# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.gpu_volume_ray_cast_mapper import GPUVolumeRayCastMapper


class OpenGLGPUVolumeRayCastMapper(GPUVolumeRayCastMapper):
    """
    OpenGLGPUVolumeRayCastMapper - open_gl implementation of volume
    rendering through ray-casting.
    
    Superclass: GPUVolumeRayCastMapper
    
    @section multi Multiple Inputs
    
    * When multiple inputs are rendered simultaneously, it is possible to
    * composite overlapping areas correctly. Inputs are connected
      directly to
    * the mapper and their parameters (transfer functions,
      transformations, etc.)
    * are specified through standard Volume instances. These Volume
    * instances are to be registered in a special Prop3D,
      MultiVolume.
    *
    * Structures related to a particular active input are stored in a
      helper
    * class (vtk_volume_input_helper) and helper structures are kept in a
    * port-referenced map (_volume_input_map). The order of the inputs in
      the
    * map is important as it defines the order in which parameters are
    * bound to uniform variables (transformation matrices, bias, scale
      and every
    * other required rendering parameter).
    *
    * A separate code path is used when rendering multiple-inputs in
      order to
    * facilitate the co-existance of these two modes (single/multiple),
      due to
    * current feature incompatibilities with multiple inputs (e.g.
      texture-streaming,
    * cropping, etc.).
    *
    *
    
    ote A limited set of the mapper features are currently supported for
    * multiple inputs:
    *
    * - Blending
    *   - Composite (front-to-back)
    *
    * - Transfer functions (defined separately for per input)
    *   - 1d color
    *   - 1d scalar opacity
    *   - 1d gradient magnitude opacity
    *   - 2d scalar-gradient magnitude
    *
    * - Point and cell data
    *   - With the limitation that all of the inputs are assumed to share
    the same
    *     name/id.
    *
    * @sa GPUVolumeRayCastMapper VolumeInputHelper VolumeTexture
    * MultiVolume
    *
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLGPUVolumeRayCastMapper, obj, update, **traits)
    
    fragment_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Allow the program to set the shader codes used directly instead
        of using the built in templates. Be aware, if set, this template
        will be used for all cases, primitive types, picking etc.
        """
    )

    def _fragment_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFragmentShaderCode,
                        self.fragment_shader_code)

    vertex_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Allow the program to set the shader codes used directly instead
        of using the built in templates. Be aware, if set, this template
        will be used for all cases, primitive types, picking etc.
        """
    )

    def _vertex_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexShaderCode,
                        self.vertex_shader_code)

    def _get_color_texture(self):
        return wrap_vtk(self._vtk_obj.GetColorTexture())
    color_texture = traits.Property(_get_color_texture, desc=\
        """
        Low level API to enable access to color texture in
        render_to_texture mode. It will return either nullptr if
        render_to_image was never turned on or texture captured the last
        time render_to_image was on.
        """
    )

    def _get_current_pass(self):
        return self._vtk_obj.GetCurrentPass()
    current_pass = traits.Property(_get_current_pass, desc=\
        """
        Mapper can have multiple passes and internally it will set the
        state. The state can not be set externally explicitly but can be
        set indirectly depending on the options set by the user.
        """
    )

    def _get_depth_texture(self):
        return wrap_vtk(self._vtk_obj.GetDepthTexture())
    depth_texture = traits.Property(_get_depth_texture, desc=\
        """
        Low level API to enable access to depth texture in
        render_to_texture mode. It will return either nullptr if
        render_to_image was never turned on or texture captured the last
        time render_to_image was on.
        """
    )

    def _get_fragment_custom_uniforms(self):
        return wrap_vtk(self._vtk_obj.GetFragmentCustomUniforms())
    fragment_custom_uniforms = traits.Property(_get_fragment_custom_uniforms, desc=\
        """
        The Uniforms object allows to set custom uniform variables that
        are used in replacement shader code.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Set/Get the input data
        """
    )

    def _get_vertex_custom_uniforms(self):
        return wrap_vtk(self._vtk_obj.GetVertexCustomUniforms())
    vertex_custom_uniforms = traits.Property(_get_vertex_custom_uniforms, desc=\
        """
        The Uniforms object allows to set custom uniform variables that
        are used in replacement shader code.
        """
    )

    def add_shader_replacement(self, *args):
        """
        V.add_shader_replacement(Shader.Type, string, bool, string, bool)
        C++: void AddShaderReplacement(Shader::Type shaderType,
            const std::string &originalValue, bool replaceFirst,
            const std::string &replacementValue, bool replaceAll)
        This function enables you to apply your own substitutions to the
        shader creation process. The shader code in this class is created
        by applying a bunch of string replacements to a shader template.
        Using this function you can apply your own string replacements to
        add features you desire.
        """
        ret = self._wrap_call(self._vtk_obj.AddShaderReplacement, *args)
        return ret

    def clear_all_shader_replacements(self):
        """
        V.clear_all_shader_replacements(Shader.Type)
        C++: void ClearAllShaderReplacements(Shader::Type shaderType)
        V.clear_all_shader_replacements()
        C++: void ClearAllShaderReplacements()
        This function enables you to apply your own substitutions to the
        shader creation process. The shader code in this class is created
        by applying a bunch of string replacements to a shader template.
        Using this function you can apply your own string replacements to
        add features you desire.
        """
        ret = self._vtk_obj.ClearAllShaderReplacements()
        return ret
        

    def clear_shader_replacement(self, *args):
        """
        V.clear_shader_replacement(Shader.Type, string, bool)
        C++: void ClearShaderReplacement(Shader::Type shaderType,
            const std::string &originalValue, bool replaceFirst)
        This function enables you to apply your own substitutions to the
        shader creation process. The shader code in this class is created
        by applying a bunch of string replacements to a shader template.
        Using this function you can apply your own string replacements to
        add features you desire.
        """
        ret = self._wrap_call(self._vtk_obj.ClearShaderReplacement, *args)
        return ret

    def pre_load_data(self, *args):
        """
        V.pre_load_data(Renderer, Volume) -> bool
        C++: bool PreLoadData(Renderer *ren, Volume *vol)
        Load the volume texture into GPU memory.  Actual loading occurs
        in VolumeTexture::LoadVolume.  The mapper by default loads
        data lazily (at render time), so it is most commonly not
        necessary to call this function.  This method is only exposed in
        order to support on-site loading which is useful in cases where
        the user needs to know a-priori whether loading will succeed or
        not.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PreLoadData, *my_args)
        return ret

    def set_partitions(self, *args):
        """
        V.set_partitions(int, int, int)
        C++: void SetPartitions(unsigned short x, unsigned short y,
            unsigned short z)
        Set a fixed number of partitions in which to split the volume
        during rendring. This will force by-block rendering without
        trying to compute an optimum number of partitions.
        """
        ret = self._wrap_call(self._vtk_obj.SetPartitions, *args)
        return ret

    def set_shared_depth_texture(self, *args):
        """
        V.set_shared_depth_texture(TextureObject)
        C++: void SetSharedDepthTexture(TextureObject *nt)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSharedDepthTexture, *my_args)
        return ret

    _updateable_traits_ = \
    (('auto_adjust_sample_distances', 'GetAutoAdjustSampleDistances'),
    ('clamp_depth_to_backface', 'GetClampDepthToBackface'),
    ('lock_sample_distance_to_input_spacing',
    'GetLockSampleDistanceToInputSpacing'), ('render_to_image',
    'GetRenderToImage'), ('use_depth_pass', 'GetUseDepthPass'),
    ('use_jittering', 'GetUseJittering'), ('cropping', 'GetCropping'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('depth_image_scalar_type', 'GetDepthImageScalarType'), ('mask_type',
    'GetMaskType'), ('blend_mode', 'GetBlendMode'),
    ('cropping_region_flags', 'GetCroppingRegionFlags'), ('scalar_mode',
    'GetScalarMode'), ('fragment_shader_code', 'GetFragmentShaderCode'),
    ('vertex_shader_code', 'GetVertexShaderCode'), ('color_range_type',
    'GetColorRangeType'), ('final_color_level', 'GetFinalColorLevel'),
    ('final_color_window', 'GetFinalColorWindow'),
    ('gradient_opacity_range_type', 'GetGradientOpacityRangeType'),
    ('image_sample_distance', 'GetImageSampleDistance'),
    ('mask_blend_factor', 'GetMaskBlendFactor'), ('max_memory_fraction',
    'GetMaxMemoryFraction'), ('max_memory_in_bytes',
    'GetMaxMemoryInBytes'), ('maximum_image_sample_distance',
    'GetMaximumImageSampleDistance'), ('minimum_image_sample_distance',
    'GetMinimumImageSampleDistance'), ('report_progress',
    'GetReportProgress'), ('sample_distance', 'GetSampleDistance'),
    ('scalar_opacity_range_type', 'GetScalarOpacityRangeType'),
    ('average_ip_scalar_range', 'GetAverageIPScalarRange'),
    ('array_access_mode', 'GetArrayAccessMode'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'auto_adjust_sample_distances',
    'clamp_depth_to_backface', 'cropping', 'debug',
    'global_warning_display', 'lock_sample_distance_to_input_spacing',
    'release_data_flag', 'render_to_image', 'use_depth_pass',
    'use_jittering', 'blend_mode', 'cropping_region_flags',
    'depth_image_scalar_type', 'mask_type', 'scalar_mode',
    'array_access_mode', 'average_ip_scalar_range', 'color_range_type',
    'final_color_level', 'final_color_window', 'fragment_shader_code',
    'gradient_opacity_range_type', 'image_sample_distance',
    'mask_blend_factor', 'max_memory_fraction', 'max_memory_in_bytes',
    'maximum_image_sample_distance', 'minimum_image_sample_distance',
    'progress_text', 'report_progress', 'sample_distance',
    'scalar_opacity_range_type', 'vertex_shader_code'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLGPUVolumeRayCastMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLGPUVolumeRayCastMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['auto_adjust_sample_distances', 'clamp_depth_to_backface',
            'cropping', 'lock_sample_distance_to_input_spacing',
            'render_to_image', 'use_depth_pass', 'use_jittering'], ['blend_mode',
            'cropping_region_flags', 'depth_image_scalar_type', 'mask_type',
            'scalar_mode'], ['array_access_mode', 'average_ip_scalar_range',
            'color_range_type', 'final_color_level', 'final_color_window',
            'fragment_shader_code', 'gradient_opacity_range_type',
            'image_sample_distance', 'mask_blend_factor', 'max_memory_fraction',
            'max_memory_in_bytes', 'maximum_image_sample_distance',
            'minimum_image_sample_distance', 'report_progress', 'sample_distance',
            'scalar_opacity_range_type', 'vertex_shader_code']),
            title='Edit OpenGLGPUVolumeRayCastMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLGPUVolumeRayCastMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

