import { ICryptoStorageProvider } from "./ICryptoStorageProvider";
import { EncryptionEventContent } from "../models/events/EncryptionEvent";
import { IInboundGroupSession, IOlmSession, IOutboundGroupSession, StoredUserDevice, UserDevice } from "../models/Crypto";
/**
 * Sqlite crypto storage provider. Requires `better-sqlite3` package to be installed.
 * @category Storage providers
 */
export declare class SqliteCryptoStorageProvider implements ICryptoStorageProvider {
    private db;
    private kvUpsert;
    private kvSelect;
    private roomUpsert;
    private roomSelect;
    private userUpsert;
    private userSelect;
    private userDeviceUpsert;
    private userDevicesDelete;
    private userDevicesSelect;
    private userActiveDevicesSelect;
    private userActiveDeviceSelect;
    private obGroupSessionUpsert;
    private obGroupSessionSelect;
    private obGroupCurrentSessionSelect;
    private obGroupSessionMarkAllInactive;
    private obSentGroupSessionUpsert;
    private obSentSelectLastSent;
    private olmSessionUpsert;
    private olmSessionCurrentSelect;
    private olmSessionSelect;
    private ibGroupSessionUpsert;
    private ibGroupSessionSelect;
    private deMetadataUpsert;
    private deMetadataSelect;
    /**
     * Creates a new Sqlite storage provider.
     * @param {string} path The file path to store the database at. Use ":memory:" to
     * store the database entirely in memory, or an empty string to do the equivalent
     * on the disk.
     */
    constructor(path: string);
    setDeviceId(deviceId: string): Promise<void>;
    getDeviceId(): Promise<string>;
    setPickleKey(pickleKey: string): Promise<void>;
    getPickleKey(): Promise<string>;
    setPickledAccount(pickled: string): Promise<void>;
    getPickledAccount(): Promise<string>;
    storeRoom(roomId: string, config: Partial<EncryptionEventContent>): Promise<void>;
    getRoom(roomId: string): Promise<Partial<EncryptionEventContent>>;
    setActiveUserDevices(userId: string, devices: UserDevice[]): Promise<void>;
    getActiveUserDevices(userId: string): Promise<UserDevice[]>;
    getActiveUserDevice(userId: string, deviceId: string): Promise<UserDevice>;
    getAllUserDevices(userId: string): Promise<StoredUserDevice[]>;
    flagUsersOutdated(userIds: string[]): Promise<void>;
    isUserOutdated(userId: string): Promise<boolean>;
    storeOutboundGroupSession(session: IOutboundGroupSession): Promise<void>;
    getOutboundGroupSession(sessionId: string, roomId: string): Promise<IOutboundGroupSession>;
    getCurrentOutboundGroupSession(roomId: string): Promise<IOutboundGroupSession>;
    storeSentOutboundGroupSession(session: IOutboundGroupSession, index: number, device: UserDevice): Promise<void>;
    getLastSentOutboundGroupSession(userId: string, deviceId: string, roomId: string): Promise<{
        sessionId: string;
        index: number;
    }>;
    storeOlmSession(userId: string, deviceId: string, session: IOlmSession): Promise<void>;
    getCurrentOlmSession(userId: string, deviceId: string): Promise<IOlmSession>;
    getOlmSessions(userId: string, deviceId: string): Promise<IOlmSession[]>;
    storeInboundGroupSession(session: IInboundGroupSession): Promise<void>;
    getInboundGroupSession(senderUserId: string, senderDeviceId: string, roomId: string, sessionId: string): Promise<IInboundGroupSession>;
    setMessageIndexForEvent(roomId: string, eventId: string, sessionId: string, messageIndex: number): Promise<void>;
    getEventForMessageIndex(roomId: string, sessionId: string, messageIndex: number): Promise<string>;
    /**
     * Closes the crypto store. Primarily for testing purposes.
     */
    close(): Promise<void>;
}
