"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var series_1 = require("../../utils/series");
var utils_1 = require("../utils/utils");
var compute_series_domains_1 = require("./compute_series_domains");
var get_specs_1 = require("./get_specs");
function getColorOverrides(_a) {
    var colors = _a.colors;
    return colors;
}
exports.getSeriesColorsSelector = re_reselect_1.default([get_specs_1.getSeriesSpecsSelector, compute_series_domains_1.computeSeriesDomainsSelector, get_chart_theme_1.getChartThemeSelector, getColorOverrides], function (seriesSpecs, seriesDomainsAndData, chartTheme, colorOverrides) {
    var updatedCustomSeriesColors = utils_1.getCustomSeriesColors(seriesSpecs, seriesDomainsAndData.seriesCollection);
    var seriesColorMap = series_1.getSeriesColors(seriesDomainsAndData.seriesCollection, chartTheme.colors, updatedCustomSeriesColors, colorOverrides);
    return seriesColorMap;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_series_color_map.js.map