/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IBinaryBuildTriggerable;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.build.IBinaryBuildSource;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class BinaryBuildTrigger
implements IBinaryBuildTriggerable {
    private static final String BUILDCONFIG_BINARY_SUBRESOURCE = "instantiatebinary";
    private static final String AS_FILE_PARAMETER = "asFile";
    private static final String AUTHOR_EMAIL_PARAMETER = "revision.authorEmail";
    private static final String AUTHOR_NAME_PARAMETER = "revision.authorName";
    private static final String COMMIT_PARAMETER = "revision.commit";
    private static final String COMMITTER_EMAIL_PARAMETER = "revision.committerEmail";
    private static final String COMMITTER_NAME_PARAMETER = "revision.committerName";
    private static final String MESSAGE_PARAMETER = "revision.message";
    private IResource resource;
    private IClient client;
    private final String subresource;
    private String asFile;
    private String authorEmail;
    private String authorName;
    private String commit;
    private String committerEmail;
    private String committerName;
    private String message;

    public BinaryBuildTrigger(IBuildConfig buildConfig, IClient client) {
        this.resource = buildConfig;
        this.client = client;
        this.subresource = BUILDCONFIG_BINARY_SUBRESOURCE;
    }

    @Override
    public boolean isSupported() {
        return this.resource != null && this.client != null && "BuildConfig".equals(this.resource.getKind()) && ((IBuildConfig)this.resource).getBuildSource() instanceof IBinaryBuildSource;
    }

    @Override
    public String getName() {
        return BinaryBuildTrigger.class.getSimpleName();
    }

    @Override
    public IBuild triggerBinary(InputStream payload) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.asFile)) {
            parameters.put(AS_FILE_PARAMETER, this.asFile);
        }
        if (StringUtils.isNotBlank((String)this.authorEmail)) {
            parameters.put(AUTHOR_EMAIL_PARAMETER, this.authorEmail);
        }
        if (StringUtils.isNotBlank((String)this.authorName)) {
            parameters.put(AUTHOR_NAME_PARAMETER, this.authorName);
        }
        if (StringUtils.isNotBlank((String)this.commit)) {
            parameters.put(COMMIT_PARAMETER, this.commit);
        }
        if (StringUtils.isNotBlank((String)this.committerEmail)) {
            parameters.put(COMMITTER_EMAIL_PARAMETER, this.committerEmail);
        }
        if (StringUtils.isNotBlank((String)this.committerName)) {
            parameters.put(COMMITTER_NAME_PARAMETER, this.committerName);
        }
        if (StringUtils.isNotBlank((String)this.message)) {
            parameters.put(MESSAGE_PARAMETER, this.message);
        }
        return (IBuild)this.client.create(this.resource.getKind(), this.resource.getApiVersion(), this.resource.getNamespaceName(), this.resource.getName(), this.subresource, payload, parameters);
    }

    @Override
    public void setAsFile(String asFile) {
        this.asFile = asFile;
    }

    @Override
    public String getAsFile() {
        return this.asFile;
    }

    @Override
    public void setCommit(String commit) {
        this.commit = commit;
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    @Override
    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    @Override
    public String getAuthorEmail() {
        return this.authorEmail;
    }

    @Override
    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    @Override
    public String getAuthorName() {
        return this.authorName;
    }

    @Override
    public void setCommitterEmail(String committerEmail) {
        this.committerEmail = committerEmail;
    }

    @Override
    public String getCommitterEmail() {
        return this.committerEmail;
    }

    @Override
    public void setCommitterName(String committerName) {
        this.committerName = committerName;
    }

    @Override
    public String getCommitterName() {
        return this.committerName;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

