/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public class EndpointService
implements Service<Endpoint> {
    protected final String endpointName;
    protected volatile Endpoint endpoint;
    protected final OptionMap optionMap;
    private final Consumer<Endpoint> endpointConsumer;
    private final Supplier<XnioWorker> workerSupplier;

    public EndpointService(Consumer<Endpoint> endpointConsumer, Supplier<XnioWorker> workerSupplier, String nodeName, EndpointType type, OptionMap optionMap) {
        this.endpointConsumer = endpointConsumer;
        this.workerSupplier = workerSupplier;
        if (nodeName == null) {
            nodeName = "remote";
        }
        this.endpointName = type == EndpointType.SUBSYSTEM ? nodeName : nodeName + ":" + (Object)((Object)type);
        this.optionMap = optionMap;
    }

    public void start(StartContext context) throws StartException {
        Endpoint endpoint;
        EndpointBuilder builder = Endpoint.builder();
        builder.setEndpointName(this.endpointName);
        builder.setXnioWorker(this.workerSupplier.get());
        try {
            endpoint = builder.build();
        }
        catch (IOException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotStart(e);
        }
        this.endpoint = endpoint;
        this.endpointConsumer.accept(endpoint);
    }

    public void stop(StopContext context) {
        context.asynchronous();
        this.endpointConsumer.accept(null);
        Endpoint endpoint = this.endpoint;
        this.endpoint = null;
        try {
            endpoint.closeAsync();
        }
        finally {
            endpoint.addCloseHandler((closed, exception) -> context.complete());
        }
    }

    public Endpoint getValue() throws IllegalStateException {
        Endpoint endpoint = this.endpoint;
        if (endpoint == null) {
            throw RemotingLogger.ROOT_LOGGER.endpointEmpty();
        }
        return endpoint;
    }

    public static enum EndpointType {
        MANAGEMENT,
        SUBSYSTEM;

    }
}

