/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.common.XaPool;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.validator.ValidateException;

public class ModifiableConnDef
implements ConnectionDefinition {
    private static final long serialVersionUID = -7109775624169563102L;
    private final ConcurrentHashMap<String, String> configProperties;
    private final String className;
    private final String jndiName;
    private final String poolName;
    private final Boolean enabled;
    private final Boolean useJavaContext;
    private final Boolean useCcm;
    private final Pool pool;
    private final TimeOut timeOut;
    private final Validation validation;
    private final Security security;
    private final Recovery recovery;
    private final Boolean sharable;
    private final Boolean enlistment;
    private final Boolean connectable;
    private final Boolean tracking;
    private final Boolean enlistmentTrace;
    private final String mcp;

    public ModifiableConnDef(Map<String, String> configProperties, String className, String jndiName, String poolName, Boolean enabled, Boolean useJavaContext, Boolean useCcm, Pool pool, TimeOut timeOut, Validation validation, Security security, Recovery recovery, Boolean sharable, Boolean enlistment, Boolean connectable, Boolean tracking, String mcp, Boolean enlistmentTrace) throws ValidateException {
        if (configProperties != null) {
            this.configProperties = new ConcurrentHashMap(configProperties.size());
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = new ConcurrentHashMap(0);
        }
        this.className = className;
        this.jndiName = jndiName;
        this.poolName = poolName;
        this.enabled = enabled;
        this.useJavaContext = useJavaContext;
        this.useCcm = useCcm;
        this.pool = pool;
        this.timeOut = timeOut;
        this.validation = validation;
        this.security = security;
        this.recovery = recovery;
        this.sharable = sharable;
        this.enlistment = enlistment;
        this.connectable = connectable;
        this.tracking = tracking;
        this.mcp = mcp;
        this.enlistmentTrace = enlistmentTrace;
    }

    public final Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    public String addConfigProperty(String key, String value) {
        return this.configProperties.put(key, value);
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getJndiName() {
        return this.jndiName;
    }

    public final String getPoolName() {
        return this.poolName;
    }

    public final Boolean isEnabled() {
        return this.enabled;
    }

    public final Boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    public final Boolean isUseCcm() {
        return this.useCcm;
    }

    public final Pool getPool() {
        return this.pool;
    }

    public final TimeOut getTimeOut() {
        return this.timeOut;
    }

    public final Validation getValidation() {
        return this.validation;
    }

    public final Security getSecurity() {
        return this.security;
    }

    public final Boolean isXa() {
        return this.pool instanceof XaPool;
    }

    public final Recovery getRecovery() {
        return this.recovery;
    }

    public Boolean isSharable() {
        return this.sharable;
    }

    public Boolean isEnlistment() {
        return this.enlistment;
    }

    public Boolean isConnectable() {
        return this.connectable;
    }

    public Boolean isTracking() {
        return this.tracking;
    }

    public String getMcp() {
        return this.mcp;
    }

    public Boolean isEnlistmentTrace() {
        return this.enlistmentTrace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        result = 31 * result + (this.poolName == null ? 0 : this.poolName.hashCode());
        result = 31 * result + (this.recovery == null ? 0 : this.recovery.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.timeOut == null ? 0 : this.timeOut.hashCode());
        result = 31 * result + (this.useJavaContext == null ? 0 : this.useJavaContext.hashCode());
        result = 31 * result + (this.useCcm == null ? 0 : this.useCcm.hashCode());
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        result = 31 * result + (this.isXa() == null ? 0 : this.isXa().hashCode());
        result = 31 * result + (this.sharable == null ? 0 : this.sharable.hashCode());
        result = 31 * result + (this.enlistment == null ? 0 : this.enlistment.hashCode());
        result = 31 * result + (this.connectable == null ? 0 : this.connectable.hashCode());
        result = 31 * result + (this.tracking == null ? 0 : this.tracking.hashCode());
        result = 31 * result + (this.mcp == null ? 0 : this.mcp.hashCode());
        result = 31 * result + (this.enlistmentTrace == null ? 0 : this.enlistmentTrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifiableConnDef)) {
            return false;
        }
        ModifiableConnDef other = (ModifiableConnDef)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.pool == null ? other.pool != null : !this.pool.equals(other.pool)) {
            return false;
        }
        if (this.poolName == null ? other.poolName != null : !this.poolName.equals(other.poolName)) {
            return false;
        }
        if (this.recovery == null ? other.recovery != null : !this.recovery.equals((Object)other.recovery)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.timeOut == null ? other.timeOut != null : !this.timeOut.equals(other.timeOut)) {
            return false;
        }
        if (this.useJavaContext == null ? other.useJavaContext != null : !this.useJavaContext.equals(other.useJavaContext)) {
            return false;
        }
        if (this.useCcm == null ? other.useCcm != null : !this.useCcm.equals(other.useCcm)) {
            return false;
        }
        if (this.validation == null ? other.validation != null : !this.validation.equals(other.validation)) {
            return false;
        }
        if (this.isXa() == null ? other.isXa() != null : !this.isXa().equals(other.isXa())) {
            return false;
        }
        if (this.sharable == null ? other.sharable != null : !this.sharable.equals(other.sharable)) {
            return false;
        }
        if (this.enlistment == null ? other.enlistment != null : !this.enlistment.equals(other.enlistment)) {
            return false;
        }
        if (this.connectable == null ? other.connectable != null : !this.connectable.equals(other.connectable)) {
            return false;
        }
        if (this.tracking == null ? other.tracking != null : !this.tracking.equals(other.tracking)) {
            return false;
        }
        if (this.mcp == null ? other.mcp != null : !this.mcp.equals(other.mcp)) {
            return false;
        }
        return !(this.enlistmentTrace == null ? other.enlistmentTrace != null : !this.enlistmentTrace.equals(other.enlistmentTrace));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<connection-definition");
        if (this.className != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.CLASS_NAME).append("=\"").append(this.className).append("\"");
        }
        if (this.jndiName != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        if (this.useCcm != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.USE_CCM).append("=\"").append(this.useCcm).append("\"");
        }
        if (this.sharable != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.SHARABLE).append("=\"").append(this.sharable).append("\"");
        }
        if (this.enlistment != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.ENLISTMENT).append("=\"").append(this.enlistment).append("\"");
        }
        if (this.connectable != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.CONNECTABLE).append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.TRACKING).append("=\"").append(this.tracking).append("\"");
        }
        if (this.mcp != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.MCP).append("=\"").append(this.mcp).append("\"");
        }
        if (this.enlistmentTrace != null) {
            sb.append(" ").append(ConnectionDefinition.Attribute.ENLISTMENT_TRACE).append("=\"").append(this.enlistmentTrace).append("\"");
        }
        sb.append(">");
        if (this.configProperties != null && this.configProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append(ConnectionDefinition.Tag.CONFIG_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append(ConnectionDefinition.Tag.CONFIG_PROPERTY).append(">");
            }
        }
        if (this.pool != null) {
            sb.append(this.pool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.timeOut != null) {
            sb.append(this.timeOut);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.recovery != null) {
            sb.append(this.recovery);
        }
        sb.append("</connection-definition>");
        return sb.toString();
    }
}

