#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 x509
version:              1.7.5
visibility:           public
id:                   x509-1.7.5-HMu4C5aPvqAHy7ZwXFzct
key:                  x509-1.7.5-HMu4C5aPvqAHy7ZwXFzct
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             http://github.com/vincenthz/hs-certificate
synopsis:             X509 reader and writer
description:          X509 reader and writer. please see README
category:             Data
abi:                  3135a948f542d0afb1cda05dc5a5925b
exposed:              True
exposed-modules:      Data.X509 Data.X509.EC
hidden-modules:
    Data.X509.Internal Data.X509.CertificateChain
    Data.X509.AlgorithmIdentifier Data.X509.DistinguishedName
    Data.X509.Cert Data.X509.PublicKey Data.X509.PrivateKey
    Data.X509.Ext Data.X509.ExtensionRaw Data.X509.CRL Data.X509.OID
    Data.X509.Signed

import-dirs:          /usr/lib/ghc-8.10.5/site-local/x509-1.7.5
library-dirs:         /usr/lib/ghc-8.10.5/site-local/x509-1.7.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/x509-1.7.5
hs-libraries:         HSx509-1.7.5-HMu4C5aPvqAHy7ZwXFzct
depends:
    asn1-encoding-0.9.6-6RSJr1YW7043TvuzXEqv2y
    asn1-parse-0.9.5-1tbGPupoxtjEQEvi1c3ub3
    asn1-types-0.3.4-3ohXd9ivbODA8aZEAugckT base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1
    cryptonite-0.29-DOJpzHmGf631cPBYwOScHA
    hourglass-0.2.12-8RX44NEiDoQFjVz8c4QYO
    memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S mtl-2.2.2
    pem-0.2.4-DpbGikAmHCO59Nn0qGQVx1

haddock-interfaces:   /usr/share/doc/haskell-x509/html/x509.haddock
haddock-html:         /usr/share/doc/haskell-x509/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

