#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lattices
version:              2.0.2
visibility:           public
id:                   lattices-2.0.2-5QPCwrxpzNRGgtrRibDI3t
key:                  lattices-2.0.2-5QPCwrxpzNRGgtrRibDI3t
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  a6b405146bbe7ed4d055099a2a06f4fd
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Stacked
    Algebra.Lattice.Unicode Algebra.Lattice.Wide
    Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-8.10.5/site-local/lattices-2.0.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/lattices-2.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/lattices-2.0.2
hs-libraries:         HSlattices-2.0.2-5QPCwrxpzNRGgtrRibDI3t
depends:
    QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk base-4.14.2.0
    base-compat-0.11.2-Eyusxyk2CrTGloLdon9bIK containers-0.6.4.1
    deepseq-1.4.4.0 hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    integer-logarithms-1.0.3.1-BDgIIkoswVLGQoPIf73qBL
    semigroupoids-5.3.5-1MUCoMhFnfRKlT8x21E1a0
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV transformers-0.5.6.2
    universe-base-1.1.2-76XTKmPL6G0Datb31jBziY
    universe-reverse-instances-1.1.1-JTcGZesP75m4DEMuLkkld4
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

