/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.DType;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SDeclaration;
import org.objectweb.asm.Label;

public final class SCatch
extends AStatement {
    private final DType baseException;
    private final SDeclaration declaration;
    private final SBlock block;
    Label begin = null;
    Label end = null;
    Label exception = null;

    public SCatch(Location location, DType baseException, SDeclaration declaration, SBlock block) {
        super(location);
        this.baseException = Objects.requireNonNull(baseException);
        this.declaration = Objects.requireNonNull(declaration);
        this.block = block;
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.declaration.extractVariables(variables);
        if (this.block != null) {
            this.block.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.declaration.analyze(scriptRoot, locals);
        Class<?> baseType = this.baseException.resolveType(scriptRoot.getPainlessLookup()).getType();
        Class<?> type = this.declaration.variable.clazz;
        if (!baseType.isAssignableFrom(type)) {
            throw this.createError(new ClassCastException("cannot cast from [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(baseType) + "]"));
        }
        if (this.block != null) {
            this.block.lastSource = this.lastSource;
            this.block.inLoop = this.inLoop;
            this.block.lastLoop = this.lastLoop;
            this.block.analyze(scriptRoot, locals);
            this.methodEscape = this.block.methodEscape;
            this.loopEscape = this.block.loopEscape;
            this.allEscape = this.block.allEscape;
            this.anyContinue = this.block.anyContinue;
            this.anyBreak = this.block.anyBreak;
            this.statementCount = this.block.statementCount;
        }
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeStatementOffset(this.location);
        Label jump = new Label();
        methodWriter.mark(jump);
        methodWriter.visitVarInsn(MethodWriter.getType(this.declaration.variable.clazz).getOpcode(54), this.declaration.variable.getSlot());
        if (this.block != null) {
            this.block.continu = this.continu;
            this.block.brake = this.brake;
            this.block.write(classWriter, methodWriter, globals);
        }
        methodWriter.visitTryCatchBlock(this.begin, this.end, jump, MethodWriter.getType(this.declaration.variable.clazz).getInternalName());
        if (!(this.exception == null || this.block != null && this.block.allEscape)) {
            methodWriter.goTo(this.exception);
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.baseException, this.declaration, this.block);
    }
}

