#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 9
#define STATE_COUNT 2882
#define SYMBOL_COUNT 153
#define ALIAS_COUNT 2
#define TOKEN_COUNT 97
#define EXTERNAL_TOKEN_COUNT 13
#define MAX_ALIAS_SEQUENCE_LENGTH 8

enum {
  sym_heredoc_start = 1,
  sym__simple_heredoc_body = 2,
  sym__heredoc_body_beginning = 3,
  sym__heredoc_body_middle = 4,
  sym__heredoc_body_end = 5,
  sym_file_descriptor = 6,
  sym__empty_value = 7,
  sym__concat = 8,
  sym_variable_name = 9,
  sym_regex = 10,
  anon_sym_for = 11,
  anon_sym_in = 12,
  anon_sym_LPAREN_LPAREN = 13,
  anon_sym_RPAREN_RPAREN = 14,
  anon_sym_SEMI = 15,
  anon_sym_while = 16,
  anon_sym_do = 17,
  anon_sym_done = 18,
  anon_sym_if = 19,
  anon_sym_then = 20,
  anon_sym_fi = 21,
  anon_sym_elif = 22,
  anon_sym_else = 23,
  anon_sym_case = 24,
  anon_sym_esac = 25,
  anon_sym_PIPE = 26,
  anon_sym_RPAREN = 27,
  anon_sym_SEMI_SEMI = 28,
  anon_sym_function = 29,
  anon_sym_LPAREN = 30,
  anon_sym_LBRACE = 31,
  anon_sym_RBRACE = 32,
  anon_sym_PIPE_AMP = 33,
  anon_sym_AMP_AMP = 34,
  anon_sym_PIPE_PIPE = 35,
  anon_sym_BANG = 36,
  anon_sym_LBRACK = 37,
  anon_sym_RBRACK = 38,
  anon_sym_LBRACK_LBRACK = 39,
  anon_sym_RBRACK_RBRACK = 40,
  anon_sym_declare = 41,
  anon_sym_typeset = 42,
  anon_sym_export = 43,
  anon_sym_readonly = 44,
  anon_sym_local = 45,
  anon_sym_unset = 46,
  anon_sym_unsetenv = 47,
  anon_sym_EQ_TILDE = 48,
  anon_sym_EQ_EQ = 49,
  anon_sym_EQ = 50,
  anon_sym_PLUS_EQ = 51,
  anon_sym_LT = 52,
  anon_sym_GT = 53,
  anon_sym_GT_GT = 54,
  anon_sym_AMP_GT = 55,
  anon_sym_AMP_GT_GT = 56,
  anon_sym_LT_AMP = 57,
  anon_sym_GT_AMP = 58,
  anon_sym_LT_LT = 59,
  anon_sym_LT_LT_DASH = 60,
  anon_sym_LT_LT_LT = 61,
  anon_sym_BANG_EQ = 62,
  anon_sym_PLUS = 63,
  anon_sym_DASH = 64,
  anon_sym_DASH_EQ = 65,
  anon_sym_LT_EQ = 66,
  anon_sym_GT_EQ = 67,
  anon_sym_PLUS_PLUS = 68,
  anon_sym_DASH_DASH = 69,
  sym__special_characters = 70,
  anon_sym_DQUOTE = 71,
  anon_sym_DOLLAR = 72,
  sym__string_content = 73,
  sym_raw_string = 74,
  anon_sym_POUND = 75,
  anon_sym_DOLLAR_LBRACE = 76,
  anon_sym_SLASH = 77,
  anon_sym_COLON = 78,
  anon_sym_COLON_QMARK = 79,
  anon_sym_COLON_DASH = 80,
  anon_sym_PERCENT = 81,
  anon_sym_DOLLAR_LPAREN = 82,
  anon_sym_BQUOTE = 83,
  anon_sym_LT_LPAREN = 84,
  anon_sym_GT_LPAREN = 85,
  sym_comment = 86,
  aux_sym_SLASH_BSLASHw_PLUS_SLASH = 87,
  anon_sym_STAR = 88,
  anon_sym_AT = 89,
  anon_sym_QMARK = 90,
  anon_sym_0 = 91,
  anon_sym__ = 92,
  sym_word = 93,
  sym_test_operator = 94,
  anon_sym_LF = 95,
  anon_sym_AMP = 96,
  sym_program = 97,
  sym__terminated_statement = 98,
  sym_for_statement = 99,
  sym_c_style_for_statement = 100,
  sym_while_statement = 101,
  sym_do_group = 102,
  sym_if_statement = 103,
  sym_elif_clause = 104,
  sym_else_clause = 105,
  sym_case_statement = 106,
  sym_case_item = 107,
  sym_last_case_item = 108,
  sym_function_definition = 109,
  sym_compound_statement = 110,
  sym_subshell = 111,
  sym_pipeline = 112,
  sym_list = 113,
  sym_negated_command = 114,
  sym_test_command = 115,
  sym_declaration_command = 116,
  sym_unset_command = 117,
  sym_command = 118,
  sym_command_name = 119,
  sym_variable_assignment = 120,
  sym_subscript = 121,
  sym_file_redirect = 122,
  sym_heredoc_redirect = 123,
  sym_heredoc_body = 124,
  sym_herestring_redirect = 125,
  sym__expression = 126,
  sym_binary_expression = 127,
  sym_unary_expression = 128,
  sym_postfix_expression = 129,
  sym_parenthesized_expression = 130,
  sym_concatenation = 131,
  sym_string = 132,
  sym_array = 133,
  sym_simple_expansion = 134,
  sym_string_expansion = 135,
  sym_expansion = 136,
  sym_command_substitution = 137,
  sym_process_substitution = 138,
  aux_sym__statements_repeat1 = 139,
  aux_sym_for_statement_repeat1 = 140,
  aux_sym_while_statement_repeat1 = 141,
  aux_sym_if_statement_repeat1 = 142,
  aux_sym_case_statement_repeat1 = 143,
  aux_sym_case_item_repeat1 = 144,
  aux_sym_declaration_command_repeat1 = 145,
  aux_sym_unset_command_repeat1 = 146,
  aux_sym_command_repeat1 = 147,
  aux_sym_command_repeat2 = 148,
  aux_sym_heredoc_body_repeat1 = 149,
  aux_sym_concatenation_repeat1 = 150,
  aux_sym_string_repeat1 = 151,
  aux_sym_expansion_repeat1 = 152,
  alias_sym_special_variable_name = 153,
  alias_sym_word = 154,
};

static const char *ts_symbol_names[] = {
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [sym_regex] = "regex",
  [ts_builtin_sym_end] = "END",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_LPAREN_LPAREN] = "((",
  [anon_sym_RPAREN_RPAREN] = "))",
  [anon_sym_SEMI] = ";",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [sym__special_characters] = "_special_characters",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DOLLAR] = "$",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_QMARK] = ":?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = "variable_name",
  [anon_sym_STAR] = "special_variable_name",
  [anon_sym_AT] = "special_variable_name",
  [anon_sym_QMARK] = "special_variable_name",
  [anon_sym_0] = "special_variable_name",
  [anon_sym__] = "special_variable_name",
  [sym_word] = "word",
  [sym_test_operator] = "test_operator",
  [anon_sym_LF] = "\n",
  [anon_sym_AMP] = "&",
  [sym_program] = "program",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_for_statement] = "for_statement",
  [sym_c_style_for_statement] = "c_style_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_string_expansion] = "string_expansion",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym__statements_repeat1] = "_statements_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_while_statement_repeat1] = "while_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
  [alias_sym_special_variable_name] = "special_variable_name",
  [alias_sym_word] = "word",
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym__special_characters] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_c_style_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_while_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_special_variable_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_word] = {
    .visible = true,
    .named = true,
  },
};

static TSSymbol ts_alias_sequences[8][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [1] = {
    [0] = alias_sym_word,
  },
  [2] = {
    [1] = alias_sym_word,
  },
  [3] = {
    [1] = alias_sym_special_variable_name,
  },
  [4] = {
    [2] = alias_sym_word,
  },
  [5] = {
    [2] = alias_sym_special_variable_name,
  },
  [6] = {
    [3] = alias_sym_word,
  },
  [7] = {
    [4] = alias_sym_word,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '+')
        ADVANCE(22);
      if (lookahead == '-')
        ADVANCE(25);
      if (lookahead == '/')
        ADVANCE(29);
      if (lookahead == '0')
        ADVANCE(30);
      if (lookahead == ':')
        ADVANCE(31);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(36);
      if (lookahead == '=')
        ADVANCE(43);
      if (lookahead == '>')
        ADVANCE(46);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(55);
      if (lookahead == ']')
        ADVANCE(56);
      if (lookahead == '_')
        ADVANCE(58);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(60);
      if (lookahead == 'i')
        ADVANCE(64);
      if (lookahead == '{')
        ADVANCE(66);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(0);
      ADVANCE(5);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 4:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(5);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 6:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(')
        ADVANCE(9);
      if (lookahead == '{')
        ADVANCE(10);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(13);
      if (lookahead == '>')
        ADVANCE(14);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>')
        ADVANCE(15);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 16:
      if (lookahead == '\'')
        ADVANCE(17);
      if (lookahead != 0)
        ADVANCE(16);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '(')
        ADVANCE(19);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_LPAREN_LPAREN);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+')
        ADVANCE(23);
      if (lookahead == '=')
        ADVANCE(24);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-')
        ADVANCE(26);
      if (lookahead == '=')
        ADVANCE(27);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(28);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '`' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-')
        ADVANCE(32);
      if (lookahead == '?')
        ADVANCE(33);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '?' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';')
        ADVANCE(35);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '(')
        ADVANCE(38);
      if (lookahead == '<')
        ADVANCE(39);
      if (lookahead == '=')
        ADVANCE(42);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-')
        ADVANCE(40);
      if (lookahead == '<')
        ADVANCE(41);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=')
        ADVANCE(44);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == '~')
        ADVANCE(45);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '~'))
        ADVANCE(5);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(47);
      if (lookahead == '(')
        ADVANCE(48);
      if (lookahead == '=')
        ADVANCE(49);
      if (lookahead == '>')
        ADVANCE(50);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[')
        ADVANCE(54);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 55:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(0);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']')
        ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 's')
        ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'a')
        ADVANCE(62);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'c')
        ADVANCE(63);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'n')
        ADVANCE(65);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(69);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 71:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(73);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(76);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(71);
      if ((lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n')
        ADVANCE(72);
      END_STATE();
    case 73:
      if (lookahead == '>')
        ADVANCE(14);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '(')
        ADVANCE(38);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(47);
      if (lookahead == '(')
        ADVANCE(48);
      if (lookahead == '>')
        ADVANCE(50);
      END_STATE();
    case 76:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(71);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym__special_characters);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      END_STATE();
    case 78:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '+')
        ADVANCE(79);
      if (lookahead == '=')
        ADVANCE(81);
      if (lookahead == '[')
        ADVANCE(82);
      if (lookahead == '\\')
        SKIP(83);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(78);
      END_STATE();
    case 79:
      if (lookahead == '=')
        ADVANCE(80);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 83:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(78);
      END_STATE();
    case 84:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '(')
        ADVANCE(85);
      if (lookahead == '\\')
        SKIP(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(87);
      END_STATE();
    case 85:
      if (lookahead == '(')
        ADVANCE(19);
      END_STATE();
    case 86:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(84);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(87);
      END_STATE();
    case 88:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == '-')
        ADVANCE(90);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(93);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(88);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(28);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '`' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 91:
      if (lookahead == '(')
        ADVANCE(38);
      END_STATE();
    case 92:
      if (lookahead == '(')
        ADVANCE(48);
      END_STATE();
    case 93:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(88);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 94:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(73);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(95);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(94);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 95:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(94);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 96:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(73);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(97);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(96);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 97:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(96);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 98:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(100);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(13);
      END_STATE();
    case 100:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(98);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 102:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(103);
      if (lookahead == '=')
        ADVANCE(104);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(105);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(102);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '(')
        ADVANCE(38);
      if (lookahead == '<')
        ADVANCE(39);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=')
        ADVANCE(44);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == '~')
        ADVANCE(45);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '~'))
        ADVANCE(5);
      END_STATE();
    case 105:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(102);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 106:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(107);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\\')
        ADVANCE(111);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(112);
      if (lookahead != 0)
        ADVANCE(108);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(108);
      if (lookahead == '\\')
        ADVANCE(110);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\')
        ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(108);
      if (lookahead == '\\')
        ADVANCE(109);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(108);
      if (lookahead != 0)
        ADVANCE(108);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(108);
      if (lookahead == '\\')
        ADVANCE(110);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(107);
      if (lookahead != 0)
        ADVANCE(107);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(112);
      if (lookahead == '\\')
        ADVANCE(109);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(112);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(108);
      if (lookahead != 0)
        ADVANCE(108);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(107);
      if (lookahead == '\\')
        ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(112);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          lookahead != '`')
        ADVANCE(108);
      END_STATE();
    case 113:
      if (lookahead == '!')
        ADVANCE(114);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(115);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(116);
      if (lookahead == '-')
        ADVANCE(117);
      if (lookahead == '0')
        ADVANCE(118);
      if (lookahead == '?')
        ADVANCE(119);
      if (lookahead == '@')
        ADVANCE(120);
      if (lookahead == '\\')
        SKIP(121);
      if (lookahead == '_')
        ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(113);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(87);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(87);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 121:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(113);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(87);
      END_STATE();
    case 123:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(103);
      if (lookahead == '=')
        ADVANCE(104);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(124);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(123);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 124:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(123);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 125:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '\\')
        SKIP(126);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(125);
      END_STATE();
    case 126:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(125);
      END_STATE();
    case 127:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(128);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(127);
      END_STATE();
    case 128:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(127);
      END_STATE();
    case 129:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(130);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(129);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 130:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(129);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 131:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(103);
      if (lookahead == '=')
        ADVANCE(104);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(132);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(131);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(131);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 133:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(134);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(133);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 134:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(133);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 135:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(136);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == '-')
        ADVANCE(90);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(135);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 137:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(135);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 138:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(136);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(139);
      if (lookahead == 'i')
        ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(138);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(138);
      END_STATE();
    case 140:
      if (lookahead == 'n')
        ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 142:
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(145);
      if (lookahead == ')')
        ADVANCE(146);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(159);
      if (lookahead == '|')
        ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(142);
      END_STATE();
    case 143:
      if (lookahead == '=')
        ADVANCE(144);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 145:
      if (lookahead == '&')
        ADVANCE(13);
      END_STATE();
    case 146:
      if (lookahead == ')')
        ADVANCE(147);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_RPAREN_RPAREN);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+')
        ADVANCE(149);
      if (lookahead == '=')
        ADVANCE(80);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-')
        ADVANCE(151);
      if (lookahead == '=')
        ADVANCE(152);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(153);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=')
        ADVANCE(42);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '~')
        ADVANCE(157);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=')
        ADVANCE(49);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(142);
      END_STATE();
    case 160:
      if (lookahead == '|')
        ADVANCE(69);
      END_STATE();
    case 161:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == '\\')
        SKIP(162);
      if (lookahead == '{')
        ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(161);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(161);
      END_STATE();
    case 163:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(164);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 164:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(163);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 165:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(103);
      if (lookahead == '=')
        ADVANCE(104);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(166);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(165);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 166:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(165);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 167:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(168);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(167);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 168:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(167);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 169:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(170);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(171);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(169);
      END_STATE();
    case 170:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(169);
      END_STATE();
    case 171:
      if (lookahead == 's')
        ADVANCE(172);
      END_STATE();
    case 172:
      if (lookahead == 'a')
        ADVANCE(173);
      END_STATE();
    case 173:
      if (lookahead == 'c')
        ADVANCE(174);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 175:
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(145);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(176);
      if (lookahead == ']')
        ADVANCE(177);
      if (lookahead == '|')
        ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(175);
      END_STATE();
    case 176:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(175);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 178:
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(145);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(179);
      if (lookahead == ']')
        ADVANCE(180);
      if (lookahead == '|')
        ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(178);
      END_STATE();
    case 179:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(178);
      END_STATE();
    case 180:
      if (lookahead == ']')
        ADVANCE(57);
      END_STATE();
    case 181:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(115);
      if (lookahead == '*')
        ADVANCE(116);
      if (lookahead == '-')
        ADVANCE(117);
      if (lookahead == '0')
        ADVANCE(182);
      if (lookahead == '?')
        ADVANCE(119);
      if (lookahead == '@')
        ADVANCE(120);
      if (lookahead == '\\')
        ADVANCE(184);
      if (lookahead == '_')
        ADVANCE(186);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(185);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(108);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(183);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(185);
      if (lookahead == '\\')
        ADVANCE(109);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(185);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(108);
      if (lookahead != 0)
        ADVANCE(108);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '*')
        ADVANCE(116);
      if (lookahead == '-')
        ADVANCE(117);
      if (lookahead == '0')
        ADVANCE(182);
      if (lookahead == '?')
        ADVANCE(119);
      if (lookahead == '@')
        ADVANCE(120);
      if (lookahead == '\\')
        ADVANCE(184);
      if (lookahead == '_')
        ADVANCE(186);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(185);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(108);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(183);
      END_STATE();
    case 187:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(115);
      if (lookahead == '*')
        ADVANCE(116);
      if (lookahead == '-')
        ADVANCE(117);
      if (lookahead == '0')
        ADVANCE(118);
      if (lookahead == '?')
        ADVANCE(119);
      if (lookahead == '@')
        ADVANCE(120);
      if (lookahead == '\\')
        SKIP(188);
      if (lookahead == '_')
        ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(187);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(87);
      END_STATE();
    case 188:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(187);
      END_STATE();
    case 189:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '-')
        ADVANCE(190);
      if (lookahead == '/')
        ADVANCE(29);
      if (lookahead == ':')
        ADVANCE(31);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '=')
        ADVANCE(191);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(192);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(189);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 192:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(189);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 193:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(194);
      if (lookahead == '\\')
        SKIP(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{')
        ADVANCE(10);
      END_STATE();
    case 195:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(193);
      END_STATE();
    case 196:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(197);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(196);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 197:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(196);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 198:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(199);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(201);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '<')
        ADVANCE(39);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(47);
      if (lookahead == '>')
        ADVANCE(50);
      END_STATE();
    case 201:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(198);
      END_STATE();
    case 202:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(203);
      if (lookahead == ']')
        ADVANCE(177);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(202);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 203:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(202);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 204:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(205);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(204);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 205:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(204);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 206:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(207);
      if (lookahead == '|')
        ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(206);
      END_STATE();
    case 207:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(206);
      END_STATE();
    case 208:
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(145);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(209);
      if (lookahead == '|')
        ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(208);
      END_STATE();
    case 209:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(208);
      END_STATE();
    case 210:
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(145);
      if (lookahead == ')')
        ADVANCE(146);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(211);
      if (lookahead == ']')
        ADVANCE(180);
      if (lookahead == '|')
        ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(210);
      END_STATE();
    case 211:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(210);
      END_STATE();
    case 212:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(73);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(213);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(212);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 213:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(212);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 214:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(215);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(216);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      END_STATE();
    case 216:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(214);
      END_STATE();
    case 217:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(73);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(218);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(219);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(217);
      if (lookahead != 0 &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 218:
      if (lookahead == ';')
        ADVANCE(35);
      END_STATE();
    case 219:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(217);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 220:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(199);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(221);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(220);
      END_STATE();
    case 221:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(220);
      END_STATE();
    case 222:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(223);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(222);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 223:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(222);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 224:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '-')
        ADVANCE(190);
      if (lookahead == ':')
        ADVANCE(31);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '=')
        ADVANCE(191);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(225);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(224);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 225:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(224);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 226:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(199);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(227);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(226);
      END_STATE();
    case 227:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(226);
      END_STATE();
    case 228:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(199);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(229);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(171);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(228);
      END_STATE();
    case 229:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(228);
      END_STATE();
    case 230:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '+')
        ADVANCE(79);
      if (lookahead == '=')
        ADVANCE(81);
      if (lookahead == '\\')
        SKIP(231);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(230);
      END_STATE();
    case 231:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(230);
      END_STATE();
    case 232:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == ')')
        ADVANCE(146);
      if (lookahead == '-')
        ADVANCE(90);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(233);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(232);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 233:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(232);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 234:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(235);
      if (lookahead == 'e')
        ADVANCE(171);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(234);
      END_STATE();
    case 235:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(234);
      END_STATE();
    case 236:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(136);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(237);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(236);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 237:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(236);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 238:
      if (lookahead == '!')
        ADVANCE(143);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(145);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '+')
        ADVANCE(148);
      if (lookahead == '-')
        ADVANCE(150);
      if (lookahead == '<')
        ADVANCE(154);
      if (lookahead == '=')
        ADVANCE(155);
      if (lookahead == '>')
        ADVANCE(158);
      if (lookahead == '\\')
        SKIP(239);
      if (lookahead == '|')
        ADVANCE(240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(238);
      END_STATE();
    case 239:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(238);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|')
        ADVANCE(69);
      END_STATE();
    case 241:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(242);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(60);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(241);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 242:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(241);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 243:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(215);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(244);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(171);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(243);
      END_STATE();
    case 244:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(243);
      END_STATE();
    case 245:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == ';')
        ADVANCE(246);
      if (lookahead == '\\')
        ADVANCE(247);
      if (lookahead == '{')
        ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(245);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 247:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(245);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 248:
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '\\')
        SKIP(249);
      if (lookahead == '|')
        ADVANCE(250);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(248);
      END_STATE();
    case 249:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(248);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 251:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(252);
      if (lookahead == 'e')
        ADVANCE(171);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(251);
      END_STATE();
    case 252:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(251);
      END_STATE();
    case 253:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(73);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ';')
        ADVANCE(218);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(254);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(60);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(253);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 254:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(253);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 255:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(256);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(255);
      END_STATE();
    case 256:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(255);
      END_STATE();
    case 257:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(258);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(257);
      END_STATE();
    case 258:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(257);
      END_STATE();
    case 259:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(99);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(91);
      if (lookahead == '>')
        ADVANCE(92);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(260);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(261);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 260:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(259);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 's')
        ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'a')
        ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'c')
        ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 265:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(103);
      if (lookahead == '=')
        ADVANCE(104);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(266);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(60);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(265);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 266:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(265);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 267:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(89);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(103);
      if (lookahead == '=')
        ADVANCE(104);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(268);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(60);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(267);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 268:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(267);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 269:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(74);
      if (lookahead == '>')
        ADVANCE(75);
      if (lookahead == '[')
        ADVANCE(77);
      if (lookahead == '\\')
        ADVANCE(270);
      if (lookahead == ']')
        ADVANCE(77);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(60);
      if (lookahead == '{')
        ADVANCE(77);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(269);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 270:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(269);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 271:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(199);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(272);
      if (lookahead == 'e')
        ADVANCE(171);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(271);
      END_STATE();
    case 272:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(271);
      END_STATE();
    case 273:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(72);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(215);
      if (lookahead == '>')
        ADVANCE(200);
      if (lookahead == '\\')
        SKIP(274);
      if (lookahead == 'e')
        ADVANCE(171);
      if (lookahead == '|')
        ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(273);
      END_STATE();
    case 274:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(273);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 'c')
        ADVANCE(1);
      if (lookahead == 'd')
        ADVANCE(5);
      if (lookahead == 'e')
        ADVANCE(15);
      if (lookahead == 'f')
        ADVANCE(26);
      if (lookahead == 'i')
        ADVANCE(37);
      if (lookahead == 'l')
        ADVANCE(39);
      if (lookahead == 'r')
        ADVANCE(44);
      if (lookahead == 't')
        ADVANCE(52);
      if (lookahead == 'u')
        ADVANCE(62);
      if (lookahead == 'w')
        ADVANCE(70);
      END_STATE();
    case 1:
      if (lookahead == 'a')
        ADVANCE(2);
      END_STATE();
    case 2:
      if (lookahead == 's')
        ADVANCE(3);
      END_STATE();
    case 3:
      if (lookahead == 'e')
        ADVANCE(4);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 5:
      if (lookahead == 'e')
        ADVANCE(6);
      if (lookahead == 'o')
        ADVANCE(12);
      END_STATE();
    case 6:
      if (lookahead == 'c')
        ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == 'l')
        ADVANCE(8);
      END_STATE();
    case 8:
      if (lookahead == 'a')
        ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == 'r')
        ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == 'e')
        ADVANCE(11);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'n')
        ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == 'e')
        ADVANCE(14);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 15:
      if (lookahead == 'l')
        ADVANCE(16);
      if (lookahead == 'x')
        ADVANCE(21);
      END_STATE();
    case 16:
      if (lookahead == 'i')
        ADVANCE(17);
      if (lookahead == 's')
        ADVANCE(19);
      END_STATE();
    case 17:
      if (lookahead == 'f')
        ADVANCE(18);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 19:
      if (lookahead == 'e')
        ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 21:
      if (lookahead == 'p')
        ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == 'o')
        ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == 'r')
        ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == 't')
        ADVANCE(25);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 26:
      if (lookahead == 'i')
        ADVANCE(27);
      if (lookahead == 'o')
        ADVANCE(28);
      if (lookahead == 'u')
        ADVANCE(30);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 28:
      if (lookahead == 'r')
        ADVANCE(29);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 30:
      if (lookahead == 'n')
        ADVANCE(31);
      END_STATE();
    case 31:
      if (lookahead == 'c')
        ADVANCE(32);
      END_STATE();
    case 32:
      if (lookahead == 't')
        ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == 'i')
        ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == 'o')
        ADVANCE(35);
      END_STATE();
    case 35:
      if (lookahead == 'n')
        ADVANCE(36);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 37:
      if (lookahead == 'f')
        ADVANCE(38);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 39:
      if (lookahead == 'o')
        ADVANCE(40);
      END_STATE();
    case 40:
      if (lookahead == 'c')
        ADVANCE(41);
      END_STATE();
    case 41:
      if (lookahead == 'a')
        ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == 'l')
        ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 44:
      if (lookahead == 'e')
        ADVANCE(45);
      END_STATE();
    case 45:
      if (lookahead == 'a')
        ADVANCE(46);
      END_STATE();
    case 46:
      if (lookahead == 'd')
        ADVANCE(47);
      END_STATE();
    case 47:
      if (lookahead == 'o')
        ADVANCE(48);
      END_STATE();
    case 48:
      if (lookahead == 'n')
        ADVANCE(49);
      END_STATE();
    case 49:
      if (lookahead == 'l')
        ADVANCE(50);
      END_STATE();
    case 50:
      if (lookahead == 'y')
        ADVANCE(51);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 52:
      if (lookahead == 'h')
        ADVANCE(53);
      if (lookahead == 'y')
        ADVANCE(56);
      END_STATE();
    case 53:
      if (lookahead == 'e')
        ADVANCE(54);
      END_STATE();
    case 54:
      if (lookahead == 'n')
        ADVANCE(55);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 56:
      if (lookahead == 'p')
        ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == 'e')
        ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == 's')
        ADVANCE(59);
      END_STATE();
    case 59:
      if (lookahead == 'e')
        ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == 't')
        ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_typeset);
      END_STATE();
    case 62:
      if (lookahead == 'n')
        ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == 's')
        ADVANCE(64);
      END_STATE();
    case 64:
      if (lookahead == 'e')
        ADVANCE(65);
      END_STATE();
    case 65:
      if (lookahead == 't')
        ADVANCE(66);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e')
        ADVANCE(67);
      END_STATE();
    case 67:
      if (lookahead == 'n')
        ADVANCE(68);
      END_STATE();
    case 68:
      if (lookahead == 'v')
        ADVANCE(69);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      END_STATE();
    case 70:
      if (lookahead == 'h')
        ADVANCE(71);
      END_STATE();
    case 71:
      if (lookahead == 'i')
        ADVANCE(72);
      END_STATE();
    case 72:
      if (lookahead == 'l')
        ADVANCE(73);
      END_STATE();
    case 73:
      if (lookahead == 'e')
        ADVANCE(74);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 71, .external_lex_state = 2},
  [2] = {.lex_state = 71},
  [3] = {.lex_state = 78},
  [4] = {.lex_state = 84},
  [5] = {.lex_state = 88},
  [6] = {.lex_state = 71, .external_lex_state = 2},
  [7] = {.lex_state = 71, .external_lex_state = 2},
  [8] = {.lex_state = 94},
  [9] = {.lex_state = 94},
  [10] = {.lex_state = 71, .external_lex_state = 2},
  [11] = {.lex_state = 96, .external_lex_state = 2},
  [12] = {.lex_state = 88},
  [13] = {.lex_state = 88},
  [14] = {.lex_state = 98, .external_lex_state = 3},
  [15] = {.lex_state = 98, .external_lex_state = 4},
  [16] = {.lex_state = 94},
  [17] = {.lex_state = 102, .external_lex_state = 5},
  [18] = {.lex_state = 106},
  [19] = {.lex_state = 113},
  [20] = {.lex_state = 102, .external_lex_state = 5},
  [21] = {.lex_state = 113, .external_lex_state = 6},
  [22] = {.lex_state = 71, .external_lex_state = 2},
  [23] = {.lex_state = 71, .external_lex_state = 2},
  [24] = {.lex_state = 71, .external_lex_state = 2},
  [25] = {.lex_state = 123, .external_lex_state = 5},
  [26] = {.lex_state = 125},
  [27] = {.lex_state = 127, .external_lex_state = 4},
  [28] = {.lex_state = 102, .external_lex_state = 7},
  [29] = {.lex_state = 129, .external_lex_state = 8},
  [30] = {.lex_state = 78},
  [31] = {.lex_state = 131, .external_lex_state = 7},
  [32] = {.lex_state = 71, .external_lex_state = 2},
  [33] = {.lex_state = 94, .external_lex_state = 2},
  [34] = {.lex_state = 94},
  [35] = {.lex_state = 94},
  [36] = {.lex_state = 133, .external_lex_state = 9},
  [37] = {.lex_state = 135, .external_lex_state = 4},
  [38] = {.lex_state = 138, .external_lex_state = 4},
  [39] = {.lex_state = 88},
  [40] = {.lex_state = 88},
  [41] = {.lex_state = 142, .external_lex_state = 10},
  [42] = {.lex_state = 106},
  [43] = {.lex_state = 113},
  [44] = {.lex_state = 142, .external_lex_state = 10},
  [45] = {.lex_state = 113, .external_lex_state = 6},
  [46] = {.lex_state = 71, .external_lex_state = 2},
  [47] = {.lex_state = 71, .external_lex_state = 2},
  [48] = {.lex_state = 71, .external_lex_state = 2},
  [49] = {.lex_state = 142},
  [50] = {.lex_state = 78},
  [51] = {.lex_state = 88},
  [52] = {.lex_state = 71, .external_lex_state = 2},
  [53] = {.lex_state = 94},
  [54] = {.lex_state = 96, .external_lex_state = 2},
  [55] = {.lex_state = 88},
  [56] = {.lex_state = 88},
  [57] = {.lex_state = 98, .external_lex_state = 3},
  [58] = {.lex_state = 98, .external_lex_state = 4},
  [59] = {.lex_state = 102, .external_lex_state = 5},
  [60] = {.lex_state = 102, .external_lex_state = 5},
  [61] = {.lex_state = 123, .external_lex_state = 5},
  [62] = {.lex_state = 94},
  [63] = {.lex_state = 98, .external_lex_state = 4},
  [64] = {.lex_state = 102, .external_lex_state = 7},
  [65] = {.lex_state = 129, .external_lex_state = 8},
  [66] = {.lex_state = 78},
  [67] = {.lex_state = 94, .external_lex_state = 2},
  [68] = {.lex_state = 94},
  [69] = {.lex_state = 138, .external_lex_state = 11},
  [70] = {.lex_state = 106},
  [71] = {.lex_state = 113},
  [72] = {.lex_state = 138, .external_lex_state = 11},
  [73] = {.lex_state = 113, .external_lex_state = 6},
  [74] = {.lex_state = 71, .external_lex_state = 2},
  [75] = {.lex_state = 71, .external_lex_state = 2},
  [76] = {.lex_state = 71, .external_lex_state = 2},
  [77] = {.lex_state = 138, .external_lex_state = 4},
  [78] = {.lex_state = 161},
  [79] = {.lex_state = 78},
  [80] = {.lex_state = 88},
  [81] = {.lex_state = 71, .external_lex_state = 2},
  [82] = {.lex_state = 94},
  [83] = {.lex_state = 96, .external_lex_state = 2},
  [84] = {.lex_state = 88},
  [85] = {.lex_state = 88},
  [86] = {.lex_state = 163, .external_lex_state = 3},
  [87] = {.lex_state = 163, .external_lex_state = 4},
  [88] = {.lex_state = 131, .external_lex_state = 5},
  [89] = {.lex_state = 131, .external_lex_state = 5},
  [90] = {.lex_state = 165, .external_lex_state = 5},
  [91] = {.lex_state = 163, .external_lex_state = 4},
  [92] = {.lex_state = 131, .external_lex_state = 7},
  [93] = {.lex_state = 167, .external_lex_state = 8},
  [94] = {.lex_state = 78},
  [95] = {.lex_state = 71, .external_lex_state = 2},
  [96] = {.lex_state = 94, .external_lex_state = 2},
  [97] = {.lex_state = 78},
  [98] = {.lex_state = 169, .external_lex_state = 4},
  [99] = {.lex_state = 78},
  [100] = {.lex_state = 88},
  [101] = {.lex_state = 88},
  [102] = {.lex_state = 175, .external_lex_state = 12},
  [103] = {.lex_state = 106},
  [104] = {.lex_state = 113},
  [105] = {.lex_state = 175, .external_lex_state = 12},
  [106] = {.lex_state = 113, .external_lex_state = 6},
  [107] = {.lex_state = 71, .external_lex_state = 2},
  [108] = {.lex_state = 71, .external_lex_state = 2},
  [109] = {.lex_state = 71, .external_lex_state = 2},
  [110] = {.lex_state = 175, .external_lex_state = 13},
  [111] = {.lex_state = 88},
  [112] = {.lex_state = 178, .external_lex_state = 10},
  [113] = {.lex_state = 178, .external_lex_state = 10},
  [114] = {.lex_state = 178},
  [115] = {.lex_state = 78},
  [116] = {.lex_state = 98, .external_lex_state = 14},
  [117] = {.lex_state = 106},
  [118] = {.lex_state = 113},
  [119] = {.lex_state = 98, .external_lex_state = 14},
  [120] = {.lex_state = 113, .external_lex_state = 6},
  [121] = {.lex_state = 71, .external_lex_state = 2},
  [122] = {.lex_state = 71, .external_lex_state = 2},
  [123] = {.lex_state = 71, .external_lex_state = 2},
  [124] = {.lex_state = 78},
  [125] = {.lex_state = 98, .external_lex_state = 3},
  [126] = {.lex_state = 98, .external_lex_state = 11},
  [127] = {.lex_state = 106},
  [128] = {.lex_state = 113},
  [129] = {.lex_state = 98, .external_lex_state = 11},
  [130] = {.lex_state = 113, .external_lex_state = 6},
  [131] = {.lex_state = 71, .external_lex_state = 2},
  [132] = {.lex_state = 71, .external_lex_state = 2},
  [133] = {.lex_state = 71, .external_lex_state = 2},
  [134] = {.lex_state = 98, .external_lex_state = 4},
  [135] = {.lex_state = 94, .external_lex_state = 15},
  [136] = {.lex_state = 106},
  [137] = {.lex_state = 113},
  [138] = {.lex_state = 94, .external_lex_state = 15},
  [139] = {.lex_state = 113, .external_lex_state = 6},
  [140] = {.lex_state = 71, .external_lex_state = 2},
  [141] = {.lex_state = 71, .external_lex_state = 2},
  [142] = {.lex_state = 71, .external_lex_state = 2},
  [143] = {.lex_state = 94, .external_lex_state = 2},
  [144] = {.lex_state = 94},
  [145] = {.lex_state = 102, .external_lex_state = 5},
  [146] = {.lex_state = 131, .external_lex_state = 5},
  [147] = {.lex_state = 181},
  [148] = {.lex_state = 106, .external_lex_state = 10},
  [149] = {.lex_state = 113, .external_lex_state = 6},
  [150] = {.lex_state = 71, .external_lex_state = 2},
  [151] = {.lex_state = 71, .external_lex_state = 2},
  [152] = {.lex_state = 106},
  [153] = {.lex_state = 131, .external_lex_state = 5},
  [154] = {.lex_state = 131, .external_lex_state = 5},
  [155] = {.lex_state = 131, .external_lex_state = 5},
  [156] = {.lex_state = 78},
  [157] = {.lex_state = 187, .external_lex_state = 6},
  [158] = {.lex_state = 189, .external_lex_state = 16},
  [159] = {.lex_state = 189, .external_lex_state = 16},
  [160] = {.lex_state = 163, .external_lex_state = 4},
  [161] = {.lex_state = 167, .external_lex_state = 8},
  [162] = {.lex_state = 71, .external_lex_state = 2},
  [163] = {.lex_state = 88},
  [164] = {.lex_state = 71, .external_lex_state = 2},
  [165] = {.lex_state = 94},
  [166] = {.lex_state = 96, .external_lex_state = 2},
  [167] = {.lex_state = 88},
  [168] = {.lex_state = 88},
  [169] = {.lex_state = 98, .external_lex_state = 3},
  [170] = {.lex_state = 98, .external_lex_state = 4},
  [171] = {.lex_state = 123, .external_lex_state = 5},
  [172] = {.lex_state = 98, .external_lex_state = 4},
  [173] = {.lex_state = 102, .external_lex_state = 7},
  [174] = {.lex_state = 129, .external_lex_state = 8},
  [175] = {.lex_state = 71, .external_lex_state = 2},
  [176] = {.lex_state = 94, .external_lex_state = 2},
  [177] = {.lex_state = 163, .external_lex_state = 4},
  [178] = {.lex_state = 167, .external_lex_state = 8},
  [179] = {.lex_state = 71, .external_lex_state = 2},
  [180] = {.lex_state = 78},
  [181] = {.lex_state = 71, .external_lex_state = 2},
  [182] = {.lex_state = 71, .external_lex_state = 2},
  [183] = {.lex_state = 71, .external_lex_state = 2},
  [184] = {.lex_state = 169, .external_lex_state = 4},
  [185] = {.lex_state = 193, .external_lex_state = 17},
  [186] = {.lex_state = 71},
  [187] = {.lex_state = 196, .external_lex_state = 18},
  [188] = {.lex_state = 94},
  [189] = {.lex_state = 71, .external_lex_state = 19},
  [190] = {.lex_state = 94},
  [191] = {.lex_state = 102, .external_lex_state = 5},
  [192] = {.lex_state = 102, .external_lex_state = 5},
  [193] = {.lex_state = 169, .external_lex_state = 4},
  [194] = {.lex_state = 198, .external_lex_state = 7},
  [195] = {.lex_state = 102, .external_lex_state = 7},
  [196] = {.lex_state = 127, .external_lex_state = 4},
  [197] = {.lex_state = 129, .external_lex_state = 8},
  [198] = {.lex_state = 71, .external_lex_state = 2},
  [199] = {.lex_state = 102, .external_lex_state = 7},
  [200] = {.lex_state = 94, .external_lex_state = 2},
  [201] = {.lex_state = 94, .external_lex_state = 15},
  [202] = {.lex_state = 94, .external_lex_state = 15},
  [203] = {.lex_state = 94, .external_lex_state = 2},
  [204] = {.lex_state = 202, .external_lex_state = 12},
  [205] = {.lex_state = 202, .external_lex_state = 12},
  [206] = {.lex_state = 202, .external_lex_state = 12},
  [207] = {.lex_state = 167, .external_lex_state = 8},
  [208] = {.lex_state = 204},
  [209] = {.lex_state = 129, .external_lex_state = 20},
  [210] = {.lex_state = 106},
  [211] = {.lex_state = 113},
  [212] = {.lex_state = 129, .external_lex_state = 20},
  [213] = {.lex_state = 113, .external_lex_state = 6},
  [214] = {.lex_state = 71, .external_lex_state = 2},
  [215] = {.lex_state = 71, .external_lex_state = 2},
  [216] = {.lex_state = 71, .external_lex_state = 2},
  [217] = {.lex_state = 135, .external_lex_state = 4},
  [218] = {.lex_state = 88},
  [219] = {.lex_state = 88},
  [220] = {.lex_state = 206, .external_lex_state = 11},
  [221] = {.lex_state = 106},
  [222] = {.lex_state = 113},
  [223] = {.lex_state = 206, .external_lex_state = 11},
  [224] = {.lex_state = 113, .external_lex_state = 6},
  [225] = {.lex_state = 71, .external_lex_state = 2},
  [226] = {.lex_state = 71, .external_lex_state = 2},
  [227] = {.lex_state = 71, .external_lex_state = 2},
  [228] = {.lex_state = 206, .external_lex_state = 4},
  [229] = {.lex_state = 94},
  [230] = {.lex_state = 94},
  [231] = {.lex_state = 88},
  [232] = {.lex_state = 88},
  [233] = {.lex_state = 208, .external_lex_state = 10},
  [234] = {.lex_state = 106},
  [235] = {.lex_state = 113},
  [236] = {.lex_state = 208, .external_lex_state = 10},
  [237] = {.lex_state = 113, .external_lex_state = 6},
  [238] = {.lex_state = 71, .external_lex_state = 2},
  [239] = {.lex_state = 71, .external_lex_state = 2},
  [240] = {.lex_state = 71, .external_lex_state = 2},
  [241] = {.lex_state = 208},
  [242] = {.lex_state = 142},
  [243] = {.lex_state = 94},
  [244] = {.lex_state = 142, .external_lex_state = 10},
  [245] = {.lex_state = 210, .external_lex_state = 10},
  [246] = {.lex_state = 181},
  [247] = {.lex_state = 106},
  [248] = {.lex_state = 210, .external_lex_state = 10},
  [249] = {.lex_state = 210, .external_lex_state = 10},
  [250] = {.lex_state = 210, .external_lex_state = 10},
  [251] = {.lex_state = 78},
  [252] = {.lex_state = 187, .external_lex_state = 6},
  [253] = {.lex_state = 189, .external_lex_state = 16},
  [254] = {.lex_state = 189, .external_lex_state = 16},
  [255] = {.lex_state = 163, .external_lex_state = 4},
  [256] = {.lex_state = 167, .external_lex_state = 8},
  [257] = {.lex_state = 71, .external_lex_state = 2},
  [258] = {.lex_state = 98, .external_lex_state = 4},
  [259] = {.lex_state = 129, .external_lex_state = 8},
  [260] = {.lex_state = 71, .external_lex_state = 2},
  [261] = {.lex_state = 163, .external_lex_state = 4},
  [262] = {.lex_state = 167, .external_lex_state = 8},
  [263] = {.lex_state = 71, .external_lex_state = 2},
  [264] = {.lex_state = 198, .external_lex_state = 21},
  [265] = {.lex_state = 88},
  [266] = {.lex_state = 88, .external_lex_state = 18},
  [267] = {.lex_state = 210},
  [268] = {.lex_state = 133, .external_lex_state = 9},
  [269] = {.lex_state = 142},
  [270] = {.lex_state = 94},
  [271] = {.lex_state = 161},
  [272] = {.lex_state = 175, .external_lex_state = 13},
  [273] = {.lex_state = 178},
  [274] = {.lex_state = 78},
  [275] = {.lex_state = 98, .external_lex_state = 14},
  [276] = {.lex_state = 98, .external_lex_state = 14},
  [277] = {.lex_state = 78},
  [278] = {.lex_state = 98, .external_lex_state = 3},
  [279] = {.lex_state = 98, .external_lex_state = 11},
  [280] = {.lex_state = 98, .external_lex_state = 11},
  [281] = {.lex_state = 98, .external_lex_state = 4},
  [282] = {.lex_state = 102, .external_lex_state = 5},
  [283] = {.lex_state = 78},
  [284] = {.lex_state = 71, .external_lex_state = 2},
  [285] = {.lex_state = 198, .external_lex_state = 7},
  [286] = {.lex_state = 94},
  [287] = {.lex_state = 71, .external_lex_state = 2},
  [288] = {.lex_state = 71, .external_lex_state = 2},
  [289] = {.lex_state = 71},
  [290] = {.lex_state = 196, .external_lex_state = 18},
  [291] = {.lex_state = 94},
  [292] = {.lex_state = 94},
  [293] = {.lex_state = 102, .external_lex_state = 5},
  [294] = {.lex_state = 102, .external_lex_state = 5},
  [295] = {.lex_state = 198, .external_lex_state = 7},
  [296] = {.lex_state = 102, .external_lex_state = 7},
  [297] = {.lex_state = 102, .external_lex_state = 7},
  [298] = {.lex_state = 71, .external_lex_state = 2},
  [299] = {.lex_state = 94},
  [300] = {.lex_state = 135, .external_lex_state = 4},
  [301] = {.lex_state = 138},
  [302] = {.lex_state = 138, .external_lex_state = 11},
  [303] = {.lex_state = 138, .external_lex_state = 11},
  [304] = {.lex_state = 181},
  [305] = {.lex_state = 106},
  [306] = {.lex_state = 138, .external_lex_state = 11},
  [307] = {.lex_state = 138, .external_lex_state = 11},
  [308] = {.lex_state = 138, .external_lex_state = 11},
  [309] = {.lex_state = 135, .external_lex_state = 4},
  [310] = {.lex_state = 138},
  [311] = {.lex_state = 78},
  [312] = {.lex_state = 187, .external_lex_state = 6},
  [313] = {.lex_state = 189, .external_lex_state = 16},
  [314] = {.lex_state = 189, .external_lex_state = 16},
  [315] = {.lex_state = 163, .external_lex_state = 4},
  [316] = {.lex_state = 167, .external_lex_state = 8},
  [317] = {.lex_state = 71, .external_lex_state = 2},
  [318] = {.lex_state = 98, .external_lex_state = 4},
  [319] = {.lex_state = 129, .external_lex_state = 8},
  [320] = {.lex_state = 71, .external_lex_state = 2},
  [321] = {.lex_state = 163, .external_lex_state = 4},
  [322] = {.lex_state = 167, .external_lex_state = 8},
  [323] = {.lex_state = 71, .external_lex_state = 2},
  [324] = {.lex_state = 78},
  [325] = {.lex_state = 212, .external_lex_state = 22},
  [326] = {.lex_state = 214, .external_lex_state = 21},
  [327] = {.lex_state = 133, .external_lex_state = 9},
  [328] = {.lex_state = 142},
  [329] = {.lex_state = 94},
  [330] = {.lex_state = 161},
  [331] = {.lex_state = 175, .external_lex_state = 13},
  [332] = {.lex_state = 178},
  [333] = {.lex_state = 78},
  [334] = {.lex_state = 163, .external_lex_state = 14},
  [335] = {.lex_state = 163, .external_lex_state = 14},
  [336] = {.lex_state = 78},
  [337] = {.lex_state = 163, .external_lex_state = 3},
  [338] = {.lex_state = 163, .external_lex_state = 11},
  [339] = {.lex_state = 163, .external_lex_state = 11},
  [340] = {.lex_state = 163, .external_lex_state = 4},
  [341] = {.lex_state = 131, .external_lex_state = 5},
  [342] = {.lex_state = 78},
  [343] = {.lex_state = 217, .external_lex_state = 2},
  [344] = {.lex_state = 71, .external_lex_state = 2},
  [345] = {.lex_state = 169, .external_lex_state = 4},
  [346] = {.lex_state = 71, .external_lex_state = 2},
  [347] = {.lex_state = 71},
  [348] = {.lex_state = 196, .external_lex_state = 18},
  [349] = {.lex_state = 94},
  [350] = {.lex_state = 94},
  [351] = {.lex_state = 131, .external_lex_state = 5},
  [352] = {.lex_state = 131, .external_lex_state = 5},
  [353] = {.lex_state = 220, .external_lex_state = 7},
  [354] = {.lex_state = 131, .external_lex_state = 7},
  [355] = {.lex_state = 163, .external_lex_state = 4},
  [356] = {.lex_state = 167, .external_lex_state = 8},
  [357] = {.lex_state = 131, .external_lex_state = 7},
  [358] = {.lex_state = 133, .external_lex_state = 9},
  [359] = {.lex_state = 208},
  [360] = {.lex_state = 175, .external_lex_state = 13},
  [361] = {.lex_state = 94},
  [362] = {.lex_state = 175, .external_lex_state = 12},
  [363] = {.lex_state = 175, .external_lex_state = 12},
  [364] = {.lex_state = 181},
  [365] = {.lex_state = 106},
  [366] = {.lex_state = 175, .external_lex_state = 12},
  [367] = {.lex_state = 175, .external_lex_state = 12},
  [368] = {.lex_state = 175, .external_lex_state = 12},
  [369] = {.lex_state = 78},
  [370] = {.lex_state = 187, .external_lex_state = 6},
  [371] = {.lex_state = 189, .external_lex_state = 16},
  [372] = {.lex_state = 189, .external_lex_state = 16},
  [373] = {.lex_state = 163, .external_lex_state = 4},
  [374] = {.lex_state = 167, .external_lex_state = 8},
  [375] = {.lex_state = 71, .external_lex_state = 2},
  [376] = {.lex_state = 98, .external_lex_state = 4},
  [377] = {.lex_state = 129, .external_lex_state = 8},
  [378] = {.lex_state = 71, .external_lex_state = 2},
  [379] = {.lex_state = 163, .external_lex_state = 4},
  [380] = {.lex_state = 167, .external_lex_state = 8},
  [381] = {.lex_state = 71, .external_lex_state = 2},
  [382] = {.lex_state = 88},
  [383] = {.lex_state = 88, .external_lex_state = 18},
  [384] = {.lex_state = 175, .external_lex_state = 13},
  [385] = {.lex_state = 178},
  [386] = {.lex_state = 178, .external_lex_state = 10},
  [387] = {.lex_state = 88},
  [388] = {.lex_state = 88, .external_lex_state = 18},
  [389] = {.lex_state = 133, .external_lex_state = 9},
  [390] = {.lex_state = 94},
  [391] = {.lex_state = 98, .external_lex_state = 14},
  [392] = {.lex_state = 163, .external_lex_state = 14},
  [393] = {.lex_state = 181},
  [394] = {.lex_state = 106},
  [395] = {.lex_state = 163, .external_lex_state = 14},
  [396] = {.lex_state = 163, .external_lex_state = 14},
  [397] = {.lex_state = 163, .external_lex_state = 14},
  [398] = {.lex_state = 78},
  [399] = {.lex_state = 187, .external_lex_state = 6},
  [400] = {.lex_state = 189, .external_lex_state = 16},
  [401] = {.lex_state = 189, .external_lex_state = 16},
  [402] = {.lex_state = 163, .external_lex_state = 4},
  [403] = {.lex_state = 167, .external_lex_state = 8},
  [404] = {.lex_state = 71, .external_lex_state = 2},
  [405] = {.lex_state = 98, .external_lex_state = 4},
  [406] = {.lex_state = 129, .external_lex_state = 8},
  [407] = {.lex_state = 71, .external_lex_state = 2},
  [408] = {.lex_state = 163, .external_lex_state = 4},
  [409] = {.lex_state = 167, .external_lex_state = 8},
  [410] = {.lex_state = 71, .external_lex_state = 2},
  [411] = {.lex_state = 98, .external_lex_state = 3},
  [412] = {.lex_state = 94},
  [413] = {.lex_state = 98, .external_lex_state = 11},
  [414] = {.lex_state = 163, .external_lex_state = 11},
  [415] = {.lex_state = 181},
  [416] = {.lex_state = 106},
  [417] = {.lex_state = 163, .external_lex_state = 11},
  [418] = {.lex_state = 163, .external_lex_state = 11},
  [419] = {.lex_state = 163, .external_lex_state = 11},
  [420] = {.lex_state = 78},
  [421] = {.lex_state = 187, .external_lex_state = 6},
  [422] = {.lex_state = 189, .external_lex_state = 16},
  [423] = {.lex_state = 189, .external_lex_state = 16},
  [424] = {.lex_state = 163, .external_lex_state = 4},
  [425] = {.lex_state = 167, .external_lex_state = 8},
  [426] = {.lex_state = 71, .external_lex_state = 2},
  [427] = {.lex_state = 98, .external_lex_state = 4},
  [428] = {.lex_state = 129, .external_lex_state = 8},
  [429] = {.lex_state = 71, .external_lex_state = 2},
  [430] = {.lex_state = 163, .external_lex_state = 4},
  [431] = {.lex_state = 167, .external_lex_state = 8},
  [432] = {.lex_state = 71, .external_lex_state = 2},
  [433] = {.lex_state = 98, .external_lex_state = 4},
  [434] = {.lex_state = 94},
  [435] = {.lex_state = 94, .external_lex_state = 15},
  [436] = {.lex_state = 94, .external_lex_state = 15},
  [437] = {.lex_state = 181},
  [438] = {.lex_state = 106},
  [439] = {.lex_state = 94, .external_lex_state = 15},
  [440] = {.lex_state = 94, .external_lex_state = 15},
  [441] = {.lex_state = 94, .external_lex_state = 15},
  [442] = {.lex_state = 78},
  [443] = {.lex_state = 187, .external_lex_state = 6},
  [444] = {.lex_state = 189, .external_lex_state = 16},
  [445] = {.lex_state = 189, .external_lex_state = 16},
  [446] = {.lex_state = 163, .external_lex_state = 4},
  [447] = {.lex_state = 167, .external_lex_state = 8},
  [448] = {.lex_state = 71, .external_lex_state = 2},
  [449] = {.lex_state = 98, .external_lex_state = 4},
  [450] = {.lex_state = 129, .external_lex_state = 8},
  [451] = {.lex_state = 71, .external_lex_state = 2},
  [452] = {.lex_state = 163, .external_lex_state = 4},
  [453] = {.lex_state = 167, .external_lex_state = 8},
  [454] = {.lex_state = 71, .external_lex_state = 2},
  [455] = {.lex_state = 131, .external_lex_state = 5},
  [456] = {.lex_state = 102, .external_lex_state = 5},
  [457] = {.lex_state = 106, .external_lex_state = 10},
  [458] = {.lex_state = 131, .external_lex_state = 5},
  [459] = {.lex_state = 106, .external_lex_state = 10},
  [460] = {.lex_state = 106, .external_lex_state = 10},
  [461] = {.lex_state = 106},
  [462] = {.lex_state = 78},
  [463] = {.lex_state = 187, .external_lex_state = 6},
  [464] = {.lex_state = 189, .external_lex_state = 16},
  [465] = {.lex_state = 189, .external_lex_state = 16},
  [466] = {.lex_state = 163, .external_lex_state = 4},
  [467] = {.lex_state = 167, .external_lex_state = 8},
  [468] = {.lex_state = 71, .external_lex_state = 2},
  [469] = {.lex_state = 98, .external_lex_state = 4},
  [470] = {.lex_state = 129, .external_lex_state = 8},
  [471] = {.lex_state = 71, .external_lex_state = 2},
  [472] = {.lex_state = 181},
  [473] = {.lex_state = 106},
  [474] = {.lex_state = 94},
  [475] = {.lex_state = 222, .external_lex_state = 16},
  [476] = {.lex_state = 78},
  [477] = {.lex_state = 189, .external_lex_state = 16},
  [478] = {.lex_state = 189, .external_lex_state = 16},
  [479] = {.lex_state = 131, .external_lex_state = 5},
  [480] = {.lex_state = 224, .external_lex_state = 23},
  [481] = {.lex_state = 106},
  [482] = {.lex_state = 113},
  [483] = {.lex_state = 224, .external_lex_state = 23},
  [484] = {.lex_state = 113, .external_lex_state = 6},
  [485] = {.lex_state = 224, .external_lex_state = 24},
  [486] = {.lex_state = 71, .external_lex_state = 2},
  [487] = {.lex_state = 71, .external_lex_state = 2},
  [488] = {.lex_state = 71, .external_lex_state = 2},
  [489] = {.lex_state = 224, .external_lex_state = 16},
  [490] = {.lex_state = 131, .external_lex_state = 5},
  [491] = {.lex_state = 224, .external_lex_state = 24},
  [492] = {.lex_state = 224, .external_lex_state = 16},
  [493] = {.lex_state = 217, .external_lex_state = 2},
  [494] = {.lex_state = 131, .external_lex_state = 5},
  [495] = {.lex_state = 163, .external_lex_state = 4},
  [496] = {.lex_state = 167, .external_lex_state = 8},
  [497] = {.lex_state = 142},
  [498] = {.lex_state = 94},
  [499] = {.lex_state = 161},
  [500] = {.lex_state = 175, .external_lex_state = 13},
  [501] = {.lex_state = 178},
  [502] = {.lex_state = 98, .external_lex_state = 3},
  [503] = {.lex_state = 98, .external_lex_state = 4},
  [504] = {.lex_state = 78},
  [505] = {.lex_state = 71, .external_lex_state = 2},
  [506] = {.lex_state = 71, .external_lex_state = 2},
  [507] = {.lex_state = 71, .external_lex_state = 2},
  [508] = {.lex_state = 71},
  [509] = {.lex_state = 94},
  [510] = {.lex_state = 94},
  [511] = {.lex_state = 226, .external_lex_state = 7},
  [512] = {.lex_state = 102, .external_lex_state = 7},
  [513] = {.lex_state = 98, .external_lex_state = 4},
  [514] = {.lex_state = 129, .external_lex_state = 8},
  [515] = {.lex_state = 102, .external_lex_state = 7},
  [516] = {.lex_state = 217, .external_lex_state = 2},
  [517] = {.lex_state = 131, .external_lex_state = 5},
  [518] = {.lex_state = 163, .external_lex_state = 4},
  [519] = {.lex_state = 167, .external_lex_state = 8},
  [520] = {.lex_state = 161},
  [521] = {.lex_state = 169, .external_lex_state = 4},
  [522] = {.lex_state = 167, .external_lex_state = 8},
  [523] = {.lex_state = 127, .external_lex_state = 4},
  [524] = {.lex_state = 129, .external_lex_state = 8},
  [525] = {.lex_state = 169, .external_lex_state = 4},
  [526] = {.lex_state = 113},
  [527] = {.lex_state = 113, .external_lex_state = 6},
  [528] = {.lex_state = 193, .external_lex_state = 17},
  [529] = {.lex_state = 94},
  [530] = {.lex_state = 131, .external_lex_state = 7},
  [531] = {.lex_state = 102, .external_lex_state = 5},
  [532] = {.lex_state = 102, .external_lex_state = 5},
  [533] = {.lex_state = 198, .external_lex_state = 5},
  [534] = {.lex_state = 198, .external_lex_state = 5},
  [535] = {.lex_state = 228, .external_lex_state = 7},
  [536] = {.lex_state = 228, .external_lex_state = 7},
  [537] = {.lex_state = 198, .external_lex_state = 5},
  [538] = {.lex_state = 198, .external_lex_state = 5},
  [539] = {.lex_state = 228, .external_lex_state = 7},
  [540] = {.lex_state = 169, .external_lex_state = 4},
  [541] = {.lex_state = 198, .external_lex_state = 7},
  [542] = {.lex_state = 198, .external_lex_state = 7},
  [543] = {.lex_state = 102, .external_lex_state = 7},
  [544] = {.lex_state = 71, .external_lex_state = 2},
  [545] = {.lex_state = 98, .external_lex_state = 4},
  [546] = {.lex_state = 129, .external_lex_state = 8},
  [547] = {.lex_state = 102, .external_lex_state = 7},
  [548] = {.lex_state = 202, .external_lex_state = 13},
  [549] = {.lex_state = 230, .external_lex_state = 10},
  [550] = {.lex_state = 202, .external_lex_state = 12},
  [551] = {.lex_state = 202, .external_lex_state = 13},
  [552] = {.lex_state = 230, .external_lex_state = 10},
  [553] = {.lex_state = 175, .external_lex_state = 13},
  [554] = {.lex_state = 167, .external_lex_state = 8},
  [555] = {.lex_state = 204, .external_lex_state = 10},
  [556] = {.lex_state = 106},
  [557] = {.lex_state = 113},
  [558] = {.lex_state = 204, .external_lex_state = 10},
  [559] = {.lex_state = 113, .external_lex_state = 6},
  [560] = {.lex_state = 71, .external_lex_state = 2},
  [561] = {.lex_state = 71, .external_lex_state = 2},
  [562] = {.lex_state = 71, .external_lex_state = 2},
  [563] = {.lex_state = 204},
  [564] = {.lex_state = 94},
  [565] = {.lex_state = 129, .external_lex_state = 20},
  [566] = {.lex_state = 167, .external_lex_state = 20},
  [567] = {.lex_state = 181},
  [568] = {.lex_state = 106},
  [569] = {.lex_state = 167, .external_lex_state = 20},
  [570] = {.lex_state = 167, .external_lex_state = 20},
  [571] = {.lex_state = 167, .external_lex_state = 20},
  [572] = {.lex_state = 78},
  [573] = {.lex_state = 187, .external_lex_state = 6},
  [574] = {.lex_state = 189, .external_lex_state = 16},
  [575] = {.lex_state = 189, .external_lex_state = 16},
  [576] = {.lex_state = 163, .external_lex_state = 4},
  [577] = {.lex_state = 167, .external_lex_state = 8},
  [578] = {.lex_state = 71, .external_lex_state = 2},
  [579] = {.lex_state = 98, .external_lex_state = 4},
  [580] = {.lex_state = 129, .external_lex_state = 8},
  [581] = {.lex_state = 71, .external_lex_state = 2},
  [582] = {.lex_state = 163, .external_lex_state = 4},
  [583] = {.lex_state = 167, .external_lex_state = 8},
  [584] = {.lex_state = 71, .external_lex_state = 2},
  [585] = {.lex_state = 232},
  [586] = {.lex_state = 206, .external_lex_state = 4},
  [587] = {.lex_state = 208},
  [588] = {.lex_state = 206, .external_lex_state = 4},
  [589] = {.lex_state = 94},
  [590] = {.lex_state = 206, .external_lex_state = 11},
  [591] = {.lex_state = 234, .external_lex_state = 11},
  [592] = {.lex_state = 181},
  [593] = {.lex_state = 106},
  [594] = {.lex_state = 234, .external_lex_state = 11},
  [595] = {.lex_state = 234, .external_lex_state = 11},
  [596] = {.lex_state = 234, .external_lex_state = 11},
  [597] = {.lex_state = 78},
  [598] = {.lex_state = 187, .external_lex_state = 6},
  [599] = {.lex_state = 189, .external_lex_state = 16},
  [600] = {.lex_state = 189, .external_lex_state = 16},
  [601] = {.lex_state = 163, .external_lex_state = 4},
  [602] = {.lex_state = 167, .external_lex_state = 8},
  [603] = {.lex_state = 71, .external_lex_state = 2},
  [604] = {.lex_state = 98, .external_lex_state = 4},
  [605] = {.lex_state = 129, .external_lex_state = 8},
  [606] = {.lex_state = 71, .external_lex_state = 2},
  [607] = {.lex_state = 163, .external_lex_state = 4},
  [608] = {.lex_state = 167, .external_lex_state = 8},
  [609] = {.lex_state = 71, .external_lex_state = 2},
  [610] = {.lex_state = 135, .external_lex_state = 4},
  [611] = {.lex_state = 88},
  [612] = {.lex_state = 88, .external_lex_state = 18},
  [613] = {.lex_state = 206, .external_lex_state = 4},
  [614] = {.lex_state = 236, .external_lex_state = 11},
  [615] = {.lex_state = 106},
  [616] = {.lex_state = 113},
  [617] = {.lex_state = 236, .external_lex_state = 11},
  [618] = {.lex_state = 113, .external_lex_state = 6},
  [619] = {.lex_state = 71, .external_lex_state = 2},
  [620] = {.lex_state = 71, .external_lex_state = 2},
  [621] = {.lex_state = 71, .external_lex_state = 2},
  [622] = {.lex_state = 236, .external_lex_state = 4},
  [623] = {.lex_state = 71, .external_lex_state = 2},
  [624] = {.lex_state = 169, .external_lex_state = 4},
  [625] = {.lex_state = 208},
  [626] = {.lex_state = 208},
  [627] = {.lex_state = 94},
  [628] = {.lex_state = 208, .external_lex_state = 10},
  [629] = {.lex_state = 238, .external_lex_state = 10},
  [630] = {.lex_state = 181},
  [631] = {.lex_state = 106},
  [632] = {.lex_state = 238, .external_lex_state = 10},
  [633] = {.lex_state = 238, .external_lex_state = 10},
  [634] = {.lex_state = 238, .external_lex_state = 10},
  [635] = {.lex_state = 78},
  [636] = {.lex_state = 187, .external_lex_state = 6},
  [637] = {.lex_state = 189, .external_lex_state = 16},
  [638] = {.lex_state = 189, .external_lex_state = 16},
  [639] = {.lex_state = 163, .external_lex_state = 4},
  [640] = {.lex_state = 167, .external_lex_state = 8},
  [641] = {.lex_state = 71, .external_lex_state = 2},
  [642] = {.lex_state = 98, .external_lex_state = 4},
  [643] = {.lex_state = 129, .external_lex_state = 8},
  [644] = {.lex_state = 71, .external_lex_state = 2},
  [645] = {.lex_state = 163, .external_lex_state = 4},
  [646] = {.lex_state = 167, .external_lex_state = 8},
  [647] = {.lex_state = 71, .external_lex_state = 2},
  [648] = {.lex_state = 210},
  [649] = {.lex_state = 88},
  [650] = {.lex_state = 88, .external_lex_state = 18},
  [651] = {.lex_state = 208},
  [652] = {.lex_state = 210, .external_lex_state = 10},
  [653] = {.lex_state = 142, .external_lex_state = 10},
  [654] = {.lex_state = 210, .external_lex_state = 10},
  [655] = {.lex_state = 181},
  [656] = {.lex_state = 222, .external_lex_state = 16},
  [657] = {.lex_state = 78},
  [658] = {.lex_state = 189, .external_lex_state = 16},
  [659] = {.lex_state = 189, .external_lex_state = 16},
  [660] = {.lex_state = 210, .external_lex_state = 10},
  [661] = {.lex_state = 224, .external_lex_state = 24},
  [662] = {.lex_state = 224, .external_lex_state = 16},
  [663] = {.lex_state = 210, .external_lex_state = 10},
  [664] = {.lex_state = 224, .external_lex_state = 24},
  [665] = {.lex_state = 224, .external_lex_state = 16},
  [666] = {.lex_state = 217, .external_lex_state = 2},
  [667] = {.lex_state = 210, .external_lex_state = 10},
  [668] = {.lex_state = 163, .external_lex_state = 4},
  [669] = {.lex_state = 167, .external_lex_state = 8},
  [670] = {.lex_state = 71, .external_lex_state = 2},
  [671] = {.lex_state = 98, .external_lex_state = 4},
  [672] = {.lex_state = 129, .external_lex_state = 8},
  [673] = {.lex_state = 217, .external_lex_state = 2},
  [674] = {.lex_state = 210, .external_lex_state = 10},
  [675] = {.lex_state = 163, .external_lex_state = 4},
  [676] = {.lex_state = 167, .external_lex_state = 8},
  [677] = {.lex_state = 71},
  [678] = {.lex_state = 94},
  [679] = {.lex_state = 71, .external_lex_state = 19},
  [680] = {.lex_state = 94},
  [681] = {.lex_state = 198, .external_lex_state = 21},
  [682] = {.lex_state = 210},
  [683] = {.lex_state = 210},
  [684] = {.lex_state = 129, .external_lex_state = 20},
  [685] = {.lex_state = 129, .external_lex_state = 20},
  [686] = {.lex_state = 198, .external_lex_state = 21},
  [687] = {.lex_state = 198, .external_lex_state = 7},
  [688] = {.lex_state = 78},
  [689] = {.lex_state = 129, .external_lex_state = 21},
  [690] = {.lex_state = 133, .external_lex_state = 9},
  [691] = {.lex_state = 98, .external_lex_state = 14},
  [692] = {.lex_state = 98, .external_lex_state = 3},
  [693] = {.lex_state = 98, .external_lex_state = 11},
  [694] = {.lex_state = 98, .external_lex_state = 4},
  [695] = {.lex_state = 102, .external_lex_state = 5},
  [696] = {.lex_state = 161},
  [697] = {.lex_state = 228, .external_lex_state = 7},
  [698] = {.lex_state = 71, .external_lex_state = 2},
  [699] = {.lex_state = 169, .external_lex_state = 4},
  [700] = {.lex_state = 198, .external_lex_state = 7},
  [701] = {.lex_state = 98, .external_lex_state = 4},
  [702] = {.lex_state = 129, .external_lex_state = 8},
  [703] = {.lex_state = 94},
  [704] = {.lex_state = 102, .external_lex_state = 5},
  [705] = {.lex_state = 102, .external_lex_state = 5},
  [706] = {.lex_state = 198, .external_lex_state = 5},
  [707] = {.lex_state = 198, .external_lex_state = 5},
  [708] = {.lex_state = 198, .external_lex_state = 5},
  [709] = {.lex_state = 198, .external_lex_state = 5},
  [710] = {.lex_state = 198, .external_lex_state = 7},
  [711] = {.lex_state = 198, .external_lex_state = 7},
  [712] = {.lex_state = 102, .external_lex_state = 7},
  [713] = {.lex_state = 102, .external_lex_state = 7},
  [714] = {.lex_state = 169, .external_lex_state = 4},
  [715] = {.lex_state = 71, .external_lex_state = 2},
  [716] = {.lex_state = 71, .external_lex_state = 2},
  [717] = {.lex_state = 94},
  [718] = {.lex_state = 71, .external_lex_state = 2},
  [719] = {.lex_state = 94},
  [720] = {.lex_state = 138, .external_lex_state = 11},
  [721] = {.lex_state = 241},
  [722] = {.lex_state = 135, .external_lex_state = 4},
  [723] = {.lex_state = 138, .external_lex_state = 11},
  [724] = {.lex_state = 138, .external_lex_state = 11},
  [725] = {.lex_state = 181},
  [726] = {.lex_state = 241},
  [727] = {.lex_state = 135, .external_lex_state = 4},
  [728] = {.lex_state = 222, .external_lex_state = 16},
  [729] = {.lex_state = 78},
  [730] = {.lex_state = 189, .external_lex_state = 16},
  [731] = {.lex_state = 189, .external_lex_state = 16},
  [732] = {.lex_state = 138, .external_lex_state = 11},
  [733] = {.lex_state = 224, .external_lex_state = 24},
  [734] = {.lex_state = 224, .external_lex_state = 16},
  [735] = {.lex_state = 138, .external_lex_state = 11},
  [736] = {.lex_state = 224, .external_lex_state = 24},
  [737] = {.lex_state = 224, .external_lex_state = 16},
  [738] = {.lex_state = 217, .external_lex_state = 2},
  [739] = {.lex_state = 138, .external_lex_state = 11},
  [740] = {.lex_state = 163, .external_lex_state = 4},
  [741] = {.lex_state = 167, .external_lex_state = 8},
  [742] = {.lex_state = 71, .external_lex_state = 2},
  [743] = {.lex_state = 98, .external_lex_state = 4},
  [744] = {.lex_state = 129, .external_lex_state = 8},
  [745] = {.lex_state = 217, .external_lex_state = 2},
  [746] = {.lex_state = 138, .external_lex_state = 11},
  [747] = {.lex_state = 163, .external_lex_state = 4},
  [748] = {.lex_state = 167, .external_lex_state = 8},
  [749] = {.lex_state = 161},
  [750] = {.lex_state = 243, .external_lex_state = 21},
  [751] = {.lex_state = 98, .external_lex_state = 4},
  [752] = {.lex_state = 129, .external_lex_state = 8},
  [753] = {.lex_state = 212, .external_lex_state = 22},
  [754] = {.lex_state = 71},
  [755] = {.lex_state = 94},
  [756] = {.lex_state = 169, .external_lex_state = 4},
  [757] = {.lex_state = 167, .external_lex_state = 20},
  [758] = {.lex_state = 167, .external_lex_state = 20},
  [759] = {.lex_state = 220, .external_lex_state = 21},
  [760] = {.lex_state = 220, .external_lex_state = 7},
  [761] = {.lex_state = 78},
  [762] = {.lex_state = 167, .external_lex_state = 21},
  [763] = {.lex_state = 133, .external_lex_state = 9},
  [764] = {.lex_state = 163, .external_lex_state = 14},
  [765] = {.lex_state = 163, .external_lex_state = 3},
  [766] = {.lex_state = 163, .external_lex_state = 11},
  [767] = {.lex_state = 163, .external_lex_state = 4},
  [768] = {.lex_state = 131, .external_lex_state = 5},
  [769] = {.lex_state = 161},
  [770] = {.lex_state = 169, .external_lex_state = 4},
  [771] = {.lex_state = 163, .external_lex_state = 4},
  [772] = {.lex_state = 167, .external_lex_state = 8},
  [773] = {.lex_state = 94},
  [774] = {.lex_state = 131, .external_lex_state = 5},
  [775] = {.lex_state = 131, .external_lex_state = 5},
  [776] = {.lex_state = 220, .external_lex_state = 5},
  [777] = {.lex_state = 220, .external_lex_state = 5},
  [778] = {.lex_state = 220, .external_lex_state = 5},
  [779] = {.lex_state = 220, .external_lex_state = 5},
  [780] = {.lex_state = 220, .external_lex_state = 7},
  [781] = {.lex_state = 220, .external_lex_state = 7},
  [782] = {.lex_state = 131, .external_lex_state = 7},
  [783] = {.lex_state = 217, .external_lex_state = 2},
  [784] = {.lex_state = 131, .external_lex_state = 7},
  [785] = {.lex_state = 94, .external_lex_state = 2},
  [786] = {.lex_state = 204},
  [787] = {.lex_state = 94, .external_lex_state = 15},
  [788] = {.lex_state = 94, .external_lex_state = 15},
  [789] = {.lex_state = 175, .external_lex_state = 13},
  [790] = {.lex_state = 175, .external_lex_state = 12},
  [791] = {.lex_state = 175, .external_lex_state = 12},
  [792] = {.lex_state = 175, .external_lex_state = 12},
  [793] = {.lex_state = 181},
  [794] = {.lex_state = 222, .external_lex_state = 16},
  [795] = {.lex_state = 78},
  [796] = {.lex_state = 189, .external_lex_state = 16},
  [797] = {.lex_state = 189, .external_lex_state = 16},
  [798] = {.lex_state = 175, .external_lex_state = 12},
  [799] = {.lex_state = 224, .external_lex_state = 24},
  [800] = {.lex_state = 224, .external_lex_state = 16},
  [801] = {.lex_state = 175, .external_lex_state = 12},
  [802] = {.lex_state = 224, .external_lex_state = 24},
  [803] = {.lex_state = 224, .external_lex_state = 16},
  [804] = {.lex_state = 217, .external_lex_state = 2},
  [805] = {.lex_state = 175, .external_lex_state = 12},
  [806] = {.lex_state = 163, .external_lex_state = 4},
  [807] = {.lex_state = 167, .external_lex_state = 8},
  [808] = {.lex_state = 71, .external_lex_state = 2},
  [809] = {.lex_state = 98, .external_lex_state = 4},
  [810] = {.lex_state = 129, .external_lex_state = 8},
  [811] = {.lex_state = 217, .external_lex_state = 2},
  [812] = {.lex_state = 175, .external_lex_state = 12},
  [813] = {.lex_state = 163, .external_lex_state = 4},
  [814] = {.lex_state = 167, .external_lex_state = 8},
  [815] = {.lex_state = 175, .external_lex_state = 13},
  [816] = {.lex_state = 175, .external_lex_state = 13},
  [817] = {.lex_state = 178, .external_lex_state = 10},
  [818] = {.lex_state = 163, .external_lex_state = 3},
  [819] = {.lex_state = 204},
  [820] = {.lex_state = 98, .external_lex_state = 14},
  [821] = {.lex_state = 98, .external_lex_state = 14},
  [822] = {.lex_state = 163, .external_lex_state = 14},
  [823] = {.lex_state = 98, .external_lex_state = 14},
  [824] = {.lex_state = 163, .external_lex_state = 14},
  [825] = {.lex_state = 181},
  [826] = {.lex_state = 222, .external_lex_state = 16},
  [827] = {.lex_state = 78},
  [828] = {.lex_state = 189, .external_lex_state = 16},
  [829] = {.lex_state = 189, .external_lex_state = 16},
  [830] = {.lex_state = 163, .external_lex_state = 14},
  [831] = {.lex_state = 224, .external_lex_state = 24},
  [832] = {.lex_state = 224, .external_lex_state = 16},
  [833] = {.lex_state = 163, .external_lex_state = 14},
  [834] = {.lex_state = 224, .external_lex_state = 24},
  [835] = {.lex_state = 224, .external_lex_state = 16},
  [836] = {.lex_state = 217, .external_lex_state = 2},
  [837] = {.lex_state = 163, .external_lex_state = 14},
  [838] = {.lex_state = 163, .external_lex_state = 4},
  [839] = {.lex_state = 167, .external_lex_state = 8},
  [840] = {.lex_state = 71, .external_lex_state = 2},
  [841] = {.lex_state = 98, .external_lex_state = 4},
  [842] = {.lex_state = 129, .external_lex_state = 8},
  [843] = {.lex_state = 217, .external_lex_state = 2},
  [844] = {.lex_state = 163, .external_lex_state = 14},
  [845] = {.lex_state = 163, .external_lex_state = 4},
  [846] = {.lex_state = 167, .external_lex_state = 8},
  [847] = {.lex_state = 163, .external_lex_state = 11},
  [848] = {.lex_state = 98, .external_lex_state = 11},
  [849] = {.lex_state = 163, .external_lex_state = 11},
  [850] = {.lex_state = 181},
  [851] = {.lex_state = 222, .external_lex_state = 16},
  [852] = {.lex_state = 78},
  [853] = {.lex_state = 189, .external_lex_state = 16},
  [854] = {.lex_state = 189, .external_lex_state = 16},
  [855] = {.lex_state = 163, .external_lex_state = 11},
  [856] = {.lex_state = 224, .external_lex_state = 24},
  [857] = {.lex_state = 224, .external_lex_state = 16},
  [858] = {.lex_state = 163, .external_lex_state = 11},
  [859] = {.lex_state = 224, .external_lex_state = 24},
  [860] = {.lex_state = 224, .external_lex_state = 16},
  [861] = {.lex_state = 217, .external_lex_state = 2},
  [862] = {.lex_state = 163, .external_lex_state = 11},
  [863] = {.lex_state = 163, .external_lex_state = 4},
  [864] = {.lex_state = 167, .external_lex_state = 8},
  [865] = {.lex_state = 71, .external_lex_state = 2},
  [866] = {.lex_state = 98, .external_lex_state = 4},
  [867] = {.lex_state = 129, .external_lex_state = 8},
  [868] = {.lex_state = 217, .external_lex_state = 2},
  [869] = {.lex_state = 163, .external_lex_state = 11},
  [870] = {.lex_state = 163, .external_lex_state = 4},
  [871] = {.lex_state = 167, .external_lex_state = 8},
  [872] = {.lex_state = 94, .external_lex_state = 15},
  [873] = {.lex_state = 94, .external_lex_state = 15},
  [874] = {.lex_state = 94, .external_lex_state = 15},
  [875] = {.lex_state = 181},
  [876] = {.lex_state = 222, .external_lex_state = 16},
  [877] = {.lex_state = 78},
  [878] = {.lex_state = 189, .external_lex_state = 16},
  [879] = {.lex_state = 189, .external_lex_state = 16},
  [880] = {.lex_state = 94, .external_lex_state = 15},
  [881] = {.lex_state = 224, .external_lex_state = 24},
  [882] = {.lex_state = 224, .external_lex_state = 16},
  [883] = {.lex_state = 94, .external_lex_state = 15},
  [884] = {.lex_state = 224, .external_lex_state = 24},
  [885] = {.lex_state = 224, .external_lex_state = 16},
  [886] = {.lex_state = 217, .external_lex_state = 2},
  [887] = {.lex_state = 94, .external_lex_state = 15},
  [888] = {.lex_state = 163, .external_lex_state = 4},
  [889] = {.lex_state = 167, .external_lex_state = 8},
  [890] = {.lex_state = 71, .external_lex_state = 2},
  [891] = {.lex_state = 98, .external_lex_state = 4},
  [892] = {.lex_state = 129, .external_lex_state = 8},
  [893] = {.lex_state = 217, .external_lex_state = 2},
  [894] = {.lex_state = 94, .external_lex_state = 15},
  [895] = {.lex_state = 163, .external_lex_state = 4},
  [896] = {.lex_state = 167, .external_lex_state = 8},
  [897] = {.lex_state = 106},
  [898] = {.lex_state = 222, .external_lex_state = 16},
  [899] = {.lex_state = 78},
  [900] = {.lex_state = 189, .external_lex_state = 16},
  [901] = {.lex_state = 189, .external_lex_state = 16},
  [902] = {.lex_state = 106, .external_lex_state = 10},
  [903] = {.lex_state = 224, .external_lex_state = 24},
  [904] = {.lex_state = 224, .external_lex_state = 16},
  [905] = {.lex_state = 106, .external_lex_state = 10},
  [906] = {.lex_state = 224, .external_lex_state = 24},
  [907] = {.lex_state = 224, .external_lex_state = 16},
  [908] = {.lex_state = 217, .external_lex_state = 2},
  [909] = {.lex_state = 106, .external_lex_state = 10},
  [910] = {.lex_state = 163, .external_lex_state = 4},
  [911] = {.lex_state = 167, .external_lex_state = 8},
  [912] = {.lex_state = 71, .external_lex_state = 2},
  [913] = {.lex_state = 98, .external_lex_state = 4},
  [914] = {.lex_state = 129, .external_lex_state = 8},
  [915] = {.lex_state = 131, .external_lex_state = 5},
  [916] = {.lex_state = 181},
  [917] = {.lex_state = 202, .external_lex_state = 12},
  [918] = {.lex_state = 202, .external_lex_state = 12},
  [919] = {.lex_state = 202, .external_lex_state = 12},
  [920] = {.lex_state = 131, .external_lex_state = 5},
  [921] = {.lex_state = 212, .external_lex_state = 23},
  [922] = {.lex_state = 106},
  [923] = {.lex_state = 113},
  [924] = {.lex_state = 212, .external_lex_state = 23},
  [925] = {.lex_state = 113, .external_lex_state = 6},
  [926] = {.lex_state = 71, .external_lex_state = 2},
  [927] = {.lex_state = 71, .external_lex_state = 2},
  [928] = {.lex_state = 71, .external_lex_state = 2},
  [929] = {.lex_state = 212, .external_lex_state = 16},
  [930] = {.lex_state = 222, .external_lex_state = 16},
  [931] = {.lex_state = 131, .external_lex_state = 5},
  [932] = {.lex_state = 224, .external_lex_state = 24},
  [933] = {.lex_state = 224, .external_lex_state = 16},
  [934] = {.lex_state = 224, .external_lex_state = 24},
  [935] = {.lex_state = 224, .external_lex_state = 16},
  [936] = {.lex_state = 94},
  [937] = {.lex_state = 224, .external_lex_state = 23},
  [938] = {.lex_state = 224, .external_lex_state = 23},
  [939] = {.lex_state = 181},
  [940] = {.lex_state = 106},
  [941] = {.lex_state = 224, .external_lex_state = 23},
  [942] = {.lex_state = 224, .external_lex_state = 23},
  [943] = {.lex_state = 224, .external_lex_state = 23},
  [944] = {.lex_state = 78},
  [945] = {.lex_state = 187, .external_lex_state = 6},
  [946] = {.lex_state = 189, .external_lex_state = 16},
  [947] = {.lex_state = 189, .external_lex_state = 16},
  [948] = {.lex_state = 224, .external_lex_state = 16},
  [949] = {.lex_state = 131, .external_lex_state = 5},
  [950] = {.lex_state = 224, .external_lex_state = 16},
  [951] = {.lex_state = 163, .external_lex_state = 4},
  [952] = {.lex_state = 167, .external_lex_state = 8},
  [953] = {.lex_state = 71, .external_lex_state = 2},
  [954] = {.lex_state = 98, .external_lex_state = 4},
  [955] = {.lex_state = 129, .external_lex_state = 8},
  [956] = {.lex_state = 71, .external_lex_state = 2},
  [957] = {.lex_state = 163, .external_lex_state = 4},
  [958] = {.lex_state = 167, .external_lex_state = 8},
  [959] = {.lex_state = 71, .external_lex_state = 2},
  [960] = {.lex_state = 224, .external_lex_state = 16},
  [961] = {.lex_state = 224, .external_lex_state = 16},
  [962] = {.lex_state = 131, .external_lex_state = 5},
  [963] = {.lex_state = 217, .external_lex_state = 2},
  [964] = {.lex_state = 226, .external_lex_state = 21},
  [965] = {.lex_state = 226, .external_lex_state = 7},
  [966] = {.lex_state = 78},
  [967] = {.lex_state = 129, .external_lex_state = 21},
  [968] = {.lex_state = 161},
  [969] = {.lex_state = 129, .external_lex_state = 8},
  [970] = {.lex_state = 98, .external_lex_state = 4},
  [971] = {.lex_state = 129, .external_lex_state = 8},
  [972] = {.lex_state = 94},
  [973] = {.lex_state = 226, .external_lex_state = 5},
  [974] = {.lex_state = 226, .external_lex_state = 5},
  [975] = {.lex_state = 226, .external_lex_state = 5},
  [976] = {.lex_state = 226, .external_lex_state = 5},
  [977] = {.lex_state = 226, .external_lex_state = 7},
  [978] = {.lex_state = 226, .external_lex_state = 7},
  [979] = {.lex_state = 71, .external_lex_state = 2},
  [980] = {.lex_state = 102, .external_lex_state = 7},
  [981] = {.lex_state = 131, .external_lex_state = 5},
  [982] = {.lex_state = 217, .external_lex_state = 2},
  [983] = {.lex_state = 214, .external_lex_state = 21},
  [984] = {.lex_state = 193, .external_lex_state = 17},
  [985] = {.lex_state = 193, .external_lex_state = 17},
  [986] = {.lex_state = 78},
  [987] = {.lex_state = 187, .external_lex_state = 6},
  [988] = {.lex_state = 189, .external_lex_state = 16},
  [989] = {.lex_state = 189, .external_lex_state = 16},
  [990] = {.lex_state = 169, .external_lex_state = 4},
  [991] = {.lex_state = 193, .external_lex_state = 17},
  [992] = {.lex_state = 198, .external_lex_state = 5},
  [993] = {.lex_state = 198, .external_lex_state = 5},
  [994] = {.lex_state = 228, .external_lex_state = 7},
  [995] = {.lex_state = 198, .external_lex_state = 5},
  [996] = {.lex_state = 169, .external_lex_state = 4},
  [997] = {.lex_state = 217, .external_lex_state = 2},
  [998] = {.lex_state = 198, .external_lex_state = 7},
  [999] = {.lex_state = 230, .external_lex_state = 10},
  [1000] = {.lex_state = 78},
  [1001] = {.lex_state = 202, .external_lex_state = 12},
  [1002] = {.lex_state = 230, .external_lex_state = 10},
  [1003] = {.lex_state = 78},
  [1004] = {.lex_state = 94},
  [1005] = {.lex_state = 204, .external_lex_state = 10},
  [1006] = {.lex_state = 204, .external_lex_state = 10},
  [1007] = {.lex_state = 181},
  [1008] = {.lex_state = 106},
  [1009] = {.lex_state = 204, .external_lex_state = 10},
  [1010] = {.lex_state = 204, .external_lex_state = 10},
  [1011] = {.lex_state = 204, .external_lex_state = 10},
  [1012] = {.lex_state = 78},
  [1013] = {.lex_state = 187, .external_lex_state = 6},
  [1014] = {.lex_state = 189, .external_lex_state = 16},
  [1015] = {.lex_state = 189, .external_lex_state = 16},
  [1016] = {.lex_state = 163, .external_lex_state = 4},
  [1017] = {.lex_state = 167, .external_lex_state = 8},
  [1018] = {.lex_state = 71, .external_lex_state = 2},
  [1019] = {.lex_state = 98, .external_lex_state = 4},
  [1020] = {.lex_state = 129, .external_lex_state = 8},
  [1021] = {.lex_state = 71, .external_lex_state = 2},
  [1022] = {.lex_state = 163, .external_lex_state = 4},
  [1023] = {.lex_state = 167, .external_lex_state = 8},
  [1024] = {.lex_state = 71, .external_lex_state = 2},
  [1025] = {.lex_state = 167, .external_lex_state = 8},
  [1026] = {.lex_state = 204},
  [1027] = {.lex_state = 167, .external_lex_state = 20},
  [1028] = {.lex_state = 129, .external_lex_state = 20},
  [1029] = {.lex_state = 167, .external_lex_state = 20},
  [1030] = {.lex_state = 181},
  [1031] = {.lex_state = 222, .external_lex_state = 16},
  [1032] = {.lex_state = 78},
  [1033] = {.lex_state = 189, .external_lex_state = 16},
  [1034] = {.lex_state = 189, .external_lex_state = 16},
  [1035] = {.lex_state = 167, .external_lex_state = 20},
  [1036] = {.lex_state = 224, .external_lex_state = 24},
  [1037] = {.lex_state = 224, .external_lex_state = 16},
  [1038] = {.lex_state = 167, .external_lex_state = 20},
  [1039] = {.lex_state = 224, .external_lex_state = 24},
  [1040] = {.lex_state = 224, .external_lex_state = 16},
  [1041] = {.lex_state = 217, .external_lex_state = 2},
  [1042] = {.lex_state = 167, .external_lex_state = 20},
  [1043] = {.lex_state = 163, .external_lex_state = 4},
  [1044] = {.lex_state = 167, .external_lex_state = 8},
  [1045] = {.lex_state = 71, .external_lex_state = 2},
  [1046] = {.lex_state = 98, .external_lex_state = 4},
  [1047] = {.lex_state = 129, .external_lex_state = 8},
  [1048] = {.lex_state = 217, .external_lex_state = 2},
  [1049] = {.lex_state = 167, .external_lex_state = 20},
  [1050] = {.lex_state = 163, .external_lex_state = 4},
  [1051] = {.lex_state = 167, .external_lex_state = 8},
  [1052] = {.lex_state = 245},
  [1053] = {.lex_state = 142},
  [1054] = {.lex_state = 232},
  [1055] = {.lex_state = 206, .external_lex_state = 4},
  [1056] = {.lex_state = 234, .external_lex_state = 11},
  [1057] = {.lex_state = 206, .external_lex_state = 11},
  [1058] = {.lex_state = 234, .external_lex_state = 11},
  [1059] = {.lex_state = 181},
  [1060] = {.lex_state = 222, .external_lex_state = 16},
  [1061] = {.lex_state = 78},
  [1062] = {.lex_state = 189, .external_lex_state = 16},
  [1063] = {.lex_state = 189, .external_lex_state = 16},
  [1064] = {.lex_state = 234, .external_lex_state = 11},
  [1065] = {.lex_state = 224, .external_lex_state = 24},
  [1066] = {.lex_state = 224, .external_lex_state = 16},
  [1067] = {.lex_state = 234, .external_lex_state = 11},
  [1068] = {.lex_state = 224, .external_lex_state = 24},
  [1069] = {.lex_state = 224, .external_lex_state = 16},
  [1070] = {.lex_state = 217, .external_lex_state = 2},
  [1071] = {.lex_state = 234, .external_lex_state = 11},
  [1072] = {.lex_state = 163, .external_lex_state = 4},
  [1073] = {.lex_state = 167, .external_lex_state = 8},
  [1074] = {.lex_state = 71, .external_lex_state = 2},
  [1075] = {.lex_state = 98, .external_lex_state = 4},
  [1076] = {.lex_state = 129, .external_lex_state = 8},
  [1077] = {.lex_state = 217, .external_lex_state = 2},
  [1078] = {.lex_state = 234, .external_lex_state = 11},
  [1079] = {.lex_state = 163, .external_lex_state = 4},
  [1080] = {.lex_state = 167, .external_lex_state = 8},
  [1081] = {.lex_state = 206, .external_lex_state = 4},
  [1082] = {.lex_state = 206, .external_lex_state = 4},
  [1083] = {.lex_state = 206, .external_lex_state = 4},
  [1084] = {.lex_state = 94},
  [1085] = {.lex_state = 236, .external_lex_state = 11},
  [1086] = {.lex_state = 236, .external_lex_state = 11},
  [1087] = {.lex_state = 181},
  [1088] = {.lex_state = 106},
  [1089] = {.lex_state = 236, .external_lex_state = 11},
  [1090] = {.lex_state = 236, .external_lex_state = 11},
  [1091] = {.lex_state = 236, .external_lex_state = 11},
  [1092] = {.lex_state = 78},
  [1093] = {.lex_state = 187, .external_lex_state = 6},
  [1094] = {.lex_state = 189, .external_lex_state = 16},
  [1095] = {.lex_state = 189, .external_lex_state = 16},
  [1096] = {.lex_state = 163, .external_lex_state = 4},
  [1097] = {.lex_state = 167, .external_lex_state = 8},
  [1098] = {.lex_state = 71, .external_lex_state = 2},
  [1099] = {.lex_state = 98, .external_lex_state = 4},
  [1100] = {.lex_state = 129, .external_lex_state = 8},
  [1101] = {.lex_state = 71, .external_lex_state = 2},
  [1102] = {.lex_state = 163, .external_lex_state = 4},
  [1103] = {.lex_state = 167, .external_lex_state = 8},
  [1104] = {.lex_state = 71, .external_lex_state = 2},
  [1105] = {.lex_state = 94},
  [1106] = {.lex_state = 236, .external_lex_state = 4},
  [1107] = {.lex_state = 169, .external_lex_state = 4},
  [1108] = {.lex_state = 71, .external_lex_state = 2},
  [1109] = {.lex_state = 208},
  [1110] = {.lex_state = 238, .external_lex_state = 10},
  [1111] = {.lex_state = 208, .external_lex_state = 10},
  [1112] = {.lex_state = 238, .external_lex_state = 10},
  [1113] = {.lex_state = 181},
  [1114] = {.lex_state = 222, .external_lex_state = 16},
  [1115] = {.lex_state = 78},
  [1116] = {.lex_state = 189, .external_lex_state = 16},
  [1117] = {.lex_state = 189, .external_lex_state = 16},
  [1118] = {.lex_state = 238, .external_lex_state = 10},
  [1119] = {.lex_state = 224, .external_lex_state = 24},
  [1120] = {.lex_state = 224, .external_lex_state = 16},
  [1121] = {.lex_state = 238, .external_lex_state = 10},
  [1122] = {.lex_state = 224, .external_lex_state = 24},
  [1123] = {.lex_state = 224, .external_lex_state = 16},
  [1124] = {.lex_state = 217, .external_lex_state = 2},
  [1125] = {.lex_state = 238, .external_lex_state = 10},
  [1126] = {.lex_state = 163, .external_lex_state = 4},
  [1127] = {.lex_state = 167, .external_lex_state = 8},
  [1128] = {.lex_state = 71, .external_lex_state = 2},
  [1129] = {.lex_state = 98, .external_lex_state = 4},
  [1130] = {.lex_state = 129, .external_lex_state = 8},
  [1131] = {.lex_state = 217, .external_lex_state = 2},
  [1132] = {.lex_state = 238, .external_lex_state = 10},
  [1133] = {.lex_state = 163, .external_lex_state = 4},
  [1134] = {.lex_state = 167, .external_lex_state = 8},
  [1135] = {.lex_state = 208},
  [1136] = {.lex_state = 208},
  [1137] = {.lex_state = 210, .external_lex_state = 10},
  [1138] = {.lex_state = 210, .external_lex_state = 10},
  [1139] = {.lex_state = 212, .external_lex_state = 23},
  [1140] = {.lex_state = 212, .external_lex_state = 23},
  [1141] = {.lex_state = 212, .external_lex_state = 16},
  [1142] = {.lex_state = 222, .external_lex_state = 16},
  [1143] = {.lex_state = 210, .external_lex_state = 10},
  [1144] = {.lex_state = 224, .external_lex_state = 24},
  [1145] = {.lex_state = 224, .external_lex_state = 16},
  [1146] = {.lex_state = 224, .external_lex_state = 24},
  [1147] = {.lex_state = 224, .external_lex_state = 16},
  [1148] = {.lex_state = 224, .external_lex_state = 16},
  [1149] = {.lex_state = 210, .external_lex_state = 10},
  [1150] = {.lex_state = 224, .external_lex_state = 16},
  [1151] = {.lex_state = 224, .external_lex_state = 16},
  [1152] = {.lex_state = 210, .external_lex_state = 10},
  [1153] = {.lex_state = 217, .external_lex_state = 2},
  [1154] = {.lex_state = 71, .external_lex_state = 2},
  [1155] = {.lex_state = 210, .external_lex_state = 10},
  [1156] = {.lex_state = 217, .external_lex_state = 2},
  [1157] = {.lex_state = 94},
  [1158] = {.lex_state = 198, .external_lex_state = 25},
  [1159] = {.lex_state = 106},
  [1160] = {.lex_state = 113},
  [1161] = {.lex_state = 198, .external_lex_state = 25},
  [1162] = {.lex_state = 113, .external_lex_state = 6},
  [1163] = {.lex_state = 71, .external_lex_state = 2},
  [1164] = {.lex_state = 71, .external_lex_state = 2},
  [1165] = {.lex_state = 71, .external_lex_state = 2},
  [1166] = {.lex_state = 228, .external_lex_state = 21},
  [1167] = {.lex_state = 228, .external_lex_state = 21},
  [1168] = {.lex_state = 198, .external_lex_state = 25},
  [1169] = {.lex_state = 198, .external_lex_state = 25},
  [1170] = {.lex_state = 228, .external_lex_state = 21},
  [1171] = {.lex_state = 198, .external_lex_state = 21},
  [1172] = {.lex_state = 129, .external_lex_state = 20},
  [1173] = {.lex_state = 71},
  [1174] = {.lex_state = 94},
  [1175] = {.lex_state = 94},
  [1176] = {.lex_state = 198, .external_lex_state = 21},
  [1177] = {.lex_state = 198, .external_lex_state = 7},
  [1178] = {.lex_state = 161},
  [1179] = {.lex_state = 71},
  [1180] = {.lex_state = 94},
  [1181] = {.lex_state = 98, .external_lex_state = 14},
  [1182] = {.lex_state = 98, .external_lex_state = 14},
  [1183] = {.lex_state = 98, .external_lex_state = 14},
  [1184] = {.lex_state = 98, .external_lex_state = 11},
  [1185] = {.lex_state = 129, .external_lex_state = 21},
  [1186] = {.lex_state = 228, .external_lex_state = 7},
  [1187] = {.lex_state = 71, .external_lex_state = 2},
  [1188] = {.lex_state = 169, .external_lex_state = 4},
  [1189] = {.lex_state = 198, .external_lex_state = 5},
  [1190] = {.lex_state = 198, .external_lex_state = 5},
  [1191] = {.lex_state = 198, .external_lex_state = 5},
  [1192] = {.lex_state = 198, .external_lex_state = 7},
  [1193] = {.lex_state = 94},
  [1194] = {.lex_state = 71, .external_lex_state = 2},
  [1195] = {.lex_state = 169, .external_lex_state = 4},
  [1196] = {.lex_state = 94},
  [1197] = {.lex_state = 71, .external_lex_state = 2},
  [1198] = {.lex_state = 94},
  [1199] = {.lex_state = 94},
  [1200] = {.lex_state = 169, .external_lex_state = 4},
  [1201] = {.lex_state = 248, .external_lex_state = 10},
  [1202] = {.lex_state = 248, .external_lex_state = 10},
  [1203] = {.lex_state = 251},
  [1204] = {.lex_state = 248},
  [1205] = {.lex_state = 94},
  [1206] = {.lex_state = 241},
  [1207] = {.lex_state = 138, .external_lex_state = 11},
  [1208] = {.lex_state = 169, .external_lex_state = 4},
  [1209] = {.lex_state = 251},
  [1210] = {.lex_state = 94},
  [1211] = {.lex_state = 241},
  [1212] = {.lex_state = 138, .external_lex_state = 11},
  [1213] = {.lex_state = 212, .external_lex_state = 23},
  [1214] = {.lex_state = 212, .external_lex_state = 23},
  [1215] = {.lex_state = 212, .external_lex_state = 16},
  [1216] = {.lex_state = 222, .external_lex_state = 16},
  [1217] = {.lex_state = 138, .external_lex_state = 11},
  [1218] = {.lex_state = 224, .external_lex_state = 24},
  [1219] = {.lex_state = 224, .external_lex_state = 16},
  [1220] = {.lex_state = 224, .external_lex_state = 24},
  [1221] = {.lex_state = 224, .external_lex_state = 16},
  [1222] = {.lex_state = 224, .external_lex_state = 16},
  [1223] = {.lex_state = 138, .external_lex_state = 11},
  [1224] = {.lex_state = 224, .external_lex_state = 16},
  [1225] = {.lex_state = 224, .external_lex_state = 16},
  [1226] = {.lex_state = 138, .external_lex_state = 11},
  [1227] = {.lex_state = 217, .external_lex_state = 2},
  [1228] = {.lex_state = 71, .external_lex_state = 2},
  [1229] = {.lex_state = 138, .external_lex_state = 11},
  [1230] = {.lex_state = 217, .external_lex_state = 2},
  [1231] = {.lex_state = 214, .external_lex_state = 21},
  [1232] = {.lex_state = 212, .external_lex_state = 22},
  [1233] = {.lex_state = 243, .external_lex_state = 21},
  [1234] = {.lex_state = 212, .external_lex_state = 22},
  [1235] = {.lex_state = 94},
  [1236] = {.lex_state = 127, .external_lex_state = 11},
  [1237] = {.lex_state = 127, .external_lex_state = 11},
  [1238] = {.lex_state = 169, .external_lex_state = 4},
  [1239] = {.lex_state = 167, .external_lex_state = 20},
  [1240] = {.lex_state = 71},
  [1241] = {.lex_state = 94},
  [1242] = {.lex_state = 94},
  [1243] = {.lex_state = 220, .external_lex_state = 21},
  [1244] = {.lex_state = 220, .external_lex_state = 7},
  [1245] = {.lex_state = 161},
  [1246] = {.lex_state = 71},
  [1247] = {.lex_state = 94},
  [1248] = {.lex_state = 163, .external_lex_state = 14},
  [1249] = {.lex_state = 163, .external_lex_state = 14},
  [1250] = {.lex_state = 163, .external_lex_state = 14},
  [1251] = {.lex_state = 163, .external_lex_state = 11},
  [1252] = {.lex_state = 167, .external_lex_state = 21},
  [1253] = {.lex_state = 220, .external_lex_state = 5},
  [1254] = {.lex_state = 220, .external_lex_state = 5},
  [1255] = {.lex_state = 220, .external_lex_state = 5},
  [1256] = {.lex_state = 169, .external_lex_state = 4},
  [1257] = {.lex_state = 220, .external_lex_state = 7},
  [1258] = {.lex_state = 94, .external_lex_state = 2},
  [1259] = {.lex_state = 204},
  [1260] = {.lex_state = 175, .external_lex_state = 12},
  [1261] = {.lex_state = 175, .external_lex_state = 12},
  [1262] = {.lex_state = 212, .external_lex_state = 23},
  [1263] = {.lex_state = 212, .external_lex_state = 23},
  [1264] = {.lex_state = 212, .external_lex_state = 16},
  [1265] = {.lex_state = 222, .external_lex_state = 16},
  [1266] = {.lex_state = 175, .external_lex_state = 12},
  [1267] = {.lex_state = 224, .external_lex_state = 24},
  [1268] = {.lex_state = 224, .external_lex_state = 16},
  [1269] = {.lex_state = 224, .external_lex_state = 24},
  [1270] = {.lex_state = 224, .external_lex_state = 16},
  [1271] = {.lex_state = 224, .external_lex_state = 16},
  [1272] = {.lex_state = 175, .external_lex_state = 12},
  [1273] = {.lex_state = 224, .external_lex_state = 16},
  [1274] = {.lex_state = 224, .external_lex_state = 16},
  [1275] = {.lex_state = 175, .external_lex_state = 12},
  [1276] = {.lex_state = 217, .external_lex_state = 2},
  [1277] = {.lex_state = 71, .external_lex_state = 2},
  [1278] = {.lex_state = 175, .external_lex_state = 12},
  [1279] = {.lex_state = 217, .external_lex_state = 2},
  [1280] = {.lex_state = 163, .external_lex_state = 3},
  [1281] = {.lex_state = 204},
  [1282] = {.lex_state = 163, .external_lex_state = 14},
  [1283] = {.lex_state = 163, .external_lex_state = 14},
  [1284] = {.lex_state = 212, .external_lex_state = 23},
  [1285] = {.lex_state = 212, .external_lex_state = 23},
  [1286] = {.lex_state = 212, .external_lex_state = 16},
  [1287] = {.lex_state = 222, .external_lex_state = 16},
  [1288] = {.lex_state = 163, .external_lex_state = 14},
  [1289] = {.lex_state = 224, .external_lex_state = 24},
  [1290] = {.lex_state = 224, .external_lex_state = 16},
  [1291] = {.lex_state = 224, .external_lex_state = 24},
  [1292] = {.lex_state = 224, .external_lex_state = 16},
  [1293] = {.lex_state = 224, .external_lex_state = 16},
  [1294] = {.lex_state = 163, .external_lex_state = 14},
  [1295] = {.lex_state = 224, .external_lex_state = 16},
  [1296] = {.lex_state = 224, .external_lex_state = 16},
  [1297] = {.lex_state = 163, .external_lex_state = 14},
  [1298] = {.lex_state = 217, .external_lex_state = 2},
  [1299] = {.lex_state = 71, .external_lex_state = 2},
  [1300] = {.lex_state = 163, .external_lex_state = 14},
  [1301] = {.lex_state = 217, .external_lex_state = 2},
  [1302] = {.lex_state = 163, .external_lex_state = 11},
  [1303] = {.lex_state = 163, .external_lex_state = 11},
  [1304] = {.lex_state = 212, .external_lex_state = 23},
  [1305] = {.lex_state = 212, .external_lex_state = 23},
  [1306] = {.lex_state = 212, .external_lex_state = 16},
  [1307] = {.lex_state = 222, .external_lex_state = 16},
  [1308] = {.lex_state = 163, .external_lex_state = 11},
  [1309] = {.lex_state = 224, .external_lex_state = 24},
  [1310] = {.lex_state = 224, .external_lex_state = 16},
  [1311] = {.lex_state = 224, .external_lex_state = 24},
  [1312] = {.lex_state = 224, .external_lex_state = 16},
  [1313] = {.lex_state = 224, .external_lex_state = 16},
  [1314] = {.lex_state = 163, .external_lex_state = 11},
  [1315] = {.lex_state = 224, .external_lex_state = 16},
  [1316] = {.lex_state = 224, .external_lex_state = 16},
  [1317] = {.lex_state = 163, .external_lex_state = 11},
  [1318] = {.lex_state = 217, .external_lex_state = 2},
  [1319] = {.lex_state = 71, .external_lex_state = 2},
  [1320] = {.lex_state = 163, .external_lex_state = 11},
  [1321] = {.lex_state = 217, .external_lex_state = 2},
  [1322] = {.lex_state = 94, .external_lex_state = 15},
  [1323] = {.lex_state = 94, .external_lex_state = 15},
  [1324] = {.lex_state = 212, .external_lex_state = 23},
  [1325] = {.lex_state = 212, .external_lex_state = 23},
  [1326] = {.lex_state = 212, .external_lex_state = 16},
  [1327] = {.lex_state = 222, .external_lex_state = 16},
  [1328] = {.lex_state = 94, .external_lex_state = 15},
  [1329] = {.lex_state = 224, .external_lex_state = 24},
  [1330] = {.lex_state = 224, .external_lex_state = 16},
  [1331] = {.lex_state = 224, .external_lex_state = 24},
  [1332] = {.lex_state = 224, .external_lex_state = 16},
  [1333] = {.lex_state = 224, .external_lex_state = 16},
  [1334] = {.lex_state = 94, .external_lex_state = 15},
  [1335] = {.lex_state = 224, .external_lex_state = 16},
  [1336] = {.lex_state = 224, .external_lex_state = 16},
  [1337] = {.lex_state = 94, .external_lex_state = 15},
  [1338] = {.lex_state = 217, .external_lex_state = 2},
  [1339] = {.lex_state = 71, .external_lex_state = 2},
  [1340] = {.lex_state = 94, .external_lex_state = 15},
  [1341] = {.lex_state = 217, .external_lex_state = 2},
  [1342] = {.lex_state = 106, .external_lex_state = 10},
  [1343] = {.lex_state = 212, .external_lex_state = 23},
  [1344] = {.lex_state = 212, .external_lex_state = 23},
  [1345] = {.lex_state = 212, .external_lex_state = 16},
  [1346] = {.lex_state = 222, .external_lex_state = 16},
  [1347] = {.lex_state = 106, .external_lex_state = 10},
  [1348] = {.lex_state = 224, .external_lex_state = 24},
  [1349] = {.lex_state = 224, .external_lex_state = 16},
  [1350] = {.lex_state = 224, .external_lex_state = 24},
  [1351] = {.lex_state = 224, .external_lex_state = 16},
  [1352] = {.lex_state = 224, .external_lex_state = 16},
  [1353] = {.lex_state = 106, .external_lex_state = 10},
  [1354] = {.lex_state = 224, .external_lex_state = 16},
  [1355] = {.lex_state = 224, .external_lex_state = 16},
  [1356] = {.lex_state = 106, .external_lex_state = 10},
  [1357] = {.lex_state = 217, .external_lex_state = 2},
  [1358] = {.lex_state = 71, .external_lex_state = 2},
  [1359] = {.lex_state = 202, .external_lex_state = 13},
  [1360] = {.lex_state = 189, .external_lex_state = 23},
  [1361] = {.lex_state = 202, .external_lex_state = 13},
  [1362] = {.lex_state = 189, .external_lex_state = 23},
  [1363] = {.lex_state = 175, .external_lex_state = 13},
  [1364] = {.lex_state = 94},
  [1365] = {.lex_state = 131, .external_lex_state = 5},
  [1366] = {.lex_state = 212, .external_lex_state = 23},
  [1367] = {.lex_state = 212, .external_lex_state = 23},
  [1368] = {.lex_state = 181},
  [1369] = {.lex_state = 106},
  [1370] = {.lex_state = 212, .external_lex_state = 23},
  [1371] = {.lex_state = 212, .external_lex_state = 23},
  [1372] = {.lex_state = 212, .external_lex_state = 23},
  [1373] = {.lex_state = 131, .external_lex_state = 5},
  [1374] = {.lex_state = 78},
  [1375] = {.lex_state = 187, .external_lex_state = 6},
  [1376] = {.lex_state = 189, .external_lex_state = 16},
  [1377] = {.lex_state = 189, .external_lex_state = 16},
  [1378] = {.lex_state = 163, .external_lex_state = 4},
  [1379] = {.lex_state = 167, .external_lex_state = 8},
  [1380] = {.lex_state = 71, .external_lex_state = 2},
  [1381] = {.lex_state = 98, .external_lex_state = 4},
  [1382] = {.lex_state = 129, .external_lex_state = 8},
  [1383] = {.lex_state = 71, .external_lex_state = 2},
  [1384] = {.lex_state = 163, .external_lex_state = 4},
  [1385] = {.lex_state = 167, .external_lex_state = 8},
  [1386] = {.lex_state = 71, .external_lex_state = 2},
  [1387] = {.lex_state = 212, .external_lex_state = 23},
  [1388] = {.lex_state = 212, .external_lex_state = 23},
  [1389] = {.lex_state = 212, .external_lex_state = 16},
  [1390] = {.lex_state = 224, .external_lex_state = 16},
  [1391] = {.lex_state = 131, .external_lex_state = 5},
  [1392] = {.lex_state = 224, .external_lex_state = 16},
  [1393] = {.lex_state = 224, .external_lex_state = 16},
  [1394] = {.lex_state = 224, .external_lex_state = 16},
  [1395] = {.lex_state = 224, .external_lex_state = 23},
  [1396] = {.lex_state = 224, .external_lex_state = 23},
  [1397] = {.lex_state = 224, .external_lex_state = 23},
  [1398] = {.lex_state = 181},
  [1399] = {.lex_state = 222, .external_lex_state = 16},
  [1400] = {.lex_state = 78},
  [1401] = {.lex_state = 189, .external_lex_state = 16},
  [1402] = {.lex_state = 189, .external_lex_state = 16},
  [1403] = {.lex_state = 224, .external_lex_state = 23},
  [1404] = {.lex_state = 224, .external_lex_state = 24},
  [1405] = {.lex_state = 224, .external_lex_state = 16},
  [1406] = {.lex_state = 224, .external_lex_state = 23},
  [1407] = {.lex_state = 224, .external_lex_state = 24},
  [1408] = {.lex_state = 224, .external_lex_state = 16},
  [1409] = {.lex_state = 131, .external_lex_state = 5},
  [1410] = {.lex_state = 224, .external_lex_state = 16},
  [1411] = {.lex_state = 217, .external_lex_state = 2},
  [1412] = {.lex_state = 224, .external_lex_state = 23},
  [1413] = {.lex_state = 163, .external_lex_state = 4},
  [1414] = {.lex_state = 167, .external_lex_state = 8},
  [1415] = {.lex_state = 71, .external_lex_state = 2},
  [1416] = {.lex_state = 98, .external_lex_state = 4},
  [1417] = {.lex_state = 129, .external_lex_state = 8},
  [1418] = {.lex_state = 217, .external_lex_state = 2},
  [1419] = {.lex_state = 224, .external_lex_state = 23},
  [1420] = {.lex_state = 163, .external_lex_state = 4},
  [1421] = {.lex_state = 167, .external_lex_state = 8},
  [1422] = {.lex_state = 131, .external_lex_state = 5},
  [1423] = {.lex_state = 71},
  [1424] = {.lex_state = 94},
  [1425] = {.lex_state = 94},
  [1426] = {.lex_state = 226, .external_lex_state = 21},
  [1427] = {.lex_state = 226, .external_lex_state = 7},
  [1428] = {.lex_state = 161},
  [1429] = {.lex_state = 71},
  [1430] = {.lex_state = 94},
  [1431] = {.lex_state = 129, .external_lex_state = 21},
  [1432] = {.lex_state = 226, .external_lex_state = 5},
  [1433] = {.lex_state = 226, .external_lex_state = 5},
  [1434] = {.lex_state = 226, .external_lex_state = 5},
  [1435] = {.lex_state = 226, .external_lex_state = 7},
  [1436] = {.lex_state = 131, .external_lex_state = 5},
  [1437] = {.lex_state = 169, .external_lex_state = 4},
  [1438] = {.lex_state = 222, .external_lex_state = 16},
  [1439] = {.lex_state = 78},
  [1440] = {.lex_state = 189, .external_lex_state = 16},
  [1441] = {.lex_state = 189, .external_lex_state = 16},
  [1442] = {.lex_state = 193, .external_lex_state = 17},
  [1443] = {.lex_state = 224, .external_lex_state = 24},
  [1444] = {.lex_state = 224, .external_lex_state = 16},
  [1445] = {.lex_state = 193, .external_lex_state = 17},
  [1446] = {.lex_state = 224, .external_lex_state = 24},
  [1447] = {.lex_state = 224, .external_lex_state = 16},
  [1448] = {.lex_state = 198, .external_lex_state = 5},
  [1449] = {.lex_state = 169, .external_lex_state = 4},
  [1450] = {.lex_state = 78},
  [1451] = {.lex_state = 78},
  [1452] = {.lex_state = 204, .external_lex_state = 10},
  [1453] = {.lex_state = 204, .external_lex_state = 10},
  [1454] = {.lex_state = 204, .external_lex_state = 10},
  [1455] = {.lex_state = 181},
  [1456] = {.lex_state = 222, .external_lex_state = 16},
  [1457] = {.lex_state = 78},
  [1458] = {.lex_state = 189, .external_lex_state = 16},
  [1459] = {.lex_state = 189, .external_lex_state = 16},
  [1460] = {.lex_state = 204, .external_lex_state = 10},
  [1461] = {.lex_state = 224, .external_lex_state = 24},
  [1462] = {.lex_state = 224, .external_lex_state = 16},
  [1463] = {.lex_state = 204, .external_lex_state = 10},
  [1464] = {.lex_state = 224, .external_lex_state = 24},
  [1465] = {.lex_state = 224, .external_lex_state = 16},
  [1466] = {.lex_state = 217, .external_lex_state = 2},
  [1467] = {.lex_state = 204, .external_lex_state = 10},
  [1468] = {.lex_state = 163, .external_lex_state = 4},
  [1469] = {.lex_state = 167, .external_lex_state = 8},
  [1470] = {.lex_state = 71, .external_lex_state = 2},
  [1471] = {.lex_state = 98, .external_lex_state = 4},
  [1472] = {.lex_state = 129, .external_lex_state = 8},
  [1473] = {.lex_state = 217, .external_lex_state = 2},
  [1474] = {.lex_state = 204, .external_lex_state = 10},
  [1475] = {.lex_state = 163, .external_lex_state = 4},
  [1476] = {.lex_state = 167, .external_lex_state = 8},
  [1477] = {.lex_state = 167, .external_lex_state = 20},
  [1478] = {.lex_state = 167, .external_lex_state = 20},
  [1479] = {.lex_state = 212, .external_lex_state = 23},
  [1480] = {.lex_state = 212, .external_lex_state = 23},
  [1481] = {.lex_state = 212, .external_lex_state = 16},
  [1482] = {.lex_state = 222, .external_lex_state = 16},
  [1483] = {.lex_state = 167, .external_lex_state = 20},
  [1484] = {.lex_state = 224, .external_lex_state = 24},
  [1485] = {.lex_state = 224, .external_lex_state = 16},
  [1486] = {.lex_state = 224, .external_lex_state = 24},
  [1487] = {.lex_state = 224, .external_lex_state = 16},
  [1488] = {.lex_state = 224, .external_lex_state = 16},
  [1489] = {.lex_state = 167, .external_lex_state = 20},
  [1490] = {.lex_state = 224, .external_lex_state = 16},
  [1491] = {.lex_state = 224, .external_lex_state = 16},
  [1492] = {.lex_state = 167, .external_lex_state = 20},
  [1493] = {.lex_state = 217, .external_lex_state = 2},
  [1494] = {.lex_state = 71, .external_lex_state = 2},
  [1495] = {.lex_state = 167, .external_lex_state = 20},
  [1496] = {.lex_state = 217, .external_lex_state = 2},
  [1497] = {.lex_state = 245},
  [1498] = {.lex_state = 212, .external_lex_state = 22},
  [1499] = {.lex_state = 169, .external_lex_state = 4},
  [1500] = {.lex_state = 245},
  [1501] = {.lex_state = 142},
  [1502] = {.lex_state = 234, .external_lex_state = 11},
  [1503] = {.lex_state = 234, .external_lex_state = 11},
  [1504] = {.lex_state = 212, .external_lex_state = 23},
  [1505] = {.lex_state = 212, .external_lex_state = 23},
  [1506] = {.lex_state = 212, .external_lex_state = 16},
  [1507] = {.lex_state = 222, .external_lex_state = 16},
  [1508] = {.lex_state = 234, .external_lex_state = 11},
  [1509] = {.lex_state = 224, .external_lex_state = 24},
  [1510] = {.lex_state = 224, .external_lex_state = 16},
  [1511] = {.lex_state = 224, .external_lex_state = 24},
  [1512] = {.lex_state = 224, .external_lex_state = 16},
  [1513] = {.lex_state = 224, .external_lex_state = 16},
  [1514] = {.lex_state = 234, .external_lex_state = 11},
  [1515] = {.lex_state = 224, .external_lex_state = 16},
  [1516] = {.lex_state = 224, .external_lex_state = 16},
  [1517] = {.lex_state = 234, .external_lex_state = 11},
  [1518] = {.lex_state = 217, .external_lex_state = 2},
  [1519] = {.lex_state = 71, .external_lex_state = 2},
  [1520] = {.lex_state = 234, .external_lex_state = 11},
  [1521] = {.lex_state = 217, .external_lex_state = 2},
  [1522] = {.lex_state = 232},
  [1523] = {.lex_state = 236, .external_lex_state = 11},
  [1524] = {.lex_state = 236, .external_lex_state = 11},
  [1525] = {.lex_state = 236, .external_lex_state = 11},
  [1526] = {.lex_state = 181},
  [1527] = {.lex_state = 222, .external_lex_state = 16},
  [1528] = {.lex_state = 78},
  [1529] = {.lex_state = 189, .external_lex_state = 16},
  [1530] = {.lex_state = 189, .external_lex_state = 16},
  [1531] = {.lex_state = 236, .external_lex_state = 11},
  [1532] = {.lex_state = 224, .external_lex_state = 24},
  [1533] = {.lex_state = 224, .external_lex_state = 16},
  [1534] = {.lex_state = 236, .external_lex_state = 11},
  [1535] = {.lex_state = 224, .external_lex_state = 24},
  [1536] = {.lex_state = 224, .external_lex_state = 16},
  [1537] = {.lex_state = 217, .external_lex_state = 2},
  [1538] = {.lex_state = 236, .external_lex_state = 11},
  [1539] = {.lex_state = 163, .external_lex_state = 4},
  [1540] = {.lex_state = 167, .external_lex_state = 8},
  [1541] = {.lex_state = 71, .external_lex_state = 2},
  [1542] = {.lex_state = 98, .external_lex_state = 4},
  [1543] = {.lex_state = 129, .external_lex_state = 8},
  [1544] = {.lex_state = 217, .external_lex_state = 2},
  [1545] = {.lex_state = 236, .external_lex_state = 11},
  [1546] = {.lex_state = 163, .external_lex_state = 4},
  [1547] = {.lex_state = 167, .external_lex_state = 8},
  [1548] = {.lex_state = 169, .external_lex_state = 4},
  [1549] = {.lex_state = 169, .external_lex_state = 4},
  [1550] = {.lex_state = 238, .external_lex_state = 10},
  [1551] = {.lex_state = 238, .external_lex_state = 10},
  [1552] = {.lex_state = 212, .external_lex_state = 23},
  [1553] = {.lex_state = 212, .external_lex_state = 23},
  [1554] = {.lex_state = 212, .external_lex_state = 16},
  [1555] = {.lex_state = 222, .external_lex_state = 16},
  [1556] = {.lex_state = 238, .external_lex_state = 10},
  [1557] = {.lex_state = 224, .external_lex_state = 24},
  [1558] = {.lex_state = 224, .external_lex_state = 16},
  [1559] = {.lex_state = 224, .external_lex_state = 24},
  [1560] = {.lex_state = 224, .external_lex_state = 16},
  [1561] = {.lex_state = 224, .external_lex_state = 16},
  [1562] = {.lex_state = 238, .external_lex_state = 10},
  [1563] = {.lex_state = 224, .external_lex_state = 16},
  [1564] = {.lex_state = 224, .external_lex_state = 16},
  [1565] = {.lex_state = 238, .external_lex_state = 10},
  [1566] = {.lex_state = 217, .external_lex_state = 2},
  [1567] = {.lex_state = 71, .external_lex_state = 2},
  [1568] = {.lex_state = 238, .external_lex_state = 10},
  [1569] = {.lex_state = 217, .external_lex_state = 2},
  [1570] = {.lex_state = 210, .external_lex_state = 10},
  [1571] = {.lex_state = 210, .external_lex_state = 10},
  [1572] = {.lex_state = 212, .external_lex_state = 23},
  [1573] = {.lex_state = 212, .external_lex_state = 23},
  [1574] = {.lex_state = 212, .external_lex_state = 16},
  [1575] = {.lex_state = 224, .external_lex_state = 16},
  [1576] = {.lex_state = 210, .external_lex_state = 10},
  [1577] = {.lex_state = 224, .external_lex_state = 16},
  [1578] = {.lex_state = 224, .external_lex_state = 16},
  [1579] = {.lex_state = 224, .external_lex_state = 16},
  [1580] = {.lex_state = 210, .external_lex_state = 10},
  [1581] = {.lex_state = 224, .external_lex_state = 16},
  [1582] = {.lex_state = 210, .external_lex_state = 10},
  [1583] = {.lex_state = 210, .external_lex_state = 10},
  [1584] = {.lex_state = 198, .external_lex_state = 25},
  [1585] = {.lex_state = 198, .external_lex_state = 25},
  [1586] = {.lex_state = 228, .external_lex_state = 21},
  [1587] = {.lex_state = 94},
  [1588] = {.lex_state = 198, .external_lex_state = 25},
  [1589] = {.lex_state = 228, .external_lex_state = 25},
  [1590] = {.lex_state = 181},
  [1591] = {.lex_state = 106},
  [1592] = {.lex_state = 228, .external_lex_state = 25},
  [1593] = {.lex_state = 228, .external_lex_state = 25},
  [1594] = {.lex_state = 228, .external_lex_state = 25},
  [1595] = {.lex_state = 78},
  [1596] = {.lex_state = 187, .external_lex_state = 6},
  [1597] = {.lex_state = 189, .external_lex_state = 16},
  [1598] = {.lex_state = 189, .external_lex_state = 16},
  [1599] = {.lex_state = 163, .external_lex_state = 4},
  [1600] = {.lex_state = 167, .external_lex_state = 8},
  [1601] = {.lex_state = 71, .external_lex_state = 2},
  [1602] = {.lex_state = 98, .external_lex_state = 4},
  [1603] = {.lex_state = 129, .external_lex_state = 8},
  [1604] = {.lex_state = 71, .external_lex_state = 2},
  [1605] = {.lex_state = 163, .external_lex_state = 4},
  [1606] = {.lex_state = 167, .external_lex_state = 8},
  [1607] = {.lex_state = 71, .external_lex_state = 2},
  [1608] = {.lex_state = 129, .external_lex_state = 20},
  [1609] = {.lex_state = 94},
  [1610] = {.lex_state = 198, .external_lex_state = 25},
  [1611] = {.lex_state = 198, .external_lex_state = 25},
  [1612] = {.lex_state = 198, .external_lex_state = 25},
  [1613] = {.lex_state = 198, .external_lex_state = 25},
  [1614] = {.lex_state = 198, .external_lex_state = 21},
  [1615] = {.lex_state = 129, .external_lex_state = 21},
  [1616] = {.lex_state = 94},
  [1617] = {.lex_state = 127, .external_lex_state = 11},
  [1618] = {.lex_state = 127, .external_lex_state = 11},
  [1619] = {.lex_state = 198, .external_lex_state = 5},
  [1620] = {.lex_state = 71, .external_lex_state = 2},
  [1621] = {.lex_state = 71, .external_lex_state = 2},
  [1622] = {.lex_state = 169, .external_lex_state = 4},
  [1623] = {.lex_state = 94},
  [1624] = {.lex_state = 94},
  [1625] = {.lex_state = 253, .external_lex_state = 2},
  [1626] = {.lex_state = 248},
  [1627] = {.lex_state = 248, .external_lex_state = 10},
  [1628] = {.lex_state = 253, .external_lex_state = 2},
  [1629] = {.lex_state = 248},
  [1630] = {.lex_state = 169, .external_lex_state = 4},
  [1631] = {.lex_state = 251},
  [1632] = {.lex_state = 94},
  [1633] = {.lex_state = 94},
  [1634] = {.lex_state = 169, .external_lex_state = 4},
  [1635] = {.lex_state = 251},
  [1636] = {.lex_state = 94},
  [1637] = {.lex_state = 138, .external_lex_state = 11},
  [1638] = {.lex_state = 138, .external_lex_state = 11},
  [1639] = {.lex_state = 212, .external_lex_state = 23},
  [1640] = {.lex_state = 212, .external_lex_state = 23},
  [1641] = {.lex_state = 212, .external_lex_state = 16},
  [1642] = {.lex_state = 224, .external_lex_state = 16},
  [1643] = {.lex_state = 138, .external_lex_state = 11},
  [1644] = {.lex_state = 224, .external_lex_state = 16},
  [1645] = {.lex_state = 224, .external_lex_state = 16},
  [1646] = {.lex_state = 224, .external_lex_state = 16},
  [1647] = {.lex_state = 138, .external_lex_state = 11},
  [1648] = {.lex_state = 224, .external_lex_state = 16},
  [1649] = {.lex_state = 138, .external_lex_state = 11},
  [1650] = {.lex_state = 138, .external_lex_state = 11},
  [1651] = {.lex_state = 169, .external_lex_state = 4},
  [1652] = {.lex_state = 127, .external_lex_state = 11},
  [1653] = {.lex_state = 127, .external_lex_state = 11},
  [1654] = {.lex_state = 169, .external_lex_state = 4},
  [1655] = {.lex_state = 127, .external_lex_state = 11},
  [1656] = {.lex_state = 167, .external_lex_state = 20},
  [1657] = {.lex_state = 94},
  [1658] = {.lex_state = 220, .external_lex_state = 25},
  [1659] = {.lex_state = 220, .external_lex_state = 25},
  [1660] = {.lex_state = 220, .external_lex_state = 25},
  [1661] = {.lex_state = 220, .external_lex_state = 25},
  [1662] = {.lex_state = 220, .external_lex_state = 21},
  [1663] = {.lex_state = 167, .external_lex_state = 21},
  [1664] = {.lex_state = 94},
  [1665] = {.lex_state = 255, .external_lex_state = 11},
  [1666] = {.lex_state = 255, .external_lex_state = 11},
  [1667] = {.lex_state = 220, .external_lex_state = 5},
  [1668] = {.lex_state = 94, .external_lex_state = 2},
  [1669] = {.lex_state = 175, .external_lex_state = 12},
  [1670] = {.lex_state = 175, .external_lex_state = 12},
  [1671] = {.lex_state = 212, .external_lex_state = 23},
  [1672] = {.lex_state = 212, .external_lex_state = 23},
  [1673] = {.lex_state = 212, .external_lex_state = 16},
  [1674] = {.lex_state = 224, .external_lex_state = 16},
  [1675] = {.lex_state = 175, .external_lex_state = 12},
  [1676] = {.lex_state = 224, .external_lex_state = 16},
  [1677] = {.lex_state = 224, .external_lex_state = 16},
  [1678] = {.lex_state = 224, .external_lex_state = 16},
  [1679] = {.lex_state = 175, .external_lex_state = 12},
  [1680] = {.lex_state = 224, .external_lex_state = 16},
  [1681] = {.lex_state = 175, .external_lex_state = 12},
  [1682] = {.lex_state = 175, .external_lex_state = 12},
  [1683] = {.lex_state = 163, .external_lex_state = 3},
  [1684] = {.lex_state = 163, .external_lex_state = 14},
  [1685] = {.lex_state = 163, .external_lex_state = 14},
  [1686] = {.lex_state = 212, .external_lex_state = 23},
  [1687] = {.lex_state = 212, .external_lex_state = 23},
  [1688] = {.lex_state = 212, .external_lex_state = 16},
  [1689] = {.lex_state = 224, .external_lex_state = 16},
  [1690] = {.lex_state = 163, .external_lex_state = 14},
  [1691] = {.lex_state = 224, .external_lex_state = 16},
  [1692] = {.lex_state = 224, .external_lex_state = 16},
  [1693] = {.lex_state = 224, .external_lex_state = 16},
  [1694] = {.lex_state = 163, .external_lex_state = 14},
  [1695] = {.lex_state = 224, .external_lex_state = 16},
  [1696] = {.lex_state = 163, .external_lex_state = 14},
  [1697] = {.lex_state = 163, .external_lex_state = 14},
  [1698] = {.lex_state = 163, .external_lex_state = 11},
  [1699] = {.lex_state = 163, .external_lex_state = 11},
  [1700] = {.lex_state = 212, .external_lex_state = 23},
  [1701] = {.lex_state = 212, .external_lex_state = 23},
  [1702] = {.lex_state = 212, .external_lex_state = 16},
  [1703] = {.lex_state = 224, .external_lex_state = 16},
  [1704] = {.lex_state = 163, .external_lex_state = 11},
  [1705] = {.lex_state = 224, .external_lex_state = 16},
  [1706] = {.lex_state = 224, .external_lex_state = 16},
  [1707] = {.lex_state = 224, .external_lex_state = 16},
  [1708] = {.lex_state = 163, .external_lex_state = 11},
  [1709] = {.lex_state = 224, .external_lex_state = 16},
  [1710] = {.lex_state = 163, .external_lex_state = 11},
  [1711] = {.lex_state = 163, .external_lex_state = 11},
  [1712] = {.lex_state = 94, .external_lex_state = 15},
  [1713] = {.lex_state = 94, .external_lex_state = 15},
  [1714] = {.lex_state = 212, .external_lex_state = 23},
  [1715] = {.lex_state = 212, .external_lex_state = 23},
  [1716] = {.lex_state = 212, .external_lex_state = 16},
  [1717] = {.lex_state = 224, .external_lex_state = 16},
  [1718] = {.lex_state = 94, .external_lex_state = 15},
  [1719] = {.lex_state = 224, .external_lex_state = 16},
  [1720] = {.lex_state = 224, .external_lex_state = 16},
  [1721] = {.lex_state = 224, .external_lex_state = 16},
  [1722] = {.lex_state = 94, .external_lex_state = 15},
  [1723] = {.lex_state = 224, .external_lex_state = 16},
  [1724] = {.lex_state = 94, .external_lex_state = 15},
  [1725] = {.lex_state = 94, .external_lex_state = 15},
  [1726] = {.lex_state = 106, .external_lex_state = 10},
  [1727] = {.lex_state = 106, .external_lex_state = 10},
  [1728] = {.lex_state = 212, .external_lex_state = 23},
  [1729] = {.lex_state = 212, .external_lex_state = 23},
  [1730] = {.lex_state = 212, .external_lex_state = 16},
  [1731] = {.lex_state = 224, .external_lex_state = 16},
  [1732] = {.lex_state = 106, .external_lex_state = 10},
  [1733] = {.lex_state = 224, .external_lex_state = 16},
  [1734] = {.lex_state = 224, .external_lex_state = 16},
  [1735] = {.lex_state = 224, .external_lex_state = 16},
  [1736] = {.lex_state = 106, .external_lex_state = 10},
  [1737] = {.lex_state = 224, .external_lex_state = 16},
  [1738] = {.lex_state = 106, .external_lex_state = 10},
  [1739] = {.lex_state = 189, .external_lex_state = 23},
  [1740] = {.lex_state = 189, .external_lex_state = 16},
  [1741] = {.lex_state = 189, .external_lex_state = 23},
  [1742] = {.lex_state = 189, .external_lex_state = 16},
  [1743] = {.lex_state = 212, .external_lex_state = 23},
  [1744] = {.lex_state = 212, .external_lex_state = 23},
  [1745] = {.lex_state = 212, .external_lex_state = 23},
  [1746] = {.lex_state = 181},
  [1747] = {.lex_state = 222, .external_lex_state = 16},
  [1748] = {.lex_state = 78},
  [1749] = {.lex_state = 189, .external_lex_state = 16},
  [1750] = {.lex_state = 189, .external_lex_state = 16},
  [1751] = {.lex_state = 212, .external_lex_state = 23},
  [1752] = {.lex_state = 224, .external_lex_state = 24},
  [1753] = {.lex_state = 224, .external_lex_state = 16},
  [1754] = {.lex_state = 212, .external_lex_state = 23},
  [1755] = {.lex_state = 224, .external_lex_state = 24},
  [1756] = {.lex_state = 224, .external_lex_state = 16},
  [1757] = {.lex_state = 217, .external_lex_state = 2},
  [1758] = {.lex_state = 212, .external_lex_state = 23},
  [1759] = {.lex_state = 163, .external_lex_state = 4},
  [1760] = {.lex_state = 167, .external_lex_state = 8},
  [1761] = {.lex_state = 71, .external_lex_state = 2},
  [1762] = {.lex_state = 98, .external_lex_state = 4},
  [1763] = {.lex_state = 129, .external_lex_state = 8},
  [1764] = {.lex_state = 217, .external_lex_state = 2},
  [1765] = {.lex_state = 212, .external_lex_state = 23},
  [1766] = {.lex_state = 163, .external_lex_state = 4},
  [1767] = {.lex_state = 167, .external_lex_state = 8},
  [1768] = {.lex_state = 131, .external_lex_state = 5},
  [1769] = {.lex_state = 131, .external_lex_state = 5},
  [1770] = {.lex_state = 131, .external_lex_state = 5},
  [1771] = {.lex_state = 224, .external_lex_state = 16},
  [1772] = {.lex_state = 224, .external_lex_state = 16},
  [1773] = {.lex_state = 224, .external_lex_state = 23},
  [1774] = {.lex_state = 224, .external_lex_state = 23},
  [1775] = {.lex_state = 212, .external_lex_state = 23},
  [1776] = {.lex_state = 212, .external_lex_state = 23},
  [1777] = {.lex_state = 212, .external_lex_state = 16},
  [1778] = {.lex_state = 222, .external_lex_state = 16},
  [1779] = {.lex_state = 224, .external_lex_state = 23},
  [1780] = {.lex_state = 224, .external_lex_state = 24},
  [1781] = {.lex_state = 224, .external_lex_state = 16},
  [1782] = {.lex_state = 224, .external_lex_state = 24},
  [1783] = {.lex_state = 224, .external_lex_state = 16},
  [1784] = {.lex_state = 224, .external_lex_state = 16},
  [1785] = {.lex_state = 224, .external_lex_state = 23},
  [1786] = {.lex_state = 224, .external_lex_state = 16},
  [1787] = {.lex_state = 224, .external_lex_state = 16},
  [1788] = {.lex_state = 131, .external_lex_state = 5},
  [1789] = {.lex_state = 224, .external_lex_state = 23},
  [1790] = {.lex_state = 217, .external_lex_state = 2},
  [1791] = {.lex_state = 71, .external_lex_state = 2},
  [1792] = {.lex_state = 224, .external_lex_state = 23},
  [1793] = {.lex_state = 217, .external_lex_state = 2},
  [1794] = {.lex_state = 94},
  [1795] = {.lex_state = 226, .external_lex_state = 25},
  [1796] = {.lex_state = 226, .external_lex_state = 25},
  [1797] = {.lex_state = 226, .external_lex_state = 25},
  [1798] = {.lex_state = 226, .external_lex_state = 25},
  [1799] = {.lex_state = 226, .external_lex_state = 21},
  [1800] = {.lex_state = 129, .external_lex_state = 21},
  [1801] = {.lex_state = 94},
  [1802] = {.lex_state = 257, .external_lex_state = 11},
  [1803] = {.lex_state = 257, .external_lex_state = 11},
  [1804] = {.lex_state = 226, .external_lex_state = 5},
  [1805] = {.lex_state = 193, .external_lex_state = 17},
  [1806] = {.lex_state = 212, .external_lex_state = 23},
  [1807] = {.lex_state = 212, .external_lex_state = 23},
  [1808] = {.lex_state = 212, .external_lex_state = 16},
  [1809] = {.lex_state = 222, .external_lex_state = 16},
  [1810] = {.lex_state = 193, .external_lex_state = 17},
  [1811] = {.lex_state = 224, .external_lex_state = 24},
  [1812] = {.lex_state = 224, .external_lex_state = 16},
  [1813] = {.lex_state = 224, .external_lex_state = 24},
  [1814] = {.lex_state = 224, .external_lex_state = 16},
  [1815] = {.lex_state = 224, .external_lex_state = 16},
  [1816] = {.lex_state = 193, .external_lex_state = 17},
  [1817] = {.lex_state = 224, .external_lex_state = 16},
  [1818] = {.lex_state = 224, .external_lex_state = 16},
  [1819] = {.lex_state = 204, .external_lex_state = 10},
  [1820] = {.lex_state = 204, .external_lex_state = 10},
  [1821] = {.lex_state = 212, .external_lex_state = 23},
  [1822] = {.lex_state = 212, .external_lex_state = 23},
  [1823] = {.lex_state = 212, .external_lex_state = 16},
  [1824] = {.lex_state = 222, .external_lex_state = 16},
  [1825] = {.lex_state = 204, .external_lex_state = 10},
  [1826] = {.lex_state = 224, .external_lex_state = 24},
  [1827] = {.lex_state = 224, .external_lex_state = 16},
  [1828] = {.lex_state = 224, .external_lex_state = 24},
  [1829] = {.lex_state = 224, .external_lex_state = 16},
  [1830] = {.lex_state = 224, .external_lex_state = 16},
  [1831] = {.lex_state = 204, .external_lex_state = 10},
  [1832] = {.lex_state = 224, .external_lex_state = 16},
  [1833] = {.lex_state = 224, .external_lex_state = 16},
  [1834] = {.lex_state = 204, .external_lex_state = 10},
  [1835] = {.lex_state = 217, .external_lex_state = 2},
  [1836] = {.lex_state = 71, .external_lex_state = 2},
  [1837] = {.lex_state = 204, .external_lex_state = 10},
  [1838] = {.lex_state = 217, .external_lex_state = 2},
  [1839] = {.lex_state = 167, .external_lex_state = 20},
  [1840] = {.lex_state = 167, .external_lex_state = 20},
  [1841] = {.lex_state = 212, .external_lex_state = 23},
  [1842] = {.lex_state = 212, .external_lex_state = 23},
  [1843] = {.lex_state = 212, .external_lex_state = 16},
  [1844] = {.lex_state = 224, .external_lex_state = 16},
  [1845] = {.lex_state = 167, .external_lex_state = 20},
  [1846] = {.lex_state = 224, .external_lex_state = 16},
  [1847] = {.lex_state = 224, .external_lex_state = 16},
  [1848] = {.lex_state = 224, .external_lex_state = 16},
  [1849] = {.lex_state = 167, .external_lex_state = 20},
  [1850] = {.lex_state = 224, .external_lex_state = 16},
  [1851] = {.lex_state = 167, .external_lex_state = 20},
  [1852] = {.lex_state = 167, .external_lex_state = 20},
  [1853] = {.lex_state = 169, .external_lex_state = 4},
  [1854] = {.lex_state = 169, .external_lex_state = 4},
  [1855] = {.lex_state = 212, .external_lex_state = 22},
  [1856] = {.lex_state = 245},
  [1857] = {.lex_state = 245},
  [1858] = {.lex_state = 234, .external_lex_state = 11},
  [1859] = {.lex_state = 234, .external_lex_state = 11},
  [1860] = {.lex_state = 212, .external_lex_state = 23},
  [1861] = {.lex_state = 212, .external_lex_state = 23},
  [1862] = {.lex_state = 212, .external_lex_state = 16},
  [1863] = {.lex_state = 224, .external_lex_state = 16},
  [1864] = {.lex_state = 234, .external_lex_state = 11},
  [1865] = {.lex_state = 224, .external_lex_state = 16},
  [1866] = {.lex_state = 224, .external_lex_state = 16},
  [1867] = {.lex_state = 224, .external_lex_state = 16},
  [1868] = {.lex_state = 234, .external_lex_state = 11},
  [1869] = {.lex_state = 224, .external_lex_state = 16},
  [1870] = {.lex_state = 234, .external_lex_state = 11},
  [1871] = {.lex_state = 234, .external_lex_state = 11},
  [1872] = {.lex_state = 142},
  [1873] = {.lex_state = 236, .external_lex_state = 11},
  [1874] = {.lex_state = 236, .external_lex_state = 11},
  [1875] = {.lex_state = 212, .external_lex_state = 23},
  [1876] = {.lex_state = 212, .external_lex_state = 23},
  [1877] = {.lex_state = 212, .external_lex_state = 16},
  [1878] = {.lex_state = 222, .external_lex_state = 16},
  [1879] = {.lex_state = 236, .external_lex_state = 11},
  [1880] = {.lex_state = 224, .external_lex_state = 24},
  [1881] = {.lex_state = 224, .external_lex_state = 16},
  [1882] = {.lex_state = 224, .external_lex_state = 24},
  [1883] = {.lex_state = 224, .external_lex_state = 16},
  [1884] = {.lex_state = 224, .external_lex_state = 16},
  [1885] = {.lex_state = 236, .external_lex_state = 11},
  [1886] = {.lex_state = 224, .external_lex_state = 16},
  [1887] = {.lex_state = 224, .external_lex_state = 16},
  [1888] = {.lex_state = 236, .external_lex_state = 11},
  [1889] = {.lex_state = 217, .external_lex_state = 2},
  [1890] = {.lex_state = 71, .external_lex_state = 2},
  [1891] = {.lex_state = 236, .external_lex_state = 11},
  [1892] = {.lex_state = 217, .external_lex_state = 2},
  [1893] = {.lex_state = 238, .external_lex_state = 10},
  [1894] = {.lex_state = 238, .external_lex_state = 10},
  [1895] = {.lex_state = 212, .external_lex_state = 23},
  [1896] = {.lex_state = 212, .external_lex_state = 23},
  [1897] = {.lex_state = 212, .external_lex_state = 16},
  [1898] = {.lex_state = 224, .external_lex_state = 16},
  [1899] = {.lex_state = 238, .external_lex_state = 10},
  [1900] = {.lex_state = 224, .external_lex_state = 16},
  [1901] = {.lex_state = 224, .external_lex_state = 16},
  [1902] = {.lex_state = 224, .external_lex_state = 16},
  [1903] = {.lex_state = 238, .external_lex_state = 10},
  [1904] = {.lex_state = 224, .external_lex_state = 16},
  [1905] = {.lex_state = 238, .external_lex_state = 10},
  [1906] = {.lex_state = 238, .external_lex_state = 10},
  [1907] = {.lex_state = 210, .external_lex_state = 10},
  [1908] = {.lex_state = 210, .external_lex_state = 10},
  [1909] = {.lex_state = 210, .external_lex_state = 10},
  [1910] = {.lex_state = 224, .external_lex_state = 16},
  [1911] = {.lex_state = 224, .external_lex_state = 16},
  [1912] = {.lex_state = 210, .external_lex_state = 10},
  [1913] = {.lex_state = 228, .external_lex_state = 25},
  [1914] = {.lex_state = 198, .external_lex_state = 25},
  [1915] = {.lex_state = 228, .external_lex_state = 25},
  [1916] = {.lex_state = 181},
  [1917] = {.lex_state = 222, .external_lex_state = 16},
  [1918] = {.lex_state = 78},
  [1919] = {.lex_state = 189, .external_lex_state = 16},
  [1920] = {.lex_state = 189, .external_lex_state = 16},
  [1921] = {.lex_state = 228, .external_lex_state = 25},
  [1922] = {.lex_state = 224, .external_lex_state = 24},
  [1923] = {.lex_state = 224, .external_lex_state = 16},
  [1924] = {.lex_state = 228, .external_lex_state = 25},
  [1925] = {.lex_state = 224, .external_lex_state = 24},
  [1926] = {.lex_state = 224, .external_lex_state = 16},
  [1927] = {.lex_state = 217, .external_lex_state = 2},
  [1928] = {.lex_state = 228, .external_lex_state = 25},
  [1929] = {.lex_state = 163, .external_lex_state = 4},
  [1930] = {.lex_state = 167, .external_lex_state = 8},
  [1931] = {.lex_state = 71, .external_lex_state = 2},
  [1932] = {.lex_state = 98, .external_lex_state = 4},
  [1933] = {.lex_state = 129, .external_lex_state = 8},
  [1934] = {.lex_state = 217, .external_lex_state = 2},
  [1935] = {.lex_state = 228, .external_lex_state = 25},
  [1936] = {.lex_state = 163, .external_lex_state = 4},
  [1937] = {.lex_state = 167, .external_lex_state = 8},
  [1938] = {.lex_state = 198, .external_lex_state = 25},
  [1939] = {.lex_state = 198, .external_lex_state = 25},
  [1940] = {.lex_state = 198, .external_lex_state = 25},
  [1941] = {.lex_state = 127, .external_lex_state = 11},
  [1942] = {.lex_state = 127, .external_lex_state = 11},
  [1943] = {.lex_state = 127, .external_lex_state = 11},
  [1944] = {.lex_state = 71, .external_lex_state = 2},
  [1945] = {.lex_state = 169, .external_lex_state = 4},
  [1946] = {.lex_state = 248, .external_lex_state = 10},
  [1947] = {.lex_state = 248, .external_lex_state = 10},
  [1948] = {.lex_state = 248},
  [1949] = {.lex_state = 78},
  [1950] = {.lex_state = 88},
  [1951] = {.lex_state = 71, .external_lex_state = 2},
  [1952] = {.lex_state = 241},
  [1953] = {.lex_state = 94},
  [1954] = {.lex_state = 96, .external_lex_state = 2},
  [1955] = {.lex_state = 88},
  [1956] = {.lex_state = 88},
  [1957] = {.lex_state = 259, .external_lex_state = 3},
  [1958] = {.lex_state = 259, .external_lex_state = 4},
  [1959] = {.lex_state = 265, .external_lex_state = 5},
  [1960] = {.lex_state = 106},
  [1961] = {.lex_state = 113},
  [1962] = {.lex_state = 265, .external_lex_state = 5},
  [1963] = {.lex_state = 113, .external_lex_state = 6},
  [1964] = {.lex_state = 71, .external_lex_state = 2},
  [1965] = {.lex_state = 71, .external_lex_state = 2},
  [1966] = {.lex_state = 71, .external_lex_state = 2},
  [1967] = {.lex_state = 267, .external_lex_state = 5},
  [1968] = {.lex_state = 251, .external_lex_state = 4},
  [1969] = {.lex_state = 265, .external_lex_state = 7},
  [1970] = {.lex_state = 269, .external_lex_state = 8},
  [1971] = {.lex_state = 78},
  [1972] = {.lex_state = 265, .external_lex_state = 7},
  [1973] = {.lex_state = 253, .external_lex_state = 2},
  [1974] = {.lex_state = 94, .external_lex_state = 2},
  [1975] = {.lex_state = 253, .external_lex_state = 2},
  [1976] = {.lex_state = 248},
  [1977] = {.lex_state = 248, .external_lex_state = 10},
  [1978] = {.lex_state = 241},
  [1979] = {.lex_state = 251, .external_lex_state = 4},
  [1980] = {.lex_state = 269, .external_lex_state = 8},
  [1981] = {.lex_state = 253, .external_lex_state = 2},
  [1982] = {.lex_state = 253, .external_lex_state = 2},
  [1983] = {.lex_state = 169, .external_lex_state = 4},
  [1984] = {.lex_state = 248, .external_lex_state = 10},
  [1985] = {.lex_state = 248, .external_lex_state = 10},
  [1986] = {.lex_state = 248},
  [1987] = {.lex_state = 251},
  [1988] = {.lex_state = 169, .external_lex_state = 4},
  [1989] = {.lex_state = 251},
  [1990] = {.lex_state = 138, .external_lex_state = 11},
  [1991] = {.lex_state = 138, .external_lex_state = 11},
  [1992] = {.lex_state = 138, .external_lex_state = 11},
  [1993] = {.lex_state = 224, .external_lex_state = 16},
  [1994] = {.lex_state = 224, .external_lex_state = 16},
  [1995] = {.lex_state = 138, .external_lex_state = 11},
  [1996] = {.lex_state = 127, .external_lex_state = 11},
  [1997] = {.lex_state = 220, .external_lex_state = 25},
  [1998] = {.lex_state = 220, .external_lex_state = 25},
  [1999] = {.lex_state = 220, .external_lex_state = 25},
  [2000] = {.lex_state = 255, .external_lex_state = 11},
  [2001] = {.lex_state = 255, .external_lex_state = 11},
  [2002] = {.lex_state = 255, .external_lex_state = 11},
  [2003] = {.lex_state = 175, .external_lex_state = 12},
  [2004] = {.lex_state = 175, .external_lex_state = 12},
  [2005] = {.lex_state = 175, .external_lex_state = 12},
  [2006] = {.lex_state = 224, .external_lex_state = 16},
  [2007] = {.lex_state = 224, .external_lex_state = 16},
  [2008] = {.lex_state = 175, .external_lex_state = 12},
  [2009] = {.lex_state = 163, .external_lex_state = 14},
  [2010] = {.lex_state = 163, .external_lex_state = 14},
  [2011] = {.lex_state = 163, .external_lex_state = 14},
  [2012] = {.lex_state = 224, .external_lex_state = 16},
  [2013] = {.lex_state = 224, .external_lex_state = 16},
  [2014] = {.lex_state = 163, .external_lex_state = 14},
  [2015] = {.lex_state = 163, .external_lex_state = 11},
  [2016] = {.lex_state = 163, .external_lex_state = 11},
  [2017] = {.lex_state = 163, .external_lex_state = 11},
  [2018] = {.lex_state = 224, .external_lex_state = 16},
  [2019] = {.lex_state = 224, .external_lex_state = 16},
  [2020] = {.lex_state = 163, .external_lex_state = 11},
  [2021] = {.lex_state = 94, .external_lex_state = 15},
  [2022] = {.lex_state = 94, .external_lex_state = 15},
  [2023] = {.lex_state = 94, .external_lex_state = 15},
  [2024] = {.lex_state = 224, .external_lex_state = 16},
  [2025] = {.lex_state = 224, .external_lex_state = 16},
  [2026] = {.lex_state = 94, .external_lex_state = 15},
  [2027] = {.lex_state = 106, .external_lex_state = 10},
  [2028] = {.lex_state = 106, .external_lex_state = 10},
  [2029] = {.lex_state = 106, .external_lex_state = 10},
  [2030] = {.lex_state = 224, .external_lex_state = 16},
  [2031] = {.lex_state = 224, .external_lex_state = 16},
  [2032] = {.lex_state = 106, .external_lex_state = 10},
  [2033] = {.lex_state = 189, .external_lex_state = 16},
  [2034] = {.lex_state = 189, .external_lex_state = 16},
  [2035] = {.lex_state = 212, .external_lex_state = 23},
  [2036] = {.lex_state = 212, .external_lex_state = 23},
  [2037] = {.lex_state = 212, .external_lex_state = 23},
  [2038] = {.lex_state = 212, .external_lex_state = 23},
  [2039] = {.lex_state = 212, .external_lex_state = 16},
  [2040] = {.lex_state = 222, .external_lex_state = 16},
  [2041] = {.lex_state = 212, .external_lex_state = 23},
  [2042] = {.lex_state = 224, .external_lex_state = 24},
  [2043] = {.lex_state = 224, .external_lex_state = 16},
  [2044] = {.lex_state = 224, .external_lex_state = 24},
  [2045] = {.lex_state = 224, .external_lex_state = 16},
  [2046] = {.lex_state = 224, .external_lex_state = 16},
  [2047] = {.lex_state = 212, .external_lex_state = 23},
  [2048] = {.lex_state = 224, .external_lex_state = 16},
  [2049] = {.lex_state = 224, .external_lex_state = 16},
  [2050] = {.lex_state = 212, .external_lex_state = 23},
  [2051] = {.lex_state = 217, .external_lex_state = 2},
  [2052] = {.lex_state = 71, .external_lex_state = 2},
  [2053] = {.lex_state = 212, .external_lex_state = 23},
  [2054] = {.lex_state = 217, .external_lex_state = 2},
  [2055] = {.lex_state = 131, .external_lex_state = 5},
  [2056] = {.lex_state = 131, .external_lex_state = 5},
  [2057] = {.lex_state = 224, .external_lex_state = 23},
  [2058] = {.lex_state = 224, .external_lex_state = 23},
  [2059] = {.lex_state = 212, .external_lex_state = 23},
  [2060] = {.lex_state = 212, .external_lex_state = 23},
  [2061] = {.lex_state = 212, .external_lex_state = 16},
  [2062] = {.lex_state = 224, .external_lex_state = 16},
  [2063] = {.lex_state = 224, .external_lex_state = 23},
  [2064] = {.lex_state = 224, .external_lex_state = 16},
  [2065] = {.lex_state = 224, .external_lex_state = 16},
  [2066] = {.lex_state = 224, .external_lex_state = 16},
  [2067] = {.lex_state = 224, .external_lex_state = 23},
  [2068] = {.lex_state = 224, .external_lex_state = 16},
  [2069] = {.lex_state = 224, .external_lex_state = 23},
  [2070] = {.lex_state = 224, .external_lex_state = 23},
  [2071] = {.lex_state = 226, .external_lex_state = 25},
  [2072] = {.lex_state = 226, .external_lex_state = 25},
  [2073] = {.lex_state = 226, .external_lex_state = 25},
  [2074] = {.lex_state = 257, .external_lex_state = 11},
  [2075] = {.lex_state = 257, .external_lex_state = 11},
  [2076] = {.lex_state = 257, .external_lex_state = 11},
  [2077] = {.lex_state = 193, .external_lex_state = 17},
  [2078] = {.lex_state = 193, .external_lex_state = 17},
  [2079] = {.lex_state = 212, .external_lex_state = 23},
  [2080] = {.lex_state = 212, .external_lex_state = 23},
  [2081] = {.lex_state = 212, .external_lex_state = 16},
  [2082] = {.lex_state = 224, .external_lex_state = 16},
  [2083] = {.lex_state = 193, .external_lex_state = 17},
  [2084] = {.lex_state = 224, .external_lex_state = 16},
  [2085] = {.lex_state = 224, .external_lex_state = 16},
  [2086] = {.lex_state = 224, .external_lex_state = 16},
  [2087] = {.lex_state = 193, .external_lex_state = 17},
  [2088] = {.lex_state = 224, .external_lex_state = 16},
  [2089] = {.lex_state = 204, .external_lex_state = 10},
  [2090] = {.lex_state = 204, .external_lex_state = 10},
  [2091] = {.lex_state = 212, .external_lex_state = 23},
  [2092] = {.lex_state = 212, .external_lex_state = 23},
  [2093] = {.lex_state = 212, .external_lex_state = 16},
  [2094] = {.lex_state = 224, .external_lex_state = 16},
  [2095] = {.lex_state = 204, .external_lex_state = 10},
  [2096] = {.lex_state = 224, .external_lex_state = 16},
  [2097] = {.lex_state = 224, .external_lex_state = 16},
  [2098] = {.lex_state = 224, .external_lex_state = 16},
  [2099] = {.lex_state = 204, .external_lex_state = 10},
  [2100] = {.lex_state = 224, .external_lex_state = 16},
  [2101] = {.lex_state = 204, .external_lex_state = 10},
  [2102] = {.lex_state = 204, .external_lex_state = 10},
  [2103] = {.lex_state = 167, .external_lex_state = 20},
  [2104] = {.lex_state = 167, .external_lex_state = 20},
  [2105] = {.lex_state = 167, .external_lex_state = 20},
  [2106] = {.lex_state = 224, .external_lex_state = 16},
  [2107] = {.lex_state = 224, .external_lex_state = 16},
  [2108] = {.lex_state = 167, .external_lex_state = 20},
  [2109] = {.lex_state = 169, .external_lex_state = 4},
  [2110] = {.lex_state = 169, .external_lex_state = 4},
  [2111] = {.lex_state = 245},
  [2112] = {.lex_state = 234, .external_lex_state = 11},
  [2113] = {.lex_state = 234, .external_lex_state = 11},
  [2114] = {.lex_state = 234, .external_lex_state = 11},
  [2115] = {.lex_state = 224, .external_lex_state = 16},
  [2116] = {.lex_state = 224, .external_lex_state = 16},
  [2117] = {.lex_state = 234, .external_lex_state = 11},
  [2118] = {.lex_state = 245},
  [2119] = {.lex_state = 236, .external_lex_state = 11},
  [2120] = {.lex_state = 236, .external_lex_state = 11},
  [2121] = {.lex_state = 212, .external_lex_state = 23},
  [2122] = {.lex_state = 212, .external_lex_state = 23},
  [2123] = {.lex_state = 212, .external_lex_state = 16},
  [2124] = {.lex_state = 224, .external_lex_state = 16},
  [2125] = {.lex_state = 236, .external_lex_state = 11},
  [2126] = {.lex_state = 224, .external_lex_state = 16},
  [2127] = {.lex_state = 224, .external_lex_state = 16},
  [2128] = {.lex_state = 224, .external_lex_state = 16},
  [2129] = {.lex_state = 236, .external_lex_state = 11},
  [2130] = {.lex_state = 224, .external_lex_state = 16},
  [2131] = {.lex_state = 236, .external_lex_state = 11},
  [2132] = {.lex_state = 236, .external_lex_state = 11},
  [2133] = {.lex_state = 238, .external_lex_state = 10},
  [2134] = {.lex_state = 238, .external_lex_state = 10},
  [2135] = {.lex_state = 238, .external_lex_state = 10},
  [2136] = {.lex_state = 224, .external_lex_state = 16},
  [2137] = {.lex_state = 224, .external_lex_state = 16},
  [2138] = {.lex_state = 238, .external_lex_state = 10},
  [2139] = {.lex_state = 210, .external_lex_state = 10},
  [2140] = {.lex_state = 210, .external_lex_state = 10},
  [2141] = {.lex_state = 228, .external_lex_state = 25},
  [2142] = {.lex_state = 228, .external_lex_state = 25},
  [2143] = {.lex_state = 212, .external_lex_state = 23},
  [2144] = {.lex_state = 212, .external_lex_state = 23},
  [2145] = {.lex_state = 212, .external_lex_state = 16},
  [2146] = {.lex_state = 222, .external_lex_state = 16},
  [2147] = {.lex_state = 228, .external_lex_state = 25},
  [2148] = {.lex_state = 224, .external_lex_state = 24},
  [2149] = {.lex_state = 224, .external_lex_state = 16},
  [2150] = {.lex_state = 224, .external_lex_state = 24},
  [2151] = {.lex_state = 224, .external_lex_state = 16},
  [2152] = {.lex_state = 224, .external_lex_state = 16},
  [2153] = {.lex_state = 228, .external_lex_state = 25},
  [2154] = {.lex_state = 224, .external_lex_state = 16},
  [2155] = {.lex_state = 224, .external_lex_state = 16},
  [2156] = {.lex_state = 228, .external_lex_state = 25},
  [2157] = {.lex_state = 217, .external_lex_state = 2},
  [2158] = {.lex_state = 71, .external_lex_state = 2},
  [2159] = {.lex_state = 228, .external_lex_state = 25},
  [2160] = {.lex_state = 217, .external_lex_state = 2},
  [2161] = {.lex_state = 198, .external_lex_state = 25},
  [2162] = {.lex_state = 127, .external_lex_state = 11},
  [2163] = {.lex_state = 133, .external_lex_state = 9},
  [2164] = {.lex_state = 142},
  [2165] = {.lex_state = 94},
  [2166] = {.lex_state = 161},
  [2167] = {.lex_state = 175, .external_lex_state = 13},
  [2168] = {.lex_state = 178},
  [2169] = {.lex_state = 78},
  [2170] = {.lex_state = 259, .external_lex_state = 14},
  [2171] = {.lex_state = 106},
  [2172] = {.lex_state = 113},
  [2173] = {.lex_state = 259, .external_lex_state = 14},
  [2174] = {.lex_state = 113, .external_lex_state = 6},
  [2175] = {.lex_state = 71, .external_lex_state = 2},
  [2176] = {.lex_state = 71, .external_lex_state = 2},
  [2177] = {.lex_state = 71, .external_lex_state = 2},
  [2178] = {.lex_state = 78},
  [2179] = {.lex_state = 259, .external_lex_state = 3},
  [2180] = {.lex_state = 259, .external_lex_state = 11},
  [2181] = {.lex_state = 106},
  [2182] = {.lex_state = 113},
  [2183] = {.lex_state = 259, .external_lex_state = 11},
  [2184] = {.lex_state = 113, .external_lex_state = 6},
  [2185] = {.lex_state = 71, .external_lex_state = 2},
  [2186] = {.lex_state = 71, .external_lex_state = 2},
  [2187] = {.lex_state = 71, .external_lex_state = 2},
  [2188] = {.lex_state = 259, .external_lex_state = 4},
  [2189] = {.lex_state = 94},
  [2190] = {.lex_state = 265, .external_lex_state = 5},
  [2191] = {.lex_state = 265, .external_lex_state = 5},
  [2192] = {.lex_state = 181},
  [2193] = {.lex_state = 106},
  [2194] = {.lex_state = 265, .external_lex_state = 5},
  [2195] = {.lex_state = 265, .external_lex_state = 5},
  [2196] = {.lex_state = 265, .external_lex_state = 5},
  [2197] = {.lex_state = 78},
  [2198] = {.lex_state = 187, .external_lex_state = 6},
  [2199] = {.lex_state = 189, .external_lex_state = 16},
  [2200] = {.lex_state = 189, .external_lex_state = 16},
  [2201] = {.lex_state = 163, .external_lex_state = 4},
  [2202] = {.lex_state = 167, .external_lex_state = 8},
  [2203] = {.lex_state = 71, .external_lex_state = 2},
  [2204] = {.lex_state = 98, .external_lex_state = 4},
  [2205] = {.lex_state = 129, .external_lex_state = 8},
  [2206] = {.lex_state = 71, .external_lex_state = 2},
  [2207] = {.lex_state = 163, .external_lex_state = 4},
  [2208] = {.lex_state = 167, .external_lex_state = 8},
  [2209] = {.lex_state = 71, .external_lex_state = 2},
  [2210] = {.lex_state = 78},
  [2211] = {.lex_state = 253, .external_lex_state = 2},
  [2212] = {.lex_state = 71, .external_lex_state = 2},
  [2213] = {.lex_state = 253, .external_lex_state = 2},
  [2214] = {.lex_state = 71, .external_lex_state = 2},
  [2215] = {.lex_state = 71},
  [2216] = {.lex_state = 196, .external_lex_state = 18},
  [2217] = {.lex_state = 94},
  [2218] = {.lex_state = 94},
  [2219] = {.lex_state = 265, .external_lex_state = 5},
  [2220] = {.lex_state = 265, .external_lex_state = 5},
  [2221] = {.lex_state = 271, .external_lex_state = 7},
  [2222] = {.lex_state = 265, .external_lex_state = 7},
  [2223] = {.lex_state = 241},
  [2224] = {.lex_state = 251, .external_lex_state = 4},
  [2225] = {.lex_state = 269, .external_lex_state = 8},
  [2226] = {.lex_state = 253, .external_lex_state = 2},
  [2227] = {.lex_state = 265, .external_lex_state = 7},
  [2228] = {.lex_state = 253, .external_lex_state = 2},
  [2229] = {.lex_state = 253, .external_lex_state = 2},
  [2230] = {.lex_state = 241},
  [2231] = {.lex_state = 251, .external_lex_state = 4},
  [2232] = {.lex_state = 269, .external_lex_state = 8},
  [2233] = {.lex_state = 253, .external_lex_state = 2},
  [2234] = {.lex_state = 217, .external_lex_state = 2},
  [2235] = {.lex_state = 248},
  [2236] = {.lex_state = 217, .external_lex_state = 2},
  [2237] = {.lex_state = 248},
  [2238] = {.lex_state = 169, .external_lex_state = 4},
  [2239] = {.lex_state = 169, .external_lex_state = 4},
  [2240] = {.lex_state = 138, .external_lex_state = 11},
  [2241] = {.lex_state = 138, .external_lex_state = 11},
  [2242] = {.lex_state = 220, .external_lex_state = 25},
  [2243] = {.lex_state = 255, .external_lex_state = 11},
  [2244] = {.lex_state = 175, .external_lex_state = 12},
  [2245] = {.lex_state = 175, .external_lex_state = 12},
  [2246] = {.lex_state = 163, .external_lex_state = 14},
  [2247] = {.lex_state = 163, .external_lex_state = 14},
  [2248] = {.lex_state = 163, .external_lex_state = 11},
  [2249] = {.lex_state = 163, .external_lex_state = 11},
  [2250] = {.lex_state = 94, .external_lex_state = 15},
  [2251] = {.lex_state = 94, .external_lex_state = 15},
  [2252] = {.lex_state = 106, .external_lex_state = 10},
  [2253] = {.lex_state = 106, .external_lex_state = 10},
  [2254] = {.lex_state = 212, .external_lex_state = 23},
  [2255] = {.lex_state = 212, .external_lex_state = 23},
  [2256] = {.lex_state = 212, .external_lex_state = 23},
  [2257] = {.lex_state = 212, .external_lex_state = 23},
  [2258] = {.lex_state = 212, .external_lex_state = 16},
  [2259] = {.lex_state = 224, .external_lex_state = 16},
  [2260] = {.lex_state = 212, .external_lex_state = 23},
  [2261] = {.lex_state = 224, .external_lex_state = 16},
  [2262] = {.lex_state = 224, .external_lex_state = 16},
  [2263] = {.lex_state = 224, .external_lex_state = 16},
  [2264] = {.lex_state = 212, .external_lex_state = 23},
  [2265] = {.lex_state = 224, .external_lex_state = 16},
  [2266] = {.lex_state = 212, .external_lex_state = 23},
  [2267] = {.lex_state = 212, .external_lex_state = 23},
  [2268] = {.lex_state = 224, .external_lex_state = 23},
  [2269] = {.lex_state = 224, .external_lex_state = 23},
  [2270] = {.lex_state = 224, .external_lex_state = 23},
  [2271] = {.lex_state = 224, .external_lex_state = 16},
  [2272] = {.lex_state = 224, .external_lex_state = 16},
  [2273] = {.lex_state = 224, .external_lex_state = 23},
  [2274] = {.lex_state = 226, .external_lex_state = 25},
  [2275] = {.lex_state = 257, .external_lex_state = 11},
  [2276] = {.lex_state = 193, .external_lex_state = 17},
  [2277] = {.lex_state = 193, .external_lex_state = 17},
  [2278] = {.lex_state = 193, .external_lex_state = 17},
  [2279] = {.lex_state = 224, .external_lex_state = 16},
  [2280] = {.lex_state = 224, .external_lex_state = 16},
  [2281] = {.lex_state = 193, .external_lex_state = 17},
  [2282] = {.lex_state = 204, .external_lex_state = 10},
  [2283] = {.lex_state = 204, .external_lex_state = 10},
  [2284] = {.lex_state = 204, .external_lex_state = 10},
  [2285] = {.lex_state = 224, .external_lex_state = 16},
  [2286] = {.lex_state = 224, .external_lex_state = 16},
  [2287] = {.lex_state = 204, .external_lex_state = 10},
  [2288] = {.lex_state = 167, .external_lex_state = 20},
  [2289] = {.lex_state = 167, .external_lex_state = 20},
  [2290] = {.lex_state = 169, .external_lex_state = 4},
  [2291] = {.lex_state = 234, .external_lex_state = 11},
  [2292] = {.lex_state = 234, .external_lex_state = 11},
  [2293] = {.lex_state = 245},
  [2294] = {.lex_state = 236, .external_lex_state = 11},
  [2295] = {.lex_state = 236, .external_lex_state = 11},
  [2296] = {.lex_state = 236, .external_lex_state = 11},
  [2297] = {.lex_state = 224, .external_lex_state = 16},
  [2298] = {.lex_state = 224, .external_lex_state = 16},
  [2299] = {.lex_state = 236, .external_lex_state = 11},
  [2300] = {.lex_state = 238, .external_lex_state = 10},
  [2301] = {.lex_state = 238, .external_lex_state = 10},
  [2302] = {.lex_state = 228, .external_lex_state = 25},
  [2303] = {.lex_state = 228, .external_lex_state = 25},
  [2304] = {.lex_state = 212, .external_lex_state = 23},
  [2305] = {.lex_state = 212, .external_lex_state = 23},
  [2306] = {.lex_state = 212, .external_lex_state = 16},
  [2307] = {.lex_state = 224, .external_lex_state = 16},
  [2308] = {.lex_state = 228, .external_lex_state = 25},
  [2309] = {.lex_state = 224, .external_lex_state = 16},
  [2310] = {.lex_state = 224, .external_lex_state = 16},
  [2311] = {.lex_state = 224, .external_lex_state = 16},
  [2312] = {.lex_state = 228, .external_lex_state = 25},
  [2313] = {.lex_state = 224, .external_lex_state = 16},
  [2314] = {.lex_state = 228, .external_lex_state = 25},
  [2315] = {.lex_state = 228, .external_lex_state = 25},
  [2316] = {.lex_state = 269, .external_lex_state = 8},
  [2317] = {.lex_state = 204},
  [2318] = {.lex_state = 269, .external_lex_state = 20},
  [2319] = {.lex_state = 106},
  [2320] = {.lex_state = 113},
  [2321] = {.lex_state = 269, .external_lex_state = 20},
  [2322] = {.lex_state = 113, .external_lex_state = 6},
  [2323] = {.lex_state = 71, .external_lex_state = 2},
  [2324] = {.lex_state = 71, .external_lex_state = 2},
  [2325] = {.lex_state = 71, .external_lex_state = 2},
  [2326] = {.lex_state = 271, .external_lex_state = 21},
  [2327] = {.lex_state = 271, .external_lex_state = 7},
  [2328] = {.lex_state = 78},
  [2329] = {.lex_state = 273, .external_lex_state = 21},
  [2330] = {.lex_state = 133, .external_lex_state = 9},
  [2331] = {.lex_state = 94},
  [2332] = {.lex_state = 259, .external_lex_state = 14},
  [2333] = {.lex_state = 259, .external_lex_state = 14},
  [2334] = {.lex_state = 181},
  [2335] = {.lex_state = 106},
  [2336] = {.lex_state = 259, .external_lex_state = 14},
  [2337] = {.lex_state = 259, .external_lex_state = 14},
  [2338] = {.lex_state = 259, .external_lex_state = 14},
  [2339] = {.lex_state = 78},
  [2340] = {.lex_state = 187, .external_lex_state = 6},
  [2341] = {.lex_state = 189, .external_lex_state = 16},
  [2342] = {.lex_state = 189, .external_lex_state = 16},
  [2343] = {.lex_state = 163, .external_lex_state = 4},
  [2344] = {.lex_state = 167, .external_lex_state = 8},
  [2345] = {.lex_state = 71, .external_lex_state = 2},
  [2346] = {.lex_state = 98, .external_lex_state = 4},
  [2347] = {.lex_state = 129, .external_lex_state = 8},
  [2348] = {.lex_state = 71, .external_lex_state = 2},
  [2349] = {.lex_state = 163, .external_lex_state = 4},
  [2350] = {.lex_state = 167, .external_lex_state = 8},
  [2351] = {.lex_state = 71, .external_lex_state = 2},
  [2352] = {.lex_state = 259, .external_lex_state = 3},
  [2353] = {.lex_state = 94},
  [2354] = {.lex_state = 259, .external_lex_state = 11},
  [2355] = {.lex_state = 259, .external_lex_state = 11},
  [2356] = {.lex_state = 181},
  [2357] = {.lex_state = 106},
  [2358] = {.lex_state = 259, .external_lex_state = 11},
  [2359] = {.lex_state = 259, .external_lex_state = 11},
  [2360] = {.lex_state = 259, .external_lex_state = 11},
  [2361] = {.lex_state = 78},
  [2362] = {.lex_state = 187, .external_lex_state = 6},
  [2363] = {.lex_state = 189, .external_lex_state = 16},
  [2364] = {.lex_state = 189, .external_lex_state = 16},
  [2365] = {.lex_state = 163, .external_lex_state = 4},
  [2366] = {.lex_state = 167, .external_lex_state = 8},
  [2367] = {.lex_state = 71, .external_lex_state = 2},
  [2368] = {.lex_state = 98, .external_lex_state = 4},
  [2369] = {.lex_state = 129, .external_lex_state = 8},
  [2370] = {.lex_state = 71, .external_lex_state = 2},
  [2371] = {.lex_state = 163, .external_lex_state = 4},
  [2372] = {.lex_state = 167, .external_lex_state = 8},
  [2373] = {.lex_state = 71, .external_lex_state = 2},
  [2374] = {.lex_state = 259, .external_lex_state = 4},
  [2375] = {.lex_state = 265, .external_lex_state = 5},
  [2376] = {.lex_state = 265, .external_lex_state = 5},
  [2377] = {.lex_state = 265, .external_lex_state = 5},
  [2378] = {.lex_state = 181},
  [2379] = {.lex_state = 222, .external_lex_state = 16},
  [2380] = {.lex_state = 78},
  [2381] = {.lex_state = 189, .external_lex_state = 16},
  [2382] = {.lex_state = 189, .external_lex_state = 16},
  [2383] = {.lex_state = 265, .external_lex_state = 5},
  [2384] = {.lex_state = 224, .external_lex_state = 24},
  [2385] = {.lex_state = 224, .external_lex_state = 16},
  [2386] = {.lex_state = 265, .external_lex_state = 5},
  [2387] = {.lex_state = 224, .external_lex_state = 24},
  [2388] = {.lex_state = 224, .external_lex_state = 16},
  [2389] = {.lex_state = 217, .external_lex_state = 2},
  [2390] = {.lex_state = 265, .external_lex_state = 5},
  [2391] = {.lex_state = 163, .external_lex_state = 4},
  [2392] = {.lex_state = 167, .external_lex_state = 8},
  [2393] = {.lex_state = 71, .external_lex_state = 2},
  [2394] = {.lex_state = 98, .external_lex_state = 4},
  [2395] = {.lex_state = 129, .external_lex_state = 8},
  [2396] = {.lex_state = 217, .external_lex_state = 2},
  [2397] = {.lex_state = 265, .external_lex_state = 5},
  [2398] = {.lex_state = 163, .external_lex_state = 4},
  [2399] = {.lex_state = 167, .external_lex_state = 8},
  [2400] = {.lex_state = 161},
  [2401] = {.lex_state = 269, .external_lex_state = 8},
  [2402] = {.lex_state = 251, .external_lex_state = 4},
  [2403] = {.lex_state = 269, .external_lex_state = 8},
  [2404] = {.lex_state = 94},
  [2405] = {.lex_state = 265, .external_lex_state = 7},
  [2406] = {.lex_state = 265, .external_lex_state = 5},
  [2407] = {.lex_state = 265, .external_lex_state = 5},
  [2408] = {.lex_state = 271, .external_lex_state = 5},
  [2409] = {.lex_state = 106},
  [2410] = {.lex_state = 113},
  [2411] = {.lex_state = 271, .external_lex_state = 5},
  [2412] = {.lex_state = 113, .external_lex_state = 6},
  [2413] = {.lex_state = 71, .external_lex_state = 2},
  [2414] = {.lex_state = 71, .external_lex_state = 2},
  [2415] = {.lex_state = 71, .external_lex_state = 2},
  [2416] = {.lex_state = 271, .external_lex_state = 5},
  [2417] = {.lex_state = 271, .external_lex_state = 5},
  [2418] = {.lex_state = 271, .external_lex_state = 7},
  [2419] = {.lex_state = 271, .external_lex_state = 7},
  [2420] = {.lex_state = 265, .external_lex_state = 7},
  [2421] = {.lex_state = 253, .external_lex_state = 2},
  [2422] = {.lex_state = 98, .external_lex_state = 4},
  [2423] = {.lex_state = 129, .external_lex_state = 8},
  [2424] = {.lex_state = 265, .external_lex_state = 7},
  [2425] = {.lex_state = 241},
  [2426] = {.lex_state = 251, .external_lex_state = 4},
  [2427] = {.lex_state = 269, .external_lex_state = 8},
  [2428] = {.lex_state = 253, .external_lex_state = 2},
  [2429] = {.lex_state = 241},
  [2430] = {.lex_state = 251, .external_lex_state = 4},
  [2431] = {.lex_state = 269, .external_lex_state = 8},
  [2432] = {.lex_state = 94},
  [2433] = {.lex_state = 98, .external_lex_state = 4},
  [2434] = {.lex_state = 129, .external_lex_state = 8},
  [2435] = {.lex_state = 217, .external_lex_state = 2},
  [2436] = {.lex_state = 217, .external_lex_state = 2},
  [2437] = {.lex_state = 94},
  [2438] = {.lex_state = 98, .external_lex_state = 4},
  [2439] = {.lex_state = 129, .external_lex_state = 8},
  [2440] = {.lex_state = 217, .external_lex_state = 2},
  [2441] = {.lex_state = 217, .external_lex_state = 2},
  [2442] = {.lex_state = 212, .external_lex_state = 23},
  [2443] = {.lex_state = 212, .external_lex_state = 23},
  [2444] = {.lex_state = 212, .external_lex_state = 23},
  [2445] = {.lex_state = 224, .external_lex_state = 16},
  [2446] = {.lex_state = 224, .external_lex_state = 16},
  [2447] = {.lex_state = 212, .external_lex_state = 23},
  [2448] = {.lex_state = 224, .external_lex_state = 23},
  [2449] = {.lex_state = 224, .external_lex_state = 23},
  [2450] = {.lex_state = 193, .external_lex_state = 17},
  [2451] = {.lex_state = 193, .external_lex_state = 17},
  [2452] = {.lex_state = 204, .external_lex_state = 10},
  [2453] = {.lex_state = 204, .external_lex_state = 10},
  [2454] = {.lex_state = 169, .external_lex_state = 4},
  [2455] = {.lex_state = 236, .external_lex_state = 11},
  [2456] = {.lex_state = 236, .external_lex_state = 11},
  [2457] = {.lex_state = 228, .external_lex_state = 25},
  [2458] = {.lex_state = 228, .external_lex_state = 25},
  [2459] = {.lex_state = 228, .external_lex_state = 25},
  [2460] = {.lex_state = 224, .external_lex_state = 16},
  [2461] = {.lex_state = 224, .external_lex_state = 16},
  [2462] = {.lex_state = 228, .external_lex_state = 25},
  [2463] = {.lex_state = 269, .external_lex_state = 8},
  [2464] = {.lex_state = 204},
  [2465] = {.lex_state = 94},
  [2466] = {.lex_state = 269, .external_lex_state = 20},
  [2467] = {.lex_state = 269, .external_lex_state = 20},
  [2468] = {.lex_state = 181},
  [2469] = {.lex_state = 106},
  [2470] = {.lex_state = 269, .external_lex_state = 20},
  [2471] = {.lex_state = 269, .external_lex_state = 20},
  [2472] = {.lex_state = 269, .external_lex_state = 20},
  [2473] = {.lex_state = 78},
  [2474] = {.lex_state = 187, .external_lex_state = 6},
  [2475] = {.lex_state = 189, .external_lex_state = 16},
  [2476] = {.lex_state = 189, .external_lex_state = 16},
  [2477] = {.lex_state = 163, .external_lex_state = 4},
  [2478] = {.lex_state = 167, .external_lex_state = 8},
  [2479] = {.lex_state = 71, .external_lex_state = 2},
  [2480] = {.lex_state = 98, .external_lex_state = 4},
  [2481] = {.lex_state = 129, .external_lex_state = 8},
  [2482] = {.lex_state = 71, .external_lex_state = 2},
  [2483] = {.lex_state = 163, .external_lex_state = 4},
  [2484] = {.lex_state = 167, .external_lex_state = 8},
  [2485] = {.lex_state = 71, .external_lex_state = 2},
  [2486] = {.lex_state = 71},
  [2487] = {.lex_state = 94},
  [2488] = {.lex_state = 94},
  [2489] = {.lex_state = 271, .external_lex_state = 21},
  [2490] = {.lex_state = 271, .external_lex_state = 7},
  [2491] = {.lex_state = 161},
  [2492] = {.lex_state = 71},
  [2493] = {.lex_state = 94},
  [2494] = {.lex_state = 259, .external_lex_state = 3},
  [2495] = {.lex_state = 204},
  [2496] = {.lex_state = 259, .external_lex_state = 14},
  [2497] = {.lex_state = 259, .external_lex_state = 14},
  [2498] = {.lex_state = 259, .external_lex_state = 14},
  [2499] = {.lex_state = 259, .external_lex_state = 14},
  [2500] = {.lex_state = 259, .external_lex_state = 14},
  [2501] = {.lex_state = 181},
  [2502] = {.lex_state = 222, .external_lex_state = 16},
  [2503] = {.lex_state = 78},
  [2504] = {.lex_state = 189, .external_lex_state = 16},
  [2505] = {.lex_state = 189, .external_lex_state = 16},
  [2506] = {.lex_state = 259, .external_lex_state = 14},
  [2507] = {.lex_state = 224, .external_lex_state = 24},
  [2508] = {.lex_state = 224, .external_lex_state = 16},
  [2509] = {.lex_state = 259, .external_lex_state = 14},
  [2510] = {.lex_state = 224, .external_lex_state = 24},
  [2511] = {.lex_state = 224, .external_lex_state = 16},
  [2512] = {.lex_state = 217, .external_lex_state = 2},
  [2513] = {.lex_state = 259, .external_lex_state = 14},
  [2514] = {.lex_state = 163, .external_lex_state = 4},
  [2515] = {.lex_state = 167, .external_lex_state = 8},
  [2516] = {.lex_state = 71, .external_lex_state = 2},
  [2517] = {.lex_state = 98, .external_lex_state = 4},
  [2518] = {.lex_state = 129, .external_lex_state = 8},
  [2519] = {.lex_state = 217, .external_lex_state = 2},
  [2520] = {.lex_state = 259, .external_lex_state = 14},
  [2521] = {.lex_state = 163, .external_lex_state = 4},
  [2522] = {.lex_state = 167, .external_lex_state = 8},
  [2523] = {.lex_state = 259, .external_lex_state = 11},
  [2524] = {.lex_state = 259, .external_lex_state = 11},
  [2525] = {.lex_state = 259, .external_lex_state = 11},
  [2526] = {.lex_state = 181},
  [2527] = {.lex_state = 222, .external_lex_state = 16},
  [2528] = {.lex_state = 78},
  [2529] = {.lex_state = 189, .external_lex_state = 16},
  [2530] = {.lex_state = 189, .external_lex_state = 16},
  [2531] = {.lex_state = 259, .external_lex_state = 11},
  [2532] = {.lex_state = 224, .external_lex_state = 24},
  [2533] = {.lex_state = 224, .external_lex_state = 16},
  [2534] = {.lex_state = 259, .external_lex_state = 11},
  [2535] = {.lex_state = 224, .external_lex_state = 24},
  [2536] = {.lex_state = 224, .external_lex_state = 16},
  [2537] = {.lex_state = 217, .external_lex_state = 2},
  [2538] = {.lex_state = 259, .external_lex_state = 11},
  [2539] = {.lex_state = 163, .external_lex_state = 4},
  [2540] = {.lex_state = 167, .external_lex_state = 8},
  [2541] = {.lex_state = 71, .external_lex_state = 2},
  [2542] = {.lex_state = 98, .external_lex_state = 4},
  [2543] = {.lex_state = 129, .external_lex_state = 8},
  [2544] = {.lex_state = 217, .external_lex_state = 2},
  [2545] = {.lex_state = 259, .external_lex_state = 11},
  [2546] = {.lex_state = 163, .external_lex_state = 4},
  [2547] = {.lex_state = 167, .external_lex_state = 8},
  [2548] = {.lex_state = 265, .external_lex_state = 5},
  [2549] = {.lex_state = 265, .external_lex_state = 5},
  [2550] = {.lex_state = 212, .external_lex_state = 23},
  [2551] = {.lex_state = 212, .external_lex_state = 23},
  [2552] = {.lex_state = 212, .external_lex_state = 16},
  [2553] = {.lex_state = 222, .external_lex_state = 16},
  [2554] = {.lex_state = 265, .external_lex_state = 5},
  [2555] = {.lex_state = 224, .external_lex_state = 24},
  [2556] = {.lex_state = 224, .external_lex_state = 16},
  [2557] = {.lex_state = 224, .external_lex_state = 24},
  [2558] = {.lex_state = 224, .external_lex_state = 16},
  [2559] = {.lex_state = 224, .external_lex_state = 16},
  [2560] = {.lex_state = 265, .external_lex_state = 5},
  [2561] = {.lex_state = 224, .external_lex_state = 16},
  [2562] = {.lex_state = 224, .external_lex_state = 16},
  [2563] = {.lex_state = 265, .external_lex_state = 5},
  [2564] = {.lex_state = 217, .external_lex_state = 2},
  [2565] = {.lex_state = 71, .external_lex_state = 2},
  [2566] = {.lex_state = 265, .external_lex_state = 5},
  [2567] = {.lex_state = 217, .external_lex_state = 2},
  [2568] = {.lex_state = 273, .external_lex_state = 21},
  [2569] = {.lex_state = 271, .external_lex_state = 5},
  [2570] = {.lex_state = 271, .external_lex_state = 5},
  [2571] = {.lex_state = 94},
  [2572] = {.lex_state = 271, .external_lex_state = 5},
  [2573] = {.lex_state = 271, .external_lex_state = 5},
  [2574] = {.lex_state = 181},
  [2575] = {.lex_state = 106},
  [2576] = {.lex_state = 271, .external_lex_state = 5},
  [2577] = {.lex_state = 271, .external_lex_state = 5},
  [2578] = {.lex_state = 271, .external_lex_state = 5},
  [2579] = {.lex_state = 78},
  [2580] = {.lex_state = 187, .external_lex_state = 6},
  [2581] = {.lex_state = 189, .external_lex_state = 16},
  [2582] = {.lex_state = 189, .external_lex_state = 16},
  [2583] = {.lex_state = 163, .external_lex_state = 4},
  [2584] = {.lex_state = 167, .external_lex_state = 8},
  [2585] = {.lex_state = 71, .external_lex_state = 2},
  [2586] = {.lex_state = 98, .external_lex_state = 4},
  [2587] = {.lex_state = 129, .external_lex_state = 8},
  [2588] = {.lex_state = 71, .external_lex_state = 2},
  [2589] = {.lex_state = 163, .external_lex_state = 4},
  [2590] = {.lex_state = 167, .external_lex_state = 8},
  [2591] = {.lex_state = 71, .external_lex_state = 2},
  [2592] = {.lex_state = 271, .external_lex_state = 7},
  [2593] = {.lex_state = 253, .external_lex_state = 2},
  [2594] = {.lex_state = 253, .external_lex_state = 2},
  [2595] = {.lex_state = 217, .external_lex_state = 2},
  [2596] = {.lex_state = 94},
  [2597] = {.lex_state = 98, .external_lex_state = 4},
  [2598] = {.lex_state = 129, .external_lex_state = 8},
  [2599] = {.lex_state = 217, .external_lex_state = 2},
  [2600] = {.lex_state = 217, .external_lex_state = 2},
  [2601] = {.lex_state = 217, .external_lex_state = 2},
  [2602] = {.lex_state = 94},
  [2603] = {.lex_state = 98, .external_lex_state = 4},
  [2604] = {.lex_state = 129, .external_lex_state = 8},
  [2605] = {.lex_state = 217, .external_lex_state = 2},
  [2606] = {.lex_state = 212, .external_lex_state = 23},
  [2607] = {.lex_state = 212, .external_lex_state = 23},
  [2608] = {.lex_state = 228, .external_lex_state = 25},
  [2609] = {.lex_state = 228, .external_lex_state = 25},
  [2610] = {.lex_state = 269, .external_lex_state = 8},
  [2611] = {.lex_state = 269, .external_lex_state = 20},
  [2612] = {.lex_state = 269, .external_lex_state = 20},
  [2613] = {.lex_state = 269, .external_lex_state = 20},
  [2614] = {.lex_state = 181},
  [2615] = {.lex_state = 222, .external_lex_state = 16},
  [2616] = {.lex_state = 78},
  [2617] = {.lex_state = 189, .external_lex_state = 16},
  [2618] = {.lex_state = 189, .external_lex_state = 16},
  [2619] = {.lex_state = 269, .external_lex_state = 20},
  [2620] = {.lex_state = 224, .external_lex_state = 24},
  [2621] = {.lex_state = 224, .external_lex_state = 16},
  [2622] = {.lex_state = 269, .external_lex_state = 20},
  [2623] = {.lex_state = 224, .external_lex_state = 24},
  [2624] = {.lex_state = 224, .external_lex_state = 16},
  [2625] = {.lex_state = 217, .external_lex_state = 2},
  [2626] = {.lex_state = 269, .external_lex_state = 20},
  [2627] = {.lex_state = 163, .external_lex_state = 4},
  [2628] = {.lex_state = 167, .external_lex_state = 8},
  [2629] = {.lex_state = 71, .external_lex_state = 2},
  [2630] = {.lex_state = 98, .external_lex_state = 4},
  [2631] = {.lex_state = 129, .external_lex_state = 8},
  [2632] = {.lex_state = 217, .external_lex_state = 2},
  [2633] = {.lex_state = 269, .external_lex_state = 20},
  [2634] = {.lex_state = 163, .external_lex_state = 4},
  [2635] = {.lex_state = 167, .external_lex_state = 8},
  [2636] = {.lex_state = 94},
  [2637] = {.lex_state = 271, .external_lex_state = 25},
  [2638] = {.lex_state = 271, .external_lex_state = 25},
  [2639] = {.lex_state = 271, .external_lex_state = 25},
  [2640] = {.lex_state = 271, .external_lex_state = 25},
  [2641] = {.lex_state = 271, .external_lex_state = 21},
  [2642] = {.lex_state = 273, .external_lex_state = 21},
  [2643] = {.lex_state = 94},
  [2644] = {.lex_state = 251, .external_lex_state = 11},
  [2645] = {.lex_state = 251, .external_lex_state = 11},
  [2646] = {.lex_state = 259, .external_lex_state = 3},
  [2647] = {.lex_state = 204},
  [2648] = {.lex_state = 259, .external_lex_state = 14},
  [2649] = {.lex_state = 259, .external_lex_state = 14},
  [2650] = {.lex_state = 212, .external_lex_state = 23},
  [2651] = {.lex_state = 212, .external_lex_state = 23},
  [2652] = {.lex_state = 212, .external_lex_state = 16},
  [2653] = {.lex_state = 222, .external_lex_state = 16},
  [2654] = {.lex_state = 259, .external_lex_state = 14},
  [2655] = {.lex_state = 224, .external_lex_state = 24},
  [2656] = {.lex_state = 224, .external_lex_state = 16},
  [2657] = {.lex_state = 224, .external_lex_state = 24},
  [2658] = {.lex_state = 224, .external_lex_state = 16},
  [2659] = {.lex_state = 224, .external_lex_state = 16},
  [2660] = {.lex_state = 259, .external_lex_state = 14},
  [2661] = {.lex_state = 224, .external_lex_state = 16},
  [2662] = {.lex_state = 224, .external_lex_state = 16},
  [2663] = {.lex_state = 259, .external_lex_state = 14},
  [2664] = {.lex_state = 217, .external_lex_state = 2},
  [2665] = {.lex_state = 71, .external_lex_state = 2},
  [2666] = {.lex_state = 259, .external_lex_state = 14},
  [2667] = {.lex_state = 217, .external_lex_state = 2},
  [2668] = {.lex_state = 259, .external_lex_state = 11},
  [2669] = {.lex_state = 259, .external_lex_state = 11},
  [2670] = {.lex_state = 212, .external_lex_state = 23},
  [2671] = {.lex_state = 212, .external_lex_state = 23},
  [2672] = {.lex_state = 212, .external_lex_state = 16},
  [2673] = {.lex_state = 222, .external_lex_state = 16},
  [2674] = {.lex_state = 259, .external_lex_state = 11},
  [2675] = {.lex_state = 224, .external_lex_state = 24},
  [2676] = {.lex_state = 224, .external_lex_state = 16},
  [2677] = {.lex_state = 224, .external_lex_state = 24},
  [2678] = {.lex_state = 224, .external_lex_state = 16},
  [2679] = {.lex_state = 224, .external_lex_state = 16},
  [2680] = {.lex_state = 259, .external_lex_state = 11},
  [2681] = {.lex_state = 224, .external_lex_state = 16},
  [2682] = {.lex_state = 224, .external_lex_state = 16},
  [2683] = {.lex_state = 259, .external_lex_state = 11},
  [2684] = {.lex_state = 217, .external_lex_state = 2},
  [2685] = {.lex_state = 71, .external_lex_state = 2},
  [2686] = {.lex_state = 259, .external_lex_state = 11},
  [2687] = {.lex_state = 217, .external_lex_state = 2},
  [2688] = {.lex_state = 265, .external_lex_state = 5},
  [2689] = {.lex_state = 265, .external_lex_state = 5},
  [2690] = {.lex_state = 212, .external_lex_state = 23},
  [2691] = {.lex_state = 212, .external_lex_state = 23},
  [2692] = {.lex_state = 212, .external_lex_state = 16},
  [2693] = {.lex_state = 224, .external_lex_state = 16},
  [2694] = {.lex_state = 265, .external_lex_state = 5},
  [2695] = {.lex_state = 224, .external_lex_state = 16},
  [2696] = {.lex_state = 224, .external_lex_state = 16},
  [2697] = {.lex_state = 224, .external_lex_state = 16},
  [2698] = {.lex_state = 265, .external_lex_state = 5},
  [2699] = {.lex_state = 224, .external_lex_state = 16},
  [2700] = {.lex_state = 265, .external_lex_state = 5},
  [2701] = {.lex_state = 265, .external_lex_state = 5},
  [2702] = {.lex_state = 271, .external_lex_state = 5},
  [2703] = {.lex_state = 271, .external_lex_state = 5},
  [2704] = {.lex_state = 271, .external_lex_state = 5},
  [2705] = {.lex_state = 181},
  [2706] = {.lex_state = 222, .external_lex_state = 16},
  [2707] = {.lex_state = 78},
  [2708] = {.lex_state = 189, .external_lex_state = 16},
  [2709] = {.lex_state = 189, .external_lex_state = 16},
  [2710] = {.lex_state = 271, .external_lex_state = 5},
  [2711] = {.lex_state = 224, .external_lex_state = 24},
  [2712] = {.lex_state = 224, .external_lex_state = 16},
  [2713] = {.lex_state = 271, .external_lex_state = 5},
  [2714] = {.lex_state = 224, .external_lex_state = 24},
  [2715] = {.lex_state = 224, .external_lex_state = 16},
  [2716] = {.lex_state = 217, .external_lex_state = 2},
  [2717] = {.lex_state = 271, .external_lex_state = 5},
  [2718] = {.lex_state = 163, .external_lex_state = 4},
  [2719] = {.lex_state = 167, .external_lex_state = 8},
  [2720] = {.lex_state = 71, .external_lex_state = 2},
  [2721] = {.lex_state = 98, .external_lex_state = 4},
  [2722] = {.lex_state = 129, .external_lex_state = 8},
  [2723] = {.lex_state = 217, .external_lex_state = 2},
  [2724] = {.lex_state = 271, .external_lex_state = 5},
  [2725] = {.lex_state = 163, .external_lex_state = 4},
  [2726] = {.lex_state = 167, .external_lex_state = 8},
  [2727] = {.lex_state = 217, .external_lex_state = 2},
  [2728] = {.lex_state = 94},
  [2729] = {.lex_state = 98, .external_lex_state = 4},
  [2730] = {.lex_state = 129, .external_lex_state = 8},
  [2731] = {.lex_state = 217, .external_lex_state = 2},
  [2732] = {.lex_state = 94},
  [2733] = {.lex_state = 98, .external_lex_state = 4},
  [2734] = {.lex_state = 129, .external_lex_state = 8},
  [2735] = {.lex_state = 269, .external_lex_state = 20},
  [2736] = {.lex_state = 269, .external_lex_state = 20},
  [2737] = {.lex_state = 212, .external_lex_state = 23},
  [2738] = {.lex_state = 212, .external_lex_state = 23},
  [2739] = {.lex_state = 212, .external_lex_state = 16},
  [2740] = {.lex_state = 222, .external_lex_state = 16},
  [2741] = {.lex_state = 269, .external_lex_state = 20},
  [2742] = {.lex_state = 224, .external_lex_state = 24},
  [2743] = {.lex_state = 224, .external_lex_state = 16},
  [2744] = {.lex_state = 224, .external_lex_state = 24},
  [2745] = {.lex_state = 224, .external_lex_state = 16},
  [2746] = {.lex_state = 224, .external_lex_state = 16},
  [2747] = {.lex_state = 269, .external_lex_state = 20},
  [2748] = {.lex_state = 224, .external_lex_state = 16},
  [2749] = {.lex_state = 224, .external_lex_state = 16},
  [2750] = {.lex_state = 269, .external_lex_state = 20},
  [2751] = {.lex_state = 217, .external_lex_state = 2},
  [2752] = {.lex_state = 71, .external_lex_state = 2},
  [2753] = {.lex_state = 269, .external_lex_state = 20},
  [2754] = {.lex_state = 217, .external_lex_state = 2},
  [2755] = {.lex_state = 271, .external_lex_state = 25},
  [2756] = {.lex_state = 271, .external_lex_state = 25},
  [2757] = {.lex_state = 271, .external_lex_state = 25},
  [2758] = {.lex_state = 251, .external_lex_state = 11},
  [2759] = {.lex_state = 251, .external_lex_state = 11},
  [2760] = {.lex_state = 251, .external_lex_state = 11},
  [2761] = {.lex_state = 259, .external_lex_state = 3},
  [2762] = {.lex_state = 259, .external_lex_state = 14},
  [2763] = {.lex_state = 259, .external_lex_state = 14},
  [2764] = {.lex_state = 212, .external_lex_state = 23},
  [2765] = {.lex_state = 212, .external_lex_state = 23},
  [2766] = {.lex_state = 212, .external_lex_state = 16},
  [2767] = {.lex_state = 224, .external_lex_state = 16},
  [2768] = {.lex_state = 259, .external_lex_state = 14},
  [2769] = {.lex_state = 224, .external_lex_state = 16},
  [2770] = {.lex_state = 224, .external_lex_state = 16},
  [2771] = {.lex_state = 224, .external_lex_state = 16},
  [2772] = {.lex_state = 259, .external_lex_state = 14},
  [2773] = {.lex_state = 224, .external_lex_state = 16},
  [2774] = {.lex_state = 259, .external_lex_state = 14},
  [2775] = {.lex_state = 259, .external_lex_state = 14},
  [2776] = {.lex_state = 259, .external_lex_state = 11},
  [2777] = {.lex_state = 259, .external_lex_state = 11},
  [2778] = {.lex_state = 212, .external_lex_state = 23},
  [2779] = {.lex_state = 212, .external_lex_state = 23},
  [2780] = {.lex_state = 212, .external_lex_state = 16},
  [2781] = {.lex_state = 224, .external_lex_state = 16},
  [2782] = {.lex_state = 259, .external_lex_state = 11},
  [2783] = {.lex_state = 224, .external_lex_state = 16},
  [2784] = {.lex_state = 224, .external_lex_state = 16},
  [2785] = {.lex_state = 224, .external_lex_state = 16},
  [2786] = {.lex_state = 259, .external_lex_state = 11},
  [2787] = {.lex_state = 224, .external_lex_state = 16},
  [2788] = {.lex_state = 259, .external_lex_state = 11},
  [2789] = {.lex_state = 259, .external_lex_state = 11},
  [2790] = {.lex_state = 265, .external_lex_state = 5},
  [2791] = {.lex_state = 265, .external_lex_state = 5},
  [2792] = {.lex_state = 265, .external_lex_state = 5},
  [2793] = {.lex_state = 224, .external_lex_state = 16},
  [2794] = {.lex_state = 224, .external_lex_state = 16},
  [2795] = {.lex_state = 265, .external_lex_state = 5},
  [2796] = {.lex_state = 271, .external_lex_state = 5},
  [2797] = {.lex_state = 271, .external_lex_state = 5},
  [2798] = {.lex_state = 212, .external_lex_state = 23},
  [2799] = {.lex_state = 212, .external_lex_state = 23},
  [2800] = {.lex_state = 212, .external_lex_state = 16},
  [2801] = {.lex_state = 222, .external_lex_state = 16},
  [2802] = {.lex_state = 271, .external_lex_state = 5},
  [2803] = {.lex_state = 224, .external_lex_state = 24},
  [2804] = {.lex_state = 224, .external_lex_state = 16},
  [2805] = {.lex_state = 224, .external_lex_state = 24},
  [2806] = {.lex_state = 224, .external_lex_state = 16},
  [2807] = {.lex_state = 224, .external_lex_state = 16},
  [2808] = {.lex_state = 271, .external_lex_state = 5},
  [2809] = {.lex_state = 224, .external_lex_state = 16},
  [2810] = {.lex_state = 224, .external_lex_state = 16},
  [2811] = {.lex_state = 271, .external_lex_state = 5},
  [2812] = {.lex_state = 217, .external_lex_state = 2},
  [2813] = {.lex_state = 71, .external_lex_state = 2},
  [2814] = {.lex_state = 271, .external_lex_state = 5},
  [2815] = {.lex_state = 217, .external_lex_state = 2},
  [2816] = {.lex_state = 217, .external_lex_state = 2},
  [2817] = {.lex_state = 217, .external_lex_state = 2},
  [2818] = {.lex_state = 269, .external_lex_state = 20},
  [2819] = {.lex_state = 269, .external_lex_state = 20},
  [2820] = {.lex_state = 212, .external_lex_state = 23},
  [2821] = {.lex_state = 212, .external_lex_state = 23},
  [2822] = {.lex_state = 212, .external_lex_state = 16},
  [2823] = {.lex_state = 224, .external_lex_state = 16},
  [2824] = {.lex_state = 269, .external_lex_state = 20},
  [2825] = {.lex_state = 224, .external_lex_state = 16},
  [2826] = {.lex_state = 224, .external_lex_state = 16},
  [2827] = {.lex_state = 224, .external_lex_state = 16},
  [2828] = {.lex_state = 269, .external_lex_state = 20},
  [2829] = {.lex_state = 224, .external_lex_state = 16},
  [2830] = {.lex_state = 269, .external_lex_state = 20},
  [2831] = {.lex_state = 269, .external_lex_state = 20},
  [2832] = {.lex_state = 271, .external_lex_state = 25},
  [2833] = {.lex_state = 251, .external_lex_state = 11},
  [2834] = {.lex_state = 259, .external_lex_state = 14},
  [2835] = {.lex_state = 259, .external_lex_state = 14},
  [2836] = {.lex_state = 259, .external_lex_state = 14},
  [2837] = {.lex_state = 224, .external_lex_state = 16},
  [2838] = {.lex_state = 224, .external_lex_state = 16},
  [2839] = {.lex_state = 259, .external_lex_state = 14},
  [2840] = {.lex_state = 259, .external_lex_state = 11},
  [2841] = {.lex_state = 259, .external_lex_state = 11},
  [2842] = {.lex_state = 259, .external_lex_state = 11},
  [2843] = {.lex_state = 224, .external_lex_state = 16},
  [2844] = {.lex_state = 224, .external_lex_state = 16},
  [2845] = {.lex_state = 259, .external_lex_state = 11},
  [2846] = {.lex_state = 265, .external_lex_state = 5},
  [2847] = {.lex_state = 265, .external_lex_state = 5},
  [2848] = {.lex_state = 271, .external_lex_state = 5},
  [2849] = {.lex_state = 271, .external_lex_state = 5},
  [2850] = {.lex_state = 212, .external_lex_state = 23},
  [2851] = {.lex_state = 212, .external_lex_state = 23},
  [2852] = {.lex_state = 212, .external_lex_state = 16},
  [2853] = {.lex_state = 224, .external_lex_state = 16},
  [2854] = {.lex_state = 271, .external_lex_state = 5},
  [2855] = {.lex_state = 224, .external_lex_state = 16},
  [2856] = {.lex_state = 224, .external_lex_state = 16},
  [2857] = {.lex_state = 224, .external_lex_state = 16},
  [2858] = {.lex_state = 271, .external_lex_state = 5},
  [2859] = {.lex_state = 224, .external_lex_state = 16},
  [2860] = {.lex_state = 271, .external_lex_state = 5},
  [2861] = {.lex_state = 271, .external_lex_state = 5},
  [2862] = {.lex_state = 269, .external_lex_state = 20},
  [2863] = {.lex_state = 269, .external_lex_state = 20},
  [2864] = {.lex_state = 269, .external_lex_state = 20},
  [2865] = {.lex_state = 224, .external_lex_state = 16},
  [2866] = {.lex_state = 224, .external_lex_state = 16},
  [2867] = {.lex_state = 269, .external_lex_state = 20},
  [2868] = {.lex_state = 259, .external_lex_state = 14},
  [2869] = {.lex_state = 259, .external_lex_state = 14},
  [2870] = {.lex_state = 259, .external_lex_state = 11},
  [2871] = {.lex_state = 259, .external_lex_state = 11},
  [2872] = {.lex_state = 271, .external_lex_state = 5},
  [2873] = {.lex_state = 271, .external_lex_state = 5},
  [2874] = {.lex_state = 271, .external_lex_state = 5},
  [2875] = {.lex_state = 224, .external_lex_state = 16},
  [2876] = {.lex_state = 224, .external_lex_state = 16},
  [2877] = {.lex_state = 271, .external_lex_state = 5},
  [2878] = {.lex_state = 269, .external_lex_state = 20},
  [2879] = {.lex_state = 269, .external_lex_state = 20},
  [2880] = {.lex_state = 271, .external_lex_state = 5},
  [2881] = {.lex_state = 271, .external_lex_state = 5},
};

enum {
  ts_external_token_heredoc_start,
  ts_external_token__simple_heredoc_body,
  ts_external_token__heredoc_body_beginning,
  ts_external_token__heredoc_body_middle,
  ts_external_token__heredoc_body_end,
  ts_external_token_file_descriptor,
  ts_external_token__empty_value,
  ts_external_token__concat,
  ts_external_token_variable_name,
  ts_external_token_regex,
  ts_external_token_RBRACE,
  ts_external_token_RBRACK,
  ts_external_token_LF,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_regex] = sym_regex,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LF] = anon_sym_LF,
};

static bool ts_external_scanner_states[26][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_LF] = true,
  },
  [2] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [3] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [4] = {
    [ts_external_token_LF] = true,
  },
  [5] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token_variable_name] = true,
  },
  [7] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LF] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [9] = {
    [ts_external_token__empty_value] = true,
  },
  [10] = {
    [ts_external_token__concat] = true,
  },
  [11] = {
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [12] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [13] = {
    [ts_external_token_RBRACK] = true,
  },
  [14] = {
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [15] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [16] = {
    [ts_external_token_RBRACE] = true,
  },
  [17] = {
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
  },
  [18] = {
    [ts_external_token_regex] = true,
  },
  [19] = {
    [ts_external_token_heredoc_start] = true,
  },
  [20] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [21] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LF] = true,
  },
  [22] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [23] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
  },
  [24] = {
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
  },
  [25] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
};

static uint16_t ts_parse_table[STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_heredoc_start] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [sym_regex] = ACTIONS(1),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(3),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(3),
    [anon_sym_done] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_fi] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_esac] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(3),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_typeset] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(3),
    [anon_sym_unsetenv] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(3),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(3),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(3),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(3),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(3),
    [anon_sym_DASH] = ACTIONS(3),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym__special_characters] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(3),
    [sym_raw_string] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(3),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [sym_test_operator] = ACTIONS(1),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(26),
    [sym__terminated_statement] = STATE(32),
    [sym_for_statement] = STATE(27),
    [sym_c_style_for_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_function_definition] = STATE(27),
    [sym_subshell] = STATE(27),
    [sym_pipeline] = STATE(27),
    [sym_list] = STATE(27),
    [sym_negated_command] = STATE(27),
    [sym_test_command] = STATE(27),
    [sym_declaration_command] = STATE(27),
    [sym_unset_command] = STATE(27),
    [sym_command] = STATE(27),
    [sym_command_name] = STATE(28),
    [sym_variable_assignment] = STATE(29),
    [sym_subscript] = STATE(30),
    [sym_file_redirect] = STATE(33),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(20),
    [sym_simple_expansion] = STATE(20),
    [sym_string_expansion] = STATE(20),
    [sym_expansion] = STATE(20),
    [sym_command_substitution] = STATE(20),
    [sym_process_substitution] = STATE(20),
    [aux_sym__statements_repeat1] = STATE(32),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(29),
    [anon_sym_declare] = ACTIONS(31),
    [anon_sym_typeset] = ACTIONS(31),
    [anon_sym_export] = ACTIONS(31),
    [anon_sym_readonly] = ACTIONS(31),
    [anon_sym_local] = ACTIONS(31),
    [anon_sym_unset] = ACTIONS(33),
    [anon_sym_unsetenv] = ACTIONS(33),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(57),
  },
  [2] = {
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_AMP_GT] = ACTIONS(59),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [sym_comment] = ACTIONS(55),
  },
  [3] = {
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_PLUS_EQ] = ACTIONS(65),
    [sym_comment] = ACTIONS(55),
  },
  [4] = {
    [anon_sym_LPAREN_LPAREN] = ACTIONS(67),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(69),
  },
  [5] = {
    [sym__expression] = STATE(49),
    [sym_binary_expression] = STATE(49),
    [sym_unary_expression] = STATE(49),
    [sym_postfix_expression] = STATE(49),
    [sym_parenthesized_expression] = STATE(49),
    [sym_concatenation] = STATE(49),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [6] = {
    [sym__terminated_statement] = STATE(62),
    [sym_for_statement] = STATE(63),
    [sym_c_style_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_case_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_subshell] = STATE(63),
    [sym_pipeline] = STATE(63),
    [sym_list] = STATE(63),
    [sym_negated_command] = STATE(63),
    [sym_test_command] = STATE(63),
    [sym_declaration_command] = STATE(63),
    [sym_unset_command] = STATE(63),
    [sym_command] = STATE(63),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(65),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [7] = {
    [sym__terminated_statement] = STATE(68),
    [sym_for_statement] = STATE(63),
    [sym_c_style_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_case_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_subshell] = STATE(63),
    [sym_pipeline] = STATE(63),
    [sym_list] = STATE(63),
    [sym_negated_command] = STATE(63),
    [sym_test_command] = STATE(63),
    [sym_declaration_command] = STATE(63),
    [sym_unset_command] = STATE(63),
    [sym_command] = STATE(63),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(65),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [8] = {
    [sym_concatenation] = STATE(77),
    [sym_string] = STATE(72),
    [sym_simple_expansion] = STATE(72),
    [sym_string_expansion] = STATE(72),
    [sym_expansion] = STATE(72),
    [sym_command_substitution] = STATE(72),
    [sym_process_substitution] = STATE(72),
    [sym__special_characters] = ACTIONS(119),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_DOLLAR] = ACTIONS(123),
    [sym_raw_string] = ACTIONS(125),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(127),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LT_LPAREN] = ACTIONS(133),
    [anon_sym_GT_LPAREN] = ACTIONS(133),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(125),
  },
  [9] = {
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(135),
  },
  [10] = {
    [sym__terminated_statement] = STATE(95),
    [sym_for_statement] = STATE(91),
    [sym_c_style_for_statement] = STATE(91),
    [sym_while_statement] = STATE(91),
    [sym_if_statement] = STATE(91),
    [sym_case_statement] = STATE(91),
    [sym_function_definition] = STATE(91),
    [sym_subshell] = STATE(91),
    [sym_pipeline] = STATE(91),
    [sym_list] = STATE(91),
    [sym_negated_command] = STATE(91),
    [sym_test_command] = STATE(91),
    [sym_declaration_command] = STATE(91),
    [sym_unset_command] = STATE(91),
    [sym_command] = STATE(91),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(93),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(95),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [11] = {
    [sym_subshell] = STATE(98),
    [sym_test_command] = STATE(98),
    [sym_command] = STATE(98),
    [sym_command_name] = STATE(28),
    [sym_variable_assignment] = STATE(33),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(33),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(20),
    [sym_simple_expansion] = STATE(20),
    [sym_string_expansion] = STATE(20),
    [sym_expansion] = STATE(20),
    [sym_command_substitution] = STATE(20),
    [sym_process_substitution] = STATE(20),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(29),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(45),
  },
  [12] = {
    [sym__expression] = STATE(110),
    [sym_binary_expression] = STATE(110),
    [sym_unary_expression] = STATE(110),
    [sym_postfix_expression] = STATE(110),
    [sym_parenthesized_expression] = STATE(110),
    [sym_concatenation] = STATE(110),
    [sym_string] = STATE(105),
    [sym_simple_expansion] = STATE(105),
    [sym_string_expansion] = STATE(105),
    [sym_expansion] = STATE(105),
    [sym_command_substitution] = STATE(105),
    [sym_process_substitution] = STATE(105),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [sym__special_characters] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(183),
    [sym_test_operator] = ACTIONS(185),
  },
  [13] = {
    [sym__expression] = STATE(114),
    [sym_binary_expression] = STATE(114),
    [sym_unary_expression] = STATE(114),
    [sym_postfix_expression] = STATE(114),
    [sym_parenthesized_expression] = STATE(114),
    [sym_concatenation] = STATE(114),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(187),
    [sym__special_characters] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(193),
    [sym_test_operator] = ACTIONS(195),
  },
  [14] = {
    [sym_variable_assignment] = STATE(125),
    [sym_subscript] = STATE(124),
    [sym_concatenation] = STATE(125),
    [sym_string] = STATE(119),
    [sym_simple_expansion] = STATE(119),
    [sym_string_expansion] = STATE(119),
    [sym_expansion] = STATE(119),
    [sym_command_substitution] = STATE(119),
    [sym_process_substitution] = STATE(119),
    [aux_sym_declaration_command_repeat1] = STATE(125),
    [sym_variable_name] = ACTIONS(197),
    [ts_builtin_sym_end] = ACTIONS(199),
    [anon_sym_SEMI] = ACTIONS(201),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_SEMI_SEMI] = ACTIONS(199),
    [anon_sym_PIPE_AMP] = ACTIONS(199),
    [anon_sym_AMP_AMP] = ACTIONS(199),
    [anon_sym_PIPE_PIPE] = ACTIONS(199),
    [sym__special_characters] = ACTIONS(203),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(209),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(219),
    [sym_word] = ACTIONS(221),
    [anon_sym_LF] = ACTIONS(199),
    [anon_sym_AMP] = ACTIONS(201),
  },
  [15] = {
    [sym_concatenation] = STATE(134),
    [sym_string] = STATE(129),
    [sym_simple_expansion] = STATE(129),
    [sym_string_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [sym_process_substitution] = STATE(129),
    [aux_sym_unset_command_repeat1] = STATE(134),
    [ts_builtin_sym_end] = ACTIONS(223),
    [anon_sym_SEMI] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_SEMI_SEMI] = ACTIONS(223),
    [anon_sym_PIPE_AMP] = ACTIONS(223),
    [anon_sym_AMP_AMP] = ACTIONS(223),
    [anon_sym_PIPE_PIPE] = ACTIONS(223),
    [sym__special_characters] = ACTIONS(227),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(233),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(243),
    [sym_word] = ACTIONS(245),
    [anon_sym_LF] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(225),
  },
  [16] = {
    [sym_concatenation] = STATE(143),
    [sym_string] = STATE(138),
    [sym_simple_expansion] = STATE(138),
    [sym_string_expansion] = STATE(138),
    [sym_expansion] = STATE(138),
    [sym_command_substitution] = STATE(138),
    [sym_process_substitution] = STATE(138),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(251),
    [sym_raw_string] = ACTIONS(253),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(255),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(257),
    [anon_sym_BQUOTE] = ACTIONS(259),
    [anon_sym_LT_LPAREN] = ACTIONS(261),
    [anon_sym_GT_LPAREN] = ACTIONS(261),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(253),
  },
  [17] = {
    [aux_sym_concatenation_repeat1] = STATE(145),
    [sym__simple_heredoc_body] = ACTIONS(263),
    [sym__heredoc_body_beginning] = ACTIONS(263),
    [sym_file_descriptor] = ACTIONS(263),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(263),
    [anon_sym_SEMI] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_SEMI_SEMI] = ACTIONS(263),
    [anon_sym_PIPE_AMP] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_EQ_TILDE] = ACTIONS(267),
    [anon_sym_EQ_EQ] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_GT_GT] = ACTIONS(263),
    [anon_sym_AMP_GT] = ACTIONS(267),
    [anon_sym_AMP_GT_GT] = ACTIONS(263),
    [anon_sym_LT_AMP] = ACTIONS(263),
    [anon_sym_GT_AMP] = ACTIONS(263),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_LT] = ACTIONS(263),
    [sym__special_characters] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(263),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym_raw_string] = ACTIONS(263),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(263),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(263),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [anon_sym_LT_LPAREN] = ACTIONS(263),
    [anon_sym_GT_LPAREN] = ACTIONS(263),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(267),
    [anon_sym_LF] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(267),
  },
  [18] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(152),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [anon_sym_DOLLAR] = ACTIONS(271),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [19] = {
    [sym_string] = STATE(154),
    [anon_sym_DASH] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(283),
    [sym_raw_string] = ACTIONS(285),
    [anon_sym_POUND] = ACTIONS(283),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(287),
    [anon_sym_STAR] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_0] = ACTIONS(287),
    [anon_sym__] = ACTIONS(287),
  },
  [20] = {
    [aux_sym_concatenation_repeat1] = STATE(145),
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(291),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [21] = {
    [sym_subscript] = STATE(159),
    [sym_variable_name] = ACTIONS(295),
    [anon_sym_BANG] = ACTIONS(297),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_POUND] = ACTIONS(297),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(301),
    [anon_sym_STAR] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(303),
    [anon_sym_QMARK] = ACTIONS(303),
    [anon_sym_0] = ACTIONS(301),
    [anon_sym__] = ACTIONS(301),
  },
  [22] = {
    [sym__terminated_statement] = STATE(162),
    [sym_for_statement] = STATE(160),
    [sym_c_style_for_statement] = STATE(160),
    [sym_while_statement] = STATE(160),
    [sym_if_statement] = STATE(160),
    [sym_case_statement] = STATE(160),
    [sym_function_definition] = STATE(160),
    [sym_subshell] = STATE(160),
    [sym_pipeline] = STATE(160),
    [sym_list] = STATE(160),
    [sym_negated_command] = STATE(160),
    [sym_test_command] = STATE(160),
    [sym_declaration_command] = STATE(160),
    [sym_unset_command] = STATE(160),
    [sym_command] = STATE(160),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(161),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(162),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [23] = {
    [sym__terminated_statement] = STATE(175),
    [sym_for_statement] = STATE(172),
    [sym_c_style_for_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_function_definition] = STATE(172),
    [sym_subshell] = STATE(172),
    [sym_pipeline] = STATE(172),
    [sym_list] = STATE(172),
    [sym_negated_command] = STATE(172),
    [sym_test_command] = STATE(172),
    [sym_declaration_command] = STATE(172),
    [sym_unset_command] = STATE(172),
    [sym_command] = STATE(172),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(174),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(175),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [24] = {
    [sym__terminated_statement] = STATE(179),
    [sym_for_statement] = STATE(177),
    [sym_c_style_for_statement] = STATE(177),
    [sym_while_statement] = STATE(177),
    [sym_if_statement] = STATE(177),
    [sym_case_statement] = STATE(177),
    [sym_function_definition] = STATE(177),
    [sym_subshell] = STATE(177),
    [sym_pipeline] = STATE(177),
    [sym_list] = STATE(177),
    [sym_negated_command] = STATE(177),
    [sym_test_command] = STATE(177),
    [sym_declaration_command] = STATE(177),
    [sym_unset_command] = STATE(177),
    [sym_command] = STATE(177),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(178),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(179),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [25] = {
    [aux_sym_concatenation_repeat1] = STATE(145),
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(291),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [26] = {
    [ts_builtin_sym_end] = ACTIONS(325),
    [sym_comment] = ACTIONS(55),
  },
  [27] = {
    [ts_builtin_sym_end] = ACTIONS(327),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_SEMI_SEMI] = ACTIONS(333),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(337),
    [anon_sym_PIPE_PIPE] = ACTIONS(337),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(329),
  },
  [28] = {
    [sym_file_redirect] = STATE(194),
    [sym_heredoc_redirect] = STATE(194),
    [sym_heredoc_body] = STATE(193),
    [sym_herestring_redirect] = STATE(194),
    [sym_concatenation] = STATE(195),
    [sym_string] = STATE(192),
    [sym_simple_expansion] = STATE(192),
    [sym_string_expansion] = STATE(192),
    [sym_expansion] = STATE(192),
    [sym_command_substitution] = STATE(192),
    [sym_process_substitution] = STATE(192),
    [aux_sym_while_statement_repeat1] = STATE(194),
    [aux_sym_command_repeat2] = STATE(195),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(343),
    [ts_builtin_sym_end] = ACTIONS(345),
    [anon_sym_SEMI] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(347),
    [anon_sym_SEMI_SEMI] = ACTIONS(345),
    [anon_sym_PIPE_AMP] = ACTIONS(345),
    [anon_sym_AMP_AMP] = ACTIONS(345),
    [anon_sym_PIPE_PIPE] = ACTIONS(345),
    [anon_sym_EQ_TILDE] = ACTIONS(349),
    [anon_sym_EQ_EQ] = ACTIONS(349),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(359),
    [sym__special_characters] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(363),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_AMP] = ACTIONS(347),
  },
  [29] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [ts_builtin_sym_end] = ACTIONS(327),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_SEMI_SEMI] = ACTIONS(333),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(337),
    [anon_sym_PIPE_PIPE] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(329),
  },
  [30] = {
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_PLUS_EQ] = ACTIONS(65),
    [sym_comment] = ACTIONS(55),
  },
  [31] = {
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [ts_builtin_sym_end] = ACTIONS(291),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_RPAREN] = ACTIONS(291),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [32] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(196),
    [sym_c_style_for_statement] = STATE(196),
    [sym_while_statement] = STATE(196),
    [sym_if_statement] = STATE(196),
    [sym_case_statement] = STATE(196),
    [sym_function_definition] = STATE(196),
    [sym_subshell] = STATE(196),
    [sym_pipeline] = STATE(196),
    [sym_list] = STATE(196),
    [sym_negated_command] = STATE(196),
    [sym_test_command] = STATE(196),
    [sym_declaration_command] = STATE(196),
    [sym_unset_command] = STATE(196),
    [sym_command] = STATE(196),
    [sym_command_name] = STATE(28),
    [sym_variable_assignment] = STATE(197),
    [sym_subscript] = STATE(30),
    [sym_file_redirect] = STATE(33),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(20),
    [sym_simple_expansion] = STATE(20),
    [sym_string_expansion] = STATE(20),
    [sym_expansion] = STATE(20),
    [sym_command_substitution] = STATE(20),
    [sym_process_substitution] = STATE(20),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(29),
    [anon_sym_declare] = ACTIONS(31),
    [anon_sym_typeset] = ACTIONS(31),
    [anon_sym_export] = ACTIONS(31),
    [anon_sym_readonly] = ACTIONS(31),
    [anon_sym_local] = ACTIONS(31),
    [anon_sym_unset] = ACTIONS(33),
    [anon_sym_unsetenv] = ACTIONS(33),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(57),
  },
  [33] = {
    [sym_command_name] = STATE(199),
    [sym_variable_assignment] = STATE(200),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(200),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(20),
    [sym_simple_expansion] = STATE(20),
    [sym_string_expansion] = STATE(20),
    [sym_expansion] = STATE(20),
    [sym_command_substitution] = STATE(20),
    [sym_process_substitution] = STATE(20),
    [aux_sym_command_repeat1] = STATE(200),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(45),
  },
  [34] = {
    [sym_concatenation] = STATE(203),
    [sym_string] = STATE(202),
    [sym_simple_expansion] = STATE(202),
    [sym_string_expansion] = STATE(202),
    [sym_expansion] = STATE(202),
    [sym_command_substitution] = STATE(202),
    [sym_process_substitution] = STATE(202),
    [sym__special_characters] = ACTIONS(373),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(251),
    [sym_raw_string] = ACTIONS(375),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(255),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(257),
    [anon_sym_BQUOTE] = ACTIONS(259),
    [anon_sym_LT_LPAREN] = ACTIONS(261),
    [anon_sym_GT_LPAREN] = ACTIONS(261),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(375),
  },
  [35] = {
    [sym_concatenation] = STATE(206),
    [sym_string] = STATE(205),
    [sym_simple_expansion] = STATE(205),
    [sym_string_expansion] = STATE(205),
    [sym_expansion] = STATE(205),
    [sym_command_substitution] = STATE(205),
    [sym_process_substitution] = STATE(205),
    [sym__special_characters] = ACTIONS(377),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(379),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(379),
  },
  [36] = {
    [sym_concatenation] = STATE(207),
    [sym_string] = STATE(212),
    [sym_array] = STATE(207),
    [sym_simple_expansion] = STATE(212),
    [sym_string_expansion] = STATE(212),
    [sym_expansion] = STATE(212),
    [sym_command_substitution] = STATE(212),
    [sym_process_substitution] = STATE(212),
    [sym__empty_value] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(383),
    [sym__special_characters] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(389),
    [sym_raw_string] = ACTIONS(391),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(393),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(397),
    [anon_sym_LT_LPAREN] = ACTIONS(399),
    [anon_sym_GT_LPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(391),
  },
  [37] = {
    [sym__expression] = STATE(228),
    [sym_binary_expression] = STATE(228),
    [sym_unary_expression] = STATE(228),
    [sym_postfix_expression] = STATE(228),
    [sym_parenthesized_expression] = STATE(228),
    [sym_concatenation] = STATE(228),
    [sym_string] = STATE(223),
    [sym_simple_expansion] = STATE(223),
    [sym_string_expansion] = STATE(223),
    [sym_expansion] = STATE(223),
    [sym_command_substitution] = STATE(223),
    [sym_process_substitution] = STATE(223),
    [anon_sym_SEMI] = ACTIONS(401),
    [anon_sym_SEMI_SEMI] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(407),
    [sym__special_characters] = ACTIONS(409),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(423),
    [anon_sym_GT_LPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(425),
    [sym_test_operator] = ACTIONS(427),
    [anon_sym_LF] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(403),
  },
  [38] = {
    [anon_sym_in] = ACTIONS(429),
    [anon_sym_SEMI] = ACTIONS(431),
    [anon_sym_SEMI_SEMI] = ACTIONS(433),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(433),
    [anon_sym_AMP] = ACTIONS(433),
  },
  [39] = {
    [sym__expression] = STATE(241),
    [sym_binary_expression] = STATE(241),
    [sym_unary_expression] = STATE(241),
    [sym_postfix_expression] = STATE(241),
    [sym_parenthesized_expression] = STATE(241),
    [sym_concatenation] = STATE(241),
    [sym_string] = STATE(236),
    [sym_simple_expansion] = STATE(236),
    [sym_string_expansion] = STATE(236),
    [sym_expansion] = STATE(236),
    [sym_command_substitution] = STATE(236),
    [sym_process_substitution] = STATE(236),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [sym__special_characters] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(455),
    [sym_test_operator] = ACTIONS(457),
  },
  [40] = {
    [sym__expression] = STATE(242),
    [sym_binary_expression] = STATE(242),
    [sym_unary_expression] = STATE(242),
    [sym_postfix_expression] = STATE(242),
    [sym_parenthesized_expression] = STATE(242),
    [sym_concatenation] = STATE(242),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [41] = {
    [aux_sym_concatenation_repeat1] = STATE(244),
    [sym__concat] = ACTIONS(459),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_EQ_TILDE] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(461),
  },
  [42] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(247),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [anon_sym_DOLLAR] = ACTIONS(467),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [43] = {
    [sym_string] = STATE(249),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(469),
    [sym_raw_string] = ACTIONS(471),
    [anon_sym_POUND] = ACTIONS(469),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(473),
    [anon_sym_STAR] = ACTIONS(475),
    [anon_sym_AT] = ACTIONS(475),
    [anon_sym_QMARK] = ACTIONS(475),
    [anon_sym_0] = ACTIONS(473),
    [anon_sym__] = ACTIONS(473),
  },
  [44] = {
    [aux_sym_concatenation_repeat1] = STATE(244),
    [sym__concat] = ACTIONS(459),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(477),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_EQ_TILDE] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(477),
  },
  [45] = {
    [sym_subscript] = STATE(254),
    [sym_variable_name] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(483),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_DOLLAR] = ACTIONS(485),
    [anon_sym_POUND] = ACTIONS(483),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(487),
    [anon_sym_STAR] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_0] = ACTIONS(487),
    [anon_sym__] = ACTIONS(487),
  },
  [46] = {
    [sym__terminated_statement] = STATE(257),
    [sym_for_statement] = STATE(255),
    [sym_c_style_for_statement] = STATE(255),
    [sym_while_statement] = STATE(255),
    [sym_if_statement] = STATE(255),
    [sym_case_statement] = STATE(255),
    [sym_function_definition] = STATE(255),
    [sym_subshell] = STATE(255),
    [sym_pipeline] = STATE(255),
    [sym_list] = STATE(255),
    [sym_negated_command] = STATE(255),
    [sym_test_command] = STATE(255),
    [sym_declaration_command] = STATE(255),
    [sym_unset_command] = STATE(255),
    [sym_command] = STATE(255),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(256),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(257),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [47] = {
    [sym__terminated_statement] = STATE(260),
    [sym_for_statement] = STATE(258),
    [sym_c_style_for_statement] = STATE(258),
    [sym_while_statement] = STATE(258),
    [sym_if_statement] = STATE(258),
    [sym_case_statement] = STATE(258),
    [sym_function_definition] = STATE(258),
    [sym_subshell] = STATE(258),
    [sym_pipeline] = STATE(258),
    [sym_list] = STATE(258),
    [sym_negated_command] = STATE(258),
    [sym_test_command] = STATE(258),
    [sym_declaration_command] = STATE(258),
    [sym_unset_command] = STATE(258),
    [sym_command] = STATE(258),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(259),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(260),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [48] = {
    [sym__terminated_statement] = STATE(263),
    [sym_for_statement] = STATE(261),
    [sym_c_style_for_statement] = STATE(261),
    [sym_while_statement] = STATE(261),
    [sym_if_statement] = STATE(261),
    [sym_case_statement] = STATE(261),
    [sym_function_definition] = STATE(261),
    [sym_subshell] = STATE(261),
    [sym_pipeline] = STATE(261),
    [sym_list] = STATE(261),
    [sym_negated_command] = STATE(261),
    [sym_test_command] = STATE(261),
    [sym_declaration_command] = STATE(261),
    [sym_unset_command] = STATE(261),
    [sym_command] = STATE(261),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(262),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(263),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [49] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_EQ_TILDE] = ACTIONS(495),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_DASH_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(493),
  },
  [50] = {
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(501),
    [anon_sym_PLUS_EQ] = ACTIONS(501),
    [sym_comment] = ACTIONS(55),
  },
  [51] = {
    [sym__expression] = STATE(269),
    [sym_binary_expression] = STATE(269),
    [sym_unary_expression] = STATE(269),
    [sym_postfix_expression] = STATE(269),
    [sym_parenthesized_expression] = STATE(269),
    [sym_concatenation] = STATE(269),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [52] = {
    [sym__terminated_statement] = STATE(270),
    [sym_for_statement] = STATE(63),
    [sym_c_style_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_case_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_subshell] = STATE(63),
    [sym_pipeline] = STATE(63),
    [sym_list] = STATE(63),
    [sym_negated_command] = STATE(63),
    [sym_test_command] = STATE(63),
    [sym_declaration_command] = STATE(63),
    [sym_unset_command] = STATE(63),
    [sym_command] = STATE(63),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(65),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [53] = {
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(503),
  },
  [54] = {
    [sym_subshell] = STATE(98),
    [sym_test_command] = STATE(98),
    [sym_command] = STATE(98),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(67),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(115),
  },
  [55] = {
    [sym__expression] = STATE(272),
    [sym_binary_expression] = STATE(272),
    [sym_unary_expression] = STATE(272),
    [sym_postfix_expression] = STATE(272),
    [sym_parenthesized_expression] = STATE(272),
    [sym_concatenation] = STATE(272),
    [sym_string] = STATE(105),
    [sym_simple_expansion] = STATE(105),
    [sym_string_expansion] = STATE(105),
    [sym_expansion] = STATE(105),
    [sym_command_substitution] = STATE(105),
    [sym_process_substitution] = STATE(105),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [sym__special_characters] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(183),
    [sym_test_operator] = ACTIONS(185),
  },
  [56] = {
    [sym__expression] = STATE(273),
    [sym_binary_expression] = STATE(273),
    [sym_unary_expression] = STATE(273),
    [sym_postfix_expression] = STATE(273),
    [sym_parenthesized_expression] = STATE(273),
    [sym_concatenation] = STATE(273),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(187),
    [sym__special_characters] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(193),
    [sym_test_operator] = ACTIONS(195),
  },
  [57] = {
    [sym_variable_assignment] = STATE(278),
    [sym_subscript] = STATE(277),
    [sym_concatenation] = STATE(278),
    [sym_string] = STATE(276),
    [sym_simple_expansion] = STATE(276),
    [sym_string_expansion] = STATE(276),
    [sym_expansion] = STATE(276),
    [sym_command_substitution] = STATE(276),
    [sym_process_substitution] = STATE(276),
    [aux_sym_declaration_command_repeat1] = STATE(278),
    [sym_variable_name] = ACTIONS(505),
    [anon_sym_SEMI] = ACTIONS(201),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_SEMI_SEMI] = ACTIONS(199),
    [anon_sym_PIPE_AMP] = ACTIONS(199),
    [anon_sym_AMP_AMP] = ACTIONS(199),
    [anon_sym_PIPE_PIPE] = ACTIONS(199),
    [sym__special_characters] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(509),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(511),
    [sym_word] = ACTIONS(513),
    [anon_sym_LF] = ACTIONS(199),
    [anon_sym_AMP] = ACTIONS(201),
  },
  [58] = {
    [sym_concatenation] = STATE(281),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym_unset_command_repeat1] = STATE(281),
    [anon_sym_SEMI] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_SEMI_SEMI] = ACTIONS(223),
    [anon_sym_PIPE_AMP] = ACTIONS(223),
    [anon_sym_AMP_AMP] = ACTIONS(223),
    [anon_sym_PIPE_PIPE] = ACTIONS(223),
    [sym__special_characters] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(517),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(519),
    [sym_word] = ACTIONS(521),
    [anon_sym_LF] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(225),
  },
  [59] = {
    [aux_sym_concatenation_repeat1] = STATE(282),
    [sym__simple_heredoc_body] = ACTIONS(263),
    [sym__heredoc_body_beginning] = ACTIONS(263),
    [sym_file_descriptor] = ACTIONS(263),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_SEMI_SEMI] = ACTIONS(263),
    [anon_sym_PIPE_AMP] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_EQ_TILDE] = ACTIONS(267),
    [anon_sym_EQ_EQ] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_GT_GT] = ACTIONS(263),
    [anon_sym_AMP_GT] = ACTIONS(267),
    [anon_sym_AMP_GT_GT] = ACTIONS(263),
    [anon_sym_LT_AMP] = ACTIONS(263),
    [anon_sym_GT_AMP] = ACTIONS(263),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_LT] = ACTIONS(263),
    [sym__special_characters] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(263),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym_raw_string] = ACTIONS(263),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(263),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(263),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [anon_sym_LT_LPAREN] = ACTIONS(263),
    [anon_sym_GT_LPAREN] = ACTIONS(263),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(267),
    [anon_sym_LF] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(267),
  },
  [60] = {
    [aux_sym_concatenation_repeat1] = STATE(282),
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [61] = {
    [aux_sym_concatenation_repeat1] = STATE(282),
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(523),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [62] = {
    [sym_do_group] = STATE(285),
    [anon_sym_do] = ACTIONS(525),
    [sym_comment] = ACTIONS(55),
  },
  [63] = {
    [anon_sym_SEMI] = ACTIONS(527),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_SEMI_SEMI] = ACTIONS(531),
    [anon_sym_PIPE_AMP] = ACTIONS(533),
    [anon_sym_AMP_AMP] = ACTIONS(535),
    [anon_sym_PIPE_PIPE] = ACTIONS(535),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(531),
    [anon_sym_AMP] = ACTIONS(527),
  },
  [64] = {
    [sym_file_redirect] = STATE(295),
    [sym_heredoc_redirect] = STATE(295),
    [sym_heredoc_body] = STATE(193),
    [sym_herestring_redirect] = STATE(295),
    [sym_concatenation] = STATE(296),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym_while_statement_repeat1] = STATE(295),
    [aux_sym_command_repeat2] = STATE(296),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(537),
    [anon_sym_SEMI] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(347),
    [anon_sym_SEMI_SEMI] = ACTIONS(345),
    [anon_sym_PIPE_AMP] = ACTIONS(345),
    [anon_sym_AMP_AMP] = ACTIONS(345),
    [anon_sym_PIPE_PIPE] = ACTIONS(345),
    [anon_sym_EQ_TILDE] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_GT_GT] = ACTIONS(543),
    [anon_sym_AMP_GT] = ACTIONS(541),
    [anon_sym_AMP_GT_GT] = ACTIONS(543),
    [anon_sym_LT_AMP] = ACTIONS(543),
    [anon_sym_GT_AMP] = ACTIONS(543),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(545),
    [sym__special_characters] = ACTIONS(547),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(549),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(551),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_AMP] = ACTIONS(347),
  },
  [65] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(527),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_SEMI_SEMI] = ACTIONS(531),
    [anon_sym_PIPE_AMP] = ACTIONS(533),
    [anon_sym_AMP_AMP] = ACTIONS(535),
    [anon_sym_PIPE_PIPE] = ACTIONS(535),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(531),
    [anon_sym_AMP] = ACTIONS(527),
  },
  [66] = {
    [anon_sym_EQ] = ACTIONS(501),
    [anon_sym_PLUS_EQ] = ACTIONS(501),
    [sym_comment] = ACTIONS(55),
  },
  [67] = {
    [sym_command_name] = STATE(297),
    [sym_variable_assignment] = STATE(200),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(200),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(200),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(553),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(115),
  },
  [68] = {
    [anon_sym_then] = ACTIONS(555),
    [sym_comment] = ACTIONS(55),
  },
  [69] = {
    [aux_sym_concatenation_repeat1] = STATE(302),
    [sym__concat] = ACTIONS(557),
    [anon_sym_in] = ACTIONS(559),
    [anon_sym_SEMI] = ACTIONS(561),
    [anon_sym_SEMI_SEMI] = ACTIONS(563),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(563),
  },
  [70] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(305),
    [anon_sym_DQUOTE] = ACTIONS(565),
    [anon_sym_DOLLAR] = ACTIONS(567),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [71] = {
    [sym_string] = STATE(307),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_DOLLAR] = ACTIONS(569),
    [sym_raw_string] = ACTIONS(571),
    [anon_sym_POUND] = ACTIONS(569),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(573),
    [anon_sym_STAR] = ACTIONS(575),
    [anon_sym_AT] = ACTIONS(575),
    [anon_sym_QMARK] = ACTIONS(575),
    [anon_sym_0] = ACTIONS(573),
    [anon_sym__] = ACTIONS(573),
  },
  [72] = {
    [aux_sym_concatenation_repeat1] = STATE(302),
    [sym__concat] = ACTIONS(557),
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_SEMI_SEMI] = ACTIONS(581),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(581),
    [anon_sym_AMP] = ACTIONS(581),
  },
  [73] = {
    [sym_subscript] = STATE(314),
    [sym_variable_name] = ACTIONS(583),
    [anon_sym_BANG] = ACTIONS(585),
    [anon_sym_DASH] = ACTIONS(587),
    [anon_sym_DOLLAR] = ACTIONS(587),
    [anon_sym_POUND] = ACTIONS(585),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(589),
    [anon_sym_STAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [anon_sym_QMARK] = ACTIONS(591),
    [anon_sym_0] = ACTIONS(589),
    [anon_sym__] = ACTIONS(589),
  },
  [74] = {
    [sym__terminated_statement] = STATE(317),
    [sym_for_statement] = STATE(315),
    [sym_c_style_for_statement] = STATE(315),
    [sym_while_statement] = STATE(315),
    [sym_if_statement] = STATE(315),
    [sym_case_statement] = STATE(315),
    [sym_function_definition] = STATE(315),
    [sym_subshell] = STATE(315),
    [sym_pipeline] = STATE(315),
    [sym_list] = STATE(315),
    [sym_negated_command] = STATE(315),
    [sym_test_command] = STATE(315),
    [sym_declaration_command] = STATE(315),
    [sym_unset_command] = STATE(315),
    [sym_command] = STATE(315),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(316),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(317),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [75] = {
    [sym__terminated_statement] = STATE(320),
    [sym_for_statement] = STATE(318),
    [sym_c_style_for_statement] = STATE(318),
    [sym_while_statement] = STATE(318),
    [sym_if_statement] = STATE(318),
    [sym_case_statement] = STATE(318),
    [sym_function_definition] = STATE(318),
    [sym_subshell] = STATE(318),
    [sym_pipeline] = STATE(318),
    [sym_list] = STATE(318),
    [sym_negated_command] = STATE(318),
    [sym_test_command] = STATE(318),
    [sym_declaration_command] = STATE(318),
    [sym_unset_command] = STATE(318),
    [sym_command] = STATE(318),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(319),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(320),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [76] = {
    [sym__terminated_statement] = STATE(323),
    [sym_for_statement] = STATE(321),
    [sym_c_style_for_statement] = STATE(321),
    [sym_while_statement] = STATE(321),
    [sym_if_statement] = STATE(321),
    [sym_case_statement] = STATE(321),
    [sym_function_definition] = STATE(321),
    [sym_subshell] = STATE(321),
    [sym_pipeline] = STATE(321),
    [sym_list] = STATE(321),
    [sym_negated_command] = STATE(321),
    [sym_test_command] = STATE(321),
    [sym_declaration_command] = STATE(321),
    [sym_unset_command] = STATE(321),
    [sym_command] = STATE(321),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(322),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(323),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [77] = {
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_SEMI_SEMI] = ACTIONS(581),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(581),
    [anon_sym_AMP] = ACTIONS(581),
  },
  [78] = {
    [sym_compound_statement] = STATE(326),
    [anon_sym_LPAREN] = ACTIONS(593),
    [anon_sym_LBRACE] = ACTIONS(595),
    [sym_comment] = ACTIONS(55),
  },
  [79] = {
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_PLUS_EQ] = ACTIONS(597),
    [sym_comment] = ACTIONS(55),
  },
  [80] = {
    [sym__expression] = STATE(328),
    [sym_binary_expression] = STATE(328),
    [sym_unary_expression] = STATE(328),
    [sym_postfix_expression] = STATE(328),
    [sym_parenthesized_expression] = STATE(328),
    [sym_concatenation] = STATE(328),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [81] = {
    [sym__terminated_statement] = STATE(329),
    [sym_for_statement] = STATE(63),
    [sym_c_style_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_case_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_subshell] = STATE(63),
    [sym_pipeline] = STATE(63),
    [sym_list] = STATE(63),
    [sym_negated_command] = STATE(63),
    [sym_test_command] = STATE(63),
    [sym_declaration_command] = STATE(63),
    [sym_unset_command] = STATE(63),
    [sym_command] = STATE(63),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(65),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [82] = {
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(599),
  },
  [83] = {
    [sym_subshell] = STATE(98),
    [sym_test_command] = STATE(98),
    [sym_command] = STATE(98),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(96),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(157),
  },
  [84] = {
    [sym__expression] = STATE(331),
    [sym_binary_expression] = STATE(331),
    [sym_unary_expression] = STATE(331),
    [sym_postfix_expression] = STATE(331),
    [sym_parenthesized_expression] = STATE(331),
    [sym_concatenation] = STATE(331),
    [sym_string] = STATE(105),
    [sym_simple_expansion] = STATE(105),
    [sym_string_expansion] = STATE(105),
    [sym_expansion] = STATE(105),
    [sym_command_substitution] = STATE(105),
    [sym_process_substitution] = STATE(105),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [sym__special_characters] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(183),
    [sym_test_operator] = ACTIONS(185),
  },
  [85] = {
    [sym__expression] = STATE(332),
    [sym_binary_expression] = STATE(332),
    [sym_unary_expression] = STATE(332),
    [sym_postfix_expression] = STATE(332),
    [sym_parenthesized_expression] = STATE(332),
    [sym_concatenation] = STATE(332),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(187),
    [sym__special_characters] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(193),
    [sym_test_operator] = ACTIONS(195),
  },
  [86] = {
    [sym_variable_assignment] = STATE(337),
    [sym_subscript] = STATE(336),
    [sym_concatenation] = STATE(337),
    [sym_string] = STATE(335),
    [sym_simple_expansion] = STATE(335),
    [sym_string_expansion] = STATE(335),
    [sym_expansion] = STATE(335),
    [sym_command_substitution] = STATE(335),
    [sym_process_substitution] = STATE(335),
    [aux_sym_declaration_command_repeat1] = STATE(337),
    [sym_variable_name] = ACTIONS(601),
    [anon_sym_SEMI] = ACTIONS(201),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_RPAREN] = ACTIONS(199),
    [anon_sym_SEMI_SEMI] = ACTIONS(199),
    [anon_sym_PIPE_AMP] = ACTIONS(199),
    [anon_sym_AMP_AMP] = ACTIONS(199),
    [anon_sym_PIPE_PIPE] = ACTIONS(199),
    [sym__special_characters] = ACTIONS(603),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(605),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(607),
    [sym_word] = ACTIONS(609),
    [anon_sym_LF] = ACTIONS(199),
    [anon_sym_AMP] = ACTIONS(201),
  },
  [87] = {
    [sym_concatenation] = STATE(340),
    [sym_string] = STATE(339),
    [sym_simple_expansion] = STATE(339),
    [sym_string_expansion] = STATE(339),
    [sym_expansion] = STATE(339),
    [sym_command_substitution] = STATE(339),
    [sym_process_substitution] = STATE(339),
    [aux_sym_unset_command_repeat1] = STATE(340),
    [anon_sym_SEMI] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_SEMI_SEMI] = ACTIONS(223),
    [anon_sym_PIPE_AMP] = ACTIONS(223),
    [anon_sym_AMP_AMP] = ACTIONS(223),
    [anon_sym_PIPE_PIPE] = ACTIONS(223),
    [sym__special_characters] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(613),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(615),
    [sym_word] = ACTIONS(617),
    [anon_sym_LF] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(225),
  },
  [88] = {
    [aux_sym_concatenation_repeat1] = STATE(341),
    [sym__simple_heredoc_body] = ACTIONS(263),
    [sym__heredoc_body_beginning] = ACTIONS(263),
    [sym_file_descriptor] = ACTIONS(263),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_RPAREN] = ACTIONS(263),
    [anon_sym_SEMI_SEMI] = ACTIONS(263),
    [anon_sym_PIPE_AMP] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_EQ_TILDE] = ACTIONS(267),
    [anon_sym_EQ_EQ] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_GT_GT] = ACTIONS(263),
    [anon_sym_AMP_GT] = ACTIONS(267),
    [anon_sym_AMP_GT_GT] = ACTIONS(263),
    [anon_sym_LT_AMP] = ACTIONS(263),
    [anon_sym_GT_AMP] = ACTIONS(263),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_LT] = ACTIONS(263),
    [sym__special_characters] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(263),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym_raw_string] = ACTIONS(263),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(263),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(263),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [anon_sym_LT_LPAREN] = ACTIONS(263),
    [anon_sym_GT_LPAREN] = ACTIONS(263),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(267),
    [anon_sym_LF] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(267),
  },
  [89] = {
    [aux_sym_concatenation_repeat1] = STATE(341),
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_RPAREN] = ACTIONS(291),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [90] = {
    [aux_sym_concatenation_repeat1] = STATE(341),
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_RPAREN] = ACTIONS(291),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [91] = {
    [anon_sym_SEMI] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(625),
    [anon_sym_SEMI_SEMI] = ACTIONS(627),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(627),
    [anon_sym_AMP] = ACTIONS(621),
  },
  [92] = {
    [sym_file_redirect] = STATE(353),
    [sym_heredoc_redirect] = STATE(353),
    [sym_heredoc_body] = STATE(193),
    [sym_herestring_redirect] = STATE(353),
    [sym_concatenation] = STATE(354),
    [sym_string] = STATE(352),
    [sym_simple_expansion] = STATE(352),
    [sym_string_expansion] = STATE(352),
    [sym_expansion] = STATE(352),
    [sym_command_substitution] = STATE(352),
    [sym_process_substitution] = STATE(352),
    [aux_sym_while_statement_repeat1] = STATE(353),
    [aux_sym_command_repeat2] = STATE(354),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(347),
    [anon_sym_RPAREN] = ACTIONS(345),
    [anon_sym_SEMI_SEMI] = ACTIONS(345),
    [anon_sym_PIPE_AMP] = ACTIONS(345),
    [anon_sym_AMP_AMP] = ACTIONS(345),
    [anon_sym_PIPE_PIPE] = ACTIONS(345),
    [anon_sym_EQ_TILDE] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_GT_GT] = ACTIONS(639),
    [anon_sym_AMP_GT] = ACTIONS(637),
    [anon_sym_AMP_GT_GT] = ACTIONS(639),
    [anon_sym_LT_AMP] = ACTIONS(639),
    [anon_sym_GT_AMP] = ACTIONS(639),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(641),
    [sym__special_characters] = ACTIONS(643),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(645),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(647),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_AMP] = ACTIONS(347),
  },
  [93] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(625),
    [anon_sym_SEMI_SEMI] = ACTIONS(627),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(627),
    [anon_sym_AMP] = ACTIONS(621),
  },
  [94] = {
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_PLUS_EQ] = ACTIONS(597),
    [sym_comment] = ACTIONS(55),
  },
  [95] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(355),
    [sym_c_style_for_statement] = STATE(355),
    [sym_while_statement] = STATE(355),
    [sym_if_statement] = STATE(355),
    [sym_case_statement] = STATE(355),
    [sym_function_definition] = STATE(355),
    [sym_subshell] = STATE(355),
    [sym_pipeline] = STATE(355),
    [sym_list] = STATE(355),
    [sym_negated_command] = STATE(355),
    [sym_test_command] = STATE(355),
    [sym_declaration_command] = STATE(355),
    [sym_unset_command] = STATE(355),
    [sym_command] = STATE(355),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(356),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [96] = {
    [sym_command_name] = STATE(357),
    [sym_variable_assignment] = STATE(200),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(200),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym_command_repeat1] = STATE(200),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(157),
  },
  [97] = {
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(651),
    [anon_sym_PLUS_EQ] = ACTIONS(651),
    [sym_comment] = ACTIONS(55),
  },
  [98] = {
    [ts_builtin_sym_end] = ACTIONS(653),
    [anon_sym_SEMI] = ACTIONS(655),
    [anon_sym_esac] = ACTIONS(653),
    [anon_sym_PIPE] = ACTIONS(655),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_SEMI_SEMI] = ACTIONS(653),
    [anon_sym_PIPE_AMP] = ACTIONS(653),
    [anon_sym_AMP_AMP] = ACTIONS(653),
    [anon_sym_PIPE_PIPE] = ACTIONS(653),
    [anon_sym_BQUOTE] = ACTIONS(653),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(653),
    [anon_sym_AMP] = ACTIONS(655),
  },
  [99] = {
    [anon_sym_EQ] = ACTIONS(651),
    [anon_sym_PLUS_EQ] = ACTIONS(651),
    [sym_comment] = ACTIONS(55),
  },
  [100] = {
    [sym__expression] = STATE(359),
    [sym_binary_expression] = STATE(359),
    [sym_unary_expression] = STATE(359),
    [sym_postfix_expression] = STATE(359),
    [sym_parenthesized_expression] = STATE(359),
    [sym_concatenation] = STATE(359),
    [sym_string] = STATE(236),
    [sym_simple_expansion] = STATE(236),
    [sym_string_expansion] = STATE(236),
    [sym_expansion] = STATE(236),
    [sym_command_substitution] = STATE(236),
    [sym_process_substitution] = STATE(236),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [sym__special_characters] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(455),
    [sym_test_operator] = ACTIONS(457),
  },
  [101] = {
    [sym__expression] = STATE(360),
    [sym_binary_expression] = STATE(360),
    [sym_unary_expression] = STATE(360),
    [sym_postfix_expression] = STATE(360),
    [sym_parenthesized_expression] = STATE(360),
    [sym_concatenation] = STATE(360),
    [sym_string] = STATE(105),
    [sym_simple_expansion] = STATE(105),
    [sym_string_expansion] = STATE(105),
    [sym_expansion] = STATE(105),
    [sym_command_substitution] = STATE(105),
    [sym_process_substitution] = STATE(105),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [sym__special_characters] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(183),
    [sym_test_operator] = ACTIONS(185),
  },
  [102] = {
    [aux_sym_concatenation_repeat1] = STATE(362),
    [sym__concat] = ACTIONS(657),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_RBRACK] = ACTIONS(461),
    [anon_sym_EQ_TILDE] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(461),
  },
  [103] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(365),
    [anon_sym_DQUOTE] = ACTIONS(659),
    [anon_sym_DOLLAR] = ACTIONS(661),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [104] = {
    [sym_string] = STATE(367),
    [anon_sym_DASH] = ACTIONS(663),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(663),
    [sym_raw_string] = ACTIONS(665),
    [anon_sym_POUND] = ACTIONS(663),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(667),
    [anon_sym_STAR] = ACTIONS(669),
    [anon_sym_AT] = ACTIONS(669),
    [anon_sym_QMARK] = ACTIONS(669),
    [anon_sym_0] = ACTIONS(667),
    [anon_sym__] = ACTIONS(667),
  },
  [105] = {
    [aux_sym_concatenation_repeat1] = STATE(362),
    [sym__concat] = ACTIONS(657),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_RBRACK] = ACTIONS(477),
    [anon_sym_EQ_TILDE] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(477),
  },
  [106] = {
    [sym_subscript] = STATE(372),
    [sym_variable_name] = ACTIONS(671),
    [anon_sym_BANG] = ACTIONS(673),
    [anon_sym_DASH] = ACTIONS(675),
    [anon_sym_DOLLAR] = ACTIONS(675),
    [anon_sym_POUND] = ACTIONS(673),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(677),
    [anon_sym_STAR] = ACTIONS(679),
    [anon_sym_AT] = ACTIONS(679),
    [anon_sym_QMARK] = ACTIONS(679),
    [anon_sym_0] = ACTIONS(677),
    [anon_sym__] = ACTIONS(677),
  },
  [107] = {
    [sym__terminated_statement] = STATE(375),
    [sym_for_statement] = STATE(373),
    [sym_c_style_for_statement] = STATE(373),
    [sym_while_statement] = STATE(373),
    [sym_if_statement] = STATE(373),
    [sym_case_statement] = STATE(373),
    [sym_function_definition] = STATE(373),
    [sym_subshell] = STATE(373),
    [sym_pipeline] = STATE(373),
    [sym_list] = STATE(373),
    [sym_negated_command] = STATE(373),
    [sym_test_command] = STATE(373),
    [sym_declaration_command] = STATE(373),
    [sym_unset_command] = STATE(373),
    [sym_command] = STATE(373),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(374),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(375),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [108] = {
    [sym__terminated_statement] = STATE(378),
    [sym_for_statement] = STATE(376),
    [sym_c_style_for_statement] = STATE(376),
    [sym_while_statement] = STATE(376),
    [sym_if_statement] = STATE(376),
    [sym_case_statement] = STATE(376),
    [sym_function_definition] = STATE(376),
    [sym_subshell] = STATE(376),
    [sym_pipeline] = STATE(376),
    [sym_list] = STATE(376),
    [sym_negated_command] = STATE(376),
    [sym_test_command] = STATE(376),
    [sym_declaration_command] = STATE(376),
    [sym_unset_command] = STATE(376),
    [sym_command] = STATE(376),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(377),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(378),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [109] = {
    [sym__terminated_statement] = STATE(381),
    [sym_for_statement] = STATE(379),
    [sym_c_style_for_statement] = STATE(379),
    [sym_while_statement] = STATE(379),
    [sym_if_statement] = STATE(379),
    [sym_case_statement] = STATE(379),
    [sym_function_definition] = STATE(379),
    [sym_subshell] = STATE(379),
    [sym_pipeline] = STATE(379),
    [sym_list] = STATE(379),
    [sym_negated_command] = STATE(379),
    [sym_test_command] = STATE(379),
    [sym_declaration_command] = STATE(379),
    [sym_unset_command] = STATE(379),
    [sym_command] = STATE(379),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(380),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(381),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [110] = {
    [anon_sym_AMP_AMP] = ACTIONS(681),
    [anon_sym_PIPE_PIPE] = ACTIONS(681),
    [anon_sym_RBRACK] = ACTIONS(491),
    [anon_sym_EQ_TILDE] = ACTIONS(683),
    [anon_sym_EQ_EQ] = ACTIONS(683),
    [anon_sym_EQ] = ACTIONS(685),
    [anon_sym_PLUS_EQ] = ACTIONS(681),
    [anon_sym_LT] = ACTIONS(685),
    [anon_sym_GT] = ACTIONS(685),
    [anon_sym_BANG_EQ] = ACTIONS(681),
    [anon_sym_PLUS] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(685),
    [anon_sym_DASH_EQ] = ACTIONS(681),
    [anon_sym_LT_EQ] = ACTIONS(681),
    [anon_sym_GT_EQ] = ACTIONS(681),
    [anon_sym_PLUS_PLUS] = ACTIONS(687),
    [anon_sym_DASH_DASH] = ACTIONS(687),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(681),
  },
  [111] = {
    [sym__expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_postfix_expression] = STATE(385),
    [sym_parenthesized_expression] = STATE(385),
    [sym_concatenation] = STATE(385),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(187),
    [sym__special_characters] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(193),
    [sym_test_operator] = ACTIONS(195),
  },
  [112] = {
    [aux_sym_concatenation_repeat1] = STATE(386),
    [sym__concat] = ACTIONS(459),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(461),
    [anon_sym_EQ_TILDE] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(461),
  },
  [113] = {
    [aux_sym_concatenation_repeat1] = STATE(386),
    [sym__concat] = ACTIONS(459),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(477),
    [anon_sym_EQ_TILDE] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(477),
  },
  [114] = {
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(491),
    [anon_sym_EQ_TILDE] = ACTIONS(691),
    [anon_sym_EQ_EQ] = ACTIONS(691),
    [anon_sym_EQ] = ACTIONS(693),
    [anon_sym_PLUS_EQ] = ACTIONS(689),
    [anon_sym_LT] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(693),
    [anon_sym_BANG_EQ] = ACTIONS(689),
    [anon_sym_PLUS] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(693),
    [anon_sym_DASH_EQ] = ACTIONS(689),
    [anon_sym_LT_EQ] = ACTIONS(689),
    [anon_sym_GT_EQ] = ACTIONS(689),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(689),
  },
  [115] = {
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_PLUS_EQ] = ACTIONS(695),
    [sym_comment] = ACTIONS(55),
  },
  [116] = {
    [aux_sym_concatenation_repeat1] = STATE(391),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(699),
    [ts_builtin_sym_end] = ACTIONS(699),
    [anon_sym_SEMI] = ACTIONS(701),
    [anon_sym_PIPE] = ACTIONS(701),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [anon_sym_PIPE_AMP] = ACTIONS(699),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [sym__special_characters] = ACTIONS(699),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_DOLLAR] = ACTIONS(701),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(699),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(699),
    [anon_sym_BQUOTE] = ACTIONS(699),
    [anon_sym_LT_LPAREN] = ACTIONS(699),
    [anon_sym_GT_LPAREN] = ACTIONS(699),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(701),
    [sym_word] = ACTIONS(701),
    [anon_sym_LF] = ACTIONS(699),
    [anon_sym_AMP] = ACTIONS(701),
  },
  [117] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(394),
    [anon_sym_DQUOTE] = ACTIONS(703),
    [anon_sym_DOLLAR] = ACTIONS(705),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [118] = {
    [sym_string] = STATE(396),
    [anon_sym_DASH] = ACTIONS(707),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(707),
    [sym_raw_string] = ACTIONS(709),
    [anon_sym_POUND] = ACTIONS(707),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(711),
    [anon_sym_STAR] = ACTIONS(713),
    [anon_sym_AT] = ACTIONS(713),
    [anon_sym_QMARK] = ACTIONS(713),
    [anon_sym_0] = ACTIONS(711),
    [anon_sym__] = ACTIONS(711),
  },
  [119] = {
    [aux_sym_concatenation_repeat1] = STATE(391),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(715),
    [ts_builtin_sym_end] = ACTIONS(715),
    [anon_sym_SEMI] = ACTIONS(717),
    [anon_sym_PIPE] = ACTIONS(717),
    [anon_sym_SEMI_SEMI] = ACTIONS(715),
    [anon_sym_PIPE_AMP] = ACTIONS(715),
    [anon_sym_AMP_AMP] = ACTIONS(715),
    [anon_sym_PIPE_PIPE] = ACTIONS(715),
    [sym__special_characters] = ACTIONS(715),
    [anon_sym_DQUOTE] = ACTIONS(715),
    [anon_sym_DOLLAR] = ACTIONS(717),
    [sym_raw_string] = ACTIONS(715),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(715),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(715),
    [anon_sym_BQUOTE] = ACTIONS(715),
    [anon_sym_LT_LPAREN] = ACTIONS(715),
    [anon_sym_GT_LPAREN] = ACTIONS(715),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(717),
    [sym_word] = ACTIONS(717),
    [anon_sym_LF] = ACTIONS(715),
    [anon_sym_AMP] = ACTIONS(717),
  },
  [120] = {
    [sym_subscript] = STATE(401),
    [sym_variable_name] = ACTIONS(719),
    [anon_sym_BANG] = ACTIONS(721),
    [anon_sym_DASH] = ACTIONS(723),
    [anon_sym_DOLLAR] = ACTIONS(723),
    [anon_sym_POUND] = ACTIONS(721),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(725),
    [anon_sym_STAR] = ACTIONS(727),
    [anon_sym_AT] = ACTIONS(727),
    [anon_sym_QMARK] = ACTIONS(727),
    [anon_sym_0] = ACTIONS(725),
    [anon_sym__] = ACTIONS(725),
  },
  [121] = {
    [sym__terminated_statement] = STATE(404),
    [sym_for_statement] = STATE(402),
    [sym_c_style_for_statement] = STATE(402),
    [sym_while_statement] = STATE(402),
    [sym_if_statement] = STATE(402),
    [sym_case_statement] = STATE(402),
    [sym_function_definition] = STATE(402),
    [sym_subshell] = STATE(402),
    [sym_pipeline] = STATE(402),
    [sym_list] = STATE(402),
    [sym_negated_command] = STATE(402),
    [sym_test_command] = STATE(402),
    [sym_declaration_command] = STATE(402),
    [sym_unset_command] = STATE(402),
    [sym_command] = STATE(402),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(403),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(404),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [122] = {
    [sym__terminated_statement] = STATE(407),
    [sym_for_statement] = STATE(405),
    [sym_c_style_for_statement] = STATE(405),
    [sym_while_statement] = STATE(405),
    [sym_if_statement] = STATE(405),
    [sym_case_statement] = STATE(405),
    [sym_function_definition] = STATE(405),
    [sym_subshell] = STATE(405),
    [sym_pipeline] = STATE(405),
    [sym_list] = STATE(405),
    [sym_negated_command] = STATE(405),
    [sym_test_command] = STATE(405),
    [sym_declaration_command] = STATE(405),
    [sym_unset_command] = STATE(405),
    [sym_command] = STATE(405),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(407),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [123] = {
    [sym__terminated_statement] = STATE(410),
    [sym_for_statement] = STATE(408),
    [sym_c_style_for_statement] = STATE(408),
    [sym_while_statement] = STATE(408),
    [sym_if_statement] = STATE(408),
    [sym_case_statement] = STATE(408),
    [sym_function_definition] = STATE(408),
    [sym_subshell] = STATE(408),
    [sym_pipeline] = STATE(408),
    [sym_list] = STATE(408),
    [sym_negated_command] = STATE(408),
    [sym_test_command] = STATE(408),
    [sym_declaration_command] = STATE(408),
    [sym_unset_command] = STATE(408),
    [sym_command] = STATE(408),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(409),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(410),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [124] = {
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_PLUS_EQ] = ACTIONS(695),
    [sym_comment] = ACTIONS(55),
  },
  [125] = {
    [sym_variable_assignment] = STATE(411),
    [sym_subscript] = STATE(124),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(119),
    [sym_simple_expansion] = STATE(119),
    [sym_string_expansion] = STATE(119),
    [sym_expansion] = STATE(119),
    [sym_command_substitution] = STATE(119),
    [sym_process_substitution] = STATE(119),
    [aux_sym_declaration_command_repeat1] = STATE(411),
    [sym_variable_name] = ACTIONS(197),
    [ts_builtin_sym_end] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(731),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(203),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(209),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(733),
    [sym_word] = ACTIONS(221),
    [anon_sym_LF] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(731),
  },
  [126] = {
    [aux_sym_concatenation_repeat1] = STATE(413),
    [sym__concat] = ACTIONS(735),
    [ts_builtin_sym_end] = ACTIONS(737),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_PIPE] = ACTIONS(739),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [anon_sym_PIPE_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(737),
    [sym__special_characters] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(739),
    [sym_raw_string] = ACTIONS(737),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [anon_sym_LT_LPAREN] = ACTIONS(737),
    [anon_sym_GT_LPAREN] = ACTIONS(737),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(739),
    [sym_word] = ACTIONS(739),
    [anon_sym_LF] = ACTIONS(737),
    [anon_sym_AMP] = ACTIONS(739),
  },
  [127] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(416),
    [anon_sym_DQUOTE] = ACTIONS(741),
    [anon_sym_DOLLAR] = ACTIONS(743),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [128] = {
    [sym_string] = STATE(418),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(745),
    [sym_raw_string] = ACTIONS(747),
    [anon_sym_POUND] = ACTIONS(745),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(749),
    [anon_sym_STAR] = ACTIONS(751),
    [anon_sym_AT] = ACTIONS(751),
    [anon_sym_QMARK] = ACTIONS(751),
    [anon_sym_0] = ACTIONS(749),
    [anon_sym__] = ACTIONS(749),
  },
  [129] = {
    [aux_sym_concatenation_repeat1] = STATE(413),
    [sym__concat] = ACTIONS(735),
    [ts_builtin_sym_end] = ACTIONS(753),
    [anon_sym_SEMI] = ACTIONS(755),
    [anon_sym_PIPE] = ACTIONS(755),
    [anon_sym_SEMI_SEMI] = ACTIONS(753),
    [anon_sym_PIPE_AMP] = ACTIONS(753),
    [anon_sym_AMP_AMP] = ACTIONS(753),
    [anon_sym_PIPE_PIPE] = ACTIONS(753),
    [sym__special_characters] = ACTIONS(753),
    [anon_sym_DQUOTE] = ACTIONS(753),
    [anon_sym_DOLLAR] = ACTIONS(755),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(753),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(753),
    [anon_sym_BQUOTE] = ACTIONS(753),
    [anon_sym_LT_LPAREN] = ACTIONS(753),
    [anon_sym_GT_LPAREN] = ACTIONS(753),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(755),
    [sym_word] = ACTIONS(755),
    [anon_sym_LF] = ACTIONS(753),
    [anon_sym_AMP] = ACTIONS(755),
  },
  [130] = {
    [sym_subscript] = STATE(423),
    [sym_variable_name] = ACTIONS(757),
    [anon_sym_BANG] = ACTIONS(759),
    [anon_sym_DASH] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(761),
    [anon_sym_POUND] = ACTIONS(759),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(763),
    [anon_sym_STAR] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(765),
    [anon_sym_QMARK] = ACTIONS(765),
    [anon_sym_0] = ACTIONS(763),
    [anon_sym__] = ACTIONS(763),
  },
  [131] = {
    [sym__terminated_statement] = STATE(426),
    [sym_for_statement] = STATE(424),
    [sym_c_style_for_statement] = STATE(424),
    [sym_while_statement] = STATE(424),
    [sym_if_statement] = STATE(424),
    [sym_case_statement] = STATE(424),
    [sym_function_definition] = STATE(424),
    [sym_subshell] = STATE(424),
    [sym_pipeline] = STATE(424),
    [sym_list] = STATE(424),
    [sym_negated_command] = STATE(424),
    [sym_test_command] = STATE(424),
    [sym_declaration_command] = STATE(424),
    [sym_unset_command] = STATE(424),
    [sym_command] = STATE(424),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(425),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(426),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [132] = {
    [sym__terminated_statement] = STATE(429),
    [sym_for_statement] = STATE(427),
    [sym_c_style_for_statement] = STATE(427),
    [sym_while_statement] = STATE(427),
    [sym_if_statement] = STATE(427),
    [sym_case_statement] = STATE(427),
    [sym_function_definition] = STATE(427),
    [sym_subshell] = STATE(427),
    [sym_pipeline] = STATE(427),
    [sym_list] = STATE(427),
    [sym_negated_command] = STATE(427),
    [sym_test_command] = STATE(427),
    [sym_declaration_command] = STATE(427),
    [sym_unset_command] = STATE(427),
    [sym_command] = STATE(427),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(428),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(429),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [133] = {
    [sym__terminated_statement] = STATE(432),
    [sym_for_statement] = STATE(430),
    [sym_c_style_for_statement] = STATE(430),
    [sym_while_statement] = STATE(430),
    [sym_if_statement] = STATE(430),
    [sym_case_statement] = STATE(430),
    [sym_function_definition] = STATE(430),
    [sym_subshell] = STATE(430),
    [sym_pipeline] = STATE(430),
    [sym_list] = STATE(430),
    [sym_negated_command] = STATE(430),
    [sym_test_command] = STATE(430),
    [sym_declaration_command] = STATE(430),
    [sym_unset_command] = STATE(430),
    [sym_command] = STATE(430),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(431),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(432),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [134] = {
    [sym_concatenation] = STATE(433),
    [sym_string] = STATE(129),
    [sym_simple_expansion] = STATE(129),
    [sym_string_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [sym_process_substitution] = STATE(129),
    [aux_sym_unset_command_repeat1] = STATE(433),
    [ts_builtin_sym_end] = ACTIONS(767),
    [anon_sym_SEMI] = ACTIONS(769),
    [anon_sym_PIPE] = ACTIONS(769),
    [anon_sym_SEMI_SEMI] = ACTIONS(767),
    [anon_sym_PIPE_AMP] = ACTIONS(767),
    [anon_sym_AMP_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(767),
    [sym__special_characters] = ACTIONS(227),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(233),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(771),
    [sym_word] = ACTIONS(245),
    [anon_sym_LF] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(769),
  },
  [135] = {
    [aux_sym_concatenation_repeat1] = STATE(435),
    [sym_file_descriptor] = ACTIONS(773),
    [sym__concat] = ACTIONS(775),
    [sym_variable_name] = ACTIONS(773),
    [anon_sym_LT] = ACTIONS(777),
    [anon_sym_GT] = ACTIONS(777),
    [anon_sym_GT_GT] = ACTIONS(773),
    [anon_sym_AMP_GT] = ACTIONS(777),
    [anon_sym_AMP_GT_GT] = ACTIONS(773),
    [anon_sym_LT_AMP] = ACTIONS(773),
    [anon_sym_GT_AMP] = ACTIONS(773),
    [sym__special_characters] = ACTIONS(773),
    [anon_sym_DQUOTE] = ACTIONS(773),
    [anon_sym_DOLLAR] = ACTIONS(777),
    [sym_raw_string] = ACTIONS(773),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(773),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(773),
    [anon_sym_BQUOTE] = ACTIONS(773),
    [anon_sym_LT_LPAREN] = ACTIONS(773),
    [anon_sym_GT_LPAREN] = ACTIONS(773),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(773),
  },
  [136] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(438),
    [anon_sym_DQUOTE] = ACTIONS(779),
    [anon_sym_DOLLAR] = ACTIONS(781),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [137] = {
    [sym_string] = STATE(440),
    [anon_sym_DASH] = ACTIONS(783),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(783),
    [sym_raw_string] = ACTIONS(785),
    [anon_sym_POUND] = ACTIONS(783),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(787),
    [anon_sym_STAR] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(789),
    [anon_sym_QMARK] = ACTIONS(789),
    [anon_sym_0] = ACTIONS(787),
    [anon_sym__] = ACTIONS(787),
  },
  [138] = {
    [aux_sym_concatenation_repeat1] = STATE(435),
    [sym_file_descriptor] = ACTIONS(791),
    [sym__concat] = ACTIONS(775),
    [sym_variable_name] = ACTIONS(791),
    [anon_sym_LT] = ACTIONS(793),
    [anon_sym_GT] = ACTIONS(793),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_AMP_GT] = ACTIONS(793),
    [anon_sym_AMP_GT_GT] = ACTIONS(791),
    [anon_sym_LT_AMP] = ACTIONS(791),
    [anon_sym_GT_AMP] = ACTIONS(791),
    [sym__special_characters] = ACTIONS(791),
    [anon_sym_DQUOTE] = ACTIONS(791),
    [anon_sym_DOLLAR] = ACTIONS(793),
    [sym_raw_string] = ACTIONS(791),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(791),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(791),
    [anon_sym_BQUOTE] = ACTIONS(791),
    [anon_sym_LT_LPAREN] = ACTIONS(791),
    [anon_sym_GT_LPAREN] = ACTIONS(791),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(791),
  },
  [139] = {
    [sym_subscript] = STATE(445),
    [sym_variable_name] = ACTIONS(795),
    [anon_sym_BANG] = ACTIONS(797),
    [anon_sym_DASH] = ACTIONS(799),
    [anon_sym_DOLLAR] = ACTIONS(799),
    [anon_sym_POUND] = ACTIONS(797),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(801),
    [anon_sym_STAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(803),
    [anon_sym_QMARK] = ACTIONS(803),
    [anon_sym_0] = ACTIONS(801),
    [anon_sym__] = ACTIONS(801),
  },
  [140] = {
    [sym__terminated_statement] = STATE(448),
    [sym_for_statement] = STATE(446),
    [sym_c_style_for_statement] = STATE(446),
    [sym_while_statement] = STATE(446),
    [sym_if_statement] = STATE(446),
    [sym_case_statement] = STATE(446),
    [sym_function_definition] = STATE(446),
    [sym_subshell] = STATE(446),
    [sym_pipeline] = STATE(446),
    [sym_list] = STATE(446),
    [sym_negated_command] = STATE(446),
    [sym_test_command] = STATE(446),
    [sym_declaration_command] = STATE(446),
    [sym_unset_command] = STATE(446),
    [sym_command] = STATE(446),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(447),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(448),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [141] = {
    [sym__terminated_statement] = STATE(451),
    [sym_for_statement] = STATE(449),
    [sym_c_style_for_statement] = STATE(449),
    [sym_while_statement] = STATE(449),
    [sym_if_statement] = STATE(449),
    [sym_case_statement] = STATE(449),
    [sym_function_definition] = STATE(449),
    [sym_subshell] = STATE(449),
    [sym_pipeline] = STATE(449),
    [sym_list] = STATE(449),
    [sym_negated_command] = STATE(449),
    [sym_test_command] = STATE(449),
    [sym_declaration_command] = STATE(449),
    [sym_unset_command] = STATE(449),
    [sym_command] = STATE(449),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(450),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(451),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [142] = {
    [sym__terminated_statement] = STATE(454),
    [sym_for_statement] = STATE(452),
    [sym_c_style_for_statement] = STATE(452),
    [sym_while_statement] = STATE(452),
    [sym_if_statement] = STATE(452),
    [sym_case_statement] = STATE(452),
    [sym_function_definition] = STATE(452),
    [sym_subshell] = STATE(452),
    [sym_pipeline] = STATE(452),
    [sym_list] = STATE(452),
    [sym_negated_command] = STATE(452),
    [sym_test_command] = STATE(452),
    [sym_declaration_command] = STATE(452),
    [sym_unset_command] = STATE(452),
    [sym_command] = STATE(452),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(453),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(454),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [143] = {
    [sym_file_descriptor] = ACTIONS(791),
    [sym_variable_name] = ACTIONS(791),
    [anon_sym_LT] = ACTIONS(793),
    [anon_sym_GT] = ACTIONS(793),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_AMP_GT] = ACTIONS(793),
    [anon_sym_AMP_GT_GT] = ACTIONS(791),
    [anon_sym_LT_AMP] = ACTIONS(791),
    [anon_sym_GT_AMP] = ACTIONS(791),
    [sym__special_characters] = ACTIONS(791),
    [anon_sym_DQUOTE] = ACTIONS(791),
    [anon_sym_DOLLAR] = ACTIONS(793),
    [sym_raw_string] = ACTIONS(791),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(791),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(791),
    [anon_sym_BQUOTE] = ACTIONS(791),
    [anon_sym_LT_LPAREN] = ACTIONS(791),
    [anon_sym_GT_LPAREN] = ACTIONS(791),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(791),
  },
  [144] = {
    [sym_string] = STATE(455),
    [sym_simple_expansion] = STATE(455),
    [sym_string_expansion] = STATE(455),
    [sym_expansion] = STATE(455),
    [sym_command_substitution] = STATE(455),
    [sym_process_substitution] = STATE(455),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(805),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(805),
  },
  [145] = {
    [aux_sym_concatenation_repeat1] = STATE(456),
    [sym__simple_heredoc_body] = ACTIONS(807),
    [sym__heredoc_body_beginning] = ACTIONS(807),
    [sym_file_descriptor] = ACTIONS(807),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_PIPE] = ACTIONS(809),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [anon_sym_PIPE_AMP] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(809),
    [anon_sym_EQ_EQ] = ACTIONS(809),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_GT_GT] = ACTIONS(807),
    [anon_sym_AMP_GT] = ACTIONS(809),
    [anon_sym_AMP_GT_GT] = ACTIONS(807),
    [anon_sym_LT_AMP] = ACTIONS(807),
    [anon_sym_GT_AMP] = ACTIONS(807),
    [anon_sym_LT_LT] = ACTIONS(809),
    [anon_sym_LT_LT_DASH] = ACTIONS(807),
    [anon_sym_LT_LT_LT] = ACTIONS(807),
    [sym__special_characters] = ACTIONS(807),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(807),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [anon_sym_LT_LPAREN] = ACTIONS(807),
    [anon_sym_GT_LPAREN] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(809),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(809),
  },
  [146] = {
    [sym__simple_heredoc_body] = ACTIONS(811),
    [sym__heredoc_body_beginning] = ACTIONS(811),
    [sym_file_descriptor] = ACTIONS(811),
    [sym__concat] = ACTIONS(811),
    [ts_builtin_sym_end] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(813),
    [anon_sym_PIPE] = ACTIONS(813),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_SEMI_SEMI] = ACTIONS(811),
    [anon_sym_PIPE_AMP] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [anon_sym_EQ_TILDE] = ACTIONS(813),
    [anon_sym_EQ_EQ] = ACTIONS(813),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_GT_GT] = ACTIONS(811),
    [anon_sym_AMP_GT] = ACTIONS(813),
    [anon_sym_AMP_GT_GT] = ACTIONS(811),
    [anon_sym_LT_AMP] = ACTIONS(811),
    [anon_sym_GT_AMP] = ACTIONS(811),
    [anon_sym_LT_LT] = ACTIONS(813),
    [anon_sym_LT_LT_DASH] = ACTIONS(811),
    [anon_sym_LT_LT_LT] = ACTIONS(811),
    [sym__special_characters] = ACTIONS(811),
    [anon_sym_DQUOTE] = ACTIONS(811),
    [anon_sym_DOLLAR] = ACTIONS(813),
    [sym_raw_string] = ACTIONS(811),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(811),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(811),
    [anon_sym_BQUOTE] = ACTIONS(811),
    [anon_sym_LT_LPAREN] = ACTIONS(811),
    [anon_sym_GT_LPAREN] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(813),
    [anon_sym_LF] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(813),
  },
  [147] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(817),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [148] = {
    [sym__concat] = ACTIONS(827),
    [anon_sym_DQUOTE] = ACTIONS(829),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym__string_content] = ACTIONS(831),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(829),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(829),
    [anon_sym_BQUOTE] = ACTIONS(829),
    [sym_comment] = ACTIONS(281),
  },
  [149] = {
    [sym_subscript] = STATE(465),
    [sym_variable_name] = ACTIONS(833),
    [anon_sym_BANG] = ACTIONS(835),
    [anon_sym_DASH] = ACTIONS(837),
    [anon_sym_DOLLAR] = ACTIONS(837),
    [anon_sym_POUND] = ACTIONS(835),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(839),
    [anon_sym_STAR] = ACTIONS(841),
    [anon_sym_AT] = ACTIONS(841),
    [anon_sym_QMARK] = ACTIONS(841),
    [anon_sym_0] = ACTIONS(839),
    [anon_sym__] = ACTIONS(839),
  },
  [150] = {
    [sym__terminated_statement] = STATE(468),
    [sym_for_statement] = STATE(466),
    [sym_c_style_for_statement] = STATE(466),
    [sym_while_statement] = STATE(466),
    [sym_if_statement] = STATE(466),
    [sym_case_statement] = STATE(466),
    [sym_function_definition] = STATE(466),
    [sym_subshell] = STATE(466),
    [sym_pipeline] = STATE(466),
    [sym_list] = STATE(466),
    [sym_negated_command] = STATE(466),
    [sym_test_command] = STATE(466),
    [sym_declaration_command] = STATE(466),
    [sym_unset_command] = STATE(466),
    [sym_command] = STATE(466),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(467),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(468),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [151] = {
    [sym__terminated_statement] = STATE(471),
    [sym_for_statement] = STATE(469),
    [sym_c_style_for_statement] = STATE(469),
    [sym_while_statement] = STATE(469),
    [sym_if_statement] = STATE(469),
    [sym_case_statement] = STATE(469),
    [sym_function_definition] = STATE(469),
    [sym_subshell] = STATE(469),
    [sym_pipeline] = STATE(469),
    [sym_list] = STATE(469),
    [sym_negated_command] = STATE(469),
    [sym_test_command] = STATE(469),
    [sym_declaration_command] = STATE(469),
    [sym_unset_command] = STATE(469),
    [sym_command] = STATE(469),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(470),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(471),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [152] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(817),
    [anon_sym_DOLLAR] = ACTIONS(843),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [153] = {
    [sym__simple_heredoc_body] = ACTIONS(845),
    [sym__heredoc_body_beginning] = ACTIONS(845),
    [sym_file_descriptor] = ACTIONS(845),
    [sym__concat] = ACTIONS(845),
    [ts_builtin_sym_end] = ACTIONS(845),
    [anon_sym_SEMI] = ACTIONS(847),
    [anon_sym_PIPE] = ACTIONS(847),
    [anon_sym_RPAREN] = ACTIONS(845),
    [anon_sym_SEMI_SEMI] = ACTIONS(845),
    [anon_sym_PIPE_AMP] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [anon_sym_EQ_TILDE] = ACTIONS(847),
    [anon_sym_EQ_EQ] = ACTIONS(847),
    [anon_sym_LT] = ACTIONS(847),
    [anon_sym_GT] = ACTIONS(847),
    [anon_sym_GT_GT] = ACTIONS(845),
    [anon_sym_AMP_GT] = ACTIONS(847),
    [anon_sym_AMP_GT_GT] = ACTIONS(845),
    [anon_sym_LT_AMP] = ACTIONS(845),
    [anon_sym_GT_AMP] = ACTIONS(845),
    [anon_sym_LT_LT] = ACTIONS(847),
    [anon_sym_LT_LT_DASH] = ACTIONS(845),
    [anon_sym_LT_LT_LT] = ACTIONS(845),
    [sym__special_characters] = ACTIONS(845),
    [anon_sym_DQUOTE] = ACTIONS(845),
    [anon_sym_DOLLAR] = ACTIONS(847),
    [sym_raw_string] = ACTIONS(845),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(845),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(845),
    [anon_sym_BQUOTE] = ACTIONS(845),
    [anon_sym_LT_LPAREN] = ACTIONS(845),
    [anon_sym_GT_LPAREN] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(847),
    [anon_sym_LF] = ACTIONS(845),
    [anon_sym_AMP] = ACTIONS(847),
  },
  [154] = {
    [sym__simple_heredoc_body] = ACTIONS(849),
    [sym__heredoc_body_beginning] = ACTIONS(849),
    [sym_file_descriptor] = ACTIONS(849),
    [sym__concat] = ACTIONS(849),
    [ts_builtin_sym_end] = ACTIONS(849),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_PIPE] = ACTIONS(851),
    [anon_sym_RPAREN] = ACTIONS(849),
    [anon_sym_SEMI_SEMI] = ACTIONS(849),
    [anon_sym_PIPE_AMP] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [anon_sym_EQ_TILDE] = ACTIONS(851),
    [anon_sym_EQ_EQ] = ACTIONS(851),
    [anon_sym_LT] = ACTIONS(851),
    [anon_sym_GT] = ACTIONS(851),
    [anon_sym_GT_GT] = ACTIONS(849),
    [anon_sym_AMP_GT] = ACTIONS(851),
    [anon_sym_AMP_GT_GT] = ACTIONS(849),
    [anon_sym_LT_AMP] = ACTIONS(849),
    [anon_sym_GT_AMP] = ACTIONS(849),
    [anon_sym_LT_LT] = ACTIONS(851),
    [anon_sym_LT_LT_DASH] = ACTIONS(849),
    [anon_sym_LT_LT_LT] = ACTIONS(849),
    [sym__special_characters] = ACTIONS(849),
    [anon_sym_DQUOTE] = ACTIONS(849),
    [anon_sym_DOLLAR] = ACTIONS(851),
    [sym_raw_string] = ACTIONS(849),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(849),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(849),
    [anon_sym_BQUOTE] = ACTIONS(849),
    [anon_sym_LT_LPAREN] = ACTIONS(849),
    [anon_sym_GT_LPAREN] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(851),
    [anon_sym_LF] = ACTIONS(849),
    [anon_sym_AMP] = ACTIONS(851),
  },
  [155] = {
    [sym__simple_heredoc_body] = ACTIONS(853),
    [sym__heredoc_body_beginning] = ACTIONS(853),
    [sym_file_descriptor] = ACTIONS(853),
    [sym__concat] = ACTIONS(853),
    [ts_builtin_sym_end] = ACTIONS(853),
    [anon_sym_SEMI] = ACTIONS(855),
    [anon_sym_PIPE] = ACTIONS(855),
    [anon_sym_RPAREN] = ACTIONS(853),
    [anon_sym_SEMI_SEMI] = ACTIONS(853),
    [anon_sym_PIPE_AMP] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [anon_sym_EQ_TILDE] = ACTIONS(855),
    [anon_sym_EQ_EQ] = ACTIONS(855),
    [anon_sym_LT] = ACTIONS(855),
    [anon_sym_GT] = ACTIONS(855),
    [anon_sym_GT_GT] = ACTIONS(853),
    [anon_sym_AMP_GT] = ACTIONS(855),
    [anon_sym_AMP_GT_GT] = ACTIONS(853),
    [anon_sym_LT_AMP] = ACTIONS(853),
    [anon_sym_GT_AMP] = ACTIONS(853),
    [anon_sym_LT_LT] = ACTIONS(855),
    [anon_sym_LT_LT_DASH] = ACTIONS(853),
    [anon_sym_LT_LT_LT] = ACTIONS(853),
    [sym__special_characters] = ACTIONS(853),
    [anon_sym_DQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [sym_raw_string] = ACTIONS(853),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(853),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(853),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_LT_LPAREN] = ACTIONS(853),
    [anon_sym_GT_LPAREN] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(855),
    [anon_sym_LF] = ACTIONS(853),
    [anon_sym_AMP] = ACTIONS(855),
  },
  [156] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(859),
    [sym_comment] = ACTIONS(55),
  },
  [157] = {
    [sym_subscript] = STATE(478),
    [sym_variable_name] = ACTIONS(861),
    [anon_sym_DASH] = ACTIONS(863),
    [anon_sym_DOLLAR] = ACTIONS(863),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(865),
    [anon_sym_STAR] = ACTIONS(867),
    [anon_sym_AT] = ACTIONS(867),
    [anon_sym_QMARK] = ACTIONS(867),
    [anon_sym_0] = ACTIONS(865),
    [anon_sym__] = ACTIONS(865),
  },
  [158] = {
    [sym_concatenation] = STATE(489),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(489),
    [anon_sym_RBRACE] = ACTIONS(869),
    [anon_sym_EQ] = ACTIONS(871),
    [anon_sym_DASH] = ACTIONS(871),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(881),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(885),
    [anon_sym_COLON] = ACTIONS(871),
    [anon_sym_COLON_QMARK] = ACTIONS(871),
    [anon_sym_COLON_DASH] = ACTIONS(871),
    [anon_sym_PERCENT] = ACTIONS(871),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [159] = {
    [sym_concatenation] = STATE(492),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(492),
    [anon_sym_RBRACE] = ACTIONS(895),
    [anon_sym_EQ] = ACTIONS(897),
    [anon_sym_DASH] = ACTIONS(897),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(899),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(901),
    [anon_sym_COLON] = ACTIONS(897),
    [anon_sym_COLON_QMARK] = ACTIONS(897),
    [anon_sym_COLON_DASH] = ACTIONS(897),
    [anon_sym_PERCENT] = ACTIONS(897),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [160] = {
    [anon_sym_SEMI] = ACTIONS(903),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(905),
    [anon_sym_SEMI_SEMI] = ACTIONS(907),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(907),
    [anon_sym_AMP] = ACTIONS(903),
  },
  [161] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(903),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(905),
    [anon_sym_SEMI_SEMI] = ACTIONS(907),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(907),
    [anon_sym_AMP] = ACTIONS(903),
  },
  [162] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(495),
    [sym_c_style_for_statement] = STATE(495),
    [sym_while_statement] = STATE(495),
    [sym_if_statement] = STATE(495),
    [sym_case_statement] = STATE(495),
    [sym_function_definition] = STATE(495),
    [sym_subshell] = STATE(495),
    [sym_pipeline] = STATE(495),
    [sym_list] = STATE(495),
    [sym_negated_command] = STATE(495),
    [sym_test_command] = STATE(495),
    [sym_declaration_command] = STATE(495),
    [sym_unset_command] = STATE(495),
    [sym_command] = STATE(495),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(496),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [163] = {
    [sym__expression] = STATE(497),
    [sym_binary_expression] = STATE(497),
    [sym_unary_expression] = STATE(497),
    [sym_postfix_expression] = STATE(497),
    [sym_parenthesized_expression] = STATE(497),
    [sym_concatenation] = STATE(497),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [164] = {
    [sym__terminated_statement] = STATE(498),
    [sym_for_statement] = STATE(63),
    [sym_c_style_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_case_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_subshell] = STATE(63),
    [sym_pipeline] = STATE(63),
    [sym_list] = STATE(63),
    [sym_negated_command] = STATE(63),
    [sym_test_command] = STATE(63),
    [sym_declaration_command] = STATE(63),
    [sym_unset_command] = STATE(63),
    [sym_command] = STATE(63),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(65),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [165] = {
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(909),
  },
  [166] = {
    [sym_subshell] = STATE(98),
    [sym_test_command] = STATE(98),
    [sym_command] = STATE(98),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(176),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(115),
  },
  [167] = {
    [sym__expression] = STATE(500),
    [sym_binary_expression] = STATE(500),
    [sym_unary_expression] = STATE(500),
    [sym_postfix_expression] = STATE(500),
    [sym_parenthesized_expression] = STATE(500),
    [sym_concatenation] = STATE(500),
    [sym_string] = STATE(105),
    [sym_simple_expansion] = STATE(105),
    [sym_string_expansion] = STATE(105),
    [sym_expansion] = STATE(105),
    [sym_command_substitution] = STATE(105),
    [sym_process_substitution] = STATE(105),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [sym__special_characters] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(183),
    [sym_test_operator] = ACTIONS(185),
  },
  [168] = {
    [sym__expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_postfix_expression] = STATE(501),
    [sym_parenthesized_expression] = STATE(501),
    [sym_concatenation] = STATE(501),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(187),
    [sym__special_characters] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(193),
    [sym_test_operator] = ACTIONS(195),
  },
  [169] = {
    [sym_variable_assignment] = STATE(502),
    [sym_subscript] = STATE(277),
    [sym_concatenation] = STATE(502),
    [sym_string] = STATE(276),
    [sym_simple_expansion] = STATE(276),
    [sym_string_expansion] = STATE(276),
    [sym_expansion] = STATE(276),
    [sym_command_substitution] = STATE(276),
    [sym_process_substitution] = STATE(276),
    [aux_sym_declaration_command_repeat1] = STATE(502),
    [sym_variable_name] = ACTIONS(505),
    [anon_sym_SEMI] = ACTIONS(201),
    [anon_sym_PIPE] = ACTIONS(201),
    [anon_sym_SEMI_SEMI] = ACTIONS(199),
    [anon_sym_PIPE_AMP] = ACTIONS(199),
    [anon_sym_AMP_AMP] = ACTIONS(199),
    [anon_sym_PIPE_PIPE] = ACTIONS(199),
    [sym__special_characters] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(509),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(911),
    [sym_word] = ACTIONS(513),
    [anon_sym_LF] = ACTIONS(199),
    [anon_sym_AMP] = ACTIONS(201),
  },
  [170] = {
    [sym_concatenation] = STATE(503),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym_unset_command_repeat1] = STATE(503),
    [anon_sym_SEMI] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_SEMI_SEMI] = ACTIONS(223),
    [anon_sym_PIPE_AMP] = ACTIONS(223),
    [anon_sym_AMP_AMP] = ACTIONS(223),
    [anon_sym_PIPE_PIPE] = ACTIONS(223),
    [sym__special_characters] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(517),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(913),
    [sym_word] = ACTIONS(521),
    [anon_sym_LF] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(225),
  },
  [171] = {
    [aux_sym_concatenation_repeat1] = STATE(282),
    [sym__simple_heredoc_body] = ACTIONS(291),
    [sym__heredoc_body_beginning] = ACTIONS(291),
    [sym_file_descriptor] = ACTIONS(291),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(293),
    [anon_sym_SEMI_SEMI] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(915),
    [anon_sym_PIPE_AMP] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_EQ_TILDE] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_GT] = ACTIONS(291),
    [anon_sym_AMP_GT] = ACTIONS(293),
    [anon_sym_AMP_GT_GT] = ACTIONS(291),
    [anon_sym_LT_AMP] = ACTIONS(291),
    [anon_sym_GT_AMP] = ACTIONS(291),
    [anon_sym_LT_LT] = ACTIONS(293),
    [anon_sym_LT_LT_DASH] = ACTIONS(291),
    [anon_sym_LT_LT_LT] = ACTIONS(291),
    [sym__special_characters] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(291),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(291),
    [anon_sym_BQUOTE] = ACTIONS(291),
    [anon_sym_LT_LPAREN] = ACTIONS(291),
    [anon_sym_GT_LPAREN] = ACTIONS(291),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(293),
    [anon_sym_LF] = ACTIONS(291),
    [anon_sym_AMP] = ACTIONS(293),
  },
  [172] = {
    [anon_sym_SEMI] = ACTIONS(917),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(921),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(905),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(921),
    [anon_sym_AMP] = ACTIONS(917),
  },
  [173] = {
    [sym_file_redirect] = STATE(511),
    [sym_heredoc_redirect] = STATE(511),
    [sym_heredoc_body] = STATE(193),
    [sym_herestring_redirect] = STATE(511),
    [sym_concatenation] = STATE(512),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym_while_statement_repeat1] = STATE(511),
    [aux_sym_command_repeat2] = STATE(512),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(927),
    [anon_sym_SEMI] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(347),
    [anon_sym_SEMI_SEMI] = ACTIONS(345),
    [anon_sym_PIPE_AMP] = ACTIONS(345),
    [anon_sym_AMP_AMP] = ACTIONS(345),
    [anon_sym_PIPE_PIPE] = ACTIONS(345),
    [anon_sym_EQ_TILDE] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(929),
    [anon_sym_GT] = ACTIONS(929),
    [anon_sym_GT_GT] = ACTIONS(931),
    [anon_sym_AMP_GT] = ACTIONS(929),
    [anon_sym_AMP_GT_GT] = ACTIONS(931),
    [anon_sym_LT_AMP] = ACTIONS(931),
    [anon_sym_GT_AMP] = ACTIONS(931),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(933),
    [sym__special_characters] = ACTIONS(547),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(549),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(345),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(551),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_AMP] = ACTIONS(347),
  },
  [174] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(917),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(921),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(905),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(921),
    [anon_sym_AMP] = ACTIONS(917),
  },
  [175] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(513),
    [sym_c_style_for_statement] = STATE(513),
    [sym_while_statement] = STATE(513),
    [sym_if_statement] = STATE(513),
    [sym_case_statement] = STATE(513),
    [sym_function_definition] = STATE(513),
    [sym_subshell] = STATE(513),
    [sym_pipeline] = STATE(513),
    [sym_list] = STATE(513),
    [sym_negated_command] = STATE(513),
    [sym_test_command] = STATE(513),
    [sym_declaration_command] = STATE(513),
    [sym_unset_command] = STATE(513),
    [sym_command] = STATE(513),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(514),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [176] = {
    [sym_command_name] = STATE(515),
    [sym_variable_assignment] = STATE(200),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(200),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(200),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(553),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(115),
  },
  [177] = {
    [anon_sym_SEMI] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(937),
    [anon_sym_SEMI_SEMI] = ACTIONS(939),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(935),
  },
  [178] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(937),
    [anon_sym_SEMI_SEMI] = ACTIONS(939),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(935),
  },
  [179] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(518),
    [sym_c_style_for_statement] = STATE(518),
    [sym_while_statement] = STATE(518),
    [sym_if_statement] = STATE(518),
    [sym_case_statement] = STATE(518),
    [sym_function_definition] = STATE(518),
    [sym_subshell] = STATE(518),
    [sym_pipeline] = STATE(518),
    [sym_list] = STATE(518),
    [sym_negated_command] = STATE(518),
    [sym_test_command] = STATE(518),
    [sym_declaration_command] = STATE(518),
    [sym_unset_command] = STATE(518),
    [sym_command] = STATE(518),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(519),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [180] = {
    [anon_sym_RPAREN] = ACTIONS(941),
    [sym_comment] = ACTIONS(55),
  },
  [181] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [ts_builtin_sym_end] = ACTIONS(945),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [182] = {
    [sym_for_statement] = STATE(521),
    [sym_c_style_for_statement] = STATE(521),
    [sym_while_statement] = STATE(521),
    [sym_if_statement] = STATE(521),
    [sym_case_statement] = STATE(521),
    [sym_function_definition] = STATE(521),
    [sym_subshell] = STATE(521),
    [sym_pipeline] = STATE(521),
    [sym_list] = STATE(521),
    [sym_negated_command] = STATE(521),
    [sym_test_command] = STATE(521),
    [sym_declaration_command] = STATE(521),
    [sym_unset_command] = STATE(521),
    [sym_command] = STATE(521),
    [sym_command_name] = STATE(28),
    [sym_variable_assignment] = STATE(522),
    [sym_subscript] = STATE(30),
    [sym_file_redirect] = STATE(33),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(20),
    [sym_simple_expansion] = STATE(20),
    [sym_string_expansion] = STATE(20),
    [sym_expansion] = STATE(20),
    [sym_command_substitution] = STATE(20),
    [sym_process_substitution] = STATE(20),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(29),
    [anon_sym_declare] = ACTIONS(31),
    [anon_sym_typeset] = ACTIONS(31),
    [anon_sym_export] = ACTIONS(31),
    [anon_sym_readonly] = ACTIONS(31),
    [anon_sym_local] = ACTIONS(31),
    [anon_sym_unset] = ACTIONS(33),
    [anon_sym_unsetenv] = ACTIONS(33),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(57),
  },
  [183] = {
    [sym_for_statement] = STATE(523),
    [sym_c_style_for_statement] = STATE(523),
    [sym_while_statement] = STATE(523),
    [sym_if_statement] = STATE(523),
    [sym_case_statement] = STATE(523),
    [sym_function_definition] = STATE(523),
    [sym_subshell] = STATE(523),
    [sym_pipeline] = STATE(523),
    [sym_list] = STATE(523),
    [sym_negated_command] = STATE(523),
    [sym_test_command] = STATE(523),
    [sym_declaration_command] = STATE(523),
    [sym_unset_command] = STATE(523),
    [sym_command] = STATE(523),
    [sym_command_name] = STATE(28),
    [sym_variable_assignment] = STATE(524),
    [sym_subscript] = STATE(30),
    [sym_file_redirect] = STATE(33),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(20),
    [sym_simple_expansion] = STATE(20),
    [sym_string_expansion] = STATE(20),
    [sym_expansion] = STATE(20),
    [sym_command_substitution] = STATE(20),
    [sym_process_substitution] = STATE(20),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(29),
    [anon_sym_declare] = ACTIONS(31),
    [anon_sym_typeset] = ACTIONS(31),
    [anon_sym_export] = ACTIONS(31),
    [anon_sym_readonly] = ACTIONS(31),
    [anon_sym_local] = ACTIONS(31),
    [anon_sym_unset] = ACTIONS(33),
    [anon_sym_unsetenv] = ACTIONS(33),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(57),
  },
  [184] = {
    [ts_builtin_sym_end] = ACTIONS(949),
    [anon_sym_SEMI] = ACTIONS(951),
    [anon_sym_esac] = ACTIONS(949),
    [anon_sym_PIPE] = ACTIONS(951),
    [anon_sym_RPAREN] = ACTIONS(949),
    [anon_sym_SEMI_SEMI] = ACTIONS(949),
    [anon_sym_PIPE_AMP] = ACTIONS(949),
    [anon_sym_AMP_AMP] = ACTIONS(949),
    [anon_sym_PIPE_PIPE] = ACTIONS(949),
    [anon_sym_BQUOTE] = ACTIONS(949),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(949),
    [anon_sym_AMP] = ACTIONS(951),
  },
  [185] = {
    [sym_simple_expansion] = STATE(528),
    [sym_expansion] = STATE(528),
    [aux_sym_heredoc_body_repeat1] = STATE(528),
    [sym__heredoc_body_middle] = ACTIONS(953),
    [sym__heredoc_body_end] = ACTIONS(955),
    [anon_sym_DOLLAR] = ACTIONS(957),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(959),
    [sym_comment] = ACTIONS(55),
  },
  [186] = {
    [anon_sym_LT] = ACTIONS(961),
    [anon_sym_GT] = ACTIONS(961),
    [anon_sym_GT_GT] = ACTIONS(963),
    [anon_sym_AMP_GT] = ACTIONS(961),
    [anon_sym_AMP_GT_GT] = ACTIONS(963),
    [anon_sym_LT_AMP] = ACTIONS(963),
    [anon_sym_GT_AMP] = ACTIONS(963),
    [sym_comment] = ACTIONS(55),
  },
  [187] = {
    [sym_concatenation] = STATE(530),
    [sym_string] = STATE(532),
    [sym_simple_expansion] = STATE(532),
    [sym_string_expansion] = STATE(532),
    [sym_expansion] = STATE(532),
    [sym_command_substitution] = STATE(532),
    [sym_process_substitution] = STATE(532),
    [sym_regex] = ACTIONS(965),
    [sym__special_characters] = ACTIONS(967),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(969),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(969),
  },
  [188] = {
    [sym_concatenation] = STATE(535),
    [sym_string] = STATE(534),
    [sym_simple_expansion] = STATE(534),
    [sym_string_expansion] = STATE(534),
    [sym_expansion] = STATE(534),
    [sym_command_substitution] = STATE(534),
    [sym_process_substitution] = STATE(534),
    [sym__special_characters] = ACTIONS(971),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(973),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(973),
  },
  [189] = {
    [sym_heredoc_start] = ACTIONS(975),
    [sym_comment] = ACTIONS(55),
  },
  [190] = {
    [sym_concatenation] = STATE(539),
    [sym_string] = STATE(538),
    [sym_simple_expansion] = STATE(538),
    [sym_string_expansion] = STATE(538),
    [sym_expansion] = STATE(538),
    [sym_command_substitution] = STATE(538),
    [sym_process_substitution] = STATE(538),
    [sym__special_characters] = ACTIONS(977),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(979),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(979),
  },
  [191] = {
    [aux_sym_concatenation_repeat1] = STATE(145),
    [sym__simple_heredoc_body] = ACTIONS(981),
    [sym__heredoc_body_beginning] = ACTIONS(981),
    [sym_file_descriptor] = ACTIONS(981),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(981),
    [anon_sym_SEMI] = ACTIONS(983),
    [anon_sym_PIPE] = ACTIONS(983),
    [anon_sym_SEMI_SEMI] = ACTIONS(981),
    [anon_sym_PIPE_AMP] = ACTIONS(981),
    [anon_sym_AMP_AMP] = ACTIONS(981),
    [anon_sym_PIPE_PIPE] = ACTIONS(981),
    [anon_sym_EQ_TILDE] = ACTIONS(983),
    [anon_sym_EQ_EQ] = ACTIONS(983),
    [anon_sym_LT] = ACTIONS(983),
    [anon_sym_GT] = ACTIONS(983),
    [anon_sym_GT_GT] = ACTIONS(981),
    [anon_sym_AMP_GT] = ACTIONS(983),
    [anon_sym_AMP_GT_GT] = ACTIONS(981),
    [anon_sym_LT_AMP] = ACTIONS(981),
    [anon_sym_GT_AMP] = ACTIONS(981),
    [anon_sym_LT_LT] = ACTIONS(983),
    [anon_sym_LT_LT_DASH] = ACTIONS(981),
    [anon_sym_LT_LT_LT] = ACTIONS(981),
    [sym__special_characters] = ACTIONS(981),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_DOLLAR] = ACTIONS(983),
    [sym_raw_string] = ACTIONS(981),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(981),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(981),
    [anon_sym_BQUOTE] = ACTIONS(981),
    [anon_sym_LT_LPAREN] = ACTIONS(981),
    [anon_sym_GT_LPAREN] = ACTIONS(981),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(983),
    [anon_sym_LF] = ACTIONS(981),
    [anon_sym_AMP] = ACTIONS(983),
  },
  [192] = {
    [aux_sym_concatenation_repeat1] = STATE(145),
    [sym__simple_heredoc_body] = ACTIONS(985),
    [sym__heredoc_body_beginning] = ACTIONS(985),
    [sym_file_descriptor] = ACTIONS(985),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(985),
    [anon_sym_SEMI] = ACTIONS(987),
    [anon_sym_PIPE] = ACTIONS(987),
    [anon_sym_SEMI_SEMI] = ACTIONS(985),
    [anon_sym_PIPE_AMP] = ACTIONS(985),
    [anon_sym_AMP_AMP] = ACTIONS(985),
    [anon_sym_PIPE_PIPE] = ACTIONS(985),
    [anon_sym_EQ_TILDE] = ACTIONS(987),
    [anon_sym_EQ_EQ] = ACTIONS(987),
    [anon_sym_LT] = ACTIONS(987),
    [anon_sym_GT] = ACTIONS(987),
    [anon_sym_GT_GT] = ACTIONS(985),
    [anon_sym_AMP_GT] = ACTIONS(987),
    [anon_sym_AMP_GT_GT] = ACTIONS(985),
    [anon_sym_LT_AMP] = ACTIONS(985),
    [anon_sym_GT_AMP] = ACTIONS(985),
    [anon_sym_LT_LT] = ACTIONS(987),
    [anon_sym_LT_LT_DASH] = ACTIONS(985),
    [anon_sym_LT_LT_LT] = ACTIONS(985),
    [sym__special_characters] = ACTIONS(985),
    [anon_sym_DQUOTE] = ACTIONS(985),
    [anon_sym_DOLLAR] = ACTIONS(987),
    [sym_raw_string] = ACTIONS(985),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(985),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(985),
    [anon_sym_BQUOTE] = ACTIONS(985),
    [anon_sym_LT_LPAREN] = ACTIONS(985),
    [anon_sym_GT_LPAREN] = ACTIONS(985),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(987),
    [anon_sym_LF] = ACTIONS(985),
    [anon_sym_AMP] = ACTIONS(987),
  },
  [193] = {
    [ts_builtin_sym_end] = ACTIONS(989),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_esac] = ACTIONS(989),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_RPAREN] = ACTIONS(989),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_BQUOTE] = ACTIONS(989),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [194] = {
    [sym_file_redirect] = STATE(541),
    [sym_heredoc_redirect] = STATE(541),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(541),
    [aux_sym_while_statement_repeat1] = STATE(541),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(343),
    [ts_builtin_sym_end] = ACTIONS(989),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(359),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [195] = {
    [sym_file_redirect] = STATE(542),
    [sym_heredoc_redirect] = STATE(542),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(542),
    [sym_concatenation] = STATE(543),
    [sym_string] = STATE(192),
    [sym_simple_expansion] = STATE(192),
    [sym_string_expansion] = STATE(192),
    [sym_expansion] = STATE(192),
    [sym_command_substitution] = STATE(192),
    [sym_process_substitution] = STATE(192),
    [aux_sym_while_statement_repeat1] = STATE(542),
    [aux_sym_command_repeat2] = STATE(543),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(343),
    [ts_builtin_sym_end] = ACTIONS(989),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(349),
    [anon_sym_EQ_EQ] = ACTIONS(349),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(359),
    [sym__special_characters] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(363),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [196] = {
    [ts_builtin_sym_end] = ACTIONS(945),
    [anon_sym_SEMI] = ACTIONS(993),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(337),
    [anon_sym_PIPE_PIPE] = ACTIONS(337),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(995),
    [anon_sym_AMP] = ACTIONS(993),
  },
  [197] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [ts_builtin_sym_end] = ACTIONS(945),
    [anon_sym_SEMI] = ACTIONS(993),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(337),
    [anon_sym_PIPE_PIPE] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(995),
    [anon_sym_AMP] = ACTIONS(993),
  },
  [198] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(545),
    [sym_c_style_for_statement] = STATE(545),
    [sym_while_statement] = STATE(545),
    [sym_if_statement] = STATE(545),
    [sym_case_statement] = STATE(545),
    [sym_function_definition] = STATE(545),
    [sym_subshell] = STATE(545),
    [sym_pipeline] = STATE(545),
    [sym_list] = STATE(545),
    [sym_negated_command] = STATE(545),
    [sym_test_command] = STATE(545),
    [sym_declaration_command] = STATE(545),
    [sym_unset_command] = STATE(545),
    [sym_command] = STATE(545),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(546),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(997),
    [sym_variable_name] = ACTIONS(1000),
    [anon_sym_for] = ACTIONS(1003),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1006),
    [anon_sym_while] = ACTIONS(1009),
    [anon_sym_if] = ACTIONS(1012),
    [anon_sym_case] = ACTIONS(1015),
    [anon_sym_function] = ACTIONS(1018),
    [anon_sym_LPAREN] = ACTIONS(1021),
    [anon_sym_BANG] = ACTIONS(1024),
    [anon_sym_LBRACK] = ACTIONS(1027),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1030),
    [anon_sym_declare] = ACTIONS(1033),
    [anon_sym_typeset] = ACTIONS(1033),
    [anon_sym_export] = ACTIONS(1033),
    [anon_sym_readonly] = ACTIONS(1033),
    [anon_sym_local] = ACTIONS(1033),
    [anon_sym_unset] = ACTIONS(1036),
    [anon_sym_unsetenv] = ACTIONS(1036),
    [anon_sym_LT] = ACTIONS(1039),
    [anon_sym_GT] = ACTIONS(1039),
    [anon_sym_GT_GT] = ACTIONS(1042),
    [anon_sym_AMP_GT] = ACTIONS(1039),
    [anon_sym_AMP_GT_GT] = ACTIONS(1042),
    [anon_sym_LT_AMP] = ACTIONS(1042),
    [anon_sym_GT_AMP] = ACTIONS(1042),
    [sym__special_characters] = ACTIONS(1045),
    [anon_sym_DQUOTE] = ACTIONS(1048),
    [anon_sym_DOLLAR] = ACTIONS(1051),
    [sym_raw_string] = ACTIONS(1054),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1057),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1060),
    [anon_sym_BQUOTE] = ACTIONS(1063),
    [anon_sym_LT_LPAREN] = ACTIONS(1066),
    [anon_sym_GT_LPAREN] = ACTIONS(1066),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1069),
  },
  [199] = {
    [sym_file_redirect] = STATE(542),
    [sym_heredoc_redirect] = STATE(542),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(542),
    [sym_concatenation] = STATE(547),
    [sym_string] = STATE(192),
    [sym_simple_expansion] = STATE(192),
    [sym_string_expansion] = STATE(192),
    [sym_expansion] = STATE(192),
    [sym_command_substitution] = STATE(192),
    [sym_process_substitution] = STATE(192),
    [aux_sym_while_statement_repeat1] = STATE(542),
    [aux_sym_command_repeat2] = STATE(547),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(343),
    [ts_builtin_sym_end] = ACTIONS(989),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(349),
    [anon_sym_EQ_EQ] = ACTIONS(349),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(359),
    [sym__special_characters] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(363),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [200] = {
    [sym_variable_assignment] = STATE(200),
    [sym_subscript] = STATE(99),
    [sym_file_redirect] = STATE(200),
    [aux_sym_command_repeat1] = STATE(200),
    [sym_file_descriptor] = ACTIONS(1072),
    [sym_variable_name] = ACTIONS(1075),
    [anon_sym_LT] = ACTIONS(1078),
    [anon_sym_GT] = ACTIONS(1078),
    [anon_sym_GT_GT] = ACTIONS(1081),
    [anon_sym_AMP_GT] = ACTIONS(1078),
    [anon_sym_AMP_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_AMP] = ACTIONS(1081),
    [anon_sym_GT_AMP] = ACTIONS(1081),
    [sym__special_characters] = ACTIONS(1084),
    [anon_sym_DQUOTE] = ACTIONS(1084),
    [anon_sym_DOLLAR] = ACTIONS(1086),
    [sym_raw_string] = ACTIONS(1084),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1084),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1084),
    [anon_sym_BQUOTE] = ACTIONS(1084),
    [anon_sym_LT_LPAREN] = ACTIONS(1084),
    [anon_sym_GT_LPAREN] = ACTIONS(1084),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1084),
  },
  [201] = {
    [aux_sym_concatenation_repeat1] = STATE(435),
    [sym_file_descriptor] = ACTIONS(1088),
    [sym__concat] = ACTIONS(775),
    [sym_variable_name] = ACTIONS(1088),
    [anon_sym_LT] = ACTIONS(1090),
    [anon_sym_GT] = ACTIONS(1090),
    [anon_sym_GT_GT] = ACTIONS(1088),
    [anon_sym_AMP_GT] = ACTIONS(1090),
    [anon_sym_AMP_GT_GT] = ACTIONS(1088),
    [anon_sym_LT_AMP] = ACTIONS(1088),
    [anon_sym_GT_AMP] = ACTIONS(1088),
    [sym__special_characters] = ACTIONS(1088),
    [anon_sym_DQUOTE] = ACTIONS(1088),
    [anon_sym_DOLLAR] = ACTIONS(1090),
    [sym_raw_string] = ACTIONS(1088),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1088),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1088),
    [anon_sym_BQUOTE] = ACTIONS(1088),
    [anon_sym_LT_LPAREN] = ACTIONS(1088),
    [anon_sym_GT_LPAREN] = ACTIONS(1088),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1088),
  },
  [202] = {
    [aux_sym_concatenation_repeat1] = STATE(435),
    [sym_file_descriptor] = ACTIONS(1092),
    [sym__concat] = ACTIONS(775),
    [sym_variable_name] = ACTIONS(1092),
    [anon_sym_LT] = ACTIONS(1094),
    [anon_sym_GT] = ACTIONS(1094),
    [anon_sym_GT_GT] = ACTIONS(1092),
    [anon_sym_AMP_GT] = ACTIONS(1094),
    [anon_sym_AMP_GT_GT] = ACTIONS(1092),
    [anon_sym_LT_AMP] = ACTIONS(1092),
    [anon_sym_GT_AMP] = ACTIONS(1092),
    [sym__special_characters] = ACTIONS(1092),
    [anon_sym_DQUOTE] = ACTIONS(1092),
    [anon_sym_DOLLAR] = ACTIONS(1094),
    [sym_raw_string] = ACTIONS(1092),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1092),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1092),
    [anon_sym_BQUOTE] = ACTIONS(1092),
    [anon_sym_LT_LPAREN] = ACTIONS(1092),
    [anon_sym_GT_LPAREN] = ACTIONS(1092),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1092),
  },
  [203] = {
    [sym_file_descriptor] = ACTIONS(1092),
    [sym_variable_name] = ACTIONS(1092),
    [anon_sym_LT] = ACTIONS(1094),
    [anon_sym_GT] = ACTIONS(1094),
    [anon_sym_GT_GT] = ACTIONS(1092),
    [anon_sym_AMP_GT] = ACTIONS(1094),
    [anon_sym_AMP_GT_GT] = ACTIONS(1092),
    [anon_sym_LT_AMP] = ACTIONS(1092),
    [anon_sym_GT_AMP] = ACTIONS(1092),
    [sym__special_characters] = ACTIONS(1092),
    [anon_sym_DQUOTE] = ACTIONS(1092),
    [anon_sym_DOLLAR] = ACTIONS(1094),
    [sym_raw_string] = ACTIONS(1092),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1092),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1092),
    [anon_sym_BQUOTE] = ACTIONS(1092),
    [anon_sym_LT_LPAREN] = ACTIONS(1092),
    [anon_sym_GT_LPAREN] = ACTIONS(1092),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1092),
  },
  [204] = {
    [aux_sym_concatenation_repeat1] = STATE(550),
    [sym__concat] = ACTIONS(1096),
    [anon_sym_RBRACK] = ACTIONS(1098),
    [sym_comment] = ACTIONS(55),
  },
  [205] = {
    [aux_sym_concatenation_repeat1] = STATE(550),
    [sym__concat] = ACTIONS(1100),
    [anon_sym_RBRACK] = ACTIONS(1102),
    [sym_comment] = ACTIONS(55),
  },
  [206] = {
    [sym__concat] = ACTIONS(1104),
    [anon_sym_RBRACK] = ACTIONS(1102),
    [sym_comment] = ACTIONS(55),
  },
  [207] = {
    [sym_file_descriptor] = ACTIONS(1106),
    [sym_variable_name] = ACTIONS(1106),
    [ts_builtin_sym_end] = ACTIONS(1106),
    [anon_sym_SEMI] = ACTIONS(1108),
    [anon_sym_PIPE] = ACTIONS(1108),
    [anon_sym_RPAREN] = ACTIONS(1106),
    [anon_sym_SEMI_SEMI] = ACTIONS(1106),
    [anon_sym_PIPE_AMP] = ACTIONS(1106),
    [anon_sym_AMP_AMP] = ACTIONS(1106),
    [anon_sym_PIPE_PIPE] = ACTIONS(1106),
    [anon_sym_LT] = ACTIONS(1108),
    [anon_sym_GT] = ACTIONS(1108),
    [anon_sym_GT_GT] = ACTIONS(1106),
    [anon_sym_AMP_GT] = ACTIONS(1108),
    [anon_sym_AMP_GT_GT] = ACTIONS(1106),
    [anon_sym_LT_AMP] = ACTIONS(1106),
    [anon_sym_GT_AMP] = ACTIONS(1106),
    [sym__special_characters] = ACTIONS(1106),
    [anon_sym_DQUOTE] = ACTIONS(1106),
    [anon_sym_DOLLAR] = ACTIONS(1108),
    [sym_raw_string] = ACTIONS(1106),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1106),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1106),
    [anon_sym_BQUOTE] = ACTIONS(1106),
    [anon_sym_LT_LPAREN] = ACTIONS(1106),
    [anon_sym_GT_LPAREN] = ACTIONS(1106),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1108),
    [anon_sym_LF] = ACTIONS(1106),
    [anon_sym_AMP] = ACTIONS(1108),
  },
  [208] = {
    [sym_concatenation] = STATE(563),
    [sym_string] = STATE(558),
    [sym_simple_expansion] = STATE(558),
    [sym_string_expansion] = STATE(558),
    [sym_expansion] = STATE(558),
    [sym_command_substitution] = STATE(558),
    [sym_process_substitution] = STATE(558),
    [aux_sym_for_statement_repeat1] = STATE(563),
    [anon_sym_RPAREN] = ACTIONS(1110),
    [sym__special_characters] = ACTIONS(1112),
    [anon_sym_DQUOTE] = ACTIONS(1114),
    [anon_sym_DOLLAR] = ACTIONS(1116),
    [sym_raw_string] = ACTIONS(1118),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1120),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1122),
    [anon_sym_BQUOTE] = ACTIONS(1124),
    [anon_sym_LT_LPAREN] = ACTIONS(1126),
    [anon_sym_GT_LPAREN] = ACTIONS(1126),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1118),
  },
  [209] = {
    [aux_sym_concatenation_repeat1] = STATE(565),
    [sym_file_descriptor] = ACTIONS(1128),
    [sym__concat] = ACTIONS(1130),
    [sym_variable_name] = ACTIONS(1128),
    [ts_builtin_sym_end] = ACTIONS(1128),
    [anon_sym_SEMI] = ACTIONS(1132),
    [anon_sym_PIPE] = ACTIONS(1132),
    [anon_sym_SEMI_SEMI] = ACTIONS(1128),
    [anon_sym_PIPE_AMP] = ACTIONS(1128),
    [anon_sym_AMP_AMP] = ACTIONS(1128),
    [anon_sym_PIPE_PIPE] = ACTIONS(1128),
    [anon_sym_LT] = ACTIONS(1132),
    [anon_sym_GT] = ACTIONS(1132),
    [anon_sym_GT_GT] = ACTIONS(1128),
    [anon_sym_AMP_GT] = ACTIONS(1132),
    [anon_sym_AMP_GT_GT] = ACTIONS(1128),
    [anon_sym_LT_AMP] = ACTIONS(1128),
    [anon_sym_GT_AMP] = ACTIONS(1128),
    [sym__special_characters] = ACTIONS(1128),
    [anon_sym_DQUOTE] = ACTIONS(1128),
    [anon_sym_DOLLAR] = ACTIONS(1132),
    [sym_raw_string] = ACTIONS(1128),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1128),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1128),
    [anon_sym_BQUOTE] = ACTIONS(1128),
    [anon_sym_LT_LPAREN] = ACTIONS(1128),
    [anon_sym_GT_LPAREN] = ACTIONS(1128),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1132),
    [anon_sym_LF] = ACTIONS(1128),
    [anon_sym_AMP] = ACTIONS(1132),
  },
  [210] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(568),
    [anon_sym_DQUOTE] = ACTIONS(1134),
    [anon_sym_DOLLAR] = ACTIONS(1136),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [211] = {
    [sym_string] = STATE(570),
    [anon_sym_DASH] = ACTIONS(1138),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(1138),
    [sym_raw_string] = ACTIONS(1140),
    [anon_sym_POUND] = ACTIONS(1138),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1142),
    [anon_sym_STAR] = ACTIONS(1144),
    [anon_sym_AT] = ACTIONS(1144),
    [anon_sym_QMARK] = ACTIONS(1144),
    [anon_sym_0] = ACTIONS(1142),
    [anon_sym__] = ACTIONS(1142),
  },
  [212] = {
    [aux_sym_concatenation_repeat1] = STATE(565),
    [sym_file_descriptor] = ACTIONS(1106),
    [sym__concat] = ACTIONS(1130),
    [sym_variable_name] = ACTIONS(1106),
    [ts_builtin_sym_end] = ACTIONS(1106),
    [anon_sym_SEMI] = ACTIONS(1108),
    [anon_sym_PIPE] = ACTIONS(1108),
    [anon_sym_SEMI_SEMI] = ACTIONS(1106),
    [anon_sym_PIPE_AMP] = ACTIONS(1106),
    [anon_sym_AMP_AMP] = ACTIONS(1106),
    [anon_sym_PIPE_PIPE] = ACTIONS(1106),
    [anon_sym_LT] = ACTIONS(1108),
    [anon_sym_GT] = ACTIONS(1108),
    [anon_sym_GT_GT] = ACTIONS(1106),
    [anon_sym_AMP_GT] = ACTIONS(1108),
    [anon_sym_AMP_GT_GT] = ACTIONS(1106),
    [anon_sym_LT_AMP] = ACTIONS(1106),
    [anon_sym_GT_AMP] = ACTIONS(1106),
    [sym__special_characters] = ACTIONS(1106),
    [anon_sym_DQUOTE] = ACTIONS(1106),
    [anon_sym_DOLLAR] = ACTIONS(1108),
    [sym_raw_string] = ACTIONS(1106),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1106),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1106),
    [anon_sym_BQUOTE] = ACTIONS(1106),
    [anon_sym_LT_LPAREN] = ACTIONS(1106),
    [anon_sym_GT_LPAREN] = ACTIONS(1106),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1108),
    [anon_sym_LF] = ACTIONS(1106),
    [anon_sym_AMP] = ACTIONS(1108),
  },
  [213] = {
    [sym_subscript] = STATE(575),
    [sym_variable_name] = ACTIONS(1146),
    [anon_sym_BANG] = ACTIONS(1148),
    [anon_sym_DASH] = ACTIONS(1150),
    [anon_sym_DOLLAR] = ACTIONS(1150),
    [anon_sym_POUND] = ACTIONS(1148),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1152),
    [anon_sym_STAR] = ACTIONS(1154),
    [anon_sym_AT] = ACTIONS(1154),
    [anon_sym_QMARK] = ACTIONS(1154),
    [anon_sym_0] = ACTIONS(1152),
    [anon_sym__] = ACTIONS(1152),
  },
  [214] = {
    [sym__terminated_statement] = STATE(578),
    [sym_for_statement] = STATE(576),
    [sym_c_style_for_statement] = STATE(576),
    [sym_while_statement] = STATE(576),
    [sym_if_statement] = STATE(576),
    [sym_case_statement] = STATE(576),
    [sym_function_definition] = STATE(576),
    [sym_subshell] = STATE(576),
    [sym_pipeline] = STATE(576),
    [sym_list] = STATE(576),
    [sym_negated_command] = STATE(576),
    [sym_test_command] = STATE(576),
    [sym_declaration_command] = STATE(576),
    [sym_unset_command] = STATE(576),
    [sym_command] = STATE(576),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(577),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(578),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [215] = {
    [sym__terminated_statement] = STATE(581),
    [sym_for_statement] = STATE(579),
    [sym_c_style_for_statement] = STATE(579),
    [sym_while_statement] = STATE(579),
    [sym_if_statement] = STATE(579),
    [sym_case_statement] = STATE(579),
    [sym_function_definition] = STATE(579),
    [sym_subshell] = STATE(579),
    [sym_pipeline] = STATE(579),
    [sym_list] = STATE(579),
    [sym_negated_command] = STATE(579),
    [sym_test_command] = STATE(579),
    [sym_declaration_command] = STATE(579),
    [sym_unset_command] = STATE(579),
    [sym_command] = STATE(579),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(580),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(581),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [216] = {
    [sym__terminated_statement] = STATE(584),
    [sym_for_statement] = STATE(582),
    [sym_c_style_for_statement] = STATE(582),
    [sym_while_statement] = STATE(582),
    [sym_if_statement] = STATE(582),
    [sym_case_statement] = STATE(582),
    [sym_function_definition] = STATE(582),
    [sym_subshell] = STATE(582),
    [sym_pipeline] = STATE(582),
    [sym_list] = STATE(582),
    [sym_negated_command] = STATE(582),
    [sym_test_command] = STATE(582),
    [sym_declaration_command] = STATE(582),
    [sym_unset_command] = STATE(582),
    [sym_command] = STATE(582),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(583),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(584),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [217] = {
    [sym__expression] = STATE(586),
    [sym_binary_expression] = STATE(586),
    [sym_unary_expression] = STATE(586),
    [sym_postfix_expression] = STATE(586),
    [sym_parenthesized_expression] = STATE(586),
    [sym_concatenation] = STATE(586),
    [sym_string] = STATE(223),
    [sym_simple_expansion] = STATE(223),
    [sym_string_expansion] = STATE(223),
    [sym_expansion] = STATE(223),
    [sym_command_substitution] = STATE(223),
    [sym_process_substitution] = STATE(223),
    [anon_sym_SEMI] = ACTIONS(1156),
    [anon_sym_SEMI_SEMI] = ACTIONS(1158),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(407),
    [sym__special_characters] = ACTIONS(409),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(423),
    [anon_sym_GT_LPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(425),
    [sym_test_operator] = ACTIONS(427),
    [anon_sym_LF] = ACTIONS(1158),
    [anon_sym_AMP] = ACTIONS(1158),
  },
  [218] = {
    [sym__expression] = STATE(587),
    [sym_binary_expression] = STATE(587),
    [sym_unary_expression] = STATE(587),
    [sym_postfix_expression] = STATE(587),
    [sym_parenthesized_expression] = STATE(587),
    [sym_concatenation] = STATE(587),
    [sym_string] = STATE(236),
    [sym_simple_expansion] = STATE(236),
    [sym_string_expansion] = STATE(236),
    [sym_expansion] = STATE(236),
    [sym_command_substitution] = STATE(236),
    [sym_process_substitution] = STATE(236),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [sym__special_characters] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(455),
    [sym_test_operator] = ACTIONS(457),
  },
  [219] = {
    [sym__expression] = STATE(588),
    [sym_binary_expression] = STATE(588),
    [sym_unary_expression] = STATE(588),
    [sym_postfix_expression] = STATE(588),
    [sym_parenthesized_expression] = STATE(588),
    [sym_concatenation] = STATE(588),
    [sym_string] = STATE(223),
    [sym_simple_expansion] = STATE(223),
    [sym_string_expansion] = STATE(223),
    [sym_expansion] = STATE(223),
    [sym_command_substitution] = STATE(223),
    [sym_process_substitution] = STATE(223),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(407),
    [sym__special_characters] = ACTIONS(409),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(423),
    [anon_sym_GT_LPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(425),
    [sym_test_operator] = ACTIONS(427),
  },
  [220] = {
    [aux_sym_concatenation_repeat1] = STATE(590),
    [sym__concat] = ACTIONS(1160),
    [anon_sym_SEMI] = ACTIONS(463),
    [anon_sym_SEMI_SEMI] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_EQ_TILDE] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(461),
    [anon_sym_LF] = ACTIONS(461),
    [anon_sym_AMP] = ACTIONS(463),
  },
  [221] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(593),
    [anon_sym_DQUOTE] = ACTIONS(1162),
    [anon_sym_DOLLAR] = ACTIONS(1164),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [222] = {
    [sym_string] = STATE(595),
    [anon_sym_DASH] = ACTIONS(1166),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(1166),
    [sym_raw_string] = ACTIONS(1168),
    [anon_sym_POUND] = ACTIONS(1166),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1170),
    [anon_sym_STAR] = ACTIONS(1172),
    [anon_sym_AT] = ACTIONS(1172),
    [anon_sym_QMARK] = ACTIONS(1172),
    [anon_sym_0] = ACTIONS(1170),
    [anon_sym__] = ACTIONS(1170),
  },
  [223] = {
    [aux_sym_concatenation_repeat1] = STATE(590),
    [sym__concat] = ACTIONS(1160),
    [anon_sym_SEMI] = ACTIONS(479),
    [anon_sym_SEMI_SEMI] = ACTIONS(477),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_EQ_TILDE] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(477),
    [anon_sym_LF] = ACTIONS(477),
    [anon_sym_AMP] = ACTIONS(479),
  },
  [224] = {
    [sym_subscript] = STATE(600),
    [sym_variable_name] = ACTIONS(1174),
    [anon_sym_BANG] = ACTIONS(1176),
    [anon_sym_DASH] = ACTIONS(1178),
    [anon_sym_DOLLAR] = ACTIONS(1178),
    [anon_sym_POUND] = ACTIONS(1176),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1180),
    [anon_sym_STAR] = ACTIONS(1182),
    [anon_sym_AT] = ACTIONS(1182),
    [anon_sym_QMARK] = ACTIONS(1182),
    [anon_sym_0] = ACTIONS(1180),
    [anon_sym__] = ACTIONS(1180),
  },
  [225] = {
    [sym__terminated_statement] = STATE(603),
    [sym_for_statement] = STATE(601),
    [sym_c_style_for_statement] = STATE(601),
    [sym_while_statement] = STATE(601),
    [sym_if_statement] = STATE(601),
    [sym_case_statement] = STATE(601),
    [sym_function_definition] = STATE(601),
    [sym_subshell] = STATE(601),
    [sym_pipeline] = STATE(601),
    [sym_list] = STATE(601),
    [sym_negated_command] = STATE(601),
    [sym_test_command] = STATE(601),
    [sym_declaration_command] = STATE(601),
    [sym_unset_command] = STATE(601),
    [sym_command] = STATE(601),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(602),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(603),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [226] = {
    [sym__terminated_statement] = STATE(606),
    [sym_for_statement] = STATE(604),
    [sym_c_style_for_statement] = STATE(604),
    [sym_while_statement] = STATE(604),
    [sym_if_statement] = STATE(604),
    [sym_case_statement] = STATE(604),
    [sym_function_definition] = STATE(604),
    [sym_subshell] = STATE(604),
    [sym_pipeline] = STATE(604),
    [sym_list] = STATE(604),
    [sym_negated_command] = STATE(604),
    [sym_test_command] = STATE(604),
    [sym_declaration_command] = STATE(604),
    [sym_unset_command] = STATE(604),
    [sym_command] = STATE(604),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(605),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(606),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [227] = {
    [sym__terminated_statement] = STATE(609),
    [sym_for_statement] = STATE(607),
    [sym_c_style_for_statement] = STATE(607),
    [sym_while_statement] = STATE(607),
    [sym_if_statement] = STATE(607),
    [sym_case_statement] = STATE(607),
    [sym_function_definition] = STATE(607),
    [sym_subshell] = STATE(607),
    [sym_pipeline] = STATE(607),
    [sym_list] = STATE(607),
    [sym_negated_command] = STATE(607),
    [sym_test_command] = STATE(607),
    [sym_declaration_command] = STATE(607),
    [sym_unset_command] = STATE(607),
    [sym_command] = STATE(607),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(608),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(609),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [228] = {
    [anon_sym_SEMI] = ACTIONS(1184),
    [anon_sym_SEMI_SEMI] = ACTIONS(1186),
    [anon_sym_AMP_AMP] = ACTIONS(1188),
    [anon_sym_PIPE_PIPE] = ACTIONS(1188),
    [anon_sym_EQ_TILDE] = ACTIONS(1190),
    [anon_sym_EQ_EQ] = ACTIONS(1190),
    [anon_sym_EQ] = ACTIONS(1192),
    [anon_sym_PLUS_EQ] = ACTIONS(1188),
    [anon_sym_LT] = ACTIONS(1192),
    [anon_sym_GT] = ACTIONS(1192),
    [anon_sym_BANG_EQ] = ACTIONS(1188),
    [anon_sym_PLUS] = ACTIONS(1192),
    [anon_sym_DASH] = ACTIONS(1192),
    [anon_sym_DASH_EQ] = ACTIONS(1188),
    [anon_sym_LT_EQ] = ACTIONS(1188),
    [anon_sym_GT_EQ] = ACTIONS(1188),
    [anon_sym_PLUS_PLUS] = ACTIONS(1194),
    [anon_sym_DASH_DASH] = ACTIONS(1194),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1188),
    [anon_sym_LF] = ACTIONS(1186),
    [anon_sym_AMP] = ACTIONS(1184),
  },
  [229] = {
    [sym_concatenation] = STATE(622),
    [sym_string] = STATE(617),
    [sym_simple_expansion] = STATE(617),
    [sym_string_expansion] = STATE(617),
    [sym_expansion] = STATE(617),
    [sym_command_substitution] = STATE(617),
    [sym_process_substitution] = STATE(617),
    [aux_sym_for_statement_repeat1] = STATE(622),
    [sym__special_characters] = ACTIONS(1196),
    [anon_sym_DQUOTE] = ACTIONS(1198),
    [anon_sym_DOLLAR] = ACTIONS(1200),
    [sym_raw_string] = ACTIONS(1202),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1204),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1206),
    [anon_sym_BQUOTE] = ACTIONS(1208),
    [anon_sym_LT_LPAREN] = ACTIONS(1210),
    [anon_sym_GT_LPAREN] = ACTIONS(1210),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1202),
  },
  [230] = {
    [sym_do_group] = STATE(624),
    [anon_sym_do] = ACTIONS(1212),
    [sym_comment] = ACTIONS(55),
  },
  [231] = {
    [sym__expression] = STATE(625),
    [sym_binary_expression] = STATE(625),
    [sym_unary_expression] = STATE(625),
    [sym_postfix_expression] = STATE(625),
    [sym_parenthesized_expression] = STATE(625),
    [sym_concatenation] = STATE(625),
    [sym_string] = STATE(236),
    [sym_simple_expansion] = STATE(236),
    [sym_string_expansion] = STATE(236),
    [sym_expansion] = STATE(236),
    [sym_command_substitution] = STATE(236),
    [sym_process_substitution] = STATE(236),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [sym__special_characters] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(455),
    [sym_test_operator] = ACTIONS(457),
  },
  [232] = {
    [sym__expression] = STATE(626),
    [sym_binary_expression] = STATE(626),
    [sym_unary_expression] = STATE(626),
    [sym_postfix_expression] = STATE(626),
    [sym_parenthesized_expression] = STATE(626),
    [sym_concatenation] = STATE(626),
    [sym_string] = STATE(236),
    [sym_simple_expansion] = STATE(236),
    [sym_string_expansion] = STATE(236),
    [sym_expansion] = STATE(236),
    [sym_command_substitution] = STATE(236),
    [sym_process_substitution] = STATE(236),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [sym__special_characters] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(455),
    [sym_test_operator] = ACTIONS(457),
  },
  [233] = {
    [aux_sym_concatenation_repeat1] = STATE(628),
    [sym__concat] = ACTIONS(1214),
    [anon_sym_RPAREN] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_EQ_TILDE] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(461),
  },
  [234] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(631),
    [anon_sym_DQUOTE] = ACTIONS(1216),
    [anon_sym_DOLLAR] = ACTIONS(1218),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [235] = {
    [sym_string] = STATE(633),
    [anon_sym_DASH] = ACTIONS(1220),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(1220),
    [sym_raw_string] = ACTIONS(1222),
    [anon_sym_POUND] = ACTIONS(1220),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1224),
    [anon_sym_STAR] = ACTIONS(1226),
    [anon_sym_AT] = ACTIONS(1226),
    [anon_sym_QMARK] = ACTIONS(1226),
    [anon_sym_0] = ACTIONS(1224),
    [anon_sym__] = ACTIONS(1224),
  },
  [236] = {
    [aux_sym_concatenation_repeat1] = STATE(628),
    [sym__concat] = ACTIONS(1214),
    [anon_sym_RPAREN] = ACTIONS(477),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_EQ_TILDE] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(477),
  },
  [237] = {
    [sym_subscript] = STATE(638),
    [sym_variable_name] = ACTIONS(1228),
    [anon_sym_BANG] = ACTIONS(1230),
    [anon_sym_DASH] = ACTIONS(1232),
    [anon_sym_DOLLAR] = ACTIONS(1232),
    [anon_sym_POUND] = ACTIONS(1230),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1234),
    [anon_sym_STAR] = ACTIONS(1236),
    [anon_sym_AT] = ACTIONS(1236),
    [anon_sym_QMARK] = ACTIONS(1236),
    [anon_sym_0] = ACTIONS(1234),
    [anon_sym__] = ACTIONS(1234),
  },
  [238] = {
    [sym__terminated_statement] = STATE(641),
    [sym_for_statement] = STATE(639),
    [sym_c_style_for_statement] = STATE(639),
    [sym_while_statement] = STATE(639),
    [sym_if_statement] = STATE(639),
    [sym_case_statement] = STATE(639),
    [sym_function_definition] = STATE(639),
    [sym_subshell] = STATE(639),
    [sym_pipeline] = STATE(639),
    [sym_list] = STATE(639),
    [sym_negated_command] = STATE(639),
    [sym_test_command] = STATE(639),
    [sym_declaration_command] = STATE(639),
    [sym_unset_command] = STATE(639),
    [sym_command] = STATE(639),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(640),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(641),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [239] = {
    [sym__terminated_statement] = STATE(644),
    [sym_for_statement] = STATE(642),
    [sym_c_style_for_statement] = STATE(642),
    [sym_while_statement] = STATE(642),
    [sym_if_statement] = STATE(642),
    [sym_case_statement] = STATE(642),
    [sym_function_definition] = STATE(642),
    [sym_subshell] = STATE(642),
    [sym_pipeline] = STATE(642),
    [sym_list] = STATE(642),
    [sym_negated_command] = STATE(642),
    [sym_test_command] = STATE(642),
    [sym_declaration_command] = STATE(642),
    [sym_unset_command] = STATE(642),
    [sym_command] = STATE(642),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(643),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(644),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [240] = {
    [sym__terminated_statement] = STATE(647),
    [sym_for_statement] = STATE(645),
    [sym_c_style_for_statement] = STATE(645),
    [sym_while_statement] = STATE(645),
    [sym_if_statement] = STATE(645),
    [sym_case_statement] = STATE(645),
    [sym_function_definition] = STATE(645),
    [sym_subshell] = STATE(645),
    [sym_pipeline] = STATE(645),
    [sym_list] = STATE(645),
    [sym_negated_command] = STATE(645),
    [sym_test_command] = STATE(645),
    [sym_declaration_command] = STATE(645),
    [sym_unset_command] = STATE(645),
    [sym_command] = STATE(645),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(646),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(647),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [241] = {
    [anon_sym_RPAREN] = ACTIONS(1238),
    [anon_sym_AMP_AMP] = ACTIONS(1240),
    [anon_sym_PIPE_PIPE] = ACTIONS(1240),
    [anon_sym_EQ_TILDE] = ACTIONS(1242),
    [anon_sym_EQ_EQ] = ACTIONS(1242),
    [anon_sym_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_EQ] = ACTIONS(1240),
    [anon_sym_LT] = ACTIONS(1244),
    [anon_sym_GT] = ACTIONS(1244),
    [anon_sym_BANG_EQ] = ACTIONS(1240),
    [anon_sym_PLUS] = ACTIONS(1244),
    [anon_sym_DASH] = ACTIONS(1244),
    [anon_sym_DASH_EQ] = ACTIONS(1240),
    [anon_sym_LT_EQ] = ACTIONS(1240),
    [anon_sym_GT_EQ] = ACTIONS(1240),
    [anon_sym_PLUS_PLUS] = ACTIONS(1246),
    [anon_sym_DASH_DASH] = ACTIONS(1246),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1240),
  },
  [242] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1248),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_EQ_TILDE] = ACTIONS(495),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_DASH_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(493),
  },
  [243] = {
    [sym_string] = STATE(652),
    [sym_simple_expansion] = STATE(652),
    [sym_string_expansion] = STATE(652),
    [sym_expansion] = STATE(652),
    [sym_command_substitution] = STATE(652),
    [sym_process_substitution] = STATE(652),
    [sym__special_characters] = ACTIONS(1250),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(1250),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1250),
  },
  [244] = {
    [aux_sym_concatenation_repeat1] = STATE(653),
    [sym__concat] = ACTIONS(459),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(807),
    [anon_sym_EQ_EQ] = ACTIONS(807),
    [anon_sym_EQ] = ACTIONS(809),
    [anon_sym_PLUS_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_BANG_EQ] = ACTIONS(807),
    [anon_sym_PLUS] = ACTIONS(809),
    [anon_sym_DASH] = ACTIONS(809),
    [anon_sym_DASH_EQ] = ACTIONS(807),
    [anon_sym_LT_EQ] = ACTIONS(807),
    [anon_sym_GT_EQ] = ACTIONS(807),
    [anon_sym_PLUS_PLUS] = ACTIONS(807),
    [anon_sym_DASH_DASH] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(807),
  },
  [245] = {
    [sym__concat] = ACTIONS(811),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(811),
    [anon_sym_EQ_TILDE] = ACTIONS(811),
    [anon_sym_EQ_EQ] = ACTIONS(811),
    [anon_sym_EQ] = ACTIONS(813),
    [anon_sym_PLUS_EQ] = ACTIONS(811),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_BANG_EQ] = ACTIONS(811),
    [anon_sym_PLUS] = ACTIONS(813),
    [anon_sym_DASH] = ACTIONS(813),
    [anon_sym_DASH_EQ] = ACTIONS(811),
    [anon_sym_LT_EQ] = ACTIONS(811),
    [anon_sym_GT_EQ] = ACTIONS(811),
    [anon_sym_PLUS_PLUS] = ACTIONS(811),
    [anon_sym_DASH_DASH] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(811),
  },
  [246] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(1252),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [247] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(1252),
    [anon_sym_DOLLAR] = ACTIONS(1254),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [248] = {
    [sym__concat] = ACTIONS(845),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(845),
    [anon_sym_EQ_TILDE] = ACTIONS(845),
    [anon_sym_EQ_EQ] = ACTIONS(845),
    [anon_sym_EQ] = ACTIONS(847),
    [anon_sym_PLUS_EQ] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(847),
    [anon_sym_GT] = ACTIONS(847),
    [anon_sym_BANG_EQ] = ACTIONS(845),
    [anon_sym_PLUS] = ACTIONS(847),
    [anon_sym_DASH] = ACTIONS(847),
    [anon_sym_DASH_EQ] = ACTIONS(845),
    [anon_sym_LT_EQ] = ACTIONS(845),
    [anon_sym_GT_EQ] = ACTIONS(845),
    [anon_sym_PLUS_PLUS] = ACTIONS(845),
    [anon_sym_DASH_DASH] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(845),
  },
  [249] = {
    [sym__concat] = ACTIONS(849),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(849),
    [anon_sym_EQ_TILDE] = ACTIONS(849),
    [anon_sym_EQ_EQ] = ACTIONS(849),
    [anon_sym_EQ] = ACTIONS(851),
    [anon_sym_PLUS_EQ] = ACTIONS(849),
    [anon_sym_LT] = ACTIONS(851),
    [anon_sym_GT] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(849),
    [anon_sym_PLUS] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(851),
    [anon_sym_DASH_EQ] = ACTIONS(849),
    [anon_sym_LT_EQ] = ACTIONS(849),
    [anon_sym_GT_EQ] = ACTIONS(849),
    [anon_sym_PLUS_PLUS] = ACTIONS(849),
    [anon_sym_DASH_DASH] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(849),
  },
  [250] = {
    [sym__concat] = ACTIONS(853),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(853),
    [anon_sym_EQ_TILDE] = ACTIONS(853),
    [anon_sym_EQ_EQ] = ACTIONS(853),
    [anon_sym_EQ] = ACTIONS(855),
    [anon_sym_PLUS_EQ] = ACTIONS(853),
    [anon_sym_LT] = ACTIONS(855),
    [anon_sym_GT] = ACTIONS(855),
    [anon_sym_BANG_EQ] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(855),
    [anon_sym_DASH] = ACTIONS(855),
    [anon_sym_DASH_EQ] = ACTIONS(853),
    [anon_sym_LT_EQ] = ACTIONS(853),
    [anon_sym_GT_EQ] = ACTIONS(853),
    [anon_sym_PLUS_PLUS] = ACTIONS(853),
    [anon_sym_DASH_DASH] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(853),
  },
  [251] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1256),
    [sym_comment] = ACTIONS(55),
  },
  [252] = {
    [sym_subscript] = STATE(659),
    [sym_variable_name] = ACTIONS(1258),
    [anon_sym_DASH] = ACTIONS(1260),
    [anon_sym_DOLLAR] = ACTIONS(1260),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1262),
    [anon_sym_STAR] = ACTIONS(1264),
    [anon_sym_AT] = ACTIONS(1264),
    [anon_sym_QMARK] = ACTIONS(1264),
    [anon_sym_0] = ACTIONS(1262),
    [anon_sym__] = ACTIONS(1262),
  },
  [253] = {
    [sym_concatenation] = STATE(662),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(662),
    [anon_sym_RBRACE] = ACTIONS(1266),
    [anon_sym_EQ] = ACTIONS(1268),
    [anon_sym_DASH] = ACTIONS(1268),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1270),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1272),
    [anon_sym_COLON] = ACTIONS(1268),
    [anon_sym_COLON_QMARK] = ACTIONS(1268),
    [anon_sym_COLON_DASH] = ACTIONS(1268),
    [anon_sym_PERCENT] = ACTIONS(1268),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [254] = {
    [sym_concatenation] = STATE(665),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(665),
    [anon_sym_RBRACE] = ACTIONS(1274),
    [anon_sym_EQ] = ACTIONS(1276),
    [anon_sym_DASH] = ACTIONS(1276),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1278),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1280),
    [anon_sym_COLON] = ACTIONS(1276),
    [anon_sym_COLON_QMARK] = ACTIONS(1276),
    [anon_sym_COLON_DASH] = ACTIONS(1276),
    [anon_sym_PERCENT] = ACTIONS(1276),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [255] = {
    [anon_sym_SEMI] = ACTIONS(1282),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1284),
    [anon_sym_SEMI_SEMI] = ACTIONS(1286),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1286),
    [anon_sym_AMP] = ACTIONS(1282),
  },
  [256] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1282),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1284),
    [anon_sym_SEMI_SEMI] = ACTIONS(1286),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1286),
    [anon_sym_AMP] = ACTIONS(1282),
  },
  [257] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(668),
    [sym_c_style_for_statement] = STATE(668),
    [sym_while_statement] = STATE(668),
    [sym_if_statement] = STATE(668),
    [sym_case_statement] = STATE(668),
    [sym_function_definition] = STATE(668),
    [sym_subshell] = STATE(668),
    [sym_pipeline] = STATE(668),
    [sym_list] = STATE(668),
    [sym_negated_command] = STATE(668),
    [sym_test_command] = STATE(668),
    [sym_declaration_command] = STATE(668),
    [sym_unset_command] = STATE(668),
    [sym_command] = STATE(668),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(669),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [258] = {
    [anon_sym_SEMI] = ACTIONS(1288),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1290),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1284),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1290),
    [anon_sym_AMP] = ACTIONS(1288),
  },
  [259] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1288),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1290),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1284),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1290),
    [anon_sym_AMP] = ACTIONS(1288),
  },
  [260] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(671),
    [sym_c_style_for_statement] = STATE(671),
    [sym_while_statement] = STATE(671),
    [sym_if_statement] = STATE(671),
    [sym_case_statement] = STATE(671),
    [sym_function_definition] = STATE(671),
    [sym_subshell] = STATE(671),
    [sym_pipeline] = STATE(671),
    [sym_list] = STATE(671),
    [sym_negated_command] = STATE(671),
    [sym_test_command] = STATE(671),
    [sym_declaration_command] = STATE(671),
    [sym_unset_command] = STATE(671),
    [sym_command] = STATE(671),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(672),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [261] = {
    [anon_sym_SEMI] = ACTIONS(1292),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1294),
    [anon_sym_SEMI_SEMI] = ACTIONS(1296),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1296),
    [anon_sym_AMP] = ACTIONS(1292),
  },
  [262] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1292),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1294),
    [anon_sym_SEMI_SEMI] = ACTIONS(1296),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1296),
    [anon_sym_AMP] = ACTIONS(1292),
  },
  [263] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(675),
    [sym_c_style_for_statement] = STATE(675),
    [sym_while_statement] = STATE(675),
    [sym_if_statement] = STATE(675),
    [sym_case_statement] = STATE(675),
    [sym_function_definition] = STATE(675),
    [sym_subshell] = STATE(675),
    [sym_pipeline] = STATE(675),
    [sym_list] = STATE(675),
    [sym_negated_command] = STATE(675),
    [sym_test_command] = STATE(675),
    [sym_declaration_command] = STATE(675),
    [sym_unset_command] = STATE(675),
    [sym_command] = STATE(675),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(676),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [264] = {
    [sym_file_redirect] = STATE(681),
    [sym_heredoc_redirect] = STATE(681),
    [sym_herestring_redirect] = STATE(681),
    [aux_sym_while_statement_repeat1] = STATE(681),
    [sym_file_descriptor] = ACTIONS(1298),
    [ts_builtin_sym_end] = ACTIONS(1300),
    [anon_sym_SEMI] = ACTIONS(1302),
    [anon_sym_PIPE] = ACTIONS(1302),
    [anon_sym_SEMI_SEMI] = ACTIONS(1300),
    [anon_sym_PIPE_AMP] = ACTIONS(1300),
    [anon_sym_AMP_AMP] = ACTIONS(1300),
    [anon_sym_PIPE_PIPE] = ACTIONS(1300),
    [anon_sym_LT] = ACTIONS(1304),
    [anon_sym_GT] = ACTIONS(1304),
    [anon_sym_GT_GT] = ACTIONS(1306),
    [anon_sym_AMP_GT] = ACTIONS(1304),
    [anon_sym_AMP_GT_GT] = ACTIONS(1306),
    [anon_sym_LT_AMP] = ACTIONS(1306),
    [anon_sym_GT_AMP] = ACTIONS(1306),
    [anon_sym_LT_LT] = ACTIONS(1308),
    [anon_sym_LT_LT_DASH] = ACTIONS(1310),
    [anon_sym_LT_LT_LT] = ACTIONS(1312),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1300),
    [anon_sym_AMP] = ACTIONS(1302),
  },
  [265] = {
    [sym__expression] = STATE(682),
    [sym_binary_expression] = STATE(682),
    [sym_unary_expression] = STATE(682),
    [sym_postfix_expression] = STATE(682),
    [sym_parenthesized_expression] = STATE(682),
    [sym_concatenation] = STATE(682),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [266] = {
    [sym__expression] = STATE(682),
    [sym_binary_expression] = STATE(682),
    [sym_unary_expression] = STATE(682),
    [sym_postfix_expression] = STATE(682),
    [sym_parenthesized_expression] = STATE(682),
    [sym_concatenation] = STATE(682),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [sym_regex] = ACTIONS(1314),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [267] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1316),
    [anon_sym_AMP_AMP] = ACTIONS(1316),
    [anon_sym_PIPE_PIPE] = ACTIONS(1316),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1316),
    [anon_sym_EQ_TILDE] = ACTIONS(1316),
    [anon_sym_EQ_EQ] = ACTIONS(1316),
    [anon_sym_EQ] = ACTIONS(1318),
    [anon_sym_PLUS_EQ] = ACTIONS(1316),
    [anon_sym_LT] = ACTIONS(1318),
    [anon_sym_GT] = ACTIONS(1318),
    [anon_sym_BANG_EQ] = ACTIONS(1316),
    [anon_sym_PLUS] = ACTIONS(1318),
    [anon_sym_DASH] = ACTIONS(1318),
    [anon_sym_DASH_EQ] = ACTIONS(1316),
    [anon_sym_LT_EQ] = ACTIONS(1316),
    [anon_sym_GT_EQ] = ACTIONS(1316),
    [anon_sym_PLUS_PLUS] = ACTIONS(1316),
    [anon_sym_DASH_DASH] = ACTIONS(1316),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1316),
  },
  [268] = {
    [sym_concatenation] = STATE(207),
    [sym_string] = STATE(685),
    [sym_array] = STATE(207),
    [sym_simple_expansion] = STATE(685),
    [sym_string_expansion] = STATE(685),
    [sym_expansion] = STATE(685),
    [sym_command_substitution] = STATE(685),
    [sym_process_substitution] = STATE(685),
    [sym__empty_value] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(383),
    [sym__special_characters] = ACTIONS(1320),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(389),
    [sym_raw_string] = ACTIONS(1322),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(393),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(397),
    [anon_sym_LT_LPAREN] = ACTIONS(399),
    [anon_sym_GT_LPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1322),
  },
  [269] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1324),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_EQ_TILDE] = ACTIONS(495),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_DASH_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(493),
  },
  [270] = {
    [sym_do_group] = STATE(687),
    [anon_sym_do] = ACTIONS(525),
    [sym_comment] = ACTIONS(55),
  },
  [271] = {
    [sym_compound_statement] = STATE(689),
    [anon_sym_LPAREN] = ACTIONS(1326),
    [anon_sym_LBRACE] = ACTIONS(595),
    [sym_comment] = ACTIONS(55),
  },
  [272] = {
    [anon_sym_AMP_AMP] = ACTIONS(681),
    [anon_sym_PIPE_PIPE] = ACTIONS(681),
    [anon_sym_RBRACK] = ACTIONS(1324),
    [anon_sym_EQ_TILDE] = ACTIONS(683),
    [anon_sym_EQ_EQ] = ACTIONS(683),
    [anon_sym_EQ] = ACTIONS(685),
    [anon_sym_PLUS_EQ] = ACTIONS(681),
    [anon_sym_LT] = ACTIONS(685),
    [anon_sym_GT] = ACTIONS(685),
    [anon_sym_BANG_EQ] = ACTIONS(681),
    [anon_sym_PLUS] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(685),
    [anon_sym_DASH_EQ] = ACTIONS(681),
    [anon_sym_LT_EQ] = ACTIONS(681),
    [anon_sym_GT_EQ] = ACTIONS(681),
    [anon_sym_PLUS_PLUS] = ACTIONS(687),
    [anon_sym_DASH_DASH] = ACTIONS(687),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(681),
  },
  [273] = {
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1324),
    [anon_sym_EQ_TILDE] = ACTIONS(691),
    [anon_sym_EQ_EQ] = ACTIONS(691),
    [anon_sym_EQ] = ACTIONS(693),
    [anon_sym_PLUS_EQ] = ACTIONS(689),
    [anon_sym_LT] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(693),
    [anon_sym_BANG_EQ] = ACTIONS(689),
    [anon_sym_PLUS] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(693),
    [anon_sym_DASH_EQ] = ACTIONS(689),
    [anon_sym_LT_EQ] = ACTIONS(689),
    [anon_sym_GT_EQ] = ACTIONS(689),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(689),
  },
  [274] = {
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(1328),
    [anon_sym_PLUS_EQ] = ACTIONS(1328),
    [sym_comment] = ACTIONS(55),
  },
  [275] = {
    [aux_sym_concatenation_repeat1] = STATE(691),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(699),
    [anon_sym_SEMI] = ACTIONS(701),
    [anon_sym_PIPE] = ACTIONS(701),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [anon_sym_PIPE_AMP] = ACTIONS(699),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [sym__special_characters] = ACTIONS(699),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_DOLLAR] = ACTIONS(701),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(699),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(699),
    [anon_sym_BQUOTE] = ACTIONS(699),
    [anon_sym_LT_LPAREN] = ACTIONS(699),
    [anon_sym_GT_LPAREN] = ACTIONS(699),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(701),
    [sym_word] = ACTIONS(701),
    [anon_sym_LF] = ACTIONS(699),
    [anon_sym_AMP] = ACTIONS(701),
  },
  [276] = {
    [aux_sym_concatenation_repeat1] = STATE(691),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(715),
    [anon_sym_SEMI] = ACTIONS(717),
    [anon_sym_PIPE] = ACTIONS(717),
    [anon_sym_SEMI_SEMI] = ACTIONS(715),
    [anon_sym_PIPE_AMP] = ACTIONS(715),
    [anon_sym_AMP_AMP] = ACTIONS(715),
    [anon_sym_PIPE_PIPE] = ACTIONS(715),
    [sym__special_characters] = ACTIONS(715),
    [anon_sym_DQUOTE] = ACTIONS(715),
    [anon_sym_DOLLAR] = ACTIONS(717),
    [sym_raw_string] = ACTIONS(715),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(715),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(715),
    [anon_sym_BQUOTE] = ACTIONS(715),
    [anon_sym_LT_LPAREN] = ACTIONS(715),
    [anon_sym_GT_LPAREN] = ACTIONS(715),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(717),
    [sym_word] = ACTIONS(717),
    [anon_sym_LF] = ACTIONS(715),
    [anon_sym_AMP] = ACTIONS(717),
  },
  [277] = {
    [anon_sym_EQ] = ACTIONS(1328),
    [anon_sym_PLUS_EQ] = ACTIONS(1328),
    [sym_comment] = ACTIONS(55),
  },
  [278] = {
    [sym_variable_assignment] = STATE(692),
    [sym_subscript] = STATE(277),
    [sym_concatenation] = STATE(692),
    [sym_string] = STATE(276),
    [sym_simple_expansion] = STATE(276),
    [sym_string_expansion] = STATE(276),
    [sym_expansion] = STATE(276),
    [sym_command_substitution] = STATE(276),
    [sym_process_substitution] = STATE(276),
    [aux_sym_declaration_command_repeat1] = STATE(692),
    [sym_variable_name] = ACTIONS(505),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(731),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(509),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1330),
    [sym_word] = ACTIONS(513),
    [anon_sym_LF] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(731),
  },
  [279] = {
    [aux_sym_concatenation_repeat1] = STATE(693),
    [sym__concat] = ACTIONS(735),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_PIPE] = ACTIONS(739),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [anon_sym_PIPE_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(737),
    [sym__special_characters] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(739),
    [sym_raw_string] = ACTIONS(737),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [anon_sym_LT_LPAREN] = ACTIONS(737),
    [anon_sym_GT_LPAREN] = ACTIONS(737),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(739),
    [sym_word] = ACTIONS(739),
    [anon_sym_LF] = ACTIONS(737),
    [anon_sym_AMP] = ACTIONS(739),
  },
  [280] = {
    [aux_sym_concatenation_repeat1] = STATE(693),
    [sym__concat] = ACTIONS(735),
    [anon_sym_SEMI] = ACTIONS(755),
    [anon_sym_PIPE] = ACTIONS(755),
    [anon_sym_SEMI_SEMI] = ACTIONS(753),
    [anon_sym_PIPE_AMP] = ACTIONS(753),
    [anon_sym_AMP_AMP] = ACTIONS(753),
    [anon_sym_PIPE_PIPE] = ACTIONS(753),
    [sym__special_characters] = ACTIONS(753),
    [anon_sym_DQUOTE] = ACTIONS(753),
    [anon_sym_DOLLAR] = ACTIONS(755),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(753),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(753),
    [anon_sym_BQUOTE] = ACTIONS(753),
    [anon_sym_LT_LPAREN] = ACTIONS(753),
    [anon_sym_GT_LPAREN] = ACTIONS(753),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(755),
    [sym_word] = ACTIONS(755),
    [anon_sym_LF] = ACTIONS(753),
    [anon_sym_AMP] = ACTIONS(755),
  },
  [281] = {
    [sym_concatenation] = STATE(694),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym_unset_command_repeat1] = STATE(694),
    [anon_sym_SEMI] = ACTIONS(769),
    [anon_sym_PIPE] = ACTIONS(769),
    [anon_sym_SEMI_SEMI] = ACTIONS(767),
    [anon_sym_PIPE_AMP] = ACTIONS(767),
    [anon_sym_AMP_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(767),
    [sym__special_characters] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(517),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1332),
    [sym_word] = ACTIONS(521),
    [anon_sym_LF] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(769),
  },
  [282] = {
    [aux_sym_concatenation_repeat1] = STATE(695),
    [sym__simple_heredoc_body] = ACTIONS(807),
    [sym__heredoc_body_beginning] = ACTIONS(807),
    [sym_file_descriptor] = ACTIONS(807),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_PIPE] = ACTIONS(809),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [anon_sym_PIPE_AMP] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(809),
    [anon_sym_EQ_EQ] = ACTIONS(809),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_GT_GT] = ACTIONS(807),
    [anon_sym_AMP_GT] = ACTIONS(809),
    [anon_sym_AMP_GT_GT] = ACTIONS(807),
    [anon_sym_LT_AMP] = ACTIONS(807),
    [anon_sym_GT_AMP] = ACTIONS(807),
    [anon_sym_LT_LT] = ACTIONS(809),
    [anon_sym_LT_LT_DASH] = ACTIONS(807),
    [anon_sym_LT_LT_LT] = ACTIONS(807),
    [sym__special_characters] = ACTIONS(807),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(807),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [anon_sym_LT_LPAREN] = ACTIONS(807),
    [anon_sym_GT_LPAREN] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(809),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(809),
  },
  [283] = {
    [anon_sym_RPAREN] = ACTIONS(1334),
    [sym_comment] = ACTIONS(55),
  },
  [284] = {
    [sym__terminated_statement] = STATE(698),
    [sym_for_statement] = STATE(545),
    [sym_c_style_for_statement] = STATE(545),
    [sym_while_statement] = STATE(545),
    [sym_if_statement] = STATE(545),
    [sym_case_statement] = STATE(545),
    [sym_function_definition] = STATE(545),
    [sym_subshell] = STATE(545),
    [sym_pipeline] = STATE(545),
    [sym_list] = STATE(545),
    [sym_negated_command] = STATE(545),
    [sym_test_command] = STATE(545),
    [sym_declaration_command] = STATE(545),
    [sym_unset_command] = STATE(545),
    [sym_command] = STATE(545),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(546),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(698),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_done] = ACTIONS(1336),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [285] = {
    [sym_file_redirect] = STATE(700),
    [sym_heredoc_redirect] = STATE(700),
    [sym_heredoc_body] = STATE(699),
    [sym_herestring_redirect] = STATE(700),
    [aux_sym_while_statement_repeat1] = STATE(700),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(343),
    [ts_builtin_sym_end] = ACTIONS(1338),
    [anon_sym_SEMI] = ACTIONS(1340),
    [anon_sym_PIPE] = ACTIONS(1340),
    [anon_sym_SEMI_SEMI] = ACTIONS(1338),
    [anon_sym_PIPE_AMP] = ACTIONS(1338),
    [anon_sym_AMP_AMP] = ACTIONS(1338),
    [anon_sym_PIPE_PIPE] = ACTIONS(1338),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(359),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1338),
    [anon_sym_AMP] = ACTIONS(1340),
  },
  [286] = {
    [anon_sym_do] = ACTIONS(943),
    [anon_sym_then] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
  },
  [287] = {
    [sym_for_statement] = STATE(521),
    [sym_c_style_for_statement] = STATE(521),
    [sym_while_statement] = STATE(521),
    [sym_if_statement] = STATE(521),
    [sym_case_statement] = STATE(521),
    [sym_function_definition] = STATE(521),
    [sym_subshell] = STATE(521),
    [sym_pipeline] = STATE(521),
    [sym_list] = STATE(521),
    [sym_negated_command] = STATE(521),
    [sym_test_command] = STATE(521),
    [sym_declaration_command] = STATE(521),
    [sym_unset_command] = STATE(521),
    [sym_command] = STATE(521),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(522),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [288] = {
    [sym_for_statement] = STATE(701),
    [sym_c_style_for_statement] = STATE(701),
    [sym_while_statement] = STATE(701),
    [sym_if_statement] = STATE(701),
    [sym_case_statement] = STATE(701),
    [sym_function_definition] = STATE(701),
    [sym_subshell] = STATE(701),
    [sym_pipeline] = STATE(701),
    [sym_list] = STATE(701),
    [sym_negated_command] = STATE(701),
    [sym_test_command] = STATE(701),
    [sym_declaration_command] = STATE(701),
    [sym_unset_command] = STATE(701),
    [sym_command] = STATE(701),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(702),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [289] = {
    [anon_sym_LT] = ACTIONS(1342),
    [anon_sym_GT] = ACTIONS(1342),
    [anon_sym_GT_GT] = ACTIONS(1344),
    [anon_sym_AMP_GT] = ACTIONS(1342),
    [anon_sym_AMP_GT_GT] = ACTIONS(1344),
    [anon_sym_LT_AMP] = ACTIONS(1344),
    [anon_sym_GT_AMP] = ACTIONS(1344),
    [sym_comment] = ACTIONS(55),
  },
  [290] = {
    [sym_concatenation] = STATE(530),
    [sym_string] = STATE(705),
    [sym_simple_expansion] = STATE(705),
    [sym_string_expansion] = STATE(705),
    [sym_expansion] = STATE(705),
    [sym_command_substitution] = STATE(705),
    [sym_process_substitution] = STATE(705),
    [sym_regex] = ACTIONS(965),
    [sym__special_characters] = ACTIONS(1346),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1348),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1348),
  },
  [291] = {
    [sym_concatenation] = STATE(535),
    [sym_string] = STATE(707),
    [sym_simple_expansion] = STATE(707),
    [sym_string_expansion] = STATE(707),
    [sym_expansion] = STATE(707),
    [sym_command_substitution] = STATE(707),
    [sym_process_substitution] = STATE(707),
    [sym__special_characters] = ACTIONS(1350),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1352),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1352),
  },
  [292] = {
    [sym_concatenation] = STATE(539),
    [sym_string] = STATE(709),
    [sym_simple_expansion] = STATE(709),
    [sym_string_expansion] = STATE(709),
    [sym_expansion] = STATE(709),
    [sym_command_substitution] = STATE(709),
    [sym_process_substitution] = STATE(709),
    [sym__special_characters] = ACTIONS(1354),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1356),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1356),
  },
  [293] = {
    [aux_sym_concatenation_repeat1] = STATE(282),
    [sym__simple_heredoc_body] = ACTIONS(981),
    [sym__heredoc_body_beginning] = ACTIONS(981),
    [sym_file_descriptor] = ACTIONS(981),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(983),
    [anon_sym_PIPE] = ACTIONS(983),
    [anon_sym_SEMI_SEMI] = ACTIONS(981),
    [anon_sym_PIPE_AMP] = ACTIONS(981),
    [anon_sym_AMP_AMP] = ACTIONS(981),
    [anon_sym_PIPE_PIPE] = ACTIONS(981),
    [anon_sym_EQ_TILDE] = ACTIONS(983),
    [anon_sym_EQ_EQ] = ACTIONS(983),
    [anon_sym_LT] = ACTIONS(983),
    [anon_sym_GT] = ACTIONS(983),
    [anon_sym_GT_GT] = ACTIONS(981),
    [anon_sym_AMP_GT] = ACTIONS(983),
    [anon_sym_AMP_GT_GT] = ACTIONS(981),
    [anon_sym_LT_AMP] = ACTIONS(981),
    [anon_sym_GT_AMP] = ACTIONS(981),
    [anon_sym_LT_LT] = ACTIONS(983),
    [anon_sym_LT_LT_DASH] = ACTIONS(981),
    [anon_sym_LT_LT_LT] = ACTIONS(981),
    [sym__special_characters] = ACTIONS(981),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_DOLLAR] = ACTIONS(983),
    [sym_raw_string] = ACTIONS(981),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(981),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(981),
    [anon_sym_BQUOTE] = ACTIONS(981),
    [anon_sym_LT_LPAREN] = ACTIONS(981),
    [anon_sym_GT_LPAREN] = ACTIONS(981),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(983),
    [anon_sym_LF] = ACTIONS(981),
    [anon_sym_AMP] = ACTIONS(983),
  },
  [294] = {
    [aux_sym_concatenation_repeat1] = STATE(282),
    [sym__simple_heredoc_body] = ACTIONS(985),
    [sym__heredoc_body_beginning] = ACTIONS(985),
    [sym_file_descriptor] = ACTIONS(985),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(987),
    [anon_sym_PIPE] = ACTIONS(987),
    [anon_sym_SEMI_SEMI] = ACTIONS(985),
    [anon_sym_PIPE_AMP] = ACTIONS(985),
    [anon_sym_AMP_AMP] = ACTIONS(985),
    [anon_sym_PIPE_PIPE] = ACTIONS(985),
    [anon_sym_EQ_TILDE] = ACTIONS(987),
    [anon_sym_EQ_EQ] = ACTIONS(987),
    [anon_sym_LT] = ACTIONS(987),
    [anon_sym_GT] = ACTIONS(987),
    [anon_sym_GT_GT] = ACTIONS(985),
    [anon_sym_AMP_GT] = ACTIONS(987),
    [anon_sym_AMP_GT_GT] = ACTIONS(985),
    [anon_sym_LT_AMP] = ACTIONS(985),
    [anon_sym_GT_AMP] = ACTIONS(985),
    [anon_sym_LT_LT] = ACTIONS(987),
    [anon_sym_LT_LT_DASH] = ACTIONS(985),
    [anon_sym_LT_LT_LT] = ACTIONS(985),
    [sym__special_characters] = ACTIONS(985),
    [anon_sym_DQUOTE] = ACTIONS(985),
    [anon_sym_DOLLAR] = ACTIONS(987),
    [sym_raw_string] = ACTIONS(985),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(985),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(985),
    [anon_sym_BQUOTE] = ACTIONS(985),
    [anon_sym_LT_LPAREN] = ACTIONS(985),
    [anon_sym_GT_LPAREN] = ACTIONS(985),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(987),
    [anon_sym_LF] = ACTIONS(985),
    [anon_sym_AMP] = ACTIONS(987),
  },
  [295] = {
    [sym_file_redirect] = STATE(710),
    [sym_heredoc_redirect] = STATE(710),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(710),
    [aux_sym_while_statement_repeat1] = STATE(710),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(537),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_GT_GT] = ACTIONS(543),
    [anon_sym_AMP_GT] = ACTIONS(541),
    [anon_sym_AMP_GT_GT] = ACTIONS(543),
    [anon_sym_LT_AMP] = ACTIONS(543),
    [anon_sym_GT_AMP] = ACTIONS(543),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(545),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [296] = {
    [sym_file_redirect] = STATE(711),
    [sym_heredoc_redirect] = STATE(711),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(711),
    [sym_concatenation] = STATE(712),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym_while_statement_repeat1] = STATE(711),
    [aux_sym_command_repeat2] = STATE(712),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(537),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_GT_GT] = ACTIONS(543),
    [anon_sym_AMP_GT] = ACTIONS(541),
    [anon_sym_AMP_GT_GT] = ACTIONS(543),
    [anon_sym_LT_AMP] = ACTIONS(543),
    [anon_sym_GT_AMP] = ACTIONS(543),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(545),
    [sym__special_characters] = ACTIONS(547),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(549),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(551),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [297] = {
    [sym_file_redirect] = STATE(711),
    [sym_heredoc_redirect] = STATE(711),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(711),
    [sym_concatenation] = STATE(713),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym_while_statement_repeat1] = STATE(711),
    [aux_sym_command_repeat2] = STATE(713),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(537),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_GT_GT] = ACTIONS(543),
    [anon_sym_AMP_GT] = ACTIONS(541),
    [anon_sym_AMP_GT_GT] = ACTIONS(543),
    [anon_sym_LT_AMP] = ACTIONS(543),
    [anon_sym_GT_AMP] = ACTIONS(543),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(545),
    [sym__special_characters] = ACTIONS(547),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(549),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(551),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [298] = {
    [sym__terminated_statement] = STATE(718),
    [sym_for_statement] = STATE(545),
    [sym_c_style_for_statement] = STATE(545),
    [sym_while_statement] = STATE(545),
    [sym_if_statement] = STATE(545),
    [sym_elif_clause] = STATE(719),
    [sym_else_clause] = STATE(717),
    [sym_case_statement] = STATE(545),
    [sym_function_definition] = STATE(545),
    [sym_subshell] = STATE(545),
    [sym_pipeline] = STATE(545),
    [sym_list] = STATE(545),
    [sym_negated_command] = STATE(545),
    [sym_test_command] = STATE(545),
    [sym_declaration_command] = STATE(545),
    [sym_unset_command] = STATE(545),
    [sym_command] = STATE(545),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(546),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(718),
    [aux_sym_if_statement_repeat1] = STATE(719),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_fi] = ACTIONS(1358),
    [anon_sym_elif] = ACTIONS(1360),
    [anon_sym_else] = ACTIONS(1362),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [299] = {
    [sym_string] = STATE(720),
    [sym_simple_expansion] = STATE(720),
    [sym_string_expansion] = STATE(720),
    [sym_expansion] = STATE(720),
    [sym_command_substitution] = STATE(720),
    [sym_process_substitution] = STATE(720),
    [sym__special_characters] = ACTIONS(1364),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_DOLLAR] = ACTIONS(123),
    [sym_raw_string] = ACTIONS(1364),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(127),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LT_LPAREN] = ACTIONS(133),
    [anon_sym_GT_LPAREN] = ACTIONS(133),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1364),
  },
  [300] = {
    [anon_sym_SEMI] = ACTIONS(1366),
    [anon_sym_SEMI_SEMI] = ACTIONS(1368),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1368),
    [anon_sym_AMP] = ACTIONS(1368),
  },
  [301] = {
    [anon_sym_in] = ACTIONS(1370),
    [sym_comment] = ACTIONS(55),
  },
  [302] = {
    [aux_sym_concatenation_repeat1] = STATE(723),
    [sym__concat] = ACTIONS(557),
    [anon_sym_in] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(807),
  },
  [303] = {
    [sym__concat] = ACTIONS(811),
    [anon_sym_in] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(813),
    [anon_sym_SEMI_SEMI] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(811),
  },
  [304] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(1372),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [305] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(1372),
    [anon_sym_DOLLAR] = ACTIONS(1374),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [306] = {
    [sym__concat] = ACTIONS(845),
    [anon_sym_in] = ACTIONS(845),
    [anon_sym_SEMI] = ACTIONS(847),
    [anon_sym_SEMI_SEMI] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(845),
    [anon_sym_AMP] = ACTIONS(845),
  },
  [307] = {
    [sym__concat] = ACTIONS(849),
    [anon_sym_in] = ACTIONS(849),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_SEMI_SEMI] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(849),
    [anon_sym_AMP] = ACTIONS(849),
  },
  [308] = {
    [sym__concat] = ACTIONS(853),
    [anon_sym_in] = ACTIONS(853),
    [anon_sym_SEMI] = ACTIONS(855),
    [anon_sym_SEMI_SEMI] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(853),
    [anon_sym_AMP] = ACTIONS(853),
  },
  [309] = {
    [anon_sym_SEMI] = ACTIONS(1376),
    [anon_sym_SEMI_SEMI] = ACTIONS(1378),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1378),
    [anon_sym_AMP] = ACTIONS(1378),
  },
  [310] = {
    [anon_sym_in] = ACTIONS(1380),
    [sym_comment] = ACTIONS(55),
  },
  [311] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1382),
    [sym_comment] = ACTIONS(55),
  },
  [312] = {
    [sym_subscript] = STATE(731),
    [sym_variable_name] = ACTIONS(1384),
    [anon_sym_DASH] = ACTIONS(1386),
    [anon_sym_DOLLAR] = ACTIONS(1386),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1388),
    [anon_sym_STAR] = ACTIONS(1390),
    [anon_sym_AT] = ACTIONS(1390),
    [anon_sym_QMARK] = ACTIONS(1390),
    [anon_sym_0] = ACTIONS(1388),
    [anon_sym__] = ACTIONS(1388),
  },
  [313] = {
    [sym_concatenation] = STATE(734),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(734),
    [anon_sym_RBRACE] = ACTIONS(1392),
    [anon_sym_EQ] = ACTIONS(1394),
    [anon_sym_DASH] = ACTIONS(1394),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1396),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1398),
    [anon_sym_COLON] = ACTIONS(1394),
    [anon_sym_COLON_QMARK] = ACTIONS(1394),
    [anon_sym_COLON_DASH] = ACTIONS(1394),
    [anon_sym_PERCENT] = ACTIONS(1394),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [314] = {
    [sym_concatenation] = STATE(737),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(737),
    [anon_sym_RBRACE] = ACTIONS(1400),
    [anon_sym_EQ] = ACTIONS(1402),
    [anon_sym_DASH] = ACTIONS(1402),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1404),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1406),
    [anon_sym_COLON] = ACTIONS(1402),
    [anon_sym_COLON_QMARK] = ACTIONS(1402),
    [anon_sym_COLON_DASH] = ACTIONS(1402),
    [anon_sym_PERCENT] = ACTIONS(1402),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [315] = {
    [anon_sym_SEMI] = ACTIONS(1408),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1410),
    [anon_sym_SEMI_SEMI] = ACTIONS(1412),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1412),
    [anon_sym_AMP] = ACTIONS(1408),
  },
  [316] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1408),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1410),
    [anon_sym_SEMI_SEMI] = ACTIONS(1412),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1412),
    [anon_sym_AMP] = ACTIONS(1408),
  },
  [317] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(740),
    [sym_c_style_for_statement] = STATE(740),
    [sym_while_statement] = STATE(740),
    [sym_if_statement] = STATE(740),
    [sym_case_statement] = STATE(740),
    [sym_function_definition] = STATE(740),
    [sym_subshell] = STATE(740),
    [sym_pipeline] = STATE(740),
    [sym_list] = STATE(740),
    [sym_negated_command] = STATE(740),
    [sym_test_command] = STATE(740),
    [sym_declaration_command] = STATE(740),
    [sym_unset_command] = STATE(740),
    [sym_command] = STATE(740),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(741),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [318] = {
    [anon_sym_SEMI] = ACTIONS(1414),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1416),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1410),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1416),
    [anon_sym_AMP] = ACTIONS(1414),
  },
  [319] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1414),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1416),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1410),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1416),
    [anon_sym_AMP] = ACTIONS(1414),
  },
  [320] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(743),
    [sym_c_style_for_statement] = STATE(743),
    [sym_while_statement] = STATE(743),
    [sym_if_statement] = STATE(743),
    [sym_case_statement] = STATE(743),
    [sym_function_definition] = STATE(743),
    [sym_subshell] = STATE(743),
    [sym_pipeline] = STATE(743),
    [sym_list] = STATE(743),
    [sym_negated_command] = STATE(743),
    [sym_test_command] = STATE(743),
    [sym_declaration_command] = STATE(743),
    [sym_unset_command] = STATE(743),
    [sym_command] = STATE(743),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(744),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [321] = {
    [anon_sym_SEMI] = ACTIONS(1418),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1420),
    [anon_sym_SEMI_SEMI] = ACTIONS(1422),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1422),
    [anon_sym_AMP] = ACTIONS(1418),
  },
  [322] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1418),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1420),
    [anon_sym_SEMI_SEMI] = ACTIONS(1422),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1422),
    [anon_sym_AMP] = ACTIONS(1418),
  },
  [323] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(747),
    [sym_c_style_for_statement] = STATE(747),
    [sym_while_statement] = STATE(747),
    [sym_if_statement] = STATE(747),
    [sym_case_statement] = STATE(747),
    [sym_function_definition] = STATE(747),
    [sym_subshell] = STATE(747),
    [sym_pipeline] = STATE(747),
    [sym_list] = STATE(747),
    [sym_negated_command] = STATE(747),
    [sym_test_command] = STATE(747),
    [sym_declaration_command] = STATE(747),
    [sym_unset_command] = STATE(747),
    [sym_command] = STATE(747),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(748),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [324] = {
    [anon_sym_RPAREN] = ACTIONS(1424),
    [sym_comment] = ACTIONS(55),
  },
  [325] = {
    [sym__terminated_statement] = STATE(753),
    [sym_for_statement] = STATE(751),
    [sym_c_style_for_statement] = STATE(751),
    [sym_while_statement] = STATE(751),
    [sym_if_statement] = STATE(751),
    [sym_case_statement] = STATE(751),
    [sym_function_definition] = STATE(751),
    [sym_subshell] = STATE(751),
    [sym_pipeline] = STATE(751),
    [sym_list] = STATE(751),
    [sym_negated_command] = STATE(751),
    [sym_test_command] = STATE(751),
    [sym_declaration_command] = STATE(751),
    [sym_unset_command] = STATE(751),
    [sym_command] = STATE(751),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(752),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(753),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(1426),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [326] = {
    [sym_file_redirect] = STATE(756),
    [sym_file_descriptor] = ACTIONS(1428),
    [ts_builtin_sym_end] = ACTIONS(1430),
    [anon_sym_SEMI] = ACTIONS(1432),
    [anon_sym_PIPE] = ACTIONS(1432),
    [anon_sym_SEMI_SEMI] = ACTIONS(1430),
    [anon_sym_PIPE_AMP] = ACTIONS(1430),
    [anon_sym_AMP_AMP] = ACTIONS(1430),
    [anon_sym_PIPE_PIPE] = ACTIONS(1430),
    [anon_sym_LT] = ACTIONS(1434),
    [anon_sym_GT] = ACTIONS(1434),
    [anon_sym_GT_GT] = ACTIONS(1436),
    [anon_sym_AMP_GT] = ACTIONS(1434),
    [anon_sym_AMP_GT_GT] = ACTIONS(1436),
    [anon_sym_LT_AMP] = ACTIONS(1436),
    [anon_sym_GT_AMP] = ACTIONS(1436),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1430),
    [anon_sym_AMP] = ACTIONS(1432),
  },
  [327] = {
    [sym_concatenation] = STATE(207),
    [sym_string] = STATE(758),
    [sym_array] = STATE(207),
    [sym_simple_expansion] = STATE(758),
    [sym_string_expansion] = STATE(758),
    [sym_expansion] = STATE(758),
    [sym_command_substitution] = STATE(758),
    [sym_process_substitution] = STATE(758),
    [sym__empty_value] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(383),
    [sym__special_characters] = ACTIONS(1438),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(389),
    [sym_raw_string] = ACTIONS(1440),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(393),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(397),
    [anon_sym_LT_LPAREN] = ACTIONS(399),
    [anon_sym_GT_LPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1440),
  },
  [328] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1442),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_EQ_TILDE] = ACTIONS(495),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_DASH_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(493),
  },
  [329] = {
    [sym_do_group] = STATE(760),
    [anon_sym_do] = ACTIONS(525),
    [sym_comment] = ACTIONS(55),
  },
  [330] = {
    [sym_compound_statement] = STATE(762),
    [anon_sym_LPAREN] = ACTIONS(1444),
    [anon_sym_LBRACE] = ACTIONS(595),
    [sym_comment] = ACTIONS(55),
  },
  [331] = {
    [anon_sym_AMP_AMP] = ACTIONS(681),
    [anon_sym_PIPE_PIPE] = ACTIONS(681),
    [anon_sym_RBRACK] = ACTIONS(1442),
    [anon_sym_EQ_TILDE] = ACTIONS(683),
    [anon_sym_EQ_EQ] = ACTIONS(683),
    [anon_sym_EQ] = ACTIONS(685),
    [anon_sym_PLUS_EQ] = ACTIONS(681),
    [anon_sym_LT] = ACTIONS(685),
    [anon_sym_GT] = ACTIONS(685),
    [anon_sym_BANG_EQ] = ACTIONS(681),
    [anon_sym_PLUS] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(685),
    [anon_sym_DASH_EQ] = ACTIONS(681),
    [anon_sym_LT_EQ] = ACTIONS(681),
    [anon_sym_GT_EQ] = ACTIONS(681),
    [anon_sym_PLUS_PLUS] = ACTIONS(687),
    [anon_sym_DASH_DASH] = ACTIONS(687),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(681),
  },
  [332] = {
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1442),
    [anon_sym_EQ_TILDE] = ACTIONS(691),
    [anon_sym_EQ_EQ] = ACTIONS(691),
    [anon_sym_EQ] = ACTIONS(693),
    [anon_sym_PLUS_EQ] = ACTIONS(689),
    [anon_sym_LT] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(693),
    [anon_sym_BANG_EQ] = ACTIONS(689),
    [anon_sym_PLUS] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(693),
    [anon_sym_DASH_EQ] = ACTIONS(689),
    [anon_sym_LT_EQ] = ACTIONS(689),
    [anon_sym_GT_EQ] = ACTIONS(689),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(689),
  },
  [333] = {
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(1446),
    [anon_sym_PLUS_EQ] = ACTIONS(1446),
    [sym_comment] = ACTIONS(55),
  },
  [334] = {
    [aux_sym_concatenation_repeat1] = STATE(764),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(699),
    [anon_sym_SEMI] = ACTIONS(701),
    [anon_sym_PIPE] = ACTIONS(701),
    [anon_sym_RPAREN] = ACTIONS(699),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [anon_sym_PIPE_AMP] = ACTIONS(699),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [sym__special_characters] = ACTIONS(699),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_DOLLAR] = ACTIONS(701),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(699),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(699),
    [anon_sym_BQUOTE] = ACTIONS(699),
    [anon_sym_LT_LPAREN] = ACTIONS(699),
    [anon_sym_GT_LPAREN] = ACTIONS(699),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(701),
    [sym_word] = ACTIONS(701),
    [anon_sym_LF] = ACTIONS(699),
    [anon_sym_AMP] = ACTIONS(701),
  },
  [335] = {
    [aux_sym_concatenation_repeat1] = STATE(764),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(715),
    [anon_sym_SEMI] = ACTIONS(717),
    [anon_sym_PIPE] = ACTIONS(717),
    [anon_sym_RPAREN] = ACTIONS(715),
    [anon_sym_SEMI_SEMI] = ACTIONS(715),
    [anon_sym_PIPE_AMP] = ACTIONS(715),
    [anon_sym_AMP_AMP] = ACTIONS(715),
    [anon_sym_PIPE_PIPE] = ACTIONS(715),
    [sym__special_characters] = ACTIONS(715),
    [anon_sym_DQUOTE] = ACTIONS(715),
    [anon_sym_DOLLAR] = ACTIONS(717),
    [sym_raw_string] = ACTIONS(715),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(715),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(715),
    [anon_sym_BQUOTE] = ACTIONS(715),
    [anon_sym_LT_LPAREN] = ACTIONS(715),
    [anon_sym_GT_LPAREN] = ACTIONS(715),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(717),
    [sym_word] = ACTIONS(717),
    [anon_sym_LF] = ACTIONS(715),
    [anon_sym_AMP] = ACTIONS(717),
  },
  [336] = {
    [anon_sym_EQ] = ACTIONS(1446),
    [anon_sym_PLUS_EQ] = ACTIONS(1446),
    [sym_comment] = ACTIONS(55),
  },
  [337] = {
    [sym_variable_assignment] = STATE(765),
    [sym_subscript] = STATE(336),
    [sym_concatenation] = STATE(765),
    [sym_string] = STATE(335),
    [sym_simple_expansion] = STATE(335),
    [sym_string_expansion] = STATE(335),
    [sym_expansion] = STATE(335),
    [sym_command_substitution] = STATE(335),
    [sym_process_substitution] = STATE(335),
    [aux_sym_declaration_command_repeat1] = STATE(765),
    [sym_variable_name] = ACTIONS(601),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(731),
    [anon_sym_RPAREN] = ACTIONS(729),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(603),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(605),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1448),
    [sym_word] = ACTIONS(609),
    [anon_sym_LF] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(731),
  },
  [338] = {
    [aux_sym_concatenation_repeat1] = STATE(766),
    [sym__concat] = ACTIONS(735),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_PIPE] = ACTIONS(739),
    [anon_sym_RPAREN] = ACTIONS(737),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [anon_sym_PIPE_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(737),
    [sym__special_characters] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(739),
    [sym_raw_string] = ACTIONS(737),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [anon_sym_LT_LPAREN] = ACTIONS(737),
    [anon_sym_GT_LPAREN] = ACTIONS(737),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(739),
    [sym_word] = ACTIONS(739),
    [anon_sym_LF] = ACTIONS(737),
    [anon_sym_AMP] = ACTIONS(739),
  },
  [339] = {
    [aux_sym_concatenation_repeat1] = STATE(766),
    [sym__concat] = ACTIONS(735),
    [anon_sym_SEMI] = ACTIONS(755),
    [anon_sym_PIPE] = ACTIONS(755),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_SEMI_SEMI] = ACTIONS(753),
    [anon_sym_PIPE_AMP] = ACTIONS(753),
    [anon_sym_AMP_AMP] = ACTIONS(753),
    [anon_sym_PIPE_PIPE] = ACTIONS(753),
    [sym__special_characters] = ACTIONS(753),
    [anon_sym_DQUOTE] = ACTIONS(753),
    [anon_sym_DOLLAR] = ACTIONS(755),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(753),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(753),
    [anon_sym_BQUOTE] = ACTIONS(753),
    [anon_sym_LT_LPAREN] = ACTIONS(753),
    [anon_sym_GT_LPAREN] = ACTIONS(753),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(755),
    [sym_word] = ACTIONS(755),
    [anon_sym_LF] = ACTIONS(753),
    [anon_sym_AMP] = ACTIONS(755),
  },
  [340] = {
    [sym_concatenation] = STATE(767),
    [sym_string] = STATE(339),
    [sym_simple_expansion] = STATE(339),
    [sym_string_expansion] = STATE(339),
    [sym_expansion] = STATE(339),
    [sym_command_substitution] = STATE(339),
    [sym_process_substitution] = STATE(339),
    [aux_sym_unset_command_repeat1] = STATE(767),
    [anon_sym_SEMI] = ACTIONS(769),
    [anon_sym_PIPE] = ACTIONS(769),
    [anon_sym_RPAREN] = ACTIONS(767),
    [anon_sym_SEMI_SEMI] = ACTIONS(767),
    [anon_sym_PIPE_AMP] = ACTIONS(767),
    [anon_sym_AMP_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(767),
    [sym__special_characters] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(613),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1450),
    [sym_word] = ACTIONS(617),
    [anon_sym_LF] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(769),
  },
  [341] = {
    [aux_sym_concatenation_repeat1] = STATE(768),
    [sym__simple_heredoc_body] = ACTIONS(807),
    [sym__heredoc_body_beginning] = ACTIONS(807),
    [sym_file_descriptor] = ACTIONS(807),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_PIPE] = ACTIONS(809),
    [anon_sym_RPAREN] = ACTIONS(807),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [anon_sym_PIPE_AMP] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(809),
    [anon_sym_EQ_EQ] = ACTIONS(809),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_GT_GT] = ACTIONS(807),
    [anon_sym_AMP_GT] = ACTIONS(809),
    [anon_sym_AMP_GT_GT] = ACTIONS(807),
    [anon_sym_LT_AMP] = ACTIONS(807),
    [anon_sym_GT_AMP] = ACTIONS(807),
    [anon_sym_LT_LT] = ACTIONS(809),
    [anon_sym_LT_LT_DASH] = ACTIONS(807),
    [anon_sym_LT_LT_LT] = ACTIONS(807),
    [sym__special_characters] = ACTIONS(807),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(807),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [anon_sym_LT_LPAREN] = ACTIONS(807),
    [anon_sym_GT_LPAREN] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(809),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(809),
  },
  [342] = {
    [anon_sym_RPAREN] = ACTIONS(1452),
    [sym_comment] = ACTIONS(55),
  },
  [343] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_RPAREN] = ACTIONS(1454),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [344] = {
    [sym_for_statement] = STATE(521),
    [sym_c_style_for_statement] = STATE(521),
    [sym_while_statement] = STATE(521),
    [sym_if_statement] = STATE(521),
    [sym_case_statement] = STATE(521),
    [sym_function_definition] = STATE(521),
    [sym_subshell] = STATE(521),
    [sym_pipeline] = STATE(521),
    [sym_list] = STATE(521),
    [sym_negated_command] = STATE(521),
    [sym_test_command] = STATE(521),
    [sym_declaration_command] = STATE(521),
    [sym_unset_command] = STATE(521),
    [sym_command] = STATE(521),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(522),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [345] = {
    [ts_builtin_sym_end] = ACTIONS(1456),
    [anon_sym_SEMI] = ACTIONS(1458),
    [anon_sym_esac] = ACTIONS(1456),
    [anon_sym_PIPE] = ACTIONS(1458),
    [anon_sym_RPAREN] = ACTIONS(1456),
    [anon_sym_SEMI_SEMI] = ACTIONS(1456),
    [anon_sym_PIPE_AMP] = ACTIONS(1456),
    [anon_sym_AMP_AMP] = ACTIONS(1456),
    [anon_sym_PIPE_PIPE] = ACTIONS(1456),
    [anon_sym_BQUOTE] = ACTIONS(1456),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1456),
    [anon_sym_AMP] = ACTIONS(1458),
  },
  [346] = {
    [sym_for_statement] = STATE(771),
    [sym_c_style_for_statement] = STATE(771),
    [sym_while_statement] = STATE(771),
    [sym_if_statement] = STATE(771),
    [sym_case_statement] = STATE(771),
    [sym_function_definition] = STATE(771),
    [sym_subshell] = STATE(771),
    [sym_pipeline] = STATE(771),
    [sym_list] = STATE(771),
    [sym_negated_command] = STATE(771),
    [sym_test_command] = STATE(771),
    [sym_declaration_command] = STATE(771),
    [sym_unset_command] = STATE(771),
    [sym_command] = STATE(771),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(772),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [347] = {
    [anon_sym_LT] = ACTIONS(1460),
    [anon_sym_GT] = ACTIONS(1460),
    [anon_sym_GT_GT] = ACTIONS(1462),
    [anon_sym_AMP_GT] = ACTIONS(1460),
    [anon_sym_AMP_GT_GT] = ACTIONS(1462),
    [anon_sym_LT_AMP] = ACTIONS(1462),
    [anon_sym_GT_AMP] = ACTIONS(1462),
    [sym_comment] = ACTIONS(55),
  },
  [348] = {
    [sym_concatenation] = STATE(530),
    [sym_string] = STATE(775),
    [sym_simple_expansion] = STATE(775),
    [sym_string_expansion] = STATE(775),
    [sym_expansion] = STATE(775),
    [sym_command_substitution] = STATE(775),
    [sym_process_substitution] = STATE(775),
    [sym_regex] = ACTIONS(965),
    [sym__special_characters] = ACTIONS(1464),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1466),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1466),
  },
  [349] = {
    [sym_concatenation] = STATE(535),
    [sym_string] = STATE(777),
    [sym_simple_expansion] = STATE(777),
    [sym_string_expansion] = STATE(777),
    [sym_expansion] = STATE(777),
    [sym_command_substitution] = STATE(777),
    [sym_process_substitution] = STATE(777),
    [sym__special_characters] = ACTIONS(1468),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1470),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1470),
  },
  [350] = {
    [sym_concatenation] = STATE(539),
    [sym_string] = STATE(779),
    [sym_simple_expansion] = STATE(779),
    [sym_string_expansion] = STATE(779),
    [sym_expansion] = STATE(779),
    [sym_command_substitution] = STATE(779),
    [sym_process_substitution] = STATE(779),
    [sym__special_characters] = ACTIONS(1472),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1474),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1474),
  },
  [351] = {
    [aux_sym_concatenation_repeat1] = STATE(341),
    [sym__simple_heredoc_body] = ACTIONS(981),
    [sym__heredoc_body_beginning] = ACTIONS(981),
    [sym_file_descriptor] = ACTIONS(981),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(983),
    [anon_sym_PIPE] = ACTIONS(983),
    [anon_sym_RPAREN] = ACTIONS(981),
    [anon_sym_SEMI_SEMI] = ACTIONS(981),
    [anon_sym_PIPE_AMP] = ACTIONS(981),
    [anon_sym_AMP_AMP] = ACTIONS(981),
    [anon_sym_PIPE_PIPE] = ACTIONS(981),
    [anon_sym_EQ_TILDE] = ACTIONS(983),
    [anon_sym_EQ_EQ] = ACTIONS(983),
    [anon_sym_LT] = ACTIONS(983),
    [anon_sym_GT] = ACTIONS(983),
    [anon_sym_GT_GT] = ACTIONS(981),
    [anon_sym_AMP_GT] = ACTIONS(983),
    [anon_sym_AMP_GT_GT] = ACTIONS(981),
    [anon_sym_LT_AMP] = ACTIONS(981),
    [anon_sym_GT_AMP] = ACTIONS(981),
    [anon_sym_LT_LT] = ACTIONS(983),
    [anon_sym_LT_LT_DASH] = ACTIONS(981),
    [anon_sym_LT_LT_LT] = ACTIONS(981),
    [sym__special_characters] = ACTIONS(981),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_DOLLAR] = ACTIONS(983),
    [sym_raw_string] = ACTIONS(981),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(981),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(981),
    [anon_sym_BQUOTE] = ACTIONS(981),
    [anon_sym_LT_LPAREN] = ACTIONS(981),
    [anon_sym_GT_LPAREN] = ACTIONS(981),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(983),
    [anon_sym_LF] = ACTIONS(981),
    [anon_sym_AMP] = ACTIONS(983),
  },
  [352] = {
    [aux_sym_concatenation_repeat1] = STATE(341),
    [sym__simple_heredoc_body] = ACTIONS(985),
    [sym__heredoc_body_beginning] = ACTIONS(985),
    [sym_file_descriptor] = ACTIONS(985),
    [sym__concat] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(987),
    [anon_sym_PIPE] = ACTIONS(987),
    [anon_sym_RPAREN] = ACTIONS(985),
    [anon_sym_SEMI_SEMI] = ACTIONS(985),
    [anon_sym_PIPE_AMP] = ACTIONS(985),
    [anon_sym_AMP_AMP] = ACTIONS(985),
    [anon_sym_PIPE_PIPE] = ACTIONS(985),
    [anon_sym_EQ_TILDE] = ACTIONS(987),
    [anon_sym_EQ_EQ] = ACTIONS(987),
    [anon_sym_LT] = ACTIONS(987),
    [anon_sym_GT] = ACTIONS(987),
    [anon_sym_GT_GT] = ACTIONS(985),
    [anon_sym_AMP_GT] = ACTIONS(987),
    [anon_sym_AMP_GT_GT] = ACTIONS(985),
    [anon_sym_LT_AMP] = ACTIONS(985),
    [anon_sym_GT_AMP] = ACTIONS(985),
    [anon_sym_LT_LT] = ACTIONS(987),
    [anon_sym_LT_LT_DASH] = ACTIONS(985),
    [anon_sym_LT_LT_LT] = ACTIONS(985),
    [sym__special_characters] = ACTIONS(985),
    [anon_sym_DQUOTE] = ACTIONS(985),
    [anon_sym_DOLLAR] = ACTIONS(987),
    [sym_raw_string] = ACTIONS(985),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(985),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(985),
    [anon_sym_BQUOTE] = ACTIONS(985),
    [anon_sym_LT_LPAREN] = ACTIONS(985),
    [anon_sym_GT_LPAREN] = ACTIONS(985),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(987),
    [anon_sym_LF] = ACTIONS(985),
    [anon_sym_AMP] = ACTIONS(987),
  },
  [353] = {
    [sym_file_redirect] = STATE(780),
    [sym_heredoc_redirect] = STATE(780),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(780),
    [aux_sym_while_statement_repeat1] = STATE(780),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_RPAREN] = ACTIONS(989),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_GT_GT] = ACTIONS(639),
    [anon_sym_AMP_GT] = ACTIONS(637),
    [anon_sym_AMP_GT_GT] = ACTIONS(639),
    [anon_sym_LT_AMP] = ACTIONS(639),
    [anon_sym_GT_AMP] = ACTIONS(639),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(641),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [354] = {
    [sym_file_redirect] = STATE(781),
    [sym_heredoc_redirect] = STATE(781),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(781),
    [sym_concatenation] = STATE(782),
    [sym_string] = STATE(352),
    [sym_simple_expansion] = STATE(352),
    [sym_string_expansion] = STATE(352),
    [sym_expansion] = STATE(352),
    [sym_command_substitution] = STATE(352),
    [sym_process_substitution] = STATE(352),
    [aux_sym_while_statement_repeat1] = STATE(781),
    [aux_sym_command_repeat2] = STATE(782),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_RPAREN] = ACTIONS(989),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_GT_GT] = ACTIONS(639),
    [anon_sym_AMP_GT] = ACTIONS(637),
    [anon_sym_AMP_GT_GT] = ACTIONS(639),
    [anon_sym_LT_AMP] = ACTIONS(639),
    [anon_sym_GT_AMP] = ACTIONS(639),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(641),
    [sym__special_characters] = ACTIONS(643),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(645),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(647),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [355] = {
    [anon_sym_SEMI] = ACTIONS(1476),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1454),
    [anon_sym_SEMI_SEMI] = ACTIONS(1478),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1478),
    [anon_sym_AMP] = ACTIONS(1476),
  },
  [356] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1476),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1454),
    [anon_sym_SEMI_SEMI] = ACTIONS(1478),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1478),
    [anon_sym_AMP] = ACTIONS(1476),
  },
  [357] = {
    [sym_file_redirect] = STATE(781),
    [sym_heredoc_redirect] = STATE(781),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(781),
    [sym_concatenation] = STATE(784),
    [sym_string] = STATE(352),
    [sym_simple_expansion] = STATE(352),
    [sym_string_expansion] = STATE(352),
    [sym_expansion] = STATE(352),
    [sym_command_substitution] = STATE(352),
    [sym_process_substitution] = STATE(352),
    [aux_sym_while_statement_repeat1] = STATE(781),
    [aux_sym_command_repeat2] = STATE(784),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_RPAREN] = ACTIONS(989),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_GT_GT] = ACTIONS(639),
    [anon_sym_AMP_GT] = ACTIONS(637),
    [anon_sym_AMP_GT_GT] = ACTIONS(639),
    [anon_sym_LT_AMP] = ACTIONS(639),
    [anon_sym_GT_AMP] = ACTIONS(639),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(641),
    [sym__special_characters] = ACTIONS(643),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(645),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(647),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [358] = {
    [sym_concatenation] = STATE(785),
    [sym_string] = STATE(788),
    [sym_array] = STATE(785),
    [sym_simple_expansion] = STATE(788),
    [sym_string_expansion] = STATE(788),
    [sym_expansion] = STATE(788),
    [sym_command_substitution] = STATE(788),
    [sym_process_substitution] = STATE(788),
    [sym__empty_value] = ACTIONS(1480),
    [anon_sym_LPAREN] = ACTIONS(1482),
    [sym__special_characters] = ACTIONS(1484),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(251),
    [sym_raw_string] = ACTIONS(1486),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(255),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(257),
    [anon_sym_BQUOTE] = ACTIONS(259),
    [anon_sym_LT_LPAREN] = ACTIONS(261),
    [anon_sym_GT_LPAREN] = ACTIONS(261),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1486),
  },
  [359] = {
    [anon_sym_RPAREN] = ACTIONS(1488),
    [anon_sym_AMP_AMP] = ACTIONS(1240),
    [anon_sym_PIPE_PIPE] = ACTIONS(1240),
    [anon_sym_EQ_TILDE] = ACTIONS(1242),
    [anon_sym_EQ_EQ] = ACTIONS(1242),
    [anon_sym_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_EQ] = ACTIONS(1240),
    [anon_sym_LT] = ACTIONS(1244),
    [anon_sym_GT] = ACTIONS(1244),
    [anon_sym_BANG_EQ] = ACTIONS(1240),
    [anon_sym_PLUS] = ACTIONS(1244),
    [anon_sym_DASH] = ACTIONS(1244),
    [anon_sym_DASH_EQ] = ACTIONS(1240),
    [anon_sym_LT_EQ] = ACTIONS(1240),
    [anon_sym_GT_EQ] = ACTIONS(1240),
    [anon_sym_PLUS_PLUS] = ACTIONS(1246),
    [anon_sym_DASH_DASH] = ACTIONS(1246),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1240),
  },
  [360] = {
    [anon_sym_AMP_AMP] = ACTIONS(681),
    [anon_sym_PIPE_PIPE] = ACTIONS(681),
    [anon_sym_RBRACK] = ACTIONS(1248),
    [anon_sym_EQ_TILDE] = ACTIONS(683),
    [anon_sym_EQ_EQ] = ACTIONS(683),
    [anon_sym_EQ] = ACTIONS(685),
    [anon_sym_PLUS_EQ] = ACTIONS(681),
    [anon_sym_LT] = ACTIONS(685),
    [anon_sym_GT] = ACTIONS(685),
    [anon_sym_BANG_EQ] = ACTIONS(681),
    [anon_sym_PLUS] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(685),
    [anon_sym_DASH_EQ] = ACTIONS(681),
    [anon_sym_LT_EQ] = ACTIONS(681),
    [anon_sym_GT_EQ] = ACTIONS(681),
    [anon_sym_PLUS_PLUS] = ACTIONS(687),
    [anon_sym_DASH_DASH] = ACTIONS(687),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(681),
  },
  [361] = {
    [sym_string] = STATE(790),
    [sym_simple_expansion] = STATE(790),
    [sym_string_expansion] = STATE(790),
    [sym_expansion] = STATE(790),
    [sym_command_substitution] = STATE(790),
    [sym_process_substitution] = STATE(790),
    [sym__special_characters] = ACTIONS(1490),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(1490),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1490),
  },
  [362] = {
    [aux_sym_concatenation_repeat1] = STATE(791),
    [sym__concat] = ACTIONS(657),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_RBRACK] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(807),
    [anon_sym_EQ_EQ] = ACTIONS(807),
    [anon_sym_EQ] = ACTIONS(809),
    [anon_sym_PLUS_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_BANG_EQ] = ACTIONS(807),
    [anon_sym_PLUS] = ACTIONS(809),
    [anon_sym_DASH] = ACTIONS(809),
    [anon_sym_DASH_EQ] = ACTIONS(807),
    [anon_sym_LT_EQ] = ACTIONS(807),
    [anon_sym_GT_EQ] = ACTIONS(807),
    [anon_sym_PLUS_PLUS] = ACTIONS(807),
    [anon_sym_DASH_DASH] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(807),
  },
  [363] = {
    [sym__concat] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [anon_sym_RBRACK] = ACTIONS(811),
    [anon_sym_EQ_TILDE] = ACTIONS(811),
    [anon_sym_EQ_EQ] = ACTIONS(811),
    [anon_sym_EQ] = ACTIONS(813),
    [anon_sym_PLUS_EQ] = ACTIONS(811),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_BANG_EQ] = ACTIONS(811),
    [anon_sym_PLUS] = ACTIONS(813),
    [anon_sym_DASH] = ACTIONS(813),
    [anon_sym_DASH_EQ] = ACTIONS(811),
    [anon_sym_LT_EQ] = ACTIONS(811),
    [anon_sym_GT_EQ] = ACTIONS(811),
    [anon_sym_PLUS_PLUS] = ACTIONS(811),
    [anon_sym_DASH_DASH] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(811),
  },
  [364] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(1492),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [365] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(1492),
    [anon_sym_DOLLAR] = ACTIONS(1494),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [366] = {
    [sym__concat] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [anon_sym_RBRACK] = ACTIONS(845),
    [anon_sym_EQ_TILDE] = ACTIONS(845),
    [anon_sym_EQ_EQ] = ACTIONS(845),
    [anon_sym_EQ] = ACTIONS(847),
    [anon_sym_PLUS_EQ] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(847),
    [anon_sym_GT] = ACTIONS(847),
    [anon_sym_BANG_EQ] = ACTIONS(845),
    [anon_sym_PLUS] = ACTIONS(847),
    [anon_sym_DASH] = ACTIONS(847),
    [anon_sym_DASH_EQ] = ACTIONS(845),
    [anon_sym_LT_EQ] = ACTIONS(845),
    [anon_sym_GT_EQ] = ACTIONS(845),
    [anon_sym_PLUS_PLUS] = ACTIONS(845),
    [anon_sym_DASH_DASH] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(845),
  },
  [367] = {
    [sym__concat] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [anon_sym_RBRACK] = ACTIONS(849),
    [anon_sym_EQ_TILDE] = ACTIONS(849),
    [anon_sym_EQ_EQ] = ACTIONS(849),
    [anon_sym_EQ] = ACTIONS(851),
    [anon_sym_PLUS_EQ] = ACTIONS(849),
    [anon_sym_LT] = ACTIONS(851),
    [anon_sym_GT] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(849),
    [anon_sym_PLUS] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(851),
    [anon_sym_DASH_EQ] = ACTIONS(849),
    [anon_sym_LT_EQ] = ACTIONS(849),
    [anon_sym_GT_EQ] = ACTIONS(849),
    [anon_sym_PLUS_PLUS] = ACTIONS(849),
    [anon_sym_DASH_DASH] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(849),
  },
  [368] = {
    [sym__concat] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [anon_sym_RBRACK] = ACTIONS(853),
    [anon_sym_EQ_TILDE] = ACTIONS(853),
    [anon_sym_EQ_EQ] = ACTIONS(853),
    [anon_sym_EQ] = ACTIONS(855),
    [anon_sym_PLUS_EQ] = ACTIONS(853),
    [anon_sym_LT] = ACTIONS(855),
    [anon_sym_GT] = ACTIONS(855),
    [anon_sym_BANG_EQ] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(855),
    [anon_sym_DASH] = ACTIONS(855),
    [anon_sym_DASH_EQ] = ACTIONS(853),
    [anon_sym_LT_EQ] = ACTIONS(853),
    [anon_sym_GT_EQ] = ACTIONS(853),
    [anon_sym_PLUS_PLUS] = ACTIONS(853),
    [anon_sym_DASH_DASH] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(853),
  },
  [369] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1496),
    [sym_comment] = ACTIONS(55),
  },
  [370] = {
    [sym_subscript] = STATE(797),
    [sym_variable_name] = ACTIONS(1498),
    [anon_sym_DASH] = ACTIONS(1500),
    [anon_sym_DOLLAR] = ACTIONS(1500),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1502),
    [anon_sym_STAR] = ACTIONS(1504),
    [anon_sym_AT] = ACTIONS(1504),
    [anon_sym_QMARK] = ACTIONS(1504),
    [anon_sym_0] = ACTIONS(1502),
    [anon_sym__] = ACTIONS(1502),
  },
  [371] = {
    [sym_concatenation] = STATE(800),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(800),
    [anon_sym_RBRACE] = ACTIONS(1506),
    [anon_sym_EQ] = ACTIONS(1508),
    [anon_sym_DASH] = ACTIONS(1508),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1510),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1512),
    [anon_sym_COLON] = ACTIONS(1508),
    [anon_sym_COLON_QMARK] = ACTIONS(1508),
    [anon_sym_COLON_DASH] = ACTIONS(1508),
    [anon_sym_PERCENT] = ACTIONS(1508),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [372] = {
    [sym_concatenation] = STATE(803),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(803),
    [anon_sym_RBRACE] = ACTIONS(1514),
    [anon_sym_EQ] = ACTIONS(1516),
    [anon_sym_DASH] = ACTIONS(1516),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1518),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1520),
    [anon_sym_COLON] = ACTIONS(1516),
    [anon_sym_COLON_QMARK] = ACTIONS(1516),
    [anon_sym_COLON_DASH] = ACTIONS(1516),
    [anon_sym_PERCENT] = ACTIONS(1516),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [373] = {
    [anon_sym_SEMI] = ACTIONS(1522),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1524),
    [anon_sym_SEMI_SEMI] = ACTIONS(1526),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1526),
    [anon_sym_AMP] = ACTIONS(1522),
  },
  [374] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1522),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1524),
    [anon_sym_SEMI_SEMI] = ACTIONS(1526),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1526),
    [anon_sym_AMP] = ACTIONS(1522),
  },
  [375] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(806),
    [sym_c_style_for_statement] = STATE(806),
    [sym_while_statement] = STATE(806),
    [sym_if_statement] = STATE(806),
    [sym_case_statement] = STATE(806),
    [sym_function_definition] = STATE(806),
    [sym_subshell] = STATE(806),
    [sym_pipeline] = STATE(806),
    [sym_list] = STATE(806),
    [sym_negated_command] = STATE(806),
    [sym_test_command] = STATE(806),
    [sym_declaration_command] = STATE(806),
    [sym_unset_command] = STATE(806),
    [sym_command] = STATE(806),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(807),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [376] = {
    [anon_sym_SEMI] = ACTIONS(1528),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1530),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1524),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1530),
    [anon_sym_AMP] = ACTIONS(1528),
  },
  [377] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1528),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1530),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1524),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1530),
    [anon_sym_AMP] = ACTIONS(1528),
  },
  [378] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(809),
    [sym_c_style_for_statement] = STATE(809),
    [sym_while_statement] = STATE(809),
    [sym_if_statement] = STATE(809),
    [sym_case_statement] = STATE(809),
    [sym_function_definition] = STATE(809),
    [sym_subshell] = STATE(809),
    [sym_pipeline] = STATE(809),
    [sym_list] = STATE(809),
    [sym_negated_command] = STATE(809),
    [sym_test_command] = STATE(809),
    [sym_declaration_command] = STATE(809),
    [sym_unset_command] = STATE(809),
    [sym_command] = STATE(809),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(810),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [379] = {
    [anon_sym_SEMI] = ACTIONS(1532),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1534),
    [anon_sym_SEMI_SEMI] = ACTIONS(1536),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1536),
    [anon_sym_AMP] = ACTIONS(1532),
  },
  [380] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1532),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1534),
    [anon_sym_SEMI_SEMI] = ACTIONS(1536),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1536),
    [anon_sym_AMP] = ACTIONS(1532),
  },
  [381] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(813),
    [sym_c_style_for_statement] = STATE(813),
    [sym_while_statement] = STATE(813),
    [sym_if_statement] = STATE(813),
    [sym_case_statement] = STATE(813),
    [sym_function_definition] = STATE(813),
    [sym_subshell] = STATE(813),
    [sym_pipeline] = STATE(813),
    [sym_list] = STATE(813),
    [sym_negated_command] = STATE(813),
    [sym_test_command] = STATE(813),
    [sym_declaration_command] = STATE(813),
    [sym_unset_command] = STATE(813),
    [sym_command] = STATE(813),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(814),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [382] = {
    [sym__expression] = STATE(815),
    [sym_binary_expression] = STATE(815),
    [sym_unary_expression] = STATE(815),
    [sym_postfix_expression] = STATE(815),
    [sym_parenthesized_expression] = STATE(815),
    [sym_concatenation] = STATE(815),
    [sym_string] = STATE(105),
    [sym_simple_expansion] = STATE(105),
    [sym_string_expansion] = STATE(105),
    [sym_expansion] = STATE(105),
    [sym_command_substitution] = STATE(105),
    [sym_process_substitution] = STATE(105),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [sym__special_characters] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(183),
    [sym_test_operator] = ACTIONS(185),
  },
  [383] = {
    [sym__expression] = STATE(815),
    [sym_binary_expression] = STATE(815),
    [sym_unary_expression] = STATE(815),
    [sym_postfix_expression] = STATE(815),
    [sym_parenthesized_expression] = STATE(815),
    [sym_concatenation] = STATE(815),
    [sym_string] = STATE(105),
    [sym_simple_expansion] = STATE(105),
    [sym_string_expansion] = STATE(105),
    [sym_expansion] = STATE(105),
    [sym_command_substitution] = STATE(105),
    [sym_process_substitution] = STATE(105),
    [sym_regex] = ACTIONS(1538),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [sym__special_characters] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(183),
    [sym_test_operator] = ACTIONS(185),
  },
  [384] = {
    [anon_sym_AMP_AMP] = ACTIONS(1316),
    [anon_sym_PIPE_PIPE] = ACTIONS(1316),
    [anon_sym_RBRACK] = ACTIONS(1316),
    [anon_sym_EQ_TILDE] = ACTIONS(1316),
    [anon_sym_EQ_EQ] = ACTIONS(1316),
    [anon_sym_EQ] = ACTIONS(1318),
    [anon_sym_PLUS_EQ] = ACTIONS(1316),
    [anon_sym_LT] = ACTIONS(1318),
    [anon_sym_GT] = ACTIONS(1318),
    [anon_sym_BANG_EQ] = ACTIONS(1316),
    [anon_sym_PLUS] = ACTIONS(1318),
    [anon_sym_DASH] = ACTIONS(1318),
    [anon_sym_DASH_EQ] = ACTIONS(1316),
    [anon_sym_LT_EQ] = ACTIONS(1316),
    [anon_sym_GT_EQ] = ACTIONS(1316),
    [anon_sym_PLUS_PLUS] = ACTIONS(1316),
    [anon_sym_DASH_DASH] = ACTIONS(1316),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1316),
  },
  [385] = {
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1248),
    [anon_sym_EQ_TILDE] = ACTIONS(691),
    [anon_sym_EQ_EQ] = ACTIONS(691),
    [anon_sym_EQ] = ACTIONS(693),
    [anon_sym_PLUS_EQ] = ACTIONS(689),
    [anon_sym_LT] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(693),
    [anon_sym_BANG_EQ] = ACTIONS(689),
    [anon_sym_PLUS] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(693),
    [anon_sym_DASH_EQ] = ACTIONS(689),
    [anon_sym_LT_EQ] = ACTIONS(689),
    [anon_sym_GT_EQ] = ACTIONS(689),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(689),
  },
  [386] = {
    [aux_sym_concatenation_repeat1] = STATE(817),
    [sym__concat] = ACTIONS(459),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(807),
    [anon_sym_EQ_EQ] = ACTIONS(807),
    [anon_sym_EQ] = ACTIONS(809),
    [anon_sym_PLUS_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_BANG_EQ] = ACTIONS(807),
    [anon_sym_PLUS] = ACTIONS(809),
    [anon_sym_DASH] = ACTIONS(809),
    [anon_sym_DASH_EQ] = ACTIONS(807),
    [anon_sym_LT_EQ] = ACTIONS(807),
    [anon_sym_GT_EQ] = ACTIONS(807),
    [anon_sym_PLUS_PLUS] = ACTIONS(807),
    [anon_sym_DASH_DASH] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(807),
  },
  [387] = {
    [sym__expression] = STATE(682),
    [sym_binary_expression] = STATE(682),
    [sym_unary_expression] = STATE(682),
    [sym_postfix_expression] = STATE(682),
    [sym_parenthesized_expression] = STATE(682),
    [sym_concatenation] = STATE(682),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(187),
    [sym__special_characters] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(193),
    [sym_test_operator] = ACTIONS(195),
  },
  [388] = {
    [sym__expression] = STATE(682),
    [sym_binary_expression] = STATE(682),
    [sym_unary_expression] = STATE(682),
    [sym_postfix_expression] = STATE(682),
    [sym_parenthesized_expression] = STATE(682),
    [sym_concatenation] = STATE(682),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [sym_regex] = ACTIONS(1314),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(187),
    [sym__special_characters] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(193),
    [sym_test_operator] = ACTIONS(195),
  },
  [389] = {
    [sym_concatenation] = STATE(818),
    [sym_string] = STATE(821),
    [sym_array] = STATE(818),
    [sym_simple_expansion] = STATE(821),
    [sym_string_expansion] = STATE(821),
    [sym_expansion] = STATE(821),
    [sym_command_substitution] = STATE(821),
    [sym_process_substitution] = STATE(821),
    [sym__empty_value] = ACTIONS(1540),
    [anon_sym_LPAREN] = ACTIONS(1542),
    [sym__special_characters] = ACTIONS(1544),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(1546),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1546),
  },
  [390] = {
    [sym_string] = STATE(822),
    [sym_simple_expansion] = STATE(822),
    [sym_string_expansion] = STATE(822),
    [sym_expansion] = STATE(822),
    [sym_command_substitution] = STATE(822),
    [sym_process_substitution] = STATE(822),
    [sym__special_characters] = ACTIONS(1548),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(1548),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1548),
  },
  [391] = {
    [aux_sym_concatenation_repeat1] = STATE(823),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(807),
    [ts_builtin_sym_end] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_PIPE] = ACTIONS(809),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [anon_sym_PIPE_AMP] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [sym__special_characters] = ACTIONS(807),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(807),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [anon_sym_LT_LPAREN] = ACTIONS(807),
    [anon_sym_GT_LPAREN] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(809),
    [sym_word] = ACTIONS(809),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(809),
  },
  [392] = {
    [sym__concat] = ACTIONS(811),
    [sym_variable_name] = ACTIONS(811),
    [ts_builtin_sym_end] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(813),
    [anon_sym_PIPE] = ACTIONS(813),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_SEMI_SEMI] = ACTIONS(811),
    [anon_sym_PIPE_AMP] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [sym__special_characters] = ACTIONS(811),
    [anon_sym_DQUOTE] = ACTIONS(811),
    [anon_sym_DOLLAR] = ACTIONS(813),
    [sym_raw_string] = ACTIONS(811),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(811),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(811),
    [anon_sym_BQUOTE] = ACTIONS(811),
    [anon_sym_LT_LPAREN] = ACTIONS(811),
    [anon_sym_GT_LPAREN] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(813),
    [sym_word] = ACTIONS(813),
    [anon_sym_LF] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(813),
  },
  [393] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(1550),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [394] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(1550),
    [anon_sym_DOLLAR] = ACTIONS(1552),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [395] = {
    [sym__concat] = ACTIONS(845),
    [sym_variable_name] = ACTIONS(845),
    [ts_builtin_sym_end] = ACTIONS(845),
    [anon_sym_SEMI] = ACTIONS(847),
    [anon_sym_PIPE] = ACTIONS(847),
    [anon_sym_RPAREN] = ACTIONS(845),
    [anon_sym_SEMI_SEMI] = ACTIONS(845),
    [anon_sym_PIPE_AMP] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [sym__special_characters] = ACTIONS(845),
    [anon_sym_DQUOTE] = ACTIONS(845),
    [anon_sym_DOLLAR] = ACTIONS(847),
    [sym_raw_string] = ACTIONS(845),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(845),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(845),
    [anon_sym_BQUOTE] = ACTIONS(845),
    [anon_sym_LT_LPAREN] = ACTIONS(845),
    [anon_sym_GT_LPAREN] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(847),
    [sym_word] = ACTIONS(847),
    [anon_sym_LF] = ACTIONS(845),
    [anon_sym_AMP] = ACTIONS(847),
  },
  [396] = {
    [sym__concat] = ACTIONS(849),
    [sym_variable_name] = ACTIONS(849),
    [ts_builtin_sym_end] = ACTIONS(849),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_PIPE] = ACTIONS(851),
    [anon_sym_RPAREN] = ACTIONS(849),
    [anon_sym_SEMI_SEMI] = ACTIONS(849),
    [anon_sym_PIPE_AMP] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [sym__special_characters] = ACTIONS(849),
    [anon_sym_DQUOTE] = ACTIONS(849),
    [anon_sym_DOLLAR] = ACTIONS(851),
    [sym_raw_string] = ACTIONS(849),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(849),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(849),
    [anon_sym_BQUOTE] = ACTIONS(849),
    [anon_sym_LT_LPAREN] = ACTIONS(849),
    [anon_sym_GT_LPAREN] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(851),
    [sym_word] = ACTIONS(851),
    [anon_sym_LF] = ACTIONS(849),
    [anon_sym_AMP] = ACTIONS(851),
  },
  [397] = {
    [sym__concat] = ACTIONS(853),
    [sym_variable_name] = ACTIONS(853),
    [ts_builtin_sym_end] = ACTIONS(853),
    [anon_sym_SEMI] = ACTIONS(855),
    [anon_sym_PIPE] = ACTIONS(855),
    [anon_sym_RPAREN] = ACTIONS(853),
    [anon_sym_SEMI_SEMI] = ACTIONS(853),
    [anon_sym_PIPE_AMP] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [sym__special_characters] = ACTIONS(853),
    [anon_sym_DQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [sym_raw_string] = ACTIONS(853),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(853),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(853),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_LT_LPAREN] = ACTIONS(853),
    [anon_sym_GT_LPAREN] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(855),
    [sym_word] = ACTIONS(855),
    [anon_sym_LF] = ACTIONS(853),
    [anon_sym_AMP] = ACTIONS(855),
  },
  [398] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1554),
    [sym_comment] = ACTIONS(55),
  },
  [399] = {
    [sym_subscript] = STATE(829),
    [sym_variable_name] = ACTIONS(1556),
    [anon_sym_DASH] = ACTIONS(1558),
    [anon_sym_DOLLAR] = ACTIONS(1558),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1560),
    [anon_sym_STAR] = ACTIONS(1562),
    [anon_sym_AT] = ACTIONS(1562),
    [anon_sym_QMARK] = ACTIONS(1562),
    [anon_sym_0] = ACTIONS(1560),
    [anon_sym__] = ACTIONS(1560),
  },
  [400] = {
    [sym_concatenation] = STATE(832),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(832),
    [anon_sym_RBRACE] = ACTIONS(1564),
    [anon_sym_EQ] = ACTIONS(1566),
    [anon_sym_DASH] = ACTIONS(1566),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1568),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1570),
    [anon_sym_COLON] = ACTIONS(1566),
    [anon_sym_COLON_QMARK] = ACTIONS(1566),
    [anon_sym_COLON_DASH] = ACTIONS(1566),
    [anon_sym_PERCENT] = ACTIONS(1566),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [401] = {
    [sym_concatenation] = STATE(835),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(835),
    [anon_sym_RBRACE] = ACTIONS(1572),
    [anon_sym_EQ] = ACTIONS(1574),
    [anon_sym_DASH] = ACTIONS(1574),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1576),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1578),
    [anon_sym_COLON] = ACTIONS(1574),
    [anon_sym_COLON_QMARK] = ACTIONS(1574),
    [anon_sym_COLON_DASH] = ACTIONS(1574),
    [anon_sym_PERCENT] = ACTIONS(1574),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [402] = {
    [anon_sym_SEMI] = ACTIONS(1580),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1582),
    [anon_sym_SEMI_SEMI] = ACTIONS(1584),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1584),
    [anon_sym_AMP] = ACTIONS(1580),
  },
  [403] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1580),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1582),
    [anon_sym_SEMI_SEMI] = ACTIONS(1584),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1584),
    [anon_sym_AMP] = ACTIONS(1580),
  },
  [404] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(838),
    [sym_c_style_for_statement] = STATE(838),
    [sym_while_statement] = STATE(838),
    [sym_if_statement] = STATE(838),
    [sym_case_statement] = STATE(838),
    [sym_function_definition] = STATE(838),
    [sym_subshell] = STATE(838),
    [sym_pipeline] = STATE(838),
    [sym_list] = STATE(838),
    [sym_negated_command] = STATE(838),
    [sym_test_command] = STATE(838),
    [sym_declaration_command] = STATE(838),
    [sym_unset_command] = STATE(838),
    [sym_command] = STATE(838),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(839),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [405] = {
    [anon_sym_SEMI] = ACTIONS(1586),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1588),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1582),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1588),
    [anon_sym_AMP] = ACTIONS(1586),
  },
  [406] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1586),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1588),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1582),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1588),
    [anon_sym_AMP] = ACTIONS(1586),
  },
  [407] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(841),
    [sym_c_style_for_statement] = STATE(841),
    [sym_while_statement] = STATE(841),
    [sym_if_statement] = STATE(841),
    [sym_case_statement] = STATE(841),
    [sym_function_definition] = STATE(841),
    [sym_subshell] = STATE(841),
    [sym_pipeline] = STATE(841),
    [sym_list] = STATE(841),
    [sym_negated_command] = STATE(841),
    [sym_test_command] = STATE(841),
    [sym_declaration_command] = STATE(841),
    [sym_unset_command] = STATE(841),
    [sym_command] = STATE(841),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(842),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [408] = {
    [anon_sym_SEMI] = ACTIONS(1590),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1592),
    [anon_sym_SEMI_SEMI] = ACTIONS(1594),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1594),
    [anon_sym_AMP] = ACTIONS(1590),
  },
  [409] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1590),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1592),
    [anon_sym_SEMI_SEMI] = ACTIONS(1594),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1594),
    [anon_sym_AMP] = ACTIONS(1590),
  },
  [410] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(845),
    [sym_c_style_for_statement] = STATE(845),
    [sym_while_statement] = STATE(845),
    [sym_if_statement] = STATE(845),
    [sym_case_statement] = STATE(845),
    [sym_function_definition] = STATE(845),
    [sym_subshell] = STATE(845),
    [sym_pipeline] = STATE(845),
    [sym_list] = STATE(845),
    [sym_negated_command] = STATE(845),
    [sym_test_command] = STATE(845),
    [sym_declaration_command] = STATE(845),
    [sym_unset_command] = STATE(845),
    [sym_command] = STATE(845),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(846),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [411] = {
    [sym_variable_assignment] = STATE(411),
    [sym_subscript] = STATE(124),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(119),
    [sym_simple_expansion] = STATE(119),
    [sym_string_expansion] = STATE(119),
    [sym_expansion] = STATE(119),
    [sym_command_substitution] = STATE(119),
    [sym_process_substitution] = STATE(119),
    [aux_sym_declaration_command_repeat1] = STATE(411),
    [sym_variable_name] = ACTIONS(1596),
    [ts_builtin_sym_end] = ACTIONS(1599),
    [anon_sym_SEMI] = ACTIONS(1601),
    [anon_sym_PIPE] = ACTIONS(1601),
    [anon_sym_SEMI_SEMI] = ACTIONS(1599),
    [anon_sym_PIPE_AMP] = ACTIONS(1599),
    [anon_sym_AMP_AMP] = ACTIONS(1599),
    [anon_sym_PIPE_PIPE] = ACTIONS(1599),
    [sym__special_characters] = ACTIONS(1603),
    [anon_sym_DQUOTE] = ACTIONS(1606),
    [anon_sym_DOLLAR] = ACTIONS(1609),
    [sym_raw_string] = ACTIONS(1612),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1615),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1618),
    [anon_sym_BQUOTE] = ACTIONS(1621),
    [anon_sym_LT_LPAREN] = ACTIONS(1624),
    [anon_sym_GT_LPAREN] = ACTIONS(1624),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1627),
    [sym_word] = ACTIONS(1630),
    [anon_sym_LF] = ACTIONS(1599),
    [anon_sym_AMP] = ACTIONS(1601),
  },
  [412] = {
    [sym_string] = STATE(847),
    [sym_simple_expansion] = STATE(847),
    [sym_string_expansion] = STATE(847),
    [sym_expansion] = STATE(847),
    [sym_command_substitution] = STATE(847),
    [sym_process_substitution] = STATE(847),
    [sym__special_characters] = ACTIONS(1633),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(1633),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1633),
  },
  [413] = {
    [aux_sym_concatenation_repeat1] = STATE(848),
    [sym__concat] = ACTIONS(735),
    [ts_builtin_sym_end] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_PIPE] = ACTIONS(809),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [anon_sym_PIPE_AMP] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [sym__special_characters] = ACTIONS(807),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(807),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [anon_sym_LT_LPAREN] = ACTIONS(807),
    [anon_sym_GT_LPAREN] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(809),
    [sym_word] = ACTIONS(809),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(809),
  },
  [414] = {
    [sym__concat] = ACTIONS(811),
    [ts_builtin_sym_end] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(813),
    [anon_sym_PIPE] = ACTIONS(813),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_SEMI_SEMI] = ACTIONS(811),
    [anon_sym_PIPE_AMP] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [sym__special_characters] = ACTIONS(811),
    [anon_sym_DQUOTE] = ACTIONS(811),
    [anon_sym_DOLLAR] = ACTIONS(813),
    [sym_raw_string] = ACTIONS(811),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(811),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(811),
    [anon_sym_BQUOTE] = ACTIONS(811),
    [anon_sym_LT_LPAREN] = ACTIONS(811),
    [anon_sym_GT_LPAREN] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(813),
    [sym_word] = ACTIONS(813),
    [anon_sym_LF] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(813),
  },
  [415] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(1635),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [416] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(1635),
    [anon_sym_DOLLAR] = ACTIONS(1637),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [417] = {
    [sym__concat] = ACTIONS(845),
    [ts_builtin_sym_end] = ACTIONS(845),
    [anon_sym_SEMI] = ACTIONS(847),
    [anon_sym_PIPE] = ACTIONS(847),
    [anon_sym_RPAREN] = ACTIONS(845),
    [anon_sym_SEMI_SEMI] = ACTIONS(845),
    [anon_sym_PIPE_AMP] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [sym__special_characters] = ACTIONS(845),
    [anon_sym_DQUOTE] = ACTIONS(845),
    [anon_sym_DOLLAR] = ACTIONS(847),
    [sym_raw_string] = ACTIONS(845),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(845),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(845),
    [anon_sym_BQUOTE] = ACTIONS(845),
    [anon_sym_LT_LPAREN] = ACTIONS(845),
    [anon_sym_GT_LPAREN] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(847),
    [sym_word] = ACTIONS(847),
    [anon_sym_LF] = ACTIONS(845),
    [anon_sym_AMP] = ACTIONS(847),
  },
  [418] = {
    [sym__concat] = ACTIONS(849),
    [ts_builtin_sym_end] = ACTIONS(849),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_PIPE] = ACTIONS(851),
    [anon_sym_RPAREN] = ACTIONS(849),
    [anon_sym_SEMI_SEMI] = ACTIONS(849),
    [anon_sym_PIPE_AMP] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [sym__special_characters] = ACTIONS(849),
    [anon_sym_DQUOTE] = ACTIONS(849),
    [anon_sym_DOLLAR] = ACTIONS(851),
    [sym_raw_string] = ACTIONS(849),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(849),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(849),
    [anon_sym_BQUOTE] = ACTIONS(849),
    [anon_sym_LT_LPAREN] = ACTIONS(849),
    [anon_sym_GT_LPAREN] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(851),
    [sym_word] = ACTIONS(851),
    [anon_sym_LF] = ACTIONS(849),
    [anon_sym_AMP] = ACTIONS(851),
  },
  [419] = {
    [sym__concat] = ACTIONS(853),
    [ts_builtin_sym_end] = ACTIONS(853),
    [anon_sym_SEMI] = ACTIONS(855),
    [anon_sym_PIPE] = ACTIONS(855),
    [anon_sym_RPAREN] = ACTIONS(853),
    [anon_sym_SEMI_SEMI] = ACTIONS(853),
    [anon_sym_PIPE_AMP] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [sym__special_characters] = ACTIONS(853),
    [anon_sym_DQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [sym_raw_string] = ACTIONS(853),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(853),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(853),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_LT_LPAREN] = ACTIONS(853),
    [anon_sym_GT_LPAREN] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(855),
    [sym_word] = ACTIONS(855),
    [anon_sym_LF] = ACTIONS(853),
    [anon_sym_AMP] = ACTIONS(855),
  },
  [420] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1639),
    [sym_comment] = ACTIONS(55),
  },
  [421] = {
    [sym_subscript] = STATE(854),
    [sym_variable_name] = ACTIONS(1641),
    [anon_sym_DASH] = ACTIONS(1643),
    [anon_sym_DOLLAR] = ACTIONS(1643),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1645),
    [anon_sym_STAR] = ACTIONS(1647),
    [anon_sym_AT] = ACTIONS(1647),
    [anon_sym_QMARK] = ACTIONS(1647),
    [anon_sym_0] = ACTIONS(1645),
    [anon_sym__] = ACTIONS(1645),
  },
  [422] = {
    [sym_concatenation] = STATE(857),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(857),
    [anon_sym_RBRACE] = ACTIONS(1649),
    [anon_sym_EQ] = ACTIONS(1651),
    [anon_sym_DASH] = ACTIONS(1651),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1653),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1655),
    [anon_sym_COLON] = ACTIONS(1651),
    [anon_sym_COLON_QMARK] = ACTIONS(1651),
    [anon_sym_COLON_DASH] = ACTIONS(1651),
    [anon_sym_PERCENT] = ACTIONS(1651),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [423] = {
    [sym_concatenation] = STATE(860),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(860),
    [anon_sym_RBRACE] = ACTIONS(1657),
    [anon_sym_EQ] = ACTIONS(1659),
    [anon_sym_DASH] = ACTIONS(1659),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1661),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1663),
    [anon_sym_COLON] = ACTIONS(1659),
    [anon_sym_COLON_QMARK] = ACTIONS(1659),
    [anon_sym_COLON_DASH] = ACTIONS(1659),
    [anon_sym_PERCENT] = ACTIONS(1659),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [424] = {
    [anon_sym_SEMI] = ACTIONS(1665),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1667),
    [anon_sym_SEMI_SEMI] = ACTIONS(1669),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1669),
    [anon_sym_AMP] = ACTIONS(1665),
  },
  [425] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1665),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1667),
    [anon_sym_SEMI_SEMI] = ACTIONS(1669),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1669),
    [anon_sym_AMP] = ACTIONS(1665),
  },
  [426] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(863),
    [sym_c_style_for_statement] = STATE(863),
    [sym_while_statement] = STATE(863),
    [sym_if_statement] = STATE(863),
    [sym_case_statement] = STATE(863),
    [sym_function_definition] = STATE(863),
    [sym_subshell] = STATE(863),
    [sym_pipeline] = STATE(863),
    [sym_list] = STATE(863),
    [sym_negated_command] = STATE(863),
    [sym_test_command] = STATE(863),
    [sym_declaration_command] = STATE(863),
    [sym_unset_command] = STATE(863),
    [sym_command] = STATE(863),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(864),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [427] = {
    [anon_sym_SEMI] = ACTIONS(1671),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1673),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1667),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1673),
    [anon_sym_AMP] = ACTIONS(1671),
  },
  [428] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1671),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1673),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1667),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1673),
    [anon_sym_AMP] = ACTIONS(1671),
  },
  [429] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(866),
    [sym_c_style_for_statement] = STATE(866),
    [sym_while_statement] = STATE(866),
    [sym_if_statement] = STATE(866),
    [sym_case_statement] = STATE(866),
    [sym_function_definition] = STATE(866),
    [sym_subshell] = STATE(866),
    [sym_pipeline] = STATE(866),
    [sym_list] = STATE(866),
    [sym_negated_command] = STATE(866),
    [sym_test_command] = STATE(866),
    [sym_declaration_command] = STATE(866),
    [sym_unset_command] = STATE(866),
    [sym_command] = STATE(866),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(867),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [430] = {
    [anon_sym_SEMI] = ACTIONS(1675),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1677),
    [anon_sym_SEMI_SEMI] = ACTIONS(1679),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1679),
    [anon_sym_AMP] = ACTIONS(1675),
  },
  [431] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1675),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1677),
    [anon_sym_SEMI_SEMI] = ACTIONS(1679),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1679),
    [anon_sym_AMP] = ACTIONS(1675),
  },
  [432] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(870),
    [sym_c_style_for_statement] = STATE(870),
    [sym_while_statement] = STATE(870),
    [sym_if_statement] = STATE(870),
    [sym_case_statement] = STATE(870),
    [sym_function_definition] = STATE(870),
    [sym_subshell] = STATE(870),
    [sym_pipeline] = STATE(870),
    [sym_list] = STATE(870),
    [sym_negated_command] = STATE(870),
    [sym_test_command] = STATE(870),
    [sym_declaration_command] = STATE(870),
    [sym_unset_command] = STATE(870),
    [sym_command] = STATE(870),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(871),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [433] = {
    [sym_concatenation] = STATE(433),
    [sym_string] = STATE(129),
    [sym_simple_expansion] = STATE(129),
    [sym_string_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [sym_process_substitution] = STATE(129),
    [aux_sym_unset_command_repeat1] = STATE(433),
    [ts_builtin_sym_end] = ACTIONS(1681),
    [anon_sym_SEMI] = ACTIONS(1683),
    [anon_sym_PIPE] = ACTIONS(1683),
    [anon_sym_SEMI_SEMI] = ACTIONS(1681),
    [anon_sym_PIPE_AMP] = ACTIONS(1681),
    [anon_sym_AMP_AMP] = ACTIONS(1681),
    [anon_sym_PIPE_PIPE] = ACTIONS(1681),
    [sym__special_characters] = ACTIONS(1685),
    [anon_sym_DQUOTE] = ACTIONS(1688),
    [anon_sym_DOLLAR] = ACTIONS(1691),
    [sym_raw_string] = ACTIONS(1694),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1697),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1700),
    [anon_sym_BQUOTE] = ACTIONS(1703),
    [anon_sym_LT_LPAREN] = ACTIONS(1706),
    [anon_sym_GT_LPAREN] = ACTIONS(1706),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1709),
    [sym_word] = ACTIONS(1712),
    [anon_sym_LF] = ACTIONS(1681),
    [anon_sym_AMP] = ACTIONS(1683),
  },
  [434] = {
    [sym_string] = STATE(872),
    [sym_simple_expansion] = STATE(872),
    [sym_string_expansion] = STATE(872),
    [sym_expansion] = STATE(872),
    [sym_command_substitution] = STATE(872),
    [sym_process_substitution] = STATE(872),
    [sym__special_characters] = ACTIONS(1715),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(251),
    [sym_raw_string] = ACTIONS(1715),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(255),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(257),
    [anon_sym_BQUOTE] = ACTIONS(259),
    [anon_sym_LT_LPAREN] = ACTIONS(261),
    [anon_sym_GT_LPAREN] = ACTIONS(261),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1715),
  },
  [435] = {
    [aux_sym_concatenation_repeat1] = STATE(873),
    [sym_file_descriptor] = ACTIONS(807),
    [sym__concat] = ACTIONS(775),
    [sym_variable_name] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_GT_GT] = ACTIONS(807),
    [anon_sym_AMP_GT] = ACTIONS(809),
    [anon_sym_AMP_GT_GT] = ACTIONS(807),
    [anon_sym_LT_AMP] = ACTIONS(807),
    [anon_sym_GT_AMP] = ACTIONS(807),
    [sym__special_characters] = ACTIONS(807),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(807),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [anon_sym_LT_LPAREN] = ACTIONS(807),
    [anon_sym_GT_LPAREN] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(807),
  },
  [436] = {
    [sym_file_descriptor] = ACTIONS(811),
    [sym__concat] = ACTIONS(811),
    [sym_variable_name] = ACTIONS(811),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_GT_GT] = ACTIONS(811),
    [anon_sym_AMP_GT] = ACTIONS(813),
    [anon_sym_AMP_GT_GT] = ACTIONS(811),
    [anon_sym_LT_AMP] = ACTIONS(811),
    [anon_sym_GT_AMP] = ACTIONS(811),
    [sym__special_characters] = ACTIONS(811),
    [anon_sym_DQUOTE] = ACTIONS(811),
    [anon_sym_DOLLAR] = ACTIONS(813),
    [sym_raw_string] = ACTIONS(811),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(811),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(811),
    [anon_sym_BQUOTE] = ACTIONS(811),
    [anon_sym_LT_LPAREN] = ACTIONS(811),
    [anon_sym_GT_LPAREN] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(811),
  },
  [437] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(1717),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [438] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(1717),
    [anon_sym_DOLLAR] = ACTIONS(1719),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [439] = {
    [sym_file_descriptor] = ACTIONS(845),
    [sym__concat] = ACTIONS(845),
    [sym_variable_name] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(847),
    [anon_sym_GT] = ACTIONS(847),
    [anon_sym_GT_GT] = ACTIONS(845),
    [anon_sym_AMP_GT] = ACTIONS(847),
    [anon_sym_AMP_GT_GT] = ACTIONS(845),
    [anon_sym_LT_AMP] = ACTIONS(845),
    [anon_sym_GT_AMP] = ACTIONS(845),
    [sym__special_characters] = ACTIONS(845),
    [anon_sym_DQUOTE] = ACTIONS(845),
    [anon_sym_DOLLAR] = ACTIONS(847),
    [sym_raw_string] = ACTIONS(845),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(845),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(845),
    [anon_sym_BQUOTE] = ACTIONS(845),
    [anon_sym_LT_LPAREN] = ACTIONS(845),
    [anon_sym_GT_LPAREN] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(845),
  },
  [440] = {
    [sym_file_descriptor] = ACTIONS(849),
    [sym__concat] = ACTIONS(849),
    [sym_variable_name] = ACTIONS(849),
    [anon_sym_LT] = ACTIONS(851),
    [anon_sym_GT] = ACTIONS(851),
    [anon_sym_GT_GT] = ACTIONS(849),
    [anon_sym_AMP_GT] = ACTIONS(851),
    [anon_sym_AMP_GT_GT] = ACTIONS(849),
    [anon_sym_LT_AMP] = ACTIONS(849),
    [anon_sym_GT_AMP] = ACTIONS(849),
    [sym__special_characters] = ACTIONS(849),
    [anon_sym_DQUOTE] = ACTIONS(849),
    [anon_sym_DOLLAR] = ACTIONS(851),
    [sym_raw_string] = ACTIONS(849),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(849),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(849),
    [anon_sym_BQUOTE] = ACTIONS(849),
    [anon_sym_LT_LPAREN] = ACTIONS(849),
    [anon_sym_GT_LPAREN] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(849),
  },
  [441] = {
    [sym_file_descriptor] = ACTIONS(853),
    [sym__concat] = ACTIONS(853),
    [sym_variable_name] = ACTIONS(853),
    [anon_sym_LT] = ACTIONS(855),
    [anon_sym_GT] = ACTIONS(855),
    [anon_sym_GT_GT] = ACTIONS(853),
    [anon_sym_AMP_GT] = ACTIONS(855),
    [anon_sym_AMP_GT_GT] = ACTIONS(853),
    [anon_sym_LT_AMP] = ACTIONS(853),
    [anon_sym_GT_AMP] = ACTIONS(853),
    [sym__special_characters] = ACTIONS(853),
    [anon_sym_DQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [sym_raw_string] = ACTIONS(853),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(853),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(853),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_LT_LPAREN] = ACTIONS(853),
    [anon_sym_GT_LPAREN] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(853),
  },
  [442] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1721),
    [sym_comment] = ACTIONS(55),
  },
  [443] = {
    [sym_subscript] = STATE(879),
    [sym_variable_name] = ACTIONS(1723),
    [anon_sym_DASH] = ACTIONS(1725),
    [anon_sym_DOLLAR] = ACTIONS(1725),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1727),
    [anon_sym_STAR] = ACTIONS(1729),
    [anon_sym_AT] = ACTIONS(1729),
    [anon_sym_QMARK] = ACTIONS(1729),
    [anon_sym_0] = ACTIONS(1727),
    [anon_sym__] = ACTIONS(1727),
  },
  [444] = {
    [sym_concatenation] = STATE(882),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(882),
    [anon_sym_RBRACE] = ACTIONS(1731),
    [anon_sym_EQ] = ACTIONS(1733),
    [anon_sym_DASH] = ACTIONS(1733),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1735),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1737),
    [anon_sym_COLON] = ACTIONS(1733),
    [anon_sym_COLON_QMARK] = ACTIONS(1733),
    [anon_sym_COLON_DASH] = ACTIONS(1733),
    [anon_sym_PERCENT] = ACTIONS(1733),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [445] = {
    [sym_concatenation] = STATE(885),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(885),
    [anon_sym_RBRACE] = ACTIONS(1739),
    [anon_sym_EQ] = ACTIONS(1741),
    [anon_sym_DASH] = ACTIONS(1741),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1743),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1745),
    [anon_sym_COLON] = ACTIONS(1741),
    [anon_sym_COLON_QMARK] = ACTIONS(1741),
    [anon_sym_COLON_DASH] = ACTIONS(1741),
    [anon_sym_PERCENT] = ACTIONS(1741),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [446] = {
    [anon_sym_SEMI] = ACTIONS(1747),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1749),
    [anon_sym_SEMI_SEMI] = ACTIONS(1751),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1751),
    [anon_sym_AMP] = ACTIONS(1747),
  },
  [447] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1747),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1749),
    [anon_sym_SEMI_SEMI] = ACTIONS(1751),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1751),
    [anon_sym_AMP] = ACTIONS(1747),
  },
  [448] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(888),
    [sym_c_style_for_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_case_statement] = STATE(888),
    [sym_function_definition] = STATE(888),
    [sym_subshell] = STATE(888),
    [sym_pipeline] = STATE(888),
    [sym_list] = STATE(888),
    [sym_negated_command] = STATE(888),
    [sym_test_command] = STATE(888),
    [sym_declaration_command] = STATE(888),
    [sym_unset_command] = STATE(888),
    [sym_command] = STATE(888),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(889),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [449] = {
    [anon_sym_SEMI] = ACTIONS(1753),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1755),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1749),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1755),
    [anon_sym_AMP] = ACTIONS(1753),
  },
  [450] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1753),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1755),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1749),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1755),
    [anon_sym_AMP] = ACTIONS(1753),
  },
  [451] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(891),
    [sym_c_style_for_statement] = STATE(891),
    [sym_while_statement] = STATE(891),
    [sym_if_statement] = STATE(891),
    [sym_case_statement] = STATE(891),
    [sym_function_definition] = STATE(891),
    [sym_subshell] = STATE(891),
    [sym_pipeline] = STATE(891),
    [sym_list] = STATE(891),
    [sym_negated_command] = STATE(891),
    [sym_test_command] = STATE(891),
    [sym_declaration_command] = STATE(891),
    [sym_unset_command] = STATE(891),
    [sym_command] = STATE(891),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(892),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [452] = {
    [anon_sym_SEMI] = ACTIONS(1757),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1759),
    [anon_sym_SEMI_SEMI] = ACTIONS(1761),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1761),
    [anon_sym_AMP] = ACTIONS(1757),
  },
  [453] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1757),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1759),
    [anon_sym_SEMI_SEMI] = ACTIONS(1761),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1761),
    [anon_sym_AMP] = ACTIONS(1757),
  },
  [454] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(895),
    [sym_c_style_for_statement] = STATE(895),
    [sym_while_statement] = STATE(895),
    [sym_if_statement] = STATE(895),
    [sym_case_statement] = STATE(895),
    [sym_function_definition] = STATE(895),
    [sym_subshell] = STATE(895),
    [sym_pipeline] = STATE(895),
    [sym_list] = STATE(895),
    [sym_negated_command] = STATE(895),
    [sym_test_command] = STATE(895),
    [sym_declaration_command] = STATE(895),
    [sym_unset_command] = STATE(895),
    [sym_command] = STATE(895),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(896),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [455] = {
    [sym__simple_heredoc_body] = ACTIONS(1763),
    [sym__heredoc_body_beginning] = ACTIONS(1763),
    [sym_file_descriptor] = ACTIONS(1763),
    [sym__concat] = ACTIONS(1763),
    [ts_builtin_sym_end] = ACTIONS(1763),
    [anon_sym_SEMI] = ACTIONS(1765),
    [anon_sym_PIPE] = ACTIONS(1765),
    [anon_sym_RPAREN] = ACTIONS(1763),
    [anon_sym_SEMI_SEMI] = ACTIONS(1763),
    [anon_sym_PIPE_AMP] = ACTIONS(1763),
    [anon_sym_AMP_AMP] = ACTIONS(1763),
    [anon_sym_PIPE_PIPE] = ACTIONS(1763),
    [anon_sym_EQ_TILDE] = ACTIONS(1765),
    [anon_sym_EQ_EQ] = ACTIONS(1765),
    [anon_sym_LT] = ACTIONS(1765),
    [anon_sym_GT] = ACTIONS(1765),
    [anon_sym_GT_GT] = ACTIONS(1763),
    [anon_sym_AMP_GT] = ACTIONS(1765),
    [anon_sym_AMP_GT_GT] = ACTIONS(1763),
    [anon_sym_LT_AMP] = ACTIONS(1763),
    [anon_sym_GT_AMP] = ACTIONS(1763),
    [anon_sym_LT_LT] = ACTIONS(1765),
    [anon_sym_LT_LT_DASH] = ACTIONS(1763),
    [anon_sym_LT_LT_LT] = ACTIONS(1763),
    [sym__special_characters] = ACTIONS(1763),
    [anon_sym_DQUOTE] = ACTIONS(1763),
    [anon_sym_DOLLAR] = ACTIONS(1765),
    [sym_raw_string] = ACTIONS(1763),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1763),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1763),
    [anon_sym_BQUOTE] = ACTIONS(1763),
    [anon_sym_LT_LPAREN] = ACTIONS(1763),
    [anon_sym_GT_LPAREN] = ACTIONS(1763),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1765),
    [anon_sym_LF] = ACTIONS(1763),
    [anon_sym_AMP] = ACTIONS(1765),
  },
  [456] = {
    [aux_sym_concatenation_repeat1] = STATE(456),
    [sym__simple_heredoc_body] = ACTIONS(1763),
    [sym__heredoc_body_beginning] = ACTIONS(1763),
    [sym_file_descriptor] = ACTIONS(1763),
    [sym__concat] = ACTIONS(1767),
    [ts_builtin_sym_end] = ACTIONS(1763),
    [anon_sym_SEMI] = ACTIONS(1765),
    [anon_sym_PIPE] = ACTIONS(1765),
    [anon_sym_SEMI_SEMI] = ACTIONS(1763),
    [anon_sym_PIPE_AMP] = ACTIONS(1763),
    [anon_sym_AMP_AMP] = ACTIONS(1763),
    [anon_sym_PIPE_PIPE] = ACTIONS(1763),
    [anon_sym_EQ_TILDE] = ACTIONS(1765),
    [anon_sym_EQ_EQ] = ACTIONS(1765),
    [anon_sym_LT] = ACTIONS(1765),
    [anon_sym_GT] = ACTIONS(1765),
    [anon_sym_GT_GT] = ACTIONS(1763),
    [anon_sym_AMP_GT] = ACTIONS(1765),
    [anon_sym_AMP_GT_GT] = ACTIONS(1763),
    [anon_sym_LT_AMP] = ACTIONS(1763),
    [anon_sym_GT_AMP] = ACTIONS(1763),
    [anon_sym_LT_LT] = ACTIONS(1765),
    [anon_sym_LT_LT_DASH] = ACTIONS(1763),
    [anon_sym_LT_LT_LT] = ACTIONS(1763),
    [sym__special_characters] = ACTIONS(1763),
    [anon_sym_DQUOTE] = ACTIONS(1763),
    [anon_sym_DOLLAR] = ACTIONS(1765),
    [sym_raw_string] = ACTIONS(1763),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1763),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1763),
    [anon_sym_BQUOTE] = ACTIONS(1763),
    [anon_sym_LT_LPAREN] = ACTIONS(1763),
    [anon_sym_GT_LPAREN] = ACTIONS(1763),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1765),
    [anon_sym_LF] = ACTIONS(1763),
    [anon_sym_AMP] = ACTIONS(1765),
  },
  [457] = {
    [sym__concat] = ACTIONS(845),
    [anon_sym_DQUOTE] = ACTIONS(847),
    [anon_sym_DOLLAR] = ACTIONS(847),
    [sym__string_content] = ACTIONS(845),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(847),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(847),
    [anon_sym_BQUOTE] = ACTIONS(847),
    [sym_comment] = ACTIONS(281),
  },
  [458] = {
    [sym__simple_heredoc_body] = ACTIONS(1770),
    [sym__heredoc_body_beginning] = ACTIONS(1770),
    [sym_file_descriptor] = ACTIONS(1770),
    [sym__concat] = ACTIONS(1770),
    [ts_builtin_sym_end] = ACTIONS(1770),
    [anon_sym_SEMI] = ACTIONS(1772),
    [anon_sym_PIPE] = ACTIONS(1772),
    [anon_sym_RPAREN] = ACTIONS(1770),
    [anon_sym_SEMI_SEMI] = ACTIONS(1770),
    [anon_sym_PIPE_AMP] = ACTIONS(1770),
    [anon_sym_AMP_AMP] = ACTIONS(1770),
    [anon_sym_PIPE_PIPE] = ACTIONS(1770),
    [anon_sym_EQ_TILDE] = ACTIONS(1772),
    [anon_sym_EQ_EQ] = ACTIONS(1772),
    [anon_sym_LT] = ACTIONS(1772),
    [anon_sym_GT] = ACTIONS(1772),
    [anon_sym_GT_GT] = ACTIONS(1770),
    [anon_sym_AMP_GT] = ACTIONS(1772),
    [anon_sym_AMP_GT_GT] = ACTIONS(1770),
    [anon_sym_LT_AMP] = ACTIONS(1770),
    [anon_sym_GT_AMP] = ACTIONS(1770),
    [anon_sym_LT_LT] = ACTIONS(1772),
    [anon_sym_LT_LT_DASH] = ACTIONS(1770),
    [anon_sym_LT_LT_LT] = ACTIONS(1770),
    [sym__special_characters] = ACTIONS(1770),
    [anon_sym_DQUOTE] = ACTIONS(1770),
    [anon_sym_DOLLAR] = ACTIONS(1772),
    [sym_raw_string] = ACTIONS(1770),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1770),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1770),
    [anon_sym_BQUOTE] = ACTIONS(1770),
    [anon_sym_LT_LPAREN] = ACTIONS(1770),
    [anon_sym_GT_LPAREN] = ACTIONS(1770),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1772),
    [anon_sym_LF] = ACTIONS(1770),
    [anon_sym_AMP] = ACTIONS(1772),
  },
  [459] = {
    [sym__concat] = ACTIONS(1774),
    [anon_sym_DQUOTE] = ACTIONS(1776),
    [anon_sym_DOLLAR] = ACTIONS(1776),
    [sym__string_content] = ACTIONS(1778),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1776),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1776),
    [anon_sym_BQUOTE] = ACTIONS(1776),
    [sym_comment] = ACTIONS(281),
  },
  [460] = {
    [sym__concat] = ACTIONS(853),
    [anon_sym_DQUOTE] = ACTIONS(855),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [sym__string_content] = ACTIONS(853),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(855),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(855),
    [anon_sym_BQUOTE] = ACTIONS(855),
    [sym_comment] = ACTIONS(281),
  },
  [461] = {
    [anon_sym_DQUOTE] = ACTIONS(1776),
    [anon_sym_DOLLAR] = ACTIONS(1776),
    [sym__string_content] = ACTIONS(1778),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1776),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1776),
    [anon_sym_BQUOTE] = ACTIONS(1776),
    [sym_comment] = ACTIONS(281),
  },
  [462] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1780),
    [sym_comment] = ACTIONS(55),
  },
  [463] = {
    [sym_subscript] = STATE(901),
    [sym_variable_name] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(1784),
    [anon_sym_DOLLAR] = ACTIONS(1784),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1786),
    [anon_sym_STAR] = ACTIONS(1788),
    [anon_sym_AT] = ACTIONS(1788),
    [anon_sym_QMARK] = ACTIONS(1788),
    [anon_sym_0] = ACTIONS(1786),
    [anon_sym__] = ACTIONS(1786),
  },
  [464] = {
    [sym_concatenation] = STATE(904),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(904),
    [anon_sym_RBRACE] = ACTIONS(1790),
    [anon_sym_EQ] = ACTIONS(1792),
    [anon_sym_DASH] = ACTIONS(1792),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1794),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1796),
    [anon_sym_COLON] = ACTIONS(1792),
    [anon_sym_COLON_QMARK] = ACTIONS(1792),
    [anon_sym_COLON_DASH] = ACTIONS(1792),
    [anon_sym_PERCENT] = ACTIONS(1792),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [465] = {
    [sym_concatenation] = STATE(907),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(907),
    [anon_sym_RBRACE] = ACTIONS(1798),
    [anon_sym_EQ] = ACTIONS(1800),
    [anon_sym_DASH] = ACTIONS(1800),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1802),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1804),
    [anon_sym_COLON] = ACTIONS(1800),
    [anon_sym_COLON_QMARK] = ACTIONS(1800),
    [anon_sym_COLON_DASH] = ACTIONS(1800),
    [anon_sym_PERCENT] = ACTIONS(1800),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [466] = {
    [anon_sym_SEMI] = ACTIONS(1806),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1808),
    [anon_sym_SEMI_SEMI] = ACTIONS(1810),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1810),
    [anon_sym_AMP] = ACTIONS(1806),
  },
  [467] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1806),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1808),
    [anon_sym_SEMI_SEMI] = ACTIONS(1810),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1810),
    [anon_sym_AMP] = ACTIONS(1806),
  },
  [468] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(910),
    [sym_c_style_for_statement] = STATE(910),
    [sym_while_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_case_statement] = STATE(910),
    [sym_function_definition] = STATE(910),
    [sym_subshell] = STATE(910),
    [sym_pipeline] = STATE(910),
    [sym_list] = STATE(910),
    [sym_negated_command] = STATE(910),
    [sym_test_command] = STATE(910),
    [sym_declaration_command] = STATE(910),
    [sym_unset_command] = STATE(910),
    [sym_command] = STATE(910),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(911),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [469] = {
    [anon_sym_SEMI] = ACTIONS(1812),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1814),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1808),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1814),
    [anon_sym_AMP] = ACTIONS(1812),
  },
  [470] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1812),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1814),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1808),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1814),
    [anon_sym_AMP] = ACTIONS(1812),
  },
  [471] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(913),
    [sym_c_style_for_statement] = STATE(913),
    [sym_while_statement] = STATE(913),
    [sym_if_statement] = STATE(913),
    [sym_case_statement] = STATE(913),
    [sym_function_definition] = STATE(913),
    [sym_subshell] = STATE(913),
    [sym_pipeline] = STATE(913),
    [sym_list] = STATE(913),
    [sym_negated_command] = STATE(913),
    [sym_test_command] = STATE(913),
    [sym_declaration_command] = STATE(913),
    [sym_unset_command] = STATE(913),
    [sym_command] = STATE(913),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(914),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [472] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(1816),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [473] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(1776),
    [anon_sym_DOLLAR] = ACTIONS(1818),
    [sym__string_content] = ACTIONS(1821),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1824),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1827),
    [anon_sym_BQUOTE] = ACTIONS(1830),
    [sym_comment] = ACTIONS(281),
  },
  [474] = {
    [sym_concatenation] = STATE(919),
    [sym_string] = STATE(918),
    [sym_simple_expansion] = STATE(918),
    [sym_string_expansion] = STATE(918),
    [sym_expansion] = STATE(918),
    [sym_command_substitution] = STATE(918),
    [sym_process_substitution] = STATE(918),
    [sym__special_characters] = ACTIONS(1833),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(1835),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1835),
  },
  [475] = {
    [sym_concatenation] = STATE(929),
    [sym_string] = STATE(924),
    [sym_simple_expansion] = STATE(924),
    [sym_string_expansion] = STATE(924),
    [sym_expansion] = STATE(924),
    [sym_command_substitution] = STATE(924),
    [sym_process_substitution] = STATE(924),
    [anon_sym_RBRACE] = ACTIONS(1837),
    [sym__special_characters] = ACTIONS(1839),
    [anon_sym_DQUOTE] = ACTIONS(1841),
    [anon_sym_DOLLAR] = ACTIONS(1843),
    [sym_raw_string] = ACTIONS(1845),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1847),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1849),
    [anon_sym_BQUOTE] = ACTIONS(1851),
    [anon_sym_LT_LPAREN] = ACTIONS(1853),
    [anon_sym_GT_LPAREN] = ACTIONS(1853),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1845),
  },
  [476] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(1855),
    [sym_comment] = ACTIONS(55),
  },
  [477] = {
    [sym_concatenation] = STATE(933),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(933),
    [anon_sym_RBRACE] = ACTIONS(1857),
    [anon_sym_EQ] = ACTIONS(1859),
    [anon_sym_DASH] = ACTIONS(1859),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1861),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1863),
    [anon_sym_COLON] = ACTIONS(1859),
    [anon_sym_COLON_QMARK] = ACTIONS(1859),
    [anon_sym_COLON_DASH] = ACTIONS(1859),
    [anon_sym_PERCENT] = ACTIONS(1859),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [478] = {
    [sym_concatenation] = STATE(935),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(935),
    [anon_sym_RBRACE] = ACTIONS(1837),
    [anon_sym_EQ] = ACTIONS(1865),
    [anon_sym_DASH] = ACTIONS(1865),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1867),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(1869),
    [anon_sym_COLON] = ACTIONS(1865),
    [anon_sym_COLON_QMARK] = ACTIONS(1865),
    [anon_sym_COLON_DASH] = ACTIONS(1865),
    [anon_sym_PERCENT] = ACTIONS(1865),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [479] = {
    [sym__simple_heredoc_body] = ACTIONS(1871),
    [sym__heredoc_body_beginning] = ACTIONS(1871),
    [sym_file_descriptor] = ACTIONS(1871),
    [sym__concat] = ACTIONS(1871),
    [ts_builtin_sym_end] = ACTIONS(1871),
    [anon_sym_SEMI] = ACTIONS(1873),
    [anon_sym_PIPE] = ACTIONS(1873),
    [anon_sym_RPAREN] = ACTIONS(1871),
    [anon_sym_SEMI_SEMI] = ACTIONS(1871),
    [anon_sym_PIPE_AMP] = ACTIONS(1871),
    [anon_sym_AMP_AMP] = ACTIONS(1871),
    [anon_sym_PIPE_PIPE] = ACTIONS(1871),
    [anon_sym_EQ_TILDE] = ACTIONS(1873),
    [anon_sym_EQ_EQ] = ACTIONS(1873),
    [anon_sym_LT] = ACTIONS(1873),
    [anon_sym_GT] = ACTIONS(1873),
    [anon_sym_GT_GT] = ACTIONS(1871),
    [anon_sym_AMP_GT] = ACTIONS(1873),
    [anon_sym_AMP_GT_GT] = ACTIONS(1871),
    [anon_sym_LT_AMP] = ACTIONS(1871),
    [anon_sym_GT_AMP] = ACTIONS(1871),
    [anon_sym_LT_LT] = ACTIONS(1873),
    [anon_sym_LT_LT_DASH] = ACTIONS(1871),
    [anon_sym_LT_LT_LT] = ACTIONS(1871),
    [sym__special_characters] = ACTIONS(1871),
    [anon_sym_DQUOTE] = ACTIONS(1871),
    [anon_sym_DOLLAR] = ACTIONS(1873),
    [sym_raw_string] = ACTIONS(1871),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1871),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1871),
    [anon_sym_BQUOTE] = ACTIONS(1871),
    [anon_sym_LT_LPAREN] = ACTIONS(1871),
    [anon_sym_GT_LPAREN] = ACTIONS(1871),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1873),
    [anon_sym_LF] = ACTIONS(1871),
    [anon_sym_AMP] = ACTIONS(1873),
  },
  [480] = {
    [aux_sym_concatenation_repeat1] = STATE(937),
    [sym__concat] = ACTIONS(1875),
    [anon_sym_RBRACE] = ACTIONS(1877),
    [anon_sym_EQ] = ACTIONS(1879),
    [anon_sym_DASH] = ACTIONS(1879),
    [sym__special_characters] = ACTIONS(1879),
    [anon_sym_DQUOTE] = ACTIONS(1877),
    [anon_sym_DOLLAR] = ACTIONS(1879),
    [sym_raw_string] = ACTIONS(1877),
    [anon_sym_POUND] = ACTIONS(1877),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1877),
    [anon_sym_COLON] = ACTIONS(1879),
    [anon_sym_COLON_QMARK] = ACTIONS(1879),
    [anon_sym_COLON_DASH] = ACTIONS(1879),
    [anon_sym_PERCENT] = ACTIONS(1879),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1877),
    [anon_sym_BQUOTE] = ACTIONS(1877),
    [anon_sym_LT_LPAREN] = ACTIONS(1877),
    [anon_sym_GT_LPAREN] = ACTIONS(1877),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(1879),
  },
  [481] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(940),
    [anon_sym_DQUOTE] = ACTIONS(1881),
    [anon_sym_DOLLAR] = ACTIONS(1883),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [482] = {
    [sym_string] = STATE(942),
    [anon_sym_DASH] = ACTIONS(1885),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(1885),
    [sym_raw_string] = ACTIONS(1887),
    [anon_sym_POUND] = ACTIONS(1885),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1889),
    [anon_sym_STAR] = ACTIONS(1891),
    [anon_sym_AT] = ACTIONS(1891),
    [anon_sym_QMARK] = ACTIONS(1891),
    [anon_sym_0] = ACTIONS(1889),
    [anon_sym__] = ACTIONS(1889),
  },
  [483] = {
    [aux_sym_concatenation_repeat1] = STATE(937),
    [sym__concat] = ACTIONS(1875),
    [anon_sym_RBRACE] = ACTIONS(1893),
    [anon_sym_EQ] = ACTIONS(1895),
    [anon_sym_DASH] = ACTIONS(1895),
    [sym__special_characters] = ACTIONS(1895),
    [anon_sym_DQUOTE] = ACTIONS(1893),
    [anon_sym_DOLLAR] = ACTIONS(1895),
    [sym_raw_string] = ACTIONS(1893),
    [anon_sym_POUND] = ACTIONS(1893),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1893),
    [anon_sym_COLON] = ACTIONS(1895),
    [anon_sym_COLON_QMARK] = ACTIONS(1895),
    [anon_sym_COLON_DASH] = ACTIONS(1895),
    [anon_sym_PERCENT] = ACTIONS(1895),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1893),
    [anon_sym_BQUOTE] = ACTIONS(1893),
    [anon_sym_LT_LPAREN] = ACTIONS(1893),
    [anon_sym_GT_LPAREN] = ACTIONS(1893),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(1895),
  },
  [484] = {
    [sym_subscript] = STATE(947),
    [sym_variable_name] = ACTIONS(1897),
    [anon_sym_BANG] = ACTIONS(1899),
    [anon_sym_DASH] = ACTIONS(1901),
    [anon_sym_DOLLAR] = ACTIONS(1901),
    [anon_sym_POUND] = ACTIONS(1899),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1903),
    [anon_sym_STAR] = ACTIONS(1905),
    [anon_sym_AT] = ACTIONS(1905),
    [anon_sym_QMARK] = ACTIONS(1905),
    [anon_sym_0] = ACTIONS(1903),
    [anon_sym__] = ACTIONS(1903),
  },
  [485] = {
    [sym_concatenation] = STATE(950),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(950),
    [sym_regex] = ACTIONS(1907),
    [anon_sym_RBRACE] = ACTIONS(1909),
    [anon_sym_EQ] = ACTIONS(1911),
    [anon_sym_DASH] = ACTIONS(1911),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1913),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(1911),
    [anon_sym_COLON_QMARK] = ACTIONS(1911),
    [anon_sym_COLON_DASH] = ACTIONS(1911),
    [anon_sym_PERCENT] = ACTIONS(1911),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [486] = {
    [sym__terminated_statement] = STATE(953),
    [sym_for_statement] = STATE(951),
    [sym_c_style_for_statement] = STATE(951),
    [sym_while_statement] = STATE(951),
    [sym_if_statement] = STATE(951),
    [sym_case_statement] = STATE(951),
    [sym_function_definition] = STATE(951),
    [sym_subshell] = STATE(951),
    [sym_pipeline] = STATE(951),
    [sym_list] = STATE(951),
    [sym_negated_command] = STATE(951),
    [sym_test_command] = STATE(951),
    [sym_declaration_command] = STATE(951),
    [sym_unset_command] = STATE(951),
    [sym_command] = STATE(951),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(952),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(953),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [487] = {
    [sym__terminated_statement] = STATE(956),
    [sym_for_statement] = STATE(954),
    [sym_c_style_for_statement] = STATE(954),
    [sym_while_statement] = STATE(954),
    [sym_if_statement] = STATE(954),
    [sym_case_statement] = STATE(954),
    [sym_function_definition] = STATE(954),
    [sym_subshell] = STATE(954),
    [sym_pipeline] = STATE(954),
    [sym_list] = STATE(954),
    [sym_negated_command] = STATE(954),
    [sym_test_command] = STATE(954),
    [sym_declaration_command] = STATE(954),
    [sym_unset_command] = STATE(954),
    [sym_command] = STATE(954),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(955),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(956),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [488] = {
    [sym__terminated_statement] = STATE(959),
    [sym_for_statement] = STATE(957),
    [sym_c_style_for_statement] = STATE(957),
    [sym_while_statement] = STATE(957),
    [sym_if_statement] = STATE(957),
    [sym_case_statement] = STATE(957),
    [sym_function_definition] = STATE(957),
    [sym_subshell] = STATE(957),
    [sym_pipeline] = STATE(957),
    [sym_list] = STATE(957),
    [sym_negated_command] = STATE(957),
    [sym_test_command] = STATE(957),
    [sym_declaration_command] = STATE(957),
    [sym_unset_command] = STATE(957),
    [sym_command] = STATE(957),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(958),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(959),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [489] = {
    [sym_concatenation] = STATE(960),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(960),
    [anon_sym_RBRACE] = ACTIONS(1909),
    [anon_sym_EQ] = ACTIONS(1915),
    [anon_sym_DASH] = ACTIONS(1915),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1917),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(1915),
    [anon_sym_COLON_QMARK] = ACTIONS(1915),
    [anon_sym_COLON_DASH] = ACTIONS(1915),
    [anon_sym_PERCENT] = ACTIONS(1915),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [490] = {
    [sym__simple_heredoc_body] = ACTIONS(1919),
    [sym__heredoc_body_beginning] = ACTIONS(1919),
    [sym_file_descriptor] = ACTIONS(1919),
    [sym__concat] = ACTIONS(1919),
    [ts_builtin_sym_end] = ACTIONS(1919),
    [anon_sym_SEMI] = ACTIONS(1921),
    [anon_sym_PIPE] = ACTIONS(1921),
    [anon_sym_RPAREN] = ACTIONS(1919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1919),
    [anon_sym_PIPE_AMP] = ACTIONS(1919),
    [anon_sym_AMP_AMP] = ACTIONS(1919),
    [anon_sym_PIPE_PIPE] = ACTIONS(1919),
    [anon_sym_EQ_TILDE] = ACTIONS(1921),
    [anon_sym_EQ_EQ] = ACTIONS(1921),
    [anon_sym_LT] = ACTIONS(1921),
    [anon_sym_GT] = ACTIONS(1921),
    [anon_sym_GT_GT] = ACTIONS(1919),
    [anon_sym_AMP_GT] = ACTIONS(1921),
    [anon_sym_AMP_GT_GT] = ACTIONS(1919),
    [anon_sym_LT_AMP] = ACTIONS(1919),
    [anon_sym_GT_AMP] = ACTIONS(1919),
    [anon_sym_LT_LT] = ACTIONS(1921),
    [anon_sym_LT_LT_DASH] = ACTIONS(1919),
    [anon_sym_LT_LT_LT] = ACTIONS(1919),
    [sym__special_characters] = ACTIONS(1919),
    [anon_sym_DQUOTE] = ACTIONS(1919),
    [anon_sym_DOLLAR] = ACTIONS(1921),
    [sym_raw_string] = ACTIONS(1919),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1919),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1919),
    [anon_sym_BQUOTE] = ACTIONS(1919),
    [anon_sym_LT_LPAREN] = ACTIONS(1919),
    [anon_sym_GT_LPAREN] = ACTIONS(1919),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1921),
    [anon_sym_LF] = ACTIONS(1919),
    [anon_sym_AMP] = ACTIONS(1921),
  },
  [491] = {
    [sym_concatenation] = STATE(935),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(935),
    [sym_regex] = ACTIONS(1923),
    [anon_sym_RBRACE] = ACTIONS(1837),
    [anon_sym_EQ] = ACTIONS(1865),
    [anon_sym_DASH] = ACTIONS(1865),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1867),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(1865),
    [anon_sym_COLON_QMARK] = ACTIONS(1865),
    [anon_sym_COLON_DASH] = ACTIONS(1865),
    [anon_sym_PERCENT] = ACTIONS(1865),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [492] = {
    [sym_concatenation] = STATE(960),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(960),
    [anon_sym_RBRACE] = ACTIONS(1837),
    [anon_sym_EQ] = ACTIONS(1915),
    [anon_sym_DASH] = ACTIONS(1915),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1917),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(1915),
    [anon_sym_COLON_QMARK] = ACTIONS(1915),
    [anon_sym_COLON_DASH] = ACTIONS(1915),
    [anon_sym_PERCENT] = ACTIONS(1915),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [493] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_RPAREN] = ACTIONS(1925),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [494] = {
    [sym__simple_heredoc_body] = ACTIONS(1927),
    [sym__heredoc_body_beginning] = ACTIONS(1927),
    [sym_file_descriptor] = ACTIONS(1927),
    [sym__concat] = ACTIONS(1927),
    [ts_builtin_sym_end] = ACTIONS(1927),
    [anon_sym_SEMI] = ACTIONS(1929),
    [anon_sym_PIPE] = ACTIONS(1929),
    [anon_sym_RPAREN] = ACTIONS(1927),
    [anon_sym_SEMI_SEMI] = ACTIONS(1927),
    [anon_sym_PIPE_AMP] = ACTIONS(1927),
    [anon_sym_AMP_AMP] = ACTIONS(1927),
    [anon_sym_PIPE_PIPE] = ACTIONS(1927),
    [anon_sym_EQ_TILDE] = ACTIONS(1929),
    [anon_sym_EQ_EQ] = ACTIONS(1929),
    [anon_sym_LT] = ACTIONS(1929),
    [anon_sym_GT] = ACTIONS(1929),
    [anon_sym_GT_GT] = ACTIONS(1927),
    [anon_sym_AMP_GT] = ACTIONS(1929),
    [anon_sym_AMP_GT_GT] = ACTIONS(1927),
    [anon_sym_LT_AMP] = ACTIONS(1927),
    [anon_sym_GT_AMP] = ACTIONS(1927),
    [anon_sym_LT_LT] = ACTIONS(1929),
    [anon_sym_LT_LT_DASH] = ACTIONS(1927),
    [anon_sym_LT_LT_LT] = ACTIONS(1927),
    [sym__special_characters] = ACTIONS(1927),
    [anon_sym_DQUOTE] = ACTIONS(1927),
    [anon_sym_DOLLAR] = ACTIONS(1929),
    [sym_raw_string] = ACTIONS(1927),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1927),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1927),
    [anon_sym_BQUOTE] = ACTIONS(1927),
    [anon_sym_LT_LPAREN] = ACTIONS(1927),
    [anon_sym_GT_LPAREN] = ACTIONS(1927),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1929),
    [anon_sym_LF] = ACTIONS(1927),
    [anon_sym_AMP] = ACTIONS(1929),
  },
  [495] = {
    [anon_sym_SEMI] = ACTIONS(1931),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1925),
    [anon_sym_SEMI_SEMI] = ACTIONS(1933),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1933),
    [anon_sym_AMP] = ACTIONS(1931),
  },
  [496] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1931),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1925),
    [anon_sym_SEMI_SEMI] = ACTIONS(1933),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1933),
    [anon_sym_AMP] = ACTIONS(1931),
  },
  [497] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1935),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_EQ_TILDE] = ACTIONS(495),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_DASH_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(493),
  },
  [498] = {
    [sym_do_group] = STATE(965),
    [anon_sym_do] = ACTIONS(525),
    [sym_comment] = ACTIONS(55),
  },
  [499] = {
    [sym_compound_statement] = STATE(967),
    [anon_sym_LPAREN] = ACTIONS(1937),
    [anon_sym_LBRACE] = ACTIONS(595),
    [sym_comment] = ACTIONS(55),
  },
  [500] = {
    [anon_sym_AMP_AMP] = ACTIONS(681),
    [anon_sym_PIPE_PIPE] = ACTIONS(681),
    [anon_sym_RBRACK] = ACTIONS(1935),
    [anon_sym_EQ_TILDE] = ACTIONS(683),
    [anon_sym_EQ_EQ] = ACTIONS(683),
    [anon_sym_EQ] = ACTIONS(685),
    [anon_sym_PLUS_EQ] = ACTIONS(681),
    [anon_sym_LT] = ACTIONS(685),
    [anon_sym_GT] = ACTIONS(685),
    [anon_sym_BANG_EQ] = ACTIONS(681),
    [anon_sym_PLUS] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(685),
    [anon_sym_DASH_EQ] = ACTIONS(681),
    [anon_sym_LT_EQ] = ACTIONS(681),
    [anon_sym_GT_EQ] = ACTIONS(681),
    [anon_sym_PLUS_PLUS] = ACTIONS(687),
    [anon_sym_DASH_DASH] = ACTIONS(687),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(681),
  },
  [501] = {
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1935),
    [anon_sym_EQ_TILDE] = ACTIONS(691),
    [anon_sym_EQ_EQ] = ACTIONS(691),
    [anon_sym_EQ] = ACTIONS(693),
    [anon_sym_PLUS_EQ] = ACTIONS(689),
    [anon_sym_LT] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(693),
    [anon_sym_BANG_EQ] = ACTIONS(689),
    [anon_sym_PLUS] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(693),
    [anon_sym_DASH_EQ] = ACTIONS(689),
    [anon_sym_LT_EQ] = ACTIONS(689),
    [anon_sym_GT_EQ] = ACTIONS(689),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(689),
  },
  [502] = {
    [sym_variable_assignment] = STATE(692),
    [sym_subscript] = STATE(277),
    [sym_concatenation] = STATE(692),
    [sym_string] = STATE(276),
    [sym_simple_expansion] = STATE(276),
    [sym_string_expansion] = STATE(276),
    [sym_expansion] = STATE(276),
    [sym_command_substitution] = STATE(276),
    [sym_process_substitution] = STATE(276),
    [aux_sym_declaration_command_repeat1] = STATE(692),
    [sym_variable_name] = ACTIONS(505),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(731),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym_raw_string] = ACTIONS(509),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(729),
    [anon_sym_LT_LPAREN] = ACTIONS(217),
    [anon_sym_GT_LPAREN] = ACTIONS(217),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1330),
    [sym_word] = ACTIONS(513),
    [anon_sym_LF] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(731),
  },
  [503] = {
    [sym_concatenation] = STATE(694),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym_unset_command_repeat1] = STATE(694),
    [anon_sym_SEMI] = ACTIONS(769),
    [anon_sym_PIPE] = ACTIONS(769),
    [anon_sym_SEMI_SEMI] = ACTIONS(767),
    [anon_sym_PIPE_AMP] = ACTIONS(767),
    [anon_sym_AMP_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(767),
    [sym__special_characters] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [sym_raw_string] = ACTIONS(517),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(235),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(767),
    [anon_sym_LT_LPAREN] = ACTIONS(241),
    [anon_sym_GT_LPAREN] = ACTIONS(241),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1332),
    [sym_word] = ACTIONS(521),
    [anon_sym_LF] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(769),
  },
  [504] = {
    [anon_sym_RPAREN] = ACTIONS(1939),
    [sym_comment] = ACTIONS(55),
  },
  [505] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(1925),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [506] = {
    [sym_for_statement] = STATE(521),
    [sym_c_style_for_statement] = STATE(521),
    [sym_while_statement] = STATE(521),
    [sym_if_statement] = STATE(521),
    [sym_case_statement] = STATE(521),
    [sym_function_definition] = STATE(521),
    [sym_subshell] = STATE(521),
    [sym_pipeline] = STATE(521),
    [sym_list] = STATE(521),
    [sym_negated_command] = STATE(521),
    [sym_test_command] = STATE(521),
    [sym_declaration_command] = STATE(521),
    [sym_unset_command] = STATE(521),
    [sym_command] = STATE(521),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(969),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [507] = {
    [sym_for_statement] = STATE(970),
    [sym_c_style_for_statement] = STATE(970),
    [sym_while_statement] = STATE(970),
    [sym_if_statement] = STATE(970),
    [sym_case_statement] = STATE(970),
    [sym_function_definition] = STATE(970),
    [sym_subshell] = STATE(970),
    [sym_pipeline] = STATE(970),
    [sym_list] = STATE(970),
    [sym_negated_command] = STATE(970),
    [sym_test_command] = STATE(970),
    [sym_declaration_command] = STATE(970),
    [sym_unset_command] = STATE(970),
    [sym_command] = STATE(970),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(971),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [508] = {
    [anon_sym_LT] = ACTIONS(1941),
    [anon_sym_GT] = ACTIONS(1941),
    [anon_sym_GT_GT] = ACTIONS(1943),
    [anon_sym_AMP_GT] = ACTIONS(1941),
    [anon_sym_AMP_GT_GT] = ACTIONS(1943),
    [anon_sym_LT_AMP] = ACTIONS(1943),
    [anon_sym_GT_AMP] = ACTIONS(1943),
    [sym_comment] = ACTIONS(55),
  },
  [509] = {
    [sym_concatenation] = STATE(535),
    [sym_string] = STATE(974),
    [sym_simple_expansion] = STATE(974),
    [sym_string_expansion] = STATE(974),
    [sym_expansion] = STATE(974),
    [sym_command_substitution] = STATE(974),
    [sym_process_substitution] = STATE(974),
    [sym__special_characters] = ACTIONS(1945),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1947),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1947),
  },
  [510] = {
    [sym_concatenation] = STATE(539),
    [sym_string] = STATE(976),
    [sym_simple_expansion] = STATE(976),
    [sym_string_expansion] = STATE(976),
    [sym_expansion] = STATE(976),
    [sym_command_substitution] = STATE(976),
    [sym_process_substitution] = STATE(976),
    [sym__special_characters] = ACTIONS(1949),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(1951),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1951),
  },
  [511] = {
    [sym_file_redirect] = STATE(977),
    [sym_heredoc_redirect] = STATE(977),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(977),
    [aux_sym_while_statement_repeat1] = STATE(977),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(927),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(929),
    [anon_sym_GT] = ACTIONS(929),
    [anon_sym_GT_GT] = ACTIONS(931),
    [anon_sym_AMP_GT] = ACTIONS(929),
    [anon_sym_AMP_GT_GT] = ACTIONS(931),
    [anon_sym_LT_AMP] = ACTIONS(931),
    [anon_sym_GT_AMP] = ACTIONS(931),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(933),
    [anon_sym_BQUOTE] = ACTIONS(989),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [512] = {
    [sym_file_redirect] = STATE(978),
    [sym_heredoc_redirect] = STATE(978),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(978),
    [sym_concatenation] = STATE(712),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym_while_statement_repeat1] = STATE(978),
    [aux_sym_command_repeat2] = STATE(712),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(927),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(929),
    [anon_sym_GT] = ACTIONS(929),
    [anon_sym_GT_GT] = ACTIONS(931),
    [anon_sym_AMP_GT] = ACTIONS(929),
    [anon_sym_AMP_GT_GT] = ACTIONS(931),
    [anon_sym_LT_AMP] = ACTIONS(931),
    [anon_sym_GT_AMP] = ACTIONS(931),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(933),
    [sym__special_characters] = ACTIONS(547),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(549),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(989),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(551),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [513] = {
    [anon_sym_SEMI] = ACTIONS(1953),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1955),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(1925),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1955),
    [anon_sym_AMP] = ACTIONS(1953),
  },
  [514] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1953),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(1955),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(1925),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1955),
    [anon_sym_AMP] = ACTIONS(1953),
  },
  [515] = {
    [sym_file_redirect] = STATE(978),
    [sym_heredoc_redirect] = STATE(978),
    [sym_heredoc_body] = STATE(540),
    [sym_herestring_redirect] = STATE(978),
    [sym_concatenation] = STATE(980),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym_while_statement_repeat1] = STATE(978),
    [aux_sym_command_repeat2] = STATE(980),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(927),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym_PIPE] = ACTIONS(991),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(929),
    [anon_sym_GT] = ACTIONS(929),
    [anon_sym_GT_GT] = ACTIONS(931),
    [anon_sym_AMP_GT] = ACTIONS(929),
    [anon_sym_AMP_GT_GT] = ACTIONS(931),
    [anon_sym_LT_AMP] = ACTIONS(931),
    [anon_sym_GT_AMP] = ACTIONS(931),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(933),
    [sym__special_characters] = ACTIONS(547),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(549),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(989),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(551),
    [anon_sym_LF] = ACTIONS(989),
    [anon_sym_AMP] = ACTIONS(991),
  },
  [516] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_RPAREN] = ACTIONS(1957),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [517] = {
    [sym__simple_heredoc_body] = ACTIONS(1959),
    [sym__heredoc_body_beginning] = ACTIONS(1959),
    [sym_file_descriptor] = ACTIONS(1959),
    [sym__concat] = ACTIONS(1959),
    [ts_builtin_sym_end] = ACTIONS(1959),
    [anon_sym_SEMI] = ACTIONS(1961),
    [anon_sym_PIPE] = ACTIONS(1961),
    [anon_sym_RPAREN] = ACTIONS(1959),
    [anon_sym_SEMI_SEMI] = ACTIONS(1959),
    [anon_sym_PIPE_AMP] = ACTIONS(1959),
    [anon_sym_AMP_AMP] = ACTIONS(1959),
    [anon_sym_PIPE_PIPE] = ACTIONS(1959),
    [anon_sym_EQ_TILDE] = ACTIONS(1961),
    [anon_sym_EQ_EQ] = ACTIONS(1961),
    [anon_sym_LT] = ACTIONS(1961),
    [anon_sym_GT] = ACTIONS(1961),
    [anon_sym_GT_GT] = ACTIONS(1959),
    [anon_sym_AMP_GT] = ACTIONS(1961),
    [anon_sym_AMP_GT_GT] = ACTIONS(1959),
    [anon_sym_LT_AMP] = ACTIONS(1959),
    [anon_sym_GT_AMP] = ACTIONS(1959),
    [anon_sym_LT_LT] = ACTIONS(1961),
    [anon_sym_LT_LT_DASH] = ACTIONS(1959),
    [anon_sym_LT_LT_LT] = ACTIONS(1959),
    [sym__special_characters] = ACTIONS(1959),
    [anon_sym_DQUOTE] = ACTIONS(1959),
    [anon_sym_DOLLAR] = ACTIONS(1961),
    [sym_raw_string] = ACTIONS(1959),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1959),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1959),
    [anon_sym_BQUOTE] = ACTIONS(1959),
    [anon_sym_LT_LPAREN] = ACTIONS(1959),
    [anon_sym_GT_LPAREN] = ACTIONS(1959),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1961),
    [anon_sym_LF] = ACTIONS(1959),
    [anon_sym_AMP] = ACTIONS(1961),
  },
  [518] = {
    [anon_sym_SEMI] = ACTIONS(1963),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1957),
    [anon_sym_SEMI_SEMI] = ACTIONS(1965),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1965),
    [anon_sym_AMP] = ACTIONS(1963),
  },
  [519] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(1963),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(1957),
    [anon_sym_SEMI_SEMI] = ACTIONS(1965),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1965),
    [anon_sym_AMP] = ACTIONS(1963),
  },
  [520] = {
    [sym_compound_statement] = STATE(983),
    [anon_sym_LBRACE] = ACTIONS(595),
    [sym_comment] = ACTIONS(55),
  },
  [521] = {
    [ts_builtin_sym_end] = ACTIONS(1967),
    [anon_sym_SEMI] = ACTIONS(1969),
    [anon_sym_esac] = ACTIONS(1967),
    [anon_sym_PIPE] = ACTIONS(1969),
    [anon_sym_RPAREN] = ACTIONS(1967),
    [anon_sym_SEMI_SEMI] = ACTIONS(1967),
    [anon_sym_PIPE_AMP] = ACTIONS(1967),
    [anon_sym_AMP_AMP] = ACTIONS(1967),
    [anon_sym_PIPE_PIPE] = ACTIONS(1967),
    [anon_sym_BQUOTE] = ACTIONS(1967),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1967),
    [anon_sym_AMP] = ACTIONS(1969),
  },
  [522] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [ts_builtin_sym_end] = ACTIONS(1967),
    [anon_sym_SEMI] = ACTIONS(1969),
    [anon_sym_PIPE] = ACTIONS(1969),
    [anon_sym_RPAREN] = ACTIONS(1967),
    [anon_sym_SEMI_SEMI] = ACTIONS(1967),
    [anon_sym_PIPE_AMP] = ACTIONS(1967),
    [anon_sym_AMP_AMP] = ACTIONS(1967),
    [anon_sym_PIPE_PIPE] = ACTIONS(1967),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1967),
    [anon_sym_AMP] = ACTIONS(1969),
  },
  [523] = {
    [ts_builtin_sym_end] = ACTIONS(1971),
    [anon_sym_SEMI] = ACTIONS(1973),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_SEMI_SEMI] = ACTIONS(1971),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(1971),
    [anon_sym_PIPE_PIPE] = ACTIONS(1971),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1971),
    [anon_sym_AMP] = ACTIONS(1973),
  },
  [524] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [ts_builtin_sym_end] = ACTIONS(1971),
    [anon_sym_SEMI] = ACTIONS(1973),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_SEMI_SEMI] = ACTIONS(1971),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(1971),
    [anon_sym_PIPE_PIPE] = ACTIONS(1971),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(1971),
    [anon_sym_AMP] = ACTIONS(1973),
  },
  [525] = {
    [ts_builtin_sym_end] = ACTIONS(1975),
    [anon_sym_SEMI] = ACTIONS(1977),
    [anon_sym_esac] = ACTIONS(1975),
    [anon_sym_PIPE] = ACTIONS(1977),
    [anon_sym_RPAREN] = ACTIONS(1975),
    [anon_sym_SEMI_SEMI] = ACTIONS(1975),
    [anon_sym_PIPE_AMP] = ACTIONS(1975),
    [anon_sym_AMP_AMP] = ACTIONS(1975),
    [anon_sym_PIPE_PIPE] = ACTIONS(1975),
    [anon_sym_BQUOTE] = ACTIONS(1975),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(1975),
    [anon_sym_AMP] = ACTIONS(1977),
  },
  [526] = {
    [anon_sym_DASH] = ACTIONS(1979),
    [anon_sym_DOLLAR] = ACTIONS(1979),
    [anon_sym_POUND] = ACTIONS(1979),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1981),
    [anon_sym_STAR] = ACTIONS(1983),
    [anon_sym_AT] = ACTIONS(1983),
    [anon_sym_QMARK] = ACTIONS(1983),
    [anon_sym_0] = ACTIONS(1981),
    [anon_sym__] = ACTIONS(1981),
  },
  [527] = {
    [sym_subscript] = STATE(989),
    [sym_variable_name] = ACTIONS(1985),
    [anon_sym_BANG] = ACTIONS(1987),
    [anon_sym_DASH] = ACTIONS(1989),
    [anon_sym_DOLLAR] = ACTIONS(1989),
    [anon_sym_POUND] = ACTIONS(1987),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1991),
    [anon_sym_STAR] = ACTIONS(1993),
    [anon_sym_AT] = ACTIONS(1993),
    [anon_sym_QMARK] = ACTIONS(1993),
    [anon_sym_0] = ACTIONS(1991),
    [anon_sym__] = ACTIONS(1991),
  },
  [528] = {
    [sym_simple_expansion] = STATE(991),
    [sym_expansion] = STATE(991),
    [aux_sym_heredoc_body_repeat1] = STATE(991),
    [sym__heredoc_body_middle] = ACTIONS(1995),
    [sym__heredoc_body_end] = ACTIONS(1997),
    [anon_sym_DOLLAR] = ACTIONS(957),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(959),
    [sym_comment] = ACTIONS(55),
  },
  [529] = {
    [sym_concatenation] = STATE(994),
    [sym_string] = STATE(993),
    [sym_simple_expansion] = STATE(993),
    [sym_string_expansion] = STATE(993),
    [sym_expansion] = STATE(993),
    [sym_command_substitution] = STATE(993),
    [sym_process_substitution] = STATE(993),
    [sym__special_characters] = ACTIONS(1999),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(2001),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2001),
  },
  [530] = {
    [sym__simple_heredoc_body] = ACTIONS(2003),
    [sym__heredoc_body_beginning] = ACTIONS(2003),
    [sym_file_descriptor] = ACTIONS(2003),
    [ts_builtin_sym_end] = ACTIONS(2003),
    [anon_sym_SEMI] = ACTIONS(2005),
    [anon_sym_PIPE] = ACTIONS(2005),
    [anon_sym_RPAREN] = ACTIONS(2003),
    [anon_sym_SEMI_SEMI] = ACTIONS(2003),
    [anon_sym_PIPE_AMP] = ACTIONS(2003),
    [anon_sym_AMP_AMP] = ACTIONS(2003),
    [anon_sym_PIPE_PIPE] = ACTIONS(2003),
    [anon_sym_EQ_TILDE] = ACTIONS(2005),
    [anon_sym_EQ_EQ] = ACTIONS(2005),
    [anon_sym_LT] = ACTIONS(2005),
    [anon_sym_GT] = ACTIONS(2005),
    [anon_sym_GT_GT] = ACTIONS(2003),
    [anon_sym_AMP_GT] = ACTIONS(2005),
    [anon_sym_AMP_GT_GT] = ACTIONS(2003),
    [anon_sym_LT_AMP] = ACTIONS(2003),
    [anon_sym_GT_AMP] = ACTIONS(2003),
    [anon_sym_LT_LT] = ACTIONS(2005),
    [anon_sym_LT_LT_DASH] = ACTIONS(2003),
    [anon_sym_LT_LT_LT] = ACTIONS(2003),
    [sym__special_characters] = ACTIONS(2003),
    [anon_sym_DQUOTE] = ACTIONS(2003),
    [anon_sym_DOLLAR] = ACTIONS(2005),
    [sym_raw_string] = ACTIONS(2003),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2003),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2003),
    [anon_sym_BQUOTE] = ACTIONS(2003),
    [anon_sym_LT_LPAREN] = ACTIONS(2003),
    [anon_sym_GT_LPAREN] = ACTIONS(2003),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2005),
    [anon_sym_LF] = ACTIONS(2003),
    [anon_sym_AMP] = ACTIONS(2005),
  },
  [531] = {
    [aux_sym_concatenation_repeat1] = STATE(145),
    [sym__simple_heredoc_body] = ACTIONS(2007),
    [sym__heredoc_body_beginning] = ACTIONS(2007),
    [sym_file_descriptor] = ACTIONS(2007),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(2007),
    [anon_sym_SEMI] = ACTIONS(2009),
    [anon_sym_PIPE] = ACTIONS(2009),
    [anon_sym_SEMI_SEMI] = ACTIONS(2007),
    [anon_sym_PIPE_AMP] = ACTIONS(2007),
    [anon_sym_AMP_AMP] = ACTIONS(2007),
    [anon_sym_PIPE_PIPE] = ACTIONS(2007),
    [anon_sym_EQ_TILDE] = ACTIONS(2009),
    [anon_sym_EQ_EQ] = ACTIONS(2009),
    [anon_sym_LT] = ACTIONS(2009),
    [anon_sym_GT] = ACTIONS(2009),
    [anon_sym_GT_GT] = ACTIONS(2007),
    [anon_sym_AMP_GT] = ACTIONS(2009),
    [anon_sym_AMP_GT_GT] = ACTIONS(2007),
    [anon_sym_LT_AMP] = ACTIONS(2007),
    [anon_sym_GT_AMP] = ACTIONS(2007),
    [anon_sym_LT_LT] = ACTIONS(2009),
    [anon_sym_LT_LT_DASH] = ACTIONS(2007),
    [anon_sym_LT_LT_LT] = ACTIONS(2007),
    [sym__special_characters] = ACTIONS(2007),
    [anon_sym_DQUOTE] = ACTIONS(2007),
    [anon_sym_DOLLAR] = ACTIONS(2009),
    [sym_raw_string] = ACTIONS(2007),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2007),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2007),
    [anon_sym_BQUOTE] = ACTIONS(2007),
    [anon_sym_LT_LPAREN] = ACTIONS(2007),
    [anon_sym_GT_LPAREN] = ACTIONS(2007),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2009),
    [anon_sym_LF] = ACTIONS(2007),
    [anon_sym_AMP] = ACTIONS(2009),
  },
  [532] = {
    [aux_sym_concatenation_repeat1] = STATE(145),
    [sym__simple_heredoc_body] = ACTIONS(2003),
    [sym__heredoc_body_beginning] = ACTIONS(2003),
    [sym_file_descriptor] = ACTIONS(2003),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(2003),
    [anon_sym_SEMI] = ACTIONS(2005),
    [anon_sym_PIPE] = ACTIONS(2005),
    [anon_sym_SEMI_SEMI] = ACTIONS(2003),
    [anon_sym_PIPE_AMP] = ACTIONS(2003),
    [anon_sym_AMP_AMP] = ACTIONS(2003),
    [anon_sym_PIPE_PIPE] = ACTIONS(2003),
    [anon_sym_EQ_TILDE] = ACTIONS(2005),
    [anon_sym_EQ_EQ] = ACTIONS(2005),
    [anon_sym_LT] = ACTIONS(2005),
    [anon_sym_GT] = ACTIONS(2005),
    [anon_sym_GT_GT] = ACTIONS(2003),
    [anon_sym_AMP_GT] = ACTIONS(2005),
    [anon_sym_AMP_GT_GT] = ACTIONS(2003),
    [anon_sym_LT_AMP] = ACTIONS(2003),
    [anon_sym_GT_AMP] = ACTIONS(2003),
    [anon_sym_LT_LT] = ACTIONS(2005),
    [anon_sym_LT_LT_DASH] = ACTIONS(2003),
    [anon_sym_LT_LT_LT] = ACTIONS(2003),
    [sym__special_characters] = ACTIONS(2003),
    [anon_sym_DQUOTE] = ACTIONS(2003),
    [anon_sym_DOLLAR] = ACTIONS(2005),
    [sym_raw_string] = ACTIONS(2003),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2003),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2003),
    [anon_sym_BQUOTE] = ACTIONS(2003),
    [anon_sym_LT_LPAREN] = ACTIONS(2003),
    [anon_sym_GT_LPAREN] = ACTIONS(2003),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2005),
    [anon_sym_LF] = ACTIONS(2003),
    [anon_sym_AMP] = ACTIONS(2005),
  },
  [533] = {
    [aux_sym_concatenation_repeat1] = STATE(995),
    [sym__simple_heredoc_body] = ACTIONS(773),
    [sym__heredoc_body_beginning] = ACTIONS(773),
    [sym_file_descriptor] = ACTIONS(773),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(773),
    [anon_sym_SEMI] = ACTIONS(777),
    [anon_sym_PIPE] = ACTIONS(777),
    [anon_sym_SEMI_SEMI] = ACTIONS(773),
    [anon_sym_PIPE_AMP] = ACTIONS(773),
    [anon_sym_AMP_AMP] = ACTIONS(773),
    [anon_sym_PIPE_PIPE] = ACTIONS(773),
    [anon_sym_LT] = ACTIONS(777),
    [anon_sym_GT] = ACTIONS(777),
    [anon_sym_GT_GT] = ACTIONS(773),
    [anon_sym_AMP_GT] = ACTIONS(777),
    [anon_sym_AMP_GT_GT] = ACTIONS(773),
    [anon_sym_LT_AMP] = ACTIONS(773),
    [anon_sym_GT_AMP] = ACTIONS(773),
    [anon_sym_LT_LT] = ACTIONS(777),
    [anon_sym_LT_LT_DASH] = ACTIONS(773),
    [anon_sym_LT_LT_LT] = ACTIONS(773),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(773),
    [anon_sym_AMP] = ACTIONS(777),
  },
  [534] = {
    [aux_sym_concatenation_repeat1] = STATE(995),
    [sym__simple_heredoc_body] = ACTIONS(791),
    [sym__heredoc_body_beginning] = ACTIONS(791),
    [sym_file_descriptor] = ACTIONS(791),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(791),
    [anon_sym_SEMI] = ACTIONS(793),
    [anon_sym_PIPE] = ACTIONS(793),
    [anon_sym_SEMI_SEMI] = ACTIONS(791),
    [anon_sym_PIPE_AMP] = ACTIONS(791),
    [anon_sym_AMP_AMP] = ACTIONS(791),
    [anon_sym_PIPE_PIPE] = ACTIONS(791),
    [anon_sym_LT] = ACTIONS(793),
    [anon_sym_GT] = ACTIONS(793),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_AMP_GT] = ACTIONS(793),
    [anon_sym_AMP_GT_GT] = ACTIONS(791),
    [anon_sym_LT_AMP] = ACTIONS(791),
    [anon_sym_GT_AMP] = ACTIONS(791),
    [anon_sym_LT_LT] = ACTIONS(793),
    [anon_sym_LT_LT_DASH] = ACTIONS(791),
    [anon_sym_LT_LT_LT] = ACTIONS(791),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(791),
    [anon_sym_AMP] = ACTIONS(793),
  },
  [535] = {
    [sym__simple_heredoc_body] = ACTIONS(791),
    [sym__heredoc_body_beginning] = ACTIONS(791),
    [sym_file_descriptor] = ACTIONS(791),
    [ts_builtin_sym_end] = ACTIONS(791),
    [anon_sym_SEMI] = ACTIONS(793),
    [anon_sym_esac] = ACTIONS(791),
    [anon_sym_PIPE] = ACTIONS(793),
    [anon_sym_RPAREN] = ACTIONS(791),
    [anon_sym_SEMI_SEMI] = ACTIONS(791),
    [anon_sym_PIPE_AMP] = ACTIONS(791),
    [anon_sym_AMP_AMP] = ACTIONS(791),
    [anon_sym_PIPE_PIPE] = ACTIONS(791),
    [anon_sym_LT] = ACTIONS(793),
    [anon_sym_GT] = ACTIONS(793),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_AMP_GT] = ACTIONS(793),
    [anon_sym_AMP_GT_GT] = ACTIONS(791),
    [anon_sym_LT_AMP] = ACTIONS(791),
    [anon_sym_GT_AMP] = ACTIONS(791),
    [anon_sym_LT_LT] = ACTIONS(793),
    [anon_sym_LT_LT_DASH] = ACTIONS(791),
    [anon_sym_LT_LT_LT] = ACTIONS(791),
    [anon_sym_BQUOTE] = ACTIONS(791),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(791),
    [anon_sym_AMP] = ACTIONS(793),
  },
  [536] = {
    [sym__simple_heredoc_body] = ACTIONS(2011),
    [sym__heredoc_body_beginning] = ACTIONS(2011),
    [sym_file_descriptor] = ACTIONS(2011),
    [ts_builtin_sym_end] = ACTIONS(2011),
    [anon_sym_SEMI] = ACTIONS(2013),
    [anon_sym_esac] = ACTIONS(2011),
    [anon_sym_PIPE] = ACTIONS(2013),
    [anon_sym_RPAREN] = ACTIONS(2011),
    [anon_sym_SEMI_SEMI] = ACTIONS(2011),
    [anon_sym_PIPE_AMP] = ACTIONS(2011),
    [anon_sym_AMP_AMP] = ACTIONS(2011),
    [anon_sym_PIPE_PIPE] = ACTIONS(2011),
    [anon_sym_LT] = ACTIONS(2013),
    [anon_sym_GT] = ACTIONS(2013),
    [anon_sym_GT_GT] = ACTIONS(2011),
    [anon_sym_AMP_GT] = ACTIONS(2013),
    [anon_sym_AMP_GT_GT] = ACTIONS(2011),
    [anon_sym_LT_AMP] = ACTIONS(2011),
    [anon_sym_GT_AMP] = ACTIONS(2011),
    [anon_sym_LT_LT] = ACTIONS(2013),
    [anon_sym_LT_LT_DASH] = ACTIONS(2011),
    [anon_sym_LT_LT_LT] = ACTIONS(2011),
    [anon_sym_BQUOTE] = ACTIONS(2011),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2011),
    [anon_sym_AMP] = ACTIONS(2013),
  },
  [537] = {
    [aux_sym_concatenation_repeat1] = STATE(995),
    [sym__simple_heredoc_body] = ACTIONS(2015),
    [sym__heredoc_body_beginning] = ACTIONS(2015),
    [sym_file_descriptor] = ACTIONS(2015),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(2015),
    [anon_sym_SEMI] = ACTIONS(2017),
    [anon_sym_PIPE] = ACTIONS(2017),
    [anon_sym_SEMI_SEMI] = ACTIONS(2015),
    [anon_sym_PIPE_AMP] = ACTIONS(2015),
    [anon_sym_AMP_AMP] = ACTIONS(2015),
    [anon_sym_PIPE_PIPE] = ACTIONS(2015),
    [anon_sym_LT] = ACTIONS(2017),
    [anon_sym_GT] = ACTIONS(2017),
    [anon_sym_GT_GT] = ACTIONS(2015),
    [anon_sym_AMP_GT] = ACTIONS(2017),
    [anon_sym_AMP_GT_GT] = ACTIONS(2015),
    [anon_sym_LT_AMP] = ACTIONS(2015),
    [anon_sym_GT_AMP] = ACTIONS(2015),
    [anon_sym_LT_LT] = ACTIONS(2017),
    [anon_sym_LT_LT_DASH] = ACTIONS(2015),
    [anon_sym_LT_LT_LT] = ACTIONS(2015),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2015),
    [anon_sym_AMP] = ACTIONS(2017),
  },
  [538] = {
    [aux_sym_concatenation_repeat1] = STATE(995),
    [sym__simple_heredoc_body] = ACTIONS(2019),
    [sym__heredoc_body_beginning] = ACTIONS(2019),
    [sym_file_descriptor] = ACTIONS(2019),
    [sym__concat] = ACTIONS(265),
    [ts_builtin_sym_end] = ACTIONS(2019),
    [anon_sym_SEMI] = ACTIONS(2021),
    [anon_sym_PIPE] = ACTIONS(2021),
    [anon_sym_SEMI_SEMI] = ACTIONS(2019),
    [anon_sym_PIPE_AMP] = ACTIONS(2019),
    [anon_sym_AMP_AMP] = ACTIONS(2019),
    [anon_sym_PIPE_PIPE] = ACTIONS(2019),
    [anon_sym_LT] = ACTIONS(2021),
    [anon_sym_GT] = ACTIONS(2021),
    [anon_sym_GT_GT] = ACTIONS(2019),
    [anon_sym_AMP_GT] = ACTIONS(2021),
    [anon_sym_AMP_GT_GT] = ACTIONS(2019),
    [anon_sym_LT_AMP] = ACTIONS(2019),
    [anon_sym_GT_AMP] = ACTIONS(2019),
    [anon_sym_LT_LT] = ACTIONS(2021),
    [anon_sym_LT_LT_DASH] = ACTIONS(2019),
    [anon_sym_LT_LT_LT] = ACTIONS(2019),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2019),
    [anon_sym_AMP] = ACTIONS(2021),
  },
  [539] = {
    [sym__simple_heredoc_body] = ACTIONS(2019),
    [sym__heredoc_body_beginning] = ACTIONS(2019),
    [sym_file_descriptor] = ACTIONS(2019),
    [ts_builtin_sym_end] = ACTIONS(2019),
    [anon_sym_SEMI] = ACTIONS(2021),
    [anon_sym_esac] = ACTIONS(2019),
    [anon_sym_PIPE] = ACTIONS(2021),
    [anon_sym_RPAREN] = ACTIONS(2019),
    [anon_sym_SEMI_SEMI] = ACTIONS(2019),
    [anon_sym_PIPE_AMP] = ACTIONS(2019),
    [anon_sym_AMP_AMP] = ACTIONS(2019),
    [anon_sym_PIPE_PIPE] = ACTIONS(2019),
    [anon_sym_LT] = ACTIONS(2021),
    [anon_sym_GT] = ACTIONS(2021),
    [anon_sym_GT_GT] = ACTIONS(2019),
    [anon_sym_AMP_GT] = ACTIONS(2021),
    [anon_sym_AMP_GT_GT] = ACTIONS(2019),
    [anon_sym_LT_AMP] = ACTIONS(2019),
    [anon_sym_GT_AMP] = ACTIONS(2019),
    [anon_sym_LT_LT] = ACTIONS(2021),
    [anon_sym_LT_LT_DASH] = ACTIONS(2019),
    [anon_sym_LT_LT_LT] = ACTIONS(2019),
    [anon_sym_BQUOTE] = ACTIONS(2019),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2019),
    [anon_sym_AMP] = ACTIONS(2021),
  },
  [540] = {
    [ts_builtin_sym_end] = ACTIONS(2023),
    [anon_sym_SEMI] = ACTIONS(2025),
    [anon_sym_esac] = ACTIONS(2023),
    [anon_sym_PIPE] = ACTIONS(2025),
    [anon_sym_RPAREN] = ACTIONS(2023),
    [anon_sym_SEMI_SEMI] = ACTIONS(2023),
    [anon_sym_PIPE_AMP] = ACTIONS(2023),
    [anon_sym_AMP_AMP] = ACTIONS(2023),
    [anon_sym_PIPE_PIPE] = ACTIONS(2023),
    [anon_sym_BQUOTE] = ACTIONS(2023),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2023),
    [anon_sym_AMP] = ACTIONS(2025),
  },
  [541] = {
    [sym_file_redirect] = STATE(541),
    [sym_heredoc_redirect] = STATE(541),
    [sym_herestring_redirect] = STATE(541),
    [aux_sym_while_statement_repeat1] = STATE(541),
    [sym__simple_heredoc_body] = ACTIONS(2027),
    [sym__heredoc_body_beginning] = ACTIONS(2027),
    [sym_file_descriptor] = ACTIONS(2029),
    [ts_builtin_sym_end] = ACTIONS(2027),
    [anon_sym_SEMI] = ACTIONS(2032),
    [anon_sym_PIPE] = ACTIONS(2032),
    [anon_sym_SEMI_SEMI] = ACTIONS(2027),
    [anon_sym_PIPE_AMP] = ACTIONS(2027),
    [anon_sym_AMP_AMP] = ACTIONS(2027),
    [anon_sym_PIPE_PIPE] = ACTIONS(2027),
    [anon_sym_LT] = ACTIONS(2034),
    [anon_sym_GT] = ACTIONS(2034),
    [anon_sym_GT_GT] = ACTIONS(2037),
    [anon_sym_AMP_GT] = ACTIONS(2034),
    [anon_sym_AMP_GT_GT] = ACTIONS(2037),
    [anon_sym_LT_AMP] = ACTIONS(2037),
    [anon_sym_GT_AMP] = ACTIONS(2037),
    [anon_sym_LT_LT] = ACTIONS(2040),
    [anon_sym_LT_LT_DASH] = ACTIONS(2043),
    [anon_sym_LT_LT_LT] = ACTIONS(2046),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2027),
    [anon_sym_AMP] = ACTIONS(2032),
  },
  [542] = {
    [sym_file_redirect] = STATE(541),
    [sym_heredoc_redirect] = STATE(541),
    [sym_heredoc_body] = STATE(996),
    [sym_herestring_redirect] = STATE(541),
    [aux_sym_while_statement_repeat1] = STATE(541),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(343),
    [ts_builtin_sym_end] = ACTIONS(2023),
    [anon_sym_SEMI] = ACTIONS(2025),
    [anon_sym_PIPE] = ACTIONS(2025),
    [anon_sym_SEMI_SEMI] = ACTIONS(2023),
    [anon_sym_PIPE_AMP] = ACTIONS(2023),
    [anon_sym_AMP_AMP] = ACTIONS(2023),
    [anon_sym_PIPE_PIPE] = ACTIONS(2023),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(359),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2023),
    [anon_sym_AMP] = ACTIONS(2025),
  },
  [543] = {
    [sym_concatenation] = STATE(543),
    [sym_string] = STATE(192),
    [sym_simple_expansion] = STATE(192),
    [sym_string_expansion] = STATE(192),
    [sym_expansion] = STATE(192),
    [sym_command_substitution] = STATE(192),
    [sym_process_substitution] = STATE(192),
    [aux_sym_command_repeat2] = STATE(543),
    [sym__simple_heredoc_body] = ACTIONS(2003),
    [sym__heredoc_body_beginning] = ACTIONS(2003),
    [sym_file_descriptor] = ACTIONS(2003),
    [ts_builtin_sym_end] = ACTIONS(2003),
    [anon_sym_SEMI] = ACTIONS(2005),
    [anon_sym_PIPE] = ACTIONS(2005),
    [anon_sym_SEMI_SEMI] = ACTIONS(2003),
    [anon_sym_PIPE_AMP] = ACTIONS(2003),
    [anon_sym_AMP_AMP] = ACTIONS(2003),
    [anon_sym_PIPE_PIPE] = ACTIONS(2003),
    [anon_sym_EQ_TILDE] = ACTIONS(2049),
    [anon_sym_EQ_EQ] = ACTIONS(2049),
    [anon_sym_LT] = ACTIONS(2005),
    [anon_sym_GT] = ACTIONS(2005),
    [anon_sym_GT_GT] = ACTIONS(2003),
    [anon_sym_AMP_GT] = ACTIONS(2005),
    [anon_sym_AMP_GT_GT] = ACTIONS(2003),
    [anon_sym_LT_AMP] = ACTIONS(2003),
    [anon_sym_GT_AMP] = ACTIONS(2003),
    [anon_sym_LT_LT] = ACTIONS(2005),
    [anon_sym_LT_LT_DASH] = ACTIONS(2003),
    [anon_sym_LT_LT_LT] = ACTIONS(2003),
    [sym__special_characters] = ACTIONS(2052),
    [anon_sym_DQUOTE] = ACTIONS(2055),
    [anon_sym_DOLLAR] = ACTIONS(2058),
    [sym_raw_string] = ACTIONS(2061),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2064),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2067),
    [anon_sym_BQUOTE] = ACTIONS(2070),
    [anon_sym_LT_LPAREN] = ACTIONS(2073),
    [anon_sym_GT_LPAREN] = ACTIONS(2073),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2076),
    [anon_sym_LF] = ACTIONS(2003),
    [anon_sym_AMP] = ACTIONS(2005),
  },
  [544] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [ts_builtin_sym_end] = ACTIONS(2079),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [545] = {
    [anon_sym_SEMI] = ACTIONS(2081),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_SEMI_SEMI] = ACTIONS(2083),
    [anon_sym_PIPE_AMP] = ACTIONS(533),
    [anon_sym_AMP_AMP] = ACTIONS(535),
    [anon_sym_PIPE_PIPE] = ACTIONS(535),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2083),
    [anon_sym_AMP] = ACTIONS(2081),
  },
  [546] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2081),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_SEMI_SEMI] = ACTIONS(2083),
    [anon_sym_PIPE_AMP] = ACTIONS(533),
    [anon_sym_AMP_AMP] = ACTIONS(535),
    [anon_sym_PIPE_PIPE] = ACTIONS(535),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2083),
    [anon_sym_AMP] = ACTIONS(2081),
  },
  [547] = {
    [sym_file_redirect] = STATE(998),
    [sym_heredoc_redirect] = STATE(998),
    [sym_heredoc_body] = STATE(996),
    [sym_herestring_redirect] = STATE(998),
    [sym_concatenation] = STATE(543),
    [sym_string] = STATE(192),
    [sym_simple_expansion] = STATE(192),
    [sym_string_expansion] = STATE(192),
    [sym_expansion] = STATE(192),
    [sym_command_substitution] = STATE(192),
    [sym_process_substitution] = STATE(192),
    [aux_sym_while_statement_repeat1] = STATE(998),
    [aux_sym_command_repeat2] = STATE(543),
    [sym__simple_heredoc_body] = ACTIONS(339),
    [sym__heredoc_body_beginning] = ACTIONS(341),
    [sym_file_descriptor] = ACTIONS(343),
    [ts_builtin_sym_end] = ACTIONS(2023),
    [anon_sym_SEMI] = ACTIONS(2025),
    [anon_sym_PIPE] = ACTIONS(2025),
    [anon_sym_SEMI_SEMI] = ACTIONS(2023),
    [anon_sym_PIPE_AMP] = ACTIONS(2023),
    [anon_sym_AMP_AMP] = ACTIONS(2023),
    [anon_sym_PIPE_PIPE] = ACTIONS(2023),
    [anon_sym_EQ_TILDE] = ACTIONS(349),
    [anon_sym_EQ_EQ] = ACTIONS(349),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(357),
    [anon_sym_LT_LT_LT] = ACTIONS(359),
    [sym__special_characters] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(363),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(2023),
    [anon_sym_AMP] = ACTIONS(2025),
  },
  [548] = {
    [sym_string] = STATE(790),
    [sym_simple_expansion] = STATE(790),
    [sym_string_expansion] = STATE(790),
    [sym_expansion] = STATE(790),
    [sym_command_substitution] = STATE(790),
    [sym_process_substitution] = STATE(790),
    [anon_sym_RBRACK] = ACTIONS(2085),
    [sym__special_characters] = ACTIONS(2087),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(1490),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1490),
  },
  [549] = {
    [sym__concat] = ACTIONS(2089),
    [anon_sym_EQ] = ACTIONS(2091),
    [anon_sym_PLUS_EQ] = ACTIONS(2091),
    [sym_comment] = ACTIONS(55),
  },
  [550] = {
    [aux_sym_concatenation_repeat1] = STATE(1001),
    [sym__concat] = ACTIONS(657),
    [anon_sym_RBRACK] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
  },
  [551] = {
    [sym_string] = STATE(790),
    [sym_simple_expansion] = STATE(790),
    [sym_string_expansion] = STATE(790),
    [sym_expansion] = STATE(790),
    [sym_command_substitution] = STATE(790),
    [sym_process_substitution] = STATE(790),
    [anon_sym_RBRACK] = ACTIONS(2093),
    [sym__special_characters] = ACTIONS(2087),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [sym_raw_string] = ACTIONS(1490),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(177),
    [anon_sym_BQUOTE] = ACTIONS(179),
    [anon_sym_LT_LPAREN] = ACTIONS(181),
    [anon_sym_GT_LPAREN] = ACTIONS(181),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1490),
  },
  [552] = {
    [sym__concat] = ACTIONS(2095),
    [anon_sym_EQ] = ACTIONS(2097),
    [anon_sym_PLUS_EQ] = ACTIONS(2097),
    [sym_comment] = ACTIONS(55),
  },
  [553] = {
    [anon_sym_RBRACK] = ACTIONS(2093),
    [sym_comment] = ACTIONS(55),
  },
  [554] = {
    [sym_file_descriptor] = ACTIONS(2099),
    [sym_variable_name] = ACTIONS(2099),
    [ts_builtin_sym_end] = ACTIONS(2099),
    [anon_sym_SEMI] = ACTIONS(2101),
    [anon_sym_PIPE] = ACTIONS(2101),
    [anon_sym_RPAREN] = ACTIONS(2099),
    [anon_sym_SEMI_SEMI] = ACTIONS(2099),
    [anon_sym_PIPE_AMP] = ACTIONS(2099),
    [anon_sym_AMP_AMP] = ACTIONS(2099),
    [anon_sym_PIPE_PIPE] = ACTIONS(2099),
    [anon_sym_LT] = ACTIONS(2101),
    [anon_sym_GT] = ACTIONS(2101),
    [anon_sym_GT_GT] = ACTIONS(2099),
    [anon_sym_AMP_GT] = ACTIONS(2101),
    [anon_sym_AMP_GT_GT] = ACTIONS(2099),
    [anon_sym_LT_AMP] = ACTIONS(2099),
    [anon_sym_GT_AMP] = ACTIONS(2099),
    [sym__special_characters] = ACTIONS(2099),
    [anon_sym_DQUOTE] = ACTIONS(2099),
    [anon_sym_DOLLAR] = ACTIONS(2101),
    [sym_raw_string] = ACTIONS(2099),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2099),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2099),
    [anon_sym_BQUOTE] = ACTIONS(2099),
    [anon_sym_LT_LPAREN] = ACTIONS(2099),
    [anon_sym_GT_LPAREN] = ACTIONS(2099),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2101),
    [anon_sym_LF] = ACTIONS(2099),
    [anon_sym_AMP] = ACTIONS(2101),
  },
  [555] = {
    [aux_sym_concatenation_repeat1] = STATE(1005),
    [sym__concat] = ACTIONS(2103),
    [anon_sym_RPAREN] = ACTIONS(2105),
    [sym__special_characters] = ACTIONS(2105),
    [anon_sym_DQUOTE] = ACTIONS(2105),
    [anon_sym_DOLLAR] = ACTIONS(2107),
    [sym_raw_string] = ACTIONS(2105),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2105),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2105),
    [anon_sym_BQUOTE] = ACTIONS(2105),
    [anon_sym_LT_LPAREN] = ACTIONS(2105),
    [anon_sym_GT_LPAREN] = ACTIONS(2105),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2105),
  },
  [556] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(1008),
    [anon_sym_DQUOTE] = ACTIONS(2109),
    [anon_sym_DOLLAR] = ACTIONS(2111),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [557] = {
    [sym_string] = STATE(1010),
    [anon_sym_DASH] = ACTIONS(2113),
    [anon_sym_DQUOTE] = ACTIONS(1114),
    [anon_sym_DOLLAR] = ACTIONS(2113),
    [sym_raw_string] = ACTIONS(2115),
    [anon_sym_POUND] = ACTIONS(2113),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2117),
    [anon_sym_STAR] = ACTIONS(2119),
    [anon_sym_AT] = ACTIONS(2119),
    [anon_sym_QMARK] = ACTIONS(2119),
    [anon_sym_0] = ACTIONS(2117),
    [anon_sym__] = ACTIONS(2117),
  },
  [558] = {
    [aux_sym_concatenation_repeat1] = STATE(1005),
    [sym__concat] = ACTIONS(2103),
    [anon_sym_RPAREN] = ACTIONS(2121),
    [sym__special_characters] = ACTIONS(2121),
    [anon_sym_DQUOTE] = ACTIONS(2121),
    [anon_sym_DOLLAR] = ACTIONS(2123),
    [sym_raw_string] = ACTIONS(2121),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2121),
    [anon_sym_BQUOTE] = ACTIONS(2121),
    [anon_sym_LT_LPAREN] = ACTIONS(2121),
    [anon_sym_GT_LPAREN] = ACTIONS(2121),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2121),
  },
  [559] = {
    [sym_subscript] = STATE(1015),
    [sym_variable_name] = ACTIONS(2125),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DASH] = ACTIONS(2129),
    [anon_sym_DOLLAR] = ACTIONS(2129),
    [anon_sym_POUND] = ACTIONS(2127),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2131),
    [anon_sym_STAR] = ACTIONS(2133),
    [anon_sym_AT] = ACTIONS(2133),
    [anon_sym_QMARK] = ACTIONS(2133),
    [anon_sym_0] = ACTIONS(2131),
    [anon_sym__] = ACTIONS(2131),
  },
  [560] = {
    [sym__terminated_statement] = STATE(1018),
    [sym_for_statement] = STATE(1016),
    [sym_c_style_for_statement] = STATE(1016),
    [sym_while_statement] = STATE(1016),
    [sym_if_statement] = STATE(1016),
    [sym_case_statement] = STATE(1016),
    [sym_function_definition] = STATE(1016),
    [sym_subshell] = STATE(1016),
    [sym_pipeline] = STATE(1016),
    [sym_list] = STATE(1016),
    [sym_negated_command] = STATE(1016),
    [sym_test_command] = STATE(1016),
    [sym_declaration_command] = STATE(1016),
    [sym_unset_command] = STATE(1016),
    [sym_command] = STATE(1016),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1017),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(1018),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [561] = {
    [sym__terminated_statement] = STATE(1021),
    [sym_for_statement] = STATE(1019),
    [sym_c_style_for_statement] = STATE(1019),
    [sym_while_statement] = STATE(1019),
    [sym_if_statement] = STATE(1019),
    [sym_case_statement] = STATE(1019),
    [sym_function_definition] = STATE(1019),
    [sym_subshell] = STATE(1019),
    [sym_pipeline] = STATE(1019),
    [sym_list] = STATE(1019),
    [sym_negated_command] = STATE(1019),
    [sym_test_command] = STATE(1019),
    [sym_declaration_command] = STATE(1019),
    [sym_unset_command] = STATE(1019),
    [sym_command] = STATE(1019),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(1020),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(1021),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [562] = {
    [sym__terminated_statement] = STATE(1024),
    [sym_for_statement] = STATE(1022),
    [sym_c_style_for_statement] = STATE(1022),
    [sym_while_statement] = STATE(1022),
    [sym_if_statement] = STATE(1022),
    [sym_case_statement] = STATE(1022),
    [sym_function_definition] = STATE(1022),
    [sym_subshell] = STATE(1022),
    [sym_pipeline] = STATE(1022),
    [sym_list] = STATE(1022),
    [sym_negated_command] = STATE(1022),
    [sym_test_command] = STATE(1022),
    [sym_declaration_command] = STATE(1022),
    [sym_unset_command] = STATE(1022),
    [sym_command] = STATE(1022),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1023),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(1024),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [563] = {
    [sym_concatenation] = STATE(1026),
    [sym_string] = STATE(558),
    [sym_simple_expansion] = STATE(558),
    [sym_string_expansion] = STATE(558),
    [sym_expansion] = STATE(558),
    [sym_command_substitution] = STATE(558),
    [sym_process_substitution] = STATE(558),
    [aux_sym_for_statement_repeat1] = STATE(1026),
    [anon_sym_RPAREN] = ACTIONS(2135),
    [sym__special_characters] = ACTIONS(1112),
    [anon_sym_DQUOTE] = ACTIONS(1114),
    [anon_sym_DOLLAR] = ACTIONS(1116),
    [sym_raw_string] = ACTIONS(1118),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1120),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1122),
    [anon_sym_BQUOTE] = ACTIONS(1124),
    [anon_sym_LT_LPAREN] = ACTIONS(1126),
    [anon_sym_GT_LPAREN] = ACTIONS(1126),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(1118),
  },
  [564] = {
    [sym_string] = STATE(1027),
    [sym_simple_expansion] = STATE(1027),
    [sym_string_expansion] = STATE(1027),
    [sym_expansion] = STATE(1027),
    [sym_command_substitution] = STATE(1027),
    [sym_process_substitution] = STATE(1027),
    [sym__special_characters] = ACTIONS(2137),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(389),
    [sym_raw_string] = ACTIONS(2137),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(393),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(397),
    [anon_sym_LT_LPAREN] = ACTIONS(399),
    [anon_sym_GT_LPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2137),
  },
  [565] = {
    [aux_sym_concatenation_repeat1] = STATE(1028),
    [sym_file_descriptor] = ACTIONS(807),
    [sym__concat] = ACTIONS(1130),
    [sym_variable_name] = ACTIONS(807),
    [ts_builtin_sym_end] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_PIPE] = ACTIONS(809),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [anon_sym_PIPE_AMP] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_GT_GT] = ACTIONS(807),
    [anon_sym_AMP_GT] = ACTIONS(809),
    [anon_sym_AMP_GT_GT] = ACTIONS(807),
    [anon_sym_LT_AMP] = ACTIONS(807),
    [anon_sym_GT_AMP] = ACTIONS(807),
    [sym__special_characters] = ACTIONS(807),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(807),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [anon_sym_LT_LPAREN] = ACTIONS(807),
    [anon_sym_GT_LPAREN] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(809),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(809),
  },
  [566] = {
    [sym_file_descriptor] = ACTIONS(811),
    [sym__concat] = ACTIONS(811),
    [sym_variable_name] = ACTIONS(811),
    [ts_builtin_sym_end] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(813),
    [anon_sym_PIPE] = ACTIONS(813),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_SEMI_SEMI] = ACTIONS(811),
    [anon_sym_PIPE_AMP] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_GT_GT] = ACTIONS(811),
    [anon_sym_AMP_GT] = ACTIONS(813),
    [anon_sym_AMP_GT_GT] = ACTIONS(811),
    [anon_sym_LT_AMP] = ACTIONS(811),
    [anon_sym_GT_AMP] = ACTIONS(811),
    [sym__special_characters] = ACTIONS(811),
    [anon_sym_DQUOTE] = ACTIONS(811),
    [anon_sym_DOLLAR] = ACTIONS(813),
    [sym_raw_string] = ACTIONS(811),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(811),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(811),
    [anon_sym_BQUOTE] = ACTIONS(811),
    [anon_sym_LT_LPAREN] = ACTIONS(811),
    [anon_sym_GT_LPAREN] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(813),
    [anon_sym_LF] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(813),
  },
  [567] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(2139),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [568] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(2139),
    [anon_sym_DOLLAR] = ACTIONS(2141),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [569] = {
    [sym_file_descriptor] = ACTIONS(845),
    [sym__concat] = ACTIONS(845),
    [sym_variable_name] = ACTIONS(845),
    [ts_builtin_sym_end] = ACTIONS(845),
    [anon_sym_SEMI] = ACTIONS(847),
    [anon_sym_PIPE] = ACTIONS(847),
    [anon_sym_RPAREN] = ACTIONS(845),
    [anon_sym_SEMI_SEMI] = ACTIONS(845),
    [anon_sym_PIPE_AMP] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(847),
    [anon_sym_GT] = ACTIONS(847),
    [anon_sym_GT_GT] = ACTIONS(845),
    [anon_sym_AMP_GT] = ACTIONS(847),
    [anon_sym_AMP_GT_GT] = ACTIONS(845),
    [anon_sym_LT_AMP] = ACTIONS(845),
    [anon_sym_GT_AMP] = ACTIONS(845),
    [sym__special_characters] = ACTIONS(845),
    [anon_sym_DQUOTE] = ACTIONS(845),
    [anon_sym_DOLLAR] = ACTIONS(847),
    [sym_raw_string] = ACTIONS(845),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(845),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(845),
    [anon_sym_BQUOTE] = ACTIONS(845),
    [anon_sym_LT_LPAREN] = ACTIONS(845),
    [anon_sym_GT_LPAREN] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(847),
    [anon_sym_LF] = ACTIONS(845),
    [anon_sym_AMP] = ACTIONS(847),
  },
  [570] = {
    [sym_file_descriptor] = ACTIONS(849),
    [sym__concat] = ACTIONS(849),
    [sym_variable_name] = ACTIONS(849),
    [ts_builtin_sym_end] = ACTIONS(849),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_PIPE] = ACTIONS(851),
    [anon_sym_RPAREN] = ACTIONS(849),
    [anon_sym_SEMI_SEMI] = ACTIONS(849),
    [anon_sym_PIPE_AMP] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [anon_sym_LT] = ACTIONS(851),
    [anon_sym_GT] = ACTIONS(851),
    [anon_sym_GT_GT] = ACTIONS(849),
    [anon_sym_AMP_GT] = ACTIONS(851),
    [anon_sym_AMP_GT_GT] = ACTIONS(849),
    [anon_sym_LT_AMP] = ACTIONS(849),
    [anon_sym_GT_AMP] = ACTIONS(849),
    [sym__special_characters] = ACTIONS(849),
    [anon_sym_DQUOTE] = ACTIONS(849),
    [anon_sym_DOLLAR] = ACTIONS(851),
    [sym_raw_string] = ACTIONS(849),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(849),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(849),
    [anon_sym_BQUOTE] = ACTIONS(849),
    [anon_sym_LT_LPAREN] = ACTIONS(849),
    [anon_sym_GT_LPAREN] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(851),
    [anon_sym_LF] = ACTIONS(849),
    [anon_sym_AMP] = ACTIONS(851),
  },
  [571] = {
    [sym_file_descriptor] = ACTIONS(853),
    [sym__concat] = ACTIONS(853),
    [sym_variable_name] = ACTIONS(853),
    [ts_builtin_sym_end] = ACTIONS(853),
    [anon_sym_SEMI] = ACTIONS(855),
    [anon_sym_PIPE] = ACTIONS(855),
    [anon_sym_RPAREN] = ACTIONS(853),
    [anon_sym_SEMI_SEMI] = ACTIONS(853),
    [anon_sym_PIPE_AMP] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [anon_sym_LT] = ACTIONS(855),
    [anon_sym_GT] = ACTIONS(855),
    [anon_sym_GT_GT] = ACTIONS(853),
    [anon_sym_AMP_GT] = ACTIONS(855),
    [anon_sym_AMP_GT_GT] = ACTIONS(853),
    [anon_sym_LT_AMP] = ACTIONS(853),
    [anon_sym_GT_AMP] = ACTIONS(853),
    [sym__special_characters] = ACTIONS(853),
    [anon_sym_DQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [sym_raw_string] = ACTIONS(853),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(853),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(853),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_LT_LPAREN] = ACTIONS(853),
    [anon_sym_GT_LPAREN] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(855),
    [anon_sym_LF] = ACTIONS(853),
    [anon_sym_AMP] = ACTIONS(855),
  },
  [572] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(2143),
    [sym_comment] = ACTIONS(55),
  },
  [573] = {
    [sym_subscript] = STATE(1034),
    [sym_variable_name] = ACTIONS(2145),
    [anon_sym_DASH] = ACTIONS(2147),
    [anon_sym_DOLLAR] = ACTIONS(2147),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2149),
    [anon_sym_STAR] = ACTIONS(2151),
    [anon_sym_AT] = ACTIONS(2151),
    [anon_sym_QMARK] = ACTIONS(2151),
    [anon_sym_0] = ACTIONS(2149),
    [anon_sym__] = ACTIONS(2149),
  },
  [574] = {
    [sym_concatenation] = STATE(1037),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1037),
    [anon_sym_RBRACE] = ACTIONS(2153),
    [anon_sym_EQ] = ACTIONS(2155),
    [anon_sym_DASH] = ACTIONS(2155),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2159),
    [anon_sym_COLON] = ACTIONS(2155),
    [anon_sym_COLON_QMARK] = ACTIONS(2155),
    [anon_sym_COLON_DASH] = ACTIONS(2155),
    [anon_sym_PERCENT] = ACTIONS(2155),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [575] = {
    [sym_concatenation] = STATE(1040),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1040),
    [anon_sym_RBRACE] = ACTIONS(2161),
    [anon_sym_EQ] = ACTIONS(2163),
    [anon_sym_DASH] = ACTIONS(2163),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2167),
    [anon_sym_COLON] = ACTIONS(2163),
    [anon_sym_COLON_QMARK] = ACTIONS(2163),
    [anon_sym_COLON_DASH] = ACTIONS(2163),
    [anon_sym_PERCENT] = ACTIONS(2163),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [576] = {
    [anon_sym_SEMI] = ACTIONS(2169),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2171),
    [anon_sym_SEMI_SEMI] = ACTIONS(2173),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2173),
    [anon_sym_AMP] = ACTIONS(2169),
  },
  [577] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2169),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2171),
    [anon_sym_SEMI_SEMI] = ACTIONS(2173),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2173),
    [anon_sym_AMP] = ACTIONS(2169),
  },
  [578] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1043),
    [sym_c_style_for_statement] = STATE(1043),
    [sym_while_statement] = STATE(1043),
    [sym_if_statement] = STATE(1043),
    [sym_case_statement] = STATE(1043),
    [sym_function_definition] = STATE(1043),
    [sym_subshell] = STATE(1043),
    [sym_pipeline] = STATE(1043),
    [sym_list] = STATE(1043),
    [sym_negated_command] = STATE(1043),
    [sym_test_command] = STATE(1043),
    [sym_declaration_command] = STATE(1043),
    [sym_unset_command] = STATE(1043),
    [sym_command] = STATE(1043),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1044),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [579] = {
    [anon_sym_SEMI] = ACTIONS(2175),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2177),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(2171),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2177),
    [anon_sym_AMP] = ACTIONS(2175),
  },
  [580] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2175),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2177),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(2171),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2177),
    [anon_sym_AMP] = ACTIONS(2175),
  },
  [581] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1046),
    [sym_c_style_for_statement] = STATE(1046),
    [sym_while_statement] = STATE(1046),
    [sym_if_statement] = STATE(1046),
    [sym_case_statement] = STATE(1046),
    [sym_function_definition] = STATE(1046),
    [sym_subshell] = STATE(1046),
    [sym_pipeline] = STATE(1046),
    [sym_list] = STATE(1046),
    [sym_negated_command] = STATE(1046),
    [sym_test_command] = STATE(1046),
    [sym_declaration_command] = STATE(1046),
    [sym_unset_command] = STATE(1046),
    [sym_command] = STATE(1046),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(1047),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [582] = {
    [anon_sym_SEMI] = ACTIONS(2179),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2181),
    [anon_sym_SEMI_SEMI] = ACTIONS(2183),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2183),
    [anon_sym_AMP] = ACTIONS(2179),
  },
  [583] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2179),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2181),
    [anon_sym_SEMI_SEMI] = ACTIONS(2183),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2183),
    [anon_sym_AMP] = ACTIONS(2179),
  },
  [584] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1050),
    [sym_c_style_for_statement] = STATE(1050),
    [sym_while_statement] = STATE(1050),
    [sym_if_statement] = STATE(1050),
    [sym_case_statement] = STATE(1050),
    [sym_function_definition] = STATE(1050),
    [sym_subshell] = STATE(1050),
    [sym_pipeline] = STATE(1050),
    [sym_list] = STATE(1050),
    [sym_negated_command] = STATE(1050),
    [sym_test_command] = STATE(1050),
    [sym_declaration_command] = STATE(1050),
    [sym_unset_command] = STATE(1050),
    [sym_command] = STATE(1050),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1051),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [585] = {
    [sym__expression] = STATE(1053),
    [sym_binary_expression] = STATE(1053),
    [sym_unary_expression] = STATE(1053),
    [sym_postfix_expression] = STATE(1053),
    [sym_parenthesized_expression] = STATE(1053),
    [sym_concatenation] = STATE(1053),
    [sym_string] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_string_expansion] = STATE(44),
    [sym_expansion] = STATE(44),
    [sym_command_substitution] = STATE(44),
    [sym_process_substitution] = STATE(44),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(2185),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [sym__special_characters] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_DOLLAR] = ACTIONS(79),
    [sym_raw_string] = ACTIONS(81),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(85),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [anon_sym_LT_LPAREN] = ACTIONS(89),
    [anon_sym_GT_LPAREN] = ACTIONS(89),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(91),
    [sym_test_operator] = ACTIONS(93),
  },
  [586] = {
    [anon_sym_SEMI] = ACTIONS(2187),
    [anon_sym_SEMI_SEMI] = ACTIONS(2189),
    [anon_sym_AMP_AMP] = ACTIONS(1188),
    [anon_sym_PIPE_PIPE] = ACTIONS(1188),
    [anon_sym_EQ_TILDE] = ACTIONS(1190),
    [anon_sym_EQ_EQ] = ACTIONS(1190),
    [anon_sym_EQ] = ACTIONS(1192),
    [anon_sym_PLUS_EQ] = ACTIONS(1188),
    [anon_sym_LT] = ACTIONS(1192),
    [anon_sym_GT] = ACTIONS(1192),
    [anon_sym_BANG_EQ] = ACTIONS(1188),
    [anon_sym_PLUS] = ACTIONS(1192),
    [anon_sym_DASH] = ACTIONS(1192),
    [anon_sym_DASH_EQ] = ACTIONS(1188),
    [anon_sym_LT_EQ] = ACTIONS(1188),
    [anon_sym_GT_EQ] = ACTIONS(1188),
    [anon_sym_PLUS_PLUS] = ACTIONS(1194),
    [anon_sym_DASH_DASH] = ACTIONS(1194),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1188),
    [anon_sym_LF] = ACTIONS(2189),
    [anon_sym_AMP] = ACTIONS(2187),
  },
  [587] = {
    [anon_sym_RPAREN] = ACTIONS(2191),
    [anon_sym_AMP_AMP] = ACTIONS(1240),
    [anon_sym_PIPE_PIPE] = ACTIONS(1240),
    [anon_sym_EQ_TILDE] = ACTIONS(1242),
    [anon_sym_EQ_EQ] = ACTIONS(1242),
    [anon_sym_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_EQ] = ACTIONS(1240),
    [anon_sym_LT] = ACTIONS(1244),
    [anon_sym_GT] = ACTIONS(1244),
    [anon_sym_BANG_EQ] = ACTIONS(1240),
    [anon_sym_PLUS] = ACTIONS(1244),
    [anon_sym_DASH] = ACTIONS(1244),
    [anon_sym_DASH_EQ] = ACTIONS(1240),
    [anon_sym_LT_EQ] = ACTIONS(1240),
    [anon_sym_GT_EQ] = ACTIONS(1240),
    [anon_sym_PLUS_PLUS] = ACTIONS(1246),
    [anon_sym_DASH_DASH] = ACTIONS(1246),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1240),
  },
  [588] = {
    [anon_sym_SEMI] = ACTIONS(2193),
    [anon_sym_SEMI_SEMI] = ACTIONS(1248),
    [anon_sym_AMP_AMP] = ACTIONS(1188),
    [anon_sym_PIPE_PIPE] = ACTIONS(1188),
    [anon_sym_EQ_TILDE] = ACTIONS(1190),
    [anon_sym_EQ_EQ] = ACTIONS(1190),
    [anon_sym_EQ] = ACTIONS(1192),
    [anon_sym_PLUS_EQ] = ACTIONS(1188),
    [anon_sym_LT] = ACTIONS(1192),
    [anon_sym_GT] = ACTIONS(1192),
    [anon_sym_BANG_EQ] = ACTIONS(1188),
    [anon_sym_PLUS] = ACTIONS(1192),
    [anon_sym_DASH] = ACTIONS(1192),
    [anon_sym_DASH_EQ] = ACTIONS(1188),
    [anon_sym_LT_EQ] = ACTIONS(1188),
    [anon_sym_GT_EQ] = ACTIONS(1188),
    [anon_sym_PLUS_PLUS] = ACTIONS(1194),
    [anon_sym_DASH_DASH] = ACTIONS(1194),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1188),
    [anon_sym_LF] = ACTIONS(1248),
    [anon_sym_AMP] = ACTIONS(2193),
  },
  [589] = {
    [sym_string] = STATE(1056),
    [sym_simple_expansion] = STATE(1056),
    [sym_string_expansion] = STATE(1056),
    [sym_expansion] = STATE(1056),
    [sym_command_substitution] = STATE(1056),
    [sym_process_substitution] = STATE(1056),
    [sym__special_characters] = ACTIONS(2195),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(2195),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(423),
    [anon_sym_GT_LPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2195),
  },
  [590] = {
    [aux_sym_concatenation_repeat1] = STATE(1057),
    [sym__concat] = ACTIONS(1160),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_SEMI_SEMI] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(807),
    [anon_sym_EQ_EQ] = ACTIONS(807),
    [anon_sym_EQ] = ACTIONS(809),
    [anon_sym_PLUS_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_BANG_EQ] = ACTIONS(807),
    [anon_sym_PLUS] = ACTIONS(809),
    [anon_sym_DASH] = ACTIONS(809),
    [anon_sym_DASH_EQ] = ACTIONS(807),
    [anon_sym_LT_EQ] = ACTIONS(807),
    [anon_sym_GT_EQ] = ACTIONS(807),
    [anon_sym_PLUS_PLUS] = ACTIONS(807),
    [anon_sym_DASH_DASH] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(807),
    [anon_sym_AMP] = ACTIONS(809),
  },
  [591] = {
    [sym__concat] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(813),
    [anon_sym_esac] = ACTIONS(811),
    [anon_sym_PIPE] = ACTIONS(813),
    [anon_sym_SEMI_SEMI] = ACTIONS(811),
    [anon_sym_PIPE_AMP] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [anon_sym_EQ_TILDE] = ACTIONS(811),
    [anon_sym_EQ_EQ] = ACTIONS(811),
    [anon_sym_EQ] = ACTIONS(813),
    [anon_sym_PLUS_EQ] = ACTIONS(811),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_BANG_EQ] = ACTIONS(811),
    [anon_sym_PLUS] = ACTIONS(813),
    [anon_sym_DASH] = ACTIONS(813),
    [anon_sym_DASH_EQ] = ACTIONS(811),
    [anon_sym_LT_EQ] = ACTIONS(811),
    [anon_sym_GT_EQ] = ACTIONS(811),
    [anon_sym_PLUS_PLUS] = ACTIONS(811),
    [anon_sym_DASH_DASH] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(811),
    [anon_sym_LF] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(813),
  },
  [592] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(2197),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [593] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(2197),
    [anon_sym_DOLLAR] = ACTIONS(2199),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [594] = {
    [sym__concat] = ACTIONS(845),
    [anon_sym_SEMI] = ACTIONS(847),
    [anon_sym_esac] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(847),
    [anon_sym_SEMI_SEMI] = ACTIONS(845),
    [anon_sym_PIPE_AMP] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [anon_sym_EQ_TILDE] = ACTIONS(845),
    [anon_sym_EQ_EQ] = ACTIONS(845),
    [anon_sym_EQ] = ACTIONS(847),
    [anon_sym_PLUS_EQ] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(847),
    [anon_sym_GT] = ACTIONS(847),
    [anon_sym_BANG_EQ] = ACTIONS(845),
    [anon_sym_PLUS] = ACTIONS(847),
    [anon_sym_DASH] = ACTIONS(847),
    [anon_sym_DASH_EQ] = ACTIONS(845),
    [anon_sym_LT_EQ] = ACTIONS(845),
    [anon_sym_GT_EQ] = ACTIONS(845),
    [anon_sym_PLUS_PLUS] = ACTIONS(845),
    [anon_sym_DASH_DASH] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(845),
    [anon_sym_LF] = ACTIONS(845),
    [anon_sym_AMP] = ACTIONS(847),
  },
  [595] = {
    [sym__concat] = ACTIONS(849),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_esac] = ACTIONS(849),
    [anon_sym_PIPE] = ACTIONS(851),
    [anon_sym_SEMI_SEMI] = ACTIONS(849),
    [anon_sym_PIPE_AMP] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [anon_sym_EQ_TILDE] = ACTIONS(849),
    [anon_sym_EQ_EQ] = ACTIONS(849),
    [anon_sym_EQ] = ACTIONS(851),
    [anon_sym_PLUS_EQ] = ACTIONS(849),
    [anon_sym_LT] = ACTIONS(851),
    [anon_sym_GT] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(849),
    [anon_sym_PLUS] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(851),
    [anon_sym_DASH_EQ] = ACTIONS(849),
    [anon_sym_LT_EQ] = ACTIONS(849),
    [anon_sym_GT_EQ] = ACTIONS(849),
    [anon_sym_PLUS_PLUS] = ACTIONS(849),
    [anon_sym_DASH_DASH] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(849),
    [anon_sym_LF] = ACTIONS(849),
    [anon_sym_AMP] = ACTIONS(851),
  },
  [596] = {
    [sym__concat] = ACTIONS(853),
    [anon_sym_SEMI] = ACTIONS(855),
    [anon_sym_esac] = ACTIONS(853),
    [anon_sym_PIPE] = ACTIONS(855),
    [anon_sym_SEMI_SEMI] = ACTIONS(853),
    [anon_sym_PIPE_AMP] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [anon_sym_EQ_TILDE] = ACTIONS(853),
    [anon_sym_EQ_EQ] = ACTIONS(853),
    [anon_sym_EQ] = ACTIONS(855),
    [anon_sym_PLUS_EQ] = ACTIONS(853),
    [anon_sym_LT] = ACTIONS(855),
    [anon_sym_GT] = ACTIONS(855),
    [anon_sym_BANG_EQ] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(855),
    [anon_sym_DASH] = ACTIONS(855),
    [anon_sym_DASH_EQ] = ACTIONS(853),
    [anon_sym_LT_EQ] = ACTIONS(853),
    [anon_sym_GT_EQ] = ACTIONS(853),
    [anon_sym_PLUS_PLUS] = ACTIONS(853),
    [anon_sym_DASH_DASH] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(853),
    [anon_sym_LF] = ACTIONS(853),
    [anon_sym_AMP] = ACTIONS(855),
  },
  [597] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(2201),
    [sym_comment] = ACTIONS(55),
  },
  [598] = {
    [sym_subscript] = STATE(1063),
    [sym_variable_name] = ACTIONS(2203),
    [anon_sym_DASH] = ACTIONS(2205),
    [anon_sym_DOLLAR] = ACTIONS(2205),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2207),
    [anon_sym_STAR] = ACTIONS(2209),
    [anon_sym_AT] = ACTIONS(2209),
    [anon_sym_QMARK] = ACTIONS(2209),
    [anon_sym_0] = ACTIONS(2207),
    [anon_sym__] = ACTIONS(2207),
  },
  [599] = {
    [sym_concatenation] = STATE(1066),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1066),
    [anon_sym_RBRACE] = ACTIONS(2211),
    [anon_sym_EQ] = ACTIONS(2213),
    [anon_sym_DASH] = ACTIONS(2213),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2215),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2217),
    [anon_sym_COLON] = ACTIONS(2213),
    [anon_sym_COLON_QMARK] = ACTIONS(2213),
    [anon_sym_COLON_DASH] = ACTIONS(2213),
    [anon_sym_PERCENT] = ACTIONS(2213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [600] = {
    [sym_concatenation] = STATE(1069),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1069),
    [anon_sym_RBRACE] = ACTIONS(2219),
    [anon_sym_EQ] = ACTIONS(2221),
    [anon_sym_DASH] = ACTIONS(2221),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2223),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2225),
    [anon_sym_COLON] = ACTIONS(2221),
    [anon_sym_COLON_QMARK] = ACTIONS(2221),
    [anon_sym_COLON_DASH] = ACTIONS(2221),
    [anon_sym_PERCENT] = ACTIONS(2221),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [601] = {
    [anon_sym_SEMI] = ACTIONS(2227),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2229),
    [anon_sym_SEMI_SEMI] = ACTIONS(2231),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2231),
    [anon_sym_AMP] = ACTIONS(2227),
  },
  [602] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2227),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2229),
    [anon_sym_SEMI_SEMI] = ACTIONS(2231),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2231),
    [anon_sym_AMP] = ACTIONS(2227),
  },
  [603] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1072),
    [sym_c_style_for_statement] = STATE(1072),
    [sym_while_statement] = STATE(1072),
    [sym_if_statement] = STATE(1072),
    [sym_case_statement] = STATE(1072),
    [sym_function_definition] = STATE(1072),
    [sym_subshell] = STATE(1072),
    [sym_pipeline] = STATE(1072),
    [sym_list] = STATE(1072),
    [sym_negated_command] = STATE(1072),
    [sym_test_command] = STATE(1072),
    [sym_declaration_command] = STATE(1072),
    [sym_unset_command] = STATE(1072),
    [sym_command] = STATE(1072),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1073),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [604] = {
    [anon_sym_SEMI] = ACTIONS(2233),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2235),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(2229),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2235),
    [anon_sym_AMP] = ACTIONS(2233),
  },
  [605] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2233),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2235),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(2229),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2235),
    [anon_sym_AMP] = ACTIONS(2233),
  },
  [606] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1075),
    [sym_c_style_for_statement] = STATE(1075),
    [sym_while_statement] = STATE(1075),
    [sym_if_statement] = STATE(1075),
    [sym_case_statement] = STATE(1075),
    [sym_function_definition] = STATE(1075),
    [sym_subshell] = STATE(1075),
    [sym_pipeline] = STATE(1075),
    [sym_list] = STATE(1075),
    [sym_negated_command] = STATE(1075),
    [sym_test_command] = STATE(1075),
    [sym_declaration_command] = STATE(1075),
    [sym_unset_command] = STATE(1075),
    [sym_command] = STATE(1075),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(1076),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [607] = {
    [anon_sym_SEMI] = ACTIONS(2237),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2239),
    [anon_sym_SEMI_SEMI] = ACTIONS(2241),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2241),
    [anon_sym_AMP] = ACTIONS(2237),
  },
  [608] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2237),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2239),
    [anon_sym_SEMI_SEMI] = ACTIONS(2241),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2241),
    [anon_sym_AMP] = ACTIONS(2237),
  },
  [609] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1079),
    [sym_c_style_for_statement] = STATE(1079),
    [sym_while_statement] = STATE(1079),
    [sym_if_statement] = STATE(1079),
    [sym_case_statement] = STATE(1079),
    [sym_function_definition] = STATE(1079),
    [sym_subshell] = STATE(1079),
    [sym_pipeline] = STATE(1079),
    [sym_list] = STATE(1079),
    [sym_negated_command] = STATE(1079),
    [sym_test_command] = STATE(1079),
    [sym_declaration_command] = STATE(1079),
    [sym_unset_command] = STATE(1079),
    [sym_command] = STATE(1079),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1080),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [610] = {
    [sym__expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_postfix_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_concatenation] = STATE(1081),
    [sym_string] = STATE(223),
    [sym_simple_expansion] = STATE(223),
    [sym_string_expansion] = STATE(223),
    [sym_expansion] = STATE(223),
    [sym_command_substitution] = STATE(223),
    [sym_process_substitution] = STATE(223),
    [anon_sym_SEMI] = ACTIONS(2187),
    [anon_sym_SEMI_SEMI] = ACTIONS(2189),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(407),
    [sym__special_characters] = ACTIONS(409),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(423),
    [anon_sym_GT_LPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(425),
    [sym_test_operator] = ACTIONS(427),
    [anon_sym_LF] = ACTIONS(2189),
    [anon_sym_AMP] = ACTIONS(2189),
  },
  [611] = {
    [sym__expression] = STATE(1082),
    [sym_binary_expression] = STATE(1082),
    [sym_unary_expression] = STATE(1082),
    [sym_postfix_expression] = STATE(1082),
    [sym_parenthesized_expression] = STATE(1082),
    [sym_concatenation] = STATE(1082),
    [sym_string] = STATE(223),
    [sym_simple_expansion] = STATE(223),
    [sym_string_expansion] = STATE(223),
    [sym_expansion] = STATE(223),
    [sym_command_substitution] = STATE(223),
    [sym_process_substitution] = STATE(223),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(407),
    [sym__special_characters] = ACTIONS(409),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(423),
    [anon_sym_GT_LPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(425),
    [sym_test_operator] = ACTIONS(427),
  },
  [612] = {
    [sym__expression] = STATE(1082),
    [sym_binary_expression] = STATE(1082),
    [sym_unary_expression] = STATE(1082),
    [sym_postfix_expression] = STATE(1082),
    [sym_parenthesized_expression] = STATE(1082),
    [sym_concatenation] = STATE(1082),
    [sym_string] = STATE(223),
    [sym_simple_expansion] = STATE(223),
    [sym_string_expansion] = STATE(223),
    [sym_expansion] = STATE(223),
    [sym_command_substitution] = STATE(223),
    [sym_process_substitution] = STATE(223),
    [sym_regex] = ACTIONS(2243),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(407),
    [sym__special_characters] = ACTIONS(409),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(423),
    [anon_sym_GT_LPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(425),
    [sym_test_operator] = ACTIONS(427),
  },
  [613] = {
    [anon_sym_SEMI] = ACTIONS(1318),
    [anon_sym_SEMI_SEMI] = ACTIONS(1316),
    [anon_sym_AMP_AMP] = ACTIONS(1316),
    [anon_sym_PIPE_PIPE] = ACTIONS(1316),
    [anon_sym_EQ_TILDE] = ACTIONS(1316),
    [anon_sym_EQ_EQ] = ACTIONS(1316),
    [anon_sym_EQ] = ACTIONS(1318),
    [anon_sym_PLUS_EQ] = ACTIONS(1316),
    [anon_sym_LT] = ACTIONS(1318),
    [anon_sym_GT] = ACTIONS(1318),
    [anon_sym_BANG_EQ] = ACTIONS(1316),
    [anon_sym_PLUS] = ACTIONS(1318),
    [anon_sym_DASH] = ACTIONS(1318),
    [anon_sym_DASH_EQ] = ACTIONS(1316),
    [anon_sym_LT_EQ] = ACTIONS(1316),
    [anon_sym_GT_EQ] = ACTIONS(1316),
    [anon_sym_PLUS_PLUS] = ACTIONS(1316),
    [anon_sym_DASH_DASH] = ACTIONS(1316),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1316),
    [anon_sym_LF] = ACTIONS(1316),
    [anon_sym_AMP] = ACTIONS(1318),
  },
  [614] = {
    [aux_sym_concatenation_repeat1] = STATE(1085),
    [sym__concat] = ACTIONS(2245),
    [anon_sym_SEMI] = ACTIONS(2107),
    [anon_sym_SEMI_SEMI] = ACTIONS(2105),
    [sym__special_characters] = ACTIONS(2105),
    [anon_sym_DQUOTE] = ACTIONS(2105),
    [anon_sym_DOLLAR] = ACTIONS(2107),
    [sym_raw_string] = ACTIONS(2105),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2105),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2105),
    [anon_sym_BQUOTE] = ACTIONS(2105),
    [anon_sym_LT_LPAREN] = ACTIONS(2105),
    [anon_sym_GT_LPAREN] = ACTIONS(2105),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2107),
    [anon_sym_LF] = ACTIONS(2105),
    [anon_sym_AMP] = ACTIONS(2105),
  },
  [615] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(1088),
    [anon_sym_DQUOTE] = ACTIONS(2247),
    [anon_sym_DOLLAR] = ACTIONS(2249),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [616] = {
    [sym_string] = STATE(1090),
    [anon_sym_DASH] = ACTIONS(2251),
    [anon_sym_DQUOTE] = ACTIONS(1198),
    [anon_sym_DOLLAR] = ACTIONS(2251),
    [sym_raw_string] = ACTIONS(2253),
    [anon_sym_POUND] = ACTIONS(2251),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2255),
    [anon_sym_STAR] = ACTIONS(2257),
    [anon_sym_AT] = ACTIONS(2257),
    [anon_sym_QMARK] = ACTIONS(2257),
    [anon_sym_0] = ACTIONS(2255),
    [anon_sym__] = ACTIONS(2255),
  },
  [617] = {
    [aux_sym_concatenation_repeat1] = STATE(1085),
    [sym__concat] = ACTIONS(2245),
    [anon_sym_SEMI] = ACTIONS(2123),
    [anon_sym_SEMI_SEMI] = ACTIONS(2121),
    [sym__special_characters] = ACTIONS(2121),
    [anon_sym_DQUOTE] = ACTIONS(2121),
    [anon_sym_DOLLAR] = ACTIONS(2123),
    [sym_raw_string] = ACTIONS(2121),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2121),
    [anon_sym_BQUOTE] = ACTIONS(2121),
    [anon_sym_LT_LPAREN] = ACTIONS(2121),
    [anon_sym_GT_LPAREN] = ACTIONS(2121),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2123),
    [anon_sym_LF] = ACTIONS(2121),
    [anon_sym_AMP] = ACTIONS(2121),
  },
  [618] = {
    [sym_subscript] = STATE(1095),
    [sym_variable_name] = ACTIONS(2259),
    [anon_sym_BANG] = ACTIONS(2261),
    [anon_sym_DASH] = ACTIONS(2263),
    [anon_sym_DOLLAR] = ACTIONS(2263),
    [anon_sym_POUND] = ACTIONS(2261),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2265),
    [anon_sym_STAR] = ACTIONS(2267),
    [anon_sym_AT] = ACTIONS(2267),
    [anon_sym_QMARK] = ACTIONS(2267),
    [anon_sym_0] = ACTIONS(2265),
    [anon_sym__] = ACTIONS(2265),
  },
  [619] = {
    [sym__terminated_statement] = STATE(1098),
    [sym_for_statement] = STATE(1096),
    [sym_c_style_for_statement] = STATE(1096),
    [sym_while_statement] = STATE(1096),
    [sym_if_statement] = STATE(1096),
    [sym_case_statement] = STATE(1096),
    [sym_function_definition] = STATE(1096),
    [sym_subshell] = STATE(1096),
    [sym_pipeline] = STATE(1096),
    [sym_list] = STATE(1096),
    [sym_negated_command] = STATE(1096),
    [sym_test_command] = STATE(1096),
    [sym_declaration_command] = STATE(1096),
    [sym_unset_command] = STATE(1096),
    [sym_command] = STATE(1096),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1097),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(1098),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [620] = {
    [sym__terminated_statement] = STATE(1101),
    [sym_for_statement] = STATE(1099),
    [sym_c_style_for_statement] = STATE(1099),
    [sym_while_statement] = STATE(1099),
    [sym_if_statement] = STATE(1099),
    [sym_case_statement] = STATE(1099),
    [sym_function_definition] = STATE(1099),
    [sym_subshell] = STATE(1099),
    [sym_pipeline] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_negated_command] = STATE(1099),
    [sym_test_command] = STATE(1099),
    [sym_declaration_command] = STATE(1099),
    [sym_unset_command] = STATE(1099),
    [sym_command] = STATE(1099),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(1100),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(1101),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [621] = {
    [sym__terminated_statement] = STATE(1104),
    [sym_for_statement] = STATE(1102),
    [sym_c_style_for_statement] = STATE(1102),
    [sym_while_statement] = STATE(1102),
    [sym_if_statement] = STATE(1102),
    [sym_case_statement] = STATE(1102),
    [sym_function_definition] = STATE(1102),
    [sym_subshell] = STATE(1102),
    [sym_pipeline] = STATE(1102),
    [sym_list] = STATE(1102),
    [sym_negated_command] = STATE(1102),
    [sym_test_command] = STATE(1102),
    [sym_declaration_command] = STATE(1102),
    [sym_unset_command] = STATE(1102),
    [sym_command] = STATE(1102),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1103),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(1104),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [622] = {
    [sym_concatenation] = STATE(1106),
    [sym_string] = STATE(617),
    [sym_simple_expansion] = STATE(617),
    [sym_string_expansion] = STATE(617),
    [sym_expansion] = STATE(617),
    [sym_command_substitution] = STATE(617),
    [sym_process_substitution] = STATE(617),
    [aux_sym_for_statement_repeat1] = STATE(1106),
    [anon_sym_SEMI] = ACTIONS(2269),
    [anon_sym_SEMI_SEMI] = ACTIONS(2271),
    [sym__special_characters] = ACTIONS(1196),
    [anon_sym_DQUOTE] = ACTIONS(1198),
    [anon_sym_DOLLAR] = ACTIONS(1200),
    [sym_raw_string] = ACTIONS(1202),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1204),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1206),
    [anon_sym_BQUOTE] = ACTIONS(1208),
    [anon_sym_LT_LPAREN] = ACTIONS(1210),
    [anon_sym_GT_LPAREN] = ACTIONS(1210),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2273),
    [anon_sym_LF] = ACTIONS(2271),
    [anon_sym_AMP] = ACTIONS(2271),
  },
  [623] = {
    [sym__terminated_statement] = STATE(1108),
    [sym_for_statement] = STATE(545),
    [sym_c_style_for_statement] = STATE(545),
    [sym_while_statement] = STATE(545),
    [sym_if_statement] = STATE(545),
    [sym_case_statement] = STATE(545),
    [sym_function_definition] = STATE(545),
    [sym_subshell] = STATE(545),
    [sym_pipeline] = STATE(545),
    [sym_list] = STATE(545),
    [sym_negated_command] = STATE(545),
    [sym_test_command] = STATE(545),
    [sym_declaration_command] = STATE(545),
    [sym_unset_command] = STATE(545),
    [sym_command] = STATE(545),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(546),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(67),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(1108),
    [aux_sym_command_repeat1] = STATE(67),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_done] = ACTIONS(2275),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(109),
    [anon_sym_typeset] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_readonly] = ACTIONS(109),
    [anon_sym_local] = ACTIONS(109),
    [anon_sym_unset] = ACTIONS(111),
    [anon_sym_unsetenv] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(117),
  },
  [624] = {
    [ts_builtin_sym_end] = ACTIONS(2277),
    [anon_sym_SEMI] = ACTIONS(2279),
    [anon_sym_esac] = ACTIONS(2277),
    [anon_sym_PIPE] = ACTIONS(2279),
    [anon_sym_RPAREN] = ACTIONS(2277),
    [anon_sym_SEMI_SEMI] = ACTIONS(2277),
    [anon_sym_PIPE_AMP] = ACTIONS(2277),
    [anon_sym_AMP_AMP] = ACTIONS(2277),
    [anon_sym_PIPE_PIPE] = ACTIONS(2277),
    [anon_sym_BQUOTE] = ACTIONS(2277),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2277),
    [anon_sym_AMP] = ACTIONS(2279),
  },
  [625] = {
    [anon_sym_RPAREN] = ACTIONS(2281),
    [anon_sym_AMP_AMP] = ACTIONS(1240),
    [anon_sym_PIPE_PIPE] = ACTIONS(1240),
    [anon_sym_EQ_TILDE] = ACTIONS(1242),
    [anon_sym_EQ_EQ] = ACTIONS(1242),
    [anon_sym_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_EQ] = ACTIONS(1240),
    [anon_sym_LT] = ACTIONS(1244),
    [anon_sym_GT] = ACTIONS(1244),
    [anon_sym_BANG_EQ] = ACTIONS(1240),
    [anon_sym_PLUS] = ACTIONS(1244),
    [anon_sym_DASH] = ACTIONS(1244),
    [anon_sym_DASH_EQ] = ACTIONS(1240),
    [anon_sym_LT_EQ] = ACTIONS(1240),
    [anon_sym_GT_EQ] = ACTIONS(1240),
    [anon_sym_PLUS_PLUS] = ACTIONS(1246),
    [anon_sym_DASH_DASH] = ACTIONS(1246),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1240),
  },
  [626] = {
    [anon_sym_RPAREN] = ACTIONS(1248),
    [anon_sym_AMP_AMP] = ACTIONS(1240),
    [anon_sym_PIPE_PIPE] = ACTIONS(1240),
    [anon_sym_EQ_TILDE] = ACTIONS(1242),
    [anon_sym_EQ_EQ] = ACTIONS(1242),
    [anon_sym_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_EQ] = ACTIONS(1240),
    [anon_sym_LT] = ACTIONS(1244),
    [anon_sym_GT] = ACTIONS(1244),
    [anon_sym_BANG_EQ] = ACTIONS(1240),
    [anon_sym_PLUS] = ACTIONS(1244),
    [anon_sym_DASH] = ACTIONS(1244),
    [anon_sym_DASH_EQ] = ACTIONS(1240),
    [anon_sym_LT_EQ] = ACTIONS(1240),
    [anon_sym_GT_EQ] = ACTIONS(1240),
    [anon_sym_PLUS_PLUS] = ACTIONS(1246),
    [anon_sym_DASH_DASH] = ACTIONS(1246),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1240),
  },
  [627] = {
    [sym_string] = STATE(1110),
    [sym_simple_expansion] = STATE(1110),
    [sym_string_expansion] = STATE(1110),
    [sym_expansion] = STATE(1110),
    [sym_command_substitution] = STATE(1110),
    [sym_process_substitution] = STATE(1110),
    [sym__special_characters] = ACTIONS(2283),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(2283),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2283),
  },
  [628] = {
    [aux_sym_concatenation_repeat1] = STATE(1111),
    [sym__concat] = ACTIONS(1214),
    [anon_sym_RPAREN] = ACTIONS(807),
    [anon_sym_AMP_AMP] = ACTIONS(807),
    [anon_sym_PIPE_PIPE] = ACTIONS(807),
    [anon_sym_EQ_TILDE] = ACTIONS(807),
    [anon_sym_EQ_EQ] = ACTIONS(807),
    [anon_sym_EQ] = ACTIONS(809),
    [anon_sym_PLUS_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(809),
    [anon_sym_GT] = ACTIONS(809),
    [anon_sym_BANG_EQ] = ACTIONS(807),
    [anon_sym_PLUS] = ACTIONS(809),
    [anon_sym_DASH] = ACTIONS(809),
    [anon_sym_DASH_EQ] = ACTIONS(807),
    [anon_sym_LT_EQ] = ACTIONS(807),
    [anon_sym_GT_EQ] = ACTIONS(807),
    [anon_sym_PLUS_PLUS] = ACTIONS(807),
    [anon_sym_DASH_DASH] = ACTIONS(807),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(807),
  },
  [629] = {
    [sym__concat] = ACTIONS(811),
    [anon_sym_PIPE] = ACTIONS(813),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_AMP_AMP] = ACTIONS(811),
    [anon_sym_PIPE_PIPE] = ACTIONS(811),
    [anon_sym_EQ_TILDE] = ACTIONS(811),
    [anon_sym_EQ_EQ] = ACTIONS(811),
    [anon_sym_EQ] = ACTIONS(813),
    [anon_sym_PLUS_EQ] = ACTIONS(811),
    [anon_sym_LT] = ACTIONS(813),
    [anon_sym_GT] = ACTIONS(813),
    [anon_sym_BANG_EQ] = ACTIONS(811),
    [anon_sym_PLUS] = ACTIONS(813),
    [anon_sym_DASH] = ACTIONS(813),
    [anon_sym_DASH_EQ] = ACTIONS(811),
    [anon_sym_LT_EQ] = ACTIONS(811),
    [anon_sym_GT_EQ] = ACTIONS(811),
    [anon_sym_PLUS_PLUS] = ACTIONS(811),
    [anon_sym_DASH_DASH] = ACTIONS(811),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(811),
  },
  [630] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(2285),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [631] = {
    [sym_simple_expansion] = STATE(148),
    [sym_expansion] = STATE(148),
    [sym_command_substitution] = STATE(148),
    [aux_sym_string_repeat1] = STATE(473),
    [anon_sym_DQUOTE] = ACTIONS(2285),
    [anon_sym_DOLLAR] = ACTIONS(2287),
    [sym__string_content] = ACTIONS(273),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(277),
    [anon_sym_BQUOTE] = ACTIONS(279),
    [sym_comment] = ACTIONS(281),
  },
  [632] = {
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(847),
    [anon_sym_RPAREN] = ACTIONS(845),
    [anon_sym_AMP_AMP] = ACTIONS(845),
    [anon_sym_PIPE_PIPE] = ACTIONS(845),
    [anon_sym_EQ_TILDE] = ACTIONS(845),
    [anon_sym_EQ_EQ] = ACTIONS(845),
    [anon_sym_EQ] = ACTIONS(847),
    [anon_sym_PLUS_EQ] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(847),
    [anon_sym_GT] = ACTIONS(847),
    [anon_sym_BANG_EQ] = ACTIONS(845),
    [anon_sym_PLUS] = ACTIONS(847),
    [anon_sym_DASH] = ACTIONS(847),
    [anon_sym_DASH_EQ] = ACTIONS(845),
    [anon_sym_LT_EQ] = ACTIONS(845),
    [anon_sym_GT_EQ] = ACTIONS(845),
    [anon_sym_PLUS_PLUS] = ACTIONS(845),
    [anon_sym_DASH_DASH] = ACTIONS(845),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(845),
  },
  [633] = {
    [sym__concat] = ACTIONS(849),
    [anon_sym_PIPE] = ACTIONS(851),
    [anon_sym_RPAREN] = ACTIONS(849),
    [anon_sym_AMP_AMP] = ACTIONS(849),
    [anon_sym_PIPE_PIPE] = ACTIONS(849),
    [anon_sym_EQ_TILDE] = ACTIONS(849),
    [anon_sym_EQ_EQ] = ACTIONS(849),
    [anon_sym_EQ] = ACTIONS(851),
    [anon_sym_PLUS_EQ] = ACTIONS(849),
    [anon_sym_LT] = ACTIONS(851),
    [anon_sym_GT] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(849),
    [anon_sym_PLUS] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(851),
    [anon_sym_DASH_EQ] = ACTIONS(849),
    [anon_sym_LT_EQ] = ACTIONS(849),
    [anon_sym_GT_EQ] = ACTIONS(849),
    [anon_sym_PLUS_PLUS] = ACTIONS(849),
    [anon_sym_DASH_DASH] = ACTIONS(849),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(849),
  },
  [634] = {
    [sym__concat] = ACTIONS(853),
    [anon_sym_PIPE] = ACTIONS(855),
    [anon_sym_RPAREN] = ACTIONS(853),
    [anon_sym_AMP_AMP] = ACTIONS(853),
    [anon_sym_PIPE_PIPE] = ACTIONS(853),
    [anon_sym_EQ_TILDE] = ACTIONS(853),
    [anon_sym_EQ_EQ] = ACTIONS(853),
    [anon_sym_EQ] = ACTIONS(855),
    [anon_sym_PLUS_EQ] = ACTIONS(853),
    [anon_sym_LT] = ACTIONS(855),
    [anon_sym_GT] = ACTIONS(855),
    [anon_sym_BANG_EQ] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(855),
    [anon_sym_DASH] = ACTIONS(855),
    [anon_sym_DASH_EQ] = ACTIONS(853),
    [anon_sym_LT_EQ] = ACTIONS(853),
    [anon_sym_GT_EQ] = ACTIONS(853),
    [anon_sym_PLUS_PLUS] = ACTIONS(853),
    [anon_sym_DASH_DASH] = ACTIONS(853),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(853),
  },
  [635] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(2289),
    [sym_comment] = ACTIONS(55),
  },
  [636] = {
    [sym_subscript] = STATE(1117),
    [sym_variable_name] = ACTIONS(2291),
    [anon_sym_DASH] = ACTIONS(2293),
    [anon_sym_DOLLAR] = ACTIONS(2293),
    [sym_comment] = ACTIONS(55),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2295),
    [anon_sym_STAR] = ACTIONS(2297),
    [anon_sym_AT] = ACTIONS(2297),
    [anon_sym_QMARK] = ACTIONS(2297),
    [anon_sym_0] = ACTIONS(2295),
    [anon_sym__] = ACTIONS(2295),
  },
  [637] = {
    [sym_concatenation] = STATE(1120),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1120),
    [anon_sym_RBRACE] = ACTIONS(2299),
    [anon_sym_EQ] = ACTIONS(2301),
    [anon_sym_DASH] = ACTIONS(2301),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2303),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2305),
    [anon_sym_COLON] = ACTIONS(2301),
    [anon_sym_COLON_QMARK] = ACTIONS(2301),
    [anon_sym_COLON_DASH] = ACTIONS(2301),
    [anon_sym_PERCENT] = ACTIONS(2301),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [638] = {
    [sym_concatenation] = STATE(1123),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1123),
    [anon_sym_RBRACE] = ACTIONS(2307),
    [anon_sym_EQ] = ACTIONS(2309),
    [anon_sym_DASH] = ACTIONS(2309),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2311),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2313),
    [anon_sym_COLON] = ACTIONS(2309),
    [anon_sym_COLON_QMARK] = ACTIONS(2309),
    [anon_sym_COLON_DASH] = ACTIONS(2309),
    [anon_sym_PERCENT] = ACTIONS(2309),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [639] = {
    [anon_sym_SEMI] = ACTIONS(2315),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2317),
    [anon_sym_SEMI_SEMI] = ACTIONS(2319),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2319),
    [anon_sym_AMP] = ACTIONS(2315),
  },
  [640] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2315),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2317),
    [anon_sym_SEMI_SEMI] = ACTIONS(2319),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2319),
    [anon_sym_AMP] = ACTIONS(2315),
  },
  [641] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1126),
    [sym_c_style_for_statement] = STATE(1126),
    [sym_while_statement] = STATE(1126),
    [sym_if_statement] = STATE(1126),
    [sym_case_statement] = STATE(1126),
    [sym_function_definition] = STATE(1126),
    [sym_subshell] = STATE(1126),
    [sym_pipeline] = STATE(1126),
    [sym_list] = STATE(1126),
    [sym_negated_command] = STATE(1126),
    [sym_test_command] = STATE(1126),
    [sym_declaration_command] = STATE(1126),
    [sym_unset_command] = STATE(1126),
    [sym_command] = STATE(1126),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1127),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [642] = {
    [anon_sym_SEMI] = ACTIONS(2321),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2323),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(2317),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2323),
    [anon_sym_AMP] = ACTIONS(2321),
  },
  [643] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2321),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2323),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(2317),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2323),
    [anon_sym_AMP] = ACTIONS(2321),
  },
  [644] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1129),
    [sym_c_style_for_statement] = STATE(1129),
    [sym_while_statement] = STATE(1129),
    [sym_if_statement] = STATE(1129),
    [sym_case_statement] = STATE(1129),
    [sym_function_definition] = STATE(1129),
    [sym_subshell] = STATE(1129),
    [sym_pipeline] = STATE(1129),
    [sym_list] = STATE(1129),
    [sym_negated_command] = STATE(1129),
    [sym_test_command] = STATE(1129),
    [sym_declaration_command] = STATE(1129),
    [sym_unset_command] = STATE(1129),
    [sym_command] = STATE(1129),
    [sym_command_name] = STATE(173),
    [sym_variable_assignment] = STATE(1130),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(176),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(176),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_typeset] = ACTIONS(317),
    [anon_sym_export] = ACTIONS(317),
    [anon_sym_readonly] = ACTIONS(317),
    [anon_sym_local] = ACTIONS(317),
    [anon_sym_unset] = ACTIONS(319),
    [anon_sym_unsetenv] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(321),
  },
  [645] = {
    [anon_sym_SEMI] = ACTIONS(2325),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2327),
    [anon_sym_SEMI_SEMI] = ACTIONS(2329),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2329),
    [anon_sym_AMP] = ACTIONS(2325),
  },
  [646] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2325),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2327),
    [anon_sym_SEMI_SEMI] = ACTIONS(2329),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2329),
    [anon_sym_AMP] = ACTIONS(2325),
  },
  [647] = {
    [sym__terminated_statement] = STATE(198),
    [sym_for_statement] = STATE(1133),
    [sym_c_style_for_statement] = STATE(1133),
    [sym_while_statement] = STATE(1133),
    [sym_if_statement] = STATE(1133),
    [sym_case_statement] = STATE(1133),
    [sym_function_definition] = STATE(1133),
    [sym_subshell] = STATE(1133),
    [sym_pipeline] = STATE(1133),
    [sym_list] = STATE(1133),
    [sym_negated_command] = STATE(1133),
    [sym_test_command] = STATE(1133),
    [sym_declaration_command] = STATE(1133),
    [sym_unset_command] = STATE(1133),
    [sym_command] = STATE(1133),
    [sym_command_name] = STATE(92),
    [sym_variable_assignment] = STATE(1134),
    [sym_subscript] = STATE(94),
    [sym_file_redirect] = STATE(96),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__statements_repeat1] = STATE(198),
    [aux_sym_command_repeat1] = STATE(96),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(149),
    [anon_sym_declare] = ACTIONS(151),
    [anon_sym_typeset] = ACTIONS(151),
    [anon_sym_export] = ACTIONS(151),
    [anon_sym_readonly] = ACTIONS(151),
    [anon_sym_local] = ACTIONS(151),
    [anon_sym_unset] = ACTIONS(153),
    [anon_sym_unsetenv] = ACTIONS(153),
    [anon_sym_LT] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(35),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [sym__special_characters] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_DOLLAR] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(157),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(159),
  },
  [648] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(2331),
    [anon_sym_AMP_AMP] = ACTIONS(2331),
    [anon_sym_PIPE_PIPE] = ACTIONS(2331),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(2331),
    [anon_sym_EQ_TILDE] = ACTIONS(2331),
    [anon_sym_EQ_EQ] = ACTIONS(2331),
    [anon_sym_EQ] = ACTIONS(2333),
    [anon_sym_PLUS_EQ] = ACTIONS(2331),
    [anon_sym_LT] = ACTIONS(2333),
    [anon_sym_GT] = ACTIONS(2333),
    [anon_sym_BANG_EQ] = ACTIONS(2331),
    [anon_sym_PLUS] = ACTIONS(2333),
    [anon_sym_DASH] = ACTIONS(2333),
    [anon_sym_DASH_EQ] = ACTIONS(2331),
    [anon_sym_LT_EQ] = ACTIONS(2331),
    [anon_sym_GT_EQ] = ACTIONS(2331),
    [anon_sym_PLUS_PLUS] = ACTIONS(2331),
    [anon_sym_DASH_DASH] = ACTIONS(2331),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(2331),
  },
  [649] = {
    [sym__expression] = STATE(1135),
    [sym_binary_expression] = STATE(1135),
    [sym_unary_expression] = STATE(1135),
    [sym_postfix_expression] = STATE(1135),
    [sym_parenthesized_expression] = STATE(1135),
    [sym_concatenation] = STATE(1135),
    [sym_string] = STATE(236),
    [sym_simple_expansion] = STATE(236),
    [sym_string_expansion] = STATE(236),
    [sym_expansion] = STATE(236),
    [sym_command_substitution] = STATE(236),
    [sym_process_substitution] = STATE(236),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [sym__special_characters] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(455),
    [sym_test_operator] = ACTIONS(457),
  },
  [650] = {
    [sym__expression] = STATE(1135),
    [sym_binary_expression] = STATE(1135),
    [sym_unary_expression] = STATE(1135),
    [sym_postfix_expression] = STATE(1135),
    [sym_parenthesized_expression] = STATE(1135),
    [sym_concatenation] = STATE(1135),
    [sym_string] = STATE(236),
    [sym_simple_expansion] = STATE(236),
    [sym_string_expansion] = STATE(236),
    [sym_expansion] = STATE(236),
    [sym_command_substitution] = STATE(236),
    [sym_process_substitution] = STATE(236),
    [sym_regex] = ACTIONS(2335),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [sym__special_characters] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(443),
    [sym_raw_string] = ACTIONS(445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(451),
    [anon_sym_LT_LPAREN] = ACTIONS(453),
    [anon_sym_GT_LPAREN] = ACTIONS(453),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(455),
    [sym_test_operator] = ACTIONS(457),
  },
  [651] = {
    [anon_sym_RPAREN] = ACTIONS(1316),
    [anon_sym_AMP_AMP] = ACTIONS(1316),
    [anon_sym_PIPE_PIPE] = ACTIONS(1316),
    [anon_sym_EQ_TILDE] = ACTIONS(1316),
    [anon_sym_EQ_EQ] = ACTIONS(1316),
    [anon_sym_EQ] = ACTIONS(1318),
    [anon_sym_PLUS_EQ] = ACTIONS(1316),
    [anon_sym_LT] = ACTIONS(1318),
    [anon_sym_GT] = ACTIONS(1318),
    [anon_sym_BANG_EQ] = ACTIONS(1316),
    [anon_sym_PLUS] = ACTIONS(1318),
    [anon_sym_DASH] = ACTIONS(1318),
    [anon_sym_DASH_EQ] = ACTIONS(1316),
    [anon_sym_LT_EQ] = ACTIONS(1316),
    [anon_sym_GT_EQ] = ACTIONS(1316),
    [anon_sym_PLUS_PLUS] = ACTIONS(1316),
    [anon_sym_DASH_DASH] = ACTIONS(1316),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1316),
  },
  [652] = {
    [sym__concat] = ACTIONS(1763),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1763),
    [anon_sym_AMP_AMP] = ACTIONS(1763),
    [anon_sym_PIPE_PIPE] = ACTIONS(1763),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1763),
    [anon_sym_EQ_TILDE] = ACTIONS(1763),
    [anon_sym_EQ_EQ] = ACTIONS(1763),
    [anon_sym_EQ] = ACTIONS(1765),
    [anon_sym_PLUS_EQ] = ACTIONS(1763),
    [anon_sym_LT] = ACTIONS(1765),
    [anon_sym_GT] = ACTIONS(1765),
    [anon_sym_BANG_EQ] = ACTIONS(1763),
    [anon_sym_PLUS] = ACTIONS(1765),
    [anon_sym_DASH] = ACTIONS(1765),
    [anon_sym_DASH_EQ] = ACTIONS(1763),
    [anon_sym_LT_EQ] = ACTIONS(1763),
    [anon_sym_GT_EQ] = ACTIONS(1763),
    [anon_sym_PLUS_PLUS] = ACTIONS(1763),
    [anon_sym_DASH_DASH] = ACTIONS(1763),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1763),
  },
  [653] = {
    [aux_sym_concatenation_repeat1] = STATE(653),
    [sym__concat] = ACTIONS(2337),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1763),
    [anon_sym_AMP_AMP] = ACTIONS(1763),
    [anon_sym_PIPE_PIPE] = ACTIONS(1763),
    [anon_sym_EQ_TILDE] = ACTIONS(1763),
    [anon_sym_EQ_EQ] = ACTIONS(1763),
    [anon_sym_EQ] = ACTIONS(1765),
    [anon_sym_PLUS_EQ] = ACTIONS(1763),
    [anon_sym_LT] = ACTIONS(1765),
    [anon_sym_GT] = ACTIONS(1765),
    [anon_sym_BANG_EQ] = ACTIONS(1763),
    [anon_sym_PLUS] = ACTIONS(1765),
    [anon_sym_DASH] = ACTIONS(1765),
    [anon_sym_DASH_EQ] = ACTIONS(1763),
    [anon_sym_LT_EQ] = ACTIONS(1763),
    [anon_sym_GT_EQ] = ACTIONS(1763),
    [anon_sym_PLUS_PLUS] = ACTIONS(1763),
    [anon_sym_DASH_DASH] = ACTIONS(1763),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1763),
  },
  [654] = {
    [sym__concat] = ACTIONS(1770),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1770),
    [anon_sym_AMP_AMP] = ACTIONS(1770),
    [anon_sym_PIPE_PIPE] = ACTIONS(1770),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1770),
    [anon_sym_EQ_TILDE] = ACTIONS(1770),
    [anon_sym_EQ_EQ] = ACTIONS(1770),
    [anon_sym_EQ] = ACTIONS(1772),
    [anon_sym_PLUS_EQ] = ACTIONS(1770),
    [anon_sym_LT] = ACTIONS(1772),
    [anon_sym_GT] = ACTIONS(1772),
    [anon_sym_BANG_EQ] = ACTIONS(1770),
    [anon_sym_PLUS] = ACTIONS(1772),
    [anon_sym_DASH] = ACTIONS(1772),
    [anon_sym_DASH_EQ] = ACTIONS(1770),
    [anon_sym_LT_EQ] = ACTIONS(1770),
    [anon_sym_GT_EQ] = ACTIONS(1770),
    [anon_sym_PLUS_PLUS] = ACTIONS(1770),
    [anon_sym_DASH_DASH] = ACTIONS(1770),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1770),
  },
  [655] = {
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_DQUOTE] = ACTIONS(2340),
    [anon_sym_DOLLAR] = ACTIONS(819),
    [sym__string_content] = ACTIONS(821),
    [anon_sym_POUND] = ACTIONS(815),
    [sym_comment] = ACTIONS(281),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(823),
    [anon_sym_STAR] = ACTIONS(825),
    [anon_sym_AT] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(825),
    [anon_sym_0] = ACTIONS(823),
    [anon_sym__] = ACTIONS(823),
  },
  [656] = {
    [sym_concatenation] = STATE(1141),
    [sym_string] = STATE(1140),
    [sym_simple_expansion] = STATE(1140),
    [sym_string_expansion] = STATE(1140),
    [sym_expansion] = STATE(1140),
    [sym_command_substitution] = STATE(1140),
    [sym_process_substitution] = STATE(1140),
    [anon_sym_RBRACE] = ACTIONS(2342),
    [sym__special_characters] = ACTIONS(2344),
    [anon_sym_DQUOTE] = ACTIONS(1841),
    [anon_sym_DOLLAR] = ACTIONS(1843),
    [sym_raw_string] = ACTIONS(2346),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1847),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1849),
    [anon_sym_BQUOTE] = ACTIONS(1851),
    [anon_sym_LT_LPAREN] = ACTIONS(1853),
    [anon_sym_GT_LPAREN] = ACTIONS(1853),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(2346),
  },
  [657] = {
    [anon_sym_LBRACK] = ACTIONS(857),
    [anon_sym_EQ] = ACTIONS(2348),
    [sym_comment] = ACTIONS(55),
  },
  [658] = {
    [sym_concatenation] = STATE(1145),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1145),
    [anon_sym_RBRACE] = ACTIONS(2350),
    [anon_sym_EQ] = ACTIONS(2352),
    [anon_sym_DASH] = ACTIONS(2352),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2354),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2356),
    [anon_sym_COLON] = ACTIONS(2352),
    [anon_sym_COLON_QMARK] = ACTIONS(2352),
    [anon_sym_COLON_DASH] = ACTIONS(2352),
    [anon_sym_PERCENT] = ACTIONS(2352),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [659] = {
    [sym_concatenation] = STATE(1147),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1147),
    [anon_sym_RBRACE] = ACTIONS(2342),
    [anon_sym_EQ] = ACTIONS(2358),
    [anon_sym_DASH] = ACTIONS(2358),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2360),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_SLASH] = ACTIONS(2362),
    [anon_sym_COLON] = ACTIONS(2358),
    [anon_sym_COLON_QMARK] = ACTIONS(2358),
    [anon_sym_COLON_DASH] = ACTIONS(2358),
    [anon_sym_PERCENT] = ACTIONS(2358),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [660] = {
    [sym__concat] = ACTIONS(1871),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1871),
    [anon_sym_AMP_AMP] = ACTIONS(1871),
    [anon_sym_PIPE_PIPE] = ACTIONS(1871),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1871),
    [anon_sym_EQ_TILDE] = ACTIONS(1871),
    [anon_sym_EQ_EQ] = ACTIONS(1871),
    [anon_sym_EQ] = ACTIONS(1873),
    [anon_sym_PLUS_EQ] = ACTIONS(1871),
    [anon_sym_LT] = ACTIONS(1873),
    [anon_sym_GT] = ACTIONS(1873),
    [anon_sym_BANG_EQ] = ACTIONS(1871),
    [anon_sym_PLUS] = ACTIONS(1873),
    [anon_sym_DASH] = ACTIONS(1873),
    [anon_sym_DASH_EQ] = ACTIONS(1871),
    [anon_sym_LT_EQ] = ACTIONS(1871),
    [anon_sym_GT_EQ] = ACTIONS(1871),
    [anon_sym_PLUS_PLUS] = ACTIONS(1871),
    [anon_sym_DASH_DASH] = ACTIONS(1871),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1871),
  },
  [661] = {
    [sym_concatenation] = STATE(1150),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1150),
    [sym_regex] = ACTIONS(2364),
    [anon_sym_RBRACE] = ACTIONS(2366),
    [anon_sym_EQ] = ACTIONS(2368),
    [anon_sym_DASH] = ACTIONS(2368),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2370),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(2368),
    [anon_sym_COLON_QMARK] = ACTIONS(2368),
    [anon_sym_COLON_DASH] = ACTIONS(2368),
    [anon_sym_PERCENT] = ACTIONS(2368),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [662] = {
    [sym_concatenation] = STATE(960),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(960),
    [anon_sym_RBRACE] = ACTIONS(2366),
    [anon_sym_EQ] = ACTIONS(1915),
    [anon_sym_DASH] = ACTIONS(1915),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1917),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(1915),
    [anon_sym_COLON_QMARK] = ACTIONS(1915),
    [anon_sym_COLON_DASH] = ACTIONS(1915),
    [anon_sym_PERCENT] = ACTIONS(1915),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [663] = {
    [sym__concat] = ACTIONS(1919),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1919),
    [anon_sym_AMP_AMP] = ACTIONS(1919),
    [anon_sym_PIPE_PIPE] = ACTIONS(1919),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1919),
    [anon_sym_EQ_TILDE] = ACTIONS(1919),
    [anon_sym_EQ_EQ] = ACTIONS(1919),
    [anon_sym_EQ] = ACTIONS(1921),
    [anon_sym_PLUS_EQ] = ACTIONS(1919),
    [anon_sym_LT] = ACTIONS(1921),
    [anon_sym_GT] = ACTIONS(1921),
    [anon_sym_BANG_EQ] = ACTIONS(1919),
    [anon_sym_PLUS] = ACTIONS(1921),
    [anon_sym_DASH] = ACTIONS(1921),
    [anon_sym_DASH_EQ] = ACTIONS(1919),
    [anon_sym_LT_EQ] = ACTIONS(1919),
    [anon_sym_GT_EQ] = ACTIONS(1919),
    [anon_sym_PLUS_PLUS] = ACTIONS(1919),
    [anon_sym_DASH_DASH] = ACTIONS(1919),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1919),
  },
  [664] = {
    [sym_concatenation] = STATE(1147),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(1147),
    [sym_regex] = ACTIONS(2372),
    [anon_sym_RBRACE] = ACTIONS(2342),
    [anon_sym_EQ] = ACTIONS(2358),
    [anon_sym_DASH] = ACTIONS(2358),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(2360),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(2358),
    [anon_sym_COLON_QMARK] = ACTIONS(2358),
    [anon_sym_COLON_DASH] = ACTIONS(2358),
    [anon_sym_PERCENT] = ACTIONS(2358),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [665] = {
    [sym_concatenation] = STATE(960),
    [sym_string] = STATE(483),
    [sym_simple_expansion] = STATE(483),
    [sym_string_expansion] = STATE(483),
    [sym_expansion] = STATE(483),
    [sym_command_substitution] = STATE(483),
    [sym_process_substitution] = STATE(483),
    [aux_sym_expansion_repeat1] = STATE(960),
    [anon_sym_RBRACE] = ACTIONS(2342),
    [anon_sym_EQ] = ACTIONS(1915),
    [anon_sym_DASH] = ACTIONS(1915),
    [sym__special_characters] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(875),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [sym_raw_string] = ACTIONS(879),
    [anon_sym_POUND] = ACTIONS(1917),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(883),
    [anon_sym_COLON] = ACTIONS(1915),
    [anon_sym_COLON_QMARK] = ACTIONS(1915),
    [anon_sym_COLON_DASH] = ACTIONS(1915),
    [anon_sym_PERCENT] = ACTIONS(1915),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(887),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [anon_sym_LT_LPAREN] = ACTIONS(891),
    [anon_sym_GT_LPAREN] = ACTIONS(891),
    [sym_comment] = ACTIONS(281),
    [sym_word] = ACTIONS(893),
  },
  [666] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_RPAREN] = ACTIONS(2374),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [667] = {
    [sym__concat] = ACTIONS(1927),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1927),
    [anon_sym_AMP_AMP] = ACTIONS(1927),
    [anon_sym_PIPE_PIPE] = ACTIONS(1927),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1927),
    [anon_sym_EQ_TILDE] = ACTIONS(1927),
    [anon_sym_EQ_EQ] = ACTIONS(1927),
    [anon_sym_EQ] = ACTIONS(1929),
    [anon_sym_PLUS_EQ] = ACTIONS(1927),
    [anon_sym_LT] = ACTIONS(1929),
    [anon_sym_GT] = ACTIONS(1929),
    [anon_sym_BANG_EQ] = ACTIONS(1927),
    [anon_sym_PLUS] = ACTIONS(1929),
    [anon_sym_DASH] = ACTIONS(1929),
    [anon_sym_DASH_EQ] = ACTIONS(1927),
    [anon_sym_LT_EQ] = ACTIONS(1927),
    [anon_sym_GT_EQ] = ACTIONS(1927),
    [anon_sym_PLUS_PLUS] = ACTIONS(1927),
    [anon_sym_DASH_DASH] = ACTIONS(1927),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1927),
  },
  [668] = {
    [anon_sym_SEMI] = ACTIONS(2376),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2374),
    [anon_sym_SEMI_SEMI] = ACTIONS(2378),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2378),
    [anon_sym_AMP] = ACTIONS(2376),
  },
  [669] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2376),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2374),
    [anon_sym_SEMI_SEMI] = ACTIONS(2378),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2378),
    [anon_sym_AMP] = ACTIONS(2376),
  },
  [670] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(2374),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [671] = {
    [anon_sym_SEMI] = ACTIONS(2380),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2382),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_BQUOTE] = ACTIONS(2374),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2382),
    [anon_sym_AMP] = ACTIONS(2380),
  },
  [672] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2380),
    [anon_sym_PIPE] = ACTIONS(919),
    [anon_sym_SEMI_SEMI] = ACTIONS(2382),
    [anon_sym_PIPE_AMP] = ACTIONS(923),
    [anon_sym_AMP_AMP] = ACTIONS(925),
    [anon_sym_PIPE_PIPE] = ACTIONS(925),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(2374),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2382),
    [anon_sym_AMP] = ACTIONS(2380),
  },
  [673] = {
    [sym_file_descriptor] = ACTIONS(943),
    [sym_variable_name] = ACTIONS(943),
    [anon_sym_for] = ACTIONS(947),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(943),
    [anon_sym_while] = ACTIONS(947),
    [anon_sym_if] = ACTIONS(947),
    [anon_sym_case] = ACTIONS(947),
    [anon_sym_RPAREN] = ACTIONS(2384),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_LPAREN] = ACTIONS(947),
    [anon_sym_BANG] = ACTIONS(947),
    [anon_sym_LBRACK] = ACTIONS(947),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(943),
    [anon_sym_declare] = ACTIONS(947),
    [anon_sym_typeset] = ACTIONS(947),
    [anon_sym_export] = ACTIONS(947),
    [anon_sym_readonly] = ACTIONS(947),
    [anon_sym_local] = ACTIONS(947),
    [anon_sym_unset] = ACTIONS(947),
    [anon_sym_unsetenv] = ACTIONS(947),
    [anon_sym_LT] = ACTIONS(947),
    [anon_sym_GT] = ACTIONS(947),
    [anon_sym_GT_GT] = ACTIONS(943),
    [anon_sym_AMP_GT] = ACTIONS(947),
    [anon_sym_AMP_GT_GT] = ACTIONS(943),
    [anon_sym_LT_AMP] = ACTIONS(943),
    [anon_sym_GT_AMP] = ACTIONS(943),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(947),
    [sym_raw_string] = ACTIONS(943),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(943),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(943),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [anon_sym_LT_LPAREN] = ACTIONS(943),
    [anon_sym_GT_LPAREN] = ACTIONS(943),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(947),
  },
  [674] = {
    [sym__concat] = ACTIONS(1959),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1959),
    [anon_sym_AMP_AMP] = ACTIONS(1959),
    [anon_sym_PIPE_PIPE] = ACTIONS(1959),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1959),
    [anon_sym_EQ_TILDE] = ACTIONS(1959),
    [anon_sym_EQ_EQ] = ACTIONS(1959),
    [anon_sym_EQ] = ACTIONS(1961),
    [anon_sym_PLUS_EQ] = ACTIONS(1959),
    [anon_sym_LT] = ACTIONS(1961),
    [anon_sym_GT] = ACTIONS(1961),
    [anon_sym_BANG_EQ] = ACTIONS(1959),
    [anon_sym_PLUS] = ACTIONS(1961),
    [anon_sym_DASH] = ACTIONS(1961),
    [anon_sym_DASH_EQ] = ACTIONS(1959),
    [anon_sym_LT_EQ] = ACTIONS(1959),
    [anon_sym_GT_EQ] = ACTIONS(1959),
    [anon_sym_PLUS_PLUS] = ACTIONS(1959),
    [anon_sym_DASH_DASH] = ACTIONS(1959),
    [sym_comment] = ACTIONS(55),
    [sym_test_operator] = ACTIONS(1959),
  },
  [675] = {
    [anon_sym_SEMI] = ACTIONS(2386),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2384),
    [anon_sym_SEMI_SEMI] = ACTIONS(2388),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [sym_comment] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(2388),
    [anon_sym_AMP] = ACTIONS(2386),
  },
  [676] = {
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(2386),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(2384),
    [anon_sym_SEMI_SEMI] = ACTIONS(2388),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(631),
    [anon_sym_PIPE_PIPE] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(367),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(367),
    [anon_sym_LT_AMP] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(367),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(367),
    [anon_sym_GT_LPAREN] = ACTIONS(367),
    [sym_comment] = ACTIONS(55),
    [sym_word] = ACTIONS(369),
    [anon_sym_LF] = ACTIONS(2388),
    [anon_sym_AMP] = ACTIONS(2386),
  },
  [677] = {
    [anon_sym_LT] = ACTIONS(2390),
    [anon_sym_GT] = ACTIONS(2390),
    [anon_sym_GT_GT] = ACTIONS(2392),
    [anon_sym_AMP_GT] = ACTIONS(2390),
    [anon_sym_AMP_GT_GT] = ACTIONS(2392),
    [anon_sym_LT_AMP] = ACTIONS(2392),
    [anon_sym_GT_AMP] = ACTIONS(2392),
    [sym_comment] = ACTIONS(55),
  },
  [678] = {
    [sym_concatenation] = STATE(1166),
    [sym_string] = STATE(1161),
    [sym_simple_expansion] = STATE(1161),
    [sym_string_expansion] = STATE(1161),
    [sym_expansion] = STATE(1161),
    [sym_command_substitution] = STATE(1161),
    [sym_process_substitution] = STATE(1161),
    [sym__special_characters] = ACTIONS(2394),
    [anon_sym_DQUOTE] = ACTIONS(2396),
    [anon_sym_DOLLAR]