/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeavyAwareExecutor
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExecutingHeavyOrPowerSaveListener myListener;
    private final int myLongActivityDurationMs;

    public HeavyAwareExecutor(@NotNull Project project, int delayMs, int longActivityDurationMs, @NotNull Disposable parent) {
        if (project == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myLongActivityDurationMs = longActivityDurationMs;
        this.myListener = new ExecutingHeavyOrPowerSaveListener(project, delayMs, this);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public Future<?> executeOutOfHeavyOrPowerSave(@NotNull Consumer<ProgressIndicator> task, @NotNull String title, @NotNull ProgressIndicator indicator) {
        if (task == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(2);
        }
        if (title == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(4);
        }
        return Futures.transformAsync(this.myListener.addTask(() -> {
            Disposable disposable = Disposer.newDisposable();
            ListenableFuture<?> future2 = HeavyAwareExecutor.runAsync(this.myProject, task, title, indicator, () -> Disposer.dispose((Disposable)disposable));
            new CancellingOnHeavyOrPowerSaveListener(this.myProject, indicator, this.myLongActivityDurationMs, disposable);
            return future2;
        }), input -> input, (Executor)MoreExecutors.directExecutor());
    }

    public void dispose() {
    }

    @NotNull
    private static ListenableFuture<?> runAsync(@NotNull Project project, final @NotNull Consumer<ProgressIndicator> task, @NotNull String title, @NotNull ProgressIndicator indicator, @NotNull Runnable continuation) {
        if (project == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(5);
        }
        if (task == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(6);
        }
        if (title == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(8);
        }
        if (continuation == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(9);
        }
        final SettableFuture future2 = SettableFuture.create();
        Task.Backgroundable wrapper2 = new Task.Backgroundable(project, title, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    task.consume((Object)indicator);
                }
                finally {
                    future2.set(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/impl/HeavyAwareExecutor$1", "run"));
            }
        };
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(wrapper2, indicator, continuation);
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(10);
        }
        return settableFuture;
    }

    public static void executeOutOfHeavyProcessLater(@NotNull Runnable command, int delayMs) {
        if (command == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(11);
        }
        HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(command, delayMs);
            } else {
                command.run();
            }
        }, (long)delayMs, TimeUnit.MILLISECONDS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continuation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/HeavyAwareExecutor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyOrPowerSave";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyProcessLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FutureRunnable<T, F extends Future<T>>
    implements Runnable {
        @NotNull
        private final SettableFuture<F> myFuture;
        @NotNull
        private final Computable<F> myComputable;

        private FutureRunnable(@NotNull Computable<F> computable) {
            if (computable == null) {
                FutureRunnable.$$$reportNull$$$0(0);
            }
            this.myComputable = computable;
            this.myFuture = SettableFuture.create();
        }

        @Override
        public void run() {
            try {
                this.myFuture.set(this.myComputable.compute());
            }
            catch (Throwable t) {
                this.myFuture.setException(t);
            }
        }

        @NotNull
        public ListenableFuture<F> getFuture() {
            SettableFuture<F> settableFuture = this.myFuture;
            if (settableFuture == null) {
                FutureRunnable.$$$reportNull$$$0(1);
            }
            return settableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$FutureRunnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$FutureRunnable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExecutingHeavyOrPowerSaveListener
    implements PowerSaveMode.Listener {
        @NotNull
        private final AtomicReference<List<FutureRunnable>> myTasksToRun;
        private final int myDelayMs;

        ExecutingHeavyOrPowerSaveListener(@NotNull Project project, int delayMs, @NotNull Disposable parent) {
            if (project == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            this.myTasksToRun = new AtomicReference<ArrayList>(ContainerUtil.newArrayList());
            this.myDelayMs = delayMs;
            project.getMessageBus().connect(parent).subscribe(PowerSaveMode.TOPIC, (Object)this);
        }

        public <T> ListenableFuture<ListenableFuture<T>> addTask(@NotNull Computable<ListenableFuture<T>> task) {
            if (task == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            FutureRunnable runnable2 = new FutureRunnable(task);
            this.myTasksToRun.getAndUpdate(tasks -> ContainerUtil.concat((List)tasks, Collections.singletonList(runnable2)));
            this.tryRun();
            return runnable2.getFuture();
        }

        public void powerSaveStateChanged() {
            this.tryRun();
        }

        private void tryRun() {
            if (!PowerSaveMode.isEnabled()) {
                HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
                    if (!HeavyProcessLatch.INSTANCE.isRunning() && !PowerSaveMode.isEnabled()) {
                        List<FutureRunnable> tasks = this.myTasksToRun.getAndSet(ContainerUtil.newArrayList());
                        tasks.forEach(Runnable::run);
                    } else {
                        this.tryRun();
                    }
                }, (long)this.myDelayMs, TimeUnit.MILLISECONDS));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$ExecutingHeavyOrPowerSaveListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTask";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CancellingOnHeavyOrPowerSaveListener
    implements HeavyProcessLatch.HeavyProcessListener,
    PowerSaveMode.Listener {
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myLongActivityDurationMs;
        @Nullable
        private ScheduledFuture<?> myFuture;

        CancellingOnHeavyOrPowerSaveListener(@NotNull Project project, @NotNull ProgressIndicator indicator, int logActivityDurationMs, @NotNull Disposable disposable) {
            if (project == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            this.myFuture = null;
            this.myIndicator = indicator;
            this.myLongActivityDurationMs = logActivityDurationMs;
            HeavyProcessLatch.INSTANCE.addListener((HeavyProcessLatch.HeavyProcessListener)this, disposable);
            project.getMessageBus().connect(disposable).subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.scheduleCancel();
            this.powerSaveStateChanged();
        }

        public void processStarted() {
            this.scheduleCancel();
        }

        public void processFinished() {
            this.doNotCancel();
        }

        public void powerSaveStateChanged() {
            if (PowerSaveMode.isEnabled() && this.myIndicator.isRunning()) {
                this.myIndicator.cancel();
            }
        }

        private synchronized void scheduleCancel() {
            if (HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture == null) {
                this.myFuture = JobScheduler.getScheduler().schedule(() -> {
                    if (HeavyProcessLatch.INSTANCE.isRunning() && this.myIndicator.isRunning()) {
                        this.myIndicator.cancel();
                    }
                }, (long)this.myLongActivityDurationMs, TimeUnit.MILLISECONDS);
            }
        }

        private synchronized void doNotCancel() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture != null) {
                ScheduledFuture<?> future2 = this.myFuture;
                this.myFuture = null;
                future2.cancel(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$CancellingOnHeavyOrPowerSaveListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

