/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.impl.CompositeDiffPanel;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.DiscloseMultiRequest;
import com.intellij.openapi.diff.impl.external.FrameDiffTool;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.config.AbstractProperty;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MultiLevelDiffTool
implements DiffTool,
DiscloseMultiRequest {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.MultiLevelDiffTool");
    private final List<? extends DiffTool> myTools;

    public MultiLevelDiffTool(List<? extends DiffTool> tools) {
        this.myTools = tools;
    }

    public void show(DiffRequest request) {
        Collection hints = request.getHints();
        boolean shouldOpenDialog = FrameDiffTool.shouldOpenDialog(hints);
        if (shouldOpenDialog) {
            final DialogBuilder builder2 = new DialogBuilder(request.getProject());
            CompositeDiffPanel diffPanel = this.createPanel(request, builder2.getWindow(), (Disposable)builder2);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)builder2);
                return;
            }
            Runnable onOkRunnable = request.getOnOkRunnable();
            if (onOkRunnable != null) {
                builder2.setOkOperation(() -> {
                    builder2.getDialogWrapper().close(0);
                    onOkRunnable.run();
                });
            } else {
                builder2.removeAllActions();
            }
            builder2.setCenterPanel(diffPanel.getComponent());
            builder2.setPreferredFocusComponent(diffPanel.getPreferredFocusedComponent());
            builder2.setTitle(request.getWindowTitle());
            builder2.setDimensionServiceKey(request.getGroupKey());
            new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    builder2.getDialogWrapper().close(0);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool$1", "actionPerformed"));
                }
            }.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseContent"), diffPanel.getComponent());
            diffPanel.setDiffRequest(request);
            FrameDiffTool.showDiffDialog(builder2, hints);
        } else {
            final FrameWrapper frameWrapper = new FrameWrapper(request.getProject(), request.getGroupKey());
            CompositeDiffPanel diffPanel = this.createPanel(request, frameWrapper.getFrame(), frameWrapper);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)frameWrapper);
                return;
            }
            frameWrapper.setTitle(request.getWindowTitle());
            diffPanel.setDiffRequest(request);
            DiffUtil.initDiffFrame(request.getProject(), frameWrapper, diffPanel, diffPanel.getComponent());
            new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)frameWrapper);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseContent"), diffPanel.getComponent());
            frameWrapper.show();
        }
    }

    private CompositeDiffPanel createPanel(DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MultiLevelDiffTool.$$$reportNull$$$0(0);
        }
        return new CompositeDiffPanel(request.getProject(), this, window, parentDisposable);
    }

    @Override
    public DiffViewer viewerForRequest(Window window, @NotNull Disposable parentDisposable, String name, DiffRequest current) {
        if (parentDisposable == null) {
            MultiLevelDiffTool.$$$reportNull$$$0(1);
        }
        DiffViewer viewer = null;
        for (DiffTool diffTool : this.myTools) {
            if (diffTool.canShow(current) && (viewer = diffTool.createComponent(name, current, window, parentDisposable)) != null) break;
        }
        return viewer;
    }

    public boolean canShow(DiffRequest request) {
        return MultiLevelDiffTool.canShowRequest(request);
    }

    public static boolean canShowRequest(DiffRequest request) {
        DiffContent[] contents;
        boolean isFile = false;
        for (DiffContent content : contents = request.getContents()) {
            VirtualFile file2 = content.getFile();
            if (file2 == null || !file2.isInLocalFileSystem() || file2.isDirectory()) continue;
            isFile = true;
            break;
        }
        AbstractProperty.AbstractPropertyContainer config2 = DiffManagerImpl.getInstanceEx().getProperties();
        if (isFile && DiffManagerImpl.ENABLE_FILES.value(config2)) {
            return false;
        }
        if (!isFile && DiffManagerImpl.ENABLE_FOLDERS.value(config2)) {
            return false;
        }
        return !DiffViewerType.merge.equals((Object)request.getType()) || !MultiLevelDiffTool.contentsWriteable(request);
    }

    private static boolean contentsWriteable(DiffRequest request) {
        DiffContent[] contents;
        for (DiffContent content : contents = request.getContents()) {
            if (content == null || !content.getDocument().isWritable()) continue;
            return true;
        }
        return false;
    }

    public DiffViewer createComponent(String title, DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MultiLevelDiffTool.$$$reportNull$$$0(2);
        }
        throw new IllegalStateException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "parentDisposable";
        objectArray2[1] = "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "viewerForRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

