/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UITheme {
    private String name;
    private boolean dark;
    private String author;
    private String id;
    private String editorScheme;
    private Map<String, Object> ui;
    private Map<String, Object> icons;
    private IconPathPatcher patcher;
    private Map<String, Object> background;
    private ClassLoader providerClassLoader = this.getClass().getClassLoader();
    private String editorSchemeName;
    private SVGLoader.SvgColorPatcher colorPatcher;
    private static final Map<String, String> colorPalette = new HashMap<String, String>();

    private UITheme() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isDark() {
        return this.dark;
    }

    public String getAuthor() {
        return this.author;
    }

    public static UITheme loadFromJson(InputStream stream, @NotNull String themeId, @NotNull ClassLoader provider) throws IOException {
        if (themeId == null) {
            UITheme.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            UITheme.$$$reportNull$$$0(1);
        }
        final UITheme theme = (UITheme)new ObjectMapper().readValue(stream, UITheme.class);
        theme.id = themeId;
        theme.providerClassLoader = provider;
        if (theme.icons != null && !theme.icons.isEmpty()) {
            theme.patcher = new IconPathPatcher(){

                @Nullable
                public String patchPath(String path, ClassLoader classLoader) {
                    Object value;
                    if (classLoader instanceof PluginClassLoader) {
                        Object pluginIconPath;
                        String pluginId = ((PluginClassLoader)((Object)classLoader)).getPluginId().getIdString();
                        Object icons = theme.icons.get(pluginId);
                        if (icons instanceof Map && (pluginIconPath = ((Map)icons).get(path)) instanceof String) {
                            return (String)pluginIconPath;
                        }
                    }
                    return (value = theme.icons.get(path)) instanceof String ? (String)value : null;
                }

                @Nullable
                public ClassLoader getContextClassLoader(String path, ClassLoader originalClassLoader) {
                    return theme.providerClassLoader;
                }
            };
            Object palette = theme.icons.get("ColorPalette");
            if (palette instanceof Map) {
                Map colors = (Map)palette;
                final HashMap<String, String> newPalette = new HashMap<String, String>();
                final HashMap<String, Integer> alphas = new HashMap<String, Integer>();
                for (Object o : colors.keySet()) {
                    String key = UITheme.toColorString(o.toString(), theme.isDark());
                    Object v = colors.get(o.toString());
                    if (!(v instanceof String)) continue;
                    String value = (String)v;
                    String alpha = null;
                    if (value.length() == 9) {
                        alpha = value.substring(7);
                        value = value.substring(0, 7);
                    }
                    if (ColorUtil.fromHex((String)key, null) == null || ColorUtil.fromHex((String)value, null) == null) continue;
                    newPalette.put(key, value);
                    int fillTransparency = -1;
                    if (alpha != null) {
                        try {
                            fillTransparency = Integer.parseInt(alpha, 16);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fillTransparency == -1) continue;
                    alphas.put(value, fillTransparency);
                }
                theme.colorPatcher = new SVGLoader.SvgColorPatcher(){

                    public void patchColors(Element svg) {
                        String newFill;
                        String fill = svg.getAttribute("fill");
                        if (fill != null && (newFill = (String)newPalette.get(StringUtil.toLowerCase((String)fill))) != null) {
                            svg.setAttribute("fill", newFill);
                            if (alphas.get(newFill) != null) {
                                svg.setAttribute("fill-opacity", String.valueOf(Float.valueOf(((Integer)alphas.get(newFill)).intValue()).floatValue() / 255.0f));
                            }
                        }
                        NodeList nodes = svg.getChildNodes();
                        int length = nodes.getLength();
                        for (int i = 0; i < length; ++i) {
                            Node item = nodes.item(i);
                            if (!(item instanceof Element)) continue;
                            this.patchColors((Element)item);
                        }
                    }
                };
            }
        }
        return theme;
    }

    private static String toColorString(String fillValue, boolean darkTheme) {
        String color;
        if (darkTheme && fillValue.startsWith("Actions.") && !fillValue.endsWith(".Dark")) {
            fillValue = fillValue + ".Dark";
        }
        if ((color = colorPalette.get(fillValue)) != null) {
            return StringUtil.toLowerCase((String)color);
        }
        return StringUtil.toLowerCase((String)fillValue);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getEditorScheme() {
        return this.editorScheme;
    }

    public Map<String, Object> getBackground() {
        return this.background;
    }

    public void applyProperties(UIDefaults defaults) {
        if (this.ui == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.ui.entrySet()) {
            UITheme.apply(entry.getKey(), entry.getValue(), defaults);
        }
    }

    public IconPathPatcher getPatcher() {
        return this.patcher;
    }

    public SVGLoader.SvgColorPatcher getColorPatcher() {
        return this.colorPatcher;
    }

    @NotNull
    public ClassLoader getProviderClassLoader() {
        ClassLoader classLoader = this.providerClassLoader;
        if (classLoader == null) {
            UITheme.$$$reportNull$$$0(2);
        }
        return classLoader;
    }

    private static void apply(String key, Object value, UIDefaults defaults) {
        if (value instanceof HashMap) {
            for (Map.Entry o : ((HashMap)value).entrySet()) {
                UITheme.apply(key + "." + (String)o.getKey(), o.getValue(), defaults);
            }
        } else {
            value = UITheme.parseValue(key, value.toString());
            if (key.startsWith("*.")) {
                String tail = key.substring(1);
                Object finalValue = value;
                UITheme.addPattern(key, value, defaults);
                ((UIDefaults)defaults.clone()).keySet().stream().filter(k -> k instanceof String && ((String)k).endsWith(tail)).forEach(k -> defaults.put(k, finalValue));
            } else {
                defaults.put(key, value);
            }
        }
    }

    private static void addPattern(String key, Object value, UIDefaults defaults) {
        HashMap o = defaults.get("*");
        if (!(o instanceof Map)) {
            o = new HashMap();
            defaults.put("*", o);
        }
        Map map = o;
        if (key != null && key.startsWith("*.")) {
            map.put(key.substring(2), value);
        }
    }

    public static Object parseValue(String key, @NotNull String value) {
        if (value == null) {
            UITheme.$$$reportNull$$$0(3);
        }
        if ("null".equals(value)) {
            return null;
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if (key.endsWith("Insets") || key.endsWith("padding")) {
            return UITheme.parseInsets(value);
        }
        if (key.endsWith("Border") || key.endsWith("border")) {
            try {
                List ints = StringUtil.split((String)value, (String)",");
                if (ints.size() == 4) {
                    return new BorderUIResource.EmptyBorderUIResource(UITheme.parseInsets(value));
                }
                if (ints.size() == 5) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)ColorUtil.fromHex((String)((String)ints.get(4))), (int)Integer.parseInt((String)ints.get(0)), (int)Integer.parseInt((String)ints.get(1)), (int)Integer.parseInt((String)ints.get(2)), (int)Integer.parseInt((String)ints.get(3))));
                }
                if (ColorUtil.fromHex((String)value, null) != null) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)ColorUtil.fromHex((String)value), (int)1));
                }
                return Class.forName(value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Icon icon;
            if (key.endsWith("Size")) {
                return UITheme.parseSize(value);
            }
            if (key.endsWith("Width")) {
                return UITheme.getInteger(value);
            }
            if (key.endsWith("grayFilter")) {
                return UITheme.parseGrayFilter(value);
            }
            Color color = UITheme.parseColor(value);
            Integer invVal = UITheme.getInteger(value);
            Icon icon2 = icon = value.startsWith("AllIcons.") ? IconLoader.getIcon((String)value) : null;
            if (color != null) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (icon != null) {
                return new IconUIResource(icon);
            }
        }
        return value;
    }

    private static Insets parseInsets(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new JBInsets(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2)), Integer.parseInt((String)numbers.get(3))).asUIResource();
    }

    private static UIUtil.GrayFilter parseGrayFilter(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new UIUtil.GrayFilter(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2))).asUIResource();
    }

    private static Color parseColor(String value) {
        if (value != null && (value = StringUtil.trimStart((String)value, (String)"#")).length() == 8) {
            Color color = ColorUtil.fromHex((String)value.substring(0, 6));
            try {
                int alpha = Integer.parseInt(value.substring(6, 8), 16);
                return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return ColorUtil.fromHex((String)value, null);
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Dimension parseSize(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new JBDimension(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1))).asUIResource();
    }

    public String getEditorSchemeName() {
        return this.editorSchemeName;
    }

    public void setEditorSchemeName(String editorSchemeName) {
        this.editorSchemeName = editorSchemeName;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setDark(boolean dark) {
        this.dark = dark;
    }

    private void setAuthor(String author) {
        this.author = author;
    }

    private void setUi(Map<String, Object> ui) {
        this.ui = ui;
    }

    private void setIcons(Map<String, Object> icons) {
        this.icons = icons;
    }

    public void setEditorScheme(String editorScheme) {
        this.editorScheme = editorScheme;
    }

    public void setBackground(Map<String, Object> background) {
        this.background = background;
    }

    static {
        colorPalette.put("Actions.Red", "#DB5860");
        colorPalette.put("Actions.Red.Dark", "#C75450");
        colorPalette.put("Actions.Yellow", "#EDA200");
        colorPalette.put("Actions.Yellow.Dark", "#F0A732");
        colorPalette.put("Actions.Green", "#59A869");
        colorPalette.put("Actions.Green.Dark", "#499C54");
        colorPalette.put("Actions.Blue", "#389FD6");
        colorPalette.put("Actions.Blue.Dark", "#3592C4");
        colorPalette.put("Actions.Grey", "#6E6E6E");
        colorPalette.put("Actions.Grey.Dark", "#AFB1B3");
        colorPalette.put("Objects.Grey", "#9AA7B0");
        colorPalette.put("Objects.Blue", "#40B6E0");
        colorPalette.put("Objects.Green", "#62B543");
        colorPalette.put("Objects.Yellow", "#F4AF3D");
        colorPalette.put("Objects.YellowDark", "#D9A343");
        colorPalette.put("Objects.Purple", "#B99BF8");
        colorPalette.put("Objects.Pink", "#F98B9E");
        colorPalette.put("Objects.Red", "#F26522");
        colorPalette.put("Objects.RedStatus", "#E05555");
        colorPalette.put("Objects.GreenAndroid", "#A4C639");
        colorPalette.put("Objects.BlackText", "#231F20");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/UITheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/UITheme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromJson";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

