/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import com.intellij.util.xml.tree.BaseDomElementNode;
import com.intellij.util.xml.tree.DomModelTreeView;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DomElementsToggleAction
extends ToggleAction {
    private final DomModelTreeView myTreeView;
    private final Class myClass;
    private final Icon myIcon;
    private final String myText;

    public DomElementsToggleAction(DomModelTreeView treeView, Class aClass) {
        this.myTreeView = treeView;
        this.myClass = aClass;
        Icon myIcon = ElementPresentationManager.getIcon((Object)this.myClass);
        if (myIcon == null) {
            myIcon = AllIcons.Nodes.Pointcut;
        }
        this.myIcon = myIcon;
        this.myText = TypePresentationService.getService().getTypePresentableName(this.myClass);
        if (this.getHiders() == null) {
            DomUtil.getFile((DomElement)this.myTreeView.getRootElement()).putUserData(AbstractDomElementNode.TREE_NODES_HIDERS_KEY, new HashMap());
        }
        this.getHiders().putIfAbsent(this.myClass, true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DomElementsToggleAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setIcon(this.myIcon);
        e.getPresentation().setText((this.getHiders().get(this.myClass) != false ? "Hide " : "Show ") + this.myText);
        e.getPresentation().setEnabled(this.getHiders() != null && this.getHiders().get(this.myClass) != null);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            DomElementsToggleAction.$$$reportNull$$$0(1);
        }
        return this.getHiders().get(this.myClass);
    }

    private Map<Class, Boolean> getHiders() {
        return (Map)DomUtil.getFile((DomElement)this.myTreeView.getRootElement()).getUserData(BaseDomElementNode.TREE_NODES_HIDERS_KEY);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        if (e == null) {
            DomElementsToggleAction.$$$reportNull$$$0(2);
        }
        this.getHiders().put(this.myClass, state2);
        this.myTreeView.getBuilder().updateFromRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/util/xml/tree/actions/DomElementsToggleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

