/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.reservedcheckout;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.JavaCvsSrcBundle;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.reservedcheckout.EditEditorsMessageParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class EditCommand
extends AbstractCommand {
    private boolean checkThatUnedited;
    private boolean forceEvenIfEdited;
    private Watch temporaryWatch;
    private boolean editors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        Requests requests;
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        if (this.isCheckThatUnedited()) {
            this.editors = true;
            requests = new Requests(CommandRequest.EDITORS, clientEnvironment);
            this.addFileRequests(cvsFiles, requests, clientEnvironment);
            requests.addLocalPathDirectoryRequest();
            this.addArgumentRequests(requests);
            EditEditorsMessageParser parser = new EditEditorsMessageParser(clientEnvironment.getCvsRoot().getUser());
            parser.registerListeners(listenerRegistry);
            try {
                RangeProgressViewer editorsProgressViewer = new RangeProgressViewer(progressViewer, 0.0, 0.5);
                requestProcessor.processRequests(requests, FileStateRequestsProgressHandler.create(editorsProgressViewer, cvsFiles));
            }
            finally {
                parser.unregisterListeners(listenerRegistry);
            }
            if (parser.isFilesEdited()) {
                String message = JavaCvsSrcBundle.message("cannot.edit.files.they.are.edited.error.message", new Object[0]);
                eventSender.notifyMessageListeners(message.getBytes(), true, false);
                return false;
            }
            progressViewer = new RangeProgressViewer(progressViewer, 0.5, 1.0);
        }
        this.editors = false;
        requests = new Requests(CommandRequest.NOOP, clientEnvironment);
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addArgumentRequest(this.isCheckThatUnedited(), "-c");
        requests.addArgumentRequest(this.isForceEvenIfEdited(), "-f");
        requests.addLocalPathDirectoryRequest();
        return requestProcessor.processRequests(requests, FileStateRequestsProgressHandler.create(progressViewer, cvsFiles));
    }

    @Override
    protected void addRequestForFile(FileObject fileObject, Entry entry, boolean fileExists, Requests requests, IClientEnvironment clientEnvironment) {
        if (this.editors) {
            super.addRequestForFile(fileObject, entry, fileExists, requests, clientEnvironment);
            return;
        }
        if (!fileExists || entry == null) {
            return;
        }
        requests.addNotifyRequest(fileObject, "E", Watch.getWatchString(this.getTemporaryWatch()));
        try {
            clientEnvironment.getAdminWriter().editFile(fileObject, entry, clientEnvironment.getCvsFileSystem(), clientEnvironment.getFileReadOnlyHandler());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("edit ");
        cvsCommandLine.append(this.getCvsArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setCheckThatUnedited(false);
        this.setForceEvenIfEdited(true);
        this.setTemporaryWatch(null);
    }

    private String getCvsArguments() {
        StringBuilder cvsArguments = new StringBuilder();
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        return cvsArguments.toString();
    }

    private boolean isCheckThatUnedited() {
        return this.checkThatUnedited;
    }

    public final void setCheckThatUnedited(boolean checkThatUnedited) {
        this.checkThatUnedited = checkThatUnedited;
    }

    private boolean isForceEvenIfEdited() {
        return this.forceEvenIfEdited;
    }

    public final void setForceEvenIfEdited(boolean forceEvenIfEdited) {
        this.forceEvenIfEdited = forceEvenIfEdited;
    }

    private Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public final void setTemporaryWatch(Watch temporaryWatch) {
        this.temporaryWatch = temporaryWatch;
    }
}

