/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefactoringElementListenerComposite
implements RefactoringElementListener,
UndoRefactoringElementListener {
    private final List<RefactoringElementListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public void addListener(RefactoringElementListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void elementMoved(@NotNull PsiElement newElement) {
        if (newElement == null) {
            RefactoringElementListenerComposite.$$$reportNull$$$0(0);
        }
        for (RefactoringElementListener myListener : this.myListeners) {
            myListener.elementMoved(newElement);
        }
    }

    @Override
    public void elementRenamed(@NotNull PsiElement newElement) {
        if (newElement == null) {
            RefactoringElementListenerComposite.$$$reportNull$$$0(1);
        }
        for (RefactoringElementListener myListener : this.myListeners) {
            myListener.elementRenamed(newElement);
        }
    }

    @Override
    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
        if (newElement == null) {
            RefactoringElementListenerComposite.$$$reportNull$$$0(2);
        }
        if (oldQualifiedName == null) {
            RefactoringElementListenerComposite.$$$reportNull$$$0(3);
        }
        for (RefactoringElementListener listener : this.myListeners) {
            if (!(listener instanceof UndoRefactoringElementListener)) continue;
            ((UndoRefactoringElementListener)((Object)listener)).undoElementMovedOrRenamed(newElement, oldQualifiedName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldQualifiedName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/listeners/RefactoringElementListenerComposite";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "elementMoved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "elementRenamed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undoElementMovedOrRenamed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

