/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminReaderForLightFiles;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;

public class LocalPathIndifferentOperationHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperationHelper");
    private final Map<File, Entry> myFileToEntryMap = new HashMap<File, Entry>();
    private final IAdminReader myAdminReader = new AdminReaderForLightFiles(this.myFileToEntryMap);
    private final String myRevision;

    public LocalPathIndifferentOperationHelper(String revision) {
        this.myRevision = revision;
    }

    public LocalPathIndifferentOperationHelper() {
        this("");
    }

    public IAdminReader getAdminReader() {
        return this.myAdminReader;
    }

    public void addFile(File file) {
        assert (file.getParentFile() != null);
        this.myFileToEntryMap.put(file, Entry.createEntryForLine((String)("/" + file.getName() + "/" + this.myRevision + "/" + Entry.getLastModifiedDateFormatter().format(new Date()) + "//")));
    }

    public void addFilesTo(AbstractCommand command) {
        AbstractFileObject[] fileObjects;
        for (AbstractFileObject fileObject : fileObjects = this.createFileObjects()) {
            command.addFileObject(fileObject);
        }
    }

    private AbstractFileObject[] createFileObjects() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        Collection<File> parents = this.collectAllParents();
        HashMap<File, DirectoryObject> parentsMap = new HashMap<File, DirectoryObject>();
        for (File file : parents) {
            String relativeFileName = file.getPath().replace(File.separatorChar, '/');
            if (!StringUtil.startsWithChar((CharSequence)relativeFileName, (char)'/')) {
                relativeFileName = "/" + relativeFileName;
            }
            parentsMap.put(file, DirectoryObject.createInstance((String)relativeFileName));
        }
        for (File file : this.myFileToEntryMap.keySet()) {
            result.add(FileObject.createInstance((DirectoryObject)((DirectoryObject)parentsMap.get(file.getParentFile())), (String)("/" + file.getName())));
        }
        return result.toArray(new AbstractFileObject[0]);
    }

    private Collection<File> collectAllParents() {
        HashSet<File> result = new HashSet<File>();
        for (File file : this.myFileToEntryMap.keySet()) {
            File parentFile = file.getParentFile();
            LOG.assertTrue(parentFile != null, (Object)file.getPath());
            result.add(parentFile);
        }
        return result;
    }
}

