/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmalgamateDisjointClassesAction
extends ProtegeOWLAction {
    private final Logger logger = LoggerFactory.getLogger(AmalgamateDisjointClassesAction.class);

    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<Object> changes = new ArrayList<Object>();
        int axiomsRemoved = 0;
        int axiomsAdded = 0;
        int numberOfDisjoints = 0;
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            CliqueFinder merger = new CliqueFinder();
            Set oldAxioms = ont.getAxioms(AxiomType.DISJOINT_CLASSES);
            numberOfDisjoints += oldAxioms.size();
            for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : oldAxioms) {
                merger.add(oWLDisjointClassesAxiom.getClassExpressions());
            }
            for (Set set : merger.getResults()) {
                OWLDisjointClassesAxiom newAxiom = this.getOWLModelManager().getOWLDataFactory().getOWLDisjointClassesAxiom(set);
                if (oldAxioms.contains(newAxiom)) {
                    oldAxioms.remove(newAxiom);
                    continue;
                }
                changes.add(new AddAxiom(ont, (OWLAxiom)newAxiom));
                ++axiomsAdded;
            }
            for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : oldAxioms) {
                changes.add(new RemoveAxiom(ont, (OWLAxiom)oWLDisjointClassesAxiom));
                ++axiomsRemoved;
            }
        }
        this.getOWLModelManager().applyChanges(changes);
        this.logger.info(axiomsRemoved + " (of " + numberOfDisjoints + " total) disjoint class axioms replaced with " + axiomsAdded);
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }

    public static void main(String[] args) {
        CliqueFinder<String> finder = new CliqueFinder<String>();
        finder.add(new HashSet<String>(Arrays.asList("A", "B")));
        finder.add(new HashSet<String>(Arrays.asList("B", "C")));
        finder.add(new HashSet<String>(Arrays.asList("C", "D")));
        finder.add(new HashSet<String>(Arrays.asList("A", "D")));
        finder.add(new HashSet<String>(Arrays.asList("B", "D")));
        Set results = finder.getResults();
        assert (results.size() == 2);
        assert (results.contains(new HashSet<String>(Arrays.asList("C", "B", "D"))));
        assert (results.contains(new HashSet<String>(Arrays.asList("A", "B", "D"))));
        finder.clear();
        finder.add(new HashSet<String>(Arrays.asList("A", "X")));
        finder.add(new HashSet<String>(Arrays.asList("B", "X")));
        finder.add(new HashSet<String>(Arrays.asList("Y", "A")));
        finder.add(new HashSet<String>(Arrays.asList("B", "D", "A")));
        finder.add(new HashSet<String>(Arrays.asList("C", "B")));
        results = finder.getResults();
        assert (results.size() == 4);
        assert (results.contains(new HashSet<String>(Arrays.asList("D", "A", "B"))));
        assert (results.contains(new HashSet<String>(Arrays.asList("A", "B", "X"))));
        assert (results.contains(new HashSet<String>(Arrays.asList("A", "Y"))));
        assert (results.contains(new HashSet<String>(Arrays.asList("C", "B"))));
        finder.clear();
        finder.add(new HashSet<String>(Arrays.asList("A", "B", "C")));
        finder.add(new HashSet<String>(Arrays.asList("X", "Y", "Z")));
        finder.add(new HashSet<String>(Arrays.asList("X", "A")));
        finder.add(new HashSet<String>(Arrays.asList("X", "C")));
        for (Set result : finder.getResults()) {
            System.out.print("<");
            for (String s : result) {
                System.out.print(s + " ");
            }
            System.out.println(">");
        }
    }

    static class CliqueFinder<O> {
        private Map<O, Set<O>> edgesByVertex = new HashMap<O, Set<O>>();
        private Set<Set<O>> originalCliques = new HashSet<Set<O>>();
        private Set<Set<O>> resultCliques;

        CliqueFinder() {
        }

        public void add(Set<O> clique) {
            this.resultCliques = null;
            Set<O> unmodClique = Collections.unmodifiableSet(clique);
            this.originalCliques.add(unmodClique);
            ArrayList<O> orderedOperands = new ArrayList<O>(clique);
            for (int i = 0; i < orderedOperands.size(); ++i) {
                Object a = orderedOperands.get(i);
                for (int j = i + 1; j < orderedOperands.size(); ++j) {
                    Object b = orderedOperands.get(j);
                    this.addEdge(a, b);
                    this.addEdge(b, a);
                }
            }
        }

        public void clear() {
            this.resultCliques = null;
            this.originalCliques.clear();
            this.edgesByVertex.clear();
        }

        public Set<Set<O>> getResults() {
            if (this.resultCliques == null) {
                this.resultCliques = new HashSet<Set<O>>();
                HashSet<Integer> skip = new HashSet<Integer>();
                ArrayList<Set<O>> workingCliques = new ArrayList<Set<O>>(this.originalCliques);
                for (int i = 0; i < workingCliques.size(); ++i) {
                    if (skip.contains(i)) continue;
                    HashSet g1 = new HashSet((Collection)workingCliques.get(i));
                    for (int j = i + 1; j < workingCliques.size(); ++j) {
                        Set g2;
                        if (skip.contains(j) || !this.canMerge(g1, g2 = (Set)workingCliques.get(j))) continue;
                        g1.addAll(g2);
                        skip.add(j);
                    }
                    this.resultCliques.add(g1);
                }
            }
            return this.resultCliques;
        }

        private void addEdge(O d1, O d2) {
            Set<O> values = this.edgesByVertex.get(d1);
            if (values == null) {
                values = new HashSet<O>();
                this.edgesByVertex.put(d1, values);
            }
            values.add(d2);
        }

        private boolean canMerge(Set<O> g1, Set<O> g2) {
            for (O vertexInG2 : g2) {
                if (g1.contains(vertexInG2)) continue;
                for (O vertexInG1 : g1) {
                    if (this.isEdge(vertexInG2, vertexInG1)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isEdge(O v1, O v2) {
            return this.edgesByVertex.get(v1).contains(v2);
        }
    }
}

