/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.SystemUtils;

public class EscapeKeyHandler {
    private static final String CANCEL_KEY_HANDLER = "key_cancel";

    private EscapeKeyHandler(JFrame frame, IAction action) {
        JRootPane rootPane = frame.getRootPane();
        this.installHandler(rootPane, action);
    }

    private EscapeKeyHandler(JDialog dialog, IAction action) {
        JRootPane rootPane = dialog.getRootPane();
        this.installHandler(rootPane, action);
    }

    public static void installHandler(JDialog dialog, IAction action) {
        new EscapeKeyHandler(dialog, action);
    }

    public static void installHandler(JFrame frame, IAction action) {
        new EscapeKeyHandler(frame, action);
    }

    private void installHandler(JRootPane rootPane, final IAction action) {
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY_HANDLER);
        if (SystemUtils.IS_OS_MAC_OSX) {
            inputMap.put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), CANCEL_KEY_HANDLER);
        }
        rootPane.getActionMap().put(CANCEL_KEY_HANDLER, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.perform();
            }
        });
    }

    public static interface IAction {
        public void perform();
    }
}

