# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class GeoJSONReader(PolyDataAlgorithm):
    """
    GeoJSONReader - Convert Geo JSON format to PolyData
    
    Superclass: PolyDataAlgorithm
    
    Outputs a PolyData from the input Geo JSON Data
    (http://www.geojson.org)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGeoJSONReader, obj, update, **traits)
    
    outline_polygons = tvtk_base.false_bool_trait(desc=\
        """
        Set/get option to generate the border outlining each polygon, so
        that the output cells for polygons are PolyLine instances. The
        default is off.
        """
    )

    def _outline_polygons_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutlinePolygons,
                        self.outline_polygons_)

    string_input_mode = tvtk_base.false_bool_trait(desc=\
        """
        Set/get whether to use string_input instead of reading input from
        file The default is off
        """
    )

    def _string_input_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStringInputMode,
                        self.string_input_mode_)

    triangulate_polygons = tvtk_base.false_bool_trait(desc=\
        """
        Set/get whether to convert all output polygons to triangles. Note
        that if outine_polygons mode is on, then no output polygons are
        generated, and in that case, this option is not relevant. The
        default is off.
        """
    )

    def _triangulate_polygons_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTriangulatePolygons,
                        self.triangulate_polygons_)

    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Accessor for name of the file that will be opened on write_data
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    serialized_properties_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/get name of data array for serialized geo_json "properties"
        node. If specified, data will be stored as
        CellData/vtkStringArray.
        """
    )

    def _serialized_properties_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSerializedPropertiesArrayName,
                        self.serialized_properties_array_name)

    string_input = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        String used as data input (instead of file) when string_input_mode
        is enabled
        """
    )

    def _string_input_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStringInput,
                        self.string_input)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def add_feature_property(self, *args):
        """
        V.add_feature_property(string, Variant)
        C++: void AddFeatureProperty(const char *name,
            Variant &typeAndDefaultValue)
        Specify feature property to read in with geometry objects Note
        that default_value specifies both type & value
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddFeatureProperty, *my_args)
        return ret

    _updateable_traits_ = \
    (('outline_polygons', 'GetOutlinePolygons'), ('string_input_mode',
    'GetStringInputMode'), ('triangulate_polygons',
    'GetTriangulatePolygons'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('serialized_properties_array_name',
    'GetSerializedPropertiesArrayName'), ('string_input',
    'GetStringInput'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'outline_polygons', 'release_data_flag', 'string_input_mode',
    'triangulate_polygons', 'file_name', 'progress_text',
    'serialized_properties_array_name', 'string_input'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GeoJSONReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GeoJSONReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['outline_polygons', 'string_input_mode',
            'triangulate_polygons'], [], ['file_name',
            'serialized_properties_array_name', 'string_input']),
            title='Edit GeoJSONReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GeoJSONReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

