import { IrcBridge } from "./IrcBridge";
import { BridgeRequest } from "../models/BridgeRequest";
import { MatrixUser, MembershipQueue } from "matrix-appservice-bridge";
import { MatrixMessageEvent } from "../models/MatrixAction";
import { BridgedClient } from "../irc/BridgedClient";
import { IrcServer } from "../irc/IrcServer";
export interface MatrixHandlerConfig {
    eventCacheSize: number;
    replySourceMaxLength: number;
    shortReplyTresholdSeconds: number;
    shortReplyTemplate: string;
    longReplyTemplate: string;
    truncatedMessageTemplate: string;
}
export interface MatrixEventInvite {
    room_id: string;
    state_key: string;
    sender: string;
    content: {
        is_direct?: boolean;
        membership: "invite";
    };
    type: string;
    event_id: string;
}
export interface MatrixEventKick {
    room_id: string;
    sender: string;
    state_key: string;
    content: {
        reason?: string;
        membership: "leave";
    };
    type: string;
    event_id: string;
}
export interface MatrixSimpleMessage {
    sender: string;
    event_id: string;
    content: {
        body: string;
    };
}
interface MatrixEventLeave {
    room_id: string;
    event_id: string;
    _injected?: boolean;
}
export interface OnMemberEventData {
    _frontier?: boolean;
    _injected?: boolean;
    room_id: string;
    state_key: string;
    type: string;
    event_id: string;
    content: {
        displayname?: string;
        membership: string;
    };
}
export declare class MatrixHandler {
    private readonly ircBridge;
    private readonly membershipQueue;
    private readonly processingInvitesForRooms;
    private readonly eventCache;
    private readonly metrics;
    private readonly mediaUrl;
    private memberTracker?;
    private adminHandler;
    private config;
    constructor(ircBridge: IrcBridge, config: MatrixHandlerConfig | undefined, membershipQueue: MembershipQueue);
    initalise(): void;
    /**
     * Process a Matrix invite event for an Admin room.
     * @param {Object} event : The Matrix invite event.
     * @param {Request} req : The request for this event.
     * @param {MatrixUser} inviter : The user who invited the bot.
     */
    private handleAdminRoomInvite;
    /**
     * Process a Matrix invite event for an Admin room.
     * @param {Object} event : The Matrix invite event.
     * @param {Request} req : The request for this event.
     * @param {IrcUser} invitedIrcUser : The IRC user the bot invited to a room.
     */
    private handleInviteFromBot;
    private handleInviteFromUser;
    private onAdminMessage;
    quitUser(req: BridgeRequest, userId: string, clientList: BridgedClient[], ircServer: IrcServer | null, reason: string): Promise<"You are not connected to any networks." | null>;
    /**
     * Called when the AS receives a new Matrix invite/join/leave event.
     * @param {Object} event : The Matrix member event.
     */
    private _onMemberEvent;
    /**
     * Called when a Matrix user tries to invite another user into a PM
     * @param {Object} event : The Matrix invite event.
     * @param {MatrixUser} inviter : The inviter (sender).
     * @param {MatrixUser} invitee : The invitee (receiver).
     * @return {Promise} which is resolved/rejected when the request finishes.
     */
    private handleInviteToPMRoom;
    /**
     * Called when the AS receives a new Matrix invite event.
     * @param {Object} event : The Matrix invite event.
     * @param {MatrixUser} inviter : The inviter (sender).
     * @param {MatrixUser} invitee : The invitee (receiver).
     * @return {Promise} which is resolved/rejected when the request finishes.
     */
    private _onInvite;
    private _onJoin;
    private _onKick;
    private _onLeave;
    private onCommand;
    /**
     * Called when the AS receives a new Matrix Event.
     * @return {Promise} which is resolved/rejected when the request finishes.
     */
    private _onMessage;
    private sendIrcAction;
    /**
     * Called when the AS receives an alias query from the HS.
     * @param {string} roomAlias : The room alias queried.
     * @return {Promise} which is resolved/rejected when the request finishes.
     */
    private _onAliasQuery;
    /**
     * Called when the AS receives a user query from the HS.
     * @param {string} userId : The user ID queried.
     * @return {Promise} which is resolved/rejected when the request finishes.
     */
    private _onUserQuery;
    private textForReplyEvent;
    private incrementMetric;
    private cacheEvent;
    private getCachedEvent;
    onConfigChanged(config: MatrixHandlerConfig | undefined): void;
    onMemberEvent(req: BridgeRequest, event: OnMemberEventData): Promise<unknown>;
    onInvite(req: BridgeRequest, event: MatrixEventInvite, inviter: MatrixUser, invitee: MatrixUser): Promise<unknown>;
    onJoin(req: BridgeRequest, event: OnMemberEventData, user: MatrixUser): Promise<unknown>;
    onLeave(req: BridgeRequest, event: MatrixEventLeave, user: MatrixUser): Promise<unknown>;
    onKick(req: BridgeRequest, event: MatrixEventKick, kicker: MatrixUser, kickee: MatrixUser): Promise<unknown>;
    onMessage(req: BridgeRequest, event: MatrixMessageEvent): Promise<unknown>;
    onAliasQuery(req: BridgeRequest, alias: string): Promise<unknown>;
    onUserQuery(req: BridgeRequest, userId: string): Promise<unknown>;
    getMetrics(serverDomain: string): {
        [metricName: string]: number;
    };
}
export {};
