/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyNil;
import org.jruby.embed.EmbedRubyInterfaceAdapter;
import org.jruby.embed.InvokeFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

public class EmbedRubyInterfaceAdapterImpl
implements EmbedRubyInterfaceAdapter {
    private final ScriptingContainer container;

    public EmbedRubyInterfaceAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    @Override
    public <T> T getInstance(Object receiver2, Class<T> clazz) {
        Object obj;
        if (clazz == null || !clazz.isInterface()) {
            return null;
        }
        Ruby runtime2 = this.container.getProvider().getRuntime();
        if (receiver2 == null || receiver2 instanceof RubyNil) {
            obj = JavaEmbedUtils.rubyToJava(runtime2, runtime2.getTopSelf(), clazz);
        } else if (receiver2 instanceof IRubyObject) {
            obj = JavaEmbedUtils.rubyToJava(runtime2, (IRubyObject)receiver2, clazz);
        } else {
            IRubyObject rubyReceiver = JavaUtil.convertJavaToRuby(runtime2, receiver2);
            obj = JavaEmbedUtils.rubyToJava(runtime2, rubyReceiver, clazz);
        }
        String name2 = clazz.getName();
        ClassLoader loader = obj.getClass().getClassLoader();
        try {
            Class<?> klass = Class.forName(name2, true, loader);
            return (T)klass.cast(obj);
        }
        catch (ClassNotFoundException e) {
            throw new InvokeFailedException(e);
        }
    }
}

