/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Configurable;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.spi.RestClientBuilderListener;
import org.eclipse.microprofile.rest.client.spi.RestClientBuilderResolver;

public interface RestClientBuilder
extends Configurable<RestClientBuilder> {
    public static RestClientBuilder newBuilder() {
        RestClientBuilder builder = RestClientBuilderResolver.instance().newBuilder();
        AccessController.doPrivileged(() -> {
            for (RestClientBuilderListener listener : ServiceLoader.load(RestClientBuilderListener.class)) {
                listener.onNewBuilder(builder);
            }
            return null;
        });
        return builder;
    }

    public RestClientBuilder baseUrl(URL var1);

    default public RestClientBuilder baseUri(URI uri) {
        try {
            return this.baseUrl(uri.toURL());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public RestClientBuilder connectTimeout(long var1, TimeUnit var3);

    public RestClientBuilder readTimeout(long var1, TimeUnit var3);

    public RestClientBuilder executorService(ExecutorService var1);

    public RestClientBuilder sslContext(SSLContext var1);

    public RestClientBuilder trustStore(KeyStore var1);

    public RestClientBuilder keyStore(KeyStore var1, String var2);

    public RestClientBuilder hostnameVerifier(HostnameVerifier var1);

    public <T> T build(Class<T> var1) throws IllegalStateException, RestClientDefinitionException;
}

