/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.config.smallrye.ConfigProviderService;
import org.wildfly.extension.microprofile.config.smallrye.MicroProfileSubsystemDefinition;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;
import org.wildfly.extension.microprofile.config.smallrye._private.MicroProfileConfigLogger;
import org.wildfly.extension.microprofile.config.smallrye.deployment.DependencyProcessor;
import org.wildfly.extension.microprofile.config.smallrye.deployment.SubsystemDeploymentProcessor;

class MicroProfileConfigSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    MicroProfileConfigSubsystemAdd() {
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) {
        MicroProfileConfigLogger.ROOT_LOGGER.activatingSubsystem();
        ConfigProviderService.install(context);
        CapabilityServiceBuilder capSvc = context.getCapabilityServiceTarget().addCapability(MicroProfileSubsystemDefinition.CONFIG_CAPABILITY);
        capSvc.requires(ServiceNames.CONFIG_PROVIDER);
        capSvc.install();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("microprofile-config-smallrye", Phase.DEPENDENCIES, 6224, (DeploymentUnitProcessor)new DependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-config-smallrye", Phase.POST_MODULE, 14160, (DeploymentUnitProcessor)new SubsystemDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

