/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.SimpleAttributesEntry;

class AggregateAttributes
implements Attributes {
    private final Map<String, Attributes.Entry> aggregatedEntries;

    private AggregateAttributes(Attributes[] aggrgatedAttributes) {
        HashMap<String, Attributes.Entry> aggregatedEntries = new HashMap<String, Attributes.Entry>();
        for (Attributes currentAttributes : aggrgatedAttributes) {
            for (Attributes.Entry currentEntry : currentAttributes.entries()) {
                String key = currentEntry.getKey();
                if (aggregatedEntries.containsKey(key)) continue;
                aggregatedEntries.put(key, currentEntry);
            }
        }
        this.aggregatedEntries = aggregatedEntries;
    }

    static Attributes aggregateOf(Attributes ... aggrgatedAttributes) {
        return new AggregateAttributes(aggrgatedAttributes).asReadOnly();
    }

    @Override
    public Collection<Attributes.Entry> entries() {
        return this.aggregatedEntries.values();
    }

    @Override
    public int size(String key) {
        return this.get(key).size();
    }

    @Override
    public Attributes.Entry get(String key) {
        if (this.aggregatedEntries.containsKey(key)) {
            return this.aggregatedEntries.get(key);
        }
        return new SimpleAttributesEntry(Attributes.EMPTY, key);
    }

    @Override
    public String get(String key, int idx) {
        return (String)this.get(key).get(idx);
    }

    @Override
    public int size() {
        return this.entries().size();
    }
}

