/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;
import org.wildfly.security.sasl.util.SaslFactories;

public final class MechanismProviderFilteringSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final BiPredicate<String, Provider> predicate;

    public MechanismProviderFilteringSaslClientFactory(SaslClientFactory delegate, BiPredicate<String, Provider> predicate) {
        super(delegate);
        Assert.checkNotNullParam("predicate", predicate);
        this.predicate = predicate;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        BiPredicate<String, Provider> existing = SaslFactories.getProviderFilterPredicate(props);
        HashMap newProps = new HashMap(props);
        if (existing != null) {
            newProps.put("org.wildfly.internal.PFK", this.predicate.and(existing));
        } else {
            newProps.put("org.wildfly.internal.PFK", this.predicate);
        }
        return super.createSaslClient(mechanisms, authorizationId, protocol, serverName, newProps, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        BiPredicate<String, Provider> existing = SaslFactories.getProviderFilterPredicate(props);
        HashMap newProps = new HashMap(props);
        if (existing != null) {
            newProps.put("org.wildfly.internal.PFK", this.predicate.and(existing));
        } else {
            newProps.put("org.wildfly.internal.PFK", this.predicate);
        }
        return super.getMechanismNames(newProps);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof MechanismProviderFilteringSaslClientFactory && this.equals((MechanismProviderFilteringSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof MechanismProviderFilteringSaslClientFactory && this.equals((MechanismProviderFilteringSaslClientFactory)other);
    }

    public boolean equals(MechanismProviderFilteringSaslClientFactory other) {
        return super.equals(other) && this.predicate.equals(other.predicate);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.predicate.hashCode());
    }
}

