/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientregistration.policy.AbstractClientRegistrationPolicyFactory;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.impl.ProtocolMappersClientRegistrationPolicy;

public class ProtocolMappersClientRegistrationPolicyFactory
extends AbstractClientRegistrationPolicyFactory {
    private List<ProviderConfigProperty> configProperties = new LinkedList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "allowed-protocol-mappers";
    public static final String ALLOWED_PROTOCOL_MAPPER_TYPES = "allowed-protocol-mapper-types";

    public ClientRegistrationPolicy create(KeycloakSession session, ComponentModel model) {
        return new ProtocolMappersClientRegistrationPolicy(session, model);
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        super.postInit(factory);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ALLOWED_PROTOCOL_MAPPER_TYPES);
        property.setLabel("allowed-protocol-mappers.label");
        property.setHelpText("allowed-protocol-mappers.tooltip");
        property.setType("MultivaluedList");
        property.setOptions(this.getProtocolMapperFactoryIds());
        this.configProperties.add(property);
    }

    private List<String> getProtocolMapperFactoryIds() {
        List protocolMapperFactories = this.sessionFactory.getProviderFactories(ProtocolMapper.class);
        return protocolMapperFactories.stream().map(factory -> factory.getId()).collect(Collectors.toList());
    }

    public String getHelpText() {
        return "When present, it allows to specify whitelist of protocol mapper types, which will be allowed in representation of registered (or updated) client";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

