/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;

public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;
    private static long lastGC;
    private static final HashMap<String, byte[]> RESOURCES;

    private Utils() {
    }

    private static int readInt(byte[] byArray, int n) {
        return (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        Utils.writeInt(byArray, n, (int)(l >> 32));
        Utils.writeInt(byArray, n + 4, (int)l);
    }

    private static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)n2;
    }

    public static long readLong(byte[] byArray, int n) {
        return ((long)Utils.readInt(byArray, n) << 32) + ((long)Utils.readInt(byArray, n + 4) & 0xFFFFFFFFL);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2.length == 0) {
            return n;
        }
        if (n > byArray.length) {
            return -1;
        }
        int n2 = byArray.length - byArray2.length + 1;
        int n3 = byArray2.length;
        while (n < n2) {
            block5: {
                for (int i = 0; i < n3; ++i) {
                    if (byArray[n + i] == byArray2[i]) {
                        continue;
                    }
                    break block5;
                }
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getByteArrayHash(byte[] byArray) {
        int n;
        int n2 = n = byArray.length;
        if (n < 50) {
            for (int i = 0; i < n; ++i) {
                n2 = 31 * n2 + byArray[i];
            }
        } else {
            int n3;
            int n4 = n / 16;
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = 31 * n2 + byArray[n3];
                n2 = 31 * n2 + byArray[--n];
            }
            for (n3 = 4 + n4; n3 < n; n3 += n4) {
                n2 = 31 * n2 + byArray[n3];
            }
        }
        return n2;
    }

    public static boolean compareSecure(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 |= byArray[i] ^ byArray2[i];
        }
        return n2 == 0;
    }

    public static int compareNotNullSigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            byte by2 = byArray2[i];
            if (by == by2) continue;
            return by > by2 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    public static int compareNotNullUnsigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray2[i] & 0xFF;
            if (n2 == n3) continue;
            return n2 > n3 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    public static byte[] copy(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n > byArray2.length) {
            byArray2 = new byte[n];
        }
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static byte[] cloneByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int getMemoryUsed() {
        Utils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        return (int)(l >> 10);
    }

    public static int getMemoryFree() {
        Utils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        return (int)(l >> 10);
    }

    public static long getMemoryMax() {
        long l = Runtime.getRuntime().maxMemory();
        return l / 1024L;
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = System.currentTimeMillis();
        if (lastGC + 50L < l2) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long l3 = runtime.totalMemory();
                if (l3 == l) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                l = l3;
            }
        }
    }

    public static int[] newIntArray(int n) {
        if (n == 0) {
            return EMPTY_INT_ARRAY;
        }
        return new int[n];
    }

    public static long[] newLongArray(int n) {
        if (n == 0) {
            return EMPTY_LONG_ARRAY;
        }
        return new long[n];
    }

    public static <X> void sortTopN(X[] XArray, int n, int n2, Comparator<? super X> comparator) {
        Utils.partitionTopN(XArray, n, n2, comparator);
        Arrays.sort(XArray, n, (int)Math.min((long)n + (long)n2, (long)XArray.length), comparator);
    }

    private static <X> void partitionTopN(X[] XArray, int n, int n2, Comparator<? super X> comparator) {
        Utils.partialQuickSort(XArray, 0, XArray.length - 1, comparator, n, n + n2 - 1);
    }

    private static <X> void partialQuickSort(X[] XArray, int n, int n2, Comparator<? super X> comparator, int n3, int n4) {
        if (n > n4 || n2 < n3 || n > n3 && n2 < n4) {
            return;
        }
        if (n == n2) {
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n + MathUtils.randomInt(n2 - n);
        X x = XArray[n7];
        int n8 = n + n2 >>> 1;
        X x2 = XArray[n8];
        XArray[n8] = x;
        XArray[n7] = x2;
        while (n5 <= n6) {
            while (comparator.compare(XArray[n5], x) < 0) {
                ++n5;
            }
            while (comparator.compare(XArray[n6], x) > 0) {
                --n6;
            }
            if (n5 > n6) continue;
            x2 = XArray[n5];
            XArray[n5++] = XArray[n6];
            XArray[n6--] = x2;
        }
        if (n < n6) {
            Utils.partialQuickSort(XArray, n, n6, comparator, n3, n4);
        }
        if (n5 < n2) {
            Utils.partialQuickSort(XArray, n5, n2, comparator, n3, n4);
        }
    }

    public static boolean haveCommonComparableSuperclass(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3;
        Class<?> clazz4;
        if (clazz == clazz2 || clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        do {
            clazz4 = clazz;
        } while (Comparable.class.isAssignableFrom(clazz = clazz.getSuperclass()));
        do {
            clazz3 = clazz2;
        } while (Comparable.class.isAssignableFrom(clazz2 = clazz2.getSuperclass()));
        return clazz4 == clazz3;
    }

    public static byte[] getResource(String string) throws IOException {
        byte[] byArray = RESOURCES.get(string);
        if (byArray == null && (byArray = Utils.loadResource(string)) != null) {
            RESOURCES.put(string, byArray);
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadResource(String string) throws IOException {
        InputStream inputStream = Utils.class.getResourceAsStream("data.zip");
        if (inputStream == null) {
            inputStream = Utils.class.getResourceAsStream(string);
            if (inputStream != null) return IOUtils.readBytesAndClose(inputStream, 0);
            return null;
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            while (true) {
                ZipEntry zipEntry;
                if ((zipEntry = zipInputStream.getNextEntry()) == null) {
                    return null;
                }
                String string2 = zipEntry.getName();
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                if (string2.equals(string)) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy(zipInputStream, byteArrayOutputStream);
                    zipInputStream.closeEntry();
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    return byArray;
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static Object callStaticMethod(String string, Object ... objectArray) throws Exception {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return Utils.callMethod(null, Class.forName(string2), string3, objectArray);
    }

    public static Object callMethod(Object object, String string, Object ... objectArray) throws Exception {
        return Utils.callMethod(object, object.getClass(), string, objectArray);
    }

    private static Object callMethod(Object object, Class<?> clazz, String string, Object ... objectArray) throws Exception {
        Method method = null;
        int n = 0;
        boolean bl = object == null;
        for (Method method2 : clazz.getMethods()) {
            int n2;
            if (Modifier.isStatic(method2.getModifiers()) != bl || !method2.getName().equals(string) || (n2 = Utils.match(method2.getParameterTypes(), objectArray)) <= n) continue;
            n = n2;
            method = method2;
        }
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        return method.invoke(object, objectArray);
    }

    public static Object newInstance(String string, Object ... objectArray) throws Exception {
        Constructor<?> constructor = null;
        int n = 0;
        for (Constructor<?> constructor2 : Class.forName(string).getConstructors()) {
            int n2 = Utils.match(constructor2.getParameterTypes(), objectArray);
            if (n2 <= n) continue;
            n = n2;
            constructor = constructor2;
        }
        if (constructor == null) {
            throw new NoSuchMethodException(string);
        }
        return constructor.newInstance(objectArray);
    }

    private static int match(Class<?>[] classArray, Object[] objectArray) {
        int n = classArray.length;
        if (n == objectArray.length) {
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                Class<?> clazz;
                Class<?> clazz2 = Utils.getNonPrimitiveClass(classArray[i]);
                Object object = objectArray[i];
                Class<?> clazz3 = clazz = object == null ? null : object.getClass();
                if (clazz2 == clazz) {
                    ++n2;
                    continue;
                }
                if (clazz == null || clazz2.isAssignableFrom(clazz)) continue;
                return 0;
            }
            return n2;
        }
        return 0;
    }

    public static Object getStaticField(String string) throws Exception {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return Class.forName(string2).getField(string3).get(null);
    }

    public static Object getField(Object object, String string) throws Exception {
        return object.getClass().getField(string).get(object);
    }

    public static boolean isClassPresent(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static int getProperty(String string, int n) {
        String string2 = Utils.getProperty(string, null);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static boolean getProperty(String string, boolean bl) {
        String string2 = Utils.getProperty(string, null);
        if (string2 != null) {
            try {
                return Boolean.parseBoolean(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static int scaleForAvailableMemory(int n) {
        long l = Runtime.getRuntime().maxMemory();
        if (l != Long.MAX_VALUE) {
            return (int)((long)n * l / 0x40000000L);
        }
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            Method method = Class.forName("com.sun.management.OperatingSystemMXBean").getMethod("getTotalPhysicalMemorySize", new Class[0]);
            long l2 = ((Number)method.invoke((Object)operatingSystemMXBean, new Object[0])).longValue();
            return (int)((long)n * l2 / 0x40000000L);
        }
        catch (Exception exception) {
            return n;
        }
    }

    static {
        RESOURCES = New.hashMap();
    }

    public static interface ClassFactory {
        public boolean match(String var1);

        public Class<?> loadClass(String var1) throws ClassNotFoundException;
    }
}

