/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.Queue;

public class QueueFilterPredicate
extends ActiveMQFilterPredicate<QueueControl> {
    private Field f;
    private ActiveMQServer server;

    public QueueFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(QueueControl queue) {
        try {
            if (this.f == null) {
                return true;
            }
            switch (this.f) {
                case ID: {
                    return this.matches(queue.getID());
                }
                case NAME: {
                    return this.matches(queue.getName());
                }
                case CONSUMER_ID: {
                    Queue q = this.server.locateQueue(new SimpleString(queue.getName()));
                    for (Consumer consumer : q.getConsumers()) {
                        if (!this.matches(consumer.sequentialID())) continue;
                        return true;
                    }
                    return false;
                }
                case MAX_CONSUMERS: {
                    return this.matches(queue.getMaxConsumers());
                }
                case ADDRESS: {
                    return this.matches(queue.getAddress());
                }
                case FILTER: {
                    return this.matches(queue.getFilter());
                }
                case MESSAGE_COUNT: {
                    return this.matches(queue.getMessageCount());
                }
                case CONSUMER_COUNT: {
                    return this.matches(queue.getConsumerCount());
                }
                case DELIVERING_COUNT: {
                    return this.matches(queue.getDeliveringCount());
                }
                case MESSAGES_ADDED: {
                    return this.matches(queue.getMessagesAdded());
                }
                case MESSAGES_ACKED: {
                    return this.matches(queue.getMessagesAcknowledged());
                }
                case RATE: {
                    return this.matches(queue.getMessagesExpired());
                }
                case ROUTING_TYPE: {
                    return this.matches(queue.getRoutingType());
                }
                case AUTO_CREATED: {
                    return this.matches(this.server.locateQueue(new SimpleString(queue.getName())).isAutoCreated());
                }
                case DURABLE: {
                    return this.matches(queue.isDurable());
                }
                case PAUSED: {
                    return this.matches(queue.isPaused());
                }
                case TEMPORARY: {
                    return this.matches(queue.isTemporary());
                }
                case PURGE_ON_NO_CONSUMERS: {
                    return this.matches(queue.isPurgeOnNoConsumers());
                }
                case MESSAGES_KILLED: {
                    return this.matches(queue.getMessagesKilled());
                }
                case EXCLUSIVE: {
                    return this.matches(queue.isExclusive());
                }
                case LAST_VALUE: {
                    return this.matches(queue.isLastValue());
                }
                case SCHEDULED_COUNT: {
                    return this.matches(queue.getScheduledCount());
                }
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = Field.valueOf(field.toUpperCase());
        }
    }

    static enum Field {
        ID,
        NAME,
        CONSUMER_ID,
        QUEUE,
        ADDRESS,
        MAX_CONSUMERS,
        FILTER,
        MESSAGE_COUNT,
        CONSUMER_COUNT,
        DELIVERING_COUNT,
        MESSAGES_ADDED,
        MESSAGES_ACKED,
        RATE,
        ROUTING_TYPE,
        USER,
        AUTO_CREATED,
        DURABLE,
        PAUSED,
        TEMPORARY,
        PURGE_ON_NO_CONSUMERS,
        MESSAGES_KILLED,
        DIRECT_DELIVER,
        LAST_VALUE,
        EXCLUSIVE,
        SCHEDULED_COUNT;

    }
}

