#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 scotty
version:              0.12
visibility:           public
id:                   scotty-0.12-ObeYpsL1Jk4Hl1sGC4Gu2
key:                  scotty-0.12-ObeYpsL1Jk4Hl1sGC4Gu2
license:              BSD-3-Clause
copyright:            (c) 2012-Present Andrew Farmer
maintainer:           Andrew Farmer <xichekolas@gmail.com>
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    import Data.Monoid (mconcat)

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- param &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  b0beb3d1a6c4fb9ad81de69af0defdde
exposed:              True
exposed-modules:      Web.Scotty Web.Scotty.Internal.Types Web.Scotty.Trans
hidden-modules:       Web.Scotty.Action Web.Scotty.Route Web.Scotty.Util
import-dirs:          /usr/lib/ghc-8.10.2/site-local/scotty-0.12
library-dirs:         /usr/lib/ghc-8.10.2/site-local/scotty-0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/scotty-0.12
hs-libraries:         HSscotty-0.12-ObeYpsL1Jk4Hl1sGC4Gu2
depends:
    aeson-1.5.5.1-7ZKmq9KLIncxnBfAj9HU2 base-4.14.1.0
    base-compat-batteries-0.11.2-IYntvvdTJmlHHb2EgtAUk
    blaze-builder-0.4.1.0-G4KXEZbDrFS6c5MmayHGI7 bytestring-0.10.10.0
    case-insensitive-1.2.1.0-6j421Scg55hFNBQMOoQNh8
    data-default-class-0.1.2.0-56BXPST0gStFZdhRwxhsn8 exceptions-0.10.4
    http-types-0.12.3-BjgB5kCegWL53v8V6hA7Kx
    monad-control-1.0.2.3-D0QtFvOGiobG7KTK5Cfhxz mtl-2.2.2
    network-3.1.2.1-Gpsuc7SHQHF6OBh84JF5QV
    regex-compat-0.95.2.0-8jAT0ozbnzh2CxYMst7LDL text-1.2.3.2
    transformers-0.5.6.2
    transformers-base-0.4.5.2-5NQt00osHIwIugRpgg1tUI
    transformers-compat-0.6.6-5ZJJ9POl5DGLIWTn4Z8HjM
    wai-3.2.2.1-BYB2v4x1FyK8eqy5kz3dj4
    wai-extra-3.1.5-8ah7ZiDfzSNDuE2iXhkFhW
    warp-3.3.13-5YMIhxHFQMs56eMisupGvu

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

