#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 FloatingHex
version:              0.5
visibility:           public
id:                   FloatingHex-0.5-2TdMqcCNIQJKe2hQGvpHYV
key:                  FloatingHex-0.5-2TdMqcCNIQJKe2hQGvpHYV
license:              BSD-3-Clause
copyright:            Levent Erkok
maintainer:           erkokl@gmail.com
author:               Levent Erkok
synopsis:             Read and write hexadecimal floating point numbers
description:
    Read and write hexadecimal floating point numbers. Provides a quasiquoter for
    entering hex-float literals, and a function for printing them in hexadecimal.

    See: <http://www.open-std.org/jtc1/sc22/wg14/www/docs/n1256.pdf>, pages 57-58.
    We slightly diverge from the standard and do not allow for the "floating-suffix,"
    as the type inference of Haskell makes this unnecessary.

    For details, please see: <http://github.com/LeventErkok/FloatingHex/>

category:             Tools
abi:                  26f8a17ccad3edc4ae4eb3b1a2852a76
exposed:              True
exposed-modules:      Data.Numbers.FloatingHex
import-dirs:          /usr/lib/ghc-8.10.5/site-local/FloatingHex-0.5
library-dirs:         /usr/lib/ghc-8.10.5/site-local/FloatingHex-0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/FloatingHex-0.5
hs-libraries:         HSFloatingHex-0.5-2TdMqcCNIQJKe2hQGvpHYV
depends:              base-4.14.2.0 template-haskell-2.16.0.0
haddock-interfaces:   /usr/share/doc/haskell-floatinghex/html/FloatingHex.haddock
haddock-html:         /usr/share/doc/haskell-floatinghex/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

