/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;

public class ComponentSelectionReasons {
    public static final ComponentSelectionDescriptorInternal REQUESTED = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.REQUESTED);
    public static final ComponentSelectionDescriptorInternal ROOT = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.ROOT);
    public static final ComponentSelectionDescriptorInternal FORCED = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.FORCED);
    public static final ComponentSelectionDescriptorInternal CONFLICT_RESOLUTION = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.CONFLICT_RESOLUTION);
    public static final ComponentSelectionDescriptorInternal SELECTED_BY_RULE = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.SELECTED_BY_RULE);
    public static final ComponentSelectionDescriptorInternal COMPOSITE_BUILD = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.COMPOSITE_BUILD);
    public static final ComponentSelectionDescriptorInternal CONSTRAINT = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.CONSTRAINT);
    public static final ComponentSelectionDescriptorInternal REJECTION = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.REJECTION);

    public static ComponentSelectionReason requested() {
        return new DefaultComponentSelectionReason(new ComponentSelectionDescriptor[]{REQUESTED});
    }

    public static ComponentSelectionReason root() {
        return new DefaultComponentSelectionReason(new ComponentSelectionDescriptor[]{ROOT});
    }

    public static ComponentSelectionReason of(ComponentSelectionDescriptor ... descriptions) {
        return new DefaultComponentSelectionReason(descriptions);
    }

    public static ComponentSelectionReasonInternal of(Collection<ComponentSelectionDescriptorInternal> dependencyReasons) {
        return new DefaultComponentSelectionReason(dependencyReasons.toArray(new ComponentSelectionDescriptor[0]));
    }

    public static ComponentSelectionReasonInternal empty() {
        return new DefaultComponentSelectionReason(new ComponentSelectionDescriptor[0]);
    }

    public static boolean isCauseExpected(ComponentSelectionDescriptor descriptor) {
        return descriptor.getCause() == ComponentSelectionCause.REQUESTED || descriptor.getCause() == ComponentSelectionCause.ROOT;
    }

    private static class DefaultComponentSelectionReason
    implements ComponentSelectionReasonInternal {
        private final ArrayDeque<ComponentSelectionDescriptorInternal> descriptions = new ArrayDeque(1);

        private DefaultComponentSelectionReason(ComponentSelectionDescriptor ... descriptors) {
            for (ComponentSelectionDescriptor descriptor : descriptors) {
                this.descriptions.add((ComponentSelectionDescriptorInternal)descriptor);
            }
        }

        public boolean isForced() {
            return this.hasCause(ComponentSelectionCause.FORCED);
        }

        private boolean hasCause(ComponentSelectionCause cause) {
            for (ComponentSelectionDescriptor componentSelectionDescriptor : this.descriptions) {
                if (componentSelectionDescriptor.getCause() != cause) continue;
                return true;
            }
            return false;
        }

        public boolean isConflictResolution() {
            return this.hasCause(ComponentSelectionCause.CONFLICT_RESOLUTION);
        }

        public boolean isSelectedByRule() {
            return this.hasCause(ComponentSelectionCause.SELECTED_BY_RULE);
        }

        public boolean isExpected() {
            return ComponentSelectionReasons.isCauseExpected((ComponentSelectionDescriptor)Iterables.getLast(this.descriptions));
        }

        public boolean isCompositeSubstitution() {
            return this.hasCause(ComponentSelectionCause.COMPOSITE_BUILD);
        }

        public String getDescription() {
            return this.descriptions.getLast().toString();
        }

        public String toString() {
            return this.getDescription();
        }

        @Override
        public ComponentSelectionReasonInternal addCause(ComponentSelectionCause cause, Describable description) {
            this.addCause(new DefaultComponentSelectionDescriptor(cause, description));
            return this;
        }

        @Override
        public ComponentSelectionReasonInternal setCause(ComponentSelectionDescriptor description) {
            this.descriptions.clear();
            this.addCause(description);
            return this;
        }

        @Override
        public ComponentSelectionReasonInternal addCause(ComponentSelectionDescriptor description) {
            ComponentSelectionDescriptorInternal descriptor = (ComponentSelectionDescriptorInternal)description;
            if (!this.descriptions.contains(descriptor)) {
                this.descriptions.add(descriptor);
            }
            return this;
        }

        public List<ComponentSelectionDescriptor> getDescriptions() {
            return ImmutableList.copyOf(this.descriptions);
        }

        public boolean isConstrained() {
            return this.hasCause(ComponentSelectionCause.CONSTRAINT);
        }

        @Override
        public boolean hasCustomDescriptions() {
            for (ComponentSelectionDescriptorInternal description : this.descriptions) {
                if (!description.hasCustomDescription()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultComponentSelectionReason that = (DefaultComponentSelectionReason)o;
            return this.sameDescriptorsAs(that);
        }

        private boolean sameDescriptorsAs(DefaultComponentSelectionReason that) {
            if (this.descriptions.size() != that.descriptions.size()) {
                return false;
            }
            Iterator<ComponentSelectionDescriptorInternal> it1 = this.descriptions.iterator();
            Iterator<ComponentSelectionDescriptorInternal> it2 = this.descriptions.iterator();
            while (it1.hasNext()) {
                if (it1.next().equals(it2.next())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.descriptions});
        }
    }
}

