#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 multistate
version:              0.8.0.3
visibility:           public
id:                   multistate-0.8.0.3-AFUwvKhdtvxIjWwSXR49u9
key:                  multistate-0.8.0.3-AFUwvKhdtvxIjWwSXR49u9
license:              BSD-3-Clause
copyright:            Copyright (C) 2013 Jan Bracker, 2013-2020 Lennart Spitzner
maintainer:           Lennart Spitzner <hexagoxel@hexagoxel.de>
author:               Jan Bracker, Lennart Spitzner
stability:            Experimental
homepage:             https://github.com/lspitzner/multistate
synopsis:
    like mtl'\''s ReaderT / WriterT / StateT, but more than one
    contained value/type.

description:
    When using multiple Read\/Write\/State transformers in the same monad stack,
    it becomes necessary to lift the operations in order to affect a specific
    transformer.
    Using heterogeneous lists (and all kinds of GHC extensions magic),
    this package provides transformers that remove that necessity:
    MultiReaderT\/MultiWriterT\/MultiStateT\/MultiRWST can contain a
    heterogeneous list of values.

    See the <https://github.com/lspitzner/multistate README> for
    a longer description.

category:             Control
abi:                  7a1dbbd377636c3acfc595420357881e
exposed:              True
exposed-modules:
    Control.Monad.Trans.MultiGST Control.Monad.Trans.MultiGST.Lazy
    Control.Monad.Trans.MultiGST.Strict
    Control.Monad.Trans.MultiGet.Class Control.Monad.Trans.MultiRWS
    Control.Monad.Trans.MultiRWS.Lazy
    Control.Monad.Trans.MultiRWS.Strict Control.Monad.Trans.MultiReader
    Control.Monad.Trans.MultiReader.Class
    Control.Monad.Trans.MultiReader.Lazy
    Control.Monad.Trans.MultiReader.Strict
    Control.Monad.Trans.MultiState Control.Monad.Trans.MultiState.Class
    Control.Monad.Trans.MultiState.Lazy
    Control.Monad.Trans.MultiState.Strict
    Control.Monad.Trans.MultiWriter
    Control.Monad.Trans.MultiWriter.Class
    Control.Monad.Trans.MultiWriter.Lazy
    Control.Monad.Trans.MultiWriter.Strict Data.HList.ContainsType
    Data.HList.HList

hidden-modules:       Control.Monad.Trans.MultiGST.Common
import-dirs:          /usr/lib/ghc-8.10.5/site-local/multistate-0.8.0.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/multistate-0.8.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/multistate-0.8.0.3
hs-libraries:         HSmultistate-0.8.0.3-AFUwvKhdtvxIjWwSXR49u9
depends:
    base-4.14.2.0 monad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J
    mtl-2.2.2 tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV
    transformers-0.5.6.2
    transformers-base-0.4.5.2-KzHjyAKDkdpHt6juu1Rjxn

haddock-interfaces:   /usr/share/doc/haskell-multistate/html/multistate.haddock
haddock-html:         /usr/share/doc/haskell-multistate/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

