---
title: Tasks
x-toc-enable: true
...

use stock template as fallback
==============================

Right now, a site must specify a template. Include HTML5 and XHTML templates,
and default to the HTML5 one if a site doesn't declare its own template.

Also permit a site to override, in site.cfg, to use another template provided
by Untitled. For example, an XHTML template.

ditto for site.cfg
------------------

Basically, make it so that someone can just make a directory with markdown
files in it. The default template would just have a sitemap link on it.

Make sitemap configurable in site.cfg
=====================================

Right now, it's turned on by the presence of a file. Make it configurable in
site.cfg instead, with it being opt-out, not opt-in.

Use the sitemap.include file if present, otherwise use a default template in
untitled.

Optimize mknews and mksitemap
=============================

Right now, they take up a lot of execution time. Optimize them, like how the
mkhtml function is optimized to minimize disk I/O.

Optimize disk I/O
=================

Right now, most of the execution time in Untitled is disk I/O. Find ways to
optimize that, by reducing unnecessary use of disk I/O.

Make BLOGDIR optional
=====================

For example, if BLOGDIR isn't specified, use the first News section found as
the BLOGDIR. Right now, BLOGDIR is required, and IMO that's a bug.

BLOGDIR is specified in `site.cfg`. You can have multiple blogs / news sections
but BLOGDIR specifies the "default" blog. For instance, you might have a blog
that is organized by months/years, where the current year is always the
default one.

make printf messages come from files
====================================

Right now, a lot of messages are hard-coded in the `build` script.

make messages configurable
--------------------------

For instance, multi-language support, or allow to override with a custom
message.

support translated messages
---------------------------

improved language support
=========================

Right now, the way multi-language pages work is very hacky, and English-as-default
is hardcoded into the logic.

Make the site i18n-compliant. For instance, GNU Gettext could be used (or the
site owner could just maintain whole pages that are translated).

Have directories in untitled, for each language. it will have messages for
printf's used, such as links, specify page language, page direction (left to
right or right to left), what character encoding to use, etc.

daemonize everything
====================

Could also write a daemon program to detect changes in real time, and
update specific pages. Functions would also be needed to selectively update
the news and sitemap pages on each site.

It already is possible to do this, by simply running `./build` in a loop, but
this is very heavy on disk I/O so would cause excessive wear/tear. It also
doesn't scale well on very large websites (think: millions of pages).

Don't delete pages when re-building
===================================

Right now, when site-wide changes are detected, e.g. template change, the
entire site is purged clean so that there are only the Markdown files, and it
is then re-built. For small websites, this is OK, but very large websites (e.g.
millions of pages) would be *offline* for several hours/days because of this.

See above: daemonize everything!

Fix cursed RSS code
===================

The code is actually not bad, but could be better.

Fix cursed title code
=====================

Code for finding title, author and date of pages is very fragile, and BARELY
works, and makes precise assumptions about the type of Markdown variant is in
use, even though Pandoc supports many variants.

Don't sed s/md/html on docs
===========================

`md` links are converted to `html` links, which is correct, but pages that
make reference to `md` files while including the `.` character will be mangled
by this.

The sed replacement is not performed on external links, which is correct, but
incomplete.

support tagging
===============

For instance, a page about cats could have the tags:

* cats
* kittens
* felines

Then you would have a directory called `tag/` automatically generated on the
site, with a directory for each tag, e.g.:

* tag/cats/index.md
* tag/kittens/index.md
* tag/felines/index.md

Make this feature optional, because it would be quite heavy on disk I/O.

petition pages
==============

Such pages could actually be used for many other purposes. An example of a
petition page is here:

<https://rms-support-letter.github.io/>

This could be very useful in general. For example, the [contrib](../contrib.md)
page on this very website could use such a feature!

auto-sort news pages
====================

Right now, a MANIFEST file needs to be present in a news directory. However,
a condition where only `news.cfg` exists could be supported, and pages sorted
automatically based on file *creation* dates (not modification dates).

This would only be a fallback feature, to make the News feature easier to use.
The best option is still to use a MANIFEST file.
