## SPDX-License-Identifier: GPL-2.0-only

bootblock-y += fit.c

# The FIT table is generated as a separate CBFS file.
# The FIT pointer is reserved in fit.c and updated to point to the 'intel_fit'
# CBFS file using 'ifittool -F'.
# With a TOP_SWAP enabled bootblock the FIT pointer at the top swap offset
# will point to the 'intel_fit_ts' CBFS file.

cbfs-files-y += intel_fit
intel_fit-file := fit_table.c:struct
intel_fit-type := intel_fit
intel_fit-align := 16

$(call add_intermediate, set_fit_ptr, $(IFITTOOL))
	@printf "    UPDATE-FIT set FIT pointer to table\n"
	$(IFITTOOL) -f $< -F -n intel_fit -r COREBOOT -c

FIT_ENTRY=$(call strip_quotes, $(CONFIG_INTEL_TOP_SWAP_FIT_ENTRY_FMAP_REG))

endif # CONFIG_UPDATE_IMAGE
