---
title: Dell Latitude E6400
x-toc-enable: true
...

<div class="specs">
<center>
<img tabindex=1 alt="Dell Latitude E6400" class="p" src="https://av.canoeboot.org/e6400/e6400-seabios.jpg" /><span class="f"><img src="https://av.canoeboot.org/e6400/e6400-seabios.jpg" /></span> <img tabindex=1 alt="Dell Latitude E6400 XFR" class="p" style="max-width:24em" src="https://av.canoeboot.org/e6400/e6400xfr-seabios.jpg" /><span class="f"><img src="https://av.canoeboot.org/e6400/e6400xfr-seabios.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | Dell                                           |
| **Name**                   | Latitude E6400                                 |
| **Variants**               | E6400, E6400 XFR and E6400 ATG are supported   |
| **Released**               | 2009                                           |
| **Chipset**                | Intel Cantiga GM45(Intel GPU)/PM45(Nvidia GPU) |
| **CPU**                    | Intel Core 2 Duo (Penryn family).              |
| **Graphics**               | Intel GMA 4500MHD (and NVidia Quadro NVS 160M 
                                                         on some models) |
| **Display**                | 1280x800/1440x900 TFT                          |
| **Memory**                 | 2 or 4GB (Upgradable to 8GB)                   |
| **Architecture**           | x86_64                                         |
| **EC**                     | SMSC MEC5035 with proprietary firmware         |
| **Original boot firmware** | Dell BIOS                                      |
| **Intel ME/AMD PSP**       | Present. Can be completely disabled.           |
| **Flash chip**             | SOIC-8 4MiB or 2MiB+4MiB                       |


```
W+: Works; 
N: Doesn't work; 
U: Untested; 
P+: Partially works; 
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | W+ |
| **Display (if Intel GPU)**                        | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |
| **External output**                               | W+ |
| **Display brightness**                            | P+ | 

| ***Payloads supported***  |           |
|---------------------------|-----------|
| **GRUB**                  | Works     |
| **SeaBIOS**               | Works     |
| **SeaBIOS with GRUB**     | Works     |
</div>

Introduction
============

Known supported variants: E6400, E6400 XFR and E6400 ATG. Only the *Intel*
graphics models are supported; the ones with Nvidia graphics are not compatible
with Canoeboot.

**To install Canoeboot, see: [E6400 installation
instructions](../install/e6400.md)**

ROM images for Dell Latitude E6400 are available for flashing in the Canoeboot
release 20230423 onwards, or you can compile a ROM image for installation via
cbmk, see: [build instructions](../build/)

There are two possible flash chip sizes for the E6400: 4MiB (32Mbit) or 2+4MiB
(16Mbit+32MBit). Canoeboot presently supports the 4MiB version, and provides
8MiB images for those who upgrade their flash to 8MiB or 16MiB. There appears
to be several possible mainboard PCBs for the E6400, which we believe mostly
affects the GPU configuration and the number of available SPI flash footprints:

- LA-3801P: iGPU, possibly dual SPI (however only one may be populated)
- LA-3803P: dGPU, dual SPI (however only one may be populated)
- LA-3805P: iGPU, single SPI flash (4MiB)
- LA-3806P: dGPU, unknown SPI configuration (likely at least 4MiB)

NOTE: dGPU variants are not supported in Canoeboot. Those are the ones with
Nvidia graphics. Canoeboot *only* supports the model with Intel graphics.

These PCB numbers can be found either under the black plastic in the RAM slots
on the bottom (CPU side) of the board, the top left corner near the VGA port
(top side, under the keyboard and palmrest), or near the CPU backplate (only
requires removal of the keyboard).

We believe that all boards will have at least a single 4MiB flash chip,
regardless of the number of SPI footprints. This is likely the most common
configuration on most available systems. The 2+4MiB configuration likely
would have only been used on systems with full Intel ME firmware with AMT
functionality, though this configuration has not yet been encountered.

Most people will want to use the 4MiB images.

Intel GPU: 100% Free Software is possible
---------------

This is a GM45/PM45 platform, so completely libre initialisation in
coreboot is possible, provided by default in Canoeboot.

Management Engine (ME) firmware removed
-------------------------

This port in Canoeboot made use of `ich9gen` from ich9utils, which
you can read about in the [ich9utils manual](../install/ich9utils.md) - this
creates a no-ME setup. The Intel Management Engine firmware (ME) is completely
removed, and the ME disabled, just like on ThinkPad X200, T400 and so on.

*The E6400 laptops may come with the ME (and sometimes AMT in addition) before
flashing canoeboot. Dell also sold configurations with the ME completely
disabled, identifiable by a yellow sticker reading "3 ME Disabled" inside the
bottom panel. This config sets the MeDisable bit in the IFD and sets the ME
region almost entirely to 1's, with the occasional 32-bit value (likely not
executable). Canoeboot disables and removes it by using a modified descriptor:
see [../install/ich9utils.md](../install/ich9utils.md)*
(contains notes, plus instructions)
