// SPDX-FileCopyrightText: 2024 g10 code Gmbh
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include <QHttpServer>
#include <QObject>
#include <QTcpServer>

/// The webserver of the native client
///
/// This webserver will receive webrequests from the outlook web client via
/// the broker.
class WebServer : public QObject
{
    Q_OBJECT
public:
    /// Default contructor.
    WebServer(QObject *parent = nullptr);

    /// Start webserver.
    void run();

    /// \return the port of the webserver. Qt will randomly assign a free port to this
    /// process.
    int port() const;

    /// \return whether the webserver is running.
    bool running() const;

private:
    int m_port;
    bool m_running = false;
    QHttpServer m_server;
    QTcpServer m_tcpserver;
};
