/*
   SPDX-FileCopyrightText: 2015-2023 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once

#include "identity/signature.h"
#include <KPIMTextEdit/RichTextComposer>

class RichTextComposerNgTest;
namespace TextAutoCorrectionCore
{
class AutoCorrection;
}
namespace MessageComposer
{
class TextPart;
class RichTextComposerSignatures;
class RichTextComposerNgPrivate;

/**
 * @brief The RichTextComposerNg class
 * @author Laurent Montel <montel@kde.org>
 */
class RichTextComposerNg : public KPIMTextEdit::RichTextComposer
{
    Q_OBJECT
public:
    explicit RichTextComposerNg(QWidget *parent = nullptr);
    ~RichTextComposerNg() override;
    [[nodiscard]] TextAutoCorrectionCore::AutoCorrection *autocorrection() const;
    void setAutocorrection(TextAutoCorrectionCore::AutoCorrection *autocorrect);

    void setAutocorrectionLanguage(const QString &lang);

    void fillComposerTextPart(MessageComposer::TextPart *textPart);
    [[nodiscard]] MessageComposer::RichTextComposerSignatures *composerSignature() const;

    void insertSignature(const KIdentityManagementCore::Signature &signature,
                         KIdentityManagementCore::Signature::Placement placement,
                         KIdentityManagementCore::Signature::AddedText addedText);
    [[nodiscard]] QString toCleanHtml() const;

    void forceAutoCorrection(bool selectedText = false) override;

protected:
    bool processModifyText(QKeyEvent *event) override;

private:
    std::unique_ptr<RichTextComposerNgPrivate> const d;

    friend class ::RichTextComposerNgTest; // for fixHtmlFontSize
    void fixHtmlFontSize(QString &cleanHtml) const;
};
}
