gpg(1)                                                     gpg(1)



NAME
       gpg -- encryption and signing tool

SYNOPSIS
       gpg  [--homedir name]  [--options file]  [options]  command  [args]

DESCRIPTION
       gpg is the main program for the GnuPG system.


       This  man  page only lists the commands and options avail
       able.  For more verbose documentation get the GNU  Privacy
       Handbook   (GPH)   or   one  of  the  other  documents  at
       http://www.gnupg.org/docs.html .

       Please remember that option parsing stops as soon as a non
       option  is  encountered,  you  can  explicitly stop option
       parsing by using the special option "--".

COMMANDS
       gpg recognizes these commands:

       -s, --sign
                 Make a signature. This command may  be  combined
                 with --encrypt.

       --clearsign
                 Make a clear text signature.

       -b, --detach-sign
                 Make a detached signature.

       -e, --encrypt
                 Encrypt  data.  This option may be combined with
                 --sign.

       -c, --symmetric
                 Encrypt  with  a  symmetric   cipher   using   a
                 passphrase.   The  default symmetric cipher used
                 is CAST5, but may be chosen with  the  --cipher-
                 algo option.

       --store   Store only (make a simple RFC1991 packet).

       --decrypt [file]
                 Decrypt  file (or stdin if no file is specified)
                 and write it to stdout (or  the  file  specified
                 with --output). If the decrypted file is signed,
                 the signature is  also  verified.  This  command
                 differs  from the default operation, as it never
                 writes to the filename which is included in  the
                 file and it rejects files which don't begin with
                 an encrypted message.

       --verify [[sigfile]  [signed-files]]
                 Assume that sigfile is a signature and verify it
                 without  generating  any output.   With no argu
                 ments, the signature packet is read from  stdin.
                 If only a sigfile is given, it may be a complete
                 signature or a detached signature, in which case
                 the  signed  stuff is expected in a file without
                 the ".sig" or ".asc" extension.  With more  than
                 1  argument, the first should be a detached sig
                 nature and the remaining files  are  the  signed
                 stuff.  To read the signed stuff from stdin, use
                 - as the second filename.  For security  reasons
                 a  detached  signature  cannot  read  the signed
                 material from stdin without denoting it  in  the
                 above way.

       --verify-files [files]
                 This  is  a special version of the --verify com
                 mand which does not work  with  detached  signa
                 tures.  The command expects the files to be ver
                 ified either on the command line  or  reads  the
                 filenames from stdin;  each name must be on sep
                 arate line. The command is  intended  for  quick
                 checking of many files.

       --encrypt-files [files]
                 This  is a special version of the --encrypt com
                 mand.  The  command  expects  the  files  to  be
                 encrypted  either  on  the command line or reads
                 the filenames from stdin; each name must  be  on
                 separate  line.  The  command  is intended for a
                 quick encryption of multiple files.

       --decrypt-files [files]
                 The same as --encrypt-files with the  difference
                 that  files will be decrypted. The syntax or the
                 filenames is the same.

       --list-keys [names]

       --list-public-keys [names]
                 List all keys from the public keyrings, or  just
                 the ones given on the command line.

                 Avoid  using  the  output  of  this  command  in
                 scripts or other programs as  it  is  likely  to
                 change  as GnuPG changes.  See --with-colons for
                 a machine-parseable key listing command that  is
                 appropriate  for  use  in scripts and other pro
                 grams.

       --list-secret-keys [names]
                 List all keys from the secret keyrings, or  just
                 the ones given on the command line.  A '#' after
                 the letters 'sec' means that the secret  key  is
                 not  usable  (for example, if it was created via
                 --export-secret-subkeys).

       --list-sigs [names]
                 Same as  --list-keys,  but  the  signatures  are
                 listed too.

                 For  each  signature  listed,  there are several
                 flags in between the "sig" tag and keyid.  These
                 flags  give  additional  information  about each
                 signature.  From left to  right,  they  are  the
                 numbers  1-3  for  certificate  check level (see
                 --default-cert-check-level), "L" for a local  or
                 non-exportable  signature (see --lsign-key), "R"
                 for a nonRevocable signature (see --nrsign-key),
                 "P"  for  a signature that contains a policy URL
                 (see --cert-policy-url),  "N"  for  a  signature
                 that  contains a notation (see --cert-notation),
                 and "X" for an  eXpired  signature  (see  --ask-
                 cert-expire).

       --check-sigs [names]
                 Same as --list-sigs, but the signatures are ver
                 ified.

       --fingerprint [names]
                 List all keys with their fingerprints.  This  is
                 the  same  output  as  --list-keys  but with the
                 additional output of a  line  with  the  finger
                 print.  May also be combined with --list-sigs or
                 --check-sigs.  If this command is  given  twice,
                 the  fingerprints  of  all  secondary  keys  are
                 listed too.

       --list-packets
                 List only  the  sequence  of  packets.  This  is
                 mainly useful for debugging.

       --gen-key Generate  a  new  key pair. This command is nor
                 mally only used interactively.

                 There is an experimental  feature  which  allows
                 you  to  create keys in batch mode. See the file
                 doc/DETAILS in the source distribution on how to
                 use this.

       --edit-key name
                 Present  a  menu which enables you to do all key
                 related tasks:

                 sign      Make a signature on key of  user  name
                           If  the  key  is not yet signed by the
                           default user (or the users given  with
                           -u), the program displays the informa
                           tion of the key again,  together  with
                           its  fingerprint  and  asks whether it
                           should be  signed.  This  question  is
                           repeated  for all users specified with
                           -u.

                 lsign     Same as --sign but  the  signature  is
                           marked   as  non-exportable  and  will
                           therefore never  be  used  by  others.
                           This  may  be  used to make keys valid
                           only in the local environment.

                 nrsign    Same as --sign but  the  signature  is
                           marked as non-revocable and can there
                           fore never be revoked.

                 nrlsign   Combines the functionality  of  nrsign
                           and  lsign to make a signature that is
                           both non-revocable and non-exportable.

                 revsig    Revoke  a signature.  For every signa
                           ture which has been generated  by  one
                           of the secret keys, GnuPG asks whether
                           a  revocation  certificate  should  be
                           generated.

                 trust     Change  the  owner  trust  value. This
                           updates the trust-db  immediately  and
                           no save is required.

                 disable

                 enable    Disable  or  enable  an  entire key. A
                           disabled key can not normally be  used
                           for encryption.

                 adduid    Create an alternate user id.

                 addphoto  Create  a  photographic user id.  This
                           will prompt for a JPEG file that  will
                           be embedded into the user ID.

                 deluid    Delete a user id.

                 revuid    Revoke a user id.

                 addkey    Add a subkey to this key.

                 delkey    Remove a subkey.

                 addrevoker
                           Add  a designated revoker.  This takes
                           one  optional  argument:  "sensitive".
                           If  a  designated revoker is marked as
                           sensitive, it will not be exported  by
                           default (see export-options).

                 revkey    Revoke a subkey.

                 expire    Change  the key expiration time.  If a
                           subkey  is  selected,  the  expiration
                           time  of  this subkey will be changed.
                           With no selection, the key  expiration
                           of the primary key is changed.

                 passwd    Change  the  passphrase  of the secret
                           key.

                 primary   Flag the current user id as  the  pri
                           mary  one, removes the primary user id
                           flag from all other user ids and  sets
                           the  timestamp  of  all affected self-
                           signatures  one  second  ahead.   Note
                           that  setting  a photo user ID as pri
                           mary makes it primary over other photo
                           user  IDs,  and setting a regular user
                           ID as primary makes  it  primary  over
                           other regular user IDs.

                 uid n     Toggle selection of user id with index
                           n.  Use 0 to deselect all.

                 key n     Toggle selection of subkey with  index
                           n.  Use 0 to deselect all.

                 check     Check all selected user ids.

                 showphoto Display the selected photographic user
                           id.

                 pref      List  preferences  from  the  selected
                           user  ID.  This shows the actual pref
                           erences, without including any implied
                           preferences.

                 showpref  More  verbose  preferences listing for
                           the selected user ID.  This shows  the
                           preferences in effect by including the
                           implied preferences of 3DES  (cipher),
                           SHA-1 (digest), and Uncompressed (com
                           pression)  if  they  are  not  already
                           included in the preference list.

                 setpref string
                           Set the list of user ID preferences to
                           string, this should be a string  simi
                           lar  to  the  one  printed  by "pref".
                           Using an empty  string  will  set  the
                           default   preference   string,   using
                           "none" will  set  the  preferences  to
                           nil.   Use "gpg -v --version" to get a
                           list of  available  algorithms.   This
                           command  just  initializes an internal
                           list  and  does  not  change  anything
                           unless   another   command   (such  as
                           "updpref") which changes the self-sig
                           natures is used.

                 updpref   Change the preferences of all user IDs
                           (or just of the selected ones  to  the
                           current   list  of  preferences.   The
                           timestamp of all affected  self-signa
                           tures  will be advanced by one second.
                           Note that while  you  can  change  the
                           preferences  on  an  attribute user ID
                           (aka  "photo  ID"),  GnuPG  does   not
                           select  keys via attribute user IDs so
                           these preferences will not be used  by
                           GnuPG.

                 toggle    Toggle  between  public and secret key
                           listing.

                 save      Save all changes to the key rings  and
                           quit.

                 quit      Quit  the program without updating the
                           key rings.

                 The listing shows you the key with its secondary
                 keys and all user ids. Selected keys or user ids
                 are indicated by an asterisk. The trust value is
                 displayed with the primary key: the first is the
                 assigned owner trust and the second is the  cal
                 culated  trust  value.  Letters are used for the
                 values:

                 -         No ownertrust assigned / not yet  cal
                           culated.

                 e         Trust calculation has failed; probably
                           due to an expired key.

                 q         Not enough  information  for  calcula
                           tion.

                 n         Never trust this key.

                 m         Marginally trusted.

                 f         Fully trusted.

                 u         Ultimately trusted.

       --sign-key name
                 Signs a public key with your secret key. This is
                 a shortcut version of the subcommand "sign" from
                 --edit.

       --lsign-key name
                 Signs  a  public  key  with  your secret key but
                 marks it as non-exportable.  This is a  shortcut
                 version of the subcommand "lsign" from --edit.

       --nrsign-key name
                 Signs  a  public  key  with  your secret key but
                 marks it as non-revocable.  This is  a  shortcut
                 version  of the subcommand "nrsign" from --edit.

       --delete-key name
                 Remove key from the public  keyring.   In  batch
                 mode either --yes is required or the key must be
                 specified by fingerprint.  This is  a  safeguard
                 against accidental deletion of multiple keys.

       --delete-secret-key  name
                 Remove  key  from the secret and public keyring.
                 In batch mode the key must be specified by  fin
                 gerprint.

       --delete-secret-and-public-key  name
                 Same  as  --delete-key,  but  if  a  secret  key
                 exists, it will be removed first. In batch  mode
                 the key must be specified by fingerprint.

       --gen-revoke
                 Generate  a  revocation certificate for the com
                 plete key. To revoke a subkey  or  a  signature,
                 use the --edit command.

       --desig-revoke
                 Generate a designated revocation certificate for
                 a key.  This allows a user (with the  permission
                 of  the keyholder) to revoke someone else's key.

       --export [names]
                 Either  export  all  keys  from   all   keyrings
                 (default   keyrings  and  those  registered  via
                 option --keyring), or if at least  one  name  is
                 given,  those of the given name. The new keyring
                 is written to stdout or to the file  given  with
                 option  "output".   Use together with --armor to
                 mail those keys.

       --send-keys [names]
                 Same as --export but sends the keys  to  a  key
                 server.  Option --keyserver must be used to give
                 the name of this keyserver. Don't send your com
                 plete keyring to a keyserver - select only those
                 keys which are new or changed by you.

       --export-all [names]
                 Same as --export, but also  exports  keys  which
                 are not compatible with OpenPGP.

       --export-secret-keys [names]

       --export-secret-subkeys [names]
                 Same  as  --export,  but exports the secret keys
                 instead.  This is normally not very useful and a
                 security  risk.   The second form of the command
                 has the special property to  render  the  secret
                 part  of  the primary key useless; this is a GNU
                 extension to OpenPGP and  other  implementations
                 can  not be expected to successfully import such
                 a key.

                 See the option --simple-sk-checksum if you  want
                 to  import  such  an  exported key with an older
                 OpenPGP implementation.

       --import [files]

       --fast-import [files]
                 Import/merge keys. This adds the given  keys  to
                 the keyring.  The fast version is currently just
                 a synonym.

                 There are a few other options which control  how
                 this  command  works.   Most notable here is the
                 --merge-only option which does  not  insert  new
                 keys  but  does  only  the merging of new signa
                 tures, user-IDs and subkeys.

       --recv-keys key IDs
                 Import the keys with the given key  IDs  from  a
                 keyserver.  Option  --keyserver  must be used to
                 give the name of this keyserver.

       --refresh-keys key IDs
                 Request updates from a keyserver for  keys  that
                 already  exist  on  the  local keyring.  This is
                 useful for updating a key with the latest signa
                 tures,  user  IDs, etc.  Option --keyserver must
                 be used to give the name of this keyserver.

       --search-keys [names]
                 Search the keyserver for the given names.   Mul
                 tiple  names  given here will be joined together
                 to create the search string for  the  keyserver.
                 Option --keyserver must be used to give the name
                 of this keyserver.

       --update-trustdb
                 Do trust  database  maintenance.   This  command
                 iterates  over  all  keys and builds the Web-of-
                 Trust. This is an interactive command because it
                 may  have to ask for the "ownertrust" values for
                 keys.  The user has to give an estimation of how
                 far she trusts the owner of the displayed key to
                 correctly certify (sign) other keys.  GnuPG only
                 asks  for the ownertrust value if it has not yet
                 been assigned to a key.   Using  the  --edit-key
                 menu,  the  assigned value can be changed at any
                 time.

       --check-trustdb
                 Do  trust  database  maintenance  without   user
                 interaction.    From  time  to  time  the  trust
                 database must be updated so that expired keys or
                 signatures and the resulting changes in the Web-
                 of-Trust can be tracked.  Normally,  GnuPG  will
                 calculate  when this is required and do it auto
                 matically unless --no-auto-check-trustdb is set.
                 This  command  can  be  used  to  force  a trust
                 database check at any time.  The  processing  is
                 identical  to  that  of  --update-trustdb but it
                 skips keys with a not yet defined  "ownertrust".

                 For use with cron jobs, this command can be used
                 together with --batch in which  case  the  trust
                 database  check  is  done  only  if  a  check is
                 needed.  To force a run even in batch  mode  add
                 the option --yes.

       --export-ownertrust
                 Send  the  ownertrust values to stdout.  This is
                 useful for backup purposes as these  values  are
                 the  only  ones which can't be re-created from a
                 corrupted trust DB.

       --import-ownertrust [files]
                 Update the trustdb with  the  ownertrust  values
                 stored  in files (or stdin if not given); exist
                 ing values will be overwritten.

       --rebuild-keydb-caches
                 When updating from version 1.0.6 to  1.0.7  this
                 command  should  be  used  to  create  signature
                 caches in the keyring.  It  might  be  handy  in
                 other situations too.

       --print-md algo [files]

       --print-mds [files]
                 Print  message  digest of algorithm ALGO for all
                 given files or stdin.  With the second form  (or
                 a deprecated "*" as algo) digests for all avail
                 able algorithms are printed.

       --gen-random 0|1|2                 [count]
                 Emit COUNT random bytes  of  the  given  quality
                 level. If count is not given or zero, an endless
                 sequence  of  random  bytes  will  be   emitted.
                 PLEASE,  don't  use this command unless you know
                 what you  are  doing;  it  may  remove  precious
                 entropy from the system!

       --gen-prime mode                  bits             [qbits]
                 Use  the  source, Luke :-). The output format is
                 still subject to change.

       --version Print version information along with a  list  of
                 supported algorithms.

       --warranty
                 Print warranty information.

       -h, --help
                 Print  usage information.  This is a really long
                 list even though it doesn't  list  all  options.
                 For every option, consult this manual.

OPTIONS
       Long  options  can  be  put  in  an  options file (default
       "~/.gnupg/gpg.conf").  Short option names will not work  -
       for  example,  "armor"  is  a valid option for the options
       file, while "a" is not.  Do not write the  2  dashes,  but
       simply  the name of the option and any required arguments.
       Lines with a hash ('#') as the first non-white-space char
       acter  are ignored.  Commands may be put in this file too,
       but that is not generally useful as the command will  exe
       cute automatically with every execution of gpg.

       gpg recognizes these options:

       -a, --armor
                 Create ASCII armored output.

       -o, --output file
                 Write output to file.

       --mangle-dos-filenames

       --no-mangle-dos-filenames
                 The Windows version of GnuPG replaces the exten
                 sion of an output  filename  to  avoid  problems
                 with  filenames  containing  more  than one dot.
                 This is not necessary for newer Windows versions
                 and  so --no-mangle-dos-filenames can be used to
                 switch this feature off and  have  GnuPG  append
                 the new extension.  This option has no effect on
                 non-Windows platforms.

       -u, --local-user name
                 Use name as the user ID to sign.  This option is
                 silently  ignored for the list commands, so that
                 it can be used in an options file.

       --default-key name
                 Use name as default user ID for signatures.   If
                 this  is  not  used  the  default user ID is the
                 first user ID found in the secret keyring.

       -r, --recipient name

                 Encrypt for user id name. If this option is  not
                 specified,  GnuPG  asks  for  the user-id unless
                 --default-recipient is given

       --default-recipient name
                 Use name as default recipient if option --recip
                 ient  is  not  used  and  don't ask if this is a
                 valid one. name must be non-empty.

       --default-recipient-self
                 Use the default  key  as  default  recipient  if
                 option  --recipient is not used and don't ask if
                 this is a valid one.  The  default  key  is  the
                 first one from the secret keyring or the one set
                 with --default-key.

       --no-default-recipient
                 Reset --default-recipient and  --default-recipi
                 ent-self.

       --encrypt-to name
                 Same as --recipient but this one is intended for
                 use in the options file and  may  be  used  with
                 your own user-id as an "encrypt-to-self".  These
                 keys are only used when there are other  recipi
                 ents  given  either  by use of --recipient or by
                 the asked user id.  No trust  checking  is  per
                 formed for these user ids and even disabled keys
                 can be used.

       --no-encrypt-to
                 Disable the use of all --encrypt-to keys.

       -v, --verbose
                 Give more information during processing. If used
                 twice, the input data is listed in detail.

       -q, --quiet
                 Try to be as quiet as possible.

       -z n, --compress n
                 Set  compression  level to n. A value of 0 for n
                 disables compression.  Default  is  to  use  the
                 default  compression level of zlib (normally 6).

       -t, --textmode

       --no-textmode
                 Use canonical text mode.  --no-textmode disables
                 this option.  If -t (but not --textmode) is used
                 together with armoring and signing, this enables
                 clearsigned messages.  This kludge is needed for
                 command-line  compatibility  with   command-line
                 versions  of  PGP; normally you would use --sign
                 or --clearsign to select the type of the  signa
                 ture.

       -n, --dry-run
                 Don't  make  any changes (this is not completely
                 implemented).

       -i, --interactive
                 Prompt before overwriting any files.

       --batch

       --no-batch
                 Use batch mode.  Never ask, do not allow  inter
                 active   commands.    --no-batch  disables  this
                 option.

       --no-tty  Make sure that the TTY (terminal) is never  used
                 for  any  output.  This option is needed in some
                 cases because GnuPG sometimes prints warnings to
                 the TTY if --batch is used.

       --yes     Assume "yes" on most questions.

       --no      Assume "no" on most questions.

       --default-cert-check-level n
                 The  default  to  use  for  the check level when
                 signing a key.

                 0 means you make no particular claim as  to  how
                 carefully you verified the key.

                 1 means you believe the key is owned by the per
                 son who claims to own it but you could  not,  or
                 did  not  verify the key at all.  This is useful
                 for a "persona" verification, where you sign the
                 key of a pseudonymous user.

                 2  means you did casual verification of the key.
                 For example, this could mean that  you  verified
                 that the key fingerprint and checked the user ID
                 on the key against a photo ID.

                 3 means you did extensive  verification  of  the
                 key.  For example, this could mean that you ver
                 ified the key fingerprint with the owner of  the
                 key in person, and that you checked, by means of
                 a hard to forge document with a photo  ID  (such
                 as  a  passport)  that the name of the key owner
                 matches the name in the user ID on the key,  and
                 finally that you verified (by exchange of email)
                 that the email address on the key belongs to the
                 key owner.

                 Note  that the examples given above for levels 2
                 and 3 are just that: examples.  In the  end,  it
                 is  up  to  you to decide just what "casual" and
                 "extensive" mean to you.

                 This option defaults to 0.

       --trusted-key long key ID
                 Assume that the specified  key  (which  must  be
                 given  as a  full 8 byte key ID) is as trustwor
                 thy as one of your own secret keys. This  option
                 is  useful if you don't want to keep your secret
                 keys (or one of them) online but still  want  to
                 be able to check the validity of a given recipi
                 ent's or signator's key.

       --trust-model classic|always
                 Set what trust model GnuPG should  follow.   The
                 models are:


                 classic   This  is  the  regular web-of-trust as
                           used in PGP and GnuPG.

                 always    Skip key validation  and  assume  that
                           used  keys  are  always fully trusted.
                           You won't use  this  unless  you  have
                           installed   some  external  validation
                           scheme.  This option  also  suppresses
                           the  "[uncertain]"  tag  printed  with
                           signature checks when there is no evi
                           dence that the user ID is bound to the
                           key.

       --always-trust
                 Identical to `--trust-model always'

       --keyserver name
                 Use name as your keyserver.  This is the  server
                 that --recv-keys, --send-keys, and --search-keys
                 will communicate with to receive keys from, send
                 keys  to, and search for keys on.  The format of
                 the  name  is  a   URI:   `scheme:[//]keyserver
                 name[:port]'  The  scheme  is  the  type of key
                 server: "hkp" for the Horowitz  (or  compatible)
                 keyservers,  "ldap"  for the NAI LDAP keyserver,
                 or "mailto" for the  Horowitz  email  keyserver.
                 Note  that your particular installation of GnuPG
                 may have  other  keyserver  types  available  as
                 well.  Keyserver schemes are case-insensitive.

                 Most  keyservers synchronize with each other, so
                 there is generally no need to send keys to  more
                 than  one  server.   Using  the command "host -l
                 pgp.net | grep wwwkeys" gives you a list of  HKP
                 keyservers.   When  using  one  of  the  wwwkeys
                 servers, due to load balancing using round-robin
                 DNS  you may notice that you get a different key
                 server each time.

       --keyserver-options parameters
                 This is a space or comma delimited  string  that
                 gives options for the keyserver.  Options can be
                 prepended with a  `no-'  to  give  the  opposite
                 meaning.  Valid import-options or export-options
                 may be used here as well to apply  to  importing
                 (--recv-key)  or  exporting  (--send-key)  a key
                 from a keyserver.  While  not  all  options  are
                 available  for  all keyserver types, some common
                 options are:

                 include-revoked
                           When  searching   for   a   key   with
                           --search-keys,  include  keys that are
                           marked on the  keyserver  as  revoked.
                           Note  that  this  option is always set
                           when using the NAI HKP  keyserver,  as
                           this  keyserver does not differentiate
                           between revoked and unrevoked keys.

                 include-disabled
                           When  searching   for   a   key   with
                           --search-keys,  include  keys that are
                           marked on the keyserver  as  disabled.
                           Note that this option is not used with
                           HKP keyservers.

                 include-subkeys
                           When receiving a key, include  subkeys
                           as  potential targets.  Note that this
                           option  is  not  used  with  HKP  key
                           servers,   as   they  do  not  support
                           retrieving keys by subkey id.

                 use-temp-files
                           On  most  Unix-like  platforms,  GnuPG
                           communicates with the keyserver helper
                           program via pipes, which is  the  most
                           efficient  method.  This option forces
                           GnuPG to use temporary files to commu
                           nicate.   On  some  platforms (such as
                           Win32 and RISC  OS),  this  option  is
                           always enabled.

                 keep-temp-files
                           If   using  `use-temp-files',  do  not
                           delete  the  temp  files  after  using
                           them.   This option is useful to learn
                           the keyserver  communication  protocol
                           by reading the temporary files.

                 verbose   Tell  the  keyserver helper program to
                           be more verbose.  This option  can  be
                           repeated  multiple  times  to increase
                           the verbosity level.

                 honor-http-proxy
                           For keyserver schemes  that  use  HTTP
                           (such  as HKP), try to access the key
                           server over the  proxy  set  with  the
                           environment variable "http_proxy".

                 auto-key-retrieve
                           This   option  enables  the  automatic
                           retrieving of keys  from  a  keyserver
                           when verifying signatures made by keys
                           that are not on the local keyring.

       --import-options parameters
                 This is a space or comma delimited  string  that
                 gives  options  for importing keys.  Options can
                 be prepended with a `no-' to give  the  opposite
                 meaning.  The options are:

                 allow-local-sigs
                           Allow  importing key signatures marked
                           as "local".   This  is  not  generally
                           useful  unless a shared keyring scheme
                           is being used.  Defaults to no.

                 repair-pks-subkey-bug
                           During import, attempt to  repair  the
                           damage caused by the PKS keyserver bug
                           (pre version 0.9.6) that mangles  keys
                           with multiple subkeys.  Note that this
                           cannot completely repair  the  damaged
                           key as some crucial data is removed by
                           the keyserver, but it  does  at  least
                           give you back one subkey.  Defaults to
                           no for regular --import and to yes for
                           keyserver --recv-keys.

       --export-options parameters
                 This  is  a space or comma delimited string that
                 gives options for exporting keys.   Options  can
                 be  prepended  with a `no-' to give the opposite
                 meaning.  The options are:

                 include-non-rfc
                           Include non-RFC compliant keys in  the
                           export.  Defaults to yes.

                 include-local-sigs
                           Allow  exporting key signatures marked
                           as "local".   This  is  not  generally
                           useful  unless a shared keyring scheme
                           is being used.  Defaults to no.

                 include-attributes
                           Include attribute user IDs (photo IDs)
                           while  exporting.   This  is useful to
                           export keys if they are  going  to  be
                           used  by  an OpenPGP program that does
                           not   accept   attribute   user   IDs.
                           Defaults to yes.

                 include-sensitive-revkeys
                           Include designated revoker information
                           that  was   marked   as   "sensitive".
                           Defaults to no.

       --show-photos

       --no-show-photos
                 Causes  --list-keys, --list-sigs, --list-public-
                 keys,  --list-secret-keys,   and   verifying   a
                 signature  to also display the photo ID attached
                 to the key, if any.   See  also  --photo-viewer.
                 --no-show-photos disables this option.

       --photo-viewer string
                 This  is  the command line that should be run to
                 view a photo ID.  "%i" will  be  expanded  to  a
                 filename  containing  the  photo.  "%I" does the
                 same, except the file will not be  deleted  once
                 the  viewer exits.  Other flags are "%k" for the
                 key ID, "%K" for the long key ID, "%f"  for  the
                 key  fingerprint,  "%t" for the extension of the
                 image type (e.g. "jpg"), "%T" for the MIME  type
                 of  the  image (e.g. "image/jpeg"), and "%%" for
                 an actual percent sign.  If neither %i or %I are
                 present,  then the photo will be supplied to the
                 viewer on standard input.

                 The default viewer is "xloadimage  -fork  -quiet
                 -title  'KeyID  0x%k' stdin".  Note that if your
                 image viewer program is not secure, then execut
                 ing it from GnuPG does not make it secure.

       --exec-path string
                 Sets  a  list of directories to search for photo
                 viewers and keyserver helpers.  If not provided,
                 keyserver  helpers  use  the compiled-in default
                 directory, and photo viewers use the $PATH envi
                 ronment variable.

       --show-keyring
                 Causes   --list-keys,   --list-public-keys,  and
                 --list-secret-keys to display the  name  of  the
                 keyring  a  given  key  resides on. This is only
                 useful when you're listing a specific key or set
                 of keys. It has no effect when listing all keys.

       --keyring file
                 Add file to  the  list  of  keyrings.   If  file
                 begins  with  a  tilde  and  a  slash, these are
                 replaced by the HOME directory. If the  filename
                 does not contain a slash, it is assumed to be in
                 the GnuPG home directory ("~/.gnupg" if  --home
                 dir  is not used).  The filename may be prefixed
                 with a scheme:

                 "gnupg-ring:" is the default one.

                 It might make sense  to  use  it  together  with
                 --no-default-keyring.

       --secret-keyring file
                 Same as --keyring but for the secret keyrings.

       --trustdb-name file
                 Use  file  instead  of  the default trustdb.  If
                 file begins with a tilde and a slash, these  are
                 replaced  by the HOME directory. If the filename
                 does not contain a slash, it is assumed to be in
                 the  GnuPG home directory ("~/.gnupg" if --home
                 dir is not used).

       --homedir directory
                 Set the name of the home directory to  directory
                 If  this  option  is  not  used  it  defaults to
                 "~/.gnupg". It does not make sense to  use  this
                 in a options file. This also overrides the envi
                 ronment variable "GNUPGHOME".

       --charset name
                 Set the name of the native character set.   This
                 is  used to convert some strings to proper UTF-8
                 encoding.  If  this  option  is  not  used,  the
                 default  character  set  is  determined from the
                 current locale.  A verbosity level  of  3  shows
                 the used one.  Valid values for name are:

                 iso-8859-1
                           This is the Latin 1 set.

                 iso-8859-2
                           The Latin 2 set.

                 iso-8859-15
                           This  is  currently  an  alias for the
                           Latin 1 set.

                 koi8-r    The usual Russian set (rfc1489).

                 utf-8     Bypass  all  translations  and  assume
                           that  the  OS uses native UTF-8 encod
                           ing.

       --utf8-strings

       --no-utf8-strings
                 Assume that the arguments are already  given  as
                 UTF8  strings.   The default (--no-utf8-strings)
                 is to assume that arguments are encoded  in  the
                 character  set  as specified by --charset. These
                 options affect all  following  arguments.   Both
                 options may be used multiple times.

       --options file
                 Read  options  from  file and do not try to read
                 them from the default options file in the  home
                 dir  (see  --homedir). This option is ignored if
                 used in an options file.

       --no-options
                 Shortcut for "--options /dev/null".  This option
                 is  detected before an attempt to open an option
                 file.  Using this option will also  prevent  the
                 creation of a "~./gnupg" homedir.

       --load-extension name
                 Load  an extension module. If name does not con
                 tain a slash it is searched for in the directory
                 configured   when  GnuPG  was  built  (generally
                 "/usr/local/lib/gnupg").   Extensions  are   not
                 generally  useful  anymore,  and the use of this
                 option is deprecated.

       --debug flags
                 Set debugging flags. All  flags  are  or-ed  and
                 flags may be given in C syntax (e.g. 0x0042).

       --debug-all
                 Set all useful debugging flags.

       --enable-progress-filter
                 Enable  certain  PROGRESS  status outputs.  This
                 option allows frontends to  display  a  progress
                 indicator  while gpg is processing larger files.
                 There is a slight performance overhead using it.

       --status-fd n
                 Write   special   status  strings  to  the  file
                 descriptor n.  See the file DETAILS in the docu
                 mentation for a listing of them.

       --logger-fd n
                 Write log output to file descriptor n and not to
                 stderr.

       --attribute-fd n
                 Write attribute subpackets to the file  descrip
                 tor  n.  This is most useful for use with --sta
                 tus-fd, since the status messages are needed  to
                 separate  out  the  various  subpackets from the
                 stream delivered to the file descriptor.

       --sk-comments

       --no-sk-comments
                 Include secret key comment packets when  export
                 ing  secret  keys.  This is a GnuPG extension to
                 the OpenPGP standard, and  is  off  by  default.
                 Please note that this has nothing to do with the
                 comments in clear text signatures or armor head
                 ers.  --no-sk-comments disables this option.

       --no-comment
                 See --no-sk-comments.  This option is deprecated
                 and may be removed soon.

       --comment string
                 Use string as the comment string in  clear  text
                 signatures.   The default behavior is not to use
                 a comment string.

       --default-comment
                 Force to write the standard  comment  string  in
                 clear  text signatures.  Use this to overwrite a
                 --comment from a config file.   This  option  is
                 now obsolete because there is no default comment
                 string anymore.

       --emit-version

       --no-emit-version
                 Force inclusion of the version string  in  ASCII
                 armored output.  --no-emit-version disables this
                 option.

       --sig-notation name=value

       --cert-notation name=value

       -N, --set-notation name=value
                 Put the name value pair into  the  signature  as
                 notation data.  name must consist only of print
                 able characters or spaces, and  must  contain  a
                 '@'  character.   This is to help prevent pollu
                 tion of the IETF  reserved  notation  namespace.
                 The --expert flag overrides the encoded in UTF8,
                 so you should check that your --charset  is  set
                 correctly.    If   you   prefix   name  with  an
                 exclamation mark,  the  notation  data  will  be
                 flagged  as critical (rfc2440:5.2.3.15).  --sig-
                 notation sets a notation  for  data  signatures.
                 --cert-notation  sets  a notation for key signa
                 tures  (certifications).   --set-notation   sets
                 both.

                 There  are  special  codes  that  may be used in
                 notation names.  "%k" will be expanded into  the
                 key  ID  of  the key being signed, "%K" into the
                 long key ID of the key being signed,  "%f"  into
                 the  fingerprint  of  the key being signed, "%s"
                 into the key ID of the key making the signature,
                 "%S"  into the long key ID of the key making the
                 signature, "%g" into the fingerprint of the  key
                 making  the signature (which might be a subkey),
                 "%p" into the fingerprint of the primary key  of
                 the  key  making the signature, and "%%" results
                 in a single "%".  %k, %K, and %f are only  mean
                 ingful  when  making a key signature (certifica
                 tion).

       --show-notation

       --no-show-notation
                 Show signature notations in the  --list-sigs  or
                 --check-sigs  listings as well as when verifying
                 a signature with a notation in  it.   --no-show-
                 notation disables this option.

       --sig-policy-url string

       --cert-policy-url string

       --set-policy-url string
                 Use   string   as   Policy  URL  for  signatures
                 (rfc2440:5.2.3.19).  If you prefix  it  with  an
                 exclamation  mark, the policy URL packet will be
                 flagged as critical.  --sig-policy-url sets a  a
                 policy  url for data signatures.  --cert-policy-
                 url sets a policy url for key signatures (certi
                 fications).  --set-policy-url sets both.

                 The  same  %-expandos used for notation data are
                 available here as well.

       --show-policy-url

       --no-show-policy-url
                 Show policy URLs in the --list-sigs or  --check-
                 sigs listings as well as when verifying a signa
                 ture with a policy URL in it.  --no-show-policy-
                 url disables this option.

       --set-filename string
                 Use  string  as  the  filename  which  is stored
                 inside messages.  This  overrides  the  default,
                 which  is to use the actual filename of the file
                 being encrypted.

       --for-your-eyes-only

       --no-for-your-eyes-only
                 Set the `for your eyes only' flag  in  the  mes
                 sage.   This  causes GnuPG to refuse to save the
                 file unless the --output option  is  given,  and
                 PGP  to  use the "secure viewer" with a Tempest-
                 resistant font to  display  the  message.   This
                 option overrides --set-filename.  --no-for-your-
                 eyes-only disables this option.

       --use-embedded-filename
                 Try to create a file with a name as embedded  in
                 the  data.  This can be a dangerous option as it
                 allows to overwrite files.

       --completes-needed n
                 Number of completely trusted users to  introduce
                 a new key signer (defaults to 1).

       --marginals-needed n
                 Number  of marginally trusted users to introduce
                 a new key signer (defaults to 3)

       --max-cert-depth n
                 Maximum depth of a certification chain  (default
                 is 5).

       --cipher-algo name
                 Use   name as cipher algorithm. Running the pro
                 gram with the command --version yields a list of
                 supported  algorithms.  If  this is not used the
                 cipher algorithm is selected  from  the  prefer
                 ences stored with the key.

       --digest-algo name
                 Use  name  as the message digest algorithm. Run
                 ning the  program  with  the  command  --version
                 yields a list of supported algorithms.

       --cert-digest-algo name
                 Use  name  as  the message digest algorithm used
                 when signing a key.  Running  the  program  with
                 the command --version yields a list of supported
                 algorithms.  Be aware  that  if  you  choose  an
                 algorithm  that GnuPG supports but other OpenPGP
                 implementations do not, then some users will not
                 be  able  to use the key signatures you make, or
                 quite possibly your entire key.

       --s2k-cipher-algo name
                 Use name as the cipher algorithm used to protect
                 secret keys.  The default cipher is CAST5.  This
                 cipher is also used for conventional  encryption
                 if --cipher-algo is not given.

       --s2k-digest-algo name
                 Use  name as the digest algorithm used to mangle
                 the  passphrases.   The  default  algorithm   is
                 SHA-1.   This  digest algorithm is also used for
                 conventional encryption if --digest-algo is  not
                 given.

       --s2k-mode n
                 Selects how passphrases are mangled. If n is 0 a
                 plain passphrase (which is not recommended) will
                 be used, a 1 adds a salt to the passphrase and a
                 3 (the default) iterates  the  whole  process  a
                 couple of times.  Unless --rfc1991 is used, this
                 mode is also used for conventional encryption.

       --simple-sk-checksum
                 Secret keys are integrity protected by  using  a
                 SHA-1  checksum.  This method will be part of an
                 enhanced OpenPGP specification but GnuPG already
                 uses  it  as  a  countermeasure  against certain
                 attacks.  Old applications don't understand this
                 new format, so this option may be used to switch
                 back to the  old  behaviour.   Using  this  this
                 option  bears  a security risk.  Note that using
                 this option only takes effect  when  the  secret
                 key is encrypted - the simplest way to make this
                 happen is to change the passphrase  on  the  key
                 (even  changing  it to the same value is accept
                 able).

       --compress-algo n
                 Use compression algorithm n.   The  value  2  is
                 RFC1950   ZLIB  compression.   The  value  1  is
                 RFC-1951 ZIP compression which is used  by  PGP.
                 0  disables  compression.  If this option is not
                 used, the default behavior  is  to  examine  the
                 recipient  key  preferences  to  see which algo
                 rithms the  recipient  supports.   If  all  else
                 fails,  ZIP  is  used for maximum compatibility.
                 Note, however, that ZLIB may  give  better  com
                 pression  results  if that is more important, as
                 the compression window size is  not  limited  to
                 8k.

       --disable-cipher-algo name
                 Never allow the use of name as cipher algorithm.
                 The given name will not be  checked  so  that  a
                 later  loaded algorithm will still get disabled.

       --disable-pubkey-algo name
                 Never allow the use of name as public key  algo
                 rithm.   The  given  name will not be checked so
                 that a later loaded  algorithm  will  still  get
                 disabled.

       --no-sig-cache
                 Do not cache the verification status of key sig
                 natures.  Caching gives a  much  better  perfor
                 mance  in key listings.  However, if you suspect
                 that your public keyring  is  not  save  against
                 write  modifications, you can use this option to
                 disable the caching.  It probably does not  make
                 sense  to  disable it because all kind of damage
                 can be done if someone else has write access  to
                 your public keyring.

       --no-sig-create-check
                 GnuPG  normally  verifies  each  signature right
                 after creation to protect against bugs and hard
                 ware malfunctions which could leak out bits from
                 the secret key.  This extra  verification  needs
                 some time (about 115% for DSA keys), and so this
                 option can be used to disable it.  However,  due
                 to  the  fact  that the signature creation needs
                 manual  interaction,  this  performance  penalty
                 does not matter in most settings.

       --auto-check-trustdb

       --no-auto-check-trustdb
                 If  GnuPG  feels  that its information about the
                 Web-of-Trust has to be updated, it automatically
                 runs  the  --check-trustdb  command  internally.
                 This may be a  time  consuming  process.   --no-
                 auto-check-trustdb disables this option.

       --throw-keyid
                 Do  not  put  the  keyid into encrypted packets.
                 This option hides the receiver  of  the  message
                 and  is  a countermeasure against traffic analy
                 sis.  It may slow down  the  decryption  process
                 because all available secret keys are tried.

       --not-dash-escaped
                 This  option  changes  the behavior of cleartext
                 signatures so that they can be  used  for  patch
                 files.  You should not send such an armored file
                 via email because all spaces  and  line  endings
                 are hashed too.  You can not use this option for
                 data which has 5 dashes at the  beginning  of  a
                 line,  patch  files  don't  have this. A special
                 armor header line tells GnuPG about this cleart
                 ext signature option.

       --escape-from-lines

       --no-escape-from-lines
                 Because  some mailers change lines starting with
                 "From " to ">From " it is good  to  handle  such
                 lines  in  a special way when creating cleartext
                 signatures  to  prevent  the  mail  system  from
                 breaking the signature.  Note that all other PGP
                 versions  do  it  this  way  too.   Enabled   by
                 default.   --no-escape-from-lines  disables this
                 option.

       --passphrase-fd n
                 Read the passphrase from file descriptor  n.  If
                 you  use  0  for  n, the passphrase will be read
                 from stdin.     This can only be  used  if  only
                 one  passphrase  is  supplied.   Don't  use this
                 option if you can avoid it.

       --command-fd n
                 This is a replacement for the deprecated shared-
                 memory  IPC  mode.   If  this option is enabled,
                 user input on questions is not expected from the
                 TTY  but  from  the  given  file descriptor.  It
                 should be used together  with  --status-fd.  See
                 the  file doc/DETAILS in the source distribution
                 for details on how to use it.

       --use-agent

       --no-use-agent
                 Try to use the  GnuPG-Agent.  Please  note  that
                 this  agent  is  still  under development.  With
                 this option, GnuPG first tries to connect to the
                 agent  before  it  asks for a passphrase.  --no-
                 use-agent disables this option.

       --gpg-agent-info
                 Override the value of the  environment  variable
                 GPG_AGENT_INFO.   This  is only used when --use-
                 agent has been given

       Compliance options
                 These options control what  GnuPG  is  compliant
                 to.   Only one of these options may be active at
                 a time.  Note that the default setting  of  this
                 is  nearly  always  the  correct  one.   See the
                 INTEROPERABILITY  WITH  OTHER  OPENPGP  PROGRAMS
                 section below before using one of these options.

                 --gnupg   Use standard GnuPG behavior.  This  is
                           essentially   OpenPGP   behavior  (see
                           --openpgp), but with  some  additional
                           workarounds  for  common compatibility
                           problems in different versions of PGP.
                           This  is  the default option, so it is
                           not generally needed, but  it  may  be
                           useful to override a different compli
                           ance option in the gpg.conf file.

                 --openpgp Reset all packet,  cipher  and  digest
                           options  to  strict  OpenPGP behavior.
                           Use this option to reset all  previous
                           options   like   --rfc1991,   --force-
                           v3-sigs,    --s2k-*,    --cipher-algo,
                           --digest-algo  and  --compress-algo to
                           OpenPGP  compliant  values.   All  PGP
                           workarounds are disabled.

                 --rfc1991 Try to be more RFC-1991 (PGP 2.x) com
                           pliant.

                 --pgp2    Set up all options to be  as  PGP  2.x
                           compliant  as possible, and warn if an
                           action is taken (e.g. encrypting to  a
                           non-RSA  key)  that will create a mes
                           sage that PGP 2.x will not be able  to
                           handle.   Note  that  `PGP  2.x'  here
                           means  `MIT  PGP  2.6.2'.   There  are
                           other  versions  of PGP 2.x available,
                           but the MIT release is a  good  common
                           baseline.

                           This  option implies `--rfc1991 --dis
                           able-mdc --no-force-v4-certs  --no-sk-
                           comment  --escape-from-lines  --force-
                           v3-sigs --no-ask-sig-expire  --no-ask-
                           cert-expire     --cipher-algo     IDEA
                           --digest-algo MD5 --compress-algo  1'.
                           It   also   disables  --textmode  when
                           encrypting.

                 --pgp6    Set up all options to be as PGP 6 com
                           pliant  as  possible.   This restricts
                           you to the ciphers IDEA (if  the  IDEA
                           plugin is installed), 3DES, and CAST5,
                           the hashes MD5,  SHA1  and  RIPEMD160,
                           and  the  compression  algorithms none
                           and ZIP.  This also disables  --throw-
                           keyid,   and  making  signatures  with
                           signing subkeys  as  PGP  6  does  not
                           understand  signatures made by signing
                           subkeys.

                           This  option  implies   `--disable-mdc
                           --no-sk-comment    --escape-from-lines
                           --force-v3-sigs --no-ask-sig-expire'

                 --pgp7    Set up all options to be as PGP 7 com
                           pliant as possible.  This is identical
                           to --pgp6 except  that  MDCs  are  not
                           disabled,  and  the  list of allowable
                           ciphers is  expanded  to  add  AES128,
                           AES192, AES256, and TWOFISH.

                 --pgp8    Set up all options to be as PGP 8 com
                           pliant as possible.  PGP 8  is  a  lot
                           closer  to  the  OpenPGP standard than
                           previous versions of PGP, so all  this
                           does  is disable --throw-keyid and set
                           --escape-from-lines.    The    allowed
                           algorithms  list is the same as --pgp7
                           with  the  addition  of  the   SHA-256
                           digest algorithm.

       --force-v3-sigs

       --no-force-v3-sigs
                 OpenPGP  states  that  an  implementation should
                 generate v4 signatures but PGP  versions  5  and
                 higher only recognize v4 signatures on key mate
                 rial.  This option forces v3 signatures for sig
                 natures  on  data.   Note that this option over
                 rides --ask-sig-expire, as v3 signatures  cannot
                 have  expiration dates.  --no-force-v3-sigs dis
                 ables this option.

       --force-v4-certs

       --no-force-v4-certs
                 Always use v4 key signatures even  on  v3  keys.
                 This  option also changes the default hash algo
                 rithm for v3 RSA keys from MD5 to SHA-1.   --no-
                 force-v4-certs disables this option.

       --force-mdc
                 Force  the use of encryption with a modification
                 detection code.  This is always  used  with  the
                 newer  ciphers  (those  with a blocksize greater
                 than 64 bits), or if all of the  recipient  keys
                 indicate MDC support in their feature flags.

       --disable-mdc
                 Disable  the  use  of the modification detection
                 code.  Note  that  by  using  this  option,  the
                 encrypted  message  becomes vulnerable to a mes
                 sage modification attack.

       --allow-non-selfsigned-uid

       --no-allow-non-selfsigned-uid
                 Allow the import and use of keys with  user  IDs
                 which  are  not self-signed.  This is not recom
                 mended, as a non self-signed user ID is  trivial
                 to  forge.   --no-allow-non-selfsigned-uid  dis
                 ables.

       --allow-freeform-uid
                 Disable all checks on the form of  the  user  ID
                 while  generating a new one.  This option should
                 only be used in very special environments as  it
                 does  not ensure the de-facto standard format of
                 user IDs.

       --ignore-time-conflict
                 GnuPG  normally  checks  that   the   timestamps
                 associated with keys and signatures have plausi
                 ble  values.   However,  sometimes  a  signature
                 seems  to  be  older  than  the key due to clock
                 problems.  This option makes these checks just a
                 warning.    See   also  --ignore-valid-from  for
                 timestamp issues on subkeys.

       --ignore-valid-from
                 GnuPG normally does not select and  use  subkeys
                 created  in  the future.  This option allows the
                 use of such keys and thus exhibits the pre-1.0.7
                 behaviour.   You  should  not  use  this  option
                 unless you there is  some  clock  problem.   See
                 also --ignore-time-conflict for timestamp issues
                 with signatures.

       --ignore-crc-error
                 The ASCII armor used by OpenPGP is protected  by
                 a  CRC  checksum  against  transmission  errors.
                 Sometimes it happens that the CRC  gets  mangled
                 somewhere  on  the  transmission channel but the
                 actual  content  (which  is  protected  by   the
                 OpenPGP  protocol  anyway)  is still okay.  This
                 option will let gpg ignore CRC errors.

       --ignore-mdc-error
                 This option changes a MDC  integrity  protection
                 failure into a warning.  This can be useful if a
                 message is partially corrupt, but it  is  neces
                 sary  to get as much data as possible out of the
                 corrupt message.  However, be aware that  a  MDC
                 protection  failure  may also mean that the mes
                 sage  was  tampered  with  intentionally  by  an
                 attacker.

       --lock-once
                 Lock  the  databases  the  first  time a lock is
                 requested and do not release the lock until  the
                 process terminates.

       --lock-multiple
                 Release the locks every time a lock is no longer
                 needed. Use this to override a previous  --lock-
                 once from a config file.

       --lock-never
                 Disable locking entirely.  This option should be
                 used only in very special environments, where it
                 can  be assured that only one process is access
                 ing those  files.   A  bootable  floppy  with  a
                 stand-alone  encryption system will probably use
                 this.  Improper usage of this option may lead to
                 data and key corruption.

       --no-random-seed-file
                 GnuPG  uses  a file to store its internal random
                 pool over invocations.  This makes random gener
                 ation faster; however sometimes write operations
                 are not desired.  This option  can  be  used  to
                 achieve that with the cost of slower random gen
                 eration.

       --no-verbose
                 Reset verbose level to 0.

       --no-greeting
                 Suppress the initial copyright message.

       --no-secmem-warning
                 Suppress the warning about "using insecure  mem
                 ory".

       --no-permission-warning
                 Suppress  the warning about unsafe file and home
                 directory (--homedir)  permissions.   Note  that
                 the  permission  checks  that GnuPG performs are
                 not intended to  be  authoritative,  but  rather
                 they simply warn about certain common permission
                 problems.  Do not assume  that  the  lack  of  a
                 warning means that your system is secure.

                 Note  that the warning for unsafe --homedir per
                 missions cannot be  supressed  in  the  gpg.conf
                 file,  as  this would allow an attacker to place
                 an unsafe gpg.conf file in place, and  use  this
                 file  to  supress  warnings  about  itself.  The
                 --homedir  permissions  warning  may   only   be
                 supressed on the command line.

       --no-mdc-warning
                 Suppress the warning about missing MDC integrity
                 protection.

       --no-armor
                 Assume the input data is not  in  ASCII  armored
                 format.

       --no-default-keyring
                 Do  not  add the default keyrings to the list of
                 keyrings.

       --skip-verify
                 Skip the signature verification step.  This  may
                 be  used  to  make  the decryption faster if the
                 signature verification is not needed.

       --with-colons
                 Print key listings delimited  by  colons.   Note
                 that the output will be encoded in UTF-8 regard
                 less of any --charset setting.  This  format  is
                 useful  when  GnuPG  is  called from scripts and
                 other programs as it is easily  machine  parsed.
                 The details of this format are documented in the
                 file doc/DETAILS, which is included in the GnuPG
                 source distribution.

       --with-key-data
                 Print  key  listings  delimited  by colons (like
                 --with-colons) and print the public key data.

       --with-fingerprint
                 Same as the command  --fingerprint  but  changes
                 only  the  format  of the output and may be used
                 together with another command.

       --fast-list-mode
                 Changes the output of the list commands to  work
                 faster;  this  is achieved by leaving some parts
                 empty.  Some applications don't need the user ID
                 and the trust information given in the listings.
                 By using this options  they  can  get  a  faster
                 listing.  The exact behaviour of this option may
                 change in future versions.

       --fixed-list-mode
                 Do not merge primary user ID and primary key  in
                 --with-colon  listing  mode and print all times
                 tamps as seconds since 1970-01-01.

       --list-only
                 Changes the behaviour of some commands.  This is
                 like --dry-run but different in some cases.  The
                 semantic of this command may be extended in  the
                 future.   Currently  it  only  skips  the actual
                 decryption pass and  therefore  enables  a  fast
                 listing of the encryption keys.

       --no-literal
                 This  is  not for normal use.  Use the source to
                 see for what it might be useful.

       --set-filesize
                 This is not for normal use.  Use the  source  to
                 see for what it might be useful.

       --emulate-md-encode-bug
                 GnuPG  versions  prior to 1.0.2 had a bug in the
                 way  a  signature  was  encoded.   This  options
                 enables  a  workaround by checking faulty signa
                 tures again with the encoding used in  old  ver
                 sions.   This may only happen for ElGamal signa
                 tures which are not widely used.

       --show-session-key
                 Display the session key used  for  one  message.
                 See  --override-session-key  for the counterpart
                 of this option.

                 We think that Key-Escrow is a Bad Thing; however
                 the  user  should  have  the  freedom  to decide
                 whether to go to prison or to reveal the content
                 of one specific message without compromising all
                 messages ever  encrypted  for  one  secret  key.
                 DON'T  USE IT UNLESS YOU ARE REALLY FORCED TO DO
                 SO.

       --override-session-key string
                 Don't use the public key  but  the  session  key
                 string.   The  format of this string is the same
                 as the one printed by --show-session-key.   This
                 option  is  normally not used but comes handy in
                 case someone forces you to reveal the content of
                 an  encrypted message; using this option you can
                 do this without handing out the secret key.

       --ask-sig-expire

       --no-ask-sig-expire
                 When making a  data  signature,  prompt  for  an
                 expiration  time.   If this option is not speci
                 fied, the expiration time is "never".  --no-ask-
                 sig-expire disables this option.

       --ask-cert-expire

       --no-ask-cert-expire
                 When making a key signature, prompt for an expi
                 ration time.  If this option is  not  specified,
                 the  expiration time is "never".  --no-ask-cert-
                 expire disables this option.

       --expert

       --no-expert
                 Allow the user  to  do  certain  nonsensical  or
                 "silly"   things  like  signing  an  expired  or
                 revoked key, or certain potentially incompatible
                 things  like  generating  deprecated  key types.
                 This  also  disables  certain  warning  messages
                 about  potentially incompatible actions.  As the
                 name implies, this option is for  experts  only.
                 If  you  don't fully understand the implications
                 of what it allows you to  do,  leave  this  off.
                 --no-expert disables this option.

       --merge-only
                 Don't  insert  new  keys into the keyrings while
                 doing an import.

       --allow-secret-key-import
                 This is an obsolete option and is not used  any
                 where.

       --try-all-secrets
                 Don't  look  at the key ID as stored in the mes
                 sage but try all secret keys in turn to find the
                 right  decryption  key.   This option forces the
                 behaviour as used by anonymous recipients  (cre
                 ated  by  using  --throw-keyid)  and  might come
                 handy in case where an  encrypted  message  con
                 tains a bogus key ID.

       --enable-special-filenames
                 This  options  enables a mode in which filenames
                 of the form -&n, where n is a non-negative deci
                 mal  number,  refer to the file descriptor n and
                 not to a file with that name.

       --no-expensive-trust-checks
                 Experimental use only.

       --group name=value1 [value2 value3 ...]
                 Sets up a  named  group,  which  is  similar  to
                 aliases  in  email programs.  Any time the group
                 name is a recipient (-r or --recipient), it will
                 be expanded to the values specified.

                 The  values are key IDs or fingerprints, but any
                 key description is accepted.  Note that a  value
                 with spaces in it will be treated as two differ
                 ent values.  Note also there is only  one  level
                 of  expansion  -  you  cannot make an group that
                 points to another group.   When  used  from  the
                 command  line,  it may be necessary to quote the
                 argument to this option  to  prevent  the  shell
                 from treating it as multiple arguments.

       --preserve-permissions
                 Don't change the permissions of a secret keyring
                 back to user read/write only.  Use  this  option
                 only if you really know what you are doing.

       --personal-cipher-preferences string
                 Set  the  list of personal cipher preferences to
                 string, this list should be a string similar  to
                 the  one  printed  by  the command "pref" in the
                 edit menu.  This allows the user  to  factor  in
                 their  own  preferred algorithms when algorithms
                 are chosen via recipient key preferences.

       --personal-digest-preferences string
                 Set the list of personal digest  preferences  to
                 string,  this list should be a string similar to
                 the one printed by the  command  "pref"  in  the
                 edit  menu.   This  allows the user to factor in
                 their own preferred algorithms  when  algorithms
                 are  chosen  via recipient key preferences.  The
                 default value is "H2" indicating SHA-1.

       --personal-compress-preferences string
                 Set the list of personal compression preferences
                 to  string, this list should be a string similar
                 to the one printed by the command "pref" in  the
                 edit  menu.   This  allows the user to factor in
                 their own preferred algorithms  when  algorithms
                 are chosen via recipient key preferences.

       --default-preference-list string
                 Set  the  list of default preferences to string,
                 this list should be a string similar to the  one
                 printed  by the command "pref" in the edit menu.
                 This affects both key generation  and  "updpref"
                 in the edit menu.

How to specify a user ID
       There  are  different  ways to specify a user ID to GnuPG;
       here are some examples:




       234567C4

       0F34E556E

       01347A56A

       0xAB123456
                 Here the key ID is  given  in  the  usual  short
                 form.

       234AABBCC34567C4

       0F323456784E56EAB

       01AB3FED1347A5612

       0x234AABBCC34567C4
                 Here  the  key  ID  is given in the long form as
                 used by OpenPGP (you can get  the  long  key  ID
                 using the option --with-colons).

       1234343434343434C434343434343434

       123434343434343C3434343434343734349A3434

       0E12343434343434343434EAB3484343434343434

       0xE12343434343434343434EAB3484343434343434
                 The best way to specify a key ID is by using the
                 fingerprint of the key.  This avoids any ambigu
                 ities  in case that there are duplicated key IDs
                 (which are really rare for the long key IDs).

       =Heinrich Heine <heinrichh@uni-duesseldorf.de>
                 Using an exact to match string.  The equal  sign
                 indicates this.

       <heinrichh@uni-duesseldorf.de>
                 Using  the  email  address part which must match
                 exactly.  The left angle bracket indicates  this
                 email address mode.

       +Heinrich Heine duesseldorf
                 All  words  must  match exactly (not case sensi
                 tive) but can appear in any order  in  the  user
                 ID.  Words are any sequences of letters, digits,
                 the underscore and all  characters  with  bit  7
                 set.

       Heine

       *Heine    By case insensitive substring matching.  This is
                 the default mode but applications  may  want  to
                 explicitly indicate this by putting the asterisk
                 in front.

       Note that you can append an exclamation mark to key IDs or
       fingerprints.   This  flag  tells GnuPG to use exactly the
       given primary or secondary key and not to  try  to  figure
       out which secondary or primary key to use.


RETURN VALUE
       The  program  returns  0  if  everything was fine, 1 if at
       least a signature was bad, and other error codes for fatal
       errors.


EXAMPLES
       gpg -se -r Bob file
                 sign and encrypt for user Bob

       gpg --clearsign file
                 make a clear text signature

       gpg -sb  file
                 make a detached signature

       gpg --list-keys  user_ID
                 show keys

       gpg --fingerprint  user_ID
                 show fingerprint

       gpg --verify  pgpfile

       gpg --verify  sigfile [files]
                 Verify the signature of the file but do not out
                 put the  data.  The  second  form  is  used  for
                 detached   signatures,   where  sigfile  is  the
                 detached  signature  (either  ASCII  armored  of
                 binary) and [files] are the signed data; if this
                 is not given the name of the  file  holding  the
                 signed  data  is  constructed by cutting off the
                 extension (".asc" or ".sig") of  sigfile  or  by
                 asking the user for the filename.

ENVIRONMENT
       HOME      Used to locate the default home directory.

       GNUPGHOME If set directory used instead of "~/.gnupg".

       GPG_AGENT_INFO
                 Used  to locate the gpg-agent; only honored when
                 --use-agent is set.  The  value  consists  of  3
                 colon delimited fields: The first is the path to
                 the Unix Domain Socket, the second  the  PID  of
                 the  gpg-agent  and  the  protocol version which
                 should be set to 1.  When starting the gpg-agent
                 as described in its documentation, this variable
                 is set to the correct value.  The option  --gpg-
                 agent-info can be used to override it.

       http_proxy
                 Only  honored  when  the keyserver-option honor-
                 http-proxy is set.

FILES
       ~/.gnupg/secring.gpg
                 The secret keyring

       ~/.gnupg/secring.gpg.lock
                 and the lock file

       ~/.gnupg/pubring.gpg
                 The public keyring

       ~/.gnupg/pubring.gpg.lock
                 and the lock file

       ~/.gnupg/trustdb.gpg
                 The trust database

       ~/.gnupg/trustdb.gpg.lock
                 and the lock file

       ~/.gnupg/random_seed
                 used to preserve the internal random pool

       ~/.gnupg/gpg.conf
                 Default configuration file

       ~/.gnupg/options
                 Old style configuration  file;  only  used  when
                 gpg.conf is not found

       /usr[/local]/share/gnupg/options.skel
                 Skeleton options file

       /usr[/local]/lib/gnupg/
                 Default location for extensions

WARNINGS
       Use  a  *good* password for your user account and a *good*
       passphrase to protect your secret key.  This passphrase is
       the weakest part of the whole system.  Programs to do dic
       tionary attacks on your secret keyring are  very  easy  to
       write and so you should protect your "~/.gnupg/" directory
       very well.

       Keep in mind that, if this program is used over a  network
       (telnet), it is *very* easy to spy out your passphrase!

       If  you are going to verify detached signatures, make sure
       that the program knows about it;  either  be  giving  both
       filenames on the command line or using - to specify stdin.

INTEROPERABILITY WITH OTHER OPENPGP PROGRAMS
       GnuPG tries to be a very flexible  implementation  of  the
       OpenPGP standard.  In particular, GnuPG implements many of
       the  "optional"  parts  of  the  standard,  such  as   the
       RIPEMD/160  hash, and the ZLIB compression algorithms.  It
       is important to be aware that  not  all  OpenPGP  programs
       implement  these  optional  algorithms and that by forcing
       their use via the  --cipher-algo,  --digest-algo,  --cert-
       digest-algo,  or  --compress-algo  options in GnuPG, it is
       possible to create a perfectly valid OpenPGP message,  but
       one that cannot be read by the intended recipient.

       For  example,  as  of this writing, no version of official
       PGP supports the BLOWFISH cipher algorithm.   If  you  use
       it, no PGP user will be able to decrypt your message.  The
       same thing applies to the ZLIB compression algorithm.   By
       default,  GnuPG  uses  the OpenPGP preferences system that
       will always do the right thing and  create  messages  that
       are  usable by all recipients, regardless of which OpenPGP
       program they use.  Only override this safe default if  you
       know what you are doing.

       If  you  absolutely  must override the safe default, or if
       the preferences on a given key are invalid for  some  rea
       son,  you  are  far  better  off using the --pgp2, --pgp6,
       --pgp7, or --pgp8 options.  These options are safe as they
       do  not  force  any  particular algorithms in violation of
       OpenPGP, but rather reduce the available algorithms  to  a
       "PGP-safe" list.

BUGS
       On  many  systems  this  program  should  be  installed as
       setuid(root). This is  necessary  to  lock  memory  pages.
       Locking  memory  pages  prevents the operating system from
       writing memory pages to disk. If you get no  warning  mes
       sage  about insecure memory your operating system supports
       locking without being root. The program drops root  privi
       leges as soon as locked memory is allocated.



                                                           gpg(1)
