/*
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Free Software Foundation
 *
 * Author: Nikos Mavroyanopoulos
 *
 * This file is part of GNUTLS.
 *
 * The GNUTLS library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA
 *
 */

#ifdef ENABLE_SRP

typedef struct
{
  char *username;

  gnutls_datum_t salt;
  gnutls_datum_t v;
  gnutls_datum_t g;
  gnutls_datum_t n;
} SRP_PWD_ENTRY;

/* this is locally allocated. It should be freed using the provided function */
int _gnutls_srp_pwd_read_entry (gnutls_session_t state, char *username,
				SRP_PWD_ENTRY **);
void _gnutls_srp_entry_free (SRP_PWD_ENTRY * entry);
int _gnutls_sbase64_encode (uint8_t * data, size_t data_size,
			    uint8_t ** result);
int _gnutls_sbase64_decode (uint8_t * data, size_t data_size,
			    uint8_t ** result);

#endif /* ENABLE_SRP */
