/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.cipher;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class TestOfNistVectors
implements Testlet {
    protected static final String ECB_VK = "ecb_vk.txt";
    protected static final String ECB_VT = "ecb_vt.txt";
    protected static final String ECB_E_M = "ecb_e_m.txt";
    protected static final String ECB_D_M = "ecb_d_m.txt";
    protected static final String CBC_E_M = "cbc_e_m.txt";
    protected static final String CBC_D_M = "cbc_d_m.txt";
    protected static final int ENCRYPTION = 0;
    protected static final int DECRYPTION = 1;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    protected String algorithm;
    protected IBlockCipher cipher;
    protected HashMap attrib;
    protected URL ecb_vk;
    protected URL ecb_vt;
    protected URL ecb_e_m;
    protected URL ecb_d_m;
    protected URL cbc_e_m;
    protected URL cbc_d_m;
    protected int endianness;

    public TestOfNistVectors() {
        this("aes", 0);
    }

    public TestOfNistVectors(String algorithm, int endianness) {
        this(algorithm, 16, endianness);
    }

    public TestOfNistVectors(String algorithm, int blockSize, int endianness) {
        this.endianness = endianness;
        this.algorithm = algorithm;
        this.cipher = CipherFactory.getInstance((String)algorithm);
        this.attrib = new HashMap();
        this.attrib.put("gnu.crypto.cipher.block.size", new Integer(blockSize));
        this.attrib.put("gnu.crypto.cipher.key.material", new byte[this.cipher.defaultKeySize()]);
        try {
            this.cipher.init((Map)this.attrib);
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }

    protected byte[] stringToBytes(String s) {
        if (this.endianness == 0) {
            return Util.toBytesFromString((String)s);
        }
        return Util.toReversedBytesFromString((String)s);
    }

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfNistVectors(" + this.algorithm + ")");
        String path1 = "/tv/nist/" + this.cipher.name().toLowerCase() + "/";
        String path2 = "/tv/nist/" + this.algorithm.trim() + "/";
        String s = "Conformance(" + this.cipher.name() + "): ";
        try {
            this.ecb_vk = this.getClass().getResource(path1 + ECB_VK);
            if (this.ecb_vk == null) {
                this.ecb_vk = this.getClass().getResource(path2 + ECB_VK);
            }
            this.ecb_vt = this.getClass().getResource(path1 + ECB_VT);
            if (this.ecb_vt == null) {
                this.ecb_vt = this.getClass().getResource(path2 + ECB_VT);
            }
            this.ecb_e_m = this.getClass().getResource(path1 + ECB_E_M);
            if (this.ecb_e_m == null) {
                this.ecb_e_m = this.getClass().getResource(path2 + ECB_E_M);
            }
            this.ecb_d_m = this.getClass().getResource(path1 + ECB_D_M);
            if (this.ecb_d_m == null) {
                this.ecb_d_m = this.getClass().getResource(path2 + ECB_D_M);
            }
            this.cbc_e_m = this.getClass().getResource(path1 + CBC_E_M);
            if (this.cbc_e_m == null) {
                this.cbc_e_m = this.getClass().getResource(path2 + CBC_E_M);
            }
            this.cbc_d_m = this.getClass().getResource(path1 + CBC_D_M);
            if (this.cbc_d_m == null) {
                this.cbc_d_m = this.getClass().getResource(path2 + CBC_D_M);
            }
            if (this.ecb_vk != null) {
                this.KatTest(harness, this.ecb_vk.openStream());
            }
            if (this.ecb_vt != null) {
                this.KatTest(harness, this.ecb_vt.openStream());
            }
            if (this.ecb_e_m != null) {
                this.MCTestECB(harness, this.ecb_e_m.openStream(), 0);
            }
            if (this.ecb_d_m != null) {
                this.MCTestECB(harness, this.ecb_d_m.openStream(), 1);
            }
            if (this.cbc_e_m != null) {
                this.MCTestCBC(harness, this.cbc_e_m.openStream(), 0);
            }
            if (this.cbc_d_m != null) {
                this.MCTestCBC(harness, this.cbc_d_m.openStream(), 1);
            }
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail(s + x.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void KatTest(TestHarness harness, InputStream tvIn) throws Exception {
        String line;
        LineNumberReader in = new LineNumberReader(new InputStreamReader(tvIn));
        byte[] key = null;
        byte[] pt = null;
        byte[] ct = new byte[this.cipher.currentBlockSize()];
        byte[] ect = null;
        while ((line = in.readLine()) != null) {
            void var4_8;
            if (var4_8.startsWith("KEYSIZE=")) {
                int ks = Integer.parseInt(var4_8.substring(var4_8.indexOf(61) + 1));
                key = new byte[ks / 8];
                continue;
            }
            if (var4_8.startsWith("PT=")) {
                pt = this.stringToBytes(var4_8.substring(var4_8.indexOf(61) + 1));
                continue;
            }
            if (var4_8.startsWith("KEY=")) {
                key = this.stringToBytes(var4_8.substring(var4_8.indexOf(61) + 1));
                this.attrib.put("gnu.crypto.cipher.key.material", key);
                continue;
            }
            if (!var4_8.startsWith("CT=")) continue;
            ect = this.stringToBytes(var4_8.substring(var4_8.indexOf(61) + 1));
            this.cipher.reset();
            this.cipher.init((Map)this.attrib);
            this.cipher.encryptBlock(pt, 0, ct, 0);
            harness.check(Util.areEqual((byte[])ct, (byte[])ect));
        }
        in.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void MCTestECB(TestHarness harness, InputStream tvIn, int mode) throws Exception {
        String line;
        LineNumberReader in = new LineNumberReader(new InputStreamReader(tvIn));
        byte[] key = new byte[this.cipher.defaultKeySize()];
        byte[] pt = new byte[this.cipher.currentBlockSize()];
        byte[] ct = new byte[this.cipher.currentBlockSize()];
        byte[] et = new byte[this.cipher.currentBlockSize()];
        while ((line = in.readLine()) != null) {
            int i;
            void var5_9;
            if (var5_9.startsWith("KEYSIZE=")) {
                int ks = Integer.parseInt(var5_9.substring(var5_9.indexOf(61) + 1));
                key = new byte[ks / 8];
                continue;
            }
            if (var5_9.startsWith("PT=")) {
                if (mode == 1) {
                    et = this.stringToBytes(var5_9.substring(var5_9.indexOf(61) + 1));
                    this.cipher.reset();
                    this.cipher.init((Map)this.attrib);
                    i = 0;
                    while (i < 10000) {
                        this.cipher.decryptBlock(ct, 0, pt, 0);
                        System.arraycopy(pt, 0, ct, 0, pt.length);
                        ++i;
                    }
                    harness.check(Util.areEqual((byte[])pt, (byte[])et));
                    continue;
                }
                pt = this.stringToBytes(var5_9.substring(var5_9.indexOf(61) + 1));
                continue;
            }
            if (var5_9.startsWith("KEY=")) {
                key = this.stringToBytes(var5_9.substring(var5_9.indexOf(61) + 1));
                this.attrib.put("gnu.crypto.cipher.key.material", key);
                continue;
            }
            if (!var5_9.startsWith("CT=")) continue;
            if (mode == 0) {
                et = this.stringToBytes(var5_9.substring(var5_9.indexOf(61) + 1));
                this.cipher.reset();
                this.cipher.init((Map)this.attrib);
                i = 0;
                while (i < 10000) {
                    this.cipher.encryptBlock(pt, 0, ct, 0);
                    System.arraycopy(ct, 0, pt, 0, ct.length);
                    ++i;
                }
                harness.check(Util.areEqual((byte[])ct, (byte[])et));
                continue;
            }
            ct = this.stringToBytes(var5_9.substring(var5_9.indexOf(61) + 1));
        }
        in.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void MCTestCBC(TestHarness harness, InputStream tvIn, int mode) throws Exception {
        String line;
        LineNumberReader in = new LineNumberReader(new InputStreamReader(tvIn));
        byte[] key = new byte[this.cipher.defaultKeySize()];
        byte[] pt = new byte[this.cipher.currentBlockSize()];
        byte[] ct = new byte[this.cipher.currentBlockSize()];
        byte[] et = new byte[this.cipher.currentBlockSize()];
        byte[] last = new byte[this.cipher.currentBlockSize()];
        byte[] iv = new byte[this.cipher.currentBlockSize()];
        this.cipher.reset();
        while ((line = in.readLine()) != null) {
            int j;
            int i;
            void var5_11;
            if (var5_11.startsWith("KEYSIZE=")) {
                int i2;
                int ks = Integer.parseInt(var5_11.substring(var5_11.indexOf(61) + 1));
                key = new byte[ks / 8];
                if (mode == 0) {
                    i2 = 0;
                    while (i2 < ct.length) {
                        ct[i2] = 0;
                        ++i2;
                    }
                    continue;
                }
                i2 = 0;
                while (i2 < pt.length) {
                    pt[i2] = 0;
                    ++i2;
                }
                continue;
            }
            if (var5_11.startsWith("PT=")) {
                if (mode == 1) {
                    et = this.stringToBytes(var5_11.substring(var5_11.indexOf(61) + 1));
                    this.cipher.reset();
                    this.cipher.init((Map)this.attrib);
                    i = 0;
                    while (i < 10000) {
                        this.cipher.decryptBlock(ct, 0, pt, 0);
                        j = 0;
                        while (j < pt.length) {
                            int n = j;
                            pt[n] = (byte)(pt[n] ^ iv[j]);
                            ++j;
                        }
                        System.arraycopy(ct, 0, iv, 0, ct.length);
                        System.arraycopy(pt, 0, ct, 0, pt.length);
                        ++i;
                    }
                    harness.check(Util.areEqual((byte[])pt, (byte[])et));
                    continue;
                }
                pt = this.stringToBytes(var5_11.substring(var5_11.indexOf(61) + 1));
                continue;
            }
            if (var5_11.startsWith("KEY=")) {
                key = this.stringToBytes(var5_11.substring(var5_11.indexOf(61) + 1));
                this.attrib.put("gnu.crypto.cipher.key.material", key);
                continue;
            }
            if (var5_11.startsWith("CT=")) {
                if (mode == 0) {
                    et = this.stringToBytes(var5_11.substring(var5_11.indexOf(61) + 1));
                    this.cipher.reset();
                    this.cipher.init((Map)this.attrib);
                    i = 0;
                    while (i < 10000) {
                        j = 0;
                        while (j < pt.length) {
                            int n = j;
                            pt[n] = (byte)(pt[n] ^ iv[j]);
                            ++j;
                        }
                        System.arraycopy(ct, 0, last, 0, ct.length);
                        this.cipher.encryptBlock(pt, 0, ct, 0);
                        System.arraycopy(ct, 0, iv, 0, ct.length);
                        System.arraycopy(last, 0, pt, 0, last.length);
                        ++i;
                    }
                    harness.check(Util.areEqual((byte[])ct, (byte[])et));
                    continue;
                }
                ct = this.stringToBytes(var5_11.substring(var5_11.indexOf(61) + 1));
                continue;
            }
            if (!var5_11.startsWith("IV=")) continue;
            iv = this.stringToBytes(var5_11.substring(var5_11.indexOf(61) + 1));
        }
        in.close();
    }
}

