/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet;

import gnu.testlet.ResourceNotFoundException;
import java.io.InputStream;
import java.io.Reader;

public abstract class TestHarness {
    public abstract void check(boolean var1);

    public void check(Object result, Object expected) {
        boolean ok = result == null ? expected == null : result.equals(expected);
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(double result, double expected) {
        boolean ok = result == expected ? result != 0.0 || 1.0 / result == 1.0 / expected : result != result && expected != expected;
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(long result, long expected) {
        boolean ok = result == expected;
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(int result, int expected) {
        boolean ok = result == expected;
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(boolean result, String name) {
        this.checkPoint(name);
        this.check(result);
    }

    public void check(Object result, Object expected, String name) {
        this.checkPoint(name);
        this.check(result, expected);
    }

    public void check(int result, int expected, String name) {
        this.checkPoint(name);
        this.check(result, expected);
    }

    public void check(long result, long expected, String name) {
        this.checkPoint(name);
        this.check(result, expected);
    }

    public void check(double result, double expected, String name) {
        this.checkPoint(name);
        this.check(result, expected);
    }

    public void fail(String name) {
        this.checkPoint(name);
        this.check(false);
    }

    public abstract Reader getResourceReader(String var1) throws ResourceNotFoundException;

    public abstract InputStream getResourceStream(String var1) throws ResourceNotFoundException;

    public abstract String getTempDirectory();

    public abstract void checkPoint(String var1);

    public abstract void verbose(String var1);

    public abstract void debug(String var1);

    public abstract void debug(String var1, boolean var2);

    public abstract void debug(Throwable var1);

    public abstract void debug(Object[] var1, String var2);
}

