/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.dss;

import gnu.crypto.sig.IKeyPairCodec;
import gnu.crypto.sig.dss.DSSPrivateKey;
import gnu.crypto.sig.dss.DSSPublicKey;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class DSSKeyPairRawCodec
implements IKeyPairCodec {
    public int getFormatID() {
        return 1;
    }

    public byte[] encodePublicKey(PublicKey key) {
        if (!(key instanceof DSSPublicKey)) {
            throw new IllegalArgumentException("key");
        }
        DSSPublicKey dssKey = (DSSPublicKey)key;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(71);
        baos.write(78);
        baos.write(85);
        baos.write(65);
        baos.write(1);
        byte[] buffer = dssKey.getParams().getP().toByteArray();
        int length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        buffer = dssKey.getParams().getQ().toByteArray();
        length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        buffer = dssKey.getParams().getG().toByteArray();
        length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        buffer = dssKey.getY().toByteArray();
        length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        return baos.toByteArray();
    }

    public PublicKey decodePublicKey(byte[] k) {
        if (k[0] != 71 || k[1] != 78 || k[2] != 85 || k[3] != 65) {
            throw new IllegalArgumentException("magic");
        }
        if (k[4] != 1) {
            throw new IllegalArgumentException("version");
        }
        int ndx = 5;
        int length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        byte[] buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger p = new BigInteger(1, buffer);
        length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger q = new BigInteger(1, buffer);
        length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger g = new BigInteger(1, buffer);
        length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger y = new BigInteger(1, buffer);
        return new DSSPublicKey(p, q, g, y);
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        if (!(key instanceof DSSPrivateKey)) {
            throw new IllegalArgumentException("key");
        }
        DSSPrivateKey dssKey = (DSSPrivateKey)key;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(71);
        baos.write(78);
        baos.write(85);
        baos.write(97);
        baos.write(1);
        byte[] buffer = dssKey.getParams().getP().toByteArray();
        int length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        buffer = dssKey.getParams().getQ().toByteArray();
        length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        buffer = dssKey.getParams().getG().toByteArray();
        length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        buffer = dssKey.getX().toByteArray();
        length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        return baos.toByteArray();
    }

    public PrivateKey decodePrivateKey(byte[] k) {
        if (k[0] != 71 || k[1] != 78 || k[2] != 85 || k[3] != 97) {
            throw new IllegalArgumentException("magic");
        }
        if (k[4] != 1) {
            throw new IllegalArgumentException("version");
        }
        int ndx = 5;
        int length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        byte[] buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger p = new BigInteger(1, buffer);
        length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger q = new BigInteger(1, buffer);
        length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger g = new BigInteger(1, buffer);
        length = k[ndx++] << 24 | (k[ndx++] & 0xFF) << 16 | (k[ndx++] & 0xFF) << 8 | k[ndx++] & 0xFF;
        buffer = new byte[length];
        System.arraycopy(k, ndx, buffer, 0, length);
        ndx += length;
        BigInteger x = new BigInteger(1, buffer);
        return new DSSPrivateKey(p, q, g, x);
    }
}

