/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.jce;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.hash.HashFactory;
import gnu.crypto.sig.KeyPairGeneratorFactory;
import gnu.crypto.sig.SignatureFactory;
import java.security.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class GnuCrypto
extends Provider {
    public GnuCrypto() {
        super("GNU-CRYPTO", 1.0, "GNU Crypto JCE Provider");
        this.put("MessageDigest.MD4", "gnu.crypto.jce.MD4Spi");
        this.put("MessageDigest.MD4 ImplementedIn", "Software");
        this.put("MessageDigest.MD5", "gnu.crypto.jce.MD5Spi");
        this.put("MessageDigest.MD5 ImplementedIn", "Software");
        this.put("MessageDigest.RIPEMD128", "gnu.crypto.jce.RipeMD128Spi");
        this.put("MessageDigest.RIPEMD128 ImplementedIn", "Software");
        this.put("MessageDigest.RIPEMD160", "gnu.crypto.jce.RipeMD160Spi");
        this.put("MessageDigest.RIPEMD160 ImplementedIn", "Software");
        this.put("MessageDigest.SHA-160", "gnu.crypto.jce.Sha160Spi");
        this.put("MessageDigest.SHA-160 ImplementedIn", "Software");
        this.put("MessageDigest.WHIRLPOOL", "gnu.crypto.jce.WhirlpoolSpi");
        this.put("MessageDigest.WHIRLPOOL ImplementedIn", "Software");
        this.put("SecureRandom.MD4PRNG", "gnu.crypto.jce.MD4RandomSpi");
        this.put("SecureRandom.MD4PRNG ImplementedIn", "Software");
        this.put("SecureRandom.MD5PRNG", "gnu.crypto.jce.MD5RandomSpi");
        this.put("SecureRandom.MD5PRNG ImplementedIn", "Software");
        this.put("SecureRandom.RIPEMD128PRNG", "gnu.crypto.jce.RipeMD128RandomSpi");
        this.put("SecureRandom.RIPEMD128PRNG ImplementedIn", "Software");
        this.put("SecureRandom.RIPEMD160PRNG", "gnu.crypto.jce.RipeMD160RandomSpi");
        this.put("SecureRandom.RIPEMD160PRNG ImplementedIn", "Software");
        this.put("SecureRandom.SHA-160PRNG", "gnu.crypto.jce.Sha160RandomSpi");
        this.put("SecureRandom.SHA-160PRNG ImplementedIn", "Software");
        this.put("SecureRandom.WHIRLPOOLPRNG", "gnu.crypto.jce.WhirlpoolRandomSpi");
        this.put("SecureRandom.WHIRLPOOLPRNG ImplementedIn", "Software");
        this.put("SecureRandom.ICM", "gnu.crypto.jce.ICMRandomSpi");
        this.put("SecureRandom.ICM ImplementedIn", "Software");
        this.put("SecureRandom.UMAC-KDF", "gnu.crypto.jce.UMacRandomSpi");
        this.put("SecureRandom.UMAC-KDF ImplementedIn", "Software");
        this.put("KeyPairGenerator.DSS", "gnu.crypto.jce.DSSKeyPairGeneratorSpi");
        this.put("KeyPairGenerator.DSS KeySize", "1024");
        this.put("KeyPairGenerator.DSS ImplementedIn", "Software");
        this.put("KeyPairGenerator.RSA", "gnu.crypto.jce.RSAKeyPairGeneratorSpi");
        this.put("KeyPairGenerator.RSA KeySize", "1024");
        this.put("KeyPairGenerator.RSA ImplementedIn", "Software");
        this.put("Signature.DSS/RAW", "gnu.crypto.jce.DSSRawSignatureSpi");
        this.put("Signature.DSS/RAW KeySize", "1024");
        this.put("Signature.DSS/RAW ImplementedIn", "Software");
        this.put("Signature.RSA-PSS/RAW", "gnu.crypto.jce.RSAPSSRawSignatureSpi");
        this.put("Signature.RSA-PSS/RAW KeySize", "1024");
        this.put("Signature.RSA-PSS/RAW ImplementedIn", "Software");
        this.put("Cipher.ANUBIS", "gnu.crypto.jce.AnubisSpi");
        this.put("Cipher.KHAZAD", "gnu.crypto.jce.KhazadSpi");
        this.put("Cipher.NULL", "gnu.crypto.jce.NullCipherSpi");
        this.put("Cipher.AES", "gnu.crypto.jce.RijndaelSpi");
        this.put("Cipher.RIJNDAEL", "gnu.crypto.jce.RijndaelSpi");
        this.put("Cipher.SQUARE", "gnu.crypto.jce.SquareSpi");
        this.put("Cipher.TWOFISH", "gnu.crypto.jce.TwofishSpi");
        this.put("Alg.Alias.MessageDigest.SHS", "SHA-160");
        this.put("Alg.Alias.MessageDigest.SHA", "SHA-160");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-160");
        this.put("Alg.Alias.MessageDigest.SHA-1", "SHA-160");
        this.put("Alg.Alias.MessageDigest.RIPEMD-160", "RIPEMD160");
        this.put("Alg.Alias.MessageDigest.RIPEMD-128", "RIPEMD128");
        this.put("Alg.Alias.SecureRandom.SHA-1PRNG", "SHA-160PRNG");
        this.put("Alg.Alias.SecureRandom.SHA1PRNG", "SHA-160PRNG");
        this.put("Alg.Alias.SecureRandom.SHAPRNG", "SHA-160PRNG");
        this.put("Alg.Alias.KeyPairGenerator.DSA", "DSS");
        this.put("Alg.Alias.Signature.DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHAwithDSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA1withDSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA160withDSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA1/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA-1/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA-160/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.DSAwithSHA", "DSS/RAW");
        this.put("Alg.Alias.Signature.DSAwithSHA1", "DSS/RAW");
        this.put("Alg.Alias.Signature.DSAwithSHA160", "DSS/RAW");
        this.put("Alg.Alias.Signature.RSA-PSS", "RSA-PSS/RAW");
        this.put("Alg.Alias.Signature.RSAPSS", "RSA-PSS/RAW");
    }

    public static final Set getMessageDigestNames() {
        return HashFactory.getNames();
    }

    public static final Set getSecureRandomNames() {
        HashSet<String> result = new HashSet<String>();
        Set md = HashFactory.getNames();
        Iterator it = md.iterator();
        while (it.hasNext()) {
            result.add(((String)it.next()).toUpperCase() + "PRNG");
        }
        result.add("icm".toUpperCase());
        result.add("umac-kdf".toUpperCase());
        return Collections.unmodifiableSet(result);
    }

    public static final Set getKeyPairGeneratorNames() {
        return KeyPairGeneratorFactory.getNames();
    }

    public static final Set getSignatureNames() {
        return SignatureFactory.getNames();
    }

    public static final Set getCipherNames() {
        return CipherFactory.getNames();
    }
}

