/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mode;

import gnu.crypto.Registry;
import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.mode.BaseMode;
import gnu.crypto.mode.CTR;
import gnu.crypto.mode.ECB;
import gnu.crypto.mode.ICM;
import gnu.crypto.mode.IMode;
import gnu.crypto.mode.OFB;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModeFactory
implements Registry {
    private ModeFactory() {
    }

    public static IMode getInstance(String mode, String cipher, int cipherBlockSize) {
        if (mode == null || cipher == null) {
            return null;
        }
        mode = mode.trim();
        IBlockCipher cipherImpl = CipherFactory.getInstance(cipher = cipher.trim());
        if (cipherImpl == null) {
            return null;
        }
        return ModeFactory.getInstance(mode, cipherImpl, cipherBlockSize);
    }

    public static IMode getInstance(String mode, IBlockCipher cipher, int cipherBlockSize) {
        boolean ok = false;
        Iterator it = cipher.blockSizes();
        while (it.hasNext()) {
            boolean bl = ok = cipherBlockSize == (Integer)it.next();
            if (ok) break;
        }
        if (!ok) {
            throw new IllegalArgumentException("cipherBlockSize");
        }
        BaseMode result = null;
        if (mode.equalsIgnoreCase("ecb")) {
            result = new ECB(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("ctr")) {
            result = new CTR(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("icm")) {
            result = new ICM(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("ofb")) {
            result = new OFB(cipher, cipherBlockSize);
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    public static final Set getNames() {
        HashSet<String> hs = new HashSet<String>();
        hs.add("ecb");
        hs.add("ctr");
        hs.add("icm");
        hs.add("ofb");
        return Collections.unmodifiableSet(hs);
    }
}

