/*
 * gaia - opensource 3D interface to the planet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "KeyholeConnection.h"

KeyholeConnection::KeyholeConnection() {
	if ((m_GEFetch = gefetch_init()) == 0)
		throw Exception("gefetch_init() failed");
}

KeyholeConnection::~KeyholeConnection() {
	if (m_GEFetch)
		gefetch_cleanup(m_GEFetch);
}

void KeyholeConnection::Process(TilePtr tile) {
	gefetch_error res;
	if ((res = gefetch_fetch_image(m_GEFetch, tile->GetX(), tile->GetY(), tile->GetLevel())) == GEFETCH_NOT_FOUND) {
		tile->Null();
		return;
	} else if (res != GEFETCH_OK) {
		sleep(1);	/* don't do a DOS in case of any problems */
		throw Exception("gefetch_fetch_image() failed");
	}

	RawBuffer *buf = new RawBuffer(gefetch_get_data_ptr(m_GEFetch), gefetch_get_data_size(m_GEFetch));

	try {
		tile->Load(buf, m_pSaveStorage != 0);
	} catch (...) {
		delete buf;
		throw;
	}
}
