/*
 * gaia - opensource 3D interface to the planet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gefetch_internal.h"

#define DEFAULT_URL "http://kh.google.com"
#define DEFAULT_MAX_METASIZE 1*1024*1024

/**
 * Initialize gefetch library
 */
gefetch *gefetch_init() {
	gefetch *handle;

	/* allocate structure */
	if ((handle = (gefetch*)malloc(sizeof(gefetch))) == 0)
		return 0;

	memset(handle, 0, sizeof(gefetch));

	/* init certain fields */
	handle->maxmetasize = DEFAULT_MAX_METASIZE;

	char *url = DEFAULT_URL;
	if ((handle->url = malloc(strlen(url)+1)) == 0) {
		gefetch_cleanup(handle);
		return 0;
	}

	strcpy(handle->url, url);

	if ((handle->curl = curl_easy_init()) == 0) {
		gefetch_cleanup(handle);
		return 0;
	}

	return handle;
}

/**
 * Destroy gefetch handle and free all data used by library
 */
void gefetch_cleanup(gefetch *handle) {
	if (handle->url)
		free(handle->url);

	if (handle->sid)
		free(handle->sid);

	if (handle->curl)
		curl_easy_cleanup(handle->curl);

	if (handle->curlheaders)
		curl_slist_free_all(handle->curlheaders);

	if (handle->currentdata)
		free(handle->currentdata);

	if (handle->dbrootdata)
		free(handle->dbrootdata);

	while (handle->firstmeta) {
		gefetch_meta *tmp = handle->firstmeta;
		handle->firstmeta = handle->firstmeta->next;
		free(tmp);
	}

	free(handle);
}

/**
 * Set max size of metadata catalogue
 *
 * @param size maximum size in bytes
 */
gefetch_error gefetch_set_max_metasize(gefetch *handle, size_t size) {
	handle->maxmetasize = size;
	gefetch_remove_extra_meta(handle, 0);

	return GEFETCH_OK;
}

/**
 * Set different address of Google server
 *
 * @url new address (like http://kh.google.com)
 */
gefetch_error gefetch_set_url(gefetch *handle, char *url) {
	char *newurl = handle->url;
	if (strlen(handle->url) < strlen(url))
		if ((newurl = realloc(handle->url, strlen(url) + 1)) == 0)
			return GEFETCH_NOMEM;

	strcpy(newurl, url);

	handle->url = newurl;

	return GEFETCH_OK;
}
