/*
 * gaia - opensource 3D interface to the planet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gefetch_internal.h"

/**
 * Fetch single image from Google server
 *
 * @param x x coordinate of image [0..(2^level-1)]
 * @param y y coordinate of image [0..(2^level-1)]
 * @param level level of image [0..]
 */
gefetch_error gefetch_fetch_image(gefetch *handle, int x, int y, int level) {
	char index[32];
	gefetch_coords_to_string(x, y, level, index, sizeof(index));

	/* get node */
	gefetch_error res;
	gefetch_meta *meta;
	gefetch_meta_entry *entry;

	if ((res = gefetch_find_meta(handle, x, y, level, &meta)) != GEFETCH_OK)
		return res;

	if ((res = gefetch_parse_meta(handle, meta, x, y, level, &entry)) != GEFETCH_OK)
		return res;

	int node = entry->imagenode;

	/* form full url */
	char urlbuf[1024];
	if (snprintf(urlbuf, sizeof(urlbuf), "%s/flatfile?f1-%s-i.%d", handle->url, index, node) >= sizeof(urlbuf))
		return GEFETCH_SMALL_BUFFER;

	/* fetch */
	return gefetch_fetch(handle, urlbuf);
}
