/*
 * gaia - opensource 3D interface to the planet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __GEFETCH_H__
#define __GEFETCH_H__

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

/* error codes */
typedef enum {
	/* no error */
	GEFETCH_OK,

	/* no memory */
	GEFETCH_NOMEM,

	/* curl init failed */
	GEFETCH_CURL_INIT_FAILED,

	/* curl perform failed */
	GEFETCH_CURL_PERFORM_FAILED,

	/* curl perform failed */
	GEFETCH_AUTH_FAILED,

	/* google returned corrupt data */
	GEFETCH_CORRUPT_DATA,

	/* constant size buffer too small for data */
	GEFETCH_SMALL_BUFFER,

	/* unable to fetch data requested */
	GEFETCH_FETCH_FAILED,

	/* data requested does not exist */
	GEFETCH_NOT_FOUND,
} gefetch_error;

typedef struct gefetch *gefetch_t;

/* init/cleanup */
gefetch_t	gefetch_init();
void		gefetch_cleanup(gefetch_t handle);

/* options */
gefetch_error	gefetch_set_max_metasize(gefetch_t handle, size_t size);
gefetch_error	gefetch_set_url(gefetch_t handle, char *url);

/* fetch specific types of data */
gefetch_error	gefetch_fetch_uri(gefetch_t handle, char *uri);
gefetch_error	gefetch_fetch_image(gefetch_t handle, int x, int y, int level);

/* retrieve data from library */
size_t		gefetch_get_data_size(gefetch_t handle);
void		*gefetch_get_data_ptr(gefetch_t handle);

#ifdef __cplusplus
}
#endif

#endif
