unit UninstSharedFileDlg;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  "Remove Shared File?" dialog displayed by uninstaller
}

interface

uses
  Windows;

function ExecuteRemoveSharedFileDlg (const OwnerWnd: HWND; const Filename: String;
  var AAll: Boolean): Boolean;

implementation

{$R *.RES}

uses
  Messages, SysUtils, Msgs, MsgIDs, WinDlgs, CmnFunc2;

const
  IDC_BODYLABEL                 = 1001;
  IDC_FILENAMELABEL             = 1002;
  IDC_FILENAMEEDIT              = 1003;
  IDC_LOCATIONLABEL             = 1004;
  IDC_LOCATIONEDIT              = 1005;
  IDC_YESTOALL                  = 1006;
  IDC_NOTOALL                   = 1007;

  DlgDataProp = 'DlgDataProp';

type
  PDlgData = ^TDlgData;
  TDlgData = record
    Filename: String;
    Yes, All: Boolean;
  end;

function DialogProc (hwndDlg: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
stdcall;

  procedure SetTextFromMsg (const ItemId: Integer; const Msg: TSetupMessageID);
  begin
    SetDlgItemText (hwndDlg, ItemId, PChar(SetupMessages[Msg]));
  end;

begin
  Result := False;
  case uMsg of
    WM_INITDIALOG: begin
        SetProp (hwndDlg, DlgDataProp, THandle(lParam));
        SetWindowText (hwndDlg, PChar(SetupMessages[msgConfirmDeleteSharedFileTitle]));
        SetTextFromMsg (IDC_BODYLABEL, msgConfirmDeleteSharedFile2);
        SetTextFromMsg (IDC_FILENAMELABEL, msgSharedFileNameLabel);
        SetDlgItemText (hwndDlg, IDC_FILENAMEEDIT,
          PChar(ExtractFileName(PDlgData(lParam).Filename)));
        SetTextFromMsg (IDC_LOCATIONLABEL, msgSharedFileLocationLabel);
        SetDlgItemText (hwndDlg, IDC_LOCATIONEDIT,
          PChar(RemoveBackslashUnlessRoot(ExtractFilePath(PDlgData(lParam).Filename))));
        SetTextFromMsg (IDYES, msgButtonYes);
        SetTextFromMsg (IDC_YESTOALL, msgButtonYesToAll);
        SetTextFromMsg (IDNO, msgButtonNo);
        SetTextFromMsg (IDC_NOTOALL, msgButtonNoToAll);
        { Kill the close button }
        DeleteMenu (GetSystemMenu(hwndDlg, False), SC_CLOSE, MF_BYCOMMAND);
        Result := True;
      end;
    WM_DESTROY:
      RemoveProp (hwndDlg, DlgDataProp);
    WM_COMMAND:
      if LongRec(wParam).Hi = BN_CLICKED then begin
        case LongRec(wParam).Lo of
          IDYES, IDC_YESTOALL, IDNO, IDC_NOTOALL: begin
            with PDlgData(GetProp(hwndDlg, DlgDataProp))^ do begin
              Yes := (LongRec(wParam).Lo = IDYES) or (LongRec(wParam).Lo = IDC_YESTOALL);
              All := (LongRec(wParam).Lo = IDC_YESTOALL) or (LongRec(wParam).Lo = IDC_NOTOALL);
            end;
            EndDialog (hwndDlg, LongRec(wParam).Lo);
          end;
        end;
      end;
  end;
end;

function ExecuteRemoveSharedFileDlg (const OwnerWnd: HWND; const Filename: String;
  var AAll: Boolean): Boolean;
var
  Data: TDlgData;
begin
  Data.Filename := Filename;
  Data.Yes := False;
  Data.All := False;
  DialogBoxWithFont (HInstance, 'REMOVESHAREDFILEDLG', OwnerWnd, @DialogProc,
    LPARAM(@Data));
  Result := Data.Yes;
  AAll := Data.All;
end;

end.

